	.TITLE	GENCAR

;	--------------------------------------
;		(C) 1986 - Daniel Roux
;	--------------------------------------


; Date		Rev	Amliorations
; -------------------------------------------------------------------------------------
; 05.07.89	3.1	plante si BGCDEMIX/Y corrige
; 23.06.89	3.0	petites amliorations (DR)
; 		2.x	largeur > 32 ok et optimisation (FJ)
; 		1.x	premire version (DR)


	.PROC	M68000 		; mnmonics CALM 3
	.BASE	10.		; base 10 par dfaut
	.LISTHEX		; listing en hexadcima


	.REV	3,1
	.IDENT	"(C)  Daniel ROUX et EPSITEC-system sa"

;	.REF	SM8		; df diverses
;	.REF	NTREL		; df noyau temps rel
;	.REF	GESMEM		; df gestionnaire de mmoire
;	.REF	FOS		; df file operating system
;	.REF	LIB		; df librairie
;	.REF	DRIVERS		; df drivers
	.REF	DOLIB		; df restart LIB
	.REF	SMAKY
	.REF	GENCAR		; df gencar

	.CHAP	GCHEADER




; Constantes
; ----------

NBDITAL	=	3		; dcale l'italique toutes les 3 lignes

BGCICO	=	12		; icne si D3 in = 'I


; Variables
; ---------

	.LOC	0
ONBCAR:	.BLK.16	1		; nb de caractres (1..128)
OFLNBCI:.BLK.8	1		; flags nbr car impair
OFLWI:	.BLK.8	1		; flags largeur en byte impaire
ODEBNGC:.BLK.32	1		; dbut des matrices du nouveau gencar
LGVAR:



; En-tte du module LIB
; ---------------------

	.LOC	0
	.16	GENCAR_FIRST	; code du premier appel
	.16	GENCAR_LAST	; code du dernier appel
	.8	0		; nombre d'installations
	.FILL.8	(OHLREV-.),0
	.8	3,1		; rvision.version
	.16	0,END_GENCAR	; longueur
	.16	(PATHLIB&H'FFFF0000)/H'10000 ; pattern de dbut
	.16	PATHLIB&H'FFFF	; pattern de dbut
	.FILL.8	(OHLNAM-.),0
	.ASCII	"GENCAR"	; nom du module
	.FILL.8	(LGHLIB-.),0

	.16	_GENCAR_CREATE




; Codes des appels
; ----------------



;---------------\\
; _GENCAR_CREATE >
;===============/

; Cre un gencar par soft.
; Les paramtres indiqus avec (*) ne sont pas utiliss.

; in	D0.B	fonte gencar de base (*)
;	D1.B	style gencar de base (*)
;	D2.B	taille gencar de base
;	A4.L	^gencar de base
;	D3.B	fonte
;	D4.24	style soft (bits)
;	D5.B	taille voulue en sortie (sert  savoir si double BGCDOUB, ou rduit BGCDEMIX&Y)
; out	A4.L	^gencar construit
;	D7.W	erreur
; mod	D7.W, A4.L

_GENCAR_CREATE:
	PUSHM.32 D0..D5|A0..A3|A5|A6

	PUSHM.32 D1|D4|A4
	MOVE.32	#LGVAR,D4
	MOVE.16	#MTYPCP,D1
	GESMEM	?GETMEM		; demande mmoire pour les variables
	MOVE.32	A4,A6		; A6 <-- ^variables
01$:
	CLR.8	{A4+}
	DEC.32	D4
	JUMP,NE	01$
	POPM.32	D1|D4|A4
	TEST.16	D7
	JUMP,NE 95$

	CLR.32	D0
	MOVE.32	D4,D0		; D0 <-- style soft

	PUSH.16 D2		; gre les rductions

	TEST.32	D0:#BGCDEMIX	; si BGCDEMIX ou BGCDEMIY, on ignore la taille
	JUMP,BC	R8^L1$
	TEST.32	D0:#BGCLARG
	JUMP,BC	R8^L1$
	AND.32	#-1-2**BGCDEMIX-2**BGCLARG,D0 ; doubler et rduire en largeur = rien !
L1$:
	TEST.32	D0:#BGCDEMIY
	JUMP,BS	R8^L3$

	SR.8	#1,D2		; taille de base / 2
	COMP.8	D5,D2		; taille voulue
	JUMP,NE	R8^L3$
	TSET.32	D0:#BGCDEMIY	; rduit
	TCLR.32	D0:#BGCLARG	; on veut rduire, seulement en hauteur ?
	JUMP,BS	R8^L3$
	TSET.32	D0:#BGCDEMIX	; en hauteur et largeur
L3$:
	POP.16	D2

	SR.8	#1,D5		; taille voulue / 2
	COMP.8	D5,D2		; gencar de base 2x plus petit ?
	JUMP,NE R8^02$		; non => 02$
	TSET.32	D0:#BGCDOUB	; oui => hardi les gars, y'faut doubler
02$:
	TSET.32	D0:#BGCPPL	; D0 <-- pas plus grand
	JUMP,BS R8^04$
	COMP.8	#'D,D3		; fonte Dfaut ?
	JUMP,EQ R8^04$
	COMP.8	#'Q,D3		; fonte Qualit ?
	JUMP,EQ R8^04$
	TCLR.32	D0:#BGCPPL	; D0 <-- on peut agrandir
	JUMP	R8^05$
04$:
	AND.32	#-1-2**BGCDOUB-2**BGCDEMIY-2**BGCDEMIX,D0 ; on ne rapetisse pas les gencar imprimante
05$:
	COMP.8	#'I,D3
	JUMP,NE	R8^06$
	TSET.32	D0:#BGCICO
06$:
	MOVE.16	{A4}+OGCMWI,D2	; D2 <-- largeur actuelle (en points)
	MOVE.16	{A4}+OGCMHD,D3	; D3 <-- hauteur actuelle (en points)

	TEST.32	D0:#BGCDEMIX
	JUMP,BC	R8^L10$
	CALL	DGCDIVL
L10$:
	TEST.32	D0:#BGCDEMIY
	JUMP,BC	R8^L20$
	CALL	DGCDIVHT
L20$:
	TEST.32	D0:#BGCDOUB
	JUMP,BC R8^10$
	CALL	DGCDOUBLE	; calcul dimensions pour double grandeur
10$:
	TEST.32	D0:#BGCLARG
	JUMP,BC R8^12$
	CALL	DGCLARGE	; calcul dimensions pour double largeur
12$:
	TEST.32	D0:#BGCITAL
	JUMP,BC R8^14$
	CALL	DGCITALIQUE	; calcul dimensions pour italique
14$:
	TEST.32	D0:#BGCBOLD
	JUMP,BS R8^15$
	TEST.32	D0:#BGCOUTL
	JUMP,BS R8^15$
	TEST.32	D0:#BGCSHAD
	JUMP,BC R8^16$
15$:
	CALL	DGCGRAS		; calcul dimensions pour gras
16$:
	MOVE.32	A4,A5		; A5 <-- ^gencar d'origine

; Vrifie si le nouveau gencar n'est pas trop large

	MOVE.16	#ERDIGC,D7	; D7 <-- erreur "gencar inexistant"
	COMP.16	#255,D2		; nouveau gencar trop large ? (255  cause des enttes...)
	JUMP,HI 90$		; oui => 90$
	CLR.16	D7

	CLR.16	D4
	MOVE.8	{A4}+OGCLCA,D4	; Code last - code first + 1
	SUB.8	{A4}+OGCFCA,D4
	INC.8	D4		; D4 <-- nb de caractres (1..128)
	TEST.32	D4:#0
	JUMP,BC	R8^17$
	SET.8	{A6}+OFLNBCI	; nbr car impair, on sautera un byte aprs les
17$:				; enttes pour tre pair aux matrices, on recalera en sortie
	MOVE.16	D4,{A6}+ONBCAR

; Rserve la mmoire pour le nouveau gencar.

	MOVE.16	D2,D4		; D4 <-- nouvelle largeur (en points)
	ADD.16	#8-1,D4
	SR.16	#3,D4		; D4 <-- nouvelle largeur (en bytes)
	TEST.32	D4:#0
	JUMP,BC	R8^18$
	SET.8	{A6}+OFLWI
	INC.32	D4		; force largeur pair des matrices (optimise le travail)
18$:
	MOVE.16	D4,D1		; D1 <-- nouvell largeur (en bytes)
	MUL.16	D3,D4		; D4* hauteur matrice
	PUSH.32	D1
	ADD.16	#3,D4		; D4 <-- + bytes l, h1, h2.
	MUL.16	{A6}+ONBCAR,D4
	ADD.32	#OGCWID,D4	; D4 <-- OGCWID+(3*NBCAR)+(NBB*NBCAR)+NBB
	TEST.32	D4:#0
	JUMP,BC	R8^19$
	INC.32	D4
19$:
	MOVE.16	#MTYPCP,D1
	GESMEM	?GETMEM		; demande mmoire pour gencar
	POPM.32	D1
	JUMP,NE 90$

	MOVE.32	A4,A3		; clear le gencar futur
20$:
	CLR.16	{A3+}
	SUB.32	#2,D4
	JUMP,NE	20$

; Transfert les en-ttes et met  jour les principaux paramtres.

	MOVE.32	A5,A2		; A2 <-- ^gencar source
	MOVE.32	A4,A3		; A3 <-- ^gencar destination

	MOVE.16	#OGCWID,D4	; transfert entte
	DEC.16	D4
21$:
	MOVE.8	{A2+},{A3+}	; nouveau <-- en-ttes
	DECJ.16,NMO D4,21$

	PUSHM.32 A2..A3
	MOVE.32	#{A4}+OGCIDE,A3
	MOVE.32	#R16^TGC,A2
ID$:
	MOVE.8	{A2+},{A3+}
	JUMP,NE	ID$
	POPM.32	A2..A3

	MOVE.16	{A6}+ONBCAR,{A4}+OGCNBR

	MOVE.8	D1,{A4}+OGCMWB	; mj nouvelle largeur (en bytes)
	MOVE.16	D2,{A4}+OGCMWI	; mj nouvelle largeur (en points)
	MOVE.16	D3,{A4}+OGCMHD	; mj nouvelle hauteur (en points)
	MOVE.16	D1,D2
	MUL.16	D3,D2		; D2 <-- hauteur * largeur
	MOVE.16	D2,{A4}+OGCMSB	; mj nouveau nb total de bytes

	MOVE.32	D0,D4
	AND.32	#2**BGCDEMIX+2**BGCDEMIY,D4
	JUMP,EQ	XPG$

; On transfert les enttes l, h1, h1 et les matrices d'un gencar plus grand dans
; le futur gencar plus petit.

X10$:
	MOVE.16	{A6}+ONBCAR,D4	; enttes
	DEC.16	D4

	PUSH.32	D4
X22$:
	MOVE.8	{A2+},D1	; nouveau <-- en-ttes largeur
	TEST.32	D0:#BGCDEMIX
	JUMP,BC	R8^X23B$
	SR.8	D1		; /2
	JUMP,CC	R8^X23$
	INC.8	D1
	JUMP	R8^X23B$
X23$:
	TEST.32	D0:#BGCICO
	JUMP,BS	R8^X23B$
	INC.8	D1		; marge garantie
X23B$:
	MOVE.8	D1,{A3+}
	DECJ.16,NMO D4,X22$
	POP.32	D4

	PUSH.32	D4
X24$:
	MOVE.8	{A2+},D1	; nouveau <-- en-ttes h1
	TEST.32	D0:#BGCDEMIY
	JUMP,BC	R8^X25$
	SR.8	D1		; (dfaut au dessus ligne base)
X25$:
	MOVE.8	D1,{A3+}
	DECJ.16,NMO D4,X24$
	POP.32	D4

X26$:
	MOVE.8	{A2+},D1	; nouveau <-- en-ttes h2
	TEST.32	D0:#BGCDEMIY
	JUMP,BC	R8^X27$
	SR.8	D1		; /2, (excs sous ligne de base)
	JUMP,CC	R8^X27$
	INC.8	D1
X27$:
	MOVE.8	D1,{A3+}
	DJ.16,NMO D4,X26$
				; met  jour entte
	TEST.32	D0:#BGCDEMIX
	JUMP,BC	R8^X30$

	MOVE.16	{A4}+OGCLMA,D4	; marge gauche
	SR.16	#1,D4		; (arrondie par dfaut)
	MOVE.16	D4,{A4}+OGCLMA
X30$:
	TEST.32	D0:#BGCDEMIY
	JUMP,BC	X40$

	MOVE.16	{A4}+OGCBLI,D4	; ht sous ligne de base
	SR.16	#1,D4
	JUMP,CC	R8^X31$
	INC.16	D4
X31$:
	MOVE.16	D4,{A4}+OGCBLI

	MOVE.16	{A4}+OGCMH1,D4	; max ht dessus ligne de base
	SR.16	#1,D4
	MOVE.16	D4,{A4}+OGCMH1

	MOVE.16	{A4}+OGCMH2,D4	; max dessous ligne de base
	SR.16	#1,D4
	JUMP,CC	R8^X33$
	INC.16	D4
X33$:
	MOVE.16	D4,{A4}+OGCMH2

	MOVE.16	{A4}+OGCISP,D4	; interligne
	SR.16	#1,D4
	JUMP,CC	R8^X35$
	INC.16	D4
X35$:
	MOVE.16	D4,{A4}+OGCISP
X40$:
	CALL	XMATRCGC	; transfert toutes les matrices
	JUMP	CGC$

; On transfert les enttes l, h1, h1 et les matrices d'un gencar plus petit dans
; le futur gencar plus grand.

XPG$:
	MOVE.16	{A6}+ONBCAR,D4	; entte des largeurs
	DEC.16	D4
22$:
	MOVE.8	{A2+},{A3+}	; nouveau <-- en-ttes largeur (seront corriges ensuite)
	DECJ.16,NMO D4,22$

	MOVE.16	{A6}+ONBCAR,D4	; entte des hauteurs h1, h2
	MUL.16	#2,D4
	DEC.16	D4		; D4 <-- (OGCWID+(NBCAR*3))-1
24$:
	MOVE.8	{A2+},{A3+}	; nouveau <-- en-ttes (seront corriges ensuite)
	DECJ.16,NMO D4,24$

	CALL	XMATR		; transfert toutes les matrices

CGC$:
	TEST.32	D0:#BGCDOUB
	JUMP,BC R8^60$
	CALL	CGCDOUBLE	; cre gencar double dimensions
60$:
	TEST.32	D0:#BGCLARG
	JUMP,BC R8^62$
	CALL	CGCLARGE	; cre gencar double largeur
62$:
	TEST.32	D0:#BGCITAL
	JUMP,BC R8^64$
	CALL	CGCITALIQUE	; cre gencar italique
64$:
	TEST.32	D0:#BGCBOLD
	JUMP,BS R8^65$
	TEST.32	D0:#BGCOUTL
	JUMP,BS R8^65$
	TEST.32	D0:#BGCSHAD
	JUMP,BC R8^66$
65$:
	CALL	CGCGRAS		; cre gencar gras
66$:
	TEST.8	{A6}+OFLNBCI
	JUMP,F	R8^75$
	MOVE.16	{A6}+ONBCAR,D4
	MUL.16	{A4}+OGCMSB,D4	; D4.32 <-- longeur des matrices
	PUSH.32	A4
	MOVE.32	{A6}+ODEBNGC,A4
67$:
	MOVE.8	{A4+},{A4}-2	; dcale sur le byte saut  cause nbr car impair
	DEC.32	D4
	JUMP,NE	67$
	POP.32	A4
75$:
	TEST.8	{A6}+OFLWI
	JUMP,F	89$
	CLR.32	D1		; on compresse le gencar en rcuprant le byte ajout
	MOVE.16	{A4}+OGCNBR,D1	; (D1 nombre de matrices)
	CLR.32	D2
	MOVE.16	{A4}+OGCMHD,D2	; D2 nombre de lignes par matrice
	MUL.16	D2,D1		; D1 nombre total de lignes
;	MOVE.32	D1,D4		; D4.32	nombre de bytes rcuprs
	CLR.32	D3
	MOVE.8	{A4}+OGCMWB,D3	; D3 largeur en bytes d'une ligne -1
	DEC.32	D3
	MOVE.32	{A6}+ODEBNGC,A2	; A2 <-- ^1er trou
	ADD.32	D3,A2
	MOVE.32	#{A2}+1,A3
76$:
	PUSH.32	D3
77$:
	MOVE.8	{A3+},{A2+}	; compresse une ligne
	DEC.32	D3
	JUMP,NE	77$
	POP.32	D3
	INC.32	A3		; octet trou
	DEC.32	D1		; ligne suivante, si encore
	JUMP,NE	76$

	SUB.16	D2,{A4}+OGCMSB	; un octet rcupr par ligne
	SUB.8	#1,{A4}+OGCMWB

; Lorsque GESMEM ?SUBMEM existera, on poura encore rduire le buffer
; (on ne le fait pas ici  cause de 1) rapidit, 2) risque de mmoire
; insuffisante, puisqu'il faudrait  l'heure actuelle redemander un buffer...)

89$:
	CLR.16	D7		; D7 <-- ok
90$:
	PUSHM.32 D7|A4
	MOVE.32	A6,A4
	MOVE.16	#MTYPCP,D1
	GESMEM	?GIVMEM		; rend les variables
	POPM.32	D7|A4
95$:
	POPM.32	D0..D5|A0..A3|A5|A6
	TEST.16	D7		; retour EQ/NE
	RET

;---------\\
; XMATRCGC >
;---------/

; Transfert toutes les matrices dans le futur gencar plus petit que le source,
; en crant donc le nouveau simultanment.

; in	A6	^var
;	A5	^gencar source
;	A4	^gencar destination (entte  jour)
;	A2	matrices sources
;	A3	^matrices destinations
;	D0	flags
; out	{A6}+ODEBNGC dbut des matrices du nouveau gencar
; mod	A2, A3, D1, D2, D3, D4, D5, D7

XMATRCGC:
	PUSHM.32 A4|A1|D6

	TEST.8	{A6}+OFLNBCI
	JUMP,F	R8^29$
	INC.32	A3		; A3 pair (saute un byte si nb car impair)
29$:
	MOVE.32	A3,{A6}+ODEBNGC

	MOVE.16	{A5}+OGCMHD,D3	; D3 ht ancien
	MOVE.16	{A5}+OGCMWI,D4	; D4 larg. ancien en points
	MOVE.16	{A6}+ONBCAR,D5	; D5 <-- nb de caractres

	TEST.32	D0:#BGCDEMIY
	JUMP,BC	DIVL
	TEST.32	D0:#BGCDEMIX
	JUMP,BC	DIVHT

; Transfert l'ancien gencar dans le nouveau, car par car, en rduisant ht. & l.

ENC$:
	PUSHM.32 A2..A3|D3..D4
L0$:
	PUSHM.32 A2..A3|D3..D4	; rduit une tranche horizontale

	MOVE.32	A2,A1		; A1^ligne suivante matr. source si
	COMP.16	#2,D3		; reste 2 lignes ou plus dans matrice source.
	JUMP,LO	R8^L1$
	CLR.32	D1
	MOVE.8	{A5}+OGCMWB,D1
	ADD.32	D1,A1
L1$:
	MOVE.32	#7,D7		; @ bits source
	MOVE.32	#7,D6
	COMP.16	#2,D4
	JUMP,LO	R8^L2$
	DEC.32	D6
L2$:
	MOVE.32	#7,D2		; @ bit destination
L10$:
	TCLR.8	{A3}:D2

	TEST.8	{A2}:D7
	JUMP,BS	R8^L20$
	TEST.8	{A1}:D7
	JUMP,BS	R8^L20$
	TEST.8	{A2}:D6
	JUMP,BS	R8^L20$
	TEST.8	{A1}:D6
	JUMP,BC	R8^L30$
L20$:
	TSET.8	{A3}:D2
L30$:
	SUB.32	#1,D2		; bit suivant destination
	JUMP,HS	R8^L35$
	INC.32	A3
	MOVE.32	#7,D2
L35$:
	SUB.16	#2,D4		; avance de 2 points dans ligne ancien, si encore
	JUMP,LE	R8^LSUIV$
	COMP.16	#2,D4
	JUMP,HS	R8^L37$
	INC.32	D6
L37$:
	SUB.32	#2,D7
	SUB.32	#2,D6
	JUMP,CC	L10$
	MOVE.32	#7,D7
	MOVE.32	#7,D6
	COMP.16	#2,D4
	JUMP,LO	R8^L38$
	DEC.32	D6
L38$:
	INC.32	A2
	INC.32	A1
	JUMP	L10$

LSUIV$:
	POPM.32	A2..A3|D3..D4	; ligne suivante si encore

	SUB.16	#2,D3
	JUMP,LE	R8^SUIV$

	CLR.32	D1
	MOVE.8	{A5}+OGCMWB,D1	; avance de 2 ligne dans source
	ADD.32	D1,A2
	ADD.32	D1,A2
	MOVE.8	{A4}+OGCMWB,D1	; et d'une ligne dans destination
	ADD.32	D1,A3
	JUMP	L0$

SUIV$:
	POPM.32	A2..A3|D3..D4

	CLR.32	D1
	MOVE.16	{A5}+OGCMSB,D1	; A2 & A3^matrice suivante
	ADD.32	D1,A2
	MOVE.16	{A4}+OGCMSB,D1
	ADD.32	D1,A3

	DEC.16	D5
	JUMP,NE	ENC$
	JUMP	OUTD

; Transfert l'ancien gencar dans le nouveau, car par car, en rduisant ht.

DIVHT:
ENC$:
	PUSHM.32 A2..A3|D3..D4
L0$:
	PUSHM.32 A2..A3|D3..D4	; rduit une tranche horizontale

	MOVE.32	A2,A1		; A1^ligne suivante matr. source si
	COMP.16	#2,D3		; reste 2 lignes ou plus dans matrice source.
	JUMP,LO	R8^L1$
	CLR.32	D1
	MOVE.8	{A5}+OGCMWB,D1
	ADD.32	D1,A1
L1$:
	MOVE.32	#7,D7		; @ bits source
L2$:
	MOVE.32	#7,D2		; @ bit destination
L10$:
	TCLR.8	{A3}:D2

	TEST.8	{A2}:D7
	JUMP,BS	R8^L20$
	TEST.8	{A1}:D7
	JUMP,BC	R8^L30$
L20$:
	TSET.8	{A3}:D2
L30$:
	SUB.32	#1,D2		; bit suivant destination
	JUMP,HS	R8^L35$
	INC.32	A3
	MOVE.32	#7,D2
L35$:
	SUB.16	#1,D4		; avance de 1 point dans ligne ancien, si encore
	JUMP,LE	R8^LSUIV$

	SUB.32	#1,D7
	JUMP,CC	L10$
	MOVE.32	#7,D7
	INC.32	A2
	INC.32	A1
	JUMP	L10$

LSUIV$:
	POPM.32	A2..A3|D3..D4	; ligne suivante si encore

	SUB.16	#2,D3
	JUMP,LE	R8^SUIV$

	CLR.32	D1
	MOVE.8	{A5}+OGCMWB,D1	; avance de 2 ligne dans source
	ADD.32	D1,A2
	ADD.32	D1,A2
	MOVE.8	{A4}+OGCMWB,D1	; et d'une ligne dans destination
	ADD.32	D1,A3
	JUMP	L0$

SUIV$:
	POPM.32	A2..A3|D3..D4

	CLR.32	D1
	MOVE.16	{A5}+OGCMSB,D1	; A2 & A3^matrice suivante
	ADD.32	D1,A2
	MOVE.16	{A4}+OGCMSB,D1
	ADD.32	D1,A3

	DEC.16	D5
	JUMP,NE	ENC$
	JUMP	OUTD

; Transfert l'ancien gencar dans le nouveau, car par car, en rduisant l.

DIVL:
ENC$:
	PUSHM.32 A2..A3|D3..D4
L0$:
	PUSHM.32 A2..A3|D3..D4	; rduit une tranche horizontale
L1$:
	MOVE.32	#7,D7		; @ bits source
	MOVE.32	#7,D6
	COMP.16	#2,D4
	JUMP,LO	R8^L2$
	DEC.32	D6
L2$:
	MOVE.32	#7,D2		; @ bit destination
L10$:
	TCLR.8	{A3}:D2

	TEST.8	{A2}:D7
	JUMP,BS	R8^L20$
	TEST.8	{A2}:D6
	JUMP,BC	R8^L30$
L20$:
	TSET.8	{A3}:D2
L30$:
	SUB.32	#1,D2		; bit suivant destination
	JUMP,HS	R8^L35$
	INC.32	A3
	MOVE.32	#7,D2
L35$:
	SUB.16	#2,D4		; avance de 2 points dans ligne ancien, si encore
	JUMP,LE	R8^LSUIV$
	COMP.16	#2,D4
	JUMP,HS	R8^L37$
	INC.32	D6
L37$:
	SUB.32	#2,D7
	SUB.32	#2,D6
	JUMP,CC	L10$
	MOVE.32	#7,D7
	MOVE.32	#7,D6
	COMP.16	#2,D4
	JUMP,LO	R8^L38$
	DEC.32	D6
L38$:
	INC.32	A2
	JUMP	L10$

LSUIV$:
	POPM.32	A2..A3|D3..D4	; ligne suivante si encore

	SUB.16	#1,D3
	JUMP,EQ	R8^SUIV$

	CLR.32	D1
	MOVE.8	{A5}+OGCMWB,D1	; avance de 1 ligne dans source
	ADD.32	D1,A2
	MOVE.8	{A4}+OGCMWB,D1	; et d'une ligne dans destination
	ADD.32	D1,A3
	JUMP	L0$

SUIV$:
	POPM.32	A2..A3|D3..D4

	CLR.32	D1
	MOVE.16	{A5}+OGCMSB,D1	; A2 & A3^matrice suivante
	ADD.32	D1,A2
	MOVE.16	{A4}+OGCMSB,D1
	ADD.32	D1,A3

	DEC.16	D5
	JUMP,NE	ENC$
OUTD:
	CLR.16	D7
	POPM.32	A4|A1|D6
	RET

;------\\
; XMATR >
;------/

; Transfert toutes les matrices dans le futur gencar plus grand que le source.

; in	A6	^var
;	A5	^gencar source
;	A2	^matrices sources
;	A3	^matrices destinations
;	D3.16	hauteur nouveau
; out	{A6}+ODEBNGC dbut des matrices du nouveau gencar
; mod	A2, A3, D1, D2, D3, D4, D5

XMATR:
	CLR.16	D2
	MOVE.8	{A5}+OGCMWB,D2	; D2 <-- ancienne largeur (en bytes)
	SUB.16	D2,D1		; D1 <-- nouvelle largeur en plus
	JUMP,NC R8^28$		; si ancien > nouveau (plus large) =>
	ADD.16	D1,D2		; D2 <-- largeur la plus petite
28$:
	MOVE.16	{A5}+OGCMHD,D4	; D4 <-- ancienne hauteur
	SUB.16	D4,D3		; D3 <-- nouvelle hauteur en plus

	MOVE.16	{A6}+ONBCAR,D5	; D5 <-- nb de caractres

; Transfert l'ancien gencar dans le nouveau, ligne par ligne.
; Transfert d'abord le dbut de la ligne. Ensuite, si le nouveau
; est plus large que l'ancien, efface la fin de la ligne.

	TEST.8	{A6}+OFLNBCI
	JUMP,F	R8^29$
	INC.32	A3		; A3 pair (saute un byte si nb car impair)
29$:
	MOVE.32	A3,{A6}+ODEBNGC
30$:
	PUSH.16	D4
31$:
	PUSHM.32 D1|D2
32$:
	TEST.16	D2
	JUMP,EQ R8^33$
	DEC.16	D2
	MOVE.8	{A2+},{A3+}	; transfert le dbut de la ligne
	JUMP	32$
33$:
	TEST.16	D1
	JUMP,NC R8^34$
	SUB.A16	D1,A2		; A2 <-- avance dans ancien si plus large
	JUMP	R8^36$
34$:
	TEST.16	D1
	JUMP,EQ R8^36$
	DEC.16	D1
	CLR.8	{A3+}		; efface la fin de la ligne
	JUMP	34$
36$:
	POPM.32	D1|D2

	DEC.16	D4		; encore une ligne ?
	JUMP,NE 31$		; oui => 31$
	POP.16	D4

; Si le nouveau gencar est plus haut que l'ancien, efface ensuite
; la partie infrieure.

	TEST.16	D3
	JUMP,EQ 38$
	PUSH.16	D1

	TEST.16	D1		; correction faute DR
	JUMP,NC	R8^E1$
	MOVE.16	D2,D1
	JUMP	R8^E2$

E1$:
	ADD.16	D2,D1		; D1 <-- nouvelle largeur totale
E2$:
	MUL.16	D3,D1
	DEC.16	D1		; D1 <--  cause du NMO
37$:
	CLR.8	{A3+}		; efface la partie suprieure
	DECJ.16,NMO D1,37$
	POP.16	D1
38$:
	DEC.16	D5		; encore un caractre ?
	JUMP,NE 30$		; oui => 30$
	RET

;--------\\
; DGCDIVL >
;--------/

; Donne les dimensions pour un gencar en largeur/2.

; in	A4.L	^gencar  transformer
;	D2.W	largeur (en points)
;	D3.W	hauteur (en points)
;	D0.32	style
; out	D2.W	largeur (en points)
;	D3.W	hauteur (en points)
; mod	D2.W, D3.W, F.

DGCDIVL:
	SR.16	#1,D2		; D2 <-- largeur/2
	JUMP,CC	R8^10$
	INC.16	D2		; arrondi par excs
	JUMP	R8^20$
10$:
	TEST.32	D0:#BGCICO
	JUMP,BS	R8^20$
	INC.16	D2		; marge de 1 point  droite
20$:
	RET


;----------\\
; DGCDIVHT  >
;----------/

; Donne les dimensions pour un gencar hauteur/2.

; in	A4.L	^gencar  transformer
;	D2.W	largeur (en points)
;	D3.W	hauteur (en points)
; out	D2.W	largeur (en points)
;	D3.W	hauteur (en points)
; mod	D2.W, D3.W, F.

DGCDIVHT:
	SR.16	#1,D3		; D3 <-- hauteur/2
	JUMP,CC	R8^10$
	INC.16	D3		; arrondi par excs
10$:
	RET


;----------\\
; DGCDOUBLE >
;----------/

; Donne les dimensions pour un gencar en double dimensions.

; in	A4.L	^gencar  transformer
;	D2.W	largeur (en points)
;	D3.W	hauteur (en points)
; out	D2.W	largeur (en points)
;	D3.W	hauteur (en points)
; mod	D2.W, D3.W, D7.W

DGCDOUBLE:
	SL.16	#1,D2		; D2 <-- double la largeur
	SL.16	#1,D3		; D3 <-- double la hauteur
	RET

;----------\\
; CGCDOUBLE >
;----------/

; Cre un gencar en double dimensions.

; in	A4.L	^gencar  transformer
; out	-
; mod	D7.W

CGCDOUBLE:
	PUSHM.32 D0..D4|A1..A5

	MOVE.16	{A4}+OGCLMA,D0	; marge gauche
	SL.16	#1,D0
	MOVE.16	D0,{A4}+OGCLMA

	MOVE.16	{A4}+OGCBLI,D0	; ht sous ligne de base
	SL.16	#1,D0
	MOVE.16	D0,{A4}+OGCBLI

	MOVE.16	{A4}+OGCMH1,D0	; max ht dessus ligne de base
	SL.16	#1,D0
	MOVE.16	D0,{A4}+OGCMH1

	MOVE.16	{A4}+OGCMH2,D0	; max dessous ligne de base
	SL.16	#1,D0
	MOVE.16	D0,{A4}+OGCMH2

	MOVE.16	{A4}+OGCISP,D0	; interligne
	SL.16	#1,D0
	MOVE.16	D0,{A4}+OGCISP

	MOVE.16	{A5}+OGCMHD,D4	; D4 <-- hauteur actuelle (0.5)

	MOVE.32	#{A4}+OGCWID,A5
	MOVE.16	{A6}+ONBCAR,D1
	MUL.16	#3,D1
	DEC.16	D1		; D1 <-- (NBCAR*3)-1
10$:
	MOVE.8	{A5},D0
	SL.8	D0		; double lg/h1/h2
	MOVE.8	D0,{A5+}
	DECJ.16,NMO D1,10$

	MOVE.16	{A6}+ONBCAR,D0	; D0 <-- nb de caractres
	CLR.16	D1
	MOVE.8	{A4}+OGCMWB,D1	; D1 <-- largeur en bytes

	MOVE.16	D4,D3		; D4 <-- hauteur actuelle (0.5)
	MUL.16	D1,D3		; D3 <-- 0.5 * nb bytes de la matrice

	MOVE.32	{A6}+ODEBNGC,A5
30$:
	MOVE.32	A5,A2		; double une matrice
	ADD.A16	D3,A2		; A2 <-- ^source (au milieu de la matrice)
	MOVE.32	A2,A3
	ADD.A16	D3,A3		; A3 <-- ^destination (en bas de la matrice)

	MOVE.16	D4,D2		; D2 <-- 0.5 * hauteur finale
	DEC.16	D2		; D2 <--  cause du NMO
35$:
	SUB.A16	D1,A2		; traite une -> deux lignes
	SUB.A16	D1,A3
	CALL	DOUBLEX		; double une ligne
	MOVE.32	A3,A1		; double une 2me fois
	SUB.A16	D1,A3
	PUSH.16	D1
37$:
	MOVE.16	{A1}+A16^{D1}-2,{A3}+A16^{D1}-2
	SUB.16	#2,D1
	JUMP,NE	37$
	POP.16	D1

	DECJ.16,NMO D2,35$	; encore une ligne ?

	ADD.A16	{A4}+OGCMSB,A5	; A5 <-- ^matrice suivante
	DEC.16	D0		; encore un caractre ?
	JUMP,NE 30$		; oui => 30$

	POPM.32	D0..D4|A1..A5
	RET



;---------\\
; DGCLARGE >
;---------/

; Donne les dimensions pour un gencar en double largeur.

; in	A4.L	^gencar  transformer
;	D2.W	largeur (en points)
;	D3.W	hauteur (en points)
; out	D2.W	largeur (en points)
;	D3.W	hauteur (en points)
; mod	D2.W, D3.W, D7.W

DGCLARGE:
	SL.16	#1,D2		; D2 <-- double la largeur
	RET


;---------\\
; CGCLARGE >
;---------/

; Cre un gencar en double largeur.

; in	A4.L	^gencar  transformer
; out	-
; mod	D7.W

CGCLARGE:
	PUSHM.32 D0..D4|A2..A5

	MOVE.16	{A4}+OGCLMA,D4
	SL.16	#1,D4
	MOVE.16	D4,{A4}+OGCLMA

	MOVE.32	#{A4}+OGCWID,A5
	MOVE.16	{A6}+ONBCAR,D4
	DEC.16	D4
10$:
	MOVE.8	{A5},D3
	SL.8	D3		; double lg
	MOVE.8	D3,{A5+}
	DECJ.16,NMO D4,10$

	MOVE.32	{A6}+ODEBNGC,A5

	MOVE.16	{A4}+OGCMHD,D0
	MUL.16	{A6}+ONBCAR,D0	; D0 <-- nb total de lignes
	CLR.16	D1
	MOVE.8	{A4}+OGCMWB,D1	; D1 <-- largeur en bytes

	MOVE.32	A5,A3		; A3 <-- ^destination
	MOVE.32	A5,A2		; A2 <-- ^source
	DEC.16	D0		; D0 <--  cause du NMO
30$:
	CALL	DOUBLEX		; double une ligne
	ADD.A16	D1,A3
	ADD.A16	D1,A2
	DECJ.16,NMO D0,30$	; encore un caractre ?

	POPM.32	D0..D4|A2..A5
	RET


;--------\\
; DOUBLEX >
;--------/

; Double la largeur d'une ligne de points.

; in	A2.L	^ligne source
;	A3.L	^ligne destination (A2=A3 OK)
;	D1.W	largeur de la ligne destination en bytes
; out	-
; mod	-

DOUBLEX:
	PUSHM.32 D1..D5

	AND.32	#16'FFFF,D1
	MOVE.32	D1,D2		; D1.32 longueur voulue
	SR.32	D2		; D2.32 longueur d'origine, -1 Bytes
	DEC.32	D2
10$:
	MOVE.8	{A2}+A16^{D2},D4 ; D4 last .8 source

	MOVE.16	#8-1,D3		; D4.8 -> D5.16 partie de ligne double
20$:
	SR.8	#1,D4		; X  <-- un point
	RRX.16	#1,D5		; D5 <-- enfile le point
	ASR.16	#1,D5		; D5 <-- double le point
	DECJ.16,NMO D3,20$

	MOVE.16	D5,{A3}+A16^{D1}-2 ; last .16 dest

	SUB.32	#2,D1		; recule de 2 bytes dans ligne destination
	DJ.16,NMO D2,10$	; et d'un dans ligne source

	POPM.32 D1..D5
	RET

;------------\\
; DGCITALIQUE >
;------------/

; Donne les dimensions pour un gencar italique.

; in	A4.L	^gencar  transformer
;	D0.W	style (BGCPPL)
;	D2.W	largeur (en points)
;	D3.W	hauteur (en points)
; out	D2.W	largeur (en points)
;	D3.W	hauteur (en points)
; mod	D2.W, D3.W, D7.W

DGCITALIQUE:
	PUSH.32	D0

	TEST.32	D0:#BGCPPL	; gencar pas plus large ?
	JUMP,BS R8^90$		; oui => 90$

	CLR.32	D0
	MOVE.16	{A4}+OGCMHD,D0	; D0 <-- hauteur en points
	SUB.16	{A4}+OGCBLI,D0	; D0 <-- hauteur dessus ligne de base
	DIV.16	#NBDITAL,D0	; D0 <-- dcalage initial
	ADD.16	D0,D2		; D2 <-- augmente la largeur

	SWAP.32	D0		; D0 <-- reste de la division
	TEST.16	D0
	JUMP,NE R8^50$
	DEC.16	D2		; D2 <-- dcale moins
50$:
	DEC.16	D2		; D2 <-- faut pas exagrer !
90$:
	POP.32	D0
	RET


;------------\\
; CGCITALIQUE >
;------------/

; Cre un gencar italique.

; in	A4.L	^gencar  transformer
;	D0.W	style (BGCPPL)
; out	-
; mod	D7.L

CGCITALIQUE:
	PUSHM.32 D0..D6|A3|A4

	SWAP.32	D0		; D0 <-- style (16+bits)
	MOVE.16	{A4}+OGCMHD,D0	; D0 <-- hauteur en points
	CLR.16	D1
	MOVE.8	{A4}+OGCMWB,D1	; D1 <-- largeur en bytes
	MOVE.16	{A6}+ONBCAR,D3	; D3 <-- nb de caractres
	CLR.32	D5
	MOVE.16	D0,D5
	SUB.16	{A4}+OGCBLI,D5
	DIV.16	#NBDITAL,D5	; D5 <-- dcalage initial

	SWAP.32	D5
	MOVE.16	D5,D6		; D6 <-- reste de la division, nombre initial
	SWAP.32	D5		; de lignes  dcaler de D5 points
	TEST.16	D6
	JUMP,NE R8^20$
	MOVE.16	#NBDITAL,D6
	DEC.16	D5		; D5 <-- dcale moins
20$:
	MOVE.32	#{A4}+OGCWID,A3	; A3 <-- ^table des largeurs
	MOVE.32	{A6}+ODEBNGC,A4	; A4^matrices

	CLR.32	D7		; 2.1
30$:
	PUSHM.32 D0|D5..D6	; boucle pour traitement d'un caratre

	TEST.32	D0:#16+BGCPPL	; gencar pas plus large ?
	JUMP,BS R8^50$		; oui => 50$

	ADD.8	D5,{A3}		; non => augmente la largeur du caractre
	DEC.8	{A3}		; faut quand mme pas exagrer !
35$:
	CALL	DECGL		; dcale la ligne A4^

	DEC.16	D6		; encore une ligne dans cette tranche ?
	JUMP,NE R8^37$
	DEC.16	D5		; non, D5 <-- dcale moins
	MOVE.16	#NBDITAL,D6	; D6 <-- r-arme le compteur
37$:
	ADD.A16	D1,A4		; A4^ligne suivante

	DEC.16	D0		; si encore une ligne de cette matrice, ->35$
	JUMP,NE 35$
	JUMP	R8^60$
50$:
	CALL	DECPL		; 2.1 (pas plus larges)

	DEC.16	D6		; encore une ligne dans cette tranche ?
	JUMP,NE R8^57$
	DEC.16	D5		; non, D5 <-- dcale moins
	MOVE.16	#NBDITAL,D6	; D6 <-- r-arme le compteur
57$:
	ADD.A16	D1,A4		; A4^ligne suivante

	DEC.16	D0		; si encore une ligne de cette matrice, ->35$
	JUMP,NE 50$
60$:
	POPM.32	D0|D5..D6	; sinon,

	INC.32	A3		; A3 <-- ^largeur suivante

	DEC.16	D3		; si encore une matrice, -> 30$
	JUMP,NE 30$

	POPM.32	D0..D6|A3|A4	; sinon, OK
	RET

;------\\
; DECPL >
;------/
; Dcale une petite ligne dans une matrice
;
; in	A4	^ligne
;	A3	^largeur en points
;	D1.16	largeur ligne en bytes =<4,
;	D5.16	+ ( droite) v - ( gauche) nombre de points  dcaler
;	D7	selon prcdent
; mod	D2, D4, D7, F.

DECPL:	TEST.32	D7
	JUMP,NE	R8^35$

	MOVE.8	D1,D2		; (D2 <-- largeur en bytes)
	SL.8	#3,D2		; (D2 <-- largeur en points)
	MOVE.8	D2,D7
	DEC.8	D7		; D7 msw <-- no bit tout  gauche
	SWAP.32	D7
	SUB.8	{A3},D2
	MOVE.8	D2,D7		; D7 <-- no bit tout  droite
35$:
	CLR.32	D4
	MOVE.16	D1,D2		; (D2 <-- largeur en bytes)
	DEC.16	D2		; (D2 <--  cause du NMO)
40$:
	SL.32	#8,D4
	MOVE.8	{A4+},D4	; D4 <-- une ligne de points
	DECJ.16,NMO D2,40$

	PUSH.16	D5		; traite une ligne

	TEST.16	D5		; sens du dcalage ?
	JUMP,EQ R8^49$		; pas de dcalage
	JUMP,NS R8^44$		; en dessous ligne de base, dcale  gauche

	DEC.16	D5		; dcale  droite =>
42$:
	TCLR.32	D4:D7		; est-ce qu'un point va dborder ?
	JUMP,BC	R8^43$
	SR.32	#1,D4		; oui
	TSET.32	D4:D7		; remet un point
	SL.32	#1,D4
43$:
	SR.32	#1,D4		; D4 <-- dcale d'un point
	DECJ.16,NMO D5,42$
	JUMP	R8^49$

44$:
	SWAP.32	D7		; dcale  gauche =>
45$:
	TEST.32	D4:D7		; est-ce qu'un point va dborder ?
	JUMP,BC	R8^46$
	SL.32	#1,D4		; oui
	TSET.32	D4:D7		; remet un point
	SR.32	#1,D4
46$:
	SL.32	#1,D4		; D4 <-- dcale d'un point
	INC.16	D5
	JUMP,NE 45$
48$:
	SWAP.32	D7
49$:
	POP.16	D5

	MOVE.16	D1,D2		; D2 <-- largeur en bytes
	DEC.16	D2		; D2 <--  cause du NMO
60$:
	MOVE.8	D4,{-A4}	; met la ligne de points dcale
	SR.32	#8,D4
	DECJ.16,NMO D2,60$

	RET

;------\\
; DECGL >
;------/

; Dcale une ligne dans une matrice

; in	A4	^ligne
;	D1.16	largeur ligne en bytes
;	D5.16	+ ( droite) v - ( gauche) nombre de points  dcaler
; out	-
; mod	D2

DECGL:
	PUSHM.32 D1|D5		; traite une ligne

	TEST.16	D5		; sens du dcalage ?
	JUMP,EQ 49$		; pas de dcalage
	JUMP,NS R8^45$		; en dessous ligne de base, dcale  gauche
41$:
	PUSH.32	A4		; dcale  droite
	MOVE.16	D1,D2		; largeur en bytes
	CLRX
42$:
	RRX.16	{A4+}
	PUSH.16	SF
	SUB.16	#2,D2
	JUMP,EQ	R8^43$
	POP.16	F
	JUMP	42$
43$:
	POP.16	F		; fin ligne,
	JUMP,CC	R8^44$
	SL.16	{-A4}		; si dpassement, on ne dcale pas dernier
	TSET.8	{A4}+1:#0	; byte de la ligne
44$:
	POP.32	A4
	DEC.16	D5		; encore dcaler?
	JUMP,NE	41$
	JUMP	R8^49$

45$:
	MOVE.16	D1,D2		; largeur en bytes
	CLRX			; dcale  gauche
46$:
	RLX.16	{A4}+A16^{D2}-2
	PUSH.16	SF
	SUB.16	#2,D2
	JUMP,EQ	R8^47$
	POP.16	F
	JUMP	46$

47$:
	POP.16	F		; fin de ligne,
	JUMP,CC	R8^48$
	SR.16	{A4}		; si dpassement, on ne dcale pas
	TSET.8	{A4}:#7		; le premier byte
	JUMP	R8^49$

48$:
	INC.16	D5		; encore dcaler ?
	JUMP,NE	45$
49$:
	POPM.32	D1|D5
	RET

;--------\\
; DGCGRAS >
;--------/

; Donne les dimensions pour un gencar gras.

; in	A4.L	^gencar  transformer
;	D0.W	style
;	D2.W	largeur (en points)
;	D3.W	hauteur (en points)
; out	D2.W	largeur (en points)
;	D3.W	hauteur (en points)
; mod	D2.W, D3.W, D7.W

DGCGRAS:
	PUSH.16	D1

	TEST.32	D0:#BGCPPL	; gencar pas plus large ?
	JUMP,BS R8^90$		; oui => 90$

	PUSH.16	D2
	CALL	GRASDIM		; D1 <-- p. tour, D2 <-- p.  vider
	POP.16	D2

	DEC.16	D1
	ADD.16	D1,D2		; D2 <-- augmente la largeur
	ADD.16	D1,D3		; D3 <-- augmente la hauteur
90$:
	POP.16	D1
	RET


;--------\\
; CGCGRAS >
;--------/

; Cre un gencar gras et/ou relief et/ou ombr.

; in	A4.L	^gencar  transformer
;	D0.W	style
; out	-
; mod	D7.W

CGCGRAS:
	PUSHM.32 D1..D4|A2..A4

	MOVE.32	A4,A3
	CLR.32	D4
	MOVE.16	{A4}+OGCMSB,D4	; D4 <-- nb bytes d'une matrice
	SL.32	D4		; double
	MOVE.16	#MTYPCP,D1
	GESMEM	?GETMEM		; demande mmoire pour deux matrices provisoires
	JUMP,NE 90$
	EX.32	A4,A3

	CALL	GRASDIM		; D1 <-- p. tour, D2 <-- p.  vider

	MOVE.32	{A6}+ODEBNGC,A2	; A2^matrices

	TEST.32	D0:#BGCPPL	; gencar pas plus large ?
	JUMP,BS 30$		; oui => 30$

	ADD.16	D1,{A4}+OGCISP	; interligne

	MOVE.32	#{A4}+OGCWID,A2	; A2 <-- ^tables l/h1/h2 gencar aprs l'en-tte
	MOVE.16	D1,D3
	DEC.16	D3
	MOVE.16	{A6}+ONBCAR,D4
	DEC.16	D4
10$:
	ADD.8	D3,{A2+}	; augmente la table l
	DECJ.16,NMO D4,10$

	MOVE.16	#1,D3
	ADD.16	D3,{A4}+OGCMH1
	MOVE.16	{A6}+ONBCAR,D4
	DEC.16	D4
12$:
	ADD.8	D3,{A2+}	; augmente la table h1
	DECJ.16,NMO D4,12$

	SUB.16	D1,D3
	NEG.16	D3
	DEC.16	D3
	ADD.16	D3,{A4}+OGCMH2
	ADD.16	D3,{A4}+OGCBLI
	MOVE.16	{A6}+ONBCAR,D4
	DEC.16	D4
14$:
	ADD.8	D3,{A2+}	; augmente la table h2
	DECJ.16,NMO D4,14$

	MOVE.32	{A6}+ODEBNGC,A2	; A2^Matrices
30$:
	MOVE.16	{A6}+ONBCAR,D3	; D3 <-- nb de caractres
	DEC.16	D3
40$:
	CALL	CRETEMP		; caractre --> temporaire
	CALL	MOVTEMP		; gencar <-- temporaire
	DECJ.16,NMO D3,40$

	MOVE.32	A3,A4
	MOVE.16	#MTYPCP,D1
	GESMEM	?GIVMEM		; libre la mmoire pour une matrice
90$:
	POPM.32	D1..D4|A2..A4
	RET


;--------\\
; GRASDIM >
;--------/

; Donne les paisseurs du tour et du fond.

; in	D0.W	style
;					OUTL	SHAD	BOLD
; out	D1.W	paisseur du tour	3	5	2
;	D2.W	paisseur  vider	1	1	0
; mod	D1.W, D2.W

GRASDIM:
	MOVE.16	#1,D2
	TEST.32	D0:#BGCSHAD
	JUMP,BS R8^30$
	TEST.32	D0:#BGCOUTL
	JUMP,BS R8^30$
	CLR.16	D2
	MOVE.16	#2,D1
	JUMP	R8^90$
30$:
	TEST.32	D0:#BGCBOLD
	JUMP,BC R8^40$
	SL.16	#1,D2
40$:
	MOVE.16	D2,D1
	ADD.16	#4,D1
	TEST.32	D0:#BGCSHAD
	JUMP,BS R8^90$
	MOVE.16	D2,D1
	ADD.16	#2,D1
90$:
	RET


;--------\\
; CRETEMP >
;--------/

; Cre un caractre dans la matrice temporaire.

; in	D1.W	paisseur du tour
;	D2.W	paisseur  vider
;	A2.L	^matrice gencar
;	A3.L	^matrice temporaire
;	A4.L	^gencar
; out	-
; mod	-

CRETEMP:
	PUSHM.32 D0..D6

	MOVE.16	D2,D0		; D0 <-- paisseur  vider

	MOVE.16	{A4}+OGCMSB,D2
	SR.16	D2		; D2 <-- nb words de la matrice
	DEC.16	D2		; D2 <--  cause du NMO
	PUSH.32	A3
20$:
	CLR.16	{A3+}		; met la 1re matrice temporaire  zro
	DECJ.16,NMO D2,20$
	POP.32	A3

	CLR.16	D2
	MOVE.8	{A4}+OGCMWB,D2	; D2 <-- largeur en bytes
	MOVE.16	{A4}+OGCMHD,D3	; D3 <-- hauteur

; Rempli le pourtour dans la matrice temporaire.

	CLR.16	D4		; D4 <-- dbut X
	CLR.16	D5		; D5 <-- dbut Y
	MOVE.16	D1,D6		; D6 <-- paisseur en X,Y
	CALL	ADDXY

; Vide l'intrieur dans la matrice temporaire.

	TEST.16	D0		; qq chose  vider ?
	JUMP,EQ R8^90$		; non => 90$

	MOVE.16	#1,D4		; D4 <-- dbut X
	MOVE.16	D4,D5		; D5 <-- dbut Y
	MOVE.16	D0,D6		; D6 <-- paisseur en X,Y
	CALL	SUBXY
90$:
	POPM.32	D0..D6
	RET

;--------\\
; MOVTEMP >
;--------/

; Met la matrice temporaire dans le gencar.

; in	A2.L	^matrice gencar
;	A3.L	^matrice temporaire
;	A4.L	^gencar
; out	A2.L	^matrice suivante
; mod	A2.L

MOVTEMP:
	PUSHM.32 D2|A3

	MOVE.16	{A4}+OGCMSB,D2
	SR.16	D2		; D2 <-- nb words de la matrice
	DEC.16	D2		; D2 <--  cause du NMO
10$:
	MOVE.16	{A3+},{A2+}
	DECJ.16,NMO D2,10$

	POPM.32	D2|A3
	RET


;--------\\
; ADDXY   >
;--------/

; Ajoute un caractre dans un autre  une position (x,y) quelconque.

; in	A2.L	^caractre dans gencar source
;	A3.L	^caractre dans gencar destination (A2 <> A3 Ok)
;	D2.W	largeur (en bytes)
;	D3.W	hauteur (en points)
;	D4.W	dcalage en X (0..n)
;	D5.W	dcalage en Y (0..n)
;	D6.W	paisseur en X,Y (1..n)
; out	-
; mod	F

ADDXY:	PUSHM.32 D0..D6|A2..A4

	SUB.16	D5,D3		; D3 <-- hauteur - dcalage Y (D3 hauteur  copier)

	MUL.16	D2,D5		; D5 <-- dcalage Y * largeur
	ADD.32	D5,A3		; A3 <-- ^n lignes en dessous
	MOVE.32	A3,A4

	MOVE.16	D2,D1		; largeur en bytes

	DEC.16	D6
	PUSH.32	D6
0$:
	PUSHM.32 A2..A3|D4..D5
	MOVE.16	D2,D4
	MUL.16	D3,D4
	SR.32	D4		; D4 longueur  copier en words
	DEC.32	D4
10$:
	MOVE.16	{A2+},D5
	OR.16	D5,{A3+}	; copie le caractre contre marge gauche
	DJ.16,NMO D4,10$
	POPM.32	A2..A3|D4..D5

	TEST.16	D6		; dcale  droite si ncessaire
	JUMP,EQ	R8^30$

	PUSHM.32 A4|D3
15$:
	PUSH.32	D2
	MOVE.16	#1,D5
	CALL	DECGL
	POPM.32	D2

	ADD.A16	D2,A4
	DEC.16	D3		; encore une ligne?
	JUMP,NE	15$

	POPM.32	A4|D3

	DEC.16	D6		; rpte D6*
	JUMP	0$

30$:
	POP.32	D6

	PUSH.32	D3
	MOVE.32	D4,D5		; dcale vers le milieu de D4 points
40$:
	CALL	DECGL
	ADD.A16	D1,A4
	DEC.16	D3
	JUMP,NE	40$
	POP.32	D3

	TEST.16	D6
	JUMP,EQ	R8^90$

	MOVE.32	A4,A3
	SUB.A16	D1,A3
	MOVE.16	D1,D4
	MUL.16	D3,D4
	SUB.16	D1,D4
	SR.16	D4

50$:
	PUSHM.32 A3..A4|D4	; paissi en hauteur de D6*
60$:
	MOVE.16	{-A3},D5
	OR.16	D5,{-A4}
	DEC.16	D4
	JUMP,NE	60$
	POPM.32	A3..A4|D4
	DEC.16	D6
	JUMP,NE	50$
90$:
	POPM.32	D0..D6|A2..A4
	RET

;--------\\
; SUBXY   >
;--------/

; Enlve un caractre dans un autre  une position (x,y) quelconque.

; in	A2.L	^caractre dans gencar source
;	A3.L	^caractre dans gencar destination (A2 = A3, Ok, mais sans utilit!?)
;	D2.W	largeur (en bytes)
;	D3.W	hauteur (en points)
;	D4.W	dcalage en X (0..n)
;	D5.W	dcalage en Y (0..n)
;	D6.W	paisseur en X,Y (1..n)
; out	-
; mod	F.

SUBXY:	PUSHM.32 D0..D1|A3

	CLR.32	D0
	MOVE.16	{A4}+OGCMSB,D0
	ADD.32	D0,A3		; A3^2ime matrice temporaire,

	PUSHM.32 A3|D0		; cleare
	SR.32	D0
	DEC.16	D0
0$:
	CLR.16	{A3+}
	DJ.16,NMO D0,0$
	POPM.32	A3|D0

	CALL	ADDXY		; construit le caractre  effacer,

	PUSHM.32 A3|D0		; le complmente,
	SR.16	D0
	DEC.16	D0
10$:
	NOT.16	{A3+}
	DJ.16,NMO D0,10$
	POPM.32	A3|D0

	PUSH.32	A2
	MOVE.32	A3,A2
	SUB.32	D0,A3
	SR.16	D0
	DEC.16	D0
20$:
	MOVE.16	{A2+},D1
	AND.16	D1,{A3+}	; et efface enfin
	DJ.16,NMO D0,20$
	POP.32	A2

	POPM.32	D0..D1|A3
	RET



TGC:	.ASCIZE	"GENCAR"
	.EVEN

END_GENCAR:

	.END
