	.TITLE	GRAMISC.ASL

;	Module GRAMISC
;	==============

; Beat Brunner,	avril 1989 - septembre 1990
; Pierre Arnaud, septembre 1997

; Ce module est la couche de support des primitives graphiques de Psos.

; rev 1.0	    BB	version solide pour systme 6
; rev 1.1	    BB	InitColorSRgn ajout et implment pour support couleur
; rev 1.2  01.09.97 PA	RgnToBitmap fonctionne aussi avec des petites rgions


	.PROC	M68000

	.REF	SMAKY
	.REF	DOLIB

.macro D
pushm.32 d0..a7
lib ?aftim
.ascize "(%1) "
move.32 %2,d4
lib ?afx8,?afspace,?getcar
popm.32 d0..a7
.endmacro

.macro DA
pushm.32 d0..a7
lib ?aftim
.ascize "(%1) "
lib ?getcar
popm.32 d0..a7
.endmacro

	.REF	GRAMISC

REV	=	1
VERS	=	2

	.REV	REV,VERS
	.IDENT	"Routines de support graphique bas-niveau. B. Brunner, 1989,1990"

; Dfinitions
; -----------

; RgnHandle^:

	.LOC	0
OrgnSize:	.BLK.32	1	; Taille courante (paire)
OrgnBBox:	.BLK.16	4	; rectangle englobant la rgion
OrgnData:			; plus de donnes si ncessaire...
LGrgnMin:

rgnENDLIST	=	16'7FFF	; fin de liste en X ou en Y


; pseudo-grafport:						; EN PLUS:

		.LOC	0
OsimgrpPT:	.BLK.32	1		; Init ^RgnHandle dans RgnSave
OsimgrpLG:	.BLK.32	1		; lg
OsimgrpNB:	.BLK.32	1		; lg utilise
OsimgrpMODE:	.BLK.16	1		; mode
OsimgrpCLIP:	.BLK.8	LGGRECT		; rectangle de clipping pour mmorisation.
OsimgrpCLIPmin:	.BLK.16	1		; minimum ( x2-x1, y2-y1) de OsimgrpCLIP
OsimgrpOLDRGN:	.BLK.32	1		; sauvetage du contenu de rgnHandle entre OpenRgn et Close
LGsimgrp:



; En-tte du module
; -----------------

	.LOC	0
DEBUT:
	.16	GMI_FIRST		; code du 1er appel
	.16	GMI_LAST		; code du dernier appel
	.8	0			; nombre d'installations
	.FILL.8	(OHLREV-APC),0
	.8	REV,VERS		; rvision-version
	.32	FINCODE			; longueur
	.32	PATHLIB			; pattern de dbut
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"GRAMISC"		; nom du module
	.FILL.8	(LGHLIB-APC),0
				; liste d'appels:
	.16	_GMI_Mul32		; multiplication 64 bits
	.16	_GMI_Div32		; division 64 bits
	.16	_GMI_FixRatio		; conversion entier --> virgule fixe
	.16	_GMI_FixMul		; multiplication  virgule fixe
	.16	_GMI_FixDiv		; division signe  virgule fixe
	.16	_GMI_FixDivUnsigned	; division non-signe  virgule fixe
	.16	_GMI_FixDiv64		; division signe  virgule fixe d'un nombre 64 bits/32 bits
	.16	_GMI_AddPt		; addition de 2 points
	.16	_GMI_SubPt		; soustraction de 2 points
	.16	_GMI_PtInRect		; test d'appartenance d'un point  un rectangle
	.16	_GMI_MapPt		; recalcule un point dans la similitude entre 2 rectangles
	.16	_GMI_EmptyRect		; teste si un rectangle est vide
	.16	_GMI_InsetRect		; Corrige les dimensions d'un rectangle
	.16	_GMI_SectRect		; Intersection entre 2 rectangles
	.16	_GMI_UnionRect		; Union entre 2 rectangles
	.16	_GMI_PointsToRect	; Forme en rectangle de 2 points
	.16	_GMI_MapRect		; recalcule un rectangle dans la similitude entre 2 rectangles
	.16	_GMI_NewRgn		; cre une nouvelle rgion (demande l'identificateur)
	.16	_GMI_DisposeRgn		; rend un identificateur de rgion
	.16	_GMI_OpenRgn		; dbute la dfinition d'une rgion (ouvre)
	.16	_GMI_PutLine		; ajoute une droite  la rgion (ouverte)
	.16	_GMI_PutRLine		; ajoute une droite en coord. relle  la rgion (ouverte)
	.16	_GMI_PutRect		; ajoute un rectangle  la rgion (ouverte)
	.16	_GMI_PutOval		; ajoute une elipse  la rgion (ouverte)
	.16	_GMI_PutRgn		; ajoute une rgion  la rgion (ouverte)
	.16	_GMI_CloseRgn		; termine la dfinition d'une rgion (ferme)
	.16	_GMI_RgnBBox		; rend le "bounding box" et la nature de la rgion
	.16	_GMI_CopyRgn		; Copie une rgion dans une autre
	.16	_GMI_SetEmptyRgn	; Met une rgion comme vide
	.16	_GMI_SetRectRgn		; Met une rgion selon 4 coordonnes d'un rectangle
	.16	_GMI_RectRgn		; Met une rgion selon un rectangle
	.16	_GMI_OffsetRgn		; dplace une rgion
	.16	_GMI_InsetRgn		; dplace sparment les 4 frontires haut,gauche,bas,droite
	.16	_GMI_EmptyRgn		; teste si une rgion est vide
	.16	_GMI_EqualRgn		; teste si 2 rgions sont identiques
	.16	_GMI_OperRgn		; effectue une opration entre 2 rgions
	.16	_GMI_PtInRgn		; teste si le point se trouve dans la rgion
	.16	_GMI_RectInRgn		; teste si un rectangle est dans une rgion
	.16	_GMI_MapRgn		; recalcule une rgion dans la similitude entre 2 rectangles
	.16	_GMI_RgnToBitMap	; transforme une rgion en bitmap (mmoire)
	.16	_GMI_InitSrgn		; initialise une ligne de bitmap vide
	.16	_GMI_RelSRgn		; rend les variables de la ligne de bitmap
	.16	_GMI_InitColorSrgn	; initialise une ligne de PixMap vide


; Routines des appels
; -------------------

	.INS	GMIRGN.ASI		; rgions
	.INS	GMIRECT.ASI		; rectangles
	.INS	GMIPT.ASI		; points
	.INS	GMIMATH.ASI		; mathmatiques

FINCODE:
	.END
