MODULE testGmi;

FROM SYSTEM IMPORT ADDRESS,ADR;
FROM System IMPORT SysError;
IMPORT Gmi;

IMPORT Fos;
IMPORT Lib;
FROM Ascii IMPORT AsciiFf;
FROM Lib IMPORT MouseButtonEnum, LibDotMode;
CONST Cr = 15C;
VAR
  GMICanal: CARDINAL;
  Error: CARDINAL;
  ch:CHAR;


PROCEDURE AffMess(t: ARRAY OF CHAR);

VAR
  x,y: CARDINAL;
  
BEGIN
  Lib.LibGetCursor(x,y);
  Lib.LibSetCursor(0,y);
  Lib.LibWriteString("                                                  ");
  Lib.LibSetCursor(0,y);
  Lib.LibWriteString(t);
END AffMess;

PROCEDURE IfMouse(VAR p:Gmi.Point; VAR buttons: Lib.MouseButtonSet);

VAR
  x,y: CARDINAL;

BEGIN
  Lib.LibTestMouseMove(x,y,buttons);
  p.x:=INTEGER(x);
  p.y:=INTEGER(y);
END IfMouse;

PROCEDURE GetSpace();

VAR
  ch: CHAR;

BEGIN
  REPEAT
    Lib.LibGetChar(ch);
  UNTIL ch=" ";
END GetSpace;

PROCEDURE AffErr(err:CARDINAL);

BEGIN
  Lib.LibWriteError(err);
  GetSpace;
END AffErr;

PROCEDURE GetScreenBase():ADDRESS;

TYPE

atyp = ARRAY[0..(0F8H DIV 4)] OF ADDRESS;
pttyp = POINTER TO atyp;
artyp = ARRAY[0..3] OF CHAR;
locTyp = RECORD CASE: BOOLEAN OF
                 TRUE: a: pttyp;
               |FALSE: b: artyp;
             END;
         END;

VAR
  pt: locTyp;
  canal: CARDINAL;
  ptr: ADDRESS;
  ch: CHAR;
BEGIN
  Lib.LibGetDisplayChannel(canal);
  Fos.FosReadStatus(Fos.TypDis,canal,pt.b);
  ptr:=ADDRESS(pt.a^[0F8H DIV 4]);
  ptr:=ptr+ADDRESS(LONGCARD(1024D DIV 8)*((LONGCARD(pt.a^[08H DIV 4])) DIV 256D) DIV 256D);
  RETURN(ptr);
END GetScreenBase;

PROCEDURE DrawRect(VAR r:Gmi.Rect);

BEGIN
  IF ((r.Bottom>r.Top) AND (r.Right>r.Left)) THEN
    Lib.LibDrawRect(r.Left,r.Top,r.Right-r.Left-1,r.Bottom-r.Top-1,Invert);
  END;
END DrawRect;


PROCEDURE DrawPoint(VAR p:Gmi.Point);

BEGIN
  Lib.LibDrawSeg(p.x,p.y,1,0,Invert);
END DrawPoint;

PROCEDURE DrawSeg(VAR p1,p2:Gmi.Point);

BEGIN
  Lib.LibDrawSeg(p1.x,p1.y,p2.x-p1.x,p2.y-p1.y,Invert);
END DrawSeg;


PROCEDURE DrawRgn(VAR r:Gmi.RgnId; mode: Gmi.GraTransMode);

VAR
  bits: Gmi.BitMap;
  err: Gmi.PsosError;
  ch: CHAR;

BEGIN
  WITH bits DO
    BaseAddr:=GetScreenBase();
    RowBytes:=1024 DIV 8;
    Bounds.Top:=0;
    Bounds.Left:=0;
    Bounds.Right:=864;
    Bounds.Bottom:=900;
  END;
(*
  Lib.LibWriteHexLong(LONGCARD(r));
  REPEAT Lib.LibGetChar(ch) UNTIL ch=" ";
*)
  err:=Gmi.GmiRgnToBitMap(r,bits,mode);
END DrawRgn;

PROCEDURE DrawRgn1(VAR r:Gmi.RgnId; mode: Gmi.GraTransMode);

VAR
  bits: Gmi.BitMap;
  err: Gmi.PsosError;
  ch: CHAR;
  scanV: Gmi.ScanRgnVars;
  Func: Gmi.SeekSRgnProc;
  i: INTEGER;
  j: CARDINAL;
  ptm:ADDRESS;
  BBox: Gmi.Rect;

BEGIN
  IF Gmi.GmiRgnBBox(r,BBox) THEN
    WITH bits DO
      BaseAddr:=GetScreenBase();
      RowBytes:=1024 DIV 8;
      Bounds.Top:=0;
      Bounds.Left:=0;
      Bounds.Right:=864;
      Bounds.Bottom:=900;
    END;
    err:=Gmi.GmiInitColorSRgn(2,r,ADR(scanV),0,864,0,Gmi.Positive,Func);
    IF err#0 THEN AffErr(err); END;
    i:=0;
    REPEAT
      i:=Func(ADR(scanV),i,ptm);
      IF i<=900 THEN
        FOR j:=0 TO (1024 DIV 8)-1 DO
          ADDRESS(bits.BaseAddr+ADDRESS((1024D DIV 8)*LONGCARD(i))+ADDRESS(j))^:=
                                                                             ADDRESS(ptm+ADDRESS(j))^;
        END;
      END;
    UNTIL i>=900;
    err:=Gmi.GmiRelSRgn(ADR(scanV));
    IF err#0 THEN AffErr(err); END;
  ELSE
    DrawRect(BBox);
  END;
END DrawRgn1;

PROCEDURE ReadRect(str: ARRAY OF CHAR; VAR r:Gmi.Rect);

VAR
  buttons: Lib.MouseButtonSet;
  r2: Gmi.Rect;
BEGIN
  AffMess(str);
  REPEAT
    IfMouse(r.TopLeft,buttons);
  UNTIL LeftMouseButton IN buttons;
  r.Bottom:=r.Top;
  r.Right:=r.Left;
  r2:=r;
  REPEAT
    IfMouse(r.BottomRight,buttons);
    DrawRect(r2);
    DrawRect(r);
    r2:=r;
  UNTIL NOT (LeftMouseButton IN buttons);
  DrawRect(r);
  IF ((r.Bottom<r.Top) OR (r.Right<r.Left)) THEN
    WITH r DO
      Top:=0; Left:=0; Bottom:=0; Right:=0;
    END;
  END;
  AffMess("");
END ReadRect;


PROCEDURE ReadPoint(str: ARRAY OF CHAR; VAR p:Gmi.Point);

VAR
  buttons: Lib.MouseButtonSet;
  pd: Gmi.Point;
BEGIN
  AffMess(str);
  REPEAT
    IfMouse(p,buttons);
  UNTIL LeftMouseButton IN buttons;
  DrawPoint(p);
  REPEAT
    IfMouse(pd,buttons);
  UNTIL NOT (LeftMouseButton IN buttons);
  DrawPoint(p);
  AffMess("");
END ReadPoint;


PROCEDURE ReadRgn(str: ARRAY OF CHAR; VAR z:Gmi.RgnId);

VAR
  buttons: Lib.MouseButtonSet;
  p0,p1,p2,p2o: Gmi.Point;
  p1r,p2r: Gmi.RealPoint;
  r1: Gmi.Rect;
  err: Gmi.PsosError;
BEGIN
  AffMess(str);
  REPEAT
    IfMouse(p1,buttons);
  UNTIL (buttons=Lib.MouseButtonSet{ });
  REPEAT
    IfMouse(p1,buttons);
  UNTIL buttons#Lib.MouseButtonSet{ };

  r1.Top:=-32767;r1.Left:=-32767;r1.Bottom:=+32767;r1.Right:=+32767;
  err:=Gmi.GmiOpenRgn(z,Gmi.GFillXor,r1);
  AffMess("OK.Open");
  IF err#0 THEN AffErr(err); END;

  p2o:=p1;
  IF buttons=Lib.MouseButtonSet{LeftMouseButton} THEN
      p0:=p1;
      REPEAT
        REPEAT
          IfMouse(p2,buttons);
          DrawSeg(p1,p2o);
          DrawSeg(p1,p2);
          p2o:=p2;
        UNTIL NOT(LeftMouseButton IN buttons);
        (*
        err:=Gmi.GmiPutLine(z,p1,p2);
        *)
        p1r.y.Integer:=p1.y;
        p1r.y.Fract:=p2.y;
        p1r.x.Integer:=p1.x;
        p1r.x.Fract:=p2.x;
        p2r.y.Integer:=p2.y;
        p2r.y.Fract:=p1.y;
        p2r.x.Integer:=p2.x;
        p2r.x.Fract:=p1.x;
        err:=Gmi.GmiPutRLine(z,p1r,p2r);
        IF err#0 THEN AffErr(err); END;
        REPEAT
          IfMouse(p1,buttons);
        UNTIL buttons#Lib.MouseButtonSet{};
        p1:=p2;
      UNTIL RightMouseButton IN buttons;
      err:=Gmi.GmiPutLine(z,p2,p0);
      IF err#0 THEN AffErr(err); END;
  ELSIF buttons=Lib.MouseButtonSet{ MiddleMouseButton} THEN
      REPEAT
        IfMouse(p2,buttons);
        r1.TopLeft:=p1;
        r1.BottomRight:=p2o;
        DrawRect(r1);
        r1.BottomRight:=p2;
        DrawRect(r1);
        p2o:=p2;
      UNTIL NOT(MiddleMouseButton IN buttons);
      err:=Gmi.GmiPutOval(z,r1,r1.Right-r1.Left,r1.Bottom-r1.Top,Gmi.Positive);
      DrawRect(r1);
      IF err#0 THEN AffErr(err); END;
  ELSIF buttons=Lib.MouseButtonSet{RightMouseButton} THEN
      REPEAT
        IfMouse(p2,buttons);
        r1.TopLeft:=p1;
        r1.BottomRight:=p2o;
        DrawRect(r1);
        r1.BottomRight:=p2;
        DrawRect(r1);
        p2o:=p2;
      UNTIL NOT(RightMouseButton IN buttons);

      err:=Gmi.GmiPutRect(z,r1,Gmi.Positive);
      DrawRect(r1);
      IF err#0 THEN AffErr(err); END;
  END;
  err:=Gmi.GmiCloseRgn(z);
  AffMess("");
END ReadRgn;

PROCEDURE TInt():BOOLEAN;

VAR
  a,b,d: LONGCARD;
  c: Gmi.Cardinal64;
  over: BOOLEAN;
BEGIN
    Lib.LibWriteString("Donnez a: ");Lib.LibGetLongHex(a);
    Lib.LibWriteString("Donnez b: ");Lib.LibGetLongHex(b);
    c:=Gmi.GmiMul32(a,b);
    Lib.LibWriteString("c=a*b= ");Lib.LibWriteHexLong(c.Hi);
    Lib.LibWriteString(",");Lib.LibWriteHexLong(c.Low);
    Lib.LibWriteChar(Cr);

    Lib.LibWriteString("Donnez l'inc C: ");Lib.LibGetLongHex(b);
    c.Low:=c.Low+b;
    Gmi.GmiDiv32(c,a,b,d,over);
    Lib.LibWriteString("b=c/a= ");Lib.LibWriteHexLong(b);
    Lib.LibWriteString(", reste");Lib.LibWriteHexLong(d);
    IF over THEN Lib.LibWriteString("overflow"); ELSE Lib.LibWriteString("ok"); END;
    Lib.LibWriteChar(Cr);
    Lib.LibGetChar(ch); RETURN((ch="q"));
END TInt;


PROCEDURE TFixed():BOOLEAN;

VAR
  a,b: LONGCARD;
  A,B: INTEGER;
  c,d,e: Gmi.Fixed;
  f: Gmi.Fixed64;
  over: BOOLEAN;
BEGIN
    Lib.LibWriteString("Donnez a: ");Lib.LibGetLongHex(a);
    Lib.LibWriteString("Donnez b: ");Lib.LibGetLongHex(b);
    A:=a; B:=b;
    c:=Gmi.GmiFixRatio(a,b);
    Lib.LibWriteString("c=FixRatio(a/b)= ");Lib.LibWriteHexLong(LONGCARD(c));
    Lib.LibWriteChar(Cr);

    Lib.LibWriteString("Donnez a: ");Lib.LibGetLongHex(a);
    Lib.LibWriteString("Donnez b: ");Lib.LibGetLongHex(b);
    A:=a; B:=b;
    d:=Gmi.GmiFixRatio(a,b);
    Lib.LibWriteString("d=FixRatio(a/b)= ");Lib.LibWriteHexLong(LONGCARD(d));
    Lib.LibWriteChar(Cr);

    e:=Gmi.GmiFixMul(c,d);
    Lib.LibWriteString("e=FixMul(c,d)= ");Lib.LibWriteHexLong(LONGCARD(e));
    Lib.LibWriteChar(Cr);

    d:=Gmi.GmiFixDiv(e,c);
    Lib.LibWriteString("d=FixDiv(e,c)= ");Lib.LibWriteHexLong(LONGCARD(d));
    Lib.LibWriteChar(Cr);

    d:=Gmi.GmiFixDivUnsigned(e,c);
    Lib.LibWriteString("d=FixDivUnsigned(e,c)= ");Lib.LibWriteHexLong(LONGCARD(d));
    Lib.LibWriteChar(Cr);

    Lib.LibWriteString("Donnez f.Int: ");Lib.LibGetLongHex(a);
    Lib.LibWriteString("Donnez f.Fract: ");Lib.LibGetLongHex(b);
    f.Integer:=a; f.Fract:=b;

    d:=Gmi.GmiFixDiv64(f,c);
    Lib.LibWriteString("d=FixDiv64(f/c)= ");Lib.LibWriteHexLong(LONGCARD(d));
    Lib.LibWriteChar(Cr);

    Lib.LibGetChar(ch); RETURN((ch="q"));
END TFixed;



PROCEDURE TPoint(): BOOLEAN;
VAR
  r1,r2: Gmi.Rect;
  p1,p2,p3: Gmi.Point;
  buttons: Lib.MouseButtonSet;
  
BEGIN
  ReadRect("srcRect:",r1);
  DrawRect(r1);
  ReadRect("dstRect:",r2);
  DrawRect(r2);
  ReadPoint("p:",p1);
  DrawPoint(p1);
  
  p2:=p1;
  Gmi.GmiMapPt(p2,r1,r2);
  DrawPoint(p2);
  AffMess("MapPt p2,r1,r2:");
  GetSpace;
  
  p3:=Gmi.GmiAddPt(p1,p2);
  DrawPoint(p3);
  AffMess("p3=AddPt(p1,p2):");
  GetSpace;
  
  p3:=Gmi.GmiSubPt(p2,p1);
  DrawPoint(p3);
  AffMess("p3=SubPt(p2-p1):");
  GetSpace;
  
  p1.x:=-32767;
  p1.y:=-32767;
  p2.x:=+32767;
  p2.y:=+32767;
  p3:=Gmi.GmiSubPt(p2,p1);
  Lib.LibWriteString("SubPt(32767-(-32767)):");
  Lib.LibWriteHexWord(p3.y);   Lib.LibWriteHexWord(p3.x); 
  GetSpace;
  
  REPEAT
    IfMouse(p1,buttons);
    IF Gmi.GmiPtInRect(p1,r2) THEN
      AffMess("p1 In r2");
    ELSE
      AffMess("p1 Out r2");
    END;
  UNTIL Lib.LibTestKeyPress(ch);

  LOOP
    Lib.LibGetChar(ch);
    IF ch="q" THEN RETURN(TRUE); END;
    IF ch=" " THEN RETURN(FALSE); END;
  END;
  
END TPoint;

PROCEDURE TRect(): BOOLEAN;
VAR
  r1,r2: Gmi.Rect;
  p1: Gmi.Point;

BEGIN
  Lib.LibWriteChar(14C);
  ReadRect("Rect:",r1);
  DrawRect(r1);
  IF Gmi.GmiEmptyRect(r1) THEN Lib.LibWriteString("Empty"); ELSE Lib.LibWriteString("Not empty"); END;

  Gmi.GmiInsetRect(r1,-10,2,-20,5);
  DrawRect(r1);

  LOOP
    Lib.LibGetChar(ch);
    IF ch="q" THEN RETURN(TRUE); END;
    IF ch=" " THEN RETURN(FALSE); END;
  END;
  
END TRect;



PROCEDURE TRect1(): BOOLEAN;
VAR
  r1,r2,r3: Gmi.Rect;
  p1,p2: Gmi.Point;

BEGIN
  Lib.LibWriteChar(14C);
  ReadRect("srcRect1:",r1);
  DrawRect(r1);
  ReadRect("srcRect2:",r2);
  DrawRect(r2);
  IF Gmi.GmiSectRect(r1,r2,r3) THEN
    AffMess("SectRect:");
    DrawRect(r3);
  ELSE
    AffMess("No SectRect !");
  END;

  LOOP
    Lib.LibGetChar(ch);
    IF ch="q" THEN RETURN(TRUE); END;
    IF ch=" " THEN EXIT; END;
  END;

  AffMess("UnionRect:");
  Gmi.GmiUnionRect(r1,r2,r3);
  DrawRect(r3);

  LOOP
    Lib.LibGetChar(ch);
    IF ch="q" THEN RETURN(TRUE); END;
    IF ch=" " THEN EXIT; END;
  END;

  ReadPoint("p1:",p1);
  DrawPoint(p1);
  ReadPoint("p2:",p2);
  DrawPoint(p2);

  AffMess("PointsToRect:");
  Gmi.GmiPointsToRect(p1,p2,r3);
  DrawRect(r3);
  
  LOOP
    Lib.LibGetChar(ch);
    IF ch="q" THEN RETURN(TRUE); END;
    IF ch=" " THEN EXIT; END;
  END;

  ReadRect("srcRect:",r1);
  DrawRect(r1);
  ReadRect("dstRect:",r2);
  DrawRect(r2);
  ReadRect("TheRect",r3);
  DrawRect(r3);
  
  Gmi.GmiMapRect(r3,r1,r2);
  AffMess("MapRect:");
  DrawRect(r3);

  LOOP
    Lib.LibGetChar(ch);
    IF ch="q" THEN RETURN(TRUE); END;
    IF ch=" " THEN RETURN(FALSE); END;
  END;
  
END TRect1;


PROCEDURE TRgn(): BOOLEAN;
VAR
  z1,z2,z3: Gmi.RgnId;
  r1,r2: Gmi.Rect;
  p1: Gmi.Point;
  err: Gmi.PsosError;
  buttons: Lib.MouseButtonSet;
  
BEGIN
  Lib.LibWriteChar(14C);
  err:=Gmi.GmiNewRgn(z1);
  IF err#0 THEN AffErr(err); END;
  err:=Gmi.GmiNewRgn(z2);
  IF err#0 THEN AffErr(err); END;
  err:=Gmi.GmiNewRgn(z3);
  IF err#0 THEN AffErr(err); END;

  ReadRect("RectRgn1:",r1);
  Gmi.GmiRectRgn(z1,r1);
  DrawRgn(z1,Gmi.GMCopy);
  ReadRect("RectRgn2:",r2);
  Gmi.GmiRectRgn(z2,r2);
  DrawRgn(z2,Gmi.GMOr);

  IF Gmi.GmiEmptyRgn(z1) THEN Lib.LibWriteString("Empty"); ELSE Lib.LibWriteString("Not empty"); END;

  err:=Gmi.GmiInsetRgn(z1,-10,2,-20,5);
  IF err#0 THEN AffErr(err); END;
  DrawRgn(z1,Gmi.GMXor);

  LOOP
    Lib.LibGetChar(ch);
    IF ch="q" THEN RETURN(TRUE); END;
    IF ch=" " THEN EXIT; END;
  END;
  
  err:=Gmi.GmiOperRgn(z1,z2,z3,Gmi.GOpSect);
  IF err#0 THEN
    AffErr(err);
  ELSE
    DrawRgn(z3,Gmi.GMCopy);
    AffMess("Sect:");
  END;
  REPEAT Lib.LibGetChar(ch); UNTIL ((ch=" ") OR (ch="q"));
  IF ch="q" THEN RETURN(TRUE); END;

  err:=Gmi.GmiOperRgn(z1,z2,z3,Gmi.GOpUnion);
  IF err#0 THEN
    AffErr(err);
  ELSE
    DrawRgn(z3,Gmi.GMCopy);
    AffMess("Union:");
  END;
  REPEAT Lib.LibGetChar(ch); UNTIL ((ch=" ") OR (ch="q"));
  IF ch="q" THEN RETURN(TRUE); END;

  err:=Gmi.GmiOperRgn(z1,z2,z3,Gmi.GOpDiff);
  IF err#0 THEN
    AffErr(err);
  ELSE
    DrawRgn(z3,Gmi.GMCopy);
    AffMess("Diff:");
  END;
  REPEAT Lib.LibGetChar(ch); UNTIL ((ch=" ") OR (ch="q"));
  IF ch="q" THEN RETURN(TRUE); END;

  err:=Gmi.GmiOperRgn(z1,z2,z3,Gmi.GOpXor);
  IF err#0 THEN
    AffErr(err);
  ELSE
    DrawRgn(z3,Gmi.GMCopy);
    AffMess("Xor:");
  END;
  REPEAT Lib.LibGetChar(ch); UNTIL ((ch=" ") OR (ch="q"));
  IF ch="q" THEN RETURN(TRUE); END;

  REPEAT
    IfMouse(p1,buttons);
    IF Gmi.GmiPtInRgn(p1,z3) THEN
      AffMess("In");
    ELSE
      AffMess("Out");
    END;
  UNTIL Lib.LibTestKeyPress(ch);

  REPEAT
    ReadRect("RectInRgn:",r1);
    IF Gmi.GmiRectInRgn(r1,z3) THEN
      AffMess("In: SPACE encore, q stop");
    ELSE
      AffMess("Out: SPACE encore, q stop");
    END;
    REPEAT Lib.LibGetChar(ch); UNTIL ((ch=" ") OR (ch="q"));
  UNTIL ch="q";


  err:=Gmi.GmiDisposeRgn(z1);
  IF err#0 THEN AffErr(err); END;
  err:=Gmi.GmiDisposeRgn(z2);
  IF err#0 THEN AffErr(err); END;
  err:=Gmi.GmiDisposeRgn(z3);
  IF err#0 THEN AffErr(err); END;
  AffMess("Fin Test: q, SPACE: suivant");
  LOOP
    Lib.LibGetChar(ch);
    IF ch="q" THEN RETURN(TRUE); END;
    IF ch=" " THEN RETURN(FALSE); END;
  END;
END TRgn;


PROCEDURE TRgn1(): BOOLEAN;
VAR
  z1,z2,z3: Gmi.RgnId;
  r1,r2: Gmi.Rect;
  p1: Gmi.Point;
  err: Gmi.PsosError;
  buttons: Lib.MouseButtonSet;

BEGIN
  Lib.LibWriteChar(14C);
  err:=Gmi.GmiNewRgn(z1);
  IF err#0 THEN AffErr(err); END;
  err:=Gmi.GmiNewRgn(z2);
  IF err#0 THEN AffErr(err); END;
  err:=Gmi.GmiNewRgn(z3);
  IF err#0 THEN AffErr(err); END;

  ReadRgn("Rgn1:",z1);
  DrawRgn(z1,Gmi.GMCopy);
  ReadRgn("Rgn2:",z2);
  DrawRgn1(z2,Gmi.GMOr);
  
  Lib.LibWriteString(" BBox Rgn2: (");
  IF Gmi.GmiRgnBBox(z2,r1) THEN
    Lib.LibWriteString("Complex, ");
  ELSE
    Lib.LibWriteString("Rectangular, ");
  END;
  Lib.LibWriteHexWord(r1.Top); Lib.LibWriteString(";");
  Lib.LibWriteHexWord(r1.Left); Lib.LibWriteString(";");
  Lib.LibWriteHexWord(r1.Bottom); Lib.LibWriteString(";");
  Lib.LibWriteHexWord(r1.Right); Lib.LibWriteString(")");
  REPEAT Lib.LibGetChar(ch); UNTIL ((ch=" ") OR (ch="q"));

  r1.Top:=0;r1.Left:=0;r1.Bottom:=500;r1.Right:=500;
  err:=Gmi.GmiOpenRgn(z3,Gmi.GFillXor,r1);
  IF err#0 THEN AffErr(err); END;
  err:=Gmi.GmiPutRgn(z3,z1,Gmi.Positive);
  IF err#0 THEN AffErr(err); END;
  err:=Gmi.GmiPutRgn(z3,z2,Gmi.Positive);
  IF err#0 THEN AffErr(err); END;
  err:=Gmi.GmiCloseRgn(z3);
  IF err#0 THEN AffErr(err); END;
  DrawRgn(z3,Gmi.GMCopy);

  AffMess("PutRgn:, SPACE: suivant");
  GetSpace;
  
  err:=Gmi.GmiCopyRgn(z1,z3);
  IF err#0 THEN AffErr(err); END;
  DrawRgn(z3,Gmi.GMCopy);
  AffMess("CopyRgn z1,z3:, SPACE: suivant");
  GetSpace;
  
  err:=Gmi.GmiCopyRgn(z2,z3);
  IF err#0 THEN AffErr(err); END;
  DrawRgn(z3,Gmi.GMCopy);
  AffMess("CopyRgn z2,z3:, SPACE: suivant");
  GetSpace;
  
  IF Gmi.GmiEqualRgn(z1,z3) THEN AffMess("EqualRgn: z1=z3");
                         ELSE AffMess("EqualRgn: z1#z3");
  END;
  GetSpace;
  
  IF Gmi.GmiEqualRgn(z2,z3) THEN AffMess("EqualRgn: z2=z3");
                         ELSE AffMess("EqualRgn: z2#z3");
  END;
  GetSpace;
  
  Gmi.GmiOffsetRgn(z3,-20,+50);
  DrawRgn(z3,Gmi.GMCopy);
  AffMess("OffsetRgn z2,dh=-20,dv=+50:, SPACE: suivant");
  GetSpace;
  
  Gmi.GmiSetEmptyRgn(z3);
  IF Gmi.GmiRgnBBox(z3,r1) OR NOT(Gmi.GmiEmptyRect(r1)) THEN AffMess("SetEmptyRgn KO");
                                                  ELSE AffMess("SetEmptyRgn Ok");
  END;
  GetSpace;
  
  ReadRect("srcRect:",r1);
  DrawRect(r1);
  
  Gmi.GmiSetRectRgn(z3,r1.Left,r1.Top,r1.Right,r1.Bottom);
  DrawRgn(z3,Gmi.GMCopy);
  IF NOT(Gmi.GmiRgnBBox(z3,r1)) AND NOT(Gmi.GmiEmptyRect(r1)) THEN AffMess("SetRectRgn OK");
                                                        ELSE AffMess("SetRectRgn KO");
  END;
  GetSpace;
  
  
  ReadRect("dstRect:",r2);
  DrawRect(r2);
  ReadRgn("TheRgn",z1);
  
  err:=Gmi.GmiMapRgn(z1,r1,r2);
  IF err#0 THEN AffErr(err); END;
  
  DrawRgn(z1,Gmi.GMCopy);
  AffMess("MapRgn:");
  GetSpace;
  
  AffMess("Fin Test: q, SPACE: suivant");

  err:=Gmi.GmiDisposeRgn(z1);
  IF err#0 THEN AffErr(err); END;
  err:=Gmi.GmiDisposeRgn(z2);
  IF err#0 THEN AffErr(err); END;
  err:=Gmi.GmiDisposeRgn(z3);
  IF err#0 THEN AffErr(err); END;
  LOOP
    Lib.LibGetChar(ch);
    IF ch="q" THEN RETURN(TRUE); END;
    IF ch=" " THEN RETURN(FALSE); END;
  END;
END TRgn1;


VAR e,c,d:Gmi.Fixed;

BEGIN
    e:=Gmi.GmiFixMul(c,d);
  Lib.LibOpenLib("GRAMISC",Gmi.GmiFirst,GMICanal);
  Error:=SysError();
  IF Error # 0 THEN
    Lib.LibWriteError(Error);
  ELSE
    LOOP
(*
     IF TInt() THEN EXIT END;
     IF TFixed() THEN EXIT END;
     IF TPoint() THEN EXIT END;
     IF TRect() THEN EXIT END;
     IF TRect1() THEN EXIT END;
     IF TRgn() THEN EXIT END;
*)
     IF TRgn1() THEN EXIT END;
    END;
    
    Lib.LibCloseLib(GMICanal);
  END;

END testGmi.
