; $CALM:

	.TITLE	GRA.ASL

;	--------------------------------------
;		(C) 1986 - Daniel Roux
;	--------------------------------------

;	Module GRA utilisant le module GRA2.

;	Source du module SMA_GRA.LIB


	.PROC	M68000 		; mnmonics CALM
	.BASE	10'10		; base 10 par dfaut
;	.LAYOUT HEX		; listing en hexadcimal
	.START	-1

	.REF	SMAKY		; df diverses
	.REF	NTREL		; df noyau temps rel
	.REF	GESMEM		; df gestionnaire de mmoire
	.REF	DRIVERS		; df drivers
	.REF	DOLIB		; df modules LIB
	.REF	GRA2		; df module GRA2
	.REF	GRA		; module GRA
	.REF	GRAMISC		; df module GRAMISC
	.REF	LIB

;========================================================================
;ErLMNO	  = 16'8622		; "Module pas ouvert"
;========================================================================

	.REV	4,1
	.IDENT	"GRA utilisant GRA2, (C) 1991  EPSITEC-system SA"


; Constantes
; ----------

PCVAR	=	1
PCCODE	=	2

; En-tte du module LIB
; ---------------------

	.APC	PCCODE
	.LOC	0
	GRA_	FIRST		; code du premier appel
	GRA_	LAST		; code du dernier appel
	.8	0		; nombre d'installations
	.FILL.8	(OHLREV-APC),0
	.8	0,1		; rvision.version
	.16	0,END_GRA	; longueur
	.32	PATHLIB		; pattern de dbut
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"GRA"		; nom du module
	.FILL.8	(LGHLIB-APC),0

	.16	_GRA_RASTER
	.16	_GRA_MATRIX
	.16	_GRA_TRAME
	.16	_GRA_ROLLUP
	.16	_GRA_ROLLDOWN
	.16	_GRA_CLEAR
	.16	_GRA_LINE
	.16	_GRA_CIRCLE
	.16	_GRA_FILLO
	.16	_GRA_FILLC
	.16	_GRA_SPRITE
	.16	_GRA_DOT
	.16	_GRA_ELLIPSE
	.16	_GRA_EFLI
	.16	_GRA_EFEOS
	.16	_GRA_INV
	.16	_GRA_QIDOT
	.16	_GRA_QXDOT
	.16	_GRA_SET
	.16	_GRA_ROLLLEFT
	.16	_GRA_ROLLRIGHT
	.16	_GRA_CODEIMA
	.16	_GRA_DECOIMA
	.16	_GRA_HVDOT
	.16	_GRA_RLINE
	.16	_GRA_CRASTER
	.16	_GRA_GDOT
	.16	_GRA_QSDOT
	.16	_GRA_QCDOT


;	_GenCall <callName>

.MACRO	_GenCall
.LOCALMACRO EXIT, AGAIN
_GRA_%1:
	PUSH.32	{A2}+ODFCRG
	CLR.32	{A2}+ODFCRG
AGAIN:
	GRA2_	%1
	JUMP,NC	R8^EXIT
	COMP.16	#ErLMNO,D7
	JUMP,NE	R8^EXIT
	CALL	OpenGRA2
	JUMP,NC	AGAIN

EXIT:	POP.32	{A2}+ODFCRG
	TEST.16	D7
	RET
.ENDMACRO


;----------\\
; OpenGra2  >
;----------/

; Tente d'ouvrir le module GRA2.

; in	-
; out	D7.16	erreur
; mod	D7.16, F

OpenGRA2:
	PUSHM.32 D1|D3|A3

	MOVE.32	#R16^NomGRA2,A3
	MOVE.16	#GRA2_FIRST,D3
	LIB_	OPEN

	POPM.32	D1|D3|A3
	TEST.16	D7
	RET




;------------\\
; GRA_CODEIMA >
;============/

; Code une image.

; in	A3.32		^image non code
;	A4.32		^buffer codage (infrieur ou gal  #{A3}-IMLBUF)
;	A2.32		^entte du fichier image
; out	{A4}+++		buffer rempli avec l'image code
;	{A2}+OIMCOD	signale image code
;	{A2}+OIMNBB	longueur image code
;	D7.16		erreur
; mod	D7.16

_GRA_CODEIMA:

AGAIN$:	GRA2_	CODEIMA
	JUMP,NC R8^EXIT$

	COMP.16	#ErLMNO,D7
	JUMP,NE	R8^EXIT$
	CALL	OpenGRA2
	JUMP,NC	AGAIN$

EXIT$:	RET


;------------\\
; GRA_DECOIMA >
;============/

; Dcode une image.

; in	A3.32		^buffer image dcode (suprieur ou gal  #{A4}+IMLBUF)
;	A4.32		^image code
;	A2.32		^entte du fichier image
; out	{A3}+++		buffer rempli avec l'image dcode
;	{A2}+OIMCOD	signale image non code
;	{A2}+OIMNBB	longueur image non code
;	D7.16		erreur
; mod	D7.16

_GRA_DECOIMA:

AGAIN$:	GRA2_	DECOIMA
	JUMP,NC R8^EXIT$

	COMP.16	#ErLMNO,D7
	JUMP,NE	R8^EXIT$
	CALL	OpenGRA2
	JUMP,NC	AGAIN$

EXIT$:	RET



	_GenCall	RASTER
	_GenCall	MATRIX
	_GenCall	TRAME
	_GenCall	ROLLUP
	_GenCall	ROLLDOWN
	_GenCall	CLEAR
	_GenCall	LINE
	_GenCall	CIRCLE
	_GenCall	FILLO
	_GenCall	FILLC
	_GenCall	SPRITE
	_GenCall	DOT
	_GenCall	ELLIPSE
	_GenCall	EFLI
	_GenCall	EFEOS
	_GenCall	INV
	_GenCall	QIDOT
	_GenCall	QXDOT
	_GenCall	SET
	_GenCall	ROLLLEFT
	_GenCall	ROLLRIGHT
	_GenCall	HVDOT
	_GenCall	RLINE
	_GenCall	CRASTER
	_GenCall	GDOT
	_GenCall	QSDOT
	_GenCall	QCDOT


NomGRA2:.ASCIZE	"GRA2"

END_GRA:

	.END

