\define g_Fond:\nef11;
\define g_Evidence:\nbf09;
; $CALM:

	.TITLE	\g_Evidence;GRA2.ASL\g_Fond;

;----------------------------------------------------------------------
; Copyright
; (C) 1986..1991	Daniel ROUX, Jean-Michel PULFER & EPSITEC-system SA
; (C) 1992,'93		Pierre ARNAUD, Daniel MARMIER & EPSITEC-system SA
; (C) 1994,'95		Daniel MARMIER & EPSITEC-system SA
; (C) 1996		Daniel MARMIER & EPSITEC SA
; (C) 1997		Daniel MARMIER, Pierre ARNAUD, Michael WALZ & EPSITEC SA
;----------------------------------------------------------------------

;	Source des modules %M_GRA2.LIB.


	.BASE	10'10		; base 10 par dfaut
	.LAYOUT HEX		; listing en hexadcimal

	.REF	SMAKY		; df gnrales
	.REF	GRA2		; df module GRA2
	.REF	GRAMISC		; df module GRAMISC
	.REF	DOLIB		; df modules LIB
	.REF	MON		; df moniteur
	.REF	DISPLAYMAN

REVMAJ		= 9
REVMIN		= 12

TDM		= TRUE		; pour pouvoir assembler depuis SMILEC ...
TEST_FLIP	= TRUE		; pour tester affichage externe

	.IF	TDM
SM130		= TRUE		; Assemblage pour Smaky 130
SM196		= FALSE
SM300		= FALSE
SM324		= FALSE
	.ELSE
	.INS	TESTMACHINE.ASI
	.ENDIF

	.PROC	M68020

	.START	-1
	.REV	REVMAJ,REVMIN
	.IDENT	"Copyright (C) 1995 Daniel MARMIER & EPSITEC SA"


; Options d'assemblage
; --------------------

Debug			= FALSE;.OR.TRUE
DebugTrame		= FALSE;.OR.TRUE
SpriteMoveCleanly	= TRUE		; dplace les lutins proprement

; les modes suivants sont provisoires :

TILE_BUFFER_SIZE	= 10*1024

; Taille du buffer de travail pour un raster depuis/vers une organisation
; mmoire particulire (doit pouvoir contenir au moins une ligne).
; Le pire cas est l'Alpine en 1024x768x16M. Etendre selon besoins.

RASTER_BUFFER_SIZE	= 4*1024


; Date		Rv	Amliorations
;----------------------------------------------------------------------------------------------
; 10.02.98  PA	9.12	GRA_LINE avec traitills corrects aussi si dessin  l'envers.
; 15.11.97  PA	9.11	GRA_LINE teste correctement l'inclusion dans une fentre (GRACLIPLINE).
; 02.10.97  PA  9.10	Re-synchronisation des sources.
; 22.09.97  PA	9.9	Corrig petit problme avec traitills passant par TILE (clear ODFTPM).
; 15.09.97  PA	9.8	Dessin de traitills horizontaux et verticaux avec TILE.
; 10.09.97  MW  9.7	Implment le FILL pour 8 bits/pixel.
;			Le FILL 4 bits/pixel ne laisse plus de segment sur l'cran.
;			en cas de dbordement par la droite.
; 01.09.97  PA	9.6	Petite correction pour GRA_GETMEM.
; 12.08.97  PA	9.5	Rsultat de la fusion des sources PA/DM version 9.4
; 10.08.97  DM  9.4	Optimis SET/CLEAR/INV avec rgions GRAMISC
;           PA  9.4	Utilise les routines externes BlockInv et PixelInv.
;			Supporte GRA2_INV, TRAME 8x8 et raster tendu en SETDOT acclrs.
; 17.05.97  PA  9.3	Collabore  la mise  jour par $DIS de ODFABS/CAB/IIY.
; 12.04.97  PA	9.2	Correction dans TILE : taille du buffer est {A6}+TileBuffSize.
;			Remplac les ?GIVMEM restants par CALL GRA_GIVMEM.
; 03.02.97  PA	9.1	Correction pour clipping avec fonctions de dessin (odfDX/DY ok).
;			Ne bloque plus lorsque dx ou dy sont nuls avec BlockRead/BlockWrite.
; 04.12.96  DM	9.0	Clipping par rgion pour RASTER 1 -> 8/16/32 bits/pixels.
;			Clipping par rgion pour RASTER avec fonctions de dessin.
; 28.11.96  PA	8.9	Correction dans FILLC (rend une seule fois la mmoire).
; 14.11.96  DM  8.8	?
; 03.08.96  DM	8.7	?
; 19.05.96  DM  8.6	Indpendance d'org. mmoire, fonctions acclres.
;			TRAME avec motif en couleur.
;			Nouvel appel CONVERT pour conversions de pixelmaps  des
;			profondeurs diffrentes.
; 09.05.95  DM  8.5	Correction d'un bug dans RASTER 1 -> 8/16/32.
; 05.04.95  PA  8.4	Suppression du problme mmoire de GRA2 (compte GRA2 = MTYPBD).
; 24.02.95  DM	8.3	Gestion du curseur lors du dessin.
;			Message d'erreur lors d'un QXDOT.
; 24.01.95  DM	8.2	Corrig bug rcalcitrant dans TRAME.
;			Avanc Raster 1->8/16/32.
;			Corrig dbordement mmoire dans DECOIMA.
; 09.12.94  DM  8.1	Le 68000/68010 est abandonn (il faut un 68020 ou plus).
;			On fait de la couleur sur toutes les machines.
;			Suppression de tous les .IF obsoltes.
; 04.12.94  DM  8.0	Remplac GRATRAME.ASI par GRATILE.ASI (efficace dans le
;			cas gnral, plus besoin de mille routines spcifiques).
;----------------------------------------------------------------------------------------------
; 26.11.94  DM	7.3	Supprim routines efficaces trs spcifiques (LOADQ,
;			LOAD8 et LOADDM) rendues inutiles par COPY et MOVE.
;			Corrig le bug dit "du FILL", qui n'en tait pas un !
;			(dsaccord entre la doc et le module  propos de FILLC).
;			Optimis GRA2_SET/CLEAR : n'utilisent plus GRA2_TRAME
;			( moins qu'il y ait une rgion de clipping).
;			(Re-)Optimis les lignes horizontales simples.
;			Optimis le raster-op cran-cran en mode LOAD, sans
;			inversion/gris/rgion (cf. GRAMOVE:GRA_MOVE).
;			Optimis le raster-op en mode LOAD sans expansion (1->n)
;			ni inversion/gris/rgion (cf. GRAMOVE:Gra_Copy).
; 08.10.94  DM	7.2	RASTER/TRAME modifis selon PA.
; 20.08.94  DM	7.1	LOADDOT fait maintenant du SETDOT pour les oprations
;			autres que le raster-op.
; 09.08.93  DM	7.0	Version test pour machines multi-couleurs (sauf 2 bits/pixel).
;			Multiples changements, amliorations, corrections, simplifications.
;			Changements pour ODFCMD (d'o quelques incompatibilits logicielles ...)
;			  - c'est un champ d'information UNIQUEMENT
;			  - ODFCMD = 0 : la fentre est noir/blanc (ODFCNP = 1)
;			  - ODFCMD <> 0 : la fentre est couleur (ODFCNP <> 1)
;			Supression des tests sur l'adresse du pixmap pour dcider mono/couleur
;			  => les champs ODFC(MD, NP, NB, ...) doivent tre  jour !
;			GRA2_TRAME retouch : utilise vars globales, donc moins de pile
;			GRA2_TRAME multicouleur bon march (utilise RASTER_1TON, trs lent)
;----------------------------------------------------------------------------------------------
; 17.01.93  DM  6.9	Corrig bug de PA (si, si, a lui arrive aussi) : GRA2_RASTERC ne change
;			plus le mode si source ET destination sont couleur 1 bit
;			GRA2_RASTER utilise enfin des variables globales -> moins de pile.
; 03.11.92  PA  6.8	GRA2_EXTEND ajout : GRA2_LOCK et GRA2_UNLOCK permettent de bloquer tous
;			les appels GRA2 utilisant les variables globales (qui dessinent) !
; 22.10.92  PA	6.7	Modification de l'allocation de mmoire. Le compte "Window Manager" existe
;			maintenant (enfin) et se trouve en ODFBAS avec un compte de type MTYPUSER
;			(chercher @PA, fichiers GRAFILL et GRASPRITE).
; 05.08.92  PA	6.6	Correction de nombreux bugs (chercher @PA + commentaires hargneux)
;			GRA2_CIRCLE fonctionne enfin correctement.
;			GRA2_Q.DOT marchent correctement
;			GRA2_SPRITE corrig, marche en couleur
;			GRA2_CRASTER tient compte du mode d'affichage pour expansion 1 --> 4 bits
;			GRA2_TRAME et GRA2_RASTER fonctionnent en couleur 1 bit, c'est--dire que
;			l'on peut permuter les couleurs set et clear et avoir un cran invers !
; 12.06.92  DM  6.5	Mmoire prise sur compte "Window Manager" si GetMemWM=TRUE.
;			Correction des cercles et ellipses en multicouleurs.
;			Correction de la conversion 1->4.
;			GRA2_CIRCLE vraiment multicouleur.
;			GRA2_RLINE pseudo-multicouleur (utilise LINE).
;			GRA2_SPRITE multicouleur.
;			ChunkyColor supprim !
;			GRA2_RASTER fonctionne peut-tre en n -> n bits/pixel.
;			Restent  faire : RASTER 1 -> n, TRAME et FILL.
; 19.05.92  DM	6.4	Introduction de l'exclusion gnrale rapide.
;			GRA2_GDOT multicouleur.
;			GRA2_(S,C,I)DOT multicouleurs.
;			GRA2_HVDOT multicouleur et simplifi.
;			GRA2_(LINE,"CIRCLE",ELLIPSE) multicouleurs.
;			Correction : plus de remise  zro du compteur traitill si
;			objet affich en trait continu.
;			Zone ODFVAR+... du descripteur n'est plus utilise.
; 14.04.92  DM  6.3	Supression des .IF COLOR & .IF XORSimple pour plus de clart.
;			Utilisation de variables globales.
;			Chunky : la table d'expansion est construite au dmarrage,
;			d'o un gain d'environ 1K dans le binaire (et en ROM).
;			GMI_PtInRgn appel directement, devrait tre plus rapide.
; 12.04.92  PA	6.2	Ecriture d'une routine pour clipping rectangulaire de la source :
;			plus de problmes avec les lutins qui dbordent.
; 10.04.92  DM	6.1	Utilise SMAKY.REF.
;			Mode graphique supprim (!) avec KeepModGra = FALSE.
;			Test de dbordement forc avec KeepNoTest = FALSE.
;			Test de dbordement dans $DIS_0 forc avec KeepDis0OK = FALSE.
;			Correction de GRA2_(LINE,DOT,ELLIPSE) (rendent EQ/NE
;			en fonction de D7.16 et non plus de D0.32).
;			Correction de GRA2_LINE : les segements simples horizontaux
;			ou verticaux en couleur n'taient pas clipps.
;			Corrections de GRA2_Q(S,C,I)DOT :
;			  - contrle de dbordement
;			  - fonctionne si largeur <> 1024
;			  - utilise les rgions (ae !)
;			  - retourne EQ et D7.16 = 0.
; 06.03.92  PA	6.0	Mcanismes nouveaux pour le multi-fentrage et pour l'impression :
;			- grabbing de l'cran (routines donnes par {A2}+ODFPGRBEF et
;			  {A2}+ODFPGRAFT s'occupant de l'exclusion)
;			- dviation possible pour tous les appels
;			Correction dans RASTER_LOAD1 pour viter les dbordements de mmoire en
;			lecture.
;----------------------------------------------------------------------------------------------
; 03.03.92  PA	5.9	Nouvel assemblage pour systme 8.
; 11.02.92  PA  5.8	Version rassemble pour le systme 8.
; 15.10.91  PA  5.7	Correction GRA2_GDOT (fonctionne en noir & blanc).
;			Correction Q(S,I,C)DOT sur un 300 en mode noir & blanc.
; 26.09.91  PA	5.6	Nouveaux appels GRA2_QSDOT et GRA2_QCDOT. Remplacent QXDOT (aussi pour la
;			couleur chunky).
;			Appel GRA2_QXDOT supprim. Rend toujours A0=0.
;			Correction dans les rasters, plus de problmes si [dx]=0
; 22.01.91	5.3	Optimisation des droites simples horizontales/verticales en noir/blanc.
; 17.10.90	5.2	Introduction de ODFCMD=2 pour dessiner en couleur en mmoire. En
;			rsum: ODFCMD=0	-> on dessine en noir/blanc partout
;				ODFCMD=2	-> on dessine en couleur partout
;				autrement	-> en couleur dans les crans couleurs,
;						   en noir/blanc en mmoire.
; 03.10.90	5.1	Clipping lent introduit sur les cercles, les droites, les points
;			et HVDot.
; 01.10.90		Reste deux bugs dans les trames, une bug dans GRA_Raster
; 29.09.90		Premires apparitions de la couleur.
; 13.08.90	5.0	Couleur chunky 4 bits bricole par JMP.
;----------------------------------------------------------------------------------------------
; 21.11.89	4.1	pour nouveau GRAMISC en A440 !
; 10.08.89	4.0	clipping selon les rgions
;			GRA_RLINE nouvel appel (nb rels)
; 19.12.88	3.0	trame selon XTRAME (ODFTxx)
;			pinceau selon XPEN (ODFPxx)
;			traitill selon XMAPTT (ODFPTx)
; 16.11.88	2.5	GRA_DECOIMA correction effectue par DD
; 28.10.88	2.4	GRA_TRAME origine trame ok si ODFFX pas modulo 8
;			GRA_ELLIPSE ok avec clipping
;			GRA_LINE clipping  ODFFDX/Y (et non ODFFDX/Y +1 !)
;			GRA_MATRIX idem
;			GRA_HVDOT nouvel appel pour les grilles
;			clipping si pinceau et INVDOT ok
; 23.08.88	2.3	GRA_TRAME fait du clipping (toujours)
; 08.08.88	2.2	GRA_DECOIMA correction selon DD
; 02.05.88	2.1	GRA_FILL peut aller jusque dans les bords (ODFFLG:#BFFILA)
;			GRA_RASTER entirement refait
;			GRA_RASTER utilis pour caractres/scrolls/SAVWDO
;			GRA_TRAME entirement refait
;			GRA_TRAME utilis par GRA_CLEAR/SET/INV
;			GRA_TRAME supporte le mode LOADDOT
;			plus de modulo 8 en X ni de modulo 2 en Y !
;			ATTENTION: Iy multiple de 16 conseill !
;			masque coordonne pour 2048x2048 sur toutes les machines
;			GRA_RASTER fait du clipping (super)
;			pinceau avec "vrai" clipping
; 15.04.88	2.0	vive la couleur ...
; 25.02.88	1.12	GRA_LINE ultra-rapide si horizontal sans pinceau (6x plus rapide)
;			GRA_LINE rapide si vertical sans pinceau (2x plus rapide)
; 18.01.88	1.11	GRA_TRAME  possible en mmoire
;			GRA_CIRCLE possible en mmoire
; 22.12.87	1.10	GRA_MATRIX possible en mmoire
; 14.12.87	1.9	GRA_QIDOT ok si hauteur > 512
; 20.11.87	1.8	.IF PLUSBIG report selon BB
; 30.07.87	1.7	GRA_MATRIX avec "gris" et "invers" ok
; 25.02.87	1.6	GRA_MATRIX avec "gris"
; 24.09.86	1.5	GRA_SPRITE avec opration SPRITE_GETPOS
; 03.07.86	1.4	GRA_CODEIMA et GRA_DECOIMA
; 17.04.86	1.3	GRA_RASTER ok dans bitmap 1000x1000
; 15.02.86	1.2	GRA_ROLLLEFT et GRA_ROLLRIGHT
; 12.02.86	1.1	GRA_FILL possible en mmoire
;			GRA_LINE possible en mmoire
;			GRA_DOT  possible en mmoire
;			GRA_RASTER optimis si tout est modulo 8
; 13.01.86	1.0	GRA_FILL tout refait (9 x plus rapide)
;			GRA_TRAME tout refait (2 x plus rapide)
;----------------------------------------------------------------------------------------------



; Constantes
; ----------

_X	=	.BIT.4
_N	=	.BIT.3
_Z	=	.BIT.2
_V	=	.BIT.1
_C	=	.BIT.0

PCVAR	=	1
PCCODE	=	2
PCDEF	=	3

LGPENX	=	8		; largeur max du pinceau
LGPENY	=	8		; hauteur max du pinceau

MTYPGRA	= MTYPBD		; utilise compte du driver $DIS (normal)


.if 0
; Fonctions de dessin externes
; ----------------------------

		.LOC	0

oDrawLineRead:	.BLK.32	1
oDrawLineWrite:	.BLK.32	1
oDrawLineFill:	.BLK.32	1
oDrawBlockRead:	.BLK.32	1
oDrawBlockWrite:.BLK.32	1
oDrawBlockMove:	.BLK.32	1
oDrawBlockFill:	.BLK.32	1
oDrawPixelRead:	.BLK.32	1
oDrawPixelWrite:.BLK.32	1
LgDrawFuncs:
.endif

;@PA-begin
; Table de description d'une fentre (complments)
; ----------------------------------

		.LOC	LGDIS10

odfIY:		.BLK.16	1		; copie "invariable" de ODFY  (*)
odfIX:		.BLK.16	1		; copie "invariable" de ODFX  (*)
odfIDY:		.BLK.16	1		; copie "invariable" de ODFDY (*)
odfIDX:		.BLK.16	1		; copie "invariable" de ODFDX (*)
odfISM:		.BLK.8	1		; TRUE => souris silencieuse  (*)
odfNEWSWAP:	.BLK.8	1		; TRUE => remplace ODFCAB/IIY (**)
odfNEWIIY:	.BLK.16	1		; nouveau IIY  initialiser   (**)
odfNEWABS:	.BLK.32	1		; nouvelle adresse  mettre   (**)

; (*)	Ces champs sont utiliss par MOUSE et SMA_SMAKY !
; (**)	Ces champs sont utiliss par GRA2 !
;@PA-end

; Variables globales de GRA2
; --------------------------

		.APC	PCVAR
		.LOC	0
OVARCTR:				; copie de la trame pour FILL (8 bytes)
OVARIP:		.BLK.8	(1+8+1)*2	; zone pour pinceau en mode inverse
OVAROY:		.BLK.16	1		; ancien pinceau y
OVAROX:		.BLK.16	1		; ancien pinceau x

oQSemCnt:	.BLK.16	1		; compteur de smaphore rapide
oModeMove:	.BLK.16	1		; mode d'affichage pour {,X}PenXYMove{,T}

oDepth:		.BLK.8	1		; profondeur du pixmap o on dessine
oL2Depth:	.BLK.8	1		; log2 de cette profondeur
		.ALIGN	4
oSemID:		.BLK.32	1		; ID du smaphore pour l'exclusion gnrale
oGMI_PtInRgn:	.BLK.32	1		; ^routine GMI_PtInRgn
	
;	variables utilises par GRA2_CIRCLE/ELLIPSE
;	-------------------------------------------

CircOctants:	.BLK.16	1		; map des octants sur .16 parce que SL.16 <ea>
CircQuadrants:	.BLK.8	1		; compteur des quadrants  tracer
		.ALIGN	4
oColor:		.BLK.32	1		; couleur courante si pnurie de registres

;	variables utilises par GRA2_RASTER
;	-----------------------------------

OldA0:		.BLK.32	1		; ce que GRA_RASTER mettait autrefois dans A0

oTabExp4:	.BLK.32	256		; table d'expansion 1 -> 4
RastExpN:	.BLK.32	16*4		; table d'expansion 1 -> 8, 16, 32
oTabFgPixel:	.BLK.32	1		; pixel chair de la table courante
oTabBgPixel:	.BLK.32	1		; pixel fond de la table courante
oTabDepth:	.BLK.8	1		; profondeur de la table courante
oSrcCoul:	.BLK.8	1		;| source en couleur
oDstCoul:	.BLK.8	1		;| destination en couleur
					;! conscutifs dans cet ordre !
		.ALIGN	4
RastC0:		.BLK.32	1		; Couleur fond tendue sur 32 bits
RastC1:		.BLK.32	1		; Couleur chair tendue sur 32 bits
RastRBSC:	.BLK.32	1		; rowbytes source corrig
RastRBDC:	.BLK.32	1		; rowbytes destination corrig
RastNBL:	.BLK.16	1		; Nombre de lignes  traiter
RastBit1:	.BLK.16 1		; offset dans 1er longword source du 1er bit du motif
RastNBLast:	.BLK.16	1		;| nb de bits dans dernier byte - 1
RastNBFirst:	.BLK.16	1		;| nb de bits dans 1er byte - 1
					;! ces deux doivent se suivre !!!
RastMa1:	.BLK.16	1		; masque de dbut
RASTNBW:	.BLK.16	1		; nb de words -1
RASTIIX:	.BLK.16	1		; sens de parcour horizontal (+1/-1)
RASTRGR:	.BLK.8	1		; <>0 si rgion non rectangulaire
		.ALIGN	4
RASTPOY:	.BLK.16	1		; position en Y
RASTCHY:	.BLK.16	1		; prochain Y ayant un changement
RASTASK:	.BLK.32	1		; ^appel GMI_SEEKSRGN
RASTLSK:	.BLK.32	1		; ^ligne de masque
RASTBLDRGN:	.BLK.8	LgBldRgn
RastBuff:	.BLK.32	1		; ^buffers de travail
RastBuffSize:	.BLK.32	1		; taille d'un buffer
RastInitBuff:	.BLK.8	2*RASTER_BUFFER_SIZE ; buffers de travail initiaux


;	variables utilises par GRA2_TRAME
;	----------------------------------

TilePos:	.BLK.32	1		; position motif dans bitmap
TileDim:	.BLK.32	1		; dimensions du motif
TileAddr:	.BLK.32	1		; addresse du bitmap
TileOrig:	.BLK.32	1		; origine du motif
TileWidth:	.BLK.16	1		; largeur en bytes du bitmap

TrameMode:	.BLK.16	1		; mode d'affichage
TrameDim:	.BLK.32	1

BuffDim:	.BLK.32	1		; dimensions du buffer
BuffAddr:	.BLK.32	1		; adresse du buffer
BuffWidth:	.BLK.16	1		; largeur en bytes du buffer
TileBuff:	.BLK.8	TILE_BUFFER_SIZE
TileBuffSize:	.BLK.32	1
BuffFree:	.BLK.8	1
		.EVEN

.IF TEST_FLIP
FlipFuncs:	.BLK.8	LgDrawFuncs
.ENDIF

LgGlobVars:				; longueur de la tranche de variables


; En-tte d'un fichier .IMAGE
; ---------------------------

		.APC	PCVAR
		.LOC	0
OIMTYP:		.BLK.8	1		; H'01 = indique type image
OIMCOD:		.BLK.8	1		; H'00 = pas de codage, H'04 = codage
OIMBIP:		.BLK.8	1		; H'01 = 1 bit par point
OIMDIR:		.BLK.8	1		; H'02 = coord. X-Y comme cran
OIMDLX:		.BLK.16	1		; largeur image en points
OIMDLY:		.BLK.16	1		; hauteur image en points
OIMNBB:		.BLK.32	1		; nb de byte pour l'image
		.BLK.8	20		; rserve
LGHIMA:


; Table pour un lutin
; -------------------

MAXLU		= 16			; nb max de lutins

		.APC	PCVAR
		.LOC	0
OLUUSE:		.BLK.8	1		; 0/1 => lutin libre/ocup
OLUSET:		.BLK.8	1		; 0/1 => lutin teint/allum
OLUMSK:		.BLK.8	1		; 0/1 => lutin ailleur/masqu
		.EVEN
OLUNUM:		.BLK.16	1		; numro du lutin
		.ALIGN	4
OLUPTS:		.BLK.32	1		; ^matrice du lutin
OLUPTC:		.BLK.32	1		; ^matrice du fond
OLUPTF:		.BLK.32	1		; ^fond de l'cran
OLUPTO:		.BLK.32	1		; ^pour oprations

OLUOLD:		.BLK.32	1		; ancienne position
OLUNEW:		.BLK.32	1		; nouvelle position
OLUORI:		.BLK.32	1		; origine du mouvement

OLULGY:		.BLK.16	1		; hauteur du lutin
OLULGX:		.BLK.16	1		; largeur du lutin

OLUIYF:		.BLK.16	1		; Iy pour OLUPTF
OLUIYO:		.BLK.16	1		; Iy pour OLUPTO

LGLU:


; Champs privs du descripteur d'cran (ne pas exporter)
; ------------------------------------------------------

		.LOC	ODFVAR

odfChHwD:	.BLK.16	1		; canal FOS pour HWDIS
odfPFlags:	.BLK.8	1		; flags privs (copie de oMonSelMode)
; bMonSelNoBar	  = 0			  ; pas de barre du haut
; bMonSelNoSKey	  = 1			  ; pas de soft-keys

		.BLK.8	1		; rserve
odfChDM:	.BLK.32	1		; canal du display manager
odfPmId:	.BLK.32	1		; ID de pixmap
odfPDY:		.BLK.16	1		; hauteur du pixmap o est la fentre
odfPDX:		.BLK.16	1		; largeur du pixmap o est la fentre
odfBDraw:	.BLK.32	1		; routine de dbut de dessin du DM
odfEDraw:	.BLK.32	1		; routine de fin de dessin du DM
odfPDrawFuncs:	.BLK.32	1		; ^fonctions de dessin du DM



	.MACRO	dbtxt ;Texte
	.IF	Debug
	PUSH.16	F
	PUSHM.32 D3|D7
	MON	?AFTIM
	.ASCIZE	"{%1} "
;;;;	MON	?GETCAR
	POPM.32	D3|D7
	POP.16	F
	.ENDIF	Debug
	.ENDMACRO

	.MACRO	dbTRAP0
	.IF	DEBUG
	TRAP	#0
	.ENDIF
	.ENDMACRO

	.MACRO	dbW
	.IF	DEBUG
	PUSH.16	F
	PUSH.32	D4
	MOVE.16	%1,D4
	MON	?AFX4,?AFSPACE
	POP.32	D4
	POP.16	F
	.ENDIF
	.ENDMACRO

	.MACRO	dbL
	.IF	DEBUG
	PUSH.16	F
	PUSH.32	D4
	MOVE.32	%1,D4
	MON	?AFX8,?AFSPACE
	POP.32	D4
	POP.16	F
	.ENDIF
	.ENDMACRO

	.MACRO	dbTW ; "text", 16
	.IF	DEBUG
	PUSH.16	F
	PUSH.32	D4
	MON	?AFTIM
	.ASCIZE	%1
	MOVE.16	%2,D4
	MON	?AFX4,?AFSPACE
	POP.32	D4
	POP.16	F
	.ENDIF
	.ENDMACRO


; En-tte du module LIB
; ---------------------

	.APC	PCCODE
	.LOC	0


START:	.16	GRA2_FIRST		; code du premier appel
	.16	GRA2_LAST		; code du dernier appel
	.8	0			; nombre d'installations
	.FILL.8	(OHLREV-APC),0
	.8	REVMAJ,REVMIN		; rvision.version
	.16	0,END_GRA		; longueur
	.32	PATHLIB			; pattern de dbut
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"GRA2"			; nom du module
	.FILL.8	(LGHLIB-APC),0

	.16	CALL_RASTER
	.16	CALL_MATRIX
	.16	CALL_TRAME
	.16	CALL_ROLLUP
	.16	CALL_ROLLDOWN
	.16	CALL_CLEAR
	.16	CALL_LINE
	.16	CALL_CIRCLE
	.16	CALL_FILLO
	.16	CALL_FILLC
	.16	CALL_SPRITE
	.16	CALL_DOT
	.16	CALL_ELLIPSE
	.16	CALL_EFLI
	.16	CALL_EFEOS
	.16	CALL_INV

	.16	CALL_QIDOT
	.16	CALL_QXDOT
	.16	CALL_SET
	.16	CALL_ROLLLEFT
	.16	CALL_ROLLRIGHT
	.16	_GRA_CODEIMA
	.16	_GRA_DECOIMA
	.16	CALL_HVDOT
	.16	CALL_RLINE
	.16	CALL_RASTERC
	.16	CALL_GDOT
	.16	CALL_QSDOT
	.16	CALL_QCDOT
	.16	_GRA_SYSINIT
	.16	_GRA_EXTEND
	.16	_GRA_CONVERT


.MACRO	_SETZ
	COMP.8	D0,D0
.ENDMACRO

.MACRO	_CLRZ
	MOVE.16	#0,F
.ENDMACRO

.MACRO	_SETC
	MOVE.16	#_C,F
.ENDMACRO

.MACRO	_CLRC
	COMP.8	D0,D0
.ENDMACRO

.MACRO	UseDrawFuncs
.LOCALMACRO End
	TEST.32	{A2}+odfPDrawFuncs
	JUMP,F	R8^End
	TEST.16	{A2}+odfIIY		; dessin en mmoire ?
	NOTZ				; oui => n'utilise pas les fonctions
End:
.ENDMACRO

	.INS	GRACALLS.ASI	; initialisation & redirection des appels GRA
	.INS	GRAMIDLEVEL.ASI
	.INS	GRALLVL.ASI	; affichage externe

	.INS	GRACODIMA.ASI	; codage/dcodage d'une image
	.INS	GRARASTER.ASI	; raster-op gnral
	.INS	GRAMATRIX.ASI	; caractres
	.INS	GRATILE.ASI
	.INS	GRAMOVE.ASI	; dplacement de zones
	.INS	GRALINE.ASI	; lignes droites
	.INS	GRARLINE.ASI	; lignes droites relles
	.INS	GRACIRCLE.ASI	; cercles et arcs
	.INS	GRAFILL.ASI	; remplissage
	.INS	GRASPRITE.ASI	; lutins
	.INS	GRADOT.ASI	; traitement d'un point
	.INS	GRACLIP.ASI
	.INS	GRAMATH.ASI	; routines mathmatiques
	.INS	CONVERT.ASI

END_GRA:

	.END

