
	.PROC	M68020
	.REF	SMAKY
	.REF	MODULES

	.LOC	0
	.START	START

		.LOC	0
OVARCTR:				; copie de la trame pour FILL (8 bytes)
OVARIP:		.BLK.8	(1+8+1)*2	; zone pour pinceau en mode inverse
OVAROY:		.BLK.16	1		; ancien pinceau y
OVAROX:		.BLK.16	1		; ancien pinceau x
oQSemCnt:	.BLK.16	1		; compteur de smaphore rapide
oModeMove:	.BLK.16	1		; mode d'affichage pour {,X}PenXYMove{,T}
oLog2BPP:	.BLK.8	1		; X.SL.Log2BPP = X*ODFCNP
		.ALIGN	4
oSemID:		.BLK.32	1		; ID du smaphore pour l'exclusion gnrale
oGMI_PtInRgn:	.BLK.32	1		; ^routine GMI_PtInRgn
oColor:		.BLK.32	1		; couleur courante si pnurie de registres
OldA0:		.BLK.32	1		; ce que GRA_RASTER mettait autrefois dans A0
oTabExp4:	.BLK.32	256		; table d'expansion
LgGlobVars:				; longueur de la tranche de variables


		.LOC	0

START:
	LIB	?GETPDIS
	MOVE.32	A4,A2

	MOVE.32	{A2}+ODFPDE,A4
	MOVE.32	{A4}+6*4,A4		; A4 <-- ^display 6
	MOVE.32	#R16^CALL,A0
	MOVE.32	{A4}+ODFTPGR+(GRA2_QSDOT-GRA2_FIRST)*4,D4
	LIB	?AFX8
	EXIT

	MOVE.32	A0,{A4}+ODFTPGR+(GRA2_QSDOT-GRA2_FIRST)*4

	MOVE.32	#16'00640010,D4
	MOVE.32	#100,D3

LOOP$:	CALL	CALL
	INC.32	D4
	DEC.32	D3
	JUMP,NE	LOOP$

	MOVE.32	#R16^TOTO,A0

	EXIT
	

CALL:	PUSHM.32 D0|D1|D3|D4|A0|A3

	CLR.32	D3
	MOVE.16	D4,D3			; D3.32 <- X
	SWAP.32	D4			; D4.32 <- Y

	ADD.16	{A2}+ODFWBX,D3		; Corrige les coordonnes selon
	ADD.16	{A2}+ODFWBY,D4		; l'origine physique de la fentre
	MUL.16	{A2}+ODFIIY,D4		; offset ligne
	MOVE.32	{A2}+ODFAbs,A0		; ^cran
	ADD.32	D4,A0			; ^ligne

	MOVE.8	{A6}+oLog2bpp,D0
	SL.32	D0,D3			; transforme les pixels en bits
	MOVE.8	{A2}+ODFCNP,D0

	CALL	R8^_QSDOT
	MOVE	D1.32,{A0}:D3%D0	; crit le pixel

	MOVE.32	#R16^TOTO,A0
	MOVE.32	A6,{A0}

	POPM.32	D0|D1|D3|D4|A0|A3
	CLR.16	D7
	RET

_QSDOT:
	MOVE.32	{A2}+ODFCSF,D1		; couleur "set"
	RET

TOTO:	.32	0

	.END

