
	.PROC	M68000

	.REF	SMAKY
	.REF	MODULES
	.REF	MON

	.LOC	0
	.START	START


START:
	LIB	?GETPDIS

	MOVE.32	{A4}+ODFPDE,A4
	MOVE.32	{A4}+1*4,A4			; A4 <-- ^descripteur de $DIS_1

	MOVE.16	{A4}+ODFGRABCNT,D4
	LIB	?AFX4

	MOVE.32	{A4}+ODFGRABSEM,D4
	LIB	?AFSPACE
	LIB	?AFX8
	LIB	?AFCR
	LIB	?GETCAR

	PUSH.32	{A4}+ODFPGRBEF
	PUSH.32	{A4}+ODFPGRAFT

	MOVE.32	#R16^grabBEFORE,A0
	MOVE.32	#R16^grabAFTER,A1

	MOVE.32	A0,{A4}+ODFPGRBEF
	MOVE.32	A1,{A4}+ODFPGRAFT

	LIB	?AFTIM
	.ASCIZE	"Fonctions de grab actives.<CR>"
	LIB	?GETCAR

	MOVE.32	A4,A2
	CALL	qsLOCK


	LIB	?AFTIM
	.ASCIZE	"Grab effectif.<CR>"
	LIB	?GETCAR

	CALL	qsUNLOCK

	LIB	?AFTIM
	.ASCIZE	"Fonctionnement normal.<CR>"

	POP.32	{A4}+ODFPGRAFT
	POP.32	{A4}+ODFPGRBEF

	EXIT


grabBEFORE:
	MON	?AFTIM
	.ASCIZE	"B"
	CALL	qsLOCK
	MON	?AFTIM
	.ASCIZE	"b"
	RET

grabAFTER:
	MON	?AFTIM
	.ASCIZE	"A"
	CALL	qsUNLOCK
	MON	?AFTIM
	.ASCIZE	"a"
	RET



qsLOCK:
	INC.16	{A2}+ODFGRABCNT		; un proc. de plus en attente
	JUMP,EQ	R8^QLocked$		; si seul => verrouillage rapide effectu
	PUSH.32	A5
	MOVE.32	{A2}+ODFGRABSEM,A5	; ID du smaphore pour l'exclusion gnrale
	NTREL	?WAITEV			; attendons notre tour
	JUMP,EQ	R8^Locked$		; si c'est OK => verrouillage lent effectu
	PUSH.32	D4
	MOVE.32	#-1,D4			; timeout infini
	NTREL	?MODTIM			; change le timeout (ancien -> D4)
	NTREL	?WAITEV			; verrouillage trs lent effectu
	NTREL	?SETTIM			; restitue le timeout initial
	POP.32	D4
Locked$:
	POP.32	A5
QLocked$:
	CLR.16	D7
	RET


qsUNLOCK:
	PUSH.16	D7
	DEC.16	{A2}+ODFGRABCNT		; un proc. de moins dans zone d'exclusion
	JUMP,CS	R8^Unlocked$		; si seul => dverrouillage rapide effectu
	PUSH.32	A5
	MOVE.32	{A2}+ODFGRABSEM,A5	; ID du sma.
	NTREL	?SIGNEV			; signale fin d'exclusion
	POP.32	A5
Unlocked$:
	POP.16	D7
	RET


	.END
