\define g_Fond:\nef11;
\define g_Evidence:\nbf09;

	.TITLE	\g_Evidence;ICOLOR\g_Fond;.ASL

;	--------------------------------------
;		(C) 1990 - Daniel Roux
;	--------------------------------------

;	Source du module SMA_ICOLOR.LIB

;	Modifications :
;	
;	(C) 1991-1997 - Pierre ARNAUD, OPaC bright ideas

MAJREV	= 2
MINREV	= 1

;	Date		Amliorations
; ---------------------------------------------------------------------------------------------
; 2.1	02.09.97   PA	Incrments plus petits pour le choix d'une couleur.
;			Annule possible lors de l'dition de la CLUT.
; 2.0	12.08.97   PA	OK avec systme 10.7 en noir & blanc.
; 1.9	25.04.97   PA	Petite correction dans CRSLPUT pour SM300.
; 1.8	31.08.96   PA	ICOL_HILITE utilise nettement moins de pile.
; 1.7	30.08.96   PA	ICOL_MODCRET met  jour les couleurs de DBOX.
; 1.6	28.08.96   PA	ICOL_CONVC plus de problme si largeur impaire.
; 1.5	10.08.96   PA	ICOL_CONVC ne pioche plus directement dans l'cran.
;			IOSAVECRET corrig (n'crase plus la fin de la CLUT).
; 1.4	06.08.96   PA	Modifi l'interface pour > 8 bpp
; 1.3	03.08.96   PA	ICOL_CONVC fonctionne aussi pour filtrer du 8 bpp.
;			ICOL_HILITE fonctionne aussi avec du 8 bpp.
; 1.2	01.08.96   PA	Accs  la palette interdit si pas de palette.
; 1.1	22.05.95   PA	Corrig petite erreur dans PREND/SAUVE de cluts.
; 1.0	09.05.95   PA	Modifi pour gestion de la couleur en monochrome.
;			En fait, l'dition des couleurs en monochrome conduit  la cration de
;			dfinitions CRET valables uniquement en monochrome...
; 0.14	25.04.95   PA	Rajout mode BICHIINV pour ICOL_HILITE.
; 0.13	19.04.95   PA	Rajout mode BICCCLUT pour ICOL_CONVNB.
;			ICOL_CONVNB supporte des images de largeur non multiple de 8.
;			ICOL_CONVNB utilise une conversion RGB -> intensit pondre.
; 0.12	01.03.95   PA	Rajout l'appel ICOL_HILITE.
; 0.11	28.01.95   PA	Traduction des sources en CALM.
; 0.10	18.09.91   PA	Modifi l'appel ICOL_MODCRET pour permettre aux	utilisateurs de griser
;			la touche "SAUVE" ou de sauver eux-mmes la CLUT et la CRET active.
;			Dplac une table en fin de code pour viter les problmes de PREFETCH
;			Quelques MOVE.W transforms en MOVEQ.L !
; 0.9	16.08.91	CLUT: ascenseurs ok si prend
; 0.8	08.05.91	BICKHELP: affiche le raccourci clavier
; 0.7	07.05.91	type "COLO" -> "RGB" pour le bloc-notes
;			colle: accepte le type "TEXT"
;			CLUT: empche de modifier blanc/noir !
; 0.6	21.02.91	sauvetage .CRET corrig
; 0.5	15.02.91	copier/coller dans ICOL_MODRGB
;			double-clic dans ICOL_MODRGB (pour sortir)
; 0.3	01.02.91	copier/coller avec le classeur
; 0.2	27.11.90	modes BICMTEXT et BICMEDIT pour ICOL_MODRGB
; 0.1	16.11.90	dbut des travaux ...
; ---------------------------------------------------------------------------------------------



	.PROC	M68000
	.BASE	10'10

	.REF	SMAKY
	.REF	DBOX
	.REF	SCROLL
	.REF	DOLIB
	.REF	BLOC
	.REF	ICOLOR
	.REF	TCOLOR
	.REF	COLORS
	.REF	GRA2
;	.REF	MON

	.REV	MAJREV,MINREV
	.IDENT	"(C)  Daniel ROUX, Pierre ARNAUD et EPSITEC SA"



; Assemblage conditionnel
; -----------------------

COUL256		= 0			; 0 = 16 couleurs et 1 = 256 couleurs (PROVISOIRE)


; Constantes
; ----------

PCCODE		= 1
PCVAR		= 2

BNTRGB		= 16'1000000*"R"+16'10000*"G"+16'100*"B"+16'1*SPACE

	.IF	COUL256
NBCOUL		= 256
	.ELSE
NBCOUL		= 16
	.ENDIF

MAXWIDTH	= 2048
LBUDIS		= MAXWIDTH*4		; lg max de OBUDIS

DEGNBX		= 9			; dgrad: nb horizontalement
DEGNBY		= NBCOUL-1		; dgrad: nb verticalement

LBUNAME		= 200			; lg max d'un nom de fichier
KEYDBOX		= 16'7E00		; "touche" spciale




; Description des variables
; -------------------------

		.APC	PCVAR
		.LOC	0
OCCMO:		.BLK.8	1		; 1 => souris enleve
OSYS105:	.BLK.8	1		; 1 => systme 10.5 (ou mieux)
		.EVEN
OBUDIS:		.BLK.8	LBUDIS		; buffer write display

OPALPY:		.BLK.16	1		; palette: position en Y
OPALPX:		.BLK.16	1		; palette: position en X
OCURPY:		.BLK.16	1		; curseur: position en Y
OCURPX:		.BLK.16	1		; curseur: position en X

OCOLR:		.BLK.16	1		; couleur rouge
OCOLG:		.BLK.16	1		; couleur vert
OCOLB:		.BLK.16	1		; couleur bleu

OFAN:		.BLK.32	1		; fanions
OSCVAR:		.BLK.8	LSCVAR*3	; variables trois ascenseurs
OSLVAR:		.BLK.8	LSLVAR		; variables scroll-liste

OIDCRET:	.BLK.32	1		; id. CRET temporaire
OPTTEXT:	.BLK.32	1		; ^table des textes
OPTNAME:	.BLK.32	1		; ^nom du logiciel
OPTSAVE:	.BLK.32	1		; ^routine "SAUVE" (si existe)
OPTVAR:		.BLK.32	1		; ^variables de l'utilisateur

OBUCLUT:	.BLK.8	LBUNAME		; nom fichier .CLUT
OBUCRET:	.BLK.8	LBUNAME		; nom fichier .CRET
OBUFILTRE:	.BLK.8	256		; buffer pour le filtre

OCONVPOS:	.BLK.16	2		; origine dans l'cran
OCONVDIM:	.BLK.16	2		; taille dans l'cran
OCONVMODE:	.BLK.32	1		; mode utilis
OCONVTABLE:	.BLK.32	1		; ^table de conversion
OCONVDEPTH:	.BLK.16	1		; profondeur
OCONVIIY:	.BLK.16	1		; iiy pour le buffer
OCONVDY:	.BLK.16	1		; nb de lignes  traiter d'un coup
OCONVINC:	.BLK.16	1		; incrment vertical
OCONVUSE:	.BLK.8	1		; TRUE => utilise ce buffer
		.ALIGN	4

lgCLUTCOPY	= LCTHEAD+16*LCTDATA

OCLUTMODE:	.BLK.32	1		; mode  utiliser
OCLUTCOPY:	.BLK.8	lgCLUTCOPY	; place pour 16 couleurs

LGVAR:




; En-tte du module LIB
; ---------------------

	.APC	PCCODE
	.LOC	0

DEBUT:
	ICOL_	FIRST			; code du premier appel
	ICOL_	LAST			; code du dernier appel
	.8	0			; nombre d'installations
	.FILL.8	(OHLREV-APC),0
	.8	MAJREV,MINREV		; rvision.version
	.16	0,END_ICOLOR		; longueur
	.32	PATHLIB			; pattern de dbut
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"ICOLOR"		; nom du module
	.FILL.8	(LGHLIB-APC),0

	.16	_ICOL_INIT
	.16	_ICOL_MODRGB
	.16	_ICOL_MODCRET
	.16	_ICOL_MODCLUT
	.16	_ICOL_RGBHSV
	.16	_ICOL_HSVRGB
	.16	_ICOL_CONVC
	.16	_ICOL_CONVNB
	.16	_ICOL_HILITE


; Codes des appels
; ----------------


;-----------\\
; _ICOL_INIT >
;===========/

; Initialise CLUT/CRET pour un logiciel donn.
;
; Effectue la lecture du fichier suivant :
;
;	si BICCRET	nom.CRET  -->	CLUT+CRET
;	si BICCLUT	nom.CLUT  -->	CLUT
;
; Ne pas mettre BICCRET et BICCLUT (l'un ou l'autre) !

; in	A0.32	^descripteur fentre
;	A3.32	^nom du logiciel (DESSIN4, PAGE, etc.)
;	D3.32	mode (BIC*)
;		 BICCRET --> charge le fichier .CRET
;		 BICCLUT --> charge le fichier .CLUT
;		 BTCGLOB --> CLUT/CRET globale
;	A5.32	^table des textes pour la CRET (*)
; out	D5.32	identificateur CRET (zro si rien)	(si D3:#BICCRET)
;	D7.16	erreur
; mod	D5.32, D7.16

_ICOL_INIT:
	PUSHM.32 D2..D4|D6|A2..A4|A6

	CALL	VAROPEN			; A6 <-- ^variables
	JUMP,NE	ERFAT$

	MOVE.32	A5,{A6}+OPTTEXT		; OPTTEXT <-- ^table des textes
	CLR.32	{A6}+OIDCRET		; OINIIC <-- pas d'id.
	MOVE.32	D3,D2			; D2 <-- mode

	CALL	IONAMECRET		; A3 <-- ^nom .CRET

	MOVE.32	{A0}+ODFCPF,D6		; D6 <-- canal TCOLOR

	TEST.32	D2:#BICCRET		; charge le fichier .CRET ?
	JUMP,BC	CLUT$			; non => suite..


	MOVE.32	D2,D3			; D3 <-- mode d'ouverture
	MOVE.32	#{A6}+OBUCRET,A3	; A3 <-- ^nom construit
	TSET.32	D3:#BTCNAME
	TCOL_	LOADCRET		; D5 <-- id. de la CRET lue
	JUMP,EQ	R8^CLADD$

	MOVE.32	#R16^TCRETVIDE,A3
	MOVE.32	D2,D3
	TSET.32	D3:#BTCTABLE
	TCLR.32	D3:#BTCNAME
	TCOL_	LOADCRET		; D5 <-- id. de la CRET vide
	JUMP,NE	R8^EXIT$

CLADD$:	MOVE.32	D2,D3
	TCOL_	ADDCRET			; rend la CRET lue active
	MOVE.32	D5,{A6}+OIDCRET		; OIDCRET <-- identificateur CRET

	CALL	CRINIT			; initialise la CRET
	CLR.16	D7			; D7 <-- ok
	JUMP	R8^EXIT$


CLUT$:	CLR.16	D7			; D7 <-- ok
	TEST.32	D2:#BICCLUT		; charge le fichier .CLUT ?
	JUMP,BC	R8^EXIT$

	MOVE.32	D2,D3			; D2 <-- mode d'ouverture d'origine
	MOVE.32	#{A6}+OBUCRET,A3	; A3 <-- ^nom construit .CRET
	MOVE.32	#R16^EXT$,A4
	MOVE.32	#1,D3
	LIB	?ADDEXT			; force l'extension .CLUT

	MOVE.32	D2,D3
	TSET.32	D3:#BTCNAME
	TCLR.32	D3:#BTCTABLE

	TCOL_	LOADCLUT		; lit la CLUT active

EXIT$:	MOVE.32	{A6}+OIDCRET,D5		; D5 <-- identificateur CRET

	CALL	VARCLOSE		; libre les variables

ERFAT$:	POPM.32	D2..D4|D6|A2..A4|A6
	TEST.16	D7			; retour EQ/NE
	RET


EXT$:	.ASCIZ	".CLUT"
	.EVEN


	.INS	ICOLCRET.ASI
	.INS	ICOLRGB.ASI
	.INS	ICOLCLUT.ASI
	.INS	ICOLDBOX.ASI
	.INS	ICOLCHOIX.ASI
	.INS	ICOLICONE.ASI
	.INS	ICOLIO.ASI
	.INS	ICOLHSV.ASI
	.INS	ICOLCONV.ASI
	.INS	ICOLMISC.ASI
	.INS	ICOLHILITE.ASI


TCRETVIDE:
	.8	CRTYPE,0		; type
	.32	0*10			; longueur
	.16	0			; nb de couleurs
	.FILL.8	24,0			; reste de l'en-tte

END_ICOLOR:


	.END

