	.TITLE	LIST.ASL

	.PROC	M68000 			; mnmonics CALM
	.BASE	10'10			; base 10 par dfaut
	.LAYOUT	HEX			; listing en hexadcimal

	.REF	SMAKY
	.REF	MODULES
	.REF	PLAN
	.REF	MON

MAJREV	= 7				; rvision
MINREV	= 3				; version

PCCODE	= 0
PCVAR	= 1


; Date		Rev	Amliorations
; -------------------------------------------------------------------------------------------
; 22.09.97  PA	7.3	Visualise le texte plus rapidement sur les cartes acclres.
; 25.04.97  PA	7.2	Fonctionne aussi avec un ancien LIB (sans ?LOCKLIB/?UNLOCKLIB).
;			Petite correction pour SM300.
; 08.02.97  PA	7.1	Elimin ?COLORPUSH/POP inutiles dans BUILDCONV.
; 11.01.97  PA	7.0	Ncessite LIB 10.16 (?LOCKLIB/?UNLOCKLIB).
; -------------------------------------------------------------------------------------------
; 03.06.96  PA	6.5	Fonctionne maintenant aussi en "n" bpp
; 19.04.96  PA	6.4	Ne plante plus si l'en-tte d'un .GENC est court
; 30.09.95  PA	6.3	Rend la mmoire au VISUCLOSE (distraction...)
; 18.06.95  PA	6.2	Corrige un bug de GRA2_CRASTER pour 300 dans COLORSHOW.
; 02.05.95  PA	6.1	Ne liste plus les units caches.
; 18.04.95  PA	6.0	Il sera possible de visualiser n'importe quel type de fichier grce
;			 des "viewers" externes *** TRAVAUX EN COURS ***
;			Les images couleur sont transformes en monochrome si ncessaire.
; -------------------------------------------------------------------------------------------
; 18.04.95  PA	5.20	LIST_VISU: correction de problmes GESMEM, utilise un compte unique.
;			LIST_VISO: utilise des tables de saut pour les divers types.
;			Optimisations diverses pour diminuer la taille (gagn 402 bytes).
; 28.02.95  PA	5.19	Traduction en CALM, petites optimisations, buffer plus grand, etc.
;			Gre la couleur de fond comme pour "scroll-list".
; 30.11.92	5.18	LIST_VISU: visualise les fichiers .PAGE/.LPAGE si rev > 4.0b
; 07.02.92	5.17	LIST_VISU: accepte images "~IMAGE", etc.
;			LIST_OPEN: liste units physiques pour SMACK ...
; 20.12.91	5.16	LIST_DBOX: accepte double-clic
;			LIST_DBOX: (DOSSIER COURANT) remplac par une jolie icne
;			LIST_OPEN: n'accepte plus de lister les units physiques
; 20.02.91	5.15	LIST_VISU: affiche aussi les images couleurs (.COLOR)
;			LIST_DBOX: accepte un critre *.COLOR|*.IMAGE
; 06.03.90	5.14	LIST_DBOX: ok si zro fichiers/dossiers
; 05.07.89	5.13	LIST_VISU: affiche aussi les *00.GENC (avec XCAR_SHOWF)
; 23.06.89	5.12	LIST_NEXT: met les noms physiques en sens inverse de ?VLOGIC
; 09.06.89	5.11	LIST_VISU: si binaire, option "dtail"
; 05.06.89	5.10	LIST_VISU: affiche aussi les fichiers binaires
; 28.04.89	5.9	LIST_VISU: ok avec les gencars analytiques (SMA_*00.GENC)
; 06.03.89	5.8	LIST_NEXT: FOS,?VLOGIC avec A3=0 !
; 28.02.89	5.7	LIST_VISU: ngatif grandes images ok
; 24.11.88	5.6	LIST_VISU: ok si largeur image pas multiple de 8
; 26.10.88	5.5	LIST_NEXT: si ASSIGN @.. @.. => montre toujours
; 06.10.88	5.4	LIST_NEXT: FOS,?VLOGIC dborde son buffer (?)
;			LIST_NEXT: ne liste plus si #TOTO: TITI: (dossier)
;			LIST_DBOX: si affiche .DI => message "Affichage impossible"
;			LIST_VISU: HEAD = nouvel appel
; 08.07.88	5.3	LIST_DBOX: (DOSSIER PAR DEFAUT) --> (DOSSIER COURANT)
;			LIST_DBOX: ne montre jamais DOSSIER:
;			LIST_DBOX: si on est dans dossier courant => rend nom tout nu !
; 05.07.88	5.2	LIST_DBOX: si changement de type => PREND gris
; 01.07.88	5.1	LIST_DBOX: changement d'unit physique ok
;			LIST_DBOX: ne liste plus fichiers/dossiers cachs
; 02.06.88	5.0	LIST_VISU: nouvel appel
;			LIST_DBOX: entirement refait ...
; -------------------------------------------------------------------------------------------
; 25.05.88	4.6	LIST_PUTFILE: nouvel appel
; 21.10.87	4.5	LIST_DELETE: utilise DBOX_DETRUIT
; 12.09.87	4.4	LIST_DBOX: petite correction pour FICHE
; 04.09.87	4.3	LIST_MODIF: supprim !
; 24.06.87	4.2	LIST_DBOX: pages dans l'ascenseur
; 16.12.86	4.1	nouvel appel LIST_NBMAX
;			LIST_DBOX: n'est plus limit  100 fichiers
;			LIST_DBOX: supprime monte/descend dans (Fn)
; 12.12.86	4.0	utilise les listes du FOS
; -------------------------------------------------------------------------------------------



	.REV	MAJREV,MINREV
	.IDENT	"(C)  Daniel ROUX et EPSITEC-system sa"




; Constantes
; ----------

KEYDBOX		= 16'7E00			; "touche" pour dbox

LMFILE		= 200				; lg max d'un nom de fichier

NBLI		= 12				; nb fichiers/ligne
LGSUITE		= 12				; lg aprs un nom de fichier
LGMFILE		= 41				; lg max nom fichier  modifier


		.APC	PCVAR

; Variables pour LIST_OPEN/NEXT/CLOSE
; -----------------------------------

LLINAM		= LMFILE
LLIUVL		= 2000

		.LOC	0
OLIREP:		.BLK.8	LLINAM			; nom de rpertoire
OLICRI:		.BLK.8	LLINAM			; critre de recherche
OLIPCR:		.BLK.32	1			; ^critre donn par l'utilisateur
OLIMOD:		.BLK.32	1			; modes (BOPSYS, BOPNEXT, etc.)
OLICH:		.BLK.32	1			; canal liste du FOS
OLIOP:		.BLK.16	1			; option (0..n)
OLINBM:		.BLK.16	1			; nb max de fichiers
LGVAR:

OLIUAR:		.BLK.8	LGARGS			; units physiques: arguments
OLIUPT:		.BLK.32	1			; units physiques: ^dans OLIUVL
OLIUVL:		.BLK.8	LLIUVL			; units physiques: buffer pour ?VLOGIC
LGVARU:



; Variables pour LIST_DBOX
; ------------------------

LDBDIS		= LMFILE

		.LOC	0
ODBCHD:		.BLK.16	1			; canal du module DBOX
ODBCHS:		.BLK.16	1			; canal du module SCROLL
ODBCHV:		.BLK.32	1			; canal pour LIST_VISUxxx
ODBVSL:		.BLK.8	LSLVAR			; variables pour scroll-list
ODBOPM:		.BLK.16	1			; mode d'ouverture
ODBOPP:		.BLK.32	1			; position centre si BDBPOS dans mode
ODBFAN:		.BLK.32	1			; fanions
ODBMOD:		.BLK.32	1			; modes
ODBPNK:		.BLK.32	1			; ^nom pour (CHOISIT)
ODBPLI:		.BLK.32	1			; ^noms et arguments des fichiers
ODBNBF:		.BLK.16	1			; nb de noms
ODBNBD:		.BLK.16	1			; nb de noms, mais sans les dossiers
ODBPBN:		.BLK.32	1			; ^buffer pour nom en sortie
ODBPCR:		.BLK.32	1			; ^critre donn en entre
ODBCRI:		.BLK.8	LMFILE			; critre
ODBTYP:		.BLK.16	1*10			; type des fichiers
ODBNOP:		.BLK.8	1			; 1 => PREND impossible (gris)
		.EVEN
ODBVER:		.BLK.16	1			; nb d'imbrications  verrouiller
ODBDIS:		.BLK.8	LDBDIS			; buffer pour "write display"
LGDBOX:


; Variables pour LIST_MODIF
; -------------------------

		.LOC	0
OMODC:		.BLK.16	1			; canal du module DBOX
OMODM:		.BLK.16	1			; mode d'ouverture
OMODP:		.BLK.32	1			; position centre si BDBPOS dans mode
OMODPC:		.BLK.32	1			; ^critre
OMODF1:		.BLK.8	LGMFILE			; premier nom de fichier
OMODF2:		.BLK.8	LGMFILE			; deuxime nom de fichier
OMODCI:		.BLK.16	1			; canal en entre
OMODCO:		.BLK.16	1			; canal en sortie
OMODLB:		.BLK.32	1			; lg buffer temporaire
OMODAR:		.BLK.8	LGARGS			; arguments
LGMODIF:


; En-tte d'un fichier .IMAGE
; ---------------------------

		.LOC	0
		.BLK.8	1			; OIMTYP: H'01 = indique type image
		.BLK.8	1			; OIMCOD: H'00 = indique pas de codage
		.BLK.8	1			; OIMBIP: H'01 = 1 bit par point
		.BLK.8	1			; OIMDIR: H'02 = coord. X-Y comme cran
		.BLK.16	1			; OIMDLX: largeur image en points
		.BLK.16	1			; OIMDLY: hauteur image en points
		.BLK.32	1			; OIMNBB: nb de byte pour l'image
		.BLK.8	19			; rserve
OIMINV:		.BLK.8	1			; flag spcial pour LIST_VISU



; En-tte d'un chantillon .PAGE/.LPAGE
; -------------------------------------

		.LOC	0
OSMPLG:		.BLK.32	1			; longueur  sauter
OSMPNBP:	.BLK.16	1			; nb de pages
OSMPDIM:	.BLK.32	1			; dimensions [mm]
		.BLK.8	22			; rserve
LSMP:



; En-tte d'un fichier .TEXT (calcule)
; -------------------------------------

		.LOC	0
OTXBIN:		.BLK.8	1			; 1 => fichier binaire
		.EVEN
OTXLGT:		.BLK.32	1			; lg totale
OTXLGB:		.BLK.32	1			; lg sans les BOAs
OTXNBL:		.BLK.16	1			; nb de lignes
OTXNBC:		.BLK.16	1			; nb de caractres/ligne (si binaire)
OTXCY:		.BLK.16	1			; hauteur d'un caractre
OTXCX:		.BLK.16	1			; largeur d'un caractre
OTXC1Y:		.BLK.16	1			; offset en Y
OTXC1X:		.BLK.16	1			; offset en X
OTXLFL:		.BLK.16	1			; dernire premire ligne affiche
OTXLNL:		.BLK.16	1			; dernier numro pour OTXLPL
OTXLPL:		.BLK.32	1			; dernier ^ligne


; Variables pour les appels LIST_VISUxxxx
; ---------------------------------------

LHVBUF		= 256				; lg buffer
LHVGRABUF	= 1600*16/8			; buffer graphique

		.LOC	0

OHVMD1:		.BLK.16	1			; D1 utilis par GESMEM
OHVMA1:		.BLK.32	1			; A1 utilis par GESMEM

OHVTYP:		.BLK.16	1			; type du fichier (TYPxxx)
OHVPT:		.BLK.32	1			; ^data du fichier
OHVPTMEM:	.BLK.32	1			; ^mmoire  librer (.COLOR)
OHVLG:		.BLK.32	1			; longueur du fichier
OHVHD:		.BLK.8	LGHIMA			; en-tte (pas forcment image)
OHVBIP:		.BLK.8	1			; bit/pixel de l'original
		.EVEN
OHVNAM:		.BLK.8	LMFILE			; nom complet du fichier

OHVPOS:		.BLK.32	1			; coin sup/gauche
OHVDIM:		.BLK.32	1			; dimensions
OHVPOF:		.BLK.32	1			; coin sup/gauche pour fichier
OHVDIF:		.BLK.32	1			; dimensions pour fichier

OHVWDI:		.BLK.16	1			; no swdo initiale
OHVWDJ:		.BLK.16	1			; no swdo de travail

OHVMOO:		.BLK.32	1			; mode pour LIST_VISUOPEN
OHVMOD:		.BLK.32	1			; mode pour LIST_VISUDRAW
OHVMOU:		.BLK.32	1			; mode pour LIST_VISUUPDATE
OHVMOI:		.BLK.32	1			; mode pour LIST_VISUINFO

OHVERR:		.BLK.16	1			; code de l'erreur

OHVPOR:		.BLK.32	1			; position relative (+/- y;x)

OHVNCM:		.BLK.16	1			; compteur pour CCMO/SCMO
OHVFLG:		.BLK.8	1			; flags divers :
 BHVMAIN	= 0				;  lutin souris = main
OHVDCR:		.BLK.8	1			; 1 => disable <cr>
		.EVEN

OHVASV:		.BLK.8	LSCVAR			; ascenseur vertical ( gauche)
OHVASH:		.BLK.8	LSCVAR			; ascenseur horizontal (en bas)

OHVCHS:		.BLK.16	1			; canal du module STRETCH
OHVCHP:		.BLK.16	1			; canal du module PLANA

OHVBUF:		.BLK.8	LHVBUF			; buffer pour diverses utilisations
OHVGRABUF:	.BLK.8	LHVGRABUF		; buffer graphique

OHVUSE:		.BLK.8	16			; qq variables pour l'utilisateur

LHV:





; En-tte du module LIB
; ---------------------

	.APC	PCCODE
	.LOC	0

BASE:	.16	LIST_FIRST			; code du premier appel
	.16	LIST_LAST			; code du dernier appel
	.8	0				; nombre d'installations
	.FILL.8	(OHLREV-APC),0
	.8	MAJREV,MINREV			; rvision.version
	.32	END_LIST			; longueur
	.32	PATHLIB				; pattern de dbut
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"LIST"			; nom du module
	.FILL.8	(LGHLIB-APC),0

	.16	_LIST_OPEN
	.16	_LIST_NEXT
	.16	_LIST_CLOSE
	.16	_LIST_AFFILE
	.16	_LIST_DBOX
	.16	_LIST_MODIF
	.16	_LIST_DELETE
	.16	_LIST_SOPEN
	.16	_LIST_NBMAX
	.16	_LIST_PUTFILE
	.16	_LIST_VISU




; Codes des appels
; ----------------



;-----------\
; _LIST_OPEN >
;===========/

; Dbut d'une recherche dans SYS_LIST.

; in	A3.L	^critre de recherche
; out	D6.L	canal
;	D7.16	erreur
; mod	D6.L, D7.W

_LIST_OPEN:
	PUSH.32	D3

	MOVE.32	#2**BOPRD,D3		; D3 <-- mode d'ouverture
	CALL	_LIST_SOPEN		; dbut d'une recherche

	POP.32	D3
	TEST.16	D7			; retour EQ/NE
	RET

;------------\
; _LIST_SOPEN >
;============/

; Dbut d'une recherche dans SYS_LIST.

; in	A3.L	^critre de recherche ($ = units physiques)
;	D3.32	mode d'ouverture pour SYS_LIST
; out	(A3)++	critre avec accs complet (si D3:#BOPNAME)
;	D6.32	canal
;	D7.16	erreur
; mod	D6.L, D7.W

_LIST_SOPEN:
	PUSHM.32 D1..D4|A2..A4|A6

	MOVE.32	#LGVAR,D4		; D4 <-- lg des variables
	COMP.8	#"$",{A3}		; liste des units physiques ?
	JUMP,NE	R8^L10$			; non => 10$
	TEST.8	{A3}+1
	JUMP,NE	R8^L10$
	MOVE.32	#LGVARU,D4		; D4 <-- plus de variables !
L10$:	MOVE.32	#MTYPCP,D1
	GESMEM	?GETMEM			; demande mmoire pour variables
	JUMP,NE	L95$
	GESMEM	?CLEARMEM		; variables <-- rempli de zro
	MOVE.32	A4,A6			; A6 <-- ^variables

	MOVE.32	D3,{A6}+OLIMOD		; OLIMOD <-- modes
	MOVE.32	A3,{A6}+OLIPCR		; OLIPCR <-- ^critre de l'utilisateur
	CLR.16	{A6}+OLIOP		; OLIOP <-- premire option

; Spare les noms de rpertoires du critre.

	CALL	SKIPREP			; A3 <-- ^rep(s): et A4 <-- ^nom (critre)

	MOVE.32	#{A6}+OLIREP,A2
L20$:
	COMP.32	A4,A3
	JUMP,EQ	R8^L22$
	MOVE.8	{A3+},{A2+}		; OLIREP <-- noms de rpertoires
	JUMP	L20$
L22$:
;	CLR.8	{A2}

	MOVE.32	#{A6}+OLICRI,A2
L30$:
	MOVE.8	{A4+},D3
	CALL	IFTERM
	JUMP,EQ	R8^L32$
	MOVE.8	D3,{A2+}		; OLICRI <-- critres
	JUMP	L30$
L32$:
;	CLR.8	{A2}

; Demande au FOS d'ouvrir la liste.

	COMP.16	#16'100*"$",{A6}+OLICRI	; liste des units physiques ?
	JUMP,EQ	L60$			; oui => 60$

	MOVE.32	#{A6}+OLIREP,A3		; A3 <-- ^rpertoires
	MOVE.32	A3,A2			; A2 <-- ^buffer pour accs (si D3:#BOPNAME)
	MOVE.16	#LLINAM,D4		; D4 <-- lg buffer (si D3:#BOPNAME)
	MOVE.32	#{A6}+OLICRI,A4		; A4 <-- ^critres
	MOVE.32	{A6}+OLIMOD,D3		; D3 <-- mode d'ouverture
	MOVE.16	{A6}+OLIOP,D2		; D2 <-- premire option
	FOS	?LISTOP			; ouvre la liste
	JUMP,NE	R8^L90$
	MOVE.16	D2,{A6}+OLIOP		; OLIOP <-- option suivante

	MOVE.32	D6,{A6}+OLICH		; mm. le canal FOS
	MOVE.16	D4,{A6}+OLINBM		; mm. le nb max de fichiers

; Retourne ventuellement le critre avec la chane d'accs complte
; rendue par le FOS.

	TEST.32	D3:#BOPNAME		; rend l'accs complet ?
	JUMP,BC	R8^L80$			; non => 80$
				; oui =>
	MOVE.32	{A6}+OLIPCR,A3		; A3 <-- ^buffer de l'utilisateur
	MOVE.32	#{A6}+OLIREP,A4
L50$:
	MOVE.8	{A4+},{A3+}		; critre <-- accs complet (rpertoires)
	JUMP,NE	L50$
	DEC.32	A3
	MOVE.32	#{A6}+OLICRI,A4
L52$:
	MOVE.8	{A4+},{A3+}		; critre <-- *.xxx
	JUMP,NE	L52$
	JUMP	R8^L80$
L60$:					; units physiques =>
	SUB.32	A3,A3			; A3 <-- ^nom physique
	MOVE.32	#{A6}+OLIUVL,A4		; A4 <-- ^buffer pour les noms
	MOVE.32	#LLIUVL,D4		; D4 <-- lg buffer
	CLR.16	D3			; D3 <-- pour tous
	MOVE.32	#-1,D2			; D2 <-- chanes d'assignations compltes
	FOS	?VLOGIC			; OLIUVL <-- tous les noms
	JUMP,NE	R8^L90$
	MOVE.32	A4,{A6}+OLIUPT		; OLIUPT <-- ^dbut de OLIUVL
L80$:
	MOVE.32	A6,D6			; D6 <-- canal du module LIST
	JUMP	R8^L95$

L90$:
	PUSH.16	D7
	MOVE.32	A6,A4			; A4 <-- ^zone des variables
	MOVE.32	#MTYPCP,D1
	GESMEM	?GIVMEM			; rend la mmoire des variables
	POP.16	D7
L95$:
	POPM.32	D1..D4|A2..A4|A6
	TEST.16	D7			; retour EQ/NE
	RET


;------------\
; _LIST_NBMAX >
;============/

; Donne le nombre de fichiers correspondants au critre.

; in	D6.L	canal
; out	D4.W	nb de fichiers (0..n)
; mod	D4.L, D7.W

_LIST_NBMAX:
	PUSH.32	A6

	MOVE.32	D6,A6			; A6 <-- ^variables
	MOVE.16	{A6}+OLINBM,D4		; D4 <-- nb de fichiers

	POP.32	A6
	CLR.16	D7			; retour EQ
	RET


;-----------\
; _LIST_NEXT >
;===========/

; Cherche le fichier suivant dans SYS_LIST.

; in	D6.L	canal
; out	A3.L	^nom trouv
;	A4.32	^arguments
;	D7.16	erreur (EROUTF quand c'est fini)
; mod	D7.W, A3.L, A4.L

_LIST_NEXT:
	PUSHM.32 D2..D5|D6|A2|A6

	MOVE.32	D6,A6			; A6 <-- ^variables

	COMP.16	#16'100*"$",{A6}+OLICRI	; liste des units physiques ?
	JUMP,EQ	R8^L50$			; oui => 50$
L10$:
	MOVE.32	{A6}+OLICH,D6		; D6 <-- canal du FOS
	FOS	?LISTNXT		; A3 <-- ^nom et A4 <-- ^arguments
	JUMP,EQ	R8^L90$
	COMP.16	#EROUTF,D7
	JUMP,NE	R8^L90$

	MOVE.32	{A6}+OLIMOD,D3		; D3 <-- mode d'ouverture
	TEST.32	D3:#BOPNEXT		; cherche toutes les options ?
	JUMP,BC	R8^L90$			; non => 90$
				; oui =>
	MOVE.32	{A6}+OLICH,D6		; D6 <-- canal du FOS
	FOS	?LISTCLO		; ferme la liste de l'option prcdente

	MOVE.32	#{A6}+OLIREP,A3		; A3 <-- ^rpertoires
	MOVE.32	#{A6}+OLICRI,A4		; A4 <-- ^critres
;	MOVE.32	{A6}+OLIMOD,D3		; D3 <-- mode d'ouverture
	TCLR.32	D3:#BOPNAME		; D3 <-- rend seulement le premier accs !
	MOVE.16	{A6}+OLIOP,D2		; D2 <-- option
	FOS	?LISTOP			; ouvre la liste de la nouvelle option
	JUMP,NE	R8^L90$
	MOVE.16	D2,{A6}+OLIOP		; OLIOP <-- option suivante
	MOVE.32	D6,{A6}+OLICH		; mm. le canal FOS
	MOVE.16	D4,{A6}+OLINBM		; mm. le nb max de fichiers
	JUMP	L10$

L50$:					; unit physique =>
	MOVE.32	{A6}+OLIUPT,A2		; A2 <-- ^dans OLIUVL
L52$:
	MOVE.16	#EROUTF,D7
	TEST.8	{A2}			; fin de la table ?
	JUMP,EQ	R8^L56$			; oui => 56$

	CALL	LISTNEXTPUT		; A3/A4 <-- ^noms/^arguments
	JUMP,NE	L52$
L56$:
	MOVE.32	A2,{A6}+OLIUPT
L90$:
	POPM.32	D2..D5|D6|A2|A6
	TEST.16	D7			; retour EQ/NE
	RET


;------------\\
; LISTNEXTPUT >
;------------/

; Cherche les noms et les arguments d'une unit physique.
; Met les noms en sens inverse de ce que donne FOS,?VLOGIC.
; Par exemple :
;	?VLOGIC	-->	#DANIEL<0>#MM1<0><0>
;	nom	-->	#MM1:/#DANIEL:<0>

; in	A2.L	^nom physique<0> logique<0> .. <0>
; out	A2.L	^nom suivant
;	A3.32	^nom trouv
;	A4.32	^arguments
;	D7.16	erreur
; mod	D7.W, A2.L, A3.L, A4.L

LISTNEXTPUT:
	PUSH.16	D3

	MOVE.32	#{A6}+OLIUAR+OBLLG,A4
L10$:
	MOVE.8	{A2+},{A4+}		; OBLLG <-- nom physique !
	JUMP,NE	L10$

; Filtre les assignations #.. -> @..

	COMP.8	#"#",{A2}
	JUMP,NE	R8^L30$
	COMP.8	#"@",{A6}+OLIUAR+OBLLG
	JUMP,NE	R8^L30$
L20$:
	TEST.8	{A2+}
	JUMP,EQ	R8^L24$
L22$:
	TEST.8	{A2+}
	JUMP,NE	L22$
	JUMP	L20$
L24$:
	MOVE.16	#EROUTF,D7		; D7 <-- pas trouv
	JUMP	R8^L90$

; Met tous les noms logiques.

L30$:
	MOVE.32	#{A6}+OLIUAR+OBLNAM,A4
	MOVE.32	A4,A3
	CLR.32	{A3+}
	CLR.32	{A3+}
	CLR.32	{A3+}
	CLR.32	{A3+}			; vide tout le buffer (LGNAME)

	MOVE.32	A2,A3			; A3 <-- ^noms logiques
	CLR.8	D3			; D3 <-- pas de terminateur
L32$:
	CALL	LISTNEXTONE		; OBLNAM <-- ajoute un nom
	MOVE.8	#"/",D3			; D3 <-- terminateur "/"
	TEST.8	{A3}			; encore un nom ?
	JUMP,NE	L32$			; oui => 32$

	MOVE.32	#{A3}+1,A2		; A2 <-- ^suivant
	MOVE.32	#{A6}+OLIUAR+OBLNAM,A3	; A3 <-- ^noms
	MOVE.32	#{A6}+OLIUAR+OBLTYP,A4	; A4 <-- ^arguments

	CLR.16	D7			; D7 <-- ok
L90$:
	POP.16	D3
	TEST.16	D7			; retour EQ/NE
	RET

;------------\\
; LISTNEXTONE >
;------------/

; Met un nom, en poussant ceux qui y sont dj !

; in	A3.L	^nom  ajouter <0>
;	A4.32	^buffer (lg=LGNAME=16)
;	D3.8	caractre terminateur/nil (si premier)
; out	A3.L	^nom suivant
; mod	D7.W, A3.L

LISTNEXTONE:
	PUSHM.32 D1|D2|A1|A2

	MOVE.32	A3,A2
	MOVE.32	#-1+1,D2		; D2 <-- +1  cause place pour ":"

L20$:	INC.16	D2
	TEST.8	{A2+}
	JUMP,NE	L20$

	TEST.8	D3
	JUMP,EQ	R8^L24$
	INC.16	D2			; D2 <-- +1  cause place pour terminateur
L24$:
	MOVE.32	#{A4}+LGNAME,A1
	MOVE.32	#{A4}+LGNAME,A2
	SUB.A16	D2,A2
	MOVE.16	#LGNAME-1,D1		; D1 <-- -1  cause NMO
	SUB.16	D2,D1
L30$:
	MOVE.8	{-A2},{-A1}		; buffer <-- pousse les noms existants
	DJ.16,NMO D1,L30$

;	MOVE.32	A4,A2
L40$:
	MOVE.8	{A3+},{A2+}
	JUMP,NE	L40$
	MOVE.8	#":",{A2}-1

	TEST.8	D3
	JUMP,EQ	R8^L44$
	MOVE.8	D3,{A2}			; buffer <-- caractre terminateur
L44$:
	TEST.8	{A4}+LGNAME-1
	JUMP,EQ	R8^L90$
	CLR.8	{A4}+LGNAME-1
	MOVE.8	#">",{A4}+LGNAME-2
L90$:
	POPM.32	D1|D2|A1|A2
	RET


;------------\
; _LIST_CLOSE >
;============/

; Termine une recherche dans SYS_LIST.

; in	D6.L	canal
; out	-
; mod	-

_LIST_CLOSE:
	PUSHM.32 D1|D6|D7|A4|A6

	MOVE.32	D6,A6			; A6 <-- ^variables

	COMP.16	#16'100*"$",{A6}+OLICRI	; liste des units physiques ?
	JUMP,EQ	R8^L50$			; oui => 50$

	MOVE.32	{A6}+OLICH,D6		; D6 <-- canal du FOS
	FOS	?LISTCLO		; ferme la liste
L50$:
	MOVE.32	A6,A4
	MOVE.32	#MTYPCP,D1
	GESMEM	?GIVMEM			; rend les variables

	POPM.32	D1|D6|D7|A4|A6
	RET



;-------------\\
; _LIST_AFFILE >
;=============/

; Affiche un nom de fichier.

; in	A3.32	^nom
;	A4.32	^arguments
;	D4.16	mode d'affichage
; out	D7.16	erreur
; mod	D7.16

_LIST_AFFILE:
	PUSHM.32 D1|D2|D3|D4|A3

	MOVE.16	D4,D1			; D1 <-- mode d'affichage

	MOVE.16	#16,D2			; D2 <-- place pour le nom
L10$:
	MOVE.8	{A3+},D3
	JUMP,EQ	R8^L20$
	LIB	?AFCAR
	DEC.16	D2
	JUMP,NE	L10$
L20$:
	TEST.16	D2
	JUMP,EQ	R8^L30$
	MOVE.8	#MSPACE,D3
	LIB	?AFCAR			; bourre le reste avec des espaces
	MOVE.8	D2,D3			; D3 <-- nb d'espace(s)
	LIB	?AFCAR
L30$:
	TEST.32	D1:#BLISTALG
	JUMP,BC	R8^L40$
	MOVE.8	#2**BAFDSP,D2		; D2 <-- mode d'affichage
	MOVE.8	#8,D3			; D3 <-- nb de digits
	MOVE.32	{A4}+OBALGF,D4
	LIB	?AFDEC			; affiche la taille
L40$:
	TEST.32	D1:#BLISTADC
	JUMP,BC	R8^L50$
	LIB	?AFSPACE
	MOVE.32	#{A4}+OBACD,A3
	MOVE.8	#"/",D3
	CALL	AFDATIM			; affiche la date de cration
L50$:
	TEST.32	D1:#BLISTAHC
	JUMP,BC	R8^L51$
	MOVE.32	#{A4}+OBACH,A3
	MOVE.8	#":",D3
	CALL	AFDATIM			; affiche l'heure de cration
L51$:
	TEST.32	D1:#BLISTADM
	JUMP,BC	R8^L52$
	LIB	?AFSPACE
	MOVE.32	#{A4}+OBAWD,A3
	MOVE.8	#"/",D3
	CALL	AFDATIM			; affiche la date de modification
L52$:
	TEST.32	D1:#BLISTAHM
	JUMP,BC	R8^L53$
	MOVE.32	#{A4}+OBAWH,A3
	MOVE.8	#":",D3
	CALL	AFDATIM			; affiche l'heure de modification
L53$:
	TEST.32	D1:#BLISTADU
	JUMP,BC	R8^L54$
	LIB	?AFSPACE
	MOVE.32	#{A4}+OBARD,A3
	MOVE.8	#"/",D3
	CALL	AFDATIM			; affiche la date d'utilisation
L54$:
	TEST.32	D1:#BLISTAHU
	JUMP,BC	R8^L55$
	MOVE.32	#{A4}+OBARH,A3
	MOVE.8	#":",D3
	CALL	AFDATIM			; affiche l'heure d'utilisation
L55$:
	POPM.32	D1|D2|D3|D4|A3
	RET

;--------\\
; AFDATIM >
;--------/

; Affiche une date ou une heure.

; in	A3.L	^date/heure (.BBB)
;	D3.8	caractre de sparation
; out	-
; mod	D4.W, D7.W

AFDATIM:
	LIB	?AFSPACE		; met d'abord un espace
	MOVE.8	{A3}+0,D4
	LIB	?AFX2			; affiche heures/jour
	LIB	?AFCAR			; affiche ":" ou "/"
	MOVE.8	{A3}+1,D4
	LIB	?AFX2			; affiche minutes/mois
	LIB	?AFCAR			; affiche ":" ou "/"
	MOVE.8	{A3}+2,D4
	LIB	?AFX2			; affiche secondes/anne
	RET


;--------------\\
; _LIST_PUTFILE >
;==============/

; Affiche un nom de fichier.

; in	A3.L	^nom
;	A4.32	^arguments
;	D4.16	mode d'affichage
;	A5.32	^buffer
; out	A5.L	^plus loin
;	D7.16	erreur
; mod	D7.W, A5.L

_LIST_PUTFILE:
	PUSHM.32 D1|D2|D3|D4|A3|A4

	EX.32	A5,A4
	MOVE.16	D4,D1			; D1 <-- mode d'affichage

	MOVE.16	#16,D2			; D2 <-- place pour le nom
L10$:
	MOVE.8	{A3+},D3
	JUMP,EQ	R8^L20$
	MOVE.8	D3,{A4+}
	DEC.16	D2
	JUMP,NE	L10$
L20$:
	TEST.16	D2
	JUMP,EQ	R8^L30$
L22$:
	MOVE.8	#SPACE,{A4+}		; bourre le reste avec des espaces
	DEC.16	D2
	JUMP,NE	L22$
L30$:
	TEST.32	D1:#BLISTALG
	JUMP,BC	R8^L40$
	MOVE.8	#2**BAFDSP,D2		; D2 <-- mode d'affichage
	MOVE.8	#8,D3			; D3 <-- nb de digits
	MOVE.32	{A5}+OBALGF,D4
	LIB	?PUTDEC			; affiche la taille
L40$:
	TEST.32	D1:#BLISTADC
	JUMP,BC	R8^L50$
	MOVE.8	#SPACE,{A4+}
	MOVE.32	#{A5}+OBACD,A3
	MOVE.8	#"/",D3
	CALL	PUTDATIM		; affiche la date de cration
L50$:
	TEST.32	D1:#BLISTAHC
	JUMP,BC	R8^L51$
	MOVE.32	#{A5}+OBACH,A3
	MOVE.8	#":",D3
	CALL	PUTDATIM		; affiche l'heure de cration
L51$:
	TEST.32	D1:#BLISTADM
	JUMP,BC	R8^L52$
	MOVE.8	#SPACE,{A4+}
	MOVE.32	#{A5}+OBAWD,A3
	MOVE.8	#"/",D3
	CALL	PUTDATIM		; affiche la date de modification
L52$:
	TEST.32	D1:#BLISTAHM
	JUMP,BC	R8^L53$
	MOVE.32	#{A5}+OBAWH,A3
	MOVE.8	#":",D3
	CALL	PUTDATIM		; affiche l'heure de modification
L53$:
	TEST.32	D1:#BLISTADU
	JUMP,BC	R8^L54$
	MOVE.8	#SPACE,{A4+}
	MOVE.32	#{A5}+OBARD,A3
	MOVE.8	#"/",D3
	CALL	PUTDATIM		; affiche la date d'utilisation
L54$:
	TEST.32	D1:#BLISTAHU
	JUMP,BC	R8^L55$
	MOVE.32	#{A5}+OBARH,A3
	MOVE.8	#":",D3
	CALL	PUTDATIM		; affiche l'heure d'utilisation
L55$:
	CLR.8	{A4}
	EX.32	A4,A5

	POPM.32	D1|D2|D3|D4|A3|A4
	RET

;---------\\
; PUTDATIM >
;---------/

; Affiche une date ou une heure.

; in	A3.L	^date/heure (.BBB)
;	D3.8	caractre de sparation
;	A4.32	^buffer
; out	A4.L	^plus loin
; mod	D4.W, D7.W, A4.L

PUTDATIM:
	MOVE.8	#SPACE,{A4+}		; met d'abord un espace
	MOVE.8	{A3}+0,D4
	CALL	PUTX2			; affiche heures/jour
	MOVE.8	D3,{A4+}		; affiche ":" ou "/"
	MOVE.8	{A3}+1,D4
	CALL	PUTX2			; affiche minutes/mois
	MOVE.8	D3,{A4+}		; affiche ":" ou "/"
	MOVE.8	{A3}+2,D4
;	CALL	PUTX2			; affiche secondes/anne
;	RET

;--------\\
; PUTX2   >
;--------/

; Affiche un nombre en BCD.

; in	D4.B	nombre BCD
;	A4.32	^buffer
; out	A4.L	^plus loin
; mod	D7.W, A4.L

PUTX2:
	PUSH.16	D3

	MOVE.8	D4,D3
	SR.8	#4,D3
	ADD.8	#"0",D3
	MOVE.8	D3,{A4+}

	MOVE.8	D4,D3
	AND.8	#16'0F,D3
	ADD.8	#"0",D3
	MOVE.8	D3,{A4+}

	POP.16	D3
	RET





	.INS	LISTDBOX.ASI
	.INS	LISTMODIF.ASI
	.INS	LISTVISU.ASI
	.INS	LISTMISC.ASI
	.INS	LISTVIEWER.ASI




;-------------\\
; _LIST_DELETE >
;=============/

; Demande  l'utilisateur s'il faut dtruire ou non un fichier.
; Ne fait pas l'appel FOS,?DELETE !

; in	A3.L	^nom du fichier
;	D2.16	mode d'ouverture pour la dbox
;	D3.32	position centre (y;x) si BDBPOS dans D2.W
; out	D3.W	dernire touche (O/N)
;	D7.16	erreur
; mod	D3.L, D7.W

_LIST_DELETE:
	PUSHM.32 D1|D2|D4|A3|A5

	MOVE.32	A3,A5			; A5 <-- ^nom du fichier
	MOVE.32	#R16^L01$,A3		; A3 <-- ^textes de description

	CLR.32	D4			; D4 <-- fanions
	CLR.32	D3			; D3 <-- flags
	TSET.32	D2:#BDBEXTEND
	MOVE.16	#DBOX_DETRUIT,D1
	DBOX_	EXTEND			; dialogue ...
	JUMP,NE	R8^L90$

	MOVE.16	D3,D2
	MOVE.16	#"O",D3
	COMP.16	#F1,D2
	JUMP,EQ	R8^L90$
	MOVE.16	#"N",D3
L90$:
	POPM.32	D1|D2|D4|A3|A5
	TEST.16	D7			; retour EQ/NE
	RET

L01$:
	.ASCIZ	""			; nom du logiciel
	.ASCIZ	"Mfichier"		; [M,F] nom des lments manipuls
	.ASCIZ	""			; [M,F] nom du contenant
	.8	0
	.EVEN


;--------\\
; SKIPREP >
;========/

; Saute "unit:rep:rep:" au dbut d'un nom de fichier.

; in	A3.L	^nom de fichier
; out	A4.L	^nom sans unit:rep:
; mod	A4.L

SKIPREP:
	PUSHM.32 D3|A3
L10$:
	MOVE.32	A3,A4			; A4 <-- ^dbut/^aprs ":"
L20$:
	MOVE.8	{A3+},D3
	CALL	IFTERM
	JUMP,EQ	R8^L90$

	COMP.8	#":",D3
	JUMP,EQ	L10$
	JUMP	L20$

L90$:
	POPM.32	D3|A3
	RET

;--------\\
; IFTERM  >
;========/

; Teste si le caractre dans D3 est un terminateur de nom de fichier.

; in	D3.8	caractre
; out	EQ	terminateur
; mod	-

IFTERM:
	TEST.8	D3
	JUMP,EQ	R8^L90$
	COMP.8	#CR,D3
	JUMP,EQ	R8^L90$
	COMP.8	#SPACE,D3
	JUMP,EQ	R8^L90$
	COMP.8	#TAB,D3
	JUMP,EQ	R8^L90$
	COMP.8	#"/",D3
;	JUMP,EQ	R8^L90$
L90$:	RET





; Tables
; ------

DOOK:	MOVE.16	#CR,D3
	RET

DOAN:	MOVE.16	#END,D3
	RET

DOKF1:	MOVE.16	#F1,D3
	RET

DOKF4:	MOVE.16	#F4,D3
	RET

DOKF7:	MOVE.16	#F7,D3
	RET

DOKF10:	MOVE.16	#F10,D3
	RET

DOKF13:	MOVE.16	#F13,D3
	RET

DOOUI:	MOVE.16	#"O",D3
	RET

DONON:	MOVE.16	#"N",D3
	RET

DOMP:	MOVE.16	#KEYMGP,D3
	RET

DOMR:	MOVE.16	#KEYMGR,D3
	RET





; Textes et tables
; ----------------

NMSTRET:	.ASCIZ	"STRETCH"
NMPLAN:		.ASCIZ	"PLANA"
NAMDBOX:	.ASCIZ	"DBOX"
NAMSCROLL:	.ASCIZ	"SCROLL"
NMSYSVIEW:	.ASCIZ	"#:VIEW:"
NMVIEWER:	.ASCIZ	"*.VIEW"
LUTERM:		.8	":"
LITERM:		.8	0,CR,SPACE,TAB,"/",-1
		.EVEN



END_LIST:


	.END

