
	.TITLE	MATH64.ASL

; "Paquage mathmatique sur 64 bits, C) F. Jaques 1985. CH-1143 APPLES"

REVISION = 1
VERSION	 = 9

; Rev	Date	  Qui	Amliorations
; ---------------------------------------------------------------------------------------------
; 1.9	12/08/97  PA	Ne modifie plus son propre code.
;			Remplac "PUSH.16 SF" par "PUSH.16 F" qui fait aussi l'affaire pour les
;			processeurs plus rcents que le 68000...
;			Remplac quelques SETZ par des COMP.8 D0,D0.
; 1.8	29/04/92  FJ	Dernire version distribue par Franois Jaques.
; ---------------------------------------------------------------------------------------------

.MACRO	PUSH_F
.IF	.DEFINED.IS_68020
	PUSH.16	F
.ELSE
	PUSH.16	SF
.ENDIF
.ENDMACRO


TC64	=	FALSE		; insertion dans c64 avec dtail des temps

	.IF	.NOT.TC64
	.REV	REVISION,VERSION
	.IDENT	"(C) Copyright 1985-1997, EPSITEC SA, Franois Jaques"

.IF	.DEFINED.IS_68020
	.PROC	M68020
.ELSE
	.PROC	M68000
.ENDIF

	.REF	SMAKY
	.REF	MATH64

	.BASE	10'10
	.CODE	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

PCCODE	=	1
PCVRB	=	2
	.ELSE
PCVRB	=	3
	.ENDIF

RAPIDE	=	TRUE			; assemblage avec mode rapide selon commande (0.6)
CONVRAP	=	TRUE			; convertions rapides (M64_C32.ASM)
RPMF	=	FALSE			; mode rapide aussi pour +,-,* ? (plus rapide en 64 bits!)
RD	=	TRUE.OR.RPMF		; et pour / (que 4 digits et 50% de gain de temps~)

	.IF	.NOT.TC64
DEBUG	=	?ASCOND			; voir aussi TOPDBG, ODEBUG et MACRO DBG.
	.ENDIF
PMFD	=	FALSE			; aussi PLUS, MOINS, FOIS, DIVISE 64 ?
FD	=	FALSE			; aussi TEST, COMP, ALIGNE,...
	.IF	.NOT.TC64
DEBUG_ENTREE=	FALSE.OR.DEBUG		; activation des macros DBGIN, DBG & DBGOUT
DEBUG_SORTIE=	FALSE.OR.DEBUG
	.ENDIF

;############################################################################################
; Entte pour module L10 ####################################################################
;############################################################################################

	.APC	PCCODE
	.IF	.NOT.TC64
	.LOC	0
	.ENDIF
M64_START:
	.IF	.NOT.TC64
		.16		MATH64_FIRST	; 1er appel
		.16		MATH64_LAST	; dernier appel
		.8		0		; instal
		.FILL.8		5,0		; rserv
		.8		REVISION,VERSION
		.32		ENDMATH64	; LEN
		.32		16'AFEE6C9C	; pattern
		.FILL.8		12,0		; rserv
		.ASCII		"MATH64"	; nom
		.FILL.8		16-6,0		; surplus de place pour nom
		.FILL.8		16,0		; rserve

;		------------------
;		Indirection MATH64
;		------------------
;=
		.16		OPEN		; 
		.16		CLOSE		; 

		.16		AFER64		; Message d'erreur du MATH64

		.16		ASCFP64		; ingnieure ou usuelle  ->  FP64
		.16		FP64ASC		; FP64  ->  ingnieure ou usuelle

		.16		USING		; usuelle    -> ingnieure
		.16		INGUS		; ingnieure -> usuelle

		.16		FORMATE		; format et arrondi (id. MATH32_FORM)

		.16		FP64ING		; FP64       -> ingnieure
		.16		INGFP64		; ingnieure -> FP64

		.16		FP32A64		; FP32       -> FP64
		.16		FP64A32		; FP64       -> FP32

		.16		XSEP64		; INT & FRAC (FP64)
		.16		XADD64		; FP64  +  FP64
		.16		XSUB64		; FP64  -  FP64
		.16		XMUL64		; FP64  *  FP64
		.16		XDIV64		; FP64  /  FP64
		.16		XCOMP64		; FP64  :: FP64
		.16		XTEST64		; FP64  :: 0

		.16		PERMUTE		; D3D4 <-> D1D2 (FP64)
		.16		ZERO		; D3D4  =  0 (FP64)
		.16		XMUL10		; FP64  *  10

		.16		XNEG64		; inverse le signe d'un FP64
		.16		XABS64		; valeur absolue

		.16		XPOWER
		.16		XSQUARE

		.16		XLOGE
		.16		XEXPE
		.16		XLOG10
		.16		XEXP10

		.16		XSINUS
		.16		XCOSINUS
		.16		XTANG
		.16		XARCSIN
		.16		XARCCOS
		.16		XARCTAN

		.16		XSINHYP
		.16		XCOSHYP
		.16		XTANHYP

		.16		ARNDFP64

		.16		FPBIN
		.16		BINFP

		.16		COMMAND

		.16		FPIEEE
		.16		IEEEFP

		.16		ROUND64		; 1.7

	;----------
	;= Macros.
	;----------

	.MACRO	DBGIN
	.IF	DEBUG_ENTREE
	PUSH.16	SF
	PUSHM.32	D3..D5|D7	; ne modifie rien

	LIB	?GETWDO			; sauve le num. wdo en cour
	LIB	?GETCURS		; et le curseur courant
	PUSHM.32	D3|D5

	CLR.32	D5
	LIB	?USEWDO			; utilise wdo 0
	CLR.32	D3
	LIB	?SETCURS		; crit en haut  gauche

	LIB	?AFTIM
	.ASCIZE	"Entre dans <AFINV> %1 <AFDIR> touche:"

	LIB	?GETCAR			; attend une touche

	POPM.32		D3|D5		; restitue wdo & curseur
	LIB	?USEWDO
	LIB	?SETCURS

	POPM.32	D3..D5|D7
	POP.16	F
	.ENDIF
	.ENDMACRO

	.MACRO	DBGOUT			; commentaires idem DBGIN
	.IF	DEBUG_SORTIE
	PUSH.16	SF
	PUSHM.32	D3..D5|D7

	LIB	?GETWDO
	LIB	?GETCURS
	PUSHM.32	D3|D5

	CLR.32	D5
	LIB	?USEWDO
	CLR.32	D3
	LIB	?SETCURS

	LIB	?AFTIM
	.ASCIZE	"Sort de <AFINV> %1 <AFDIR> touche:"
	LIB	?GETCAR

	POPM.32		D3|D5
	LIB	?USEWDO
	LIB	?SETCURS

	POPM.32	D3..D5|D7
	POP.16	F
	.ENDIF
	.ENDMACRO
;
	.MACRO	DBG,DBG			; MACRO pour dbugage local ( ex: DBG	46$ )
;	.DEFMACRO	%1=DBG		; affiche simplement DBG si pas de paramtre in
	.IF	DEBUG.OR.DEBUG_ENTREE.OR.DEBUG_SORTIE
	PUSH.16	SF
	PUSH.32	D7
	LIB	?AFTIM			; affiche une tiquette pour traage de dbug.
	.ASCIZE	" %1 "
	POP.32	D7			; ici si 3v4.
	POP.16	F
	.ENDIF
	.ENDMACRO
	.ENDIF

;=========================================================================================
; ROUTINES
;=========================================================================================

	.APC	PCVRB			; variables selon buffer pris par OPEN
	.LOC	0
OCAN:	.BLK.32	1			; canal dans A5
OCOM:	.BLK.32	1			; flags de commande
LGVARM64:

	.APC	PCCODE

;---------\\
OPEN:
;---------/
;
; IN:	D0.32 commandes (#0 si mode standart)
; OUT:	A5 canal, D7, F.
; MOD:	A5, D7, F.
;=
.IF	FD
.IF	.NOT.TC64
DBGIN	OPEN
.ENDIF
.ENDIF
	PUSHM.32 A3..A4|D1|D4

	MOVE.32	#LGVARM64,D4
	MOVE.32	#MTYPCP,D1
	GESMEM	?GETMEM
	JUMP,NE	OUT$
	MOVE.32	A4,A5
	MOVE.32	A5,{A5}+OCAN
	MOVE.32	D0,{A5}+OCOM
	CLR.16	D7

OUT$:	POPM.32	A3..A4|D1|D4
.IF	FD
.IF	.NOT.TC64
DBGOUT	OPEN
.ENDIF
.ENDIF
	TEST.16	D7
	RET


;---------\\
CLOSE:
;---------/
;
; IN:	A5 canal
; OUT:	D7, F.
; MOD:	D7, F.
;=
.IF	FD
.IF	.NOT.TC64
DBGIN	CLOSE
.ENDIF
.ENDIF
	PUSHM.32 A3..A4|D1

	CALL	VRFCAN
	JUMP,NE	OUT$

	MOVE.32	{A5}+OCAN,A4
	MOVE.32	#MTYPCP,D1
	GESMEM	?GIVMEM

OUT$:	POPM.32	A3..A4|D1
	TEST.16	D7
.IF	FD
.IF	.NOT.TC64
DBGOUT	CLOSE
.ENDIF
.ENDIF
	RET

;---------\\
COMMAND:
;---------/
;
; IN:	D0.32 nouvelles commandes (#0 si mode standart), A5 canal
; OUT:	D0.32 commandes prcdentes, D7, F.
; MOD:	D7, F.
;=
	CALL	VRFCAN
	JUMP,NE	OUT$
	PUSH.32	{A5}+OCOM
	MOVE.32	D0,{A5}+OCOM
	POP.32	D0
	CLR.16	D7
OUT$:	RET

;-------\\
VRFCAN:
;-------/
; Vrifie le canal
;
; IN:	A5 canal
; OUT:	D7, F (ERMA64CH)
; MOD:	D7, F.
;=
	PUSHM.32	D4
	CLR.16	D7
	MOVE.32	A5,D4
	COMP.32	{A5}+OCAN,D4
	JUMP,EQ	OUT$
	MOVE.16	#ERMA64CH,D7
	SETV
OUT$:	POPM.32		D4
	RET

;=
	.INS	M64_ASC.ASI		; traitement sur les chanes numriques ascii
	.INS	M64_ASC2.ASI		; sous-rout. M64_ASC (*)

	.INS	M64_CONV.ASI		; convertions fp autres et rciproques
	.INS	M64_ING.ASI		; convertions fp<->ing (*)
	.INS	M64_BIN.ASI		; conv. bin<->fp (*)

	.INS	M64_FP32.ASI		; convertions fp64 <-> fp32 (*)

	.INS	M64_IEEE.ASI		; surplus d  l'mulation MC68881 (*)

	.IF	CONVRAP
	.INS	M64_C32.ASI		; convertions rapides par le 32 bits (*)
	.ENDIF

	.INS	M64_M64.ASI		; routines de calcul 64bits
	.INS	M64_C64.ASI		; """"""""""""""""""""""""" (*)

	.IF	RAPIDE
	.INS	M64_M32.ASI		; routines fp32 pour mode rapide (*)
	.ENDIF
					; (*) => utiliss aussi par M68881.ASM
;*
;-------\\
AFER64:	;>
;-------/
; Affiche un message d'erreur si erreur math64.
;
; IN:	F, D7.
; OUT:	NE si pas erreur MATH64
; MOD:	Z
;=
	JUMP,EQ	L99$
	PUSHM.32	D3|D7|A3

	PUSH_F
	MOVE.32	#R16^TERMA64,A3
	MOVE.16	D7,D3
	CALL	JUMPCAR
	.32	APC
	.16	ERMA64CH,0,L64$
	.16	ERMA64DN,0,L62$
	.16	ERMA64NN,0,L60$
	.16	ERMA64DZ,0,L50$
	.16	ERMA64IV,0,L40$
	.16	ERMA64OV,0,L30$
	.16	ERMA64UN,0,L20$
	.16	ERMA64IE,0,L10$
	.16	0,L80$

L10$:	CALL	L00$
L20$:	CALL	L00$
L30$:	CALL	L00$
L40$:	CALL	L00$
L50$:	CALL	L00$
L60$:	CALL	L00$
L62$:	CALL	L00$
L64$:	LIB	?AFTEXT
	POP.16	F
	COMP.8	D0,D0			; SETZ
	JUMP	L90$

L80$:	POP.16	F			; pas une erreur math64

L90$:	POPM.32		D3|D7|A3

L99$:	RET

L00$:	TEST.8	{A3+}
	JUMP,NE	L00$
	RET

TERMA64:.ASCIZ	"Canal incorrect"
	.ASCIZ	"Nombre dnormalis"
	.ASCIZ	"Pas un nombre"
	.ASCIZ	"Division par 0"
	.ASCIZ	"Opration invalide"
	.ASCIZ	"Dpassement de capacit suprieure"
	.ASCIZ	"Dpassement de capacit infrieure"
	.ASCIZ	"Rsultat inxact"
	.ASCIZ	""
	.EVEN

.IF	FALSE
VD3D4HG:		;= voir D3D4 en haut  gauche (test) mod -
PUSH.16	SF
PUSHM.32	D3..D7
MOVE.32	D3,D5
MOVE.32	D4,D6
LIB	?GETCURS
PUSH.32	D3
CLR.32	D3
LIB	?SETCURS,?AFTIM
.ASCIZE	"<EFLI>FP64 : "
MOVE.32	D5,D3
MOVE.32	D6,D4
CALL	VOIRFP
LIB	?GETCAR
POP.32	D3
LIB	?SETCURS
POPM.32		D3..D7
RETF

;-------\\
VOIRFP:	;>
;-------/
;= Affiche D3..D4.32 :  (-) 0.123456789012 *2^(-) 1234 (27 car max)
; la mantisse et l'exposant sont en hexa, l'exposant est dbiais (pour dbug)
	PUSH_F
	PUSHM.32 A3|D3..D4|D7

	TCLR.32	D3:#31
	JUMP,BC	L10$
	LIB	?AFTIM
	.ASCIZE	"- "

L10$:	LIB	?AFTIM
	.ASCIZE	"0."

	PUSH.32	D4			; affiche mantisse en dcimal
	MOVE.32	D3,D4
	AND.32	#16'FFFF,D4
	LIB	?AFX4
	POP.32	D4
	JUMP,EQ	L20$
	TEST.16	D4
	JUMP,EQ	L15$
	LIB	?AFX8
	JUMP	L20$
L15$:	SWAP.32	D4
	LIB	?AFX4
	SWAP.32	D4

L20$:	PUSHM.32 D3..D4
	LIB	?AFTIM			; exposant
	.ASCIZE	" *2^ "
	SWAP.32	D3
	SUB.16	#16384,D3		; dbiais
	JUMP,NC	L30$
	LIB	?AFTIM			; signe
	.ASCIZE	"- "
	NEG.16	D3
L30$:	MOVE.16	D3,D4			; valeur
	LIB	?AFX4
	POPM.32		D3..D4

	MOVE.32	#R16^BUASC,A3
	CALL	FP64ING
	LIB	?AFTIM
	.ASCIZE	" = "
	LIB	?AFTEXT

	POPM.32	A3|D3..D4|D7
	RETF
BUASC:	.FILL.8	100,0
.ENDIF

ENDMATH64:
	.END

