	.TITLE	MTREE

;	------------------------------------------
;		(C) 1987 - Alwin Dieperink
;		Gestion de l'arbre par F. Klay
;	------------------------------------------

; Rev	Date		Amliorations
; -----------------------------------------------------------------------
; 1.0	06/10/88	Premire version
; 1.1	25/03/90	Nouvel appel MTREE_COPY

MAJREV = 1
MINREV = 1

	.PROC	M68000		; mnmonics CALM 3
	.LAYOUT HEX

	.REF	SMAKY
	.REF	MODULES
	.REF	MTREE

	.REV	MAJREV,MINREV
	.IDENT	"(C)  Alwin Dieperink & EPSITEC-system sa"

	.INS	MTREEVAR.ASI	; variables diverses

	.CHAP	MTREE, Programme principal

; En-tte du module LIB
; ---------------------

	.LOC	0
	MTREE_	FIRST		; code du premier appel
	MTREE_	LAST		; code du dernier appel
	.8	0		; nombre d'installations
	.FILL.8	(OHLREV-APC),0
	.8	MAJREV,MINREV	; rvision.version
	.16	0,END_MTREE	; longueur
	.16	(PATHLIB.AND.16'FFFF0000)/16'10000; pattern de dbut
	.16	PATHLIB.AND.16'FFFF; pattern de dbut
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"MTREE"		; nom du module
	.FILL.8	(LGHLIB-APC),0

	.16	_MTREE_OPEN
	.16	_MTREE_CLOSE

	.16	_MTREE_INS
	.16	_MTREE_MOD
	.16	_MTREE_DEL
	.16	_MTREE_SEARC
	.16	_MTREE_MODCL
	.16	_MTREE_INFO

	.16	_MTREE_SOPEN
	.16	_MTREE_SCLOS
	.16	_MTREE_SSTAR

	.16	_MTREE_SNEXT
	.16	_MTREE_SPREV
	.16	_MTREE_COPY

;--------------\\
; _MTREE_OPEN	>
;--------------/

; Cre un nouvel arbre et retourne son canal

; in	D0.16	nombre max de cellules dans un noeud
;	D1.16	longueur moyenne d'une cellule
; out	A0.32	^descripteur
;	D7.16	erreur
; mod	A0.32
;	D7.16

_MTREE_OPEN:
	PUSHM.32 D1|D2|D4|D6|A4
	MOVE.16	D1,D2			; sauve la longueur moyenne

	MOVE.32	#LGMTREE,D4		; cre un descripteur de mtree
	MOVE.16	#MTYPCP,D1
	GESMEM	?GETMEM
	JUMP,NE	R8^ERROR$

	MOVE.32	A4,{A4}+OIDENT		; pour le controle
	MOVE.16	D0,{A4}+ONBMAX
	MOVE.16	D2,{A4}+OLENAVG
	CLR.32	D4
	MOVE.16	D0,D4
	MUL.16	D2,D4			; dans D4 la longueur d'une tranche

	CALL	CREATE_LIST		; cre une liste vide
	JUMP,NE	R8^ERROR1$
	MOVE.32	D6,{A4}+OCANALLISTE	; canal de la liste

	CALL	_TREE_OPEN		; ouvre un arbre vide
	JUMP,NE	R8^ERROR2$
	MOVE.32	A0,{A4}+ODESCRARBRE	; ^descripteur de l'arbre

	MOVE.32	A4,A0
	JUMP	R8^END$
ERROR2$:
	MOVE.32	{A4}+OCANALLISTE,D6
	PUSH.32	D7
	CALL	DELETE_LIST
	POP.32	D7
ERROR1$:
	PUSH.32	D7
	MOVE.32	#0,{A4}+OIDENT
	MOVE.16	#MTYPCP,D1
	GESMEM	?GIVMEM			; rends la mmoire
	POP.32	D7
ERROR$:
	MOVE.32	#0,A0
END$:
	POPM.32	D1|D2|D4|D6|A4
	TEST.16	D7
	RET

;--------------\\
; _MTREE_CLOSE	>
;--------------/

; Dtruit un arbre

; in	A0.32	^descripteur
; out	D7.16	erreur
; mod	D7.16

_MTREE_CLOSE:
	PUSHM.32 D1|D6|A0|A4
	COMP.32	{A0}+OIDENT,A0
	JUMP,NE	R8^ERROR1$

	MOVE.32	A0,A4

	MOVE.32	{A4}+OCANALLISTE,D6	; ferme la liste
	CALL	DELETE_LIST

	MOVE.32	{A4}+ODESCRARBRE,A0	; ferme l'arbre
	CALL	_TREE_CLOSE

	MOVE.32	#0,{A4}+OIDENT		; identificateur NUL
	MOVE.16	#MTYPCP,D1		; rends la mmoire utilise
	GESMEM	?GIVMEM
	CLR.16	D7
	JUMP	R8^END$
ERROR1$:
	MOVE.16	#ERTBTD,D7
END$:
	POPM.32	D1|D6|A0|A4
	TEST.16	D7
	RET

;--------------\\
; _MTREE_INS	>
;--------------/

; Insre une nouvelle tranche

; in	A0.32	^descripteur
;	D0.32	cl      cellule  insrer
;	D4.32	longueur cellule  insrer
; out	A4.32	^cellule
;	D7.16	erreur
; mod	A4.32
;	D7.16

_MTREE_INS:
	PUSHM.32 D1|D6|A0|A2|A6
	COMP.32	{A0}+OIDENT,A0
	JUMP,NE	R8^ERDESC$

	MOVE.32	A0,A6
	MOVE.32	#0,A4

	MOVE.32	{A6}+OCANALLISTE,D6
	MOVE.32	{A6}+ODESCRARBRE,A0

	CALL	_TREE_SEARCH			; cherche si l'lment existe
	JUMP,EQ	R8^ERKAEX$				; oui --> lment existe dj
	COMP.16	#ERTKNEX,D7
	JUMP,NE	R8^END$				; autre erreur que "cl n'existe pas"
	CALL	CREATE_ELEMENT			; cre l'lment
	JUMP,NE	R8^END$				; ^lment --> A2
	MOVE.32	A2,D1
	CALL	_TREE_INS			; insre l'lment dans l'arbre
	JUMP,NE	R8^END$

	MOVE.32	#{A2}+OEECONTENU,A4
	MOVE.16	#0,D7				; pas d'erreur
	JUMP	R8^END$
ERKAEX$:
	MOVE.16	#ERTKAEX,D7			; erreur : Cellule existe dj
	JUMP	R8^END$
ERDESC$:
	MOVE.16	#ERTBTD,D7			; erreur : mauvais descripteur
END$:
	POPM.32	D1|D6|A0|A2|A6
	TEST.16	D7
	RET

;--------------\\
; _MTREE_MOD	>
;--------------/

; Modifie les informations d'une cellule de l'arbre

; in	A0.32	^descripteur
;	D0.32	cl      cellule  modifier
;	D4.32	longueur cellule  modifier
; out	A4.32	nouveau ^cellule
;	D7.16	erreur
; mod	A4.32
;	D7.16

_MTREE_MOD:
	PUSHM.32 D1|D6|A0|A2|A6
	COMP.32	{A0}+OIDENT,A0
	JUMP,NE	R8^ERDESC$

	MOVE.32	A0,A6
	MOVE.32	#0,A4

	MOVE.32	{A6}+OCANALLISTE,D6
	MOVE.32	{A6}+ODESCRARBRE,A0

	CALL	_TREE_SEARCH			; ^descr lment
	JUMP,NE	R8^END$				; si pas d'erreur, la cl existe
	MOVE.32	D1,A2				; --> A2

	CALL	DELETE_ELEMENT			; dtruit l'lment ***** ( modifier)
	CALL	CREATE_ELEMENT			; et le recre
	JUMP,NE	R8^END$

	MOVE.32	A2,D1
	CALL	_TREE_MOD			; modifie le contenu dans l'arbre
	JUMP,NE	R8^END$

	MOVE.32	#{A2}+OEECONTENU,A4
	MOVE.16	#0,D7
	JUMP	R8^END$
ERDESC$:
	MOVE.16	#ERTBTD,D7
END$:
	POPM.32	D1|D6|A0|A2|A6
	TEST.16	D7
	RET

;--------------\\
; _MTREE_DEL	>
;--------------/

; Supprime une cellule identifie par sa cl de l'arbre

; in	A0.32	^descripteur
;	D0.32	cl cellule  dtruire
; out	D7.16	erreur
; mod	D7.16

_MTREE_DEL:
	PUSHM.32 D1|D6|A0|A2|A6
	COMP.32	{A0}+OIDENT,A0
	JUMP,NE	R8^ERDESC$

	MOVE.32	A0,A6

	MOVE.32	{A6}+ODESCRARBRE,A0
	MOVE.32	{A6}+OCANALLISTE,D6
	CALL	_TREE_SEARCH			; --> D1 le ^ au descrip. de l'lment
	JUMP,NE	R8^END$
	MOVE.32	D1,A2
	CALL	DELETE_ELEMENT
	CALL	_TREE_DEL

	MOVE.16	#0,D7
	JUMP	R8^END$
ERDESC$:
	MOVE.16	#ERTBTD,D7
END$:
	POPM.32	D1|D6|A0|A2|A6
	TEST.16	D7
	RET

;--------------\\
; _MTREE_SEARC	>
;--------------/

; Cherche les informations relative  une cellule identifie par sa
; cl dans l'arbre

; in	A0.32	^descripteur
;	D0.32	cl cellule  chercher
; out	A4.32	^cellule
;	D4.32	longueur de la cellule
;	D7.16	erreur
; mod	D4.32
;	D7.16

_MTREE_SEARC:
	PUSHM.32 D1|A0|A2|A6
	COMP.32	{A0}+OIDENT,A0
	JUMP,NE	R8^ERDESC$

	MOVE.32	A0,A6

	MOVE.32	#0,A4
	MOVE.32	#0,D4

	MOVE.32	{A6}+ODESCRARBRE,A0

	CALL	_TREE_SEARCH
	JUMP,NE	R8^END$			; lment pas trouv
	MOVE.32	D1,A2

	MOVE.32	{A2}+OEELONGCONT,D4
	MOVE.32	#{A2}+OEECONTENU,A4

	JUMP	R8^END$
ERDESC$:
	MOVE.16	#ERTBTD,D7
END$:
	POPM.32	D1|A0|A2|A6
	TEST.16	D7
	RET

;--------------\\
; _MTREE_MODCL	>
;--------------/

; Modifie la cl sans modifier le contenu

; in	A0.32	^descripteur
;	D0.32	ancienne cl
;	D1.32	nouvelle cl
; out	D7.16	erreur
; mod	D7.16

_MTREE_MODCL:
	PUSHM.32 A0|A6|D0|D1|D2
	COMP.32	{A0}+OIDENT,A0
	JUMP,NE	R8^ERDESC$

	MOVE.32	A0,A6

	MOVE.32	{A6}+ODESCRARBRE,A0

	PUSHM.32 D1
	CALL	_TREE_SEARCH
	MOVE.32	D1,D2			; D2 <-- ^lment
	POPM.32	D1

	CALL	_TREE_DEL		; dtruit l'ancien dans l'arbre
	JUMP,NE	R8^END$
	MOVE.32	D1,D0			; nouvelle cl
	MOVE.32	D2,D1			; ^lment
	CALL	_TREE_INS

	JUMP	R8^END$
ERDESC$:
	MOVE.16	#ERTBTD,D7
END$:
	POPM.32	A0|A6|D0|D1|D2
	TEST.16	D7
	RET

;--------------\\
; _MTREE_INFO	>
;--------------/

; Retourne des informations relative  un arbre identifi par son canal

; in	A0.32	^descripteur
; out	D0.32	nombre de cellules dans l'arbre
;	D7.16	erreur
; mod	D0.32
;	D7.16

_MTREE_INFO:
	PUSHM.32 A0|A6
	COMP.32	{A0}+OIDENT,A0
	JUMP,NE	R8^ERDESC$

	MOVE.32	A0,A6

	MOVE.32	{A6}+ODESCRARBRE,A0
	CALL	_TREE_INFO

	MOVE.16	#0,D7
	JUMP	R8^END$
ERDESC$:
	MOVE.16	#ERTBTD,D7
END$:
	POPM.32	A0|A6
	TEST.16	D7
	RET

;--------------\\
; _MTREE_SOPEN	>
;--------------/

; Cre et initialise un descripteur d'acces squentiel

; in	A0.32	^descripteur
; out	A1.32	^descripteur accs squentiel
;	D7.16	erreur
; mod	A1.32
;	D7.16

_MTREE_SOPEN:
	PUSHM.32 A0|A6
	COMP.32	{A0}+OIDENT,A0
	JUMP,NE	R8^ERDESC$

	MOVE.32	A0,A6

	MOVE.32	{A6}+ODESCRARBRE,A0
	CALL	_TREE_SOPEN

	JUMP	R8^END$
ERDESC$:
	MOVE.16	#ERTBTD,D7
END$:
	POPM.32	A0|A6
	TEST.16	D7
	RET

;--------------\\
; _MTREE_SCLOS	>
;--------------/

; Dtruit un descripteur d'accs squentiel

; in	A0.32	^descripteur
;	A1.32	^descripteur accs squentiel
; out	D7.16	erreur
; mod	D7.16

_MTREE_SCLOS:
	PUSHM.32 A0|A6
	COMP.32	{A0}+OIDENT,A0
	JUMP,NE	R8^ERDESC$

	MOVE.32	A0,A6

	MOVE.32	{A6}+ODESCRARBRE,A0
	CALL	_TREE_SCLOSE

	JUMP	R8^END$
ERDESC$:
	MOVE.16	#ERTBTD,D7
END$:
	POPM.32	A0|A6
	TEST.16	D7
	RET

;--------------\\
; _MTREE_SSTAR	>
;--------------/

; Cherche la cellule dont la cl est gale ou directement suprieure (inf-
; rieure si elle n'existe pas)  celle donne en entre, et initialise le
; descripteur d'accs squentiel. Si en entre la valeur de la cl est 0 ou -1,
; on a respectivement la cellule dont la cl est minimale ou maximale dans
; l'arbre.
; Cet appel est utilis avant next ou prev pour fixer la position de dpart de
; l'accs squentiel. S'il est omis, la position de dpart est la cellule
; virtuelle qui se trouve avant la premire; dans ce cas, next fournira la
; cellule dont la cl est la plus petite de l'arbre et prev retournera une
; erreur.

; in	D0.32	cl
;	A0.32	^descripteur
;	A1.32	^descripteur accs squentiel
; out	D0.32	cl
;	A4.32	^cellule
;	D4.32	longueur de la cellule
;	D7.16	erreur
; mod	D0.32
;	A4.32
;	D4.32
;	D7.16

_MTREE_SSTAR:
	PUSHM.32 D1|A0|A2|A6
	COMP.32	{A0}+OIDENT,A0
	JUMP,NE	R8^ERDESC$

	MOVE.32	A0,A6

	MOVE.32	#0,A4
	MOVE.32	#0,D4

	MOVE.32	{A6}+ODESCRARBRE,A0
	CALL	_TREE_SSTART
	JUMP,NE	R8^END$
	MOVE.32	D1,A4

	MOVE.32	{A4}+OEELONGCONT,D4
	MOVE.32	#{A4}+OEECONTENU,A4

	JUMP	R8^END$
ERDESC$:
	MOVE.16	#ERTBTD,D7
END$:
	POPM.32	D1|A0|A2|A6
	TEST.16	D7
	RET

;--------------\\
; _MTREE_SNEXT	>
;--------------/

; Retourne la cellule suivante dans l'arbre.

; in	A0.32	^descripteur
;	A1.32	^descripteur accs squentiel
; out	D0.32	cl suivante
;	A4.32	^cellule
;	D4.32	longueur de la cellule
;	D7.16	erreur
; mod	D0.32
;	D4.32
;	D7.16

_MTREE_SNEXT:
	PUSHM.32 D1|A0|A2|A6
	COMP.32	{A0}+OIDENT,A0
	JUMP,NE	R8^ERDESC$

	MOVE.32	A0,A6

	MOVE.32	#0,A4
	MOVE.32	#0,D4

	MOVE.32	{A6}+ODESCRARBRE,A0
	CALL	_TREE_SNEXT
	JUMP,NE	R8^END$
	MOVE.32	D1,A2

	MOVE.32	{A2}+OEELONGCONT,D4
	MOVE.32	#{A2}+OEECONTENU,A4

	JUMP	R8^END$
ERDESC$:
	MOVE.16	#ERTBTD,D7
END$:
	POPM.32	D1|A0|A2|A6
	TEST.16	D7
	RET

;--------------\\
; _MTREE_SPREV	>
;--------------/

; Retourne la cellule prcdente dans l'arbre.

; in	A0.32	^descripteur
;	A1.32	^descripteur accs squentiel
; out	D0.32	cl prcdente
;	A4.32	^cellule
;	D4.32	longueur de la cellule
;	D7.16	erreur
; mod	D0.32
;	D4.32
;	A4.32
;	D7.16

_MTREE_SPREV:
	PUSHM.32 D1|A0|A2|A6
	COMP.32	{A0}+OIDENT,A0
	JUMP,NE	R8^ERDESC$

	MOVE.32	A0,A6

	MOVE.32	{A6}+ODESCRARBRE,A0
	CALL	_TREE_SPREV
	JUMP,NE	R8^END$
	MOVE.32	D1,A2

	MOVE.32	{A2}+OEELONGCONT,D4
	MOVE.32	#{A2}+OEECONTENU,A4

	JUMP	R8^END$
ERDESC$:
	MOVE.16	#ERTBTD,D7
END$:
	POPM.32	D1|A0|A2|A6
	TEST.16	D7
	RET

;------------\\
; _MTREE_COPY >
;------------/

; effectue une copie conforme d'un arbre

; in	A0.32	^ descripteur arbre source
; out	A0.32	^ descripteur copie
; mod	A0.32, D7.16

_MTREE_COPY:
	PUSHM.32 D0|D1|D4|A1..A4
	MOVE.16	#ERTBTD,D7
	COMP.32	{A0}+OIDENT,A0
	JUMP,NE	R8^END$

	MOVE.16	{A0}+ONBMAX,D0
	MOVE.16	{A0}+OLENAVG,D1
	PUSHM.32 A0
	CALL	_MTREE_OPEN
	MOVE.32	A0,A2		; A2 <- ^ descripteur nouvel arbre
	POPM.32	A0
	TEST.16	D7
	JUMP,NE	END$
	
	CALL	_MTREE_SOPEN
	JUMP,NE	END$
LOOP$:
	CALL	_MTREE_SNEXT	; D0/A4/D4 <- cl/^tranche/longueur
	JUMP,NE	ENDLOOP$
	MOVE.32	A4,A3
	PUSHM.32 A0
	MOVE.32	A2,A0
	CALL	_MTREE_INS
	POPM.32	A0
	JUMP,NE	ERRENDLOOP$
	DEC.16	D4		; -1  cause de NMO
COPY$:
	MOVE.8	{A3+},{A4+}
	DJ.16,NMO D4,COPY$
	JUMP	LOOP$

ENDLOOP$:
	CLR.16	D7
ERRENDLOOP$:
	PUSH.16	D7
	CALL	_MTREE_SCLOS
	POP.16	D7
	JUMP,NE	END$
	MOVE.32	A2,A0
END$:
	POPM.32	D0|D1|D4|A1..A4
	TEST.16	D7
	RET



	.INS	MTREELIST.ASI
	.INS	MTREETREE.ASI


END_MTREE:


	.END
	.EN