/*
 *	atom.h
 *
 *	Atomic name management. An atom is a unique string.
 *
 *	(C) Copyright 1996, Pierre ARNAUD, LAMI - EPFL, CH-1015 Lausanne
 */

#ifndef	_SB_ATOM_H_
#define	_SB_ATOM_H_

/*****************************************************************************/

class Atom
{
	const char*		name;
public:
	Atom (const char* n = 0);
	Atom (const Atom& a) : name (a.name) { }
	
	Atom& operator = (const char* n);
	Atom& operator = (const Atom& a) { name = a.name; return *this; }

	operator const char* () const	{ return name; }
	
	friend int operator == (const Atom& a1, const Atom& a2);
	friend int operator != (const Atom& a1, const Atom& a2);
};

inline int operator == (const Atom& a1, const Atom& a2) { return a1.name == a2.name; }
inline int operator != (const Atom& a1, const Atom& a2) { return a1.name != a2.name; }

/*****************************************************************************/

#endif /* _SB_ATOM_H_ */
