
#include "../smreg.h"

#include <c++/portable.h>
#include <c++/mon.h>

typedef void (*pf)(...);

extern "C" pf   global_lib_table[1];

extern "C" void global_init ();
extern "C" void global_cleanup ();
extern "C" void __do_global_init ();
extern "C" void __do_global_cleanup ();

extern "C" int  memory_type;
extern "C" long memory_desc;

extern "C" int G_getmem(long *length, int type, long *desc_memptr);
extern "C" int G_givmem(void *memptr, int type, long desc);

extern "C" void abort ();
extern "C" void* malloc (unsigned long);
extern "C" void free (void*);

int  memory_type;
long memory_desc;


//  The global LIB table defines the pointers to each function
//  implemented by the C library.

pf global_lib_table[1] = { (pf) Reg::GetRegistry };


//  Global initilisation function called just after relocation.
//  This usually calls the global constructors.

void
global_init ()
{
	AfText ("Global init D1="); AfX8 (memory_type);
	AfText (", A1="); AfX8 (memory_desc);
	AfCR ();
	__do_global_init ();
}

//  Global cleanup function called when the library wants to
//  unload the module. This usually calls the global destructors.

void
global_cleanup ()
{
	AfText ("Cleanup D1="); AfX8 (memory_type);
	AfText (", A1="); AfX8 (memory_desc);
	AfCR ();
	__do_global_cleanup ();
}

void*
malloc (unsigned long l)
{
	long len  = l;
	long ptr  = memory_desc;
	int error = G_getmem (&len, memory_type, &ptr);
	if (error == 0) return (void*)(ptr);
	return 0;
}

void
free (void* ptr)
{
	G_givmem (ptr, memory_type, memory_desc);
}

void
abort ()
{
	asm ("trap #0");
}
