/*
 *	dynamic.h
 *
 *	Smaky Registry / INTERNAL.
 *
 *	Base class for data and level access in the Registry.
 *
 *	(C) Copyright 1996-1997, Pierre ARNAUD, OPaC bright ideas
 *		CH-1437 Suscevaz
 */

#ifndef _DYNAMIC_H_
#define	_DYNAMIC_H_

#include "smreg.h"
#include "regkey.h"

class RegDynamic
{
public:
	virtual Bool Enter ()														= 0;
	virtual Bool Release ()														= 0;
	
	virtual int  Insert (RegValue& value, RegHive* hive = 0)					= 0;
	virtual Bool Remove (RegValue& value)										= 0;
	
	virtual Bool Find (RegValue& value, RegHive** hive_ptr = 0)					= 0;
	virtual Bool Find (Card32& iter, RegValue& value, RegHive** hive_ptr = 0)	= 0;
};

#endif /* _DYNAMIC_H_ */

