/*
 *	portable.h
 *
 *	Smaky Registry: portable types and some standard C library
 *	calls (which might need to be re-implemented to build a Smaky
 *	library).
 *
 *	(C) Copyright 1996-1997, Pierre ARNAUD, OPaC bright ideas
 *		CH-1437 Suscevaz
 */

#ifndef _SR_PORTABLE_H_
#define	_SR_PORTABLE_H_

/*****************************************************************************/

#ifdef __smaky__

#include <C++/portable.h>
#include <stddef.h>

class AutoLock
{
	Card32*		id;
public:
	
	AutoLock (Card32* l)
	{
		if (l[0] == 0) {
			asm volatile ( "moveql #0,d4\n\t"
						   ".long  0x4E44000A\n\t"	// NTREL?CRESEM
						   "movel  a5,%0"
						 : "=g" (l[0])
						 :
						 : "d4", "d7", "a5" );
			l[1] = 1;
		}
		
		id = l;
		
		asm volatile ( "subql #1,%0\n\t"
					   "jeq 1f\n\t"
					   "moveql #-1,d4\n\t"
					   ".long  0x4E44005A\n\t"		// NTREL?MODTIM
					   "movel  %1,a5\n\t"
					   ".long  0x4E440043\n\t"		// NTREL?LOCK
					   ".long  0x4E44005A\n\t"		// NTREL?MODTIM
					   "1:"
					 : "=g" (id[1])
					 : "g"  (id[0])
					 : "d4", "d7", "a5" );
	}
	
	~AutoLock ()
	{
		asm volatile ( "addql #1,%0\n\t"
					   "jgt 1f\n\t"
					   "movel  %1,a5\n\t"
					   ".long  0x4E440044\n\t"		// NTREL?UNLOCK
					   "1:"
					 : "=g" (id[1])
					 : "g" (id[0])
					 : "d7", "a5" );
	}

	static void KillLock (Card32* l)
	{
		asm volatile ( "movel  %0,a5\n\t"
					   ".long  0x4E44000D\n\t"		// NTREL?KILLSEM
					 : : "g" (l[0])
					 : "d7", "a5" );
	}
};

#define	USE(x)	asm volatile ( "# using %0" : : "g" (&(x)))

#else

/*****************************************************************************/

//	This is for non-smaky compilation only :

typedef signed long   Int32;
typedef unsigned long Card32;
typedef unsigned char Bool;

#define	FALSE	0
#define	TRUE	1

class AutoLock
{
	Card32		id;
public:
	AutoLock (Card32* l)			 { id = l[0]; }
	~AutoLock ()					 { }
	static void KillLock (Card32* l) { }
};

#define	USE(x)

#endif

/*****************************************************************************/

//	Common definitions :

typedef double Real;

/*****************************************************************************/

//	Miscellaneous :

extern "C" int strcmp (const char*, const char*);
extern "C" size_t strlen (const char*);
extern "C" char* strcpy (char*, const char*);
extern "C" void* memcpy (void*, const void*, size_t);

extern "C" void* malloc (size_t);
extern "C" void free (void*);

/*****************************************************************************/

#endif

