/*
 *	regdata.h
 *
 *	The Registry Data class makes dynamic data publishing
 *	possible in any registry sub-tree.
 *
 *	(C) Copyright 1996-1997, Pierre ARNAUD, OPaC bright ideas
 *		CH-1437 Suscevaz
 */

#ifndef _REGDATA_H_
#define	_REGDATA_H_

#include "smreg.h"

class Registry;
class RegKey;

class RegData
{
	struct IDList						//	each registered class is stored in a list
	{
		IDList*		next;				//	link to next class
		RegData*	(*func)();			//	allocation function used to create a new object
		Card32		id;					//	unique class ID associated to the class
	};

	static IDList*	id_list;
	
protected:
	Card32			class_id;			//	unique class ID for each data publisher class
	
	Card32			startup_len;		//	length of startup information
	char*			startup_data;		//	copy of startup information
	Registry*		startup_reg;
	RegKey*			startup_father;
	
public:
	RegData ();
	virtual ~ RegData ();
	
	RegData* Clone ();
	
	virtual Bool Startup (const char* data, Card32 len, Registry* reg, RegKey* father);
	virtual Bool FillRegValue (RegValue& value) = 0;
	
	Card32 GetClassID () const			{ return this->class_id; }
	Card32 GetStartupLength () const	{ return this->startup_len; }
	const char* GetStartupData () const	{ return this->startup_data; }

	static RegData* AllocFromClassID (Card32 id);
	static void RegisterClassID (Card32 id, RegData* (*)());
};

#endif /* _REGDATA_H_ */

