/*
 *	regddhive.cxx
 *
 *	Smaky Registry / INTERNAL.
 *
 *	This Dynamic Data provider handles the automatic loading and
 *	saving of a whole subtree of the registry, based on the RegData
 *	class and on the ShadowRegKey + ShadowHelper classes.
 *
 *	(C) Copyright 1997, Pierre ARNAUD, OPaC bright ideas
 *		CH-1437 Suscevaz
 */

#include "regddhive.h"
#include "registry.h"

#include <c++/mon.h>

#define RegDDHive_CLASS_ID	0x00000001

int 			g_dummy_regddhive = 0;		//	required: otherwise the file won't be linked
ShadowHelpDDH*	RegDDHive::helper = 0;		//	only helper needed for this class

/*
 */

RegDDHive::RegDDHive ()
{
	this->class_id = RegDDHive_CLASS_ID;
	this->shadow   = 0;
}

RegDDHive::~RegDDHive ()
{
	this->Cleanup ();
}


/*
 *	Release the allocated resources (if any).
 */

void
RegDDHive::Cleanup ()
{
	if (this->shadow) {
		delete this->shadow;
		this->shadow = 0;
	}
}


/*
 *	Call the `super' method first.
 */

Bool
RegDDHive::Startup (const char* data, Card32 len, Registry* reg, RegKey* father)
{
	if (RegData::Startup (data, len, reg, father) == FALSE) {
		return FALSE;
	}
	
	this->Cleanup ();
	this->shadow = new ShadowRegKey (reg, father);
	
	if (RegDDHive::helper == 0) {
		RegDDHive::helper = new ShadowHelpDDH ();
	}
	
	this->shadow->SetShadow (0);
	this->shadow->SetHelper (RegDDHive::helper);
	this->shadow->SetHelperInfo (this);
	
	//	do it...
	
	return TRUE;
}


/*
 *	Return the "artificially built" value which corresponds
 *	in fact to the sub-tree.
 */

Bool
RegDDHive::FillRegValue (RegValue& value)
{
	value.type           = REG_TYP_X_LEVEL;
	value.name.token     = 0;
	value.data.level.key = this->shadow;
	
	return (this->shadow ? TRUE : FALSE);
}

/*
 *	Special method used to register the class ID of RegDDHive.
 */

void
RegDDHive::DoRegisterClassID ()
{
	RegData::RegisterClassID (RegDDHive_CLASS_ID, RegDDHive::Alloc);
}


/*
 *	Just return a new instance of the dynamic data class.
 *	This is the only way an instance of RegDDHive can be
 *	allocated by RegData::AllocFromClassID.
 */

RegData*
RegDDHive::Alloc ()
{
	return new RegDDHive;
}

class RegDDHiveRegister { public : RegDDHiveRegister () { RegDDHive::DoRegisterClassID (); } } x;


/*****************************************************************************/

ShadowHelpDDH::ShadowHelpDDH ()
{
}

ShadowHelpDDH::~ShadowHelpDDH ()
{
}

Bool
ShadowHelpDDH::Enter (RegKey*& shadow)
{
	ShadowRegKey* key = (ShadowRegKey*)(shadow);
	RegDDHive* ddhive = (RegDDHive*)(key->GetHelperInfo ());
	
	AfText ("Enter of shadow key : ");
	AfText (ddhive->GetStartupData ());
	AfCR ();
	
	return TRUE;
}

Bool
ShadowHelpDDH::Release (RegKey*& shadow)
{
	ShadowRegKey* key = (ShadowRegKey*)(shadow);
	RegDDHive* ddhive = (RegDDHive*)(key->GetHelperInfo ());
	
	AfText ("Release of shadow key : ");
	AfText (ddhive->GetStartupData ());
	AfCR ();
	
	return TRUE;
}


