/*
 *	regddhive.h
 *
 *	Smaky Registry / INTERNAL.
 *
 *	This Dynamic Data provider handles the automatic loading and
 *	saving of a whole subtree of the registry, based on the RegData
 *	class and on the ShadowRegKey + ShadowHelper classes.
 *
 *	(C) Copyright 1997, Pierre ARNAUD, OPaC bright ideas
 *		CH-1437 Suscevaz
 */

#ifndef _REGDDHIVE_H_
#define	_REGDDHIVE_H_

#include "regdata.h"
#include "regkey.h"

/*****************************************************************************/

class ShadowHelpDDH;

/*****************************************************************************/

class RegDDHive : public RegData
{
	friend class ShadowHelpDDH;
	
protected:
	ShadowRegKey*			shadow;		//	shadow of the "value"
	static ShadowHelpDDH*	helper;		//	helper
	
	static RegData* Alloc ();
	void Cleanup ();
	
public:
	RegDDHive ();
	virtual ~ RegDDHive ();
	
	virtual Bool Startup (const char* data, Card32 len, Registry* reg, RegKey* father);
	virtual Bool FillRegValue (RegValue& value);
	
	static void DoRegisterClassID ();
};

/*****************************************************************************/

class ShadowHelpDDH : public ShadowHelper
{
public:
	ShadowHelpDDH ();
	virtual ~ ShadowHelpDDH ();
	
	virtual Bool Enter (RegKey*& shadow);
	virtual Bool Release (RegKey*& shadow);
};

/*****************************************************************************/

#endif /* _REGDDHIVE_H_ */

