/*
 *	registry.h
 *
 *	Smaky Registry / INTERNAL.
 *
 *	The registry class provides useful methods for accessing some
 *	keys and handling the atom data base.
 *
 *	(C) Copyright 1996-1997, Pierre ARNAUD, OPaC bright ideas
 *		CH-1437 Suscevaz
 */


#ifndef _REGISTRY_H_
#define	_REGISTRY_H_

#include "smreg.h"

class RegKey;
class RegHive;

/*****************************************************************************/

class Registry
{
	struct KeyInfo
	{
		RegKey*		key;
		Card32		id;
	};

	struct HiveInfo
	{
		RegHive*	hive;
		Card32		id;
	};

private:
	RegKey*			root;			//	root of the registry
	
	KeyInfo*		enter_array;	//	array of entered keys
	Card32			enter_max;		//	maximum # of keys in array
	Card32			enter_num;		//	current # of keys in array
	Card32			id_of_next;		//	ID of next entered key
	Bool			id_wrapped;		//	ID wrapped to zero (slower checking !)

	HiveInfo*		hive_array;		//	array of existing hives
	Card32			hive_max;		//	maximum # of hives in array
	Card32			hive_num;		//	current # of hives in array

protected:
	Bool GrowEnterArray ();
	Bool GrowHiveArray ();
	
	Card32 NewID ();
	
public:
	Registry ();
	~Registry ();

	const char* MakeAtom (const char* name);
	RegKey* Root () const;
	void SetRoot (RegKey* key)		{ this->root = key; }

	Bool NotifyEnter (RegKey* key);
	Bool NotifyRelease (RegKey* key);
	
	Bool NotifyNewHive (RegHive* hive);
	Bool NotifyDeleteHive (RegHive* hive);
	
	RegKey* FindKeyFromID (Card32 key_id);
	Card32 KeyID (RegKey* key);
};

/*****************************************************************************/

void* operator new (size_t);
void  operator delete (void*);

/*****************************************************************************/

#endif /* _REGISTRY_H_ */

