/*
 *	main.cpp
 *
 *	Ugly test program. This tries to check every function
 *	provided by the registry.
 *
 *	(C) Copyright 1996, Pierre ARNAUD, OPaC bright ideas
 *		CH-1437 Suscevaz
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "registry.h"

static Reg* grg = 0;

#ifndef __smaky__

/*
 *	Following part should not belong to the user side of
 *	the registry... This is only for testing...
 */

#include "library/regdata.h"
#include "library/registry.h"

class DynamicData : public RegData
{
protected:
	
public:
	DynamicData ()				{ this->class_id = 0x0B0A00BA; }
	virtual ~ DynamicData ()	{ }
	
	virtual Bool Startup (const char*, Card32);
	virtual Bool FillRegValue (RegValue& value)
	{
		value.type &= 0xFF000000;
		value.type |= REG_TYP_LATIN | REG_TYP_ARRAY;
		value.data.array.data = this->startup_data;
		value.data.array.num  = this->startup_len;
		return TRUE;
	}

	static RegData* Alloc ()	{ return new DynamicData (); }
};

Bool
DynamicData::Startup (const char* data, Card32 len)
{
	return RegData::Startup (data, len);
}

#endif


static FILE* file = 0;
static int   file_len = 0;

int
my_write (const void* arg, Card32 len, void* f)
{
	if (file) {
		fwrite (arg, len, 1, file);
		file_len += len;
	}

	const unsigned char* data = (const unsigned char*)(arg);

	for (unsigned i = 0; i < len; i += 16) {
		printf ("- ");
		for (unsigned j = 0; (i+j < len) && (j < 16); j++) {
			printf ("%02lx ", (unsigned long)(data[i+j]));
		}
		for (; j < 16; j++) printf ("   ");
		printf (": ");
		for (j = 0; (i+j < len) && (j < 16); j++) {
			printf ("%c",  iscntrl (data[i+j]) ? '.' : data[i+j] );
		}
		printf ("\n");
	}

	return 0;
}


void
dump_tree (Card32 key_id, int depth = 0)
{
	RegValue value = { 0 };
	Card32   index = 0;

	while (grg->Explore (key_id, index, value)) {
		for (int i = 0; i < depth; i++) printf ("| ");
		printf ("+-> %s\n", grg->GetName (value));
		if ( (value.type & 0xFF) == REG_TYP_X_LEVEL) {
			const char* name = grg->GetName (value);
			Card32 deeper = grg->EnterKey (key_id, name);
			dump_tree (deeper, depth+1);
			grg->ReleaseKey (deeper);
		}
		value.type = 0;
	}
}

void
main ()
{
	grg = Reg::GetRegistry ();
	
	Card32 root     = grg->Open ();
	Card32 array[3] = { 10, 20, 30 };

	RegValue value;
	
	value.type            = REG_TYP_INTEGER | REG_NAM_STRING | REG_TYP_ARRAY;
	value.name.string     = "ArrayOfIntegers";
	value.data.array.data = array;
	value.data.array.num  = 3;
	grg->CreateValue (root, value);
	grg->CreateValue (root, value);
	grg->CreateValue (root, value);

#ifndef __smaky__
	RegData::RegisterClassID (0x0B0A00BA, DynamicData::Alloc);
	
	value.type            = REG_TYP_X_DDATA | REG_NAM_STRING;
	value.name.string     = "DynamicData";
	value.data.dynamic.data = new DynamicData ();
	value.data.dynamic.temp = 0x00000000;
	value.data.dynamic.data->Startup ("Hello !", 8);
	grg->CreateValue (root, value);
#endif
	
	value.type            = REG_TYP_BOOLEAN | REG_NAM_STRING;
	value.name.string     = "YesOrNo";
	value.data.boolean    = TRUE;
	grg->CreateValue (root, value);
	
	Card32 subtree        = grg->CreateKey (root, "Subtree");
	Card32 restore_key    = grg->CreateKey (root, "Restore");
	
	value.type            = REG_TYP_REAL | REG_NAM_STRING;
	value.name.string     = "DeepInTheTree";
	value.data.real       = 3.1415926;
	grg->CreateValue (subtree, value);
	
	value.type            = REG_TYP_REAL | REG_NAM_STRING;
	value.name.string     = "RestoreInTheTree";
	value.data.real       = 1.23456789;
	grg->CreateValue (restore_key, value);
	
	//	Show the current registry contents.
	
	dump_tree (root);
	printf ("\n");

	Card32 restore2_key   = grg->CreateKey (root, "Restore");
	value.type            = REG_TYP_REAL | REG_NAM_STRING;
	value.name.string     = "Restore Part 2";
	value.data.real       = 0;
	grg->CreateValue (restore2_key, value);
	
	dump_tree (root);
	printf ("\n");

	//	Save the full hive.
	
	printf ("Changed = %s\n", grg->HasHiveChanged (0) ? "Yes" : "No");
	printf ("Dumping the full hive to disk.\n");

	file = fopen ("test.reg", "wb");
	if (file == 0) return;
	grg->SaveHive (0, my_write, 0);
	fclose (file);
	printf ("Changed = %s\n", grg->HasHiveChanged (0) ? "Yes" : "No");
	
	//	Load the hive back into the registry. Restore it under another
	//	sub-tree.
	
	char* buffer = new char[file_len];
	file = fopen ("test.reg", "rb");
	if (file == 0) return;
	fread (buffer, file_len, 1, file);
	fclose (file);
	
	Card32 restored_hive = grg->LoadHive (0, restore_key, buffer);
	memset (buffer, 'X', file_len);
	delete buffer;
	
	grg->KillKeyOrValue (root, "ArrayOfIntegers");
	grg->ReleaseKey (subtree);
	grg->ReleaseKey (restore_key);
	grg->ReleaseKey (restore2_key);
	
	printf ("Restored tree:\n");
	restore_key = grg->EnterKey (root, "Restore");
	dump_tree (restore_key);
	grg->ReleaseKey (restore_key);
	
	printf ("Full tree:\n");
	dump_tree (root);

	//	Some experimentation : TIMING
	
	{
		Card32 key_1 = 0;
		Card32 key_2 = 0;
		
		if (key_1 = grg->EnterKey (root, "Restore")) {
			if (key_2 = grg->EnterKey (key_1, "Subtree")) {
				value.type        = REG_NAM_STRING;
				value.name.string = "DeepInTheTree";
				if (grg->GetValue (key_2, value)) {
					
					//	Takes about 2.1 us on a Pentium 133MHz
					//	Takes about 65 us on a Smaky 130 (30 times slower)
					
					printf ("Restore:Subtree:DeepInTheTree = %lf\n", value.data.real);
					long x = 100000;
					while (x--) grg->GetValue (key_2, value);
					printf ("Done 100'000 times.\n");
				}
			}
		}

		grg->ReleaseKey (key_1);
		grg->ReleaseKey (key_2);
	}
	
	//	Some experimentation : DYNAMIC DATA ACCESS
	
	{
		Card32 key_1 = 0;
		char buffer[100];
		
		if (key_1 = grg->EnterKey (root, "Restore")) {
			
			value.type            = REG_NAM_STRING | REG_TYP_ARRAY;
			value.data.array.data = buffer;
			value.data.array.num  = 100;
			value.name.string     = "DynamicData";
			
			if (grg->GetValue (key_1, value)) {
				printf ("Restore:DynamicData = '%s'\n", value.data.array.data);
			}
		}

		grg->ReleaseKey (key_1);
	}
	
	//	Remove the hive which we loaded dynamically
	
	grg->KillHive (restored_hive);

	printf ("Clean tree:\n");
	dump_tree (root);
	
	printf ("Restore tree:\n");
	
	restore_key = grg->CreateKey (root, "Restore");
//	restore_key = grg->EnterKey (root, "Restore");
	dump_tree (restore_key);
	grg->ReleaseKey (restore_key);
	
	//	Close the whole mess.
	
	grg->Close ();
	getchar ();
}
