
#include "registry.h"

extern "C"
{
extern int	L_open (const char *name, short firstCall ,short *channel);
extern int	L_close(short channel);
};

class AutoInit
{
	short	channel;
	
public:
	AutoInit ()		{ if (L_open ("REG", 0xA7D0, &this->channel)) this->channel = 0; }
	~AutoInit ()	{ if (this->channel) L_close (this->channel); this->channel = 0; }
	
	Bool IsOk ()	{ return this->channel ? TRUE : FALSE; }
};

Reg::Reg ()
{
	asm ("trap #0");
}

Reg::~Reg ()
{
	asm ("trap #0");
}

Reg*
Reg::GetRegistry ()
{
	static AutoInit init;
	Card32 d0 = 0;
	
	if (init.IsOk ()) {
		asm volatile ( ".word 0xA7D0\n"
			           "# output in %0\n"
			         : "=g" (d0) );
	}
	return (Reg*)(d0);
}


