
	.TITLE	RES.ASL

	.PROC	M68000
	.REF	SMAKY
	.REF	DOLIB
	.REF	RES

;RESLIBREVMAJ	= 2
;RESLIBREVMIN	= 12
;RESLIBREVPRO	= " "

OBXLRS		= OBXOVN+4

;	Date	  Rv.	Commentaires
;	-------------------------------------------------------------------------------
;	...		Voir fichier .NEWS
;	06/06/91  2.2	On peut maintenant charger un fichier de ressources qui a t
;			coll  la fin d'un fichier .CODE ou qui nous est donn par un
;			pointeur.
;	01/06/91  2.1	Version avec les appels NEWRES, NEWTYPE et MODIF tests. La
;			partie archivage d'un fichier de ressources est aussi ok.
;	18/05/91  2.0	Rvision rom-able.
;	22/04/91  1.7	Commentaires amliors.
;			Optimisations en place et en vitesse effectues.
;			On peut maintenant charger des ressources contenues dans un
;			binaire avec en-tte courte. Meilleure gestion des erreurs.
;	12/01/91  1.6a	Version de test pour ressources modifiables et sauvables.
;	20/11/90  1.5d	Rend une erreur si on essaie de charger un fichier ne contenant
;			aucune ressource.
;	26/09/90  1.5c	Lors du RES_OPEN, on peut donner un compte mmoire  utiliser
;			 la place du compte MTYPCP habituel.
;	22/09/90  1.5b	Petite correction de la librairie pour le mode BRSGETSUBRES.
;	28/08/90  1.5a	Les ressources au sein d'un type peuvent tre regroupes
;			selon un clef en tables de sous-ressources. L'accs se fait
;			alors par un D2:#BRSGETSUBRES. On utilise une macro-ressource
;			contenant un descriptif des sous-ressources et des tables
;			dfinies.
;	15/04/90  1.4	Ajout les tailles 0,-1 et -2 pour le genre RESDKPROGVAR qui
;			demandent au gestionnaire de calculer la taille lui-mme.

REVMAJ	= RESLIBREVMAJ
REVMIN	= RESLIBREVMIN
REVPRO	= RESLIBREVPRO

OLDSYSTEM = FALSE				; utilise un systme avec NTR > 7.0
debug	= false

PCVAR	= 1
PCCODE	= 0

.if debug
	.REF	MON
.endif debug

	.START	-1
	.CODE	600,11,2'000000,20,2000,20,2000,2
	.IDENT	"(C)  Pierre Arnaud et EPSITEC SA"
	.REV	REVMAJ,REVMIN

	.HEADER	128+64, .8	"0"+REVMAJ,".","0"+REVMIN,REVPRO

      .IF REVPRO.NE.SPACE
	.HEADER	128+80, .8	"P","r","o","v","i","s","o","i","r","e","."
      .ELSE
	.HEADER 128+80, .8	"D","","f","i","n","i","t","i","f","."
      .ENDIF


;	-----------------------------------------
;		(C) 1991 - Pierre Arnaud
;	-----------------------------------------


;	Source du module de librarie RES (gestion des ressources)


		.INS	RESVARS.ASI


;	Mode interne
;	------------

BRSGETCOPYBU	= 31				; interne : copie sur buffer mmoire interne

BRSOPINCODEMEM	= 31				; interne : signale que charg aprs coup


;	Dbut du code
;	-------------

	.LOC	0

BASE:	.16	RES_FIRST
	.16	RES_LAST
	.8	0
	.FILL.8	(OHLREV-APC),0
	.8	REVMAJ,REVMIN
	.32	END_MODULE
	.32	PATHLIB
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"RES"
	.FILL.8	(LGHLIB-APC),0
	.16	_RES_OPEN		; ouvre
	.16	_RES_GETTYPE		; demande le handle + info du type
	.16	_RES_GET		; recherche donnes
	.16	_RES_CLOSE		; ferme
	.16	_RES_DEF		; dfinitions
	.16	_RES_CONTROL		; contrle le fonctionnement de RES
	.16	_RES_NEWRES
	.16	_RES_NEWTYPE
	.16	_RES_GIVE
	.16	_RES_MODIF

	.16	_RES_EXEOPEN
	.16	_RES_EXEDO
	.16	_RES_EXECLOSE

	.16	_RES_DEBUG


NMMCPT:		.ASCIZ	"RES"
NMglMCPT:	.ASCIZ	"RESGLOB"
NMsaveMCPT:	.ASCIZ	"RESSAVE"
NMROM:		.ASCIZ	"%M_ROM(_%L,).RS"
NMSYSTEM:	.ASCIZ	"%M_SYSTEM(_%L,).RS"
		.EVEN


;-------------\\
;  CHECKCANAL  >
;=============/

; Vrifie la validit du canal fourni. Appelle ventuellement une routine
; de patch qui aurait t ajoute. La routine de patch s'arrange pour
; rendre NE si elle veut que la routine patche ne soit pas excute.

; in	A2.32	canal
;	D7.16	numro de l'appel RES_xxx
;	+ ..
; out	+ ..
;	D7.16	ok/erreur si NE
;	EQ	-> excute la routine d'o l'on vient
;	NE	-> n'excute pas la routine d'o l'on vient
; mod	D7.16

CHECKCANAL:
	COMP.A16 #0,A2				; canal initialis ?
	JUMP,EQ	R8^BAD$				; non => erreur
	COMP.32	#cCANCHECK,{A2}+OCANCHECK	; canal valide ?
	JUMP,EQ	R8^OK$				; oui => OK

BAD$:	MOVE.16	#ERrsILCAN,D7			; rend une erreur si le canal est inconnu
	RET

OK$:	SUB.16	#RES_FIRST,D7			; numro de l'appel (0..n)
	SL.16	#2,D7				; x 2 => offset dans table des sauts
	TEST.32	{A2}+A16^{D7}+OCANPATCH		; routine de patch connue ?
	JUMP,NE	R8^PATCH$			; oui => effectue le PATCH
	RET					; non => rend EQ

PATCH$:	PUSH.32	{A2}+A16^{D7}+OCANPATCH
	RET					; saute  l'adresse de la routine de patch


	.INS	RESCALLS.ASI
	.INS	RESWORK.ASI
	.INS	RESMODIF.ASI
	.INS	RESnewSAVE.ASI
	.INS	RESEXEC.ASI

END_MODULE:


	.END
