
	.TITLE	RMT.ASL

	.PROC	M68000
	.REF	SMAKY
	.REF	DOLIB
	.REF	RMT
	.REF	M8SYS

DEB2	= FALSE				; debug pour exclusion
DEBUG	= FALSE
FOSOK	= TRUE				; tant que FOS?AUXIL1 ne marche pas par $Z, mettre FALSE

REVMAJ	= 0
REVMIN	= 4

	.CODE	600,11,2'000000,20,2000,20,2000,2
	.IDENT	"(C) 1991  Pierre ARNAUD et EPSITEC-system SA. Libraire d'excution distante"
	.REV	REVMAJ,REVMIN


;	-----------------------------------------
;		(C) 1989 - Pierre Arnaud
;	-----------------------------------------


;	Source de la librairie d'accs  distance.

;	Cette librairie offre  l'utilisateur la possibilit
;	d'excuter  distance n'importe quel appel (appel
;	du type LINE A ou TRAP #n).

;	Il est possible de dfinir soi-mme des appels qui
;	ne seraient pas (encore) grs grce  RMT_DEFINE.

;	Pour que les oprations puissent tre excute  distance,
;	il faut que le rcepteur ait excut au pralable un
;	RMT_RECEIVE (installation du driver $RMT_0)


;	Variables globales au module de librairie
;	-----------------------------------------

		.LOC	0

OVHANDLE:	.BLK.8	4		; ^zone de dfinition des appels

OVARGS:		.BLK.8	LGARGS

OVSEMACR1:	.BLK.8	4		; ^smaphore pour zone critique (mod. {OVPDEF}..)
OVCOUNT:	.BLK.8	2		; compteur d'utilisation
OVOK:		.BLK.8	1		; <> 0, signal indiquant que dj initialis
OVUSE:		.BLK.8	1		; <> 0 (presque) initialis
LGV:


;	Variables pour un canal
;	-----------------------

		.LOC	0

OCBUFFER:	.BLK.8	200		; buffer pour envoi & rception rseau
OCBUNET:	.BLK.8	128		; nom d'accs rseau
OCHANDLE1:	.BLK.8	4
OCHANDLE2:	.BLK.8	4
OCHANDLET1:	.BLK.8	4
OCHANDLET2:	.BLK.8	4
OCCANAL:	.BLK.8	2		; canal FOS
OCREMOTE:	.BLK.8	1		; flag, si <> 0, alors canal distant
		.ALIGN	4
OCRMD:		.BLK.8	LRMD		; copie de l'actuel appel  grer
		.ALIGN	4
LGC:


;	----------------------------------
;		MODULE SMA_RMT.LIB
;	----------------------------------


	.LOC	0

BEGIN:	.16	RMT_FIRST
	.16	RMT_LAST
	.8	0
	.FILL.8	(OHLREV-APC),0
	.8	REVMAJ,REVMIN
	.32	END_RMT
	.32	PATHLIB
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"RMT"
	.FILL.8	(LGHLIB-APC),0

	.16	_RMT_OPEN
	.16	_RMT_CLOSE
	.16	_RMT_RECEIVE
	.16	_RMT_DEFINE
	.16	_RMT_EXECUTE

NMDEFS:	.ASCIZ	"(:,#:)SMA_RMT.INFO"
NMUNIT:	.ASCIZ	"$RMT_0:"
	.EVEN



;------------\\
;  _RMT_OPEN  >
;============/

; Ouvre un canal pour les accs  distance.

; in	A3.32	^chane rseau
; out	D7.16	erreur : ERNHNQ si pas prsent
;			 ERUNNI si rcepteur pas initialis
;		ou autre (mmoire pleine, SMA_RMT.INFO absent..)
;	A0.32	canal  utiliser si D7.16 = 0
; mod	D7.16, A0.32

_RMT_OPEN:
	PUSHM.32 A3|A6

	CALL	INIT_RMT		; init mmoire globale & sma & defs.
	JUMP,NE	R8^ERR$			; erreur => abandonne

	INC.16	{A6}+OVCOUNT		; un processus de plus utilise ce module
	CALL	OPENCANAL		; ouvre le canal d'accs
	JUMP,EQ	ERR$			; pas d'erreur => ok

	PUSH.16	D7
	CALL	KILL_ONE		; sinon, tue une <entre>
	POP.16	D7

ERR$:	POPM.32	A3|A6
	TEST.16	D7			; test pour EQ/NE
	RET



;-------------\\
;  _RMT_CLOSE  >
;=============/

; Ferme un canal d'accs

; in	A0.32	canal
; out	D7.16	ok/erreur
; mod	D7.16

_RMT_CLOSE:
	PUSHM.32 A5|A6

	CALL	VARMEM			; demande le ^mmoire => A6
	MOVE.16	{A0}+OCCANAL,D6
	FOS	?CLOSE
	CALL	KILL_ONE		; supprime une <entre>

ERR$:	POPM.32	A5|A6
	TEST.16	D7			; test pour EQ/NE
	RET



;---------------\\
;  _RMT_RECEIVE  >
;===============/

; Initialise l'appareil  la rception de commandes.

; in	D3.32	attributs (0)
;	A3.32	inutilis (pour le futur)
; out	D7.16	erreur
; mod	D7.16

_RMT_RECEIVE:
	PUSHM.32 D3|A2|A3|A4

	CLR.16	D3
	MOVE.32	A3,A2			; on passe le registre A3 comme param.
	MOVE.32	#0,A3			; pas de nom logique
	MOVE.32	#R16^NMUNIT,A4		; nom de l'unit
	FOS	?INSTALL
	JUMP,EQ	R8^ERR$			; ok, installation effectue

	COMP.16	#ERNDEV,D7		; pilote dj install ?
	JUMP,NE	R8^ERR$			; non => rend l'erreur

	CLR.16	D7			; sinon, ok

ERR$:	POPM.32	D3|A2|A3|A4
	TEST.16	D7			; test pour EQ/NE
	RET



;--------------\\
;  _RMT_DEFINE  >
;==============/

; Ajoute une dfinition d'appel.

; in	A3.32	^table de description de l'appel
;	D3.32	attributs
; out	D7.16	erreur (existe dj)
; mod	D7.16

_RMT_DEFINE:
	PUSHM.32 D2|D3|D4|D6|A3|A4|A6

	CALL	VARMEM			; A6: variables globales

	MOVE.16	{A3}+ORMDTRAP+0,D2	; appel TRAP#...
	JUMP,EQ	R8^LINEA$
	MOVE.16	{A3}+ORMDTRAP+2,D3
	CALL	TEST_DEF
	JUMP,NE	R8^DO$			; existe pas, ajoute la df.

AEX$:	MOVE.16	#1,D7
	JUMP	R8^ERR$			; existe dj !

LINEA$:	MOVE.16	{A3}+ORMDLINEA+0,D2	; appel par LINEA...
	MOVE.16	{A3}+ORMDLINEA+2,D3
	CALL	TEST_DEF
	JUMP,EQ	R8^AEX$			; existe dj, rend une erreur

DO$:	MOVE.32	A3,A4
	MOVE.32	#R16^NMDEFS,A3
	MOVE.32	#2**BOPAPPEND+2**BOPWR+2**BOPEXCL+2**BOPCREATE,D3
	FOS	?ARGSOPEN		; ouvre (:,#:)SMA_RMT.INFO  l'criture
	JUMP,NE	R8^ERR$

	MOVE.32	#LRMD,D4
	FOS	?WRBYTE			; ajoute les defs.

	PUSH.16	D7
	FOS	?CLOSE
	POP.16	D7
	JUMP,NE	R8^ERR$

	CALL	LOADDEF			; recharge les dfinitions

ERR$:	POPM.32	D2|D3|D4|D6|A3|A4|A6
	TEST.16	D7			; test pour EQ/NE
	RET



;---------------\\
;  _RMT_EXECUTE  >
;===============/

; Excute l'appel qui suit sur la station initialise. Exemple:

; RMT_	EXECUTE
; LIB	?BEEP

; in	A0.32	canal
;	+ suivant appel
; out	suivant appel
; mod	suivant appel

_RMT_EXECUTE:
	PUSHM.32 D0..D7|A0..A6

	TEST.8	{A0}+OCREMOTE		; action locale ?
	JUMP,NE	R8^REMOTE$		; non => distant

	POPM.32 D0..D7|A0..A6		; restitue l'tat de la pile
	RET				; effectue un RET, suivi du TRAP  grer

REMOTE$:
	MOVE.32	#{SP}+15*4,A1		; cherche l'adresse juste avant le PUSHM
	CALL	EXE_REMOTE		; excute l'action  distance, puis termine

ERR$:	POPM.32	D0..D7|A0..A6
	TEST.16	D7			; test pour EQ/NE
	RET



;---------\\
;  VARMEM  >
;=========/

; Cherche la zone de variables alloue au module

; in	-
; out	A6.32	^zone
; mod	D7.16, A6.32

VARMEM:
	PUSHM.32 D4|A4

	MOVE.32	#LGV,D4			; variables globales
	MOVE.32	#R16^BEGIN,A4		; dbut du module LIB
	FOS	?GETCOMMEM		; demande la mmoire commune
	MOVE.32	A4,A6			; ^zone commune

	POPM.32	D4|A4
	RET



;-----------\\
;  INIT_RMT  >
;===========/

; Initialise la librairie

; in	-
; out	A6.32	variables si D7=0
;	D7.16	erreur (fatale)
; mod	D7.16, A6.32

INIT_RMT:
	PUSHM.32 D1|D4|A4|A5

	MOVE.32	#LGV,D4			; variables globales
	MOVE.32	#R16^BEGIN,A4		; dbut du module LIB
	FOS	?GETCOMMEM		; demande la mmoire commune
	JUMP,NE	R8^ERR$

	MOVE.32	A4,A6			; ^variables
	TAS.8	{A6}+OVUSE		; dj utilis ?
	JUMP,NE	R8^WAITOK$		; oui => attend que disponible
					; non => indique que vient d'tre utilis
	MOVE.16	#1,D4
	NTREL	?CRESEM			; cre un smaphore d'exclusion
	JUMP,NE	R8^ERR$			; erreur => abandonne

	MOVE.16	#MTYPcp,D1		; sur le compte du processus !!!! MMU ????
	MOVE.32	#1,D4			; taille mmoire minimum pour HANDLE
	GESMEM	?GETHANDLE		; cre le handle
	JUMP,NE	R8^ERR$			; erreur => abandonne

	MOVE.32	A4,{A6}+OVHANDLE	; sauve pour plus tard

	MOVE.32	A5,{A6}+OVSEMACR1	; exclusion d'accs aux defs
	CALL	LOADDEF			; charge les dfinitions
	JUMP,NE	R8^ERR$			; erreur => abandonne
	SET.8	{A6}+OVOK		; signale qu'initialisation globale ok
	JUMP	R8^ERR$			; et termine

WAITOK$:
	TEST.8	{A6}+OVOK		; teste si ok ?
	JUMP,NE	R8^ERR$			; oui => termine, c'est dj initialis
	MOVE.16	#5,D4			; attend 1/10 de seconde
	NTREL	?DELMS			; avant de recommencer le test
	.if deb2
	lib	?aftim
	.ascize	"w"
	.endif deb2
	JUMP	R8^WAITOK$

ERR$:	POPM.32	D1|D4|A4|A5
	TEST.16	D7
	RET




;----------\\
;  LOADDEF  >
;==========/

; (Re)charge les dfinitions gnrales

; in	A6.32	^variables globales
; out	D7.16	ok/erreur
; mod	D7.16

LOADDEF:
	PUSHM.32 D1|D3|D4|D6|A3|A4|A5

	MOVE.32	{A6}+OVSEMACR1,A5
	NTREL	?LOCK			; zone d'exclusion mutuelle, un seul proc.
	JUMP,NE	R8^ERR$			; accde aux dfs. des appels

	MOVE.16	#2**BOPRD+2**BOPARGS,D3
	MOVE.32	#R16^NMDEFS,A3
	MOVE.32	#{A6}+OVARGS,A4
	FOS	?ARGSOPEN		; ouvre le fichier (:,#:)SMA_RMT.INFO
	JUMP,EQ	R8^OK01$
	COMP.16	#ERFDNE,D7		; fichier n'existe pas ?
	JUMP,NE	R8^ER1$			; non => rend erreur
	CLR.16	D7
	JUMP,EQ	R8^ER1$			; oui => pas d'erreur

OK01$:	MOVE.32	{A4}+OBALGF,D4		; taille du fichier en octets
	MOVE.32	{A6}+OVHANDLE,A4	; ^au handle pour les dfs.
	GESMEM	?RESIZEHANDLE		; change la taille du HANDLE
	JUMP,NE	R8^ER2$			; erreur => termine

	GESMEM	?LOCKHANDLE		; verrouille le HANDLE
	EX.32	A3,A4			; A4: ^zone mmoire,  A3: ^handle
	FOS	?RDBYTE			; lit le fichier

	PUSH.16	D7
	MOVE.32	A3,A4			; A4: ^handle
	GESMEM	?UNLOCKHANDLE		; re-libre le HANDLE pour l'utilisateur
	POP.16	D7

ER2$:	PUSH.16	D7
	FOS	?CLOSE			; ferme le canal du fichier d'infos.
	POP.16	D7

ER1$:	PUSH.16	D7
	NTREL	?UNLOCK			; d-verrouille la zone
	POP.16	D7

ERR$:	POPM.32	D1|D3|D4|D6|A3|A4|A5
	TEST.16	D7
	RET



;-----------\\
;  KILL_ONE  >
;===========/

; Dtruit une entre (on s'en fiche du canal)

; in	A6.32	^variables
; out	D7.16	ok/erreur
; mod	D7.16

KILL_ONE:
	PUSHM.32 A5

	TEST.16	{A6}+OVCOUNT
	JUMP,EQ	R8^ERR$			; termin, plus utilis du tout

;;?	COMP.16	#1,{A6}+OVCOUNT		; nombre d'utilisations (faut agir vite)
;;?	JUMP,EQ	R8^OFF$			; dernire, libre la zone

	DEC.16	{A6}+OVCOUNT		; pas la dernire utilisation !
	JUMP,NE	R8^ERR$			; non => termine, une utilisation de moins

OFF$:	CLR.32	{A6}+OVCOUNT		; efface tout les fanions (used et init)	

	MOVE.32	{A6}+OVSEMACR1,A5	; smaphore  dtruire

;;?	DEC.16	{A6}+OVCOUNT		; un de moins (0 si pas chang)
;;?	JUMP,NE	R8^ERR$			; encore utilis => termine

	NTREL	?KILLSEM		; tue le smaphore (si possible)
;	JUMP,NE	R8^ERR$			; erreur, encore utilis => abandonne

ERR$:	POPM.32	A5
	TEST.16	D7
	RET



;------------\\
;  OPENCANAL  >
;============/

; Ouvre un canal distant sur l'appareil demand.

; in	A3.32	^chane rseau
; out	D7.16	erreur (station inexistante, unit non initialise)
;	A0.32	si D7=0
; mod	D7.16, A0.32

OPENCANAL:
	PUSHM.32 D1|D3|D4|D6|A3|A4

	MOVE.16	#MTYPcp,D1
	MOVE.32	#LGC,D4	
	GESMEM	?GETMEM			; demande la mmoire pour le canal
	JUMP,NE	R16^ERR$		; pas assez de mmoire..

	GESMEM	?CLEARMEM
	MOVE.32	A4,A0			; utilisera comme indicateur de canal

	MOVE.32	#{A0}+OCBUNET,A4	; buffer pour la chane rseau
	COMP.32	#0,A3
	JUMP,EQ	R16^LOCAL$		; pas de nom rseau, excution locale

COPY$:	MOVE.8	{A3+},D3
	JUMP,EQ	R8^OK$			; termin
	COMP.8	#CR,D3
	JUMP,EQ	R8^OK$
	COMP.8	#SPACE,D3
	JUMP,EQ	R8^OK$
	COMP.8	#TAB,D3
	JUMP,EQ	R8^OK$
	MOVE.8	D3,{A4+}
	JUMP	R8^COPY$		; copie la suite de la chane

OK$:	COMP.32	A4,A0			; les mmes positions ?
	JUMP,EQ	R8^LOCAL$		; oui, pas de gestion  distance

	COMP.8	#":",{A4}-1		; cherche si le ":" terminateur est donn
	JUMP,EQ	R8^ADD$			; oui => ajoute la suite du nom
	MOVE.8	#":",{A4+}

ADD$:	MOVE.32	#R16^NMUNIT,A3

COPY1$:	MOVE.8	{A3+},{A4+}		; ajoute "$RMT_0:" au nom rseau
	JUMP,NE	R8^COPY1$

	MOVE.32	#R16^NMUNIT,A3		; #### provisiore #### pour test uniquement
	.IF	FOSOK
	MOVE.32	#{A0}+OCBUNET,A3	; ^nom rseau
	FOS	?WHAT
	JUMP,NE	R8^GIVMEM$		; erreur => rend la mmoire
	TEST.32	D3:#BWHUNIT
	JUMP,BC	R8^SYNT$		; erreur de syntaxe, pas une unit
	TEST.32	D3:#BWHNETW
	JUMP,BC	R8^SYNT$		; erreur de syntaxe, pas une chane rseau
	.ENDIF

	MOVE.16	#2**BOPOPEN,D3		; ouvre le canal, mais sans RD ou WR
	FOS	?ARGSOPEN
	JUMP,NE	R8^GIVMEM$		; erreur, rend la mmoire demande

	.IF	DEBUG
	LIB	?AFTIM
	.ASCIZE	">> FileName="
	LIB	?AFTEXT
	LIB	?AFTIM
	.ASCIZE	" CanalFos=H'"
	MOVE.16	D6,D4
	LIB	?AFX4, ?AFCR
	.ENDIF

	MOVE.16	D6,{A0}+OCCANAL		; mmorise le canal distant
	SET.8	{A0}+OCREMOTE		; canal distant (on mule)
	JUMP	R8^ERR$			; et termine

LOCAL$:	CLR.8	{A0}+OCREMOTE		; indique que local
	CLR.16	D7
	JUMP	R8^ERR$			; et termine

SYNT$:	MOVE.16	#ERSYNT,D7		; rend une erreur de syntaxe

GIVMEM$:
	PUSH.16	D7
	MOVE.32	A0,A4
	GESMEM	?GIVMEM			; rend la mmoire
	POP.16	D7

ERR$:	POPM.32	D1|D3|D4|D6|A3|A4
	TEST.16	D7
	RET



;-----------\\
;  TEST_DEF  >
;===========/

; Recherche si l'appel est connu par le systme

; in	D2.16	premire partie de l'appel
;	D3.16	seconde partie de l'appel
;	A6.32	^variables communes
; out	D7.16	0: appel existe
; mod	D7.16

TEST_DEF:
	PUSHM.32 D4|A3|A4|A5

	MOVE.32	{A6}+OVSEMACR1,A5
	NTREL	?LOCK			; zone d'exclusion mutuelle, un seul proc.
	JUMP,NE	R8^ERR$			; erreur => abandonne

	MOVE.32	{A6}+OVHANDLE,A4	; ^au handle pour les dfs.
	GESMEM	?LOCKHANDLE		; verrouille le HANDLE
	JUMP,NE	R8^ERR$			; erreur, pas de handle
	GESMEM	?GETSIZEHANDLE		; cherche la taille du HANDLE
	COMP.32	#1,D4			; taille incorrecte (pas de df.)
	JUMP,EQ	R16^NODEF$		; erreur, pas de df. trouve

	MOVE.32	A3,A4			; A4: ^zone mmoire

SEEK$:	COMP.16	{A4}+ORMDTRAP,D2	; mme TRAP ?
	JUMP,EQ	R16^EQTRAP$		; oui, premier pas ok
	COMP.16	{A4}+ORMDLINEA,D2	; mme LINEA ?
	JUMP,EQ	R16^EQLINEA$		; oui, premier pas ok

NEXT$:	ADD.32	#LRMD,A4
	SUB.32	#LRMD,D4
	JUMP,GT	R8^SEEK$		; cherche la suite dans les dfs.

NODEF$:	MOVE.16	#1,D7			; pas de dfinition trouve
	JUMP	R8^ERR$

RET$:	CLR.16	D7			; pas d'erreur

ERR$:	PUSH.16	D7
	MOVE.32	{A6}+OVHANDLE,A4	; ^au handle pour les dfs.
	GESMEM	?UNLOCKHANDLE		; d-verrouille le HANDLE
	NTREL	?UNLOCK			; exclusion termine
	POP.16	D7
	POPM.32	D4|A3|A4|A5
	RET				; retour


EQTRAP$:				; => mme numro de TRAP
	COMP.16	{A4}+ORMDTRAP+2,D3	; mme sous-numro ?
	JUMP,NE	R8^NEXT$		; non => reprend la suite
	JUMP	R8^RET$			; termine, ok

EQLINEA$:
	TEST.8	{A4}+ORMDFLAG+1:#BRMFLINEX
	JUMP,BC	R8^RET$			; pas sur .32, ok, trouv !

	COMP.16	{A4}+ORMDLINEA+2,D3	; mme extension ?
	JUMP,NE	R16^NEXT$		; non => suivant

	JUMP	R8^RET$			; lance l'mulation



;-------------\\
;  EXE_REMOTE  >
;=============/

; Excute l'action  distance. Si l'action ne trouve pas de dfinition,
; alors on l'excute localement...

; in	A0.32	canal
;	A1.32	^pile avant le PUSHM.32 ...
; out	D7.16	ok/erreur
; mod	...

EXE_REMOTE:
	MOVE.32	{A1},A2			; PC juste aprs le RMT_EXECUTE
	MOVE.16	{A2+},D2		; premire partie (soit TRAP, soit LINEA)
	MOVE.16	{A2},D3			; extension pour TRAP ou LINEA tendue

	CALL	VARMEM			; demande les variables globales

	MOVE.32	{A6}+OVSEMACR1,A5
	NTREL	?LOCK			; zone d'exclusion mutuelle, un seul proc.
	JUMP,NE	R8^ERR$			; erreur => abandonne

	MOVE.32	{A6}+OVHANDLE,A4	; ^au handle pour les dfs.
	GESMEM	?LOCKHANDLE		; verrouille le HANDLE
	JUMP,NE	R8^ERR$			; erreur, pas de handle
	GESMEM	?GETSIZEHANDLE		; cherche la taille du HANDLE
	COMP.32	#1,D4			; taille incorrecte (pas de df.)
	JUMP,EQ	R16^NODEF$		; erreur, pas de df. trouve

	MOVE.32	A3,A4			; A4: ^zone mmoire

SEEK$:	COMP.16	{A4}+ORMDTRAP,D2	; mme TRAP ?
	JUMP,EQ	R16^EQTRAP$		; oui, premier pas ok
	COMP.16	{A4}+ORMDLINEA,D2	; mme LINEA ?
	JUMP,EQ	R16^EQLINEA$		; oui, premier pas ok

NEXT$:	ADD.32	#LRMD,A4
	SUB.32	#LRMD,D4
	JUMP,GT	R8^SEEK$		; cherche la suite dans les dfs.

NODEF$:
	.16	?AFTIM
	.ASCIZE	"RMT: appel non dfini dans D2/D3<CR><CR>"
	TRAP	#1
	JUMP	R8^RET$

ERR$:	.16	?AFTIM
	.ASCIZE	"RMT: erreur dans D7.16 lors de EXECUTE<CR><CR>"
	TRAP	#1

RET$:	MOVE.32	{A6}+OVHANDLE,A4	; ^au handle pour les dfs.
	GESMEM	?UNLOCKHANDLE		; d-verrouille le HANDLE
	NTREL	?UNLOCK			; exclusion termine
	RET				; retour

FAT$:	.16	?AFTIM
	.ASCIZE	"RMT: erreur fatale "
	MOVE.16	D7,D4
	.16	?AFX4
	.16	?AFCR, ?AFCR
	TRAP	#1
	JUMP	R8^RET$

EQTRAP$:				; => mme numro de TRAP
	COMP.16	{A4}+ORMDTRAP+2,D3	; mme sous-numro ?
	JUMP,NE	R16^NEXT$		; non => reprend la suite

	MOVE.32	{A4}+ORMDTRAP,D4	; dans D4.32 : appel  muler au bout de la ligne
	ADD.32	#2,A2			; aprs l'appel .32
	JUMP	R8^EMULE$		; lance l'mulation

EQLINEA$:
	TEST.8	{A4}+ORMDFLAG+1:#BRMFLINEX
	JUMP,BC	R8^SHORT$		; pas sur .32, ok, trouv !

	COMP.16	{A4}+ORMDLINEA+2,D3	; mme extendion ?
	JUMP,NE	R16^NEXT$		; non => suivant

	MOVE.32	{A4}+ORMDLINEA,D4	; un appel LINEA sur .32  muler
	ADD.32	#2,A2			; aprs l'appel .32
	JUMP	R8^EMULE$		; lance l'mulation

SHORT$:	CLR.32	D4
	MOVE.16	D2,D4			; utilise uniquement le .16 du LINEA (normal)

EMULE$:
	.IF	DEBUG
	LIB	?AFTIM
	.ASCIZE	">> Emulator Of "
	LIB	?AFX8
	LIB	?AFTAB
	MOVE.32	#{A4}+ORMDNAME,A3
	LIB	?AFTEXT, ?AFCR
	.ENDIF


	MOVE.32	#{A0}+OCRMD,A3		; ^zone mmoire interne pour la copie
	MOVE.16	#LRMD/4-1,D3		; nombre-1 de .32  copier

COPY$:	MOVE.32	{A4+},{A3+}
	DJ.16,NMO D3,COPY$		; copie super-rapide

	MOVE.32	{A6}+OVHANDLE,A4	; ^au handle pour les dfs.
	GESMEM	?UNLOCKHANDLE		; d-verrouille le HANDLE
	JUMP,NE	R16^FAT$		; erreur fatale
	MOVE.32	{A6}+OVSEMACR1,A5
	NTREL	?UNLOCK			; on peut  nouveau accder  la zone mmoire
	JUMP,NE	R16^FAT$

	MOVE.32	#{A0}+OCBUFFER,A3

;	Rcapitulation :
;	----------------

;	A0.32	canal
;	A1.32	^juste avant le PUSHM des registres
;	A2.32	^juste aprs l'appel
;	A3.32	^dans le buffer pour le paquet
;	D4.32	appel complet
;	A6.32	^variables gnrales

REMOTE_SEND:					; => envoi du paquet de DATA

	MOVE.32	A2,{A1}				; nouvelle adresse de retour
	MOVE.32	D4,{A3}+ORMpCALL		; mmorise l'appel
	CLR.8	{A3}+ORMpATYPe			; vide input flags pour An

	MOVE.32	{A1}-4*15,{A3}+ORMpDATA+0*4	; registre D0
	MOVE.32	{A1}-4*14,{A3}+ORMpDATA+1*4	; registre D1
	MOVE.32	{A1}-4*13,{A3}+ORMpDATA+2*4	; registre D2
	MOVE.32	{A1}-4*12,{A3}+ORMpDATA+3*4	; registre D3
	MOVE.32	{A1}-4*11,{A3}+ORMpDATA+4*4	; registre D4
	MOVE.32	{A1}-4*10,{A3}+ORMpDATA+5*4	; registre D5
	MOVE.32	{A1}-4*9 ,{A3}+ORMpDATA+6*4	; registre D6
	MOVE.32	{A1}-4*8 ,{A3}+ORMpDATA+7*4	; registre D7

	MOVE.32	{A1}-4*7 ,{A3}+ORMpADR+0*4	; registre A0
	MOVE.32	{A1}-4*6 ,{A3}+ORMpADR+1*4	; registre A1
	MOVE.32	{A1}-4*5 ,{A3}+ORMpADR+2*4	; registre A2
	MOVE.32	{A1}-4*4 ,{A3}+ORMpADR+3*4	; registre A3
	MOVE.32	{A1}-4*3 ,{A3}+ORMpADR+4*4	; registre A4
	MOVE.32	{A1}-4*2 ,{A3}+ORMpADR+5*4	; registre A5
	MOVE.32	{A1}-4*1 ,{A3}+ORMpADR+6*4	; registre A6

	MOVE.32	{A1}-4*7 ,{A3}+ORMpADRold+0*4	; registre A0
	MOVE.32	{A1}-4*6 ,{A3}+ORMpADRold+1*4	; registre A1
	MOVE.32	{A1}-4*5 ,{A3}+ORMpADRold+2*4	; registre A2
	MOVE.32	{A1}-4*4 ,{A3}+ORMpADRold+3*4	; registre A3
	MOVE.32	{A1}-4*3 ,{A3}+ORMpADRold+4*4	; registre A4
	MOVE.32	{A1}-4*2 ,{A3}+ORMpADRold+5*4	; registre A5
	MOVE.32	{A1}-4*1 ,{A3}+ORMpADRold+6*4	; registre A6

;	Si le contenu d'un registre d'adresse est une valeur
;	absolue (pas une adresse relative), on ne change rien;
;	sinon, on copie un bout de la zone mmoire dans le tampon
;	d'mission et on transforme An en un offset.

	MOVE.16	#MTYPcp,D1
	MOVE.32	#LRMp,D4
	GESMEM	?GETHANDLE			; prend un HANDLE de taille minimum

	MOVE.16	#0,D2				; numro du reg. d'adresse
	MOVE.32	#{A3}+ORMpADR,A2		; ^valeurs dans les DATA
	MOVE.32	#{A0}+OCRMD+ORMDREGMAP,A5	; ^dans le MAP des reg. d'adresse

WRKin$:	MOVE.8	{A5}+ORMMTYP,D0			; fanions
	JUMP,EQ	R8^NXTin$			; aucun => registre suivant
	TEST.32	D0:#BRMMNB
	JUMP,BS	R8^NXTin$			; nombre => registre suivant
	TEST.32	D0:#BRMMFIX
	JUMP,BS	R8^FIXin$			; dcalage fixe in

.if debug
	lib	?aftim
	.ascize	"registre BRMMDxx = "
	push.32	d4
	move.16	d0,d4
	lib	?afx8, ?afcr
	pop.32	d4
.endif

	MOVE.8	D0,D1
	SR.8	#3,D1				; cherche le dcalage
	AND.16	#2'0011100,D1
	MOVE.32	{A3}+A16^{D1}+ORMpDATA,D1	; taille de la zone
	TEST.32	D0:#BRMMD8			; sur 8 bits ?
	JUMP,BC	R8^D16in$			; non => suite
	AND.32	#16'000000FF,D1
	JUMP	R8^ADDin$			; ajoute cette zone

D16in$:	TEST.32	D0:#BRMMD16
	JUMP,BC	R8^ADDin$			; sur .32, pas de masquage
	AND.32	#16'0000FFFF,D1
	JUMP	R8^ADDin$

FIXin$:	MOVE.32	{A5}+ORMMFIX,D1			; valeur sur 32 bits fixe

ADDin$:	TEST.32	D1
	JUMP,EQ	R8^NXTin$			; pas de valeur  ajouter
	CALL	ADDMEM				; ajoute la zone mmoire
	JUMP,NE	R16^MEM1$			; erreur (mmoire pleine)

NXTin$:	ADD.32	#4,A2
	ADD.32	#LRMM,A5
	ADD.16	#1,D2				; registre d'adresse suivant
	COMP.16	#7,D2
	JUMP,LT	WRKin$

	MOVE.32	A4,{A0}+OCHANDLE1		; mmorise le 1er HANDLE
	MOVE.32	D4,{A0}+OCHANDLET1		; taille

;	La rception comme l'mission se font dans la mme zone de mmoire;
;	elle est transmise de RMT => dest, modifie et dest => RMT pour
;	tre remise en mmoire...

	MOVE.32	A3,A2				; ^paquet
	GESMEM	?LOCKHANDLE			; cherche ^mmoire pour mission
	MOVE.32	A3,A5				; ^mission
	MOVE.32	D4,D5				; taille pour l'mission
	MOVE.32	A3,A4				; ^rception
	MOVE.32	A2,A3				; ^paquet  envoyer
	MOVE.16	{A0}+OCCANAL,D6

	CALL	COPYinout

	.IF	DEBUG
	PUSHM.32 D4
	LIB	?AFTIM
	.ASCIZE	">> D4="
	LIB	?AFX8
	LIB	?AFTIM
	.ASCIZE	"  A4="
	MOVE.32	A4,D4
	LIB	?AFX8
	LIB	?AFTIM
	.ASCIZE	"<CR>>> A3="
	MOVE.32	A3,D4
	LIB	?AFX8
	LIB	?AFTIM
	.ASCIZE	"<CR>>> A5="
	MOVE.32	A5,D4
	LIB	?AFX8
	LIB	?AFTIM
	.ASCIZE	"  D5="
	MOVE.32	D5,D4
	LIB	?AFX8
	LIB	?AFTIM
	.ASCIZE	"  MAP=2'"
	MOVE.8	{A3}+ORMpATYPe,D4
	LIB	?AFB8, ?AFCR
	POPM.32	D4
	.ENDIF

	MOVE.16	#TYPIO,D3

	FOS	?AUXIL1				; envoi de la commande
	JUMP,NE	R16^MEM2$			; erreur +/- fatale

	.IF	DEBUG

	PUSHM.32 D4|A0
	LIB	?AFTIM
	.ASCIZE	">> D4="
	LIB	?AFX8
	LIB	?AFTIM
	.ASCIZE	"  A4="
	MOVE.32	A4,D4
	LIB	?AFX8
	LIB	?AFTIM
	.ASCIZE	"<CR>>> A3="
	MOVE.32	A3,D4
	LIB	?AFX8
	LIB	?AFTIM
	.ASCIZE	"<CR>>> A5="
	MOVE.32	A5,D4
	LIB	?AFX8
	LIB	?AFTIM
	.ASCIZE	"  D5="
	MOVE.32	D5,D4
	LIB	?AFX8
	LIB	?AFTIM
	.ASCIZE	"  MAP=2'"
	MOVE.8	{A3}+ORMpATYPe,D4
	LIB	?AFB8, ?AFCR

	POPM.32	D4|A0


	.ENDIF


;	On a maintenant en retour le paquet des informations modifi.
;	Il faut recopier le contenu des zones {An++} dans l'emplacement
;	de dpart..


	PUSHM.32 D3|D4|D5|A3|A5|A6
	MOVE.32	#{A3}+ORMPADIM,A6
	MOVE.8	{A3}+ORMpATYPe,D4		; map pour la rcupration
	MOVE.32	#{A3}+ORMpADRold,A5		; ^anciennes valeurs An
	MOVE.32	#{A4}+ORMpADR,A3		; ^valeur du registre An
	MOVE.32	A4,D5				; dcalage
	MOVE.16	#6-1,D3				; passe en revue A0..A6

DO$:	RR.8	#1,D4				; test pour le registre An

	.IF	DEBUG
	LIB	?AFB8, ?AFSPACE
	PUSHM.32 D4
	MOVE.8	D3,D4
	LIB	?AFX2, ?AFCR
	POPM.32	D4
	.ENDIF

	TEST.32	D4:#7
	JUMP,BC	R8^NEXT$			; sans offset, suite !

	ADD.32	D5,{A3}				; ajoute le dcalage
	CALL	RECUPVAL

NEXT$:	ADD.32	#4,A3
	ADD.32	#4,A5
	ADD.32	#4,A6
	DJ.16,NMO D3,DO$

	POPM.32	D3|D4|D5|A3|A5|A6


	MOVE.32	{A4}+ORMpDATA+0*4,{A1}-4*15	; met  jour les registres pour le retour
	MOVE.32	{A4}+ORMpDATA+1*4,{A1}-4*14
	MOVE.32	{A4}+ORMpDATA+2*4,{A1}-4*13
	MOVE.32	{A4}+ORMpDATA+3*4,{A1}-4*12
	MOVE.32	{A4}+ORMpDATA+4*4,{A1}-4*11
	MOVE.32	{A4}+ORMpDATA+5*4,{A1}-4*10
	MOVE.32	{A4}+ORMpDATA+6*4,{A1}-4*9
	MOVE.32	{A4}+ORMpDATA+7*4,{A1}-4*8

	MOVE.32	{A4}+ORMpADR+0*4,{A1}-4*7
	MOVE.32	{A4}+ORMpADR+1*4,{A1}-4*6
	MOVE.32	{A4}+ORMpADR+2*4,{A1}-4*5
	MOVE.32	{A4}+ORMpADR+3*4,{A1}-4*4
	MOVE.32	{A4}+ORMpADR+4*4,{A1}-4*3
	MOVE.32	{A4}+ORMpADR+4*5,{A1}-4*2
	MOVE.32	{A4}+ORMpADR+6*4,{A1}-4*1





MEM2$:	PUSH.16	D7
	MOVE.32	{A0}+OCHANDLE1,A4
	GESMEM	?UNLOCKHANDLE
	POP.16	D7

MEM1$:	PUSH.16	D7
	MOVE.16	#MTYPcp,D1
	GESMEM	?GIVHANDLE		; rend le HANDLE
	POP.16	D7

AVORT1$:
	TEST.16	D7
	JUMP,EQ	R8^RT$
	MOVE.32	D7,{A1}-4*8		; pas de REMOTE, rend l'erreur !

RT$:	RET




;-----------\\
;   ADDMEM   >
;===========/

; Ajoute la mmoire et rend relatif

; in	A2.32	^valeur de An
;	A3.32	^paquet  envoyer
;	A4.32	^handle
;	A5.32	^map de An
;	D1.32	mmoire  ajouter
;	D2.16	numro du registre
;	D4.32	ancienne quantit mmoire
; out	D4.32	nouvelle quantit mmoire
;	D7.16	ok/erreur
; mod	D4.32, D7.16


ADDMEM:
	PUSHM.32 D0|D1|D2|A1..A5

	MOVE.32	D4,D0				; garde offset pour le dbut
	ADD.32	D1,D4				; nouvelle taille mmoire
	GESMEM	?RESIZEHANDLE			; redimensionne
	JUMP,NE	R8^ERR$				; erreur => abandonne

	TSET.8	{A3}+ORMpATYPe:D2		; met le bit du registre An  1 (relatif)
	MOVE.32	{A2},A1				; ^zone mmoire  copier

	MOVE.32	D0,{A2}				; relatif au dbut de la zone mmoire
	MOVE.32	D1,{A2}+7*4			; mmorise les tailles
	GESMEM	?LOCKHANDLE			; maintenant dans A3, ^buffer mmoire
	ADD.32	D0,A3

	.IF	DEBUG
	PUSHM.32 D4
	LIB	?AFTIM
	.ASCIZE	"%%%% A1="
	MOVE.32	A1,D4
	LIB	?AFX8
	LIB	?AFTIM
	.ASCIZE	"  A3="
	MOVE.32	A3,D4
	LIB	?AFX8, ?AFCR
	POPM.32	D4
	.ENDIF

COPY$:	MOVE.8	{A1+},{A3+}
	DEC.32	D1
	JUMP,GT	R8^COPY$			; copie la zone

	GESMEM	?UNLOCKHANDLE			; re-libre le HANDLE pour re-dimensionnement futur

ERR$:	POPM.32	D0|D1|D2|A1..A5
	TEST.16	D7
	RET



;-----------\\
;  RECUPVAL  >
;===========/

; Rcupre le contenu du buffer

; in	A3.32	^^mmoire dans le paquet reu
;	A5.32	^^ancienne zone mmoire
;	A6.32	^taille  copier
; out	-
; mod	-

RECUPVAL:
	PUSHM.32 D1|D4|A0|A1

	MOVE.32	{A3},A0				; ^mmoire dans le paquet reu
	MOVE.32	{A5},A1				; ^ancienne zone mmoire
	MOVE.32	{A6},D1				; taille  copier

	.IF	DEBUG
	LIB	?AFTIM
	.ASCIZE	"## Copie depuis "
	MOVE.32	A0,D4
	LIB	?AFX8
	LIB	?AFTIM
	.ASCIZE	" vers "
	MOVE.32	A1,D4
	LIB	?AFX8
	LIB	?AFTIM
	.ASCIZE	" (taille "
	MOVE.32	D1,D4
	LIB	?AFX8
	LIB	?AFTIM
	.ASCIZE	")<CR>"
	.ENDIF

COPY$:	MOVE.8	{A0+},{A1+}
	DEC.32	D1
	JUMP,GT	R8^COPY$			; copie le buffer

	MOVE.32	{A5},{A3}			; rcupre ancien pointeur

	POPM.32	D1|D4|A0|A1
	RET


COPYinout:
	PUSHM.32 D3|A3|A4

	MOVE.16	#LRMp-1,D3

COPY$:	MOVE.8	{A3+},{A4+}
	DJ.16,NMO D3,COPY$

	POPM.32	D3|A3|A4
	RET


END_RMT:

	.END
