	.TITLE	SCAN.ASL

;	--------------------------------------
;		(C) 1989 - Daniel Roux
;	--------------------------------------

;	Source du module SMA_SCAN.LIB


	.PROC	M68000
	.REF	SMAKY
	.REF	MODULES
	.REF	DESSIN2
	.REF	SCAN
	.REF	xxxHARD
	.BASE	10
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SMAKY400 = 10
SMAKY300 = 7
SMAKY130 = 8
SM300ADMUBUS = 16'1000000
SM130ADMUBUS = 16'FFFF8000
SM400ADMUBUS = 16'FFFF8000
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; Rev	Date		Amliorations
; -----------------------------------------------------------------------------
; 2.0	11.11.97  PA	fonctionne sur le Smaky 400
; 1.13	04.08.96  PA	fonctionne en plus que 4 bpp
; 1.12	22.05.95  PA	iy en sortie de scanner idem au iy interne
; 1.11	02.05.95  ChK	attend 1/2 seconde dans SCANCONNECT avant d'allumer
;			le scanner (autrement il n'a pas le temps!!!)
;			Test 10x l'absence du scanner avant d'annuler
; 1.10	16.06.92	adaptation au SMAKY130
; 1.9	11.11.91  DM	adaptation au SMAKY8
; 1.8	21.06.91	accs MUBUS en mode superviseur
; 1.7	27.02.91	version pour SMAKY300
; 1.6	09.11.90	essais pour SMAKY300
; 1.5	09.04.90	n'allume pas le ScanMan plus de 15 secondes !
; 1.4	08.01.90	"Connection" --> "Connexion"
; 1.3	11.12.89	Sauve image: ok si codage impossible
; 1.2	07.12.89	F0 = Annule
;			F4 = Sauve
;			F6 = Param, pour permettre d'aller plus vite !
;			F12 = Contraste, pour amliorer les photos grises
;			F13 = Ngatif
;			F15 = Imprime
; 1.1	05.12.89	empche de dplacer les coupures > OMAXDI
; 1.0	27.11.89	reprise du programme HANDY de CK
; -----------------------------------------------------------------------------


SCANREV	= 2
SCANVERS= 0

	.REV	SCANREV,SCANVERS
	.IDENT	"(C)  Daniel ROUX et EPSITEC SA"




; Constantes
; ----------

NBENT	= 2		; nombre de words d'entte par ligne
NB100	= 25		; nombre de words d'une image  100 ppp
NB200	= 51		; nombre de words d'une image  200 ppp
NB300	= 77		; nombre de words d'une image  300 ppp
NB400	= 103		; nombre de words d'une image  400 ppp

ADBYT1	= 16		; priphrique de lecture du 1er octet
ADBYT2	= 17		; priphrique de lecture du 2me octet
ADSTAT	= 18		; priphrique de lecture des status
AD12V	= 18		; commande 12[V] scanner 0 = ON, 1 = OFF

NBLOOP	= 16'40000	; timeout de 2 secondes

VIMARG	= 16		; marges supp. autour du cadre
IMMARG	= 20		; marges supp. autour de l'image

FDBNBX	= 17		; filtre: nb de cases en X
FDBNBY	= 17		; filtre: nb de cases en Y

LBUFILE	= 50		; lg max d'un nom de fichier

KEYDBOX	= 16'7E00	; "touche" spciale


; Fanions de la rsolution
; ------------------------

BRE100	= 0		; 100 ppp
BRE200	= 1		; 200 ppp
BRE300	= 2		; 300 ppp
BRE400	= 3		; 400 ppp


; Variables
; ---------

	.LOC	0

OCHDESS2:.BLK.16 1	; canal module DESSIN2

OPDDIS:	.BLK.32	1	; ^descripteur de la fentre
OBUDIS:	.BLK.8	30	; buffer pour write-display
OSMAKY:	.BLK.8	1	; type de SMAKY
	.EVEN
OMUBB1:	.BLK.32	1	; ^1er byte sur MUBUS
OMUBB2:	.BLK.32	1	; ^2me byte sur MUBUS
OMSTAT:	.BLK.32	1	; ^status de l'interface
OM12V:	.BLK.32	1	; ^scanner ON-OFF

OAFINV:	.BLK.8	1	; 1 => affichage invers
	.EVEN

OMAXDI:	.BLK.16	2	; dimensions maximales

OPTMEF:	.BLK.32	1	; pointeur buffer de l'image filtre
OPTMEM:	.BLK.32	1	; pointeur buffer de l'image
OLGMEM:	.BLK.32	1	; longeur buffer de l'image

OTIMO:	.BLK.32	1	; timeout
OLARG:	.BLK.16	1	; largeur de l'image en word
ODIMX:	.BLK.16	1	; largeur de l'cran
ODIMY:	.BLK.16	1	; hauteur de l'cran
ONBWRD:	.BLK.16	1	; nombre de word  afficher  l'cran
ONBRES:	.BLK.16	1	; nb. de word restant  lire

OSCRDB:	.BLK.32	1	; ^dbut de l'cran

OREFAN:	.BLK.32	1	; rsolution: fanions

OVIPTI:	.BLK.32	1	; visu: ^data image
OVIDII:	.BLK.16	2	; visu: dimensions image
OVIASV:	.BLK.8	LSCVAR	; visu: ascenseur vertical
OVIASH:	.BLK.8	LSCVAR	; visu: ascenseur horizontal
OVIPOS:	.BLK.16	2	; visu: position coin sup/gauche
OVIDIM:	.BLK.16	2	; visu: dimensions
OVICBY:	.BLK.16	1	; visu: dbut coupe en Y
OVICBX:	.BLK.16	1	; visu: dbut coupe en X
OVICEY:	.BLK.16	1	; visu: fin coupe en Y
OVICEX:	.BLK.16	1	; visu: fin coupe en X
OVIPCM:	.BLK.16	2	; visu: position centre de la souris
OVIMAI:	.BLK.8	1	; visu: 1 => main prsente
OVIBIN:	.BLK.8	1	; visu: bits pour image inverse
 BVIIMO	=  0		;        image originale inverse
 BVIIMF	=  1		;        image filtre inverse
	.EVEN

OFDBTAB:.BLK.8	FDBNBX	; filtre: table
	.EVEN
OFDBPOS:.BLK.16	2	; filtre: position coin sup/gauche
OFDBDIM:.BLK.16	2	; filtre: dimensions d'une case
OFDBFAN:.BLK.32	1	; filtre: fanions
OFDBTRA:.BLK.8	FDBNBX*8 ; filtre: trames

OBUFIO:	.BLK.8	LBUFILE	; sauve: nom du fichier
OBUPRES:.BLK.8	16	; print: nom de la prsentation

LGVAR:




; En-tte du module LIB
; ---------------------

	.LOC	0
	SCAN_	FIRST		; code du premier appel	;%error
	SCAN_	LAST		; code du dernier appel	;%error
	.8	0		; nombre d'installations
	.FILL.8	(OHLREV-APC),0
	.8	SCANREV,SCANVERS ; rvision.version
	.16	0,END_SCAN	; longueur
	.32	PATHLIB		; pattern de dbut
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"SCAN"		; nom du module
	.FILL.8	(LGHLIB-APC),0

	.16	_SCAN_OPEN
	.16	_SCAN_CLOSE
	.16	_SCAN_READ
	.16	_SCAN_RELEASE



NMDESS2:.ASCIZ	"DESSIN2"
	.EVEN



;-----------\\
; _SCAN_OPEN >
;===========/

; Ouvre le module scanner.

; in	-
; out	D6.32	canal
;	D7.16	erreur
; mod	D6.32, D7.16

_SCAN_OPEN:
	PUSHM.32 D0|D1|D3|D4|A0|A1|A3|A4|A5|A6

	MOVE.32	#LGVAR,D4
	MOVE.16	#MTYPCP,D1
	GESMEM	?GETMEM		; A4 <-- ^mmoire pour variables
	JUMP,NE	EXIT$
	GESMEM	?CLEARMEM
	MOVE.32	A4,A6		; A6 <-- ^variables

	MOVE.32	#R16^NMDESS2,A3
	MOVE.16	#DESS2_FIRST,D3
	LIB_	OPEN
	JUMP,NE	R8^NODESS2$
	MOVE.16	D1,{A6}+OCHDESS2
NODESS2$:
	LIB	?GETPDIS
	MOVE.32	A4,{A6}+OPDDIS
	MOVE.32	A4,A0		; A0 <-- ^descripteur fentre

	NTREL	?GETMACHINE	; Cherche le type de machine
	RL.32	#8, D4
	MOVE.8	D4,{A6}+OSMAKY

	MOVE.32	#2**BRE300,{A6}+OREFAN

	MOVE.16	#ERBIOS,D7	; D7 <-- erreur fatale

	COMP.8	#SMAKY324,D4
	JUMP,EQ	R8^OKSMAKY$
	COMP.8	#SMAKY300,D4
	JUMP,EQ	R8^OKSMAKY$
	COMP.8	#SMAKY130,D4
	JUMP,EQ	R8^OKSMAKY$
	COMP.8	#SMAKY400,D4
	JUMP,EQ	R8^OKSMAKY$
	COMP.8	#SMAKY100,D4
	JUMP,EQ	R8^OKSMAKY$
	COMP.8	#SMAKY8,D4
	JUMP,NE	R8^ERROR$
OKSMAKY$:
	TEST.8	{A0}+ODFMOD:#BFBLANC
	JUMP,BS	R8^OKINV$
	SET.8	{A6}+OAFINV	; affichage invers
OKINV$:
	CALL	SCANINIT	; initialise pour la lecture

	CALL	SCANON		; allume le scanner
	CALL	SCANCONNECT	; scanner connect ?
	CALL	SCANOFF		; allume le scanner
	TEST.16	D7
	JUMP,NE	R8^ERROR$

	CLR.16	D3
	CALL	FILDBINIT	; initialise le filtre
	MOVE.32	#2**0.OR.2**18,{A6}+OFDBFAN

	MOVE.32	A6,D6		; D6 <-- canal
	CLR.16	D7		; D7 <-- ok
	JUMP	R8^EXIT$

ERROR$:
	PUSH.16	D7
	MOVE.32	A6,A4
	MOVE.16	#MTYPCP,D1
	GESMEM	?GIVMEM		; libre les variables
	POP.16	D7
EXIT$:
	POPM.32	D0|D1|D3|D4|A0|A1|A3|A4|A5|A6
	TEST.16	D7		; retour EQ/NE
	RET


;------------\\
; _SCAN_CLOSE >
;============/

; Ferme le module scanner.

; in	D6.32	canal
; out	-
; mod	D7.16

_SCAN_CLOSE:
	PUSHM.32 D1|A4|A6

	MOVE.32	D6,A6		; A6 <-- ^variables

	MOVE.16	{A6}+OCHDESS2,D1
	JUMP,EQ	R8^NODESS2$
	LIB_	CLOSE
NODESS2$:
	CALL	_SCAN_RELEASE	; libre image si ncessaire

	MOVE.32	D6,A4
	MOVE.16	#MTYPCP,D1
	GESMEM	?GIVMEM		; libre les variables

	POPM.32	D1|A4|A6
	CLR.16	D7		; retour EQ
	RET


;-----------\\
; _SCAN_READ >
;===========/

; Lit une image sur le scanner.
; Il faudra rafficher tout l'cran et les soft-keys !

; in	D6.32	canal
;	D3.32	mode (zro pour l'instant)
;	D4.32	dimensions maximales (dy;dx)
; out	A4.32	^image
;	D4.32	dimensions (dy;dx) (zro si rien n'est lu)
;	D5.16	incrment ligne
;	D7.16	erreur
; mod	D4.32, D5.32, D7.16, A4.32

_SCAN_READ:
	PUSHM.32 D0..D3|A0..A3|A5|A6

	CALL	_SCAN_RELEASE	; libre image si ncessaire

	MOVE.32	D6,A6		; A6 <-- ^variables
	MOVE.32	{A6}+OPDDIS,A0	; A0 <-- ^descripteur fentre

	COMP.16	#20000,D4
	JUMP,LS	R8^MAXX$
	MOVE.16	#20000,D4
MAXX$:
	SWAP.32	D4
	COMP.16	#20000,D4
	JUMP,LS	R8^MAXY$
	MOVE.16	#20000,D4
MAXY$:
	SWAP.32	D4
	MOVE.32	D4,{A6}+OMAXDI	; OMAXDI <-- dimensions maximales

	CALL	SCANON		; allume le scanner
	CALL	SCANCONNECT	; scanner connect ?
	JUMP,NE	CANCEL$		; non => CANCEL$
DRAW$:
	CALL	VISUDRAW	; dessine les ascenseurs vides
	CALL	VISUFOND	; dessine le fond blanc ou noir
SK$:
	MOVE.32	#R16^SKWAIT,A3
	LIB	?AFMENU		; affiche les soft-keys
	CALL	SCANON		; allume le scanner
LOOP$:
	MOVE.32	#R16^SCANEVENT,A5 ; A5 <-- ^routine  excuter en IOF
	CALL	EXSUPER		; attend touche/scanner ...

	TEST.16	D3		; une ligne lue du scanner ?
	JUMP,EQ	SCAN$		; oui => SCAN$

	COMP.16	#KEYMGR,D3
	JUMP,EQ	LOOP$
	COMP.16	#KEYMMR,D3
	JUMP,EQ	LOOP$
	COMP.16	#KEYMDR,D3
	JUMP,EQ	LOOP$

	COMP.16	#F0+SHIFT,D3
	JUMP,LO R8^NOSF$
	COMP.16	#F15+SHIFT,D3
	JUMP,HI R8^NOSF$
	SUB.16	#SHIFT,D3
NOSF$:
	COMP.16	#F0,D3
	JUMP,EQ CANCEL$

	COMP.16	#F6,D3
	JUMP,EQ RESOL$

	COMP.16	#F13,D3
	JUMP,EQ INV$
BIP$:
	MOVE.16	#BIPLIT,D3
	LIB	?BEEP		; p'tit bruit
	JUMP	LOOP$

ERROR$:
	PUSH.16	D7
	MOVE.16	#BIPERR,D3
	LIB	?BEEP		; vilain bruit
	POP.16	D7
	CLR.16	D2
	DBOX_	MERROR		; affiche l'erreur ...
	JUMP	DRAW$

RESOL$:
	CALL	SCANOFF		; teint le scanner
	CALL	VISUVIDE
	CALL	DBOXRESOL	; choix de la rsolution ...
	JUMP,NE	ERROR$
	CALL	VISUFOND	; dessine le fond blanc ou noir
	JUMP	SK$

INV$:
	NOT.8	{A6}+OAFINV
	CALL	VISUFOND	; dessine le fond blanc ou noir
	JUMP	LOOP$

SCAN$:
	CALL	SCANIMAGE	; lit une image ...
	JUMP,NE ERROR$
	TEST.32	D4
	JUMP,EQ RIEN$

	COMP.16	#32,D4		; image minuscule ?
	JUMP,LS	RIEN$		; oui => RIEN$
	SWAP.32	D4
	COMP.16	#2,D4
	JUMP,LS	RIEN$
	SWAP.32	D4

	CALL	SCANOFF		; teint le scanner
	MOVE.32	A4,{A6}+OVIPTI
	MOVE.32	D4,{A6}+OVIDII
	CLR.8	{A6}+OVIBIN	; images positives
	CALL	VISU		; montre l'image ...

	COMP.16	#F1,D3
	JUMP,EQ R8^EXIT$
	COMP.16	#F2,D3
	JUMP,EQ R8^EXIT$
	COMP.16	#F3,D3
	JUMP,EQ R8^EXIT$

	CALL	_SCAN_RELEASE	; libre image si ncessaire

	COMP.16	#F0,D3
	JUMP,EQ R8^CANCEL$

	COMP.16	#F7,D3
	JUMP,EQ DRAW$
	COMP.16	#F8,D3
	JUMP,EQ DRAW$
	COMP.16	#F9,D3
	JUMP,EQ DRAW$

	JUMP	R8^CANCEL$

RIEN$:
	CALL	_SCAN_RELEASE	; libre image si ncessaire
	JUMP	SK$

CANCEL$:
	CLR.32	D4		; D4 <-- image nulle
EXIT$:
	CALL	SCANOFF		; teint le scanner

	POPM.32	D0..D3|A0..A3|A5|A6
	CLR.16	D7		; retour EQ
	RET


;--------------\\
; _SCAN_RELEASE >
;==============/

; Libre l'image lue par SCAN_READ.

; in	D6.32	canal
; out	-
; mod	D7.16

_SCAN_RELEASE:
	PUSHM.32 D1|A4|A6

	MOVE.32	D6,A6		; A6 <-- ^variables

	TEST.32	{A6}+OPTMEF	; image filtre existe ?
	JUMP,EQ	R8^COPY$	; non => COPY$

	MOVE.32	{A6}+OPTMEF,A4	; A4 <-- ^buffer
	MOVE.16	#MTYPCP,D1
	GESMEM	?GIVMEM		; libre la mmoire
	CLR.32	{A6}+OPTMEF
COPY$:
	TEST.32	{A6}+OPTMEM	; image existe ?
	JUMP,EQ	R8^EXIT$	; non => EXIT$

	MOVE.32	{A6}+OPTMEM,A4	; A4 <-- ^buffer
	MOVE.16	#MTYPCP,D1
	GESMEM	?GIVMEM		; libre la mmoire
	CLR.32	{A6}+OPTMEM
EXIT$:
	POPM.32	D1|A4|A6
	CLR.16	D7		; retour EQ/NE
	RET




;---------\\
; SCANINIT >
;=========/

; Initialise pour la lecture du scanner.

; in	-
; out	-
; mod	D7.16

SCANINIT:
	COMP.8	#SMAKY8,{A6}+OSMAKY
	JUMP,EQ	SM8$
	COMP.8	#SMAKY100,{A6}+OSMAKY
	JUMP,EQ	SM100$
	COMP.8	#SMAKY300,{A6}+OSMAKY
	JUMP,EQ	SM300$
	COMP.8	#SMAKY130,{A6}+OSMAKY
	JUMP,EQ	SM130$
	COMP.8	#SMAKY400,{A6}+OSMAKY
	JUMP,EQ	SM400$
SM324$:
	MOVE.32	#NBLOOP*4,{A6}+OTIMO
	MOVE.32	#SM324ADMUBUS+ADBYT1,{A6}+OMUBB1
	MOVE.32	#SM324ADMUBUS+ADBYT2,{A6}+OMUBB2
	MOVE.32	#SM324ADMUBUS+ADSTAT,{A6}+OMSTAT
	MOVE.32	#SM324ADMUBUS+AD12V,{A6}+OM12V
	JUMP	EXIT$
SM300$:
	MOVE.32	#NBLOOP*6,{A6}+OTIMO
	MOVE.32	#SM300ADMUBUS+ADBYT1,{A6}+OMUBB1
	MOVE.32	#SM300ADMUBUS+ADBYT2,{A6}+OMUBB2
	MOVE.32	#SM300ADMUBUS+ADSTAT,{A6}+OMSTAT
	MOVE.32	#SM300ADMUBUS+AD12V,{A6}+OM12V
	JUMP	EXIT$
SM130$:
	MOVE.32	#NBLOOP*6,{A6}+OTIMO
	MOVE.32	#SM130ADMUBUS+ADBYT1,{A6}+OMUBB1
	MOVE.32	#SM130ADMUBUS+ADBYT2,{A6}+OMUBB2
	MOVE.32	#SM130ADMUBUS+ADSTAT,{A6}+OMSTAT
	MOVE.32	#SM130ADMUBUS+AD12V,{A6}+OM12V
	JUMP	EXIT$
SM400$:
	MOVE.32	#NBLOOP*10,{A6}+OTIMO
	MOVE.32	#SM400ADMUBUS+ADBYT1*4,{A6}+OMUBB1
	MOVE.32	#SM130ADMUBUS+ADBYT2*4,{A6}+OMUBB2
	MOVE.32	#SM130ADMUBUS+ADSTAT*4,{A6}+OMSTAT
	MOVE.32	#SM130ADMUBUS+AD12V*4,{A6}+OM12V
	JUMP	EXIT$
SM100$:
	MOVE.32	#NBLOOP,{A6}+OTIMO
	MOVE.32	#SM100ADMUBUS+ADBYT1*2,{A6}+OMUBB1
	MOVE.32	#SM100ADMUBUS+ADBYT2*2,{A6}+OMUBB2
	MOVE.32	#SM100ADMUBUS+ADSTAT*2,{A6}+OMSTAT
	MOVE.32	#SM100ADMUBUS+AD12V*2,{A6}+OM12V
	JUMP	EXIT$
SM8$:
	MOVE.32	#NBLOOP,{A6}+OTIMO
	MOVE.32	#SM8MUBUS20+1+ADBYT1*2,{A6}+OMUBB1
	MOVE.32	#SM8MUBUS20+1+ADBYT2*2,{A6}+OMUBB2
	MOVE.32	#SM8MUBUS20+1+ADSTAT*2,{A6}+OMSTAT
	MOVE.32	#SM8MUBUS20+1+AD12V*2,{A6}+OM12V
;	JUMP	EXIT$
EXIT$:
	RET


;------------\\
; SCANCONNECT >
;============/

; Vrifie si le scanner est connect.

; in	-
; out	D7.16	erreur
; mod	D7.16

SCANCONNECT:
	PUSHM.32 D4|A5


	MOVE.16	#50/2,D4
	NTREL	?DELMS		; ChK: attend 1/2 de seconde ...

	MOVE.32	#R16^SCANIFCON,A5 ; A5 <-- ^routine  excuter en IOF
	CALL	EXSUPER		; excute en mode superviseur
END$:
	POPM.32	D4|A5
	TEST.16	D7
	RET

;----------\\
; SCANIFCON >
;----------/

; Vrifie si le scanner est connect.

; in	-
; out	D7.16	erreur
; mod	D7.16

SCANIFCON:
	PUSHM.32 D1|D2|D3|A0|A1|A4

	COMP.8	#SMAKY300,{A6}+OSMAKY
	JUMP,EQ	SM300$
	OR.16	#16'0700,SF	; met IOF total
	JUMP	SMXXX$
SM300$:
	OR.16	#16'0500,SF	; met IOF presque total
SMXXX$:
	MOVE.16	#ERTIMO,D7	; D7 <-- timeout

	MOVE.32	{A6}+OMUBB1,A0
	MOVE.32	{A6}+OMUBB2,A1
	MOVE.32	{A6}+OMSTAT,A4
	MOVE.32	#10,D1		;ChK test 10x si le scanner est absent
	MOVE.32	{A6}+OTIMO,D3	; D3 <-- prpare un timeout de 2 secondes
WAIT$:
	TEST.8	{A4}:#7		; 16 bits reus ?
	JUMP,BS	READ$
	DEC.32	D3
	JUMP,NE	WAIT$
	JUMP	EXIT$

READ$:
	MOVE.8	{A1},D2		; D2 <-- lit les poids forts
	MOVE.8	{A0},D3		; D3 <-- lit les poids faibles
	MOVE.8	D3,{A0}

;ChK	COMP.8	#-1,D3
;ChK	JUMP,EQ	EXIT$		; peut-tre que c'est l'image...

	COMP.8	#-1,D2		;ChK Test aussi les poids forts
	JUMP,NE	OK$
	COMP.8	#-1,D3		;ChK et les poids faible du 1er byte
	JUMP,NE	OK$		;ChK de l'image
	DEC.32	D1
	JUMP,NE	WAIT$		;Chk Essaye 10x
	JUMP	EXIT$
OK$:
	CLR.16	D7		; D7 <-- connect
EXIT$:
	POPM.32	D1|D2|D3|A0|A1|A4
	POPM.32	D0|A0
	RETSF


;----------\\
; SCANEVENT >
;==========/

; Attend un vnement du clavier ou du scanner.

; in	-
; out	D3.32	touche presse (zro si scanner)
; mod	D3.32, D7.16

SCANEVENT:
	PUSHM.32 D1|D2|D4|D5|A4

	NTREL	?GETSYTIME	; D4 <-- temps processus (mod D2..D5 !)
	MOVE.32	D4,D1		; D1 <-- temps du dbut (unit = 128us)

	MOVE.32	{A6}+OMSTAT,A4
	MOVE.16	#100,D2
LOOP$:
	LIB	?IFCAR		; D3 <-- touche presse
	JUMP,EQ	R8^EXIT$

	DEC.16	D2
	JUMP,NE R8^SCAN$

	NTREL	?GETSYTIME	; D4 <-- temps processus (mod D2..D5 !)
	SUB.32	D1,D4		; D4 <-- temps coul (unit = 128us)
	MOVE.16	#F0,D3		; D3 <-- annule
	COMP.32	#15*(1000000/128),D4 ; s'est-il coul 15 secondes ?
	JUMP,HS	R8^EXIT$	; oui => EXIT$

	MOVE.16	#100,D2
SCAN$:
	TEST.8	{A4}:#6		; prend une ligne ?
	JUMP,BC	LOOP$		; non => LOOP$
	CLR.32	D3
EXIT$:
	POPM.32	D1|D2|D4|D5|A4
	POPM.32	D0|A0
	RETSF


;----------\\
; SCANIMAGE >
;==========/

; Lit une image entire depuis le scanner.

; in	-
; out	A4.32	^image
;	D4.32	dimensions (dy;dx)
;	D7.16	erreur
; mod	D4.32, D7.16, A4.32

SCANIMAGE:
	PUSHM.32 D0..D3|D5|A0|A5

	MOVE.8	#AFCCMO,D3
	LIB	?AFCAR		; enlve la souris

	GESMEM	?ARGMEM		; D4/D5 <-- total libre/plus grand trou
	MOVE.32	D5,D4
	SUB.32	#25000,D4	; D4 <-- il doit rester 25 Kbytes !

	MOVE.16	#ERNEMEM,D7	; D7 <-- pas assez de mmoire
	COMP.32	#50000,D4	; reste au moins 50 Kbytes ?
	JUMP,LT	EXIT$		; non => EXIT$
	COMP.32	#1000000,D4	; reste plus de 1 Mbyte ?
	JUMP,LT R8^MEM$		; non => R8^MEM$
	MOVE.32	#1000000,D4	; D4 <-- pas plus que 1 Mbyte
MEM$:
	ADD.32	#32,D4		; D4 <-- rserve pour IMAGEINV !
	MOVE.16	#MTYPCP,D1
	GESMEM	?GETMEM		; A4 <-- mmoire du buffer d'image
	JUMP,NE EXIT$
	SUB.32	#32,D4
	MOVE.32	A4,{A6}+OPTMEM
	MOVE.32	D4,{A6}+OLGMEM

	MOVE.32	{A6}+OPDDIS,A0	; A0 <-- ^descripteur fentre

	MOVE.32	#0,D3
	MOVE.8	{A0}+ODFCNP,D3	; D3 <-- nb de bits/pixel
	JUMP,NE R8^COUL$
	INC.16	D3

COUL$:	LIB	?POW2DEPTH
	MOVE.16	D3,D1		; D1 <-- puissance de 2 suprieure

	MOVE.16	{A0}+ODFFDY,D0
	SUB.16	{A0}+ODFC1Y,D0
	SUB.16	{A0}+ODFC2Y,D0
	SUB.16	#VIMARG+LGSCROLL+LGSCROLL+VIMARG,D0
	MOVE.16	D0,{A6}+ODIMY

	MOVE.16	{A0}+ODFFDX,D0
	SUB.16	#VIMARG+LGSCROLL+LGSCROLL+VIMARG,D0
	MUL.16	D1,D0
	MOVE.16	D0,{A6}+ODIMX

	MOVE.32	{A0}+ODFABS,A4
	MOVE.16	{A0}+ODFWBX,D0
	ADD.16	#VIMARG+LGSCROLL,D0
	SR.16	#3,D0
	MUL.16	D1,D0
	ADD.32	D0,A4
	MOVE.16	{A0}+ODFWBY,D0
	ADD.16	{A0}+ODFC1Y,D0
	ADD.16	{A0}+ODFC2Y,D0
	ADD.16	#VIMARG+LGSCROLL,D0
	MUL.16	{A0}+ODFIIY,D0
	ADD.32	D0,A4
	MOVE.32	A4,{A6}+OSCRDB

	MOVE.32	{A6}+OREFAN,D0	; D0 <-- fanions de la rsolution
	MOVE.16	#NB100,{A6}+OLARG
	TEST.32	D0:#BRE100
	JUMP,BS	R8^PAOK$
	MOVE.16	#NB200,{A6}+OLARG
	TEST.32	D0:#BRE200
	JUMP,BS	R8^PAOK$
	MOVE.16	#NB300,{A6}+OLARG
	TEST.32	D0:#BRE300
	JUMP,BS	R8^PAOK$
	MOVE.16	#NB400,{A6}+OLARG
PAOK$:
	MOVE.16	{A6}+OLARG,D0	; D0 <-- largeur image en words
	MOVE.16	{A6}+ODIMX,D1	; D1 <-- largeur de l'cran en points
	SR.16	#4,D1		; D1 <-- largeur de l'cran en words
	MOVE.16	D0,{A6}+ONBWRD
	CLR.16	{A6}+ONBRES
	COMP.16	D1,D0
	JUMP,LS	LGOK$
	MOVE.16	D1,{A6}+ONBWRD
	SUB.16	D1,D0
	MOVE.16	D0,{A6}+ONBRES
LGOK$:
	MOVE.32	#R16^SCANALL,A5	; A5 <-- ^routine  excuter en IOF
	CALL	EXSUPER		; excute en mode superviseur
	JUMP,NE	R8^GIVE$

	PUSH.32	D4
	MOVE.32	D4,D3
	SWAP.32	D3		; D3 <-- hauteur en points
	SR.16	#3,D4		; D4 <-- largeur en bytes
	MUL.16	D3,D4
	ADD.32	#32,D4		; D4 <-- rserve pour IMAGEINV !
	MOVE.16	#MTYPCP,D1
	GESMEM	?TRUNCMEM	; libre la fin inutile
	POP.32	D4
	CLR.16	D7
	JUMP	R8^EXIT$

GIVE$:
	PUSH.16	D7
	MOVE.32	{A6}+OPTMEM,A4	; A4 <-- ^buffer
	MOVE.16	#MTYPCP,D1
	GESMEM	?GIVMEM		; libre l'image lue
	CLR.32	{A6}+OPTMEM
	POP.16	D7
EXIT$:
	PUSH.16	D7
	MOVE.8	#AFSCMO,D3
	LIB	?AFCAR		; remet la souris
	POP.16	D7

	POPM.32	D0..D3|D5|A0|A5
	TEST.16	D7
	RET

;--------\\
; SCANALL >
;--------/

; Lit toute l'image depuis le scanner.

; in	-
; out	A4.32	^image
;	D4.32	dimensions (dy;dx)
; mod	D4.32, D7.16, A4.32

SCANALL:
	PUSHM.32 D0..D3|D5|D6|A0..A3|A5

	COMP.8	#SMAKY300,{A6}+OSMAKY
	JUMP,EQ	SM300$
	OR.16	#16'0700,SF	; met IOF total
	JUMP	SMXXX$
SM300$:
	OR.16	#16'0500,SF	; met IOF presque total
SMXXX$:
	MOVE.32	{A6}+OMUBB1,A0
	MOVE.32	{A6}+OMUBB2,A1
	MOVE.32	{A6}+OMSTAT,A4

	MOVE.32	{A6}+OPDDIS,A5	; A5 <-- ^descripteur cran
	MOVE.32	{A6}+OPTMEM,A2	; A2 <-- ^buffer
	MOVE.32	{A6}+OSCRDB,A3	; A3 <-- ^cran
	CLR.16	D6		; D6 <-- compteur de ligne sur l'cran
	CLR.16	D5		; D5 <-- compteur de ligne dans buffer
	CLR.16	D3		; D3 <-- lg max ligne lue
LOOP$:
	COMP.16	{A6}+ODIMY,D6	; est-on en bas de l'cran ?
	JUMP,LO	R8^NOTOP$	; non => NOTOP$
	MOVE.32	{A6}+OSCRDB,A3	; A3 <-- ^haut de l'cran
	CLR.16	D6		; D6 <-- r-arme le compteur cran
NOTOP$:

; Lit toute une ligne depuis le scanner.

; in	A2.32	^dans buffer
;	A3.32	^dans l'cran
;	D5.16	compteur de ligne dans buffer
;	A0.16	^OMUBB1
;	A1.16	^OMUBB2
;	A4.16	^OMSTAT
; out	A2.32	^plus loin
;	D4.16	lg ligne lue
;	D7.16	erreur
; mod	D0.32, D1.32, D2.32, D4.32, D7.16, A2.32

	PUSHM.32 A3|A5

	CLR.16	D7		; D7 <-- ok

	MOVE.16	#NBENT-1,D1	; D1 <-- lg en-tte
	MOVE.32	{A6}+OTIMO,D0	; D0 <-- prpare un timeout de 2 secondes
;;?	TEST.16	D5		; premire lecture ?
;;?	JUMP,NE	R8^WLINE$	; non => WLINE$
;;?	SL.32	#4,D0		; D0 <-- prpare un timeout de 32 secondes
WLINE$:
	TEST.8	{A4}:#6		; prend une autre ligne ?
	JUMP,BS	R8^WHEAD$	; oui => WHEAD$
	DEC.32	D0
	JUMP,NE	WLINE$
	MOVE.16	#ERTIMO,D7	; D7 <-- timeout
	JUMP	LEXIT$
WHEAD$:
	TEST.8	{A4}:#7		; 16 bits reus ?
	JUMP,BC	WHEAD$
	MOVE.8	{A1},D0		; D0 <-- lit les poids forts
	MOVE.8	{A0},D0		; D0 <-- lit les poids faibles
	MOVE.8	D0,{A0}
	DJ.16,NMO D1,WHEAD$

	MOVE.32	A2,A5		; A5 <-- ^dernier word non-nul
	MOVE.32	A2,D4		; D4 <-- ^dbut ligne

	MOVE.16	{A6}+ONBWRD,D1	; D1 <-- nb de words  lire
	DEC.16	D1		; D1 <-- -1  cause NMO
	TEST.8	{A6}+OAFINV	; affichage invers ?
	JUMP,NE	R8^ILOOP$	; oui => ILOOP$
NLOOP$:
	TEST.8	{A4}:#7		; 16 bits reus ?
	JUMP,BC	NLOOP$
	MOVE.8	{A1},D0		; D0 <-- lit les poids forts
	SL.16	#8,D0
	MOVE.8	{A0},D0		; D0 <-- lit les poids faibles
	MOVE.8	D0,{A0}
	MOVE.16	D0,{A2+}	; buffer de lecture <-- 16 bits lus
	JUMP,EQ	R8^NZERO$
	MOVE.32	A2,A5		; A5 <-- ^dernier word non-nul
NZERO$:
	MOVE.16	D0,{A3+}	; cran <-- 16 bits lus
	DJ.16,NMO D1,NLOOP$
	JUMP	R8^LAST$

ILOOP$:
	TEST.8	{A4}:#7		; 16 bits reus ?
	JUMP,BC	ILOOP$
	MOVE.8	{A1},D0		; D0 <-- lit les poids forts
	SL.16	#8,D0
	MOVE.8	{A0},D0		; D0 <-- lit les poids faibles
	MOVE.8	D0,{A0}
	MOVE.16	D0,{A2+}	; buffer de lecture <-- 16 bits lus
	JUMP,EQ	R8^IZERO$
	MOVE.32	A2,A5		; A5 <-- ^dernier word non-nul
IZERO$:
	NOT.16	D0
	MOVE.16	D0,{A3+}	; cran <-- 16 bits lus
	DJ.16,NMO D1,ILOOP$
;	JUMP	R8^LAST$

LAST$:
	MOVE.16	{A6}+ONBRES,D1	; D1 <-- nb de words restants
	JUMP,EQ	R8^LEND$
	DEC.16	D1		; D1 <-- -1  cause NMO
LLOOP$:
	TEST.8	{A4}:#7		; 16 bits reus ?
	JUMP,BC	LLOOP$
	MOVE.8	{A1},D0		; D0 <-- lit les poids forts
	SL.16	#8,D0
	MOVE.8	{A0},D0		; D0 <-- lit les poids faibles
	MOVE.8	D0,{A0}
	MOVE.16	D0,{A2+}	; buffer de lecture <-- 16 bits lus
	JUMP,EQ	R8^LZERO$
	MOVE.32	A2,A5		; A5 <-- ^dernier word non-nul
LZERO$:
	DJ.16,NMO D1,LLOOP$
LEND$:
	MOVE.32	A5,A2		; A2 <-- ^dernier word non-nul
	SUB.32	A5,D4
	NEG.32	D4		; D4 <-- lg
	MOVE.16	D4,{A2+}	; buffer <-- lg
LEXIT$:
	POPM.32	A3|A5
	TEST.16	D7		; retour EQ/NE
	JUMP,NE	R8^END$

	INC.16	D5		; D5 <-- ligne suivante dans buffer
	INC.16	D6		; D6 <-- ligne suivante dans l'cran
	ADD.A16	{A5}+ODFIIY,A3	; A3 <-- ^ligne cran suivante

	MOVE.8	D0,{A1}		; prpare pour la ligne suivante

	ADD.16	#2,D4
	COMP.16	D4,D3
	JUMP,HS	R8^LITTLE$
	MOVE.16	D4,D3		; D3 <-- lg max ligne lue
LITTLE$:
	MOVE.16	D3,D4
	MUL.16	D5,D4		; D4 <-- place occupe une fois tendu
	COMP.32	{A6}+OLGMEM,D4
	JUMP,LO	LOOP$
END$:
	CALL	SCANEXTEND	; tend l'image

	POPM.32	D0..D3|D5|D6|A0..A3|A5
	CLR.16	D7		; D7 <-- ok
	POPM.32	D0|A0
	RETSF

;-----------\\
; SCANEXTEND >
;-----------/

; Etend l'image compresse.

; in	A2.32	^fin lecture dans buffer
;	D3.16	lg max ligne
;	D5.16	nb lignes lues
; out	A4.32	^image
;	D4.32	dimensions (dy;dx)
; mod	D4.32, D7.16, A4.32

SCANEXTEND:
	PUSHM.32 D1..D3|A2

	MOVE.32	{A6}+OPTMEM,A4
	ADD.32	{A6}+OLGMEM,A4

	CLR.32	D4		; D4 <-- dimensions nulles
	SUB.16	#2,D3
	JUMP,NS	EXIT$

	MOVE.16	D5,D4		; D4 <-- hauteur
	SWAP.32	D4
	MOVE.16	D3,D4		; D4 <-- largeur en bytes
	SL.16	#3,D4		; D4 <-- largeur en points
LOOP$:
	MOVE.16	{-A2},D1	; D1 <-- lg ligne

	MOVE.16	D3,D2
	SUB.16	D1,D2		; D2 <-- lg  remplir de zros
	JUMP,EQ	R8^MAX$
	SR.16	#1,D2		; D2 <-- /2 car .16
	DEC.16	D2		; D2 <-- -1 car NMO
ZERO$:
	CLR.16	{-A4}
	DJ.16,NMO D2,ZERO$
MAX$:
	SR.16	#1,D1		; D1 <-- /2 car .16
	JUMP,EQ	R8^NEXT$
	DEC.16	D1		; D1 <-- -1 car NMO
XFER$:
	MOVE.16	{-A2},{-A4}
	DJ.16,NMO D1,XFER$
NEXT$:
	DEC.16	D5		; encore une ligne ?
	JUMP,NE	LOOP$		; oui => LOOP$

	MOVE.32	{A6}+OPTMEM,A2
	MOVE.32	A2,D3
	ADD.32	{A6}+OLGMEM,D3
	SUB.32	A4,D3
	SR.32	#2,D3
BEGIN$:
	MOVE.32	{A4+},{A2+}	; ramne l'image au dbut (pour ?TRUNCMEM)
	DEC.32	D3
	JUMP,NC	BEGIN$

	MOVE.32	{A6}+OPTMEM,A4	; A4 <-- ^image au dbut
EXIT$:
	POPM.32	D1..D3|A2
	RET


;----------\\
; SCANCOUPE >
;----------/

; Coupe l'image selon les repres.

; in	-
; out	A4.32	^image coupe
;	D4.32	dimensions (dy;dx)
;	D5.16	incrment ligne
;	D7.16	erreur
; mod	D4.32, D5.32, D7.16, A4.32

SCANCOUPE:
	PUSHM.32 D1|D2|D3|D6|A2|A3

	MOVE.32	{A6}+OVIPTI,A4	; A4 <-- ^source
	TEST.32	{A6}+OPTMEF	; image filtre existe ?
	JUMP,EQ	R8^NOF$		; non => NOF$
	MOVE.32	{A6}+OPTMEF,A4	; A4 <-- ^source (image filtre)

NOF$:	TEST.8	{A6}+OAFINV	; affichage invers ?
	JUMP,EQ	R8^NOINV$	; non => NOINV$
	CALL	IMAGEINV	; remet l'image en positif

NOINV$:	MOVE.16	{A6}+OVIDII+2,D5
	SR.16	#3,D5		; D5 <-- iy source

	MOVE.16	{A6}+OVICBY,D3
	SUB.16	#IMMARG,D3
	SWAP.32	D3
	MOVE.16	{A6}+OVICBX,D3
	SUB.16	#IMMARG,D3	; D3 <-- position source

	MOVE.16	#ERDIOUT,D7
	MOVE.16	{A6}+OVICEY,D2
	SUB.16	{A6}+OVICBY,D2	; D2 <-- hauteur
	COMP.16	{A6}+OMAXDI+0,D2
	JUMP,HS	EXIT$
	SWAP.32	D2
	MOVE.16	{A6}+OVICEX,D2
	SUB.16	{A6}+OVICBX,D2	; D2 <-- largeur
	COMP.16	{A6}+OMAXDI+2,D2
	JUMP,HS	EXIT$

	CLR.32	D4		; D4 <-- position destination

;;	MOVE.16	D2,D6
;;	ADD.16	#16-1,D6
;;	SR.16	#4,D6
;;	SL.16	#1,D6		; D6 <-- iy destination

	MOVE.16	D5,D6		; D6 <-- iy destination comme iy source

	MOVE.32	#LOADDOT,D1	; D1 <-- mode
	MOVE.32	A0,A2		; A2 <-- ^descripteur fentre
	MOVE.32	A4,A3		; A3 <-- ^source
	GRA2_	RASTER

	MOVE.32	A4,A3		; A3 <-- ^image coupe

	MOVE.16	D2,D3
	SR.16	#4,D3
	SL.16	#4,D3		; D3 <-- largeur en points (arrondi)
	SUB.16	D2,D3
	JUMP,EQ	R8^END$

	MOVE.16	#-1,D1
	SR.16	D3,D1
	NOT.16	D1		; D1 <-- masque

	ADD.A16	D6,A3
	SUB.32	#2,A3		; A3 <-- ^dernier word de la ligne
	MOVE.32	D2,D3
	SWAP.32	D3		; D3 <-- nb de lignes

CLEAR$:	AND.16	D1,{A3}		; masque la fin de la ligne
	ADD.A16	D6,A3		; A3 <-- ^fin ligne suivante
	DEC.16	D3
	JUMP,NE	CLEAR$

END$:	MOVE.32	D2,D4		; D4 <-- dimensions
	MOVE.16	D6,D5		; D5 <-- iy

	CLR.16	D7		; D7 <-- ok

EXIT$:	POPM.32	D1|D2|D3|D6|A2|A3
	TEST.16	D7		; retour EQ/NE
	RET


;--------\\
; SCANON  >
;========/

; Allume le scanner.

; in	-
; out	-
; mod	-

SCANON:
	PUSHM.32 D7|A5

	MOVE.32	#R16^EXEC$,A5	; A5 <-- ^routine  excuter en IOF
	CALL	EXSUPER		; excute en mode superviseur

	POPM.32	D7|A5
	RET

EXEC$:
	PUSH.32 A1

	MOVE.32	{A6}+OM12V,A1
	MOVE.8	#0,{A1}		; 12V scanner ON

	POP.32	A1
	POPM.32	D0|A0
	RETSF

;--------\\
; SCANOFF >
;========/

; Eteint le scanner.

; in	-
; out	-
; mod	-

SCANOFF:
	PUSHM.32 D7|A5

	MOVE.32	#R16^EXEC$,A5	; A5 <-- ^routine  excuter en IOF
	CALL	EXSUPER		; excute en mode superviseur

	POPM.32	D7|A5
	RET

EXEC$:
	PUSH.32	A1

	MOVE.32	{A6}+OM12V,A1
	MOVE.8	#1,{A1}		; 12V scanner OFF

	POP.32	A1
	POPM.32	D0|A0
	RETSF


;--------\\
; EXSUPER >
;========/

; Excute une routine en mode superviseur.

; in	A5.32	^routine  excuter en mode superviseur
; out	D7.16	erreur
; mod	D7.16, A5.32

EXSUPER:
	NTREL	?IEP15TRP	; init le TRAP #15
	JUMP,NE	R8^EXIT$

	TRAP	#15		; passe en mode "superviseur"

	PUSH.16	D7
	MOVE.32	#0,A5
	NTREL	?IEP15TRP	; init le TRAP #15
	POP.16	D7
EXIT$:
	TEST.16	D7		; retour EQ/NE
	RET





SKWAIT:
	.ASCIZ	"An-  "
	.ASCIZ	"nule "
		;     ;     ;     ;
	.ASCIZ	""
	.ASCIZ	"<AFGREY>Prend<AFFULL>"
		;     ;     ;     ;
	.ASCIZ	"<AFGREY>Sauve<AFFULL>            "
	.ASCIZ	"<AFGREY>image<AFFULL>       Rsol"
		;     ;     ;     ;
	.ASCIZ	""
	.ASCIZ	""
		;     ;     ;     ;
	.ASCIZ	"<AFGREY>            Con- <AFFULL>"
	.ASCIZ	"<AFGREY>Filtre     traste<AFFULL>"
		;     ;     ;     ;
	.ASCIZ	""
	.ASCIZ	"Ngatif      <AFGREY>Imp.<AFFULL>"
		;     ;     ;     ;

SKVISU:
	.ASCIZ	"An-  "
	.ASCIZ	"nule "
		;     ;     ;     ;
	.ASCIZ	""
	.ASCIZ	"Prend"
		;     ;     ;     ;
	.ASCIZ	"Sauve            "
	.ASCIZ	"image       Rsol"
		;     ;     ;     ;
	.ASCIZ	"   Scanne une    "
	.ASCIZ	"  autre image... "
		;     ;     ;     ;
	.ASCIZ	"            Con- "
	.ASCIZ	"Filtre     traste"
		;     ;     ;     ;
	.ASCIZ	""
	.ASCIZ	"Ngatif      Imp."
		;     ;     ;     ;

	.EVEN





	.INS	SCANDBOX.ASI
	.INS	SCANVISU.ASI
	.INS	SCANFILTRE.ASI
	.INS	SCANCONTRA.ASI
	.INS	SCANIO.ASI
	.INS	SCANMISC.ASI
	.INS	SCANTABLE.ASI




END_SCAN:



	.END
