
	.TITLE	SCROLL.ASL

	.PROC	M68000
	.BASE	10'10

	.REF	SMAKY
	.REF	MODULES
	.REF	COLORS

REVMAJ	= 3
REVMIN	= 11

OSLSPTR		= OSLCXA + 2

; Date		Rev	Amliorations
; -------------------------------------------------------------------------------------
; 03.10.97 PA	3.11	hilite correctement la cabine si bpp > 8
; 30.09.97 PA	3.10	liste avec ascenseurs proportionnels automatiques
; 29.09.97 PA	3.9	coordonnes ngatives possibles (comparaisons signes)
; 22.09.97 PA	3.8	petite correction pour choix du look 3D (LIB ?FLUSH)
; 29.08.97 PA	3.7	choix du look 3D plus intelligent (prend en compte les gris)
; 16.11.96 PA	3.6	n'appelle plus LDIM depuis LDRAW si la taille semble correcte
;			et que OSLSPTR a t initialis correctement (contrle)
; 10.08.96 PA	3.5	utilise LIB ?HILITERECT
; 03.08.96 PA	3.4	gestion de bpp > 4
; 22.06.96 PA	3.3	utilise ICOL_HILITE pour SCROLL_LINVCAS en couleur
; 28.04.95 PA	3.2	ajout OSLNSL pour les listes
; 22.04.95 PA	3.1	adaptation pour pouvoir forcer l'ancien look
; 11.02.95 PA	3.0	traduction en CALM, ajout du look 3D
;			tats press, inactif et gris pour les boutons
;			offset cabine/souris constant lors de move
; 21.02.92	2.11	SCROLL_L*: slectionne la case du centre si OSLNBY impair
; 18.12.91	2.10	SCROLL_L*: efface toute la surface des cases vides
;			SCROLL_L*: accepte si seulement 3 lignes
; 28.06.91	2.9	SCROLL_L*: case inverse plus avec AFINV !
;			SCROLL_L*: couleurs
;			SCROLL_MOVE: meilleure dtection de la position de l'ascenseur
; 13.09.88	2.8	SCROLL_LUPDATE met toujours trait fin dernire case
; 24.05.88	2.7	SCROLL_LMOVE utilise scroll up/down
;			si CALL (OSLADL) retourne D3=1 --> ligne pointille
; 13.04.88	2.6	et vive la couleur ...
; 02.03.88	2.5	rgles: dizaines en gras
; 16.02.88	2.4	rgles: plus jolies (n'utilisent plus NEF07)
;			rgles: graduation ok jusqu' 2 mtres
; 14.12.87	2.3	SCROLL_RUPDATE ok si hauteur > 512
; 24.06.87	2.2	liste: pages dans ascenseur vertical possibles
; 20.01.87	2.1	ascenseur: possible mme si trs court
; -------------------------------------------------------------------------------------


	.REV	REVMAJ,REVMIN
	.IDENT	"(C)  Daniel ROUX et EPSITEC SA"


; Symboles des "arrows" et "pages"
; --------------------------------

ICON_SCR_AU_N = 16'2000
ICON_SCR_AU_H = 16'2001
ICON_SCR_PU_N = 16'2002
ICON_SCR_PU_H = 16'2003
ICON_SCR_AD_N = 16'2004
ICON_SCR_AD_H = 16'2005
ICON_SCR_PD_N = 16'2006
ICON_SCR_PD_H = 16'2007
ICON_SCR_AL_N = 16'2008
ICON_SCR_AL_H = 16'2009
ICON_SCR_PL_N = 16'200A
ICON_SCR_PL_H = 16'200B
ICON_SCR_AR_N = 16'200C
ICON_SCR_AR_H = 16'200D
ICON_SCR_PR_N = 16'200E
ICON_SCR_PR_H = 16'200F

ICON_SCR_AU_D = 16'2100
ICON_SCR_PU_D = 16'2102
ICON_SCR_AD_D = 16'2104
ICON_SCR_PD_D = 16'2106
ICON_SCR_AL_D = 16'2108
ICON_SCR_PL_D = 16'210A
ICON_SCR_AR_D = 16'210C
ICON_SCR_PR_D = 16'210E


; En-tte du module LIB
; ---------------------

	.LOC	0

BASE:
	SCROLL_	FIRST			; code du premier appel
	SCROLL_	LAST			; code du dernier appel
	.8	0			; nombre d'installations
	.FILL.8	(OHLREV-APC),0
	.8	REVMAJ,REVMIN		; rvision.version
	.32	END_SCROLL		; longueur
	.32	PATHLIB			; pattern de dbut
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"SCROLL"		; nom du module
	.FILL.8	(LGHLIB-APC),0

	.16	_SCROLL_DRAW
	.16	_SCROLL_UPDATE
	.16	_SCROLL_MOVE
	.16	_SCROLL_PRESS
	.16	_SCROLL_SCALE
	.16	_SCROLL_LDIM
	.16	_SCROLL_LDRAW
	.16	_SCROLL_LUPDATE
	.16	_SCROLL_LMOVE
	.16	_SCROLL_LINVCAS
	.16	_SCROLL_RUPDATE
	.16	_SCROLL_RMOUSE




; Codes des appels
; ----------------


;-------------\\
; _SCROLL_MOVE >
;=============/

; Dplace l'ascenseur jusqu' ce qu'un bouton soit press ou relch.
; Si la souris n'est pas dans la cage de l'ascenseur, on revient tout
; de suite avec une erreur (D7=ERDIOUT).
; (m) = peut tre modifi

; in	D4.32		position de la souris
;	A5.32		^variables de l'ascenseur
;	{A5}+OSCDEB.32	coin sup/gauche
;	{A5}+OSCHTR.16	hauteur relle
;	{A5}+OSCHOR.8	T => horizontal et F => vertical
;	{A5}+OSCPAGE.8	T => avance par pages possible
;	{A5}+OSCMARK.8	T => marqueur dans la cabine
;	{A5}+OSCHTV.16	hauteur virtuelle (m)
;	{A5}+OSCPOSV.16	position virtuelle (m)
;	{A5}+OSCINC.16	incrment si flche (m)
; out	D3.16		touche presse ou bouton press/relch
;	D4.16		SCROLL(F/P)(UP/DOWN)
;	{A5}+OSCPOSV.16	nouvelle position virtulle
;	{A5}+OSCPOSR.16	nouvelle position relle
;	D7.16		erreur (souris pas dans l'ascenseur)
; mod	D3.32, D4.32, D7.16

_SCROLL_MOVE:
	PUSHM.32 D0..D2|D6

	LIB	?COLORPUSH

	TEST.8	{A5}+OSCHOR
	JUMP,F	R8^L05$
	SWAP.32	D4			; X <--> Y

L05$:	MOVE.16	#ERDIOUT,D7		; D7 <-- souris pas dans l'ascenseur
	MOVE.32	{A5}+OSCDEB,D3		; D3 <-- position coin sup/gauche
	COMP.16	D3,D4			; souris trop  gauche ?
	JUMP,LT	L90$			; oui => 90$
	ADD.16	#LGSCROLL,D3
	COMP.16	D3,D4			; souris trop  droite ?
	JUMP,GE	L90$			; oui => 90$

	SWAP.32	D3
	SWAP.32	D4
	TEST.8	{A5}+OSCPAGE
	JUMP,T	R8^L10$
	COMP.16	D3,D4			; souris trop haute ?
	JUMP,LT	L90$			; oui => 90$
	ADD.16	#LGSCROLL,D3
	COMP.16	D3,D4			; souris dans la flche suprieure ?
	JUMP,LT	L25$			; oui => 25$
	ADD.16	{A5}+OSCHTR,D3
	SUB.16	#LGSCROLL*2,D3
	COMP.16	D3,D4			; souris dans l'ascenseur ?
	JUMP,LT	L40$			; oui => 40$
	ADD.16	#LGSCROLL,D3
	COMP.16	D3,D4			; souris dans la flche infrieure ?
	JUMP,LT	R8^L20$			; oui => 20$
	JUMP	L90$

L10$:	COMP.16	D3,D4			; souris trop haute ?
	JUMP,LT	L90$			; oui => 90$
	ADD.16	#LGSCROLL,D3
	COMP.16	D3,D4			; souris dans la flche suprieure ?
	JUMP,LT	R8^L25$			; oui => 25$
	ADD.16	#LGSCROLL,D3
	COMP.16	D3,D4			; souris dans la page suprieure ?
	JUMP,LT	R8^L17$			; oui => 17$
	ADD.16	{A5}+OSCHTR,D3
	SUB.16	#LGSCROLL*4,D3
	COMP.16	D3,D4			; souris dans l'ascenseur ?
	JUMP,LT	R8^L40$			; oui => 40$
	ADD.16	#LGSCROLL,D3
	COMP.16	D3,D4			; souris dans la page infrieure ?
	JUMP,LT	R8^L15$			; oui => 15$
	ADD.16	#LGSCROLL,D3
	COMP.16	D3,D4			; souris dans la flche infrieure ?
	JUMP,LT	R8^L20$			; oui => 20$
	JUMP	L90$

L15$:					; page infrieure =>
	MOVE.16	#SCROLLPDOWN,D4
	JUMP	L85$

L17$:					; page suprieure =>
	MOVE.16	#SCROLLPUP,D4
	JUMP	L85$

L20$:					; flche infrieure =>
	MOVE.16	#SCROLLFDOWN,D4
	MOVE.16	{A5}+OSCPOSV,D2
	ADD.16	{A5}+OSCINC,D2
	MOVE.16	{A5}+OSCHTV,D3
	COMP.16	D3,D2			; est-on trop bas ?
	JUMP,LT	R8^L30$			; non => 30$
	MOVE.16	D3,D2
	DEC.16	D2
	JUMP	R8^L30$

L25$:					; flche suprieure =>
	MOVE.16	#SCROLLFUP,D4
	MOVE.16	{A5}+OSCPOSV,D2
	SUB.16	{A5}+OSCINC,D2
	JUMP,GE	R8^L30$			; est-on trop haut, non => 30$
	CLR.16	D2
L30$:
	MOVE.16	D2,{A5}+OSCPOSV
	CALL	_SCROLL_UPDATE		; dessine l'ascenseur  la nouvelle position
	JUMP	L85$

; La souris se trouve dans l'ascenceur. Il faut voir si la cabine
; doit "sauter"  la nouvelle position ou si l'utilisateur  vis
; dans la cabine affiche.

L40$:	LIB	?COLORPUSH		; sauve les couleurs

	LIB	?AFTIM
	.8	NOCURS			; supprime le curseur
	.8	AFCCMO			; supprime la flche de la souris
	.8	0
	.EVEN

; D4.16 contient la coordonne par rapport  l'ascenceur.

	MOVE.16	{A5}+OSCHTC,D6
	SR.16	#1,D6			; offset = demi hauteur de cabine

	MOVE.16	D4,D0
	SUB.16	{A5}+OSCDEB,D0
	SUB.16	#LGSCROLL,D0
	JUMP,LE	R8^JUMP$
	TEST.8	{A5}+OSCPAGE
	JUMP,F	R8^NOP$
	SUB.16	#LGSCROLL,D0
	JUMP,LE	R8^JUMP$

NOP$:	COMP.16	{A5}+OSCPOSR,D0		; cliqu en-dessous de la cabine ?
	JUMP,LT	R8^JUMP$		; oui => sautes-y !

	SUB.16	{A5}+OSCPOSR,D0		; offset par rapport au dbut de la cabine
	COMP.16	{A5}+OSCHTC,D0		; cliqu en-dessus de la cabine ?
	JUMP,GT	R8^JUMP$		; oui => sautes-y !

;;	SUB.16	{A5}+OSCHTC,D0
	MOVE.16	D0,D6			; utilise offset par rapport  la cabine

JUMP$:	SUB.16	D6,D4
	MOVE.16	D4,D0			; D0 <-- position Y initiale
	MOVE.16	#1,D1			; D1 <-- dessine
	CALL	MOVEASCENSEUR		; dessine le premier ascenseur

L50$:	LIB	?GETKEY			; attend souris/clavier ...
	TEST.32	D3:#BKPSEUDO		; touche relache ?
	JUMP,BS	L50$			; oui => 50$
	COMP.16	#KEYMPO,D3		; souris dplace ?
	JUMP,NE	R8^L60$			; non => 60$
					; oui =>
	CALL	IFMOUSE			; D4 <-- position de la souris
	JUMP,NE	R8^L50$

	SWAP.32	D4
	SUB.16	D6,D4
	COMP.16	D0,D4			; mme position verticale ?
	JUMP,EQ	L50$			; oui => 50$
					; non =>
	CLR.16	D1			; D1 <-- efface
	CALL	MOVEASCENSEUR		; efface l'ancien ascenseur
	MOVE.16	D4,D0
	MOVE.16	#1,D1			; D1 <-- dessine
	CALL	MOVEASCENSEUR		; dessine le nouveau ascenseur
	JUMP	L50$

L60$:
	CLR.16	D1			; D1 <-- efface
	CALL	MOVEASCENSEUR		; efface l'ancien ascenseur

	SUB.16	{A5}+OSCDEBO,D0
	SUB.16	#LGSCROLL,D0
	TEST.8	{A5}+OSCPAGE
	JUMP,F	R8^L70$
	SUB.16	#LGSCROLL,D0
L70$:
	MOVE.16	D0,{A5}+OSCPOSR
	CALL	CALPOSV			; OSCPOSV <-- position virtuelle
	CALL	_SCROLL_UPDATE		; dessine le nouvel ascenseur dfinitif

	LIB	?AFTIM
	.8	AFSCMO			; remet la flche de la souris
	.8	0
	.EVEN

	LIB	?COLORPOP		; restitue les couleurs

	CLR.16	D4			; D4 <-- flche/page sup/inf
L85$:
	CLR.16	D7			; D7 <-- ok

L90$:	PUSH.16	D7
	LIB	?COLORPOP
	LIB	?FLUSH
	POP.16	D7

	POPM.32	D0..D2|D6
	TEST.16	D7			; retour EQ/NE
	RET


;--------------\\
; _SCROLL_PRESS >
;==============/

; Inverse un bouton (flche/page).

; in	D4.16		bouton press SCROLL(F/P)(UP/DOWN)
;	A5.32		^variables de l'ascenseur
;	{A5}+OSCDEB.32	coin sup/gauche
;	{A5}+OSCHTR.16	hauteur relle
;	{A5}+OSCHOR.8	T => horizontal et F => vertical
;	{A5}+OSCPAGE.8	T => avance par pages possible
; out	-
; mod	D7.16

_SCROLL_PRESS:
	PUSHM.32 D1..D4|A0|A1|A4

	LIB	?COLORPUSH		; sauve les couleurs
	MOVE.32	#COLOR_SCCLEAR,D3
	LIB	?COLORCR		; donne la couleur du fond
	MOVE.32	#COLOR_PPHILI,D3
	LIB	?COLORSR		; donne la couleur des mises en vidence

	MOVE.16	D4,D2			; D2 <-- bouton press

	MOVE.32	#-1,D3			; D3 <-- trame
	MOVE.32	D3,D4			; D4 <-- trame
	LIB	?DRMDEF			; dfinit la trame

	MOVE.32	{A5}+OSCDEB,D3
	SWAP.32	D3
	INC.16	D3
	MOVE.16	#LGSCROLL-2,D4
	COMP.16	#SCROLLFUP,D2
	JUMP,EQ	R8^L20$
	ADD.16	#LGSCROLL-1,D3
	INC.16	D4
	COMP.16	#SCROLLPUP,D2
	JUMP,EQ	R8^L20$
	ADD.16	{A5}+OSCHTR,D3
	SUB.16	#(LGSCROLL*2)-1,D3
	MOVE.16	#LGSCROLL-2,D4
	COMP.16	#SCROLLFDOWN,D2
	JUMP,EQ	R8^L20$
	SUB.16	#LGSCROLL,D3
	INC.16	D4
	COMP.16	#SCROLLPDOWN,D2
	JUMP,NE	EXIT$

L20$:	SWAP.32	D3
	INC.16	D3

; Le code du bouton  inverser est disponible dans D2, sa position
; dans D3...

	CALL	USE3DLOOK		; look 3D ?
	JUMP,NE	R8^OLD$			; non => inverse tout simplement

	COMP.16	#SCROLLPUP,D2
	JUMP,NE	R8^NPUP$

	ADD.32	#16'00010000,D3		; mise  jour de la position

NPUP$:	MOVE.32	#0,D1			; pas press par dfaut
	TNOT.8	{A5}+OSCMARK+1:D2	; inverse le bouton ?
	JUMP,BS	R8^OK$			; non => c'est bon
	INC.32	D1			; oui => dcale d'un dans les icones

OK$:	SL.16	#1,D2			; index dans la table
	ADD.16	R8^TAICO+A16^{D2},D1	; nouvelle icone...
	TEST.8	{A5}+OSCHOR		; ascenceur horizontal ?
	JUMP,EQ	R8^VER$			; non => vertical
	ADD.16	#8,D1			; oui => change d'icone
	SWAP.32	D3

VER$:	MOVE.32	D3,D4			; D4 <-- [y;x]
	DEC.16	D4
	SWAP.32	D4
	DEC.16	D4
	SWAP.32	D4
	MOVE.16	D1,D3			; D3 <-- numro de l'icone
	LIB	?GETPDIS
	MOVE.32	A4,A0
	SUB.A16	#16*4,SP
	MOVE.32	SP,A1
	CALL	BUILDLOOKUP		; calcule la table de "look-up"
	CALL	DRICON3D		; dessine l'icone correspondante
	ADD.A16	#16*4,SP
	JUMP	R8^EXIT$

OLD$:	SWAP.32	D4
	MOVE.16	#LGSCROLL-2,D4

	MOVE.16	#INVDOT,D2		; D2 <-- mode
	CALL	DRTRAME			; inverse le bouton

EXIT$:	LIB	?COLORPOP		; restitue les couleurs
	LIB	?FLUSH
	POPM.32	D1..D4|A0|A1|A4
	CLR.16	D7			; retour EQ
	RET


TAICO:	.16	0
	.16	ICON_SCR_AU_N		; flche vers le haut
	.16	ICON_SCR_AD_N		; flche vers le bas
	.16	ICON_SCR_PU_N		; page vers le haut
	.16	ICON_SCR_PD_N		; page vers le bas


;--------------\\
; MOVEASCENSEUR >
;--------------/

; Dplace l'ascenseur.

; in	D0.16	position Y de la souris
;	D1.16	0 => efface et 1 => dessine
; out	D0.16	position Y possible
; mod	D0.32, D7.16

MOVEASCENSEUR:
	PUSHM.32 D1..D6|A4

	MOVE.16	#LGSCROLL,D6		; D6 <-- hauteur flche
	TEST.8	{A5}+OSCPAGE
	JUMP,F	R8^L05$
	MOVE.16	#LGSCROLL*2,D6		; D6 <-- hauteur flche/page

L05$:	MOVE.16	{A5}+OSCDEBO,D4
	ADD.16	D6,D4
	COMP.16	D4,D0			; souris trop haute ?
	JUMP,GE	R8^L10$			; non => 10$
	MOVE.16	D4,D0			; oui => met en haut au maximum

L10$:	MOVE.16	{A5}+OSCDEBO,D4
	ADD.16	{A5}+OSCHTR,D4
	SUB.16	D6,D4
	SUB.16	{A5}+OSCHTC,D4
	DEC.16	D4
	COMP.16	D4,D0			; souris trop basse ?
	JUMP,LT	R8^L20$			; non => 20$
	MOVE.16	D4,D0			; oui => met en bas au maximum

L20$:	MOVE.16	D0,D3			; D3 <-- dbut Y
	SWAP.32	D3
	MOVE.16	{A5}+OSCDEBL,D3
	INC.16	D3			; D3 <-- dbut X

	MOVE.16	{A5}+OSCHTC,D4		; D4 <-- hauteur de la cabine
	SWAP.32	D4
	MOVE.16	#LGSCROLL-(2+1),D4

	CALL	USE3DLOOK		; utilise le look 3D ?
	JUMP,NE	OLD$			; non => ancienne mode...

	TEST.16	D1			; effacer ?
	JUMP,EQ	EXIT$			; oui => ne dessine rien

; D6.16	offset par rapport au bord suprieur

	CALL	xDRRECT			; dessine la cabine de l'ascenseur

	LIB	?GETPDIS
	PUSH.32	D3
	MOVE.32	#COLOR_PPWHITE,D3
	LIB	?COLORCR
	POP.32	D3

	LIB	?FLUSH

	CLR.32	{A4}+ODFTRA+0
	CLR.32	{A4}+ODFTRA+4		; trame blanche pour remplir la cabine

	PUSHM.32 D3|D4
	ADD.16	#1,D3
	SWAP.32	D3
	ADD.16	#1,D3
	SWAP.32	D3
	SUB.16	#1,D4
	SWAP.32	D4
	SUB.16	#1,D4
	SWAP.32	D4
	MOVE.32	#LOADDOT,D2
	CALL	DRTRAME			; efface l'intrieur de la cabine
	POPM.32	D3|D4

	MOVE.32	#SETDOT,D2
	CALL	DESCABINE		; dessine l'intrieur

	PUSH.32	D4
	PUSH.32	D3

	MOVE.32	#COLOR_SCCLEAR,D3
	LIB	?COLORCR		; donne la couleur du fond
	CALL	DEFTRAME

	MOVE.32	#LOADDOT,D2
	MOVE.16	{A5}+OSCDEBO,D3
	ADD.16	D6,D3			; position [y] du dbut
	MOVE.16	{SP}+0,D4
	SUB.16	D3,D4			; hauteur [dy] en-dessus de la cabine
	JUMP,LE	R8^BOT$			; rien => pas de dessin

	SWAP.32	D3
	MOVE.16	{A5}+OSCDEBL,D3		; D3 <-- [y;x]
	INC.16	D3
	SWAP.32	D4
	MOVE.16	{SP}+6,D4		; D4 <-- [dy;dx]
	INC.16	D4
	CALL	DRTRAME

BOT$:	MOVE.16	{SP}+0,D3
	ADD.16	{A5}+OSCHTC,D3		; position [y] du dbut
	INC.16	D3
	SWAP.32	D3
	MOVE.16	{A5}+OSCDEBL,D3		; D3 <-- [y;x]
	INC.16	D3

	MOVE.16	{A5}+OSCHTR,D4
	ADD.16	{A5}+OSCDEBO,D4
	SUB.16	{A5}+OSCHTC,D4
	SUB.16	{SP}+0,D4
	SUB.16	D6,D4
	SUB.16	#1,D4			; hauteur [dy] en-dessous de la cabine
	SWAP.32	D4
	MOVE.16	{SP}+6,D4		; D4 <-- [dy;dx]
	INC.16	D4
	CALL	DRTRAME

	POP.32	D3
	POP.32	D4

	JUMP	EXIT$

; Dessin ancienne mode...

OLD$:	TEST.16	D1
	JUMP,EQ	R8^L50$

	PUSH.32	D3
	MOVE.32	#COLOR_SCSET,D3
	LIB	?COLORSR		; donne la couleur du dessin
	POP.32	D3
	MOVE.16	#SETDOT,D2
	CALL	xDRRECT			; dessine la cabine de l'ascenseur
	CALL	DESCABINE		; dessine l'intrieur
	JUMP	L90$

L50$:
	MOVE.16	{A5}+OSCPOSR,D5
	ADD.16	{A5}+OSCDEBO,D5
	ADD.16	D6,D5
	SUB.16	D0,D5
	JUMP,NC	R8^L52$
	NEG.16	D5			; D5 <-- |distance|
L52$:
	COMP.16	{A5}+OSCHTC,D5		; chevauchement ?
	JUMP,LS	R8^L60$			; oui => 60$
					; non =>
	INC.16	D4			; largeur <-- +1
	SWAP.32	D4
	INC.16	D4			; hauteur <-- +1
	SWAP.32	D4

	PUSH.32	D3
	MOVE.32	#COLOR_SCCLEAR,D3
	LIB	?COLORCR		; donne la couleur du fond
	CALL	DEFTRAME		; dfinit la trame du fond
	POP.32	D3
	MOVE.16	#CLRDOT,D2
	CALL	DRTRAME			; efface le rectangle
	JUMP	R8^L90$
L60$:
	MOVE.16	{A5}+OSCPOSR,D4
	CALL	MAJASCENSEUR		; re-affiche tout l'ascenseur
L90$:
EXIT$:	POPM.32	D1..D6|A4
	RET


;---------------\\
; _SCROLL_UPDATE >
;===============/

; Met  jour la cabine de l'ascenseur.
; On utilise cet appel lorsque l'ascenseur bouge (OSCPOSV ou OSCHTV
; modifis par un vnement extrieur au module SCROLL).
; Lorsque l'ascenseur bouge avec SCROLL_MOVE, cet appel n'est pas
; ncessaire.
; (m) = peut tre modifi

; in	A5.32		^variables de l'ascenseur
;	{A5}+OSCDEB.32	coin sup/gauche
;	{A5}+OSCHTR.16	hauteur relle
;	{A5}+OSCHOR.8	T => horizontal et F => vertical
;	{A5}+OSCPAGE.8	T => avance par pages possible
;	{A5}+OSCMARK.8	T => marqueur dans la cabine
;	{A5}+OSCHTV.16	hauteur virtuelle (m)
;	{A5}+OSCPOSV.16	position virtuelle (m)
; out	(A5)+OSCPOSR.16	position relle
; mod	D7.16

_SCROLL_UPDATE:
	PUSH.32	D4

	LIB	?COLORPUSH		; sauve les couleurs

	TCLR.8	{A5}+OSCMARK+1:#7	; doit-on redessiner ?
	JUMP,F	R8^OK$

	CALL	SCROLLjustDRAW		; redessine actif

OK$:	CALL	CALPOSR			; OSCPOSR <-- position relle
	MOVE.16	{A5}+OSCPOSR,D4
	CALL	MAJASCENSEUR

	LIB	?COLORPOP		; restitue les couleurs
	LIB	?FLUSH

	POP.32	D4
	CLR.16	D7			; retour EQ
	RET


;-------------\\
; MAJASCENSEUR >
;-------------/

; Met  jour l'affichage de l'ascenseur.

; in	D4.16	position Y
; out	-
; mod	D7.16

MAJASCENSEUR:
	PUSHM.32 D1..D4

	MOVE.32	#COLOR_SCCLEAR,D3
	LIB	?COLORCR		; donne la couleur du fond
	MOVE.32	#COLOR_SCSET,D3
	LIB	?COLORSR		; donne la couleur du dessin

	MOVE.16	D4,{A5}+OSCPOSR

	MOVE.16	#LGSCROLL,D1		; D1 <-- hauteur flche
	TEST.8	{A5}+OSCPAGE
	JUMP,F	R8^L10$
	MOVE.16	#LGSCROLL*2,D1		; D1 <-- hauteur flche/page
L10$:
	CALL	DEFTRAME		; dfinit la trame du fond

	MOVE.32	{A5}+OSCDEB,D3		; D3 <-- position coin sup/gauche
	INC.16	D3
	SWAP.32	D3
	ADD.16	D1,D3
	SWAP.32	D3

	MOVE.16	{A5}+OSCPOSR,D4		; D4 <-- hauteur partie suprieure
	JUMP,LE	R8^L30$
	SWAP.32	D4
	MOVE.16	#LGSCROLL-2,D4		; D4 <-- largeur

	MOVE.16	#LOADDOT,D2		; D2 <-- mode
	CALL	DRTRAME			; dessine la trame
L30$:
	SWAP.32	D3
	ADD.16	{A5}+OSCPOSR,D3
	ADD.16	{A5}+OSCHTC,D3
	SWAP.32	D3

	MOVE.16	{A5}+OSCHTR,D4
	SUB.16	{A5}+OSCPOSR,D4
	SUB.16	D1,D4
	SUB.16	D1,D4
	SUB.16	{A5}+OSCHTC,D4		; D4 <-- hauteur partie infrieure
	JUMP,LE	R8^L50$
	SWAP.32	D4
	MOVE.16	#LGSCROLL-2,D4		; D4 <-- largeur

	MOVE.16	#LOADDOT,D2		; D2 <-- mode
	CALL	DRTRAME			; dessine la trame
L50$:
	MOVE.16	{A5}+OSCPOSR,D3		; D3 <-- dbut Y marqueur
	ADD.16	{A5}+OSCDEBO,D3
	ADD.16	#LGSCROLL,D3
	TEST.8	{A5}+OSCPAGE
	JUMP,F	R8^L60$
	ADD.16	#LGSCROLL,D3
L60$:
	SWAP.32	D3
	MOVE.16	{A5}+OSCDEBL,D3
	INC.16	D3			; D3 <-- dbut X marqueur
	MOVE.16	{A5}+OSCHTC,D4		; D4 <-- hauteur de la cabine
	SWAP.32	D4
	MOVE.16	#LGSCROLL-(2+1),D4
	MOVE.16	#SETDOT,D2
	CALL	xDRRECT			; dessine la cabine de l'ascenseur

	PUSHM.32 D3|D4
	MOVE.32	#COLOR_SCPOS,D3
	LIB	?COLORCR		; donne la couleur de la position
	CLR.32	D3			; D3 <-- trame
	CLR.32	D4			; D4 <-- trame
	LIB	?DRMDEF			; dfinit la trame
	POPM.32	D3|D4

	PUSHM.32 D3|D4
	INC.16	D3
	DEC.16	D4
	SWAP.32	D3
	SWAP.32	D4
	INC.16	D3
	DEC.16	D4
	SWAP.32	D3
	SWAP.32	D4
	MOVE.16	#CLRDOT,D2
	CALL	DRTRAME			; efface l'intrieur
	POPM.32	D3|D4

	MOVE.16	#SETDOT,D2
	CALL	DESCABINE		; dessine l'intrieur de la cabine

	POPM.32	D1..D4
	RET

;---------\\
; DEFTRAME >
;---------/

; Dfinit la trame grise pour les ascenseurs.

; in	-
; out	-
; mod	D7.16

DEFTRAME:
	PUSHM.32 D3|D4|A4

	LIB	?GETPDIS		; A4 <-- ^descripteur
	JUMP,NE	R8^L90$

	MOVE.32	#0,D3			; trame unie si 3D
	CALL	USE3DLOOK		; utilise look 3D ?
	JUMP,EQ	R8^L40$			; oui => ok

	MOVE.32	#16'55AA55AA,D3		; D3 <-- trame
	TEST.8	{A4}+ODFMOD:#BFBLANC	; cran  fond blanc ?
	JUMP,BC	R8^L40$			; non => 40$
	MOVE.32	#16'00110044,D3		; D3 <-- trame plus claire
L40$:
	MOVE.32	D3,D4			; D4 <-- trame
	LIB	?DRMDEF			; dfinit la trame du fond
L90$:
	POPM.32	D3|D4|A4
	RET


;-------------\\
; _SCROLL_DRAW >
;=============/

; Dessine la cage de l'ascenseur vide, avec les flches suprieure
; et infrieure, et ventuellement les pages.
; L'cran sous la cage de l'ascenseur est effac automatiquement.

; in	A5.32		^variables de l'ascenseur
;	{A5}+OSCDEB.32	coin sup/gauche
;	{A5}+OSCHTR.16	hauteur relle
;	{A5}+OSCHOR.8	T => horizontal et F => vertical
;	{A5}+OSCPAGE.8	T => avance par pages possible
; out	-
; mod	D7.16

_SCROLL_DRAW:
	PUSHM.32 D2..D4|A3

	MOVE.8	#2**7,{A5}+OSCMARK+1	; plus de boutons presss, boutons inactifs

	LIB	?COLORPUSH		; sauve les couleurs
	MOVE.32	#COLOR_PPLGREY,D3
	LIB	?COLORCR		; donne la couleur du fond
	MOVE.32	#COLOR_SCSET,D3
	LIB	?COLORSR		; donne la couleur du dessin

	CLR.32	D3			; D3 <-- trame
	CLR.32	D4			; D4 <-- trame
	LIB	?DRMDEF			; dfinit la trame

	MOVE.32	{A5}+OSCDEB,D3		; D3 <-- position coin sup/gauche
	MOVE.16	{A5}+OSCHTR,D4		; D4 <-- hauteur
	DEC.16	D4
	SWAP.32	D4
	MOVE.16	#LGSCROLL-1,D4		; D4 <-- largeur
	MOVE.32	#CLRDOT,D2
	CALL	DRTRAME			; efface l'intrieur
	MOVE.32	#SETDOT,D2		; D2 <-- mode
	CALL	DRRECT			; met un rectangle autour

; Dessine encore une cabine norme, au cas o on a le nouveau look...

	CALL	SCROLLjustDRAW		; dessine les boutons...

	CALL	USE3DLOOK
	JUMP,NE	R8^OLD$

	ADD.16	#1,D3
	SUB.16	#2,D4
	SWAP.32	D3
	SWAP.32	D4
	ADD.16	#1*LGSCROLL,D3
	SUB.16	#2*LGSCROLL,D4

	TEST.8	{A5}+OSCPAGE
	JUMP,F	R8^NOP$

	ADD.16	#1+1*LGSCROLL-1,D3
	SUB.16	#2+2*LGSCROLL-2,D4

NOP$:	SWAP.32	D3
	SWAP.32	D4
	CALL	xDRRECT			; cabine prenant tout l'ascenceur

OLD$:	MOVE.16	#LGSCROLL,{A5}+OSCHTC	; une cabine normale
	MOVE.16	#(LGSCROLL*3)+2,D4
	TEST.8	{A5}+OSCPAGE
	JUMP,F	R8^L70$
	ADD.16	#LGSCROLL*2,D4
L70$:
	COMP.16	{A5}+OSCHTR,D4
	JUMP,LT	R8^L90$
	MOVE.16	#4,{A5}+OSCHTC		; une cabine minuscule
L90$:
	LIB	?COLORPOP		; restitue les couleurs
	LIB	?FLUSH

	POPM.32	D2..D4|A3
	CLR.16	D7			; retour EQ
	RET


; Dessine les divers boutons et traits de sparation.

SCROLLjustDRAW:
	PUSHM.32 D2..D4|A3

	MOVE.32	#SETDOT,D2
	MOVE.32	#COLOR_SCOBJ,D3
	LIB	?COLORSR		; donne la couleur des objets
	MOVE.32	{A5}+OSCDEB,D3		; D3 <-- position coin sup/gauche
	MOVE.32	#R16^TAFLUP,A3
	CALL	DESMOTIF		; dessine la flche suprieure

	PUSH.32	D3
	MOVE.32	#COLOR_SCSET,D3
	LIB	?COLORSR		; donne la couleur du dessin
	POP.32	D3
	SWAP.32	D3
	ADD.16	#LGSCROLL-1,D3
	SWAP.32	D3
	CLR.32	D4
	MOVE.16	#LGSCROLL,D4
	PUSH.32	D3
	CALL	DRSEG
	POP.32	D3

	TEST.8	{A5}+OSCPAGE
	JUMP,F	R8^L40$

	PUSH.32	D3
	MOVE.32	#COLOR_SCOBJ,D3
	LIB	?COLORSR		; donne la couleur des objets
	POP.32	D3
	SWAP.32	D3
	INC.16	D3
	SWAP.32	D3
	MOVE.32	#R16^TAPGUP,A3
	CALL	DESMOTIF		; dessine la page suprieure

	PUSH.32	D3
	MOVE.32	#COLOR_SCSET,D3
	LIB	?COLORSR		; donne la couleur du dessin
	POP.32	D3
	SWAP.32	D3
	ADD.16	#LGSCROLL-1,D3
	SWAP.32	D3
	CLR.32	D4
	MOVE.16	#LGSCROLL,D4
	CALL	DRSEG

L40$:	MOVE.32	#COLOR_SCOBJ,D3
	LIB	?COLORSR		; donne la couleur des objets
	MOVE.32	{A5}+OSCDEB,D3		; D3 <-- position coin sup/gauche
	SWAP.32	D3
	ADD.16	{A5}+OSCHTR,D3		; D3 <-- position coin inf/gauche
	DEC.16	D3
	SWAP.32	D3
	MOVE.32	#R16^TAFLDOWN,A3
	CALL	DESMOTIF		; dessine la flche infrieure

	PUSH.32	D3
	MOVE.32	#COLOR_SCSET,D3
	LIB	?COLORSR		; donne la couleur du dessin
	POP.32	D3
	SWAP.32	D3
	SUB.16	#LGSCROLL-1,D3
	SWAP.32	D3
	PUSH.32	D3
	CALL	DRSEG
	POP.32	D3

	TEST.8	{A5}+OSCPAGE
	JUMP,F	R8^L60$

	PUSH.32	D3
	MOVE.32	#COLOR_SCOBJ,D3
	LIB	?COLORSR		; donne la couleur des objets
	POP.32	D3
	SWAP.32	D3
	DEC.16	D3
	SWAP.32	D3
	MOVE.32	#R16^TAPGDOWN,A3
	CALL	DESMOTIF		; dessine la page infrieure

	PUSH.32	D3
	MOVE.32	#COLOR_SCSET,D3
	LIB	?COLORSR		; donne la couleur du dessin
	POP.32	D3
	SWAP.32	D3
	SUB.16	#LGSCROLL-1,D3
	SWAP.32	D3
	CLR.32	D4
	MOVE.16	#LGSCROLL,D4
	CALL	DRSEG

L60$:	POPM.32 D2..D4|A3
	RET


;--------------\\
; _SCROLL_SCALE >
;==============/

; Dessine  droite ou en bas d'un ascenseur une chelle gradue.

; in	A5.32		^variables de l'ascenseur
;	{A5}+OSCDEB.32	coin sup/gauche
;	{A5}+OSCHTR.16	hauteur relle
;	{A5}+OSCHOR.8	T => horizontal et F => vertical
;	{A5}+OSCPAGE.8	T => avance par pages possible
;	D3.16		nombre de divisions (2..n)
;	D4.16		longueur des divisions (1..n)
;	A3.32		^liste des textes/^nil
;			 n .ASCIZ  la suite (n=D3+1)
;			 seulement si ascenseur vertical !
;	A0.32		^description de la fentre
; out	-
; mod	D7.16

_SCROLL_SCALE:
	PUSHM.32 D0..D5|A3

	MOVE.16	D3,D2
	LIB	?COLORPUSH		; sauve les couleurs
	MOVE.32	#COLOR_SCSCALE,D3
	LIB	?COLORSR		; donne la couleur des graduations
	MOVE.16	D2,D3

	MOVE.16	{A5}+OSCHTR,D0
	SUB.16	{A5}+OSCHTC,D0
	SUB.16	#LGSCROLL*2,D0		; D0 <-- hauteur de l'ascenseur
	TEST.8	{A5}+OSCPAGE
	JUMP,F	R8^L10$
	SUB.16	#LGSCROLL*2,D0
L10$:
	CLR.16	D1			; D1 <-- rang de la barette

	AND.32	#16'FFFF,D4		; D4 <-- dimensions (dy;dx)

	MOVE.16	D3,D5			; D5 <-- nb de divisions
L40$:
	MOVE.16	D0,D3
	MUL.16	D1,D3
	DIV.16	D5,D3
	ADD.16	{A5}+OSCDEBO,D3
	ADD.16	#LGSCROLL+LGSCROLL/2,D3
	TEST.8	{A5}+OSCPAGE
	JUMP,F	R8^L45$
	ADD.16	#LGSCROLL,D3
L45$:
	SWAP.32	D3
	MOVE.16	{A5}+OSCDEBL,D3
	ADD.16	#LGSCROLL,D3
	MOVE.16	#SETDOT,D2		; D2 <-- mode de dessin
	CALL	DRSEG			; dessine une barette

	MOVE.32	A3,D2			; liste de textes existe ?
	JUMP,EQ	R8^L60$			; non => 60$
	INC.16	D3			; D3 <-- <xx>
	SWAP.32	D3
	MOVE.16	{A0}+ODFC1Y,D2		; D2 <-- hauteur d'une lettre
	SR.16	#1,D2			; D2 <-- demi-hauteur
	ADD.16	D2,D3			; D3 <-- <yy>
	SWAP.32	D3
	LIB	?SETCURS		; positionne le curseur
	LIB	?AFTEXT			; affiche un texte
L60$:
	INC.16	D1			; D1 <-- rang suivant
	COMP.16	D5,D1
	JUMP,LS	L40$

	LIB	?COLORPOP		; restitue les couleurs
	LIB	?FLUSH

	POPM.32	D0..D5|A3
	CLR.16	D7			; retour EQ
	RET


;----------\\
; DESCABINE >
;----------/

; Dessine la cabine de l'ascenseur.

; in	D3.32	position (y;x)
;	D4.32	dimensions (y;x)
;	D2.16	mode de dessin
; out	-
; mod	D7.16

DESCABINE:
	PUSH.32	A3

	TEST.8	{A5}+OSCMARK		; marqueur dans la cabine ?
	JUMP,F	R8^L90$			; non => 90$
					; oui =>
	PUSH.32	D3
	MOVE.32	#COLOR_SCSCALE,D3
	LIB	?COLORSR		; donne la couleur des graduations
	POP.32	D3

	MOVE.32	#R16^TAMARK,A3
	CALL	DESMOTIF		; met marqueur dans la cabine
L90$:
	POP.32	A3
	RET


;---------\\
; DESMOTIF >
;---------/

; Dessine un motif constitu de lignes droites.

; in	D3.32	coordonne initiale
;	D2.16	mode
;	A3.32	^table (dy;dx)
; out	-
; mod	D7.16

DESMOTIF:
	PUSHM.32 D3|D4|A3

	CALL	USE3DLOOK
	JUMP,NE	R8^OLD$

	TEST.16	{A3}			; y a-t-il une icone ?
	JUMP,EQ	R8^OLD$			; non => dessin normal

	MOVE.32	D3,D4			; D4 <-- [y;x]
	MOVE.16	{A3+},D3		; D3 <-- numro de l'icone
	SWAP.32	D4
	ADD.16	{A3+},D4		; corrige la position
	SWAP.32	D4

	TEST.8	{A5}+OSCHOR		; ascenceur horizontal ?
	JUMP,EQ	R8^VER$			; non => vertical
	ADD.16	#8,D3			; oui => change d'icone
	SWAP.32	D4			;        permute les coordonnes

VER$:	PUSHM.32 A0|A1|A4

	LIB	?GETPDIS
	MOVE.32	A4,A0
	SUB.A16	#16*4,SP
	MOVE.32	SP,A1
	CALL	BUILDLOOKUP		; calcule la table de "look-up"
	CALL	DRICON3D		; dessine l'icone correspondante
	ADD.A16	#16*4,SP

	POPM.32	A0|A1|A4
	JUMP	R8^EXIT$

OLD$:	ADD.A16	#4,A3			; saute l'icone (raster)

	SWAP.32	D3
	ADD.16	{A3+},D3		; saute au dpart
	SWAP.32	D3
	ADD.16	{A3+},D3

L10$:	MOVE.32	{A3+},D4
	JUMP,EQ	R8^EXIT$
	CALL	DRSEG
	JUMP	L10$

EXIT$:	POPM.32	D3|D4|A3
	RET


TAFLUP:					; flche suprieure
	.16	ICON_SCR_AU_N,0
	.16	2,7
	.16	6,-6
	.16	0,3
	.16	4,0
	.16	0,6
	.16	-4,0
	.16	0,3
	.16	-6,-6
	.16	0,0

TAFLDOWN:				; flche infrieure
	.16	ICON_SCR_AD_N,-LGSCROLL+1
	.16	-2,7
	.16	-6,-6
	.16	0,3
	.16	-4,0
	.16	0,6
	.16	4,0
	.16	0,3
	.16	6,-6
	.16	0,0

TAPGUP:					; page suprieure
	.16	ICON_SCR_PU_N,0
	.16	5,3
	.16	0,4
	.16	-4,0
	.16	4,-4
	.16	8,0
	.16	0,9
	.16	-12,0
	.16	0,-5
	.16	0,0

TAPGDOWN:				; page infrieure
	.16	ICON_SCR_PD_N,-LGSCROLL+1
	.16	-5,3
	.16	0,4
	.16	4,0
	.16	-4,-4
	.16	-8,0
	.16	0,9
	.16	12,0
	.16	0,-5
	.16	0,0

TAMARK:					; marque dans la cabine
	.16	0,0			; pas d'icone
	.16	8,11
	.16	0,-9
	.16	0,9
	.16	-3,-3
	.16	3,3
	.16	4,-4
	.16	0,0



;--------\\
; CALPOSV >
;--------/

; Calcul la position virtuelle en fonction de la position relle.

; in	-
; out	-
; mod	-

CALPOSV:
	PUSHM.32 D2..D4

	MOVE.16	{A5}+OSCHTR,D3
	SUB.16	{A5}+OSCHTC,D3
	SUB.16	#LGSCROLL*2,D3
	TEST.8	{A5}+OSCPAGE
	JUMP,F	R8^L20$
	SUB.16	#LGSCROLL*2,D3
L20$:
	MOVE.16	{A5}+OSCPOSR,D4
	INC.16	D4
	COMP.16	D3,D4			; est-on tout en bas ?
	JUMP,EQ	R8^L50$			; oui => 50$
				; non =>
	TEST.16	D3
	JUMP,EQ	R8^L40$
	DEC.16	D4
	MOVE.16	{A5}+OSCHTV,D2
	DEC.16	D2
	MUL.16	D2,D4
	CLR.32	D2
	MOVE.16	D3,D2
	SR.16	#1,D2
	ADD.32	D2,D4
	DIV.16	D3,D4
	JUMP	R8^L80$

L40$:
	CLR.16	D4			; D4 <-- met le minimum
	JUMP	R8^L80$
L50$:
	MOVE.16	{A5}+OSCHTV,D4
	DEC.16	D4			; D4 <-- met le maximum
L80$:
	MOVE.16	D4,{A5}+OSCPOSV

	POPM.32	D2..D4
	RET


;--------\\
; CALPOSR >
;--------/

; Calcul la position relle en fonction de la position virtuelle.

; in	-
; out	-
; mod	-

CALPOSR:
	PUSHM.32 D2..D4

	MOVE.16	{A5}+OSCHTR,D3
	SUB.16	{A5}+OSCHTC,D3
	SUB.16	#LGSCROLL*2,D3
	TEST.8	{A5}+OSCPAGE
	JUMP,F	R8^L20$
	SUB.16	#LGSCROLL*2,D3
L20$:
	MOVE.16	{A5}+OSCPOSV,D4
	MUL.16	D3,D4
	MOVE.16	{A5}+OSCHTV,D2
	DEC.16	D2
	JUMP,EQ	R8^L30$
	DIV.16	D2,D4
	COMP.16	D3,D4			; dpasse la fin ?
	JUMP,LT	R8^L40$			; non => 40$
	MOVE.16	D3,D4			; oui => ne va pas plus loin
	DEC.16	D4
	JUMP	R8^L40$
L30$:
	CLR.16	D4			; D4 <-- met le minimum
L40$:
	MOVE.16	D4,{A5}+OSCPOSR

	POPM.32	D2..D4
	RET



;--------\\
; IFMOUSE >
;--------/

IFMOUSE:
	PUSH.32	D5

	LIB	?GETWDO
	MOVE.32	D3,D5			; D5 <-- origine swdo
	LIB	?IFMOUSE		; D3 <-- boutons et D4 <-- position
	MOVE.16	#ERDIOUT,D7
	SUB.16	D5,D4			; D4 <-- origine en X dans swdo
	JUMP,LT	R8^L90$
	SWAP.32	D4
	SWAP.32	D5
	SUB.16	D5,D4			; D4 <-- origine en Y dans swdo
	JUMP,LT	R8^L90$
	SWAP.32	D4
;	SWAP.32	D5
	CLR.16	D7

	TEST.8	{A5}+OSCHOR
	JUMP,F	R8^L90$
	SWAP.32	D4			; X <--> Y
L90$:
	POP.32	D5
	TEST.16	D7
	RET

;-------\\
; DRRECT >
;-------/

DRRECT:
	TEST.8	{A5}+OSCHOR
	JUMP,T	R8^L50$
	LIB	?DRRECT
	RET
L50$:
	SWAP.32	D3			; X <--> Y
	SWAP.32	D4			; dX <-- dY
	LIB	?DRRECT
	SWAP.32	D4			; dX <-- dY
	SWAP.32	D3			; X <--> Y
	RET


;--------\\
; xDRRECT >
;--------/

; Comme DRRECT, mais si possible, dessine les choses en
; relief.

xDRRECT:
	CALL	USE3DLOOK		; utilise le nouveau look ?
	JUMP,NE	DRRECT			; non => routine banale

	TEST.8	{A5}+OSCHOR
	JUMP,T	R8^HOR$

DRAW$:	PUSHM.32 A0|A1|A4
	LIB	?GETPDIS
	MOVE.32	A4,A0
	SUB.A16	#16*4,SP
	MOVE.32	SP,A1
	CALL	BUILDLOOKUP
	CALL	DRRECT3D
	ADD.A16	#16*4,SP
	POPM.32	A0|A1|A4
	RET

HOR$:	SWAP.32	D3			; X <--> Y
	SWAP.32	D4			; dX <-- dY
	CALL	DRAW$
	SWAP.32	D4			; dX <-- dY
	SWAP.32	D3			; X <--> Y
	RET


;--------\\
; DRTRAME >
;--------/

DRTRAME:
	TEST.8	{A5}+OSCHOR
	JUMP,T	R8^L50$
	LIB	?DRTRAME
	RET
L50$:
	SWAP.32	D3			; X <--> Y
	SWAP.32	D4			; dX <-- dY
	LIB	?DRTRAME
	SWAP.32	D4			; dX <-- dY
	SWAP.32	D3			; X <--> Y
	RET

;------\\
; DRSEG >
;------/

DRSEG:
	TEST.8	{A5}+OSCHOR
	JUMP,T	R8^L50$
	LIB	?DRSEG
	RET
L50$:
	SWAP.32	D3			; X <--> Y
	SWAP.32	D4			; dX <-- dY
	LIB	?DRSEG
	SWAP.32	D4			; dX <-- dY
	SWAP.32	D3			; X <--> Y
	RET


;------------\\
; BUILDLOOKUP >
;------------/

; Cre la table de "look-up" des couleurs pour du 4 bpp.

; in	A1.32	^table  remplir 16 x .32
;	A0.32	^descripteur de fentre
; out	{A1}++
; mod	D7.16

BUILDLOOKUP:
	PUSH.32	D3
	LIB	?FLUSH
	PUSH.32	{A0}+ODFCSF

	MOVE.32	#COLOR_PPWHITE,D3
	LIB	?COLORSR
	LIB	?FLUSH
	MOVE.32	{A0}+ODFCSF,D3

	PUSHM.32 D1|A1
	MOVE.32	#12-1,D1
LOOP$:	MOVE.32	D3,{A1+}
	DJ.16,NMO D1,LOOP$
	POPM.32	D1|A1

	MOVE.32	#COLOR_PPLGREY,D3
	LIB	?COLORSR
	LIB	?FLUSH
	MOVE.32	{A0}+ODFCSF,{A1}+12*4	; cherche gris clair

	MOVE.32	#COLOR_PPMGREY,D3
	LIB	?COLORSR
	LIB	?FLUSH
	MOVE.32	{A0}+ODFCSF,{A1}+13*4	; cherche gris moyen

	MOVE.32	#COLOR_PPDGREY,D3
	LIB	?COLORSR
	LIB	?FLUSH
	MOVE.32	{A0}+ODFCSF,{A1}+14*4	; cherche gris fonc

	MOVE.32	#COLOR_PPBLACK,D3
	LIB	?COLORSR
	LIB	?FLUSH
	MOVE.32	{A0}+ODFCSF,{A1}+15*4	; cherche noir

	POP.32	{A0}+ODFCSF
	POP.32	D3
	RET



;---------\\
; DRICON3D >
;---------/

; Dessine une icone en 3D, si cela est possible avec les gris
; actuels.

; in	D3.16	numro de l'icone
;	D4.32	[y;x] o l'afficher
;	A0.32	^descripteur de fentre
;	A1.32	^table .32 de look-up
; out	D7.16	ok/pas ok
; mod	D7.16

DRICON3D:
	PUSHM.32 D0..D6|A0..A5|A6

	CALL	qGETMEM			; A6 <-- ^mmoire (pour icone 16 x 16)
	JUMP,NE	RET$

	TEST.32	D3:#0			; icone "active" ?
	JUMP,T	R8^ACT$			; oui => ok

	TEST.8	{A5}+OSCMARK+1:#7	; icone "grise" ?
	JUMP,F	R8^ACT$			; non => ok

	ADD.16	#16'0100,D3		; choisit l'icone grise

ACT$:	MOVE.32	A0,A2			; A2 <-- ^descripteur de fentre

	MOVE.16	#2**BDBEXTEND,D2
	MOVE.16	#DBOX_GETDBICON,D1
	DBOX_	EXTEND			; cherche ^sur l'icone
	JUMP,NE	EXIT$			; erreur => laisse tomber

	MOVE.16	#1,D7

	COMP.32	#16'00100010,D2		; taille correcte (16 x 16) ?
	JUMP,NE	EXIT$			; non => laisse tomber
	COMP.16	#4,D1			; profondeur correcte ?
	JUMP,NE	EXIT$			; non => laisse tomber

; Convertit l'icone en couleurs correctes.

	MOVE.16	D3,D0
	MUL.16	D1,D0
	SR.16	#3,D0			; offset dbut horizontal en bytes

	SWAP.32	D3
	MUL.16	D5,D3			; offset dbut de ligne en bytes

	ADD.A16	D0,A3
	ADD.A16	D3,A3			; A3 <-- ^premier pixel

	MOVE.32	#0,D0
	MOVE.8	{A2}+ODFCNP,D0		; D0 <-- bpp
	ADD.32	D0,D0			; D0 <-- bpp * 2 (index dans table)

	MOVE.32	#R16^TABLE$,A4
	ADD.A16	{A4}+A16^{D0},A4	; A4 <-- ^routine  appeler

	MOVE.16	D5,D6			; largeur en bytes totale
	SUB.16	#16/2,D6		; largeur en bytes corrige (source)
	MOVE.32	#16-1,D0		; traduit les pixels par ligne (16 lignes)
	MOVE.32	A6,A0			; buffer de rception

TRAD$:	CALL	TWOPIXELS$		; pixels d'une ligne...
	CALL	TWOPIXELS$
	CALL	TWOPIXELS$
	CALL	TWOPIXELS$
	CALL	TWOPIXELS$
	CALL	TWOPIXELS$
	CALL	TWOPIXELS$
	CALL	TWOPIXELS$
	ADD.A16	D6,A3			; passe  la ligne suivante

	DJ.16,NMO D0,TRAD$		; traduit toute l'icone

; Maintenant, on peut dessiner l'icone !

	MOVE.32	A6,A3			; A3 <-- ^source
	MOVE.32	#0,D3			; D3 <-- offset [y;x] source
	MOVE.32	#16'00100010,D2		; D2 <-- dimensions [dy;dx]
	SUB.32	A4,A4			; A4 <-- destination  l'cran

	PUSH.8	{A2}+ODFFLG		; sauve tat de la souris

	LIB	?AFTIM			; efface le lutin souris (anciennes machines)
	.8	AFCCMO,0
	.EVEN
	LIB	?FLUSH

	MOVE.16	#LOADDOT.OR.2**BSRCCOUL.OR.2**BDSTCOUL,D1
	GRA2_	CRASTER			; affiche l'image en couleurs
	CLR.16	D7

	POP.8	{A2}+ODFFLG		; remet l'tat de la souris d'avant...

EXIT$:	CALL	qGIVMEM
RET$:	POPM.32	D0..D6|A0..A5|A6
	TEST.16	D7
	RET

; Traduit 2 pixels d'un coup...

TWOPIXELS$:
	MOVE.32	#0,D1
	MOVE.32	#0,D2
	MOVE.8	{A3+},D1		; D1 <-- 2 pixels
	MOVE.8	D1,D2
	SR.8	#4,D1			; D1 <-- [pixel left]
	AND.8	#16'0F,D2		; D2 <-- [pixel right]
	SL.32	#.LOG2.4,D1
	SL.32	#.LOG2.4,D2
	MOVE.32	{A1}+A16^{D1},D1	; look-up de la couleur
	MOVE.32	{A1}+A16^{D2},D2	; look-up de la couleur
	JUMP	{A4}

TABLE$:	.16	BPP0$-TABLE$
	.16	BPP1$-TABLE$		; 1 bpp
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP4$-TABLE$		; 4 bpp
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP8$-TABLE$		; 8 bpp
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP16$-TABLE$		; 15 bpp
	.16	BPP16$-TABLE$		; 16 bpp
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP32$-TABLE$		; 24 bpp
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP0$-TABLE$
	.16	BPP32$-TABLE$		; 32 bpp

BPP0$:
BPP1$:	MOVE.32	#4,D5			; D5 <-- largeur en bytes
	RET

BPP4$:	SL.8	#4,D1
	OR.8	D2,D1			; D1 <-- 2 pixels mis  jour
	MOVE.8	D1,{A0+}		; stocke
	MOVE.32	#8,D5			; D5 <-- largeur en bytes
	RET

BPP8$:	MOVE.8	D1,{A0+}
	MOVE.8	D2,{A0+}
	MOVE.32	#16,D5			; D5 <-- largeur en bytes
	RET

BPP16$:	MOVE.16	D1,{A0+}
	MOVE.16	D2,{A0+}
	MOVE.32	#32,D5			; D5 <-- largeur en bytes
	RET

BPP32$:	MOVE.32	D1,{A0+}
	MOVE.32	D2,{A0+}
	MOVE.32	#64,D5			; D5 <-- largeur en bytes
	RET



qGETMEM:
	PUSHM.32 D1|D4|A4
	MOVE.32	#MTYPCP,D1
	MOVE.32	#16*16*4,D4
	GESMEM	?GETMEM
	MOVE.32	A4,A6			; A6 <-- ^buffer
	POPM.32	D1|D4|A4
	RET

qGIVMEM:
	PUSH.16	D7
	PUSHM.32 D1|A4
	MOVE.32	A6,A4
	MOVE.32	#MTYPCP,D1
	GESMEM	?GIVMEM
	POPM.32	D1|A4
	POP.16	D7
	RET

;---------\\
; DRRECT3D >
;---------/

; Dessine un rectangle 3D qui "sort".

; in	A0.32	^descripteur de la fentre
;	A1.32	^table .32 de look-up
;	D3.32	[y;x] origine
;	D4.32	[dy;dx] dimensions
; out	-
; mod	D7.16

DRRECT3D:
	PUSHM.32 D0..D2

	MOVE.32	{A1}+0*4,D0			; blanc
	MOVE.32	{A1}+14*4,D1			; gris fonc
	LIB	?FLUSH

	PUSH.32	{A0}+ODFCSF
	PUSH.32	D3
	PUSH.32	D4

	MOVE.32	#SETDOT,D2
	MOVE.32	D0,{A0}+ODFCSF

	MOVE.32	{SP}+4,D3			; D3 <-- [y;x]
	MOVE.32	#0,D4
	MOVE.16	{SP}+2,D4
	INC.16	D4				; D4 <-- [0;dx]
	LIB	?DRSEG

	MOVE.32	{SP}+4,D3			; D3 <-- [y;x]
	MOVE.32	#0,D4
	MOVE.16	{SP}+0,D4
	INC.16	D4
	SWAP.32	D4				; D4 <-- [dy;0]
	LIB	?DRSEG
	LIB	?FLUSH

	MOVE.32	D1,{A0}+ODFCSF

	MOVE.32	{SP}+4,D3
	ADD.32	#16'00010000,D3
	ADD.16	{SP}+2,D3			; D3 <-- [y;x]
	MOVE.32	{SP}+0,D4
	CLR.16	D4				; D4 <-- [dy;0]
	LIB	?DRSEG

	MOVE.32	{SP}+4,D3
	INC.16	D3
	SWAP.32	D3
	ADD.16	{SP}+0,D3
	SWAP.32	D3				; D3 <-- [y;x]
	MOVE.32	#0,D4
	MOVE.16	{SP}+2,D4			; D4 <-- [0;dx]
	LIB	?DRSEG
	LIB	?FLUSH

	POP.32	D4
	POP.32	D3
	POP.32	{A0}+ODFCSF
	POPM.32	D0..D2
	TEST.16	D7
	RET


;----------\\
; USE3DLOOK >
;----------/

; Faut-il utiliser un joli look 3D ?

; in	-
; out	EQ	=> utilise le look 3D
; mod	-

USE3DLOOK:
	PUSHM.32 D1|D2|D3|D7|A0|A1|A4

	LIB	?COLORPUSH		; sauve les couleurs
	LIB	?GETPDIS

	COMP.8	#4,{A4}+ODFCNP
	JUMP,LT	R8^NO$

	MOVE.32	#COLOR_PPWHITE,D3
	LIB	?COLORCR
	MOVE.32	#COLOR_PPBLACK,D3
	LIB	?COLORSR
	LIB	?FLUSH

	MOVE.32	{A4}+ODFCCF,D1		; blanc
	MOVE.32	{A4}+ODFCSF,D2		; noir

; Cherche si le gris clair n'est ni blanc, ni noir.

	MOVE.32	#COLOR_PPLGREY,D3
	LIB	?COLORCR
	LIB	?FLUSH

	MOVE.32	{A4}+ODFCCF,A1		; gris clair

	COMP.32	A1,D1
	JUMP,EQ	R8^NO$
	COMP.32	A1,D2
	JUMP,EQ	R8^NO$

; Mmes recherches avec le gris fonc et le gris moyen

	MOVE.32	#COLOR_PPMGREY,D3
	LIB	?COLORCR
	MOVE.32	#COLOR_PPDGREY,D3
	LIB	?COLORSR
	LIB	?FLUSH

	COMP.32	{A4}+ODFCCF,D1
	JUMP,EQ	R8^NO$
	COMP.32	{A4}+ODFCSF,D1
	JUMP,EQ	R8^NO$
	COMP.32	{A4}+ODFCCF,D2
	JUMP,EQ	R8^NO$
	COMP.32	{A4}+ODFCSF,D2
	JUMP,EQ	R8^NO$
	COMP.32	{A4}+ODFCCF,A1
	JUMP,EQ	R8^NO$
	COMP.32	{A4}+ODFCSF,A1
	JUMP,EQ	R8^NO$

; Si tout colle, demande encore  DBOX si le look moderne a t choisi
; par l'utilisateur.

	MOVE.32	#A8^DBOX_GETLOOK,D1
	MOVE.16	#2**BDBEXTEND,D2
	DBOX_	EXTEND
	JUMP,NE	R8^NO$

	TEST.16	D3			; ancien look ?
	JUMP,NE	R8^YES$			; non => c'est bon

NO$:	MOVE.32	#1,D3			; force NE
	JUMP	R8^EXIT$

YES$:	MOVE.32	#0,D3			; force EQ

EXIT$:	LIB	?COLORPOP
	TEST.32	D3

	POPM.32	D1|D2|D3|D7|A0|A1|A4
	RET

	.INS	SCROLLLIST.ASI
	.INS	SCROLLREGLE.ASI
	.INS	SCROLL09.ASI

 
END_SCROLL:


	.END

