\define g_Fond:\nef11;
\define g_ev:\n(bf)09;
\define g_titre:\m(f)17;
\define g_it:\n(if)07;
\g_Fond;; $sma; $bin:STRETCH

	.TITLE		STRETCH.ASL
;	--------------------------------------
;		(C) 1987 - Francis Klay
;	--------------------------------------
;	--------------------------------------
;		(C) 1991 - Denis Dumoulin
;	--------------------------------------
;	Librairie de transformation lastique.
;
;	LSTRECH		Psos	Nom	Modifications
; ----------------------------------------------------------------------
;	0.0		4.10	F.K.	cration
;	0.1		5.18	F.K.	Modif erreur points perdus dans 
;				        les bords de la matrice source.
;	1.0		6.20	D.D.	version couleur

	VersCouleur	=	.not.?AsCond

;
;
; Pour les rectangles :
; ---------------------
;
;   (S0x,S0y)        (S1x,S1y)     (D0x,D0y) (D1x,D1y)
;	o----------------o             o---------o
;       |                |     ---\    |          \
;       |                |     ---/    |           \
;       o----------------o             o------------o
;   (S3x,S3y)        (S2x,S2y)     (D3x,D3y)     (D2x,D2y)
;
; X ,Y 	: Position source relative  S0
; X',Y' : Position dest   relative  D0
;
; En continu :
;
; X' 	= (D3x-D0x)/(S2y-S0y) * Y +
;	  (D1x-D0x)/(S2x-S0x) * X +
;	  (((D2x-D3x)-(D1x-D0x))/((S2x-S0x)*(S2y-S0y))) * X * Y
;
; Y'	= (D3y-D0y)/(S2y-S0y) * Y +
;	  (D1y-D0y)/(S2x-S0x) * X +
;	  (((D2y-D1y)-(D3y-D0y))/((S2x-S0x)*(S2y-S0y))) * X * Y
;
; En incrmental :
;
; X'	=  OXFIX  * X +
;	   OXFIY  * Y +
;	   OXFIXY * X * Y
;
; Y'	=  OYFIX  * X +
;	   OYFIY  * Y +
;	   OYFIXY * X * Y


	.PROC		M68000			; CALM
	.BASE		10'10			; Base 10 par dfaut
	.LAYOUT		HEX

	.REF		SMAKY				; Df machine
;	.REF		DOLIB				; Df restart lib
;	.REF		STRETCH				; Df module courant
	.ref		modules

;	.INS		M_DEB.ASI			; Macro de debug

MAJREV	=		1				; Rvision
MINREV	=		2				; Version
	.REV		  MAJREV,MINREV			; Init rev entte
.if	VersCouleur
	.IDENT		  "F.Klay D.Dumoulin - Stretch couleur"		; Init ident entte
.else
	.IDENT		  "F.Klay D.Dumoulin - Stretch noir/blanc"	; Init ident entte
.endif


; Dclaration PC d'assemblage :
; -----------------------------
PCCODE	=		0				; Pour le code
PCVAR	=		1				; Pour var globales
PCOFFSET=		2				; Pour var locales

	.APC		PCCODE				; Initialisation PC d'assemblage
	.LOC		0
	.APC		PCVAR
	.LOC		0
	.APC		PCOFFSET
	.LOC		0


; Dclaration constantes :
; ------------------------
OY	=		0				; Offset Y
OX	=		2				; Offset X
OHLW	=		0				; Offset high long word
OLLW	=		2				; Offset low  long word
OHDLW	=		0				; Offset high double long word
OLDLW	=		4				; Offset low  double long word


; Dclaration des variables utilises pour la transformation de rectangle : 
; -------------------------------------------------------------------------
	.APC		PCOFFSET
	.LOC		0
OTTRANS:	.BLK.16		1			; Type de transformation   (inutilis)
OTOPPG:		.BLK.16		1			; Type opration sur point (inutilis)

OSPT:		.BLK.32		1			; ^matrice source
OSDX:		.BLK.16		1			; Dim X matrice source (bytes)
OS0:		.BLK.32		1			; S0 (y,x)
OS2:		.BLK.32		1			; S2 (y,x)

ODPT:		.BLK.32		1			; ^matrice destination
ODDX:		.BLK.16		1			; Dim X matrice destination (bytes)
OD0:		.BLK.32		1			; D0 (y,x)
OD1:		.BLK.32		1			; D1 (y,x)
OD2:		.BLK.32		1			; D2 (y,x)
OD3:		.BLK.32		1			; D3 (y,x)

ONBPIXEL:	.BLK.16		1
OTABLCOUL:	.BLK.32		1			; table de conversion de couleur
		.BLK.16		8-2-1			; Rserve...

OSDIM:		.BLK.32		1			; Dim rectangle source (y,x)
ORD1:		.BLK.32		1			; Pos relative D1 par rapport  D0 (y,x)
ORD2:		.BLK.32		1			; Pos relative D2 par rapport  D0 (y,x)
ORD3:		.BLK.32		1			; Pos relative D3 par rapport  D0 (y,x)

OD2MD3:		.BLK.32		1			; D2-D3 (y,x)
OD2MD1:		.BLK.32		1			; D2-D1 (y,x)

ONBITX:		.BLK.16		1			; Nb itration en X
ONBITY:		.BLK.16		1			; Nb itration en Y

OCPTX:		.BLK.16		1			; Cpt d'itration X
OCPTY:		.BLK.16		1			; Cpt d'itration Y

OSFIX:		.BLK.16		1			; Incrment X source * 2**16 (0< <=1)
OSFIY:		.BLK.16		1			; Incrment Y source * 2**16 (0< <=1)

OSMODY:		.BLK.16		1			; Modulo 2**16 Y source
OSPTLINE:	.BLK.32		1			; ^ligne

OXFIX:		.BLK.32		2			; Facteur incrmental pour X' de X
OXFIY:		.BLK.32		2			; Facteur incrmental pour X' de Y
OXFIXY:		.BLK.32		2			; Facteur incrmental pour X' de X*Y
OXFIL:		.BLK.32		2			; Facteur incrmental de ligne   pour X'
OXFIC:		.BLK.32		2			; Facteur incrmental de colonne pour X'

OYFIX:		.BLK.32		2			; Facteur incrmental pour Y' de X
OYFIY:		.BLK.32		2			; Facteur incrmental pour Y' de Y
OYFIXY:		.BLK.32		2			; Facteur incrmental pour Y' de X*Y
OYFIL:		.BLK.32		2			; Facteur incrmental de ligne   pour Y'
OYFIC:		.BLK.32		2			; Facteur incrmental de colonne pour Y'
OTCOUL:		.BLK.32		1			; copie ^table couleur

;;	.FILL.8		ST_LGTRECT-APC, 0


; Routine et entte :
; -------------------
	.APC		PCCODE

	ST_		FIRST				; Code du premier appel	
	ST_		LAST				; Code du dernier appel	
	.8		0				; Nombre d'installations
	.FILL.8		(OHLREV-APC), 0
	.8		MAJREV,MINREV			; Rvision.version
	.16		0,ENDSTRETCH			; Longueur

	.32		PATHLIB				; Pattern de dbut
	.FILL.8		(OHLNAM-APC),0

	.ASCII	 	"STRETCH"			; Nom du module

	.FILL.8		(LGHLIB-APC),0
	.16		_ST_RECT			; Dformation d'un rectangle


;--------------\\
;   _ST_RECT	>
;==============/

; Transformation d'un rectangle lastique. Si un paramtre de la table
; est incorrecte la routine est sans effet.

; in	A0.32 : ^Table
; out	D7.16 : 0, 1
; mod	D7.16 , F

_ST_RECT:
	test.32		{A0}+OTTRANS		; appel ancienne version ?
	jump,ne		r8^DoIt$

	pushm.32	A1|D1
	move.32		#{A0}+Os0+ox, A1
	move.16		#2, D1
	call		DimMax			; diminue la coordonne max
	move.32		#{A0}+Os0+oy, A1
	move.16		#2, D1
	call		DimMax			; diminue la coordonne max
	move.32		#{A0}+Od0+ox, A1
	move.16		#4, D1
	call		DimMax			; diminue la coordonne max
	move.32		#{A0}+Od0+oy, A1
	move.16		#4, D1
	call		DimMax			; diminue la coordonne max
	popm.32		A1|D1
DoIt$:
	CALL		TRANSRECT
	test.16		D7
	RET

DimMax:
	pushm.32	a1|d1|d0		; A1 puis D1 puis D0
	clr.16		d0
t$:
	comp.16		{A1}, d0		; recherche la plus grande valeur
	jump,ge		r8^s$			; avec nombres signs
	move.16		{A1}, d0		; -> d0
s$:
	add.32		#4, A1			; coordonne suivante
	dec.16		d1
	jump,ne		t$
	movem.32	{SP}+4, A1|d1
c$:
	comp.16		{A1}, d0		; valeur limite ?
	jump,ne		r8^l$
	dec.16		{A1}			; oui -> diminue !
l$:
	add.32		#4, A1
	dec.16		d1
	jump,ne		c$
	popm.32		a1|d1|d0
	Ret

; Dclaration macros :
; --------------------

	.MACRO		ABS		; Calcul valeur absolue
	.LOCALMACRO	L9
	TEST.%0		%1
	JUMP,PL		L9
	NEG.%0		%1
L9:
	.ENDMACRO

	.MACRO		ABSF		; Calcul valeur absolue selon flag
	.LOCALMACRO	L9
	JUMP,PL		L9
	NEG.%0		%1
L9:
	.ENDMACRO



;--------------\\
;    MACRO      \\
;    GETPTS	/
;--------------/

; Donne les paramtres du point source suivant en X.

; in	A0.32 : ^byte suivant byte point courant
;	D7.16 : I masque I bit point courant | contenu byte point courant I
; out	A0.32 : ^byte suivant byte point suivant
;	D7.16 : I masque I bit point suivant | contenu byte point suivant I
; mod	D7.16 , A0.32 

	.MACRO		GETPTS
	.LOCALMACRO	L1			; Labels locaux
	SL.16		#1,D7				; Point suivant dans byte suivant ?
	JUMP,CC		R8^L1				; Non => L1
	MOVE.16		#2**8,D7			; Init masque
	MOVE.8		{A0+},D7			; Byte suivant (bit 7 point suivant)	-> D7
L1:
	.ENDMACRO


;--------------\\
;    MACRO      \\
;    GETPTD	/
;--------------/

; Donne le pointeur au byte et le no du bit d'un point en fonction des
; paramtres du point prcdent. La diffrence en X,Y entre 2 points
; successifs doit tre : -1..+1.

; in	D2.16 : Coor X point courant
;	D5.32 : | Dim X dest (byte) | Coor Y point courant |
;	D7.16 : No bit point prcdente
;	A1.32 : ^byte point prcdent
;	A4.16 : Coor X point prcdent
;	A5.16 : Coor Y point prcdent
; out	D7.16 : No bit point courant
;	A1.32 : ^byte point courant
;	A4.16 : Coor X point courant
;	A5.16 : Coor Y point courant
; mod	D7.16 , A1.32 , A4.32 , A5.32 

	.MACRO		GETPTD
	.LOCALMACRO	L1,L2,L3,L4,L6,L7	; Labels locaux
	COMP.16		A5,D5				; Nouveau Y par apport ancien
	JUMP,EQ		R8^L2				; Egal       => L2
	JUMP,HI		R8^L1				; Plus grand => L1

	SWAP.32		D5				; Plus petit =>
	SUB.A16		D5,A1				; Mj ^byte dest			-> A1
	SWAP.32		D5
	MOVE.32		D5,A5				; Coor Y courante			-> A5

	COMP.16		A4,D2				; Nouveau X par apport ancien
	JUMP,EQ		R8^L6				; Egal       => L6
	JUMP,HI		R8^L4				; Plus grand => L4
	JUMP		R8^L3				; Plus petit => L3

L1:
	SWAP.32		D5				; Plus grand =>
	ADD.A16		D5,A1				; Mj ^byte dest			-> A1
	SWAP.32		D5
	MOVE.32		D5,A5				; Coor Y courante			-> A5

	COMP.16		A4,D2				; Nouveau X par apport ancien
	JUMP,EQ		R8^L6				; Egal       => L6
	JUMP,HI		R8^L4				; Plus grand => L4
	JUMP		R8^L3				; Plus petit => L3

L2:
	COMP.16		A4,D2				; Nouveau X par apport ancien
	JUMP,HI		R8^L4				; Plus grand => L4
	JUMP,EQ		R8^L7				; Egal       => L7

L3:							; Plus petit =>
	MOVE.32		D2,A4				; Coor X courante			-> A4
	INC.16		D7
	COMP.16		#7,D7				; Point dans byte prcdent ?
	JUMP,LS		R8^L6				; Non => L6
	CLR.16		D7				; Bit 0 dans byte prcdent		-> D7
	DEC.32		A1				; ^byte prcdent			-> A1 
	JUMP		R8^L6
L4:							; Plus grand =>
	MOVE.32		D2,A4				; Coor X courante			-> A4
	DEC.16		D7				; Point dans byte suivant ?
	JUMP,CC		R8^L6				; Non => L6
	MOVE.16		#7,D7				; Bit 7 dans byte suivant	
	INC.32		A1				; ^byte suivant				-> A1
;	JUMP		R8^L6
L6:
;#1#	TCLR.8	{A1}:D7		; Eteint le point #1#
L7:
	.ENDMACRO


;--------------\\
;    MACRO      \\
;    GETPTDX	/
;--------------/

; Donne le pointeur au byte et le no du bit d'un point en fonction des
; paramtres du point prcdent. La diffrence en X entre 2 points
; successifs doit tre : -1..+1.

; in	D2.16 : Coor X point courant
;	D6.16 : No bit point prcdente
;	A1.32 : ^byte point prcdent
;	A4.16 : Coor X point prcdent
; out	D6.16 : No bit point courant
;	A1.32 : ^byte point courant
;	A4.16 : Coor X point courant
; mod	D6.16 , A1.32 , A4.32

	.MACRO		GETPTDX
	.LOCALMACRO	L1,L2,L3,L4,L6,L7	; Labels locaux

	COMP.16		A4,D2				; Nouveau X par apport ancien
	JUMP,HI		R8^L4				; Plus grand => L4
	JUMP,EQ		R8^L7				; Egal       => L7

L3:							; Plus petit =>
	MOVE.32		D2,A4				; Coor X courante			-> A4
	INC.16		D6
	COMP.16		#7,D6				; Point dans byte prcdent ?
	JUMP,LS		R8^L6				; Non => L6
	CLR.16		D6				; Bit 0 dans byte prcdent		-> D6
	DEC.32		A1				; ^byte prcdent			-> A1 
	JUMP		R8^L6
L4:							; Plus grand =>
	MOVE.32		D2,A4				; Coor X courante			-> A4
	DEC.16		D6				; Point dans byte suivant ?
	JUMP,CC		R8^L6				; Non => L6
	MOVE.16		#7,D6				; Bit 7 dans byte suivant	
	INC.32		A1				; ^byte suivant				-> A1
;	JUMP		R8^L6
L6:
L7:
	.ENDMACRO


;--------------\\
;    MACRO      \\
;    GETPTDY	/
;--------------/

; Donne le pointeur au byte et le no du bit d'un point en fonction 
; des paramtres du point prcdent. La diffrence en Y entre 2 
; points successifs doit tre : -1..+1.

; in	D5.32 : | Dim X dest (byte) | Coor Y point courant |
;	A1.32 : ^byte point prcdent
;	A5.16 : Coor Y point prcdent
; out;	A1.32 : ^byte point courant
;	A5.16 : Coor Y point courant
; mod	A1.32 , A5.32 

	.MACRO		GETPTDY
	.LOCALMACRO	L1,L2,L3,L4,L6,L7	; Labels locaux
	COMP.16		A5,D5				; Nouveau Y par rapport ancien
	JUMP,EQ		R8^L2				; Egal       => L2
	JUMP,HI		R8^L1				; Plus grand => L1

	SWAP.32		D5				; Plus petit =>
	SUB.A16		D5,A1				; Mj ^byte dest			-> A1
	SWAP.32		D5
	MOVE.32		D5,A5				; Coor Y courante			-> A5
	JUMP		R8^L2

L1:
	SWAP.32		D5				; Plus grand =>
	ADD.A16		D5,A1				; Mj ^byte dest			-> A1
	SWAP.32		D5
	MOVE.32		D5,A5				; Coor Y courante			-> A5
L2:
	.ENDMACRO


.If	VersCouleur
;--------------\\
;    MACRO      \\
;    GETPTSc	/
;--------------/

; Donne les paramtres du point source suivant en X.

; in	A0.32 : ^byte suivant byte point courant
;	D7.16 : I masque I bit point courant | contenu byte point courant I
; out	A0.32 : ^byte suivant byte point suivant
;	D7.16 : I masque I bit point suivant | contenu byte point suivant I
; mod	D7.16 , A0.32 

	.MACRO		GETPTSc
	.LOCALMACRO	L1			; Labels locaux
	SL.16		#4,D7				; Point suivant dans byte suivant ?
	JUMP,CC		R8^L1				; Non => L1
	MOVE.16		#2**8*2'1111,D7			; Init masque
	MOVE.8		{A0+},D7			; Byte suivant (bit 7654 point suivant)	-> D7
L1:
	.ENDMACRO


;--------------\\
;    MACRO      \\
;    GETPTDc	/
;--------------/

; Donne le pointeur au byte et le no du bit d'un point en fonction des
; paramtres du point prcdent. La diffrence en X,Y entre 2 points
; successifs doit tre : -1..+1.

; in	D2.16 : Coor X point courant
;	D5.32 : | Dim X dest (byte) | Coor Y point courant |
;	D7.16 : No bit point prcdente
;	A1.32 : ^byte point prcdent
;	A4.16 : Coor X point prcdent
;	A5.16 : Coor Y point prcdent
; out	D7.16 : No bit point courant
;	A1.32 : ^byte point courant
;	A4.16 : Coor X point courant
;	A5.16 : Coor Y point courant
; mod	D7.16 , A1.32 , A4.32 , A5.32 

	.MACRO		GETPTDc
	.LOCALMACRO	L1,L2,L3,L4,L6,L7	; Labels locaux
	COMP.16		A5,D5				; Nouveau Y par rapport ancien
	JUMP,EQ		R8^L2				; Egal       => L2
	JUMP,HI		R8^L1				; Plus grand => L1

	SWAP.32		D5				; Plus petit =>
	SUB.A16		D5,A1				; Mj ^byte dest			-> A1
	SWAP.32		D5
	MOVE.32		D5,A5				; Coor Y courante			-> A5

	COMP.16		A4,D2				; Nouveau X par rapport ancien
	JUMP,EQ		R8^L6				; Egal       => L6
	JUMP,HI		R8^L4				; Plus grand => L4
	JUMP		R8^L3				; Plus petit => L3

L1:
	SWAP.32		D5				; Plus grand =>
	ADD.A16		D5,A1				; Mj ^byte dest			-> A1
	SWAP.32		D5
	MOVE.32		D5,A5				; Coor Y courante			-> A5

	COMP.16		A4,D2				; Nouveau X par rapport ancien
	JUMP,EQ		R8^L6				; Egal       => L6
	JUMP,HI		R8^L4				; Plus grand => L4
	JUMP		R8^L3				; Plus petit => L3

L2:
	COMP.16		A4,D2				; Nouveau X par rapport ancien
	JUMP,HI		R8^L4				; Plus grand => L4
	JUMP,EQ		R8^L7				; Egal       => L7

L3:							; Plus petit =>
	MOVE.32		D2,A4				; Coor X courante			-> A4
;	INC.16		D7
	ADD.8		#4, D7
	COMP.8		#7,D7				; Point dans byte prcdent ?
	JUMP,LS		R8^L6				; Non => L6
	CLR.8		D7				; Bit 0 dans byte prcdent		-> D7
	DEC.32		A1				; ^byte prcdent			-> A1 
	JUMP		R8^L6
L4:							; Plus grand =>
	MOVE.32		D2,A4				; Coor X courante			-> A4
;	DEC.16		D7				; Point dans byte suivant ?
	SUB.8		#4, D7
	JUMP,CC		R8^L6				; Non => L6
;	MOVE.16		#7,D7				; Bit 7 dans byte suivant	
	ADD.8		#8, D7
	INC.32		A1				; ^byte suivant				-> A1
;	JUMP		R8^L6
L6:
.if	.not.empty(%1)
L7:
.endif
	swap.16		d7
	move.8		{A1}, d7
	swap.16		d7
.if	empty(%1)
L7:
.endif
	.ENDMACRO


;--------------\\
;    MACRO      \\
;    GETPTDXc	/
;--------------/

; Donne le pointeur au byte et le no du bit d'un point en fonction des
; paramtres du point prcdent. La diffrence en X entre 2 points
; successifs doit tre : -1..+1.

; in	D2.16 : Coor X point courant
;	D6.16 : No bit point prcdent
;	A1.32 : ^byte point prcdent
;	A4.16 : Coor X point prcdent
; out	D6.16 : No bit point courant
;	A1.32 : ^byte point courant
;	A4.16 : Coor X point courant
; mod	D6.16 , A1.32 , A4.32

	.MACRO		GETPTDXc
	.LOCALMACRO	L1,L2,L3,L4,L6,L7	; Labels locaux

	COMP.16		A4,D2				; Nouveau X par rapport ancien
	JUMP,HI		R8^L4				; Plus grand => L4
	JUMP,EQ		R8^L7				; Egal       => L7

L3:							; Plus petit =>
	MOVE.32		D2,A4				; Coor X courante			-> A4
;	INC.16		D6
	ADD.8		#4, D6
	COMP.8		#7,D6				; Point dans byte prcdent ?
	JUMP,LS		R8^L6				; Non => L6
	CLR.8		D6				; Bit 0 dans byte prcdent		-> D6
	DEC.32		A1				; ^byte prcdent			-> A1 
	JUMP		R8^L6
L4:							; Plus grand =>
	MOVE.32		D2,A4				; Coor X courante			-> A4
;	DEC.16		D6				; Point dans byte suivant ?
	SUB.8		#4, D6
	JUMP,CC		R8^L6				; Non => L6
;	MOVE.16		#7,D6				; Bit 7 dans byte suivant	
	ADD.8		#8, D6
	INC.32		A1				; ^byte suivant				-> A1
;	JUMP		R8^L6
L6:
	swap.16		d6
	move.8		{A1}, d6			; prpare l'octet destination
	swap.16		d6
L7:
	.ENDMACRO


;--------------\\
;    MACRO      \\
;    GETPTDYc	/
;--------------/

; Donne le pointeur au byte et le no du bit d'un point en fonction 
; des paramtres du point prcdent. La diffrence en Y entre 2 
; points successifs doit tre : -1..+1.

; in	D5.32 : | Dim X dest (byte) | Coor Y point courant |
;	A1.32 : ^byte point prcdent
;	A5.16 : Coor Y point prcdent
; out;	A1.32 : ^byte point courant
;	A5.16 : Coor Y point courant
; mod	A1.32 , A5.32 

	.MACRO		GETPTDYc
	.LOCALMACRO	L1,L2,L3,L4,L6,L7	; Labels locaux
	COMP.16		A5,D5				; Nouveau Y par rapport ancien
	JUMP,EQ		R8^L2				; Egal       => L2
	JUMP,HI		R8^L1				; Plus grand => L1

	SWAP.32		D5				; Plus petit =>
	SUB.A16		D5,A1				; Mj ^byte dest			-> A1
	SWAP.32		D5
	MOVE.32		D5,A5				; Coor Y courante			-> A5
	JUMP		R8^L2

L1:
	SWAP.32		D5				; Plus grand =>
	ADD.A16		D5,A1				; Mj ^byte dest			-> A1
	SWAP.32		D5
	MOVE.32		D5,A5				; Coor Y courante			-> A5
L2:
	swap.16		d6
	move.8		{A1}, d6
	swap.16		d6

	.ENDMACRO

;--------------\\
;    MACRO      \\
;    SETcDEST	/
;--------------/

; dtermine la couleur d'un point de destination

; in	D7.32	|masque|nibble source ....|octet destination|no bit destination|
;		0001.... ssss.... dddddddd ......nn
;	A1.32	^octet destination
;	A2.32	^table de conversion source+destination -> destination
; out	D7.32	|masque|nibble source ....|nouv. octet destination|no bit destination|

	.MACRO		SETcDEST, D7

	pushm.32	D0|D1

	move.32		D7, D0				; 0001.... ssss.... dddddddd ......nn
	move.8		%1, D1				; ......nn
	rl.32		#8, D0				; ssss.... dddddddd ......nn 0001....
;	and.32		#16'F0000000, D0		; ssss.... ........ ........ ........

	rr.32		#8, %1				; ......nn 0001.... ssss.... dddddddd
	rr.32		d1, %1				; a) ......nn 0001.... ssss.... dddddddd
							; b) dddd.... ..nn0001 ....ssss ....dddd
	move.8		%1, d0				; ssss.... ........ ........ ****dddd
	rl.32		#4, D0				; ........ ........ ....**** ddddssss
	and.32		#16'FF, D0			; 00000000 00000000 00000000 ddddssss
	move.8		{A2}+A16^{D0}, D0		; nibble DDDD correspondant

	and.32		#16'FFFFFFF0, %1		; a) ......nn 0001.... ssss.... dddd0000
							; b) dddd.... ..nn0001 ....ssss ....0000
	or.8		D0, %1				; a) ......nn 0001.... ssss.... ddddDDDD
							; b) dddd.... ..nn0001 ....ssss ....DDDD
	rl.32		d1, %1				; a) ......nn 0001.... ssss.... ddddDDDD
							; b) ......nn 0001.... ssss.... DDDDdddd
	move.8		%1, {A1}			; met  jour le point de destination
	rl.32		#8, %1				; 0001.... ssss.... DDDDDDDD ......nn

	popm.32		D0|D1

	.ENDMACRO

.endif

;-------------\\
;    MACRO     \\
;    DIVA      /
;-------------/

; Effectue une division de 2 nb positif avec arrondi.

; in	  %1.16	: Diviseur	(reg # D7)
;	  %2.32	: Dividante	(reg # D7)
; out	  %2.32	: Rsultat	(reg # D7)
; mod	  %2.32 , F
; prot    D7.16
; def	  -
	.MACRO		DIVA
	.LOCALMACRO	L1
	.IF		%1=D7
	Erreur param DIVA
	.ENDIF
	.IF		%2=D7
	Erreur param DIVA
	.ENDIF
	PUSH.32		D7
	CLR.32		D7
	MOVE.16		%1,D7				; Diviseur 				-> D7
	SR.16		#1,D7				; Diviseur/2				-> D7
	ADD.32		D7,%2				; Pour arrondi
	DIV.16		%1,%2
	JUMP,VC		L1				; Pas Owerflow => L1
	CLR.32		%2
L1:
	AND.32		#16'FFFF,%2			; Supprime reste
	POP.32		D7
	.ENDMACRO


;-------------\\
;    MACRO     \\
;    INCS      /
;-------------/

; Incrment sign (i.e.) ajoute 1 si l'oprande est positive et
; supprime 1 si l'oprande est ngative.

; in	  %1 : taille (.8,.16,.32)
;	  %2 : Oprande
; out	  %2 : Rsultat	
; mod	  %2 , F
; prot    -
; def	  -
;	.MACRO		INCS
;	.LOCALMACRO	L1, L2
;	TEST.%0		%1		; Nb positif ?
;	JUMP,PL		L1		; Oui => L1
;	DEC.%0		%1		; -1
;	JUMP		L2		;
;L1:
;	INC.%0		%1		; +1
;L2:
;	.ENDMACRO


;--------------\\
;   TRANSRECT	>
;--------------/

; Transforme un rectangle en un quadrilatre quelquonc.

; in	A0 : ^zone variable
; out	-
; mod	F

TRANSRECT:
	PUSHM.32	D0..D6|A0..A6

	move.16		#1, D7
	MOVE.16		{A0}+OS0+OX,D0			; Contrle paramtres =>
	COMP.16		{A0}+OS2+OX,D0			; S0x > S2x
	JUMP,HI		L90$				; Oui => 90$
	MOVE.16		{A0}+OS0+OY,D0
	COMP.16		{A0}+OS2+OY,D0			; S0y > S2y
	JUMP,HI		L90$				; Oui => 90$

	CALL		DORELPT				; Calcul pos rel pt par rap  S0,D0
	CALL		DODIFFPT			; Calcul diffrence entre pt dest

	TEST.16		{A0}+ORD3+OX			; D0 X = D3 X ?
	JUMP,NE		L10$				; Non => 10$
	TEST.16		{A0}+ORD1+OY			; D0 Y = D1 Y ?
	JUMP,NE		L10$				; Non => 10$

	TEST.16		{A0}+OD2MD1+OX			; D2 X = D1 X ?
	JUMP,NE		L10$				; Non => 10$
	TEST.16		{A0}+OD2MD3+OY			; D2 Y = D3 Y ?
	JUMP,NE		L10$

	comp.16		#2, {A0}+OTTRANS
	jump,lo		r8^rnb$

	comp.16		#1, {A0}+ONBPIXEL
	jump,eq		r8^rnb$

	move.16		#1, D7
.if	VersCouleur
	comp.16		#4, {A0}+ONBPIXEL
	jump,ne		L90$

	move.32		{A0}+OTABLCOUL, {A0}+OTCOUL
	jump,ne		r8^r$
	move.32		#r16^TableCouleur, A1
	move.32		A1, {A0}+OTCOUL
r$:

	CALL		TRECTRECTc			; Trans rect -> rect sans inv coor X,Y
.endif
	JUMP		L90$
rnb$:
	CALL		TRECTRECT			; version noir/blanc
	JUMP		L90$

L10$:
	comp.16		#2, {A0}+OTTRANS
	jump,lo		r8^qnb$

	comp.16		#1, {A0}+ONBPIXEL
	jump,eq		r8^qnb$

	move.16		#1, D7
.if	VersCouleur
	comp.16		#4, {A0}+ONBPIXEL
	jump,ne		L90$

	move.32		{A0}+OTABLCOUL, {A0}+OTCOUL
	jump,ne		r8^q$
	move.32		#r16^TableCouleur, A1
	move.32		A1, {A0}+OTCOUL
q$:
	CALL		TRECTQUADc			; Trans rect -> quadrilatre qq
.endif
	JUMP		L90$

qnb$:
	CALL		TRECTQUAD			; Trans rect -> quadrilatre qq

L90$:
	POPM.32		D0..D6|A0..A6
	TEST.16		D7
	RET



;--------------\\
;   TRECTQUAD	>
;--------------/

; Transforme un rectangle en un quadrilatre quelconque.

; in	A0 : ^zone variable
; out	-
; mod	F

TRECTQUAD:
	CALL		DONBITRQ			; Calcul nb itration en X et Y
	CALL		DOFINC				; Calcul des facteurs incrmentaux

	; Calcul param accs destination

	MOVE.32		{A0}+ODPT,A4			; ^matrice dest  			-> A4
	MOVE.16		{A0}+ODDX,D4			; Dim X matrice dest (bytes)		-> D4
	MOVE.32		{A0}+OD0,D5			; Coor D0				-> D5
	CALL		GETMEMPOS			; ^byte mmoire				-> A4
	MOVE.32		A4,A1				; ^byte  point D0			-> A1
	MOVE.16		D5,D7				; No bit point D0			-> D7
	SWAP.32		D7

        ; Calcul param accs source (S0 -1 en X)
	; Pour viter les accs hors matrice, on demande le point source
 	; courant en dbut de boucle (et pas le point suivant en fin de
	; boucle. C'est pourquoi il faut les paramtres du point prcdent
	; le premier point en entre dans la boucle (^byte et masque).

	MOVE.32		{A0}+OSPT,A4			; ^matrice source			-> A4
	MOVE.16		{A0}+OSDX,D4			; Dim X matrice source (bytes)		-> D4
	MOVE.32		{A0}+OS0,D5			; Coor S0				-> D5
	CALL		GETMEMPOS			; ^byte mmoire				-> A4
							; No bit				-> D5

	MOVE.32		A4,{A0}+OSPTLINE		; Init ^ligne source
	MOVE.16		#2**8,D7			; Init masque				-> D7
	SL.16		D5,D7				; Point prc = B0 byte prc. ?
	JUMP,NS		L10$				; Oui => 10$ (byte charg dans GETPTS)
	SUB.32		#6,D5				;  0..6 -> -6..0
	NEG.32		D5				; -6..0 ->  6..0
	MOVE.16		D5,D2				; Sauve nb shift left  pour que 
	SWAP.32		D2				; point prcdent = B7 byte		-> D2H
	MOVE.16		#2**8,D7			; Init masque				-> D7
	SL.16		D5,D7
L10$:

	MOVE.32		#2**31,D1			; Pf X' * 2**32				-> D1
	MOVE.16		{A0}+OD0+OX,D2			; PF X' * 2**32 : D0			-> D2
	MOVE.32		{A0}+OXFIX+OLDLW,A3		; Pf Facteur incrmental X pour X'	-> A3
	MOVE.32		{A0}+OXFIX+OHDLW,D3		; PF Facteur incrmental X pour X'	-> D3

	MOVE.32		#2**31,D4			; Pf Y' * 2**32				-> D4
	MOVE.16		{A0}+OD0+OY,D5			; PF Y' * 2**32 : D0 			-> D5
	MOVE.32		{A0}+OYFIX+OLDLW,A6		; Pf Facteur incrmental X pour Y'	-> A6
	MOVE.32		{A0}+OYFIX+OHDLW,D6		; PF Facteur incrmental X pour Y'	-> D6

	MOVE.32		D2,A4				; Init coor X point dest prcdent
	MOVE.32		D5,A5				; Init coor Y point dest prcdent

	SWAP.32		D5
	MOVE.16		{A0}+ODDX,D5			; Dim X dest (bytes)		-> D5.16..31
	SWAP.32		D5

	CLR.16		{A0}+OSMODY			; Init modulo 2**16 coor Y


	MOVE.16		{A0}+ONBITX,{A0}+OCPTX		; Dcompteur Y
	MOVE.16		{A0}+ONBITY,{A0}+OCPTY		; Dcompteur X
	DEC.16		{A0}+OCPTX			; Pour DJ.16,NMO


	; BOUCLE PRINCIPALE DEFORMATION RECTANGLE :
	; -----------------------------------------

LLINERQ:						; Boucle ligne   =>
	SWAP.32		D7				; No bit dest point prcdent	-> D7.16
	GETPTD						; Calcul ^, no bit point dest	-> A1,D7
	SWAP.32		D7				; I masque I byte source I	-> D7.16

	CLR.32		D0				; | modulo 2**16 X | dcpt X |	-> D0
	MOVE.16		{A0}+OCPTX,D0			; Nb itration en X -1		-> D0

	PUSHM.32	D1..D2|D4..D5|D7|A0|A1		; Sauve :
				        ; D1..D2 : X' dbut ligne courante
				        ; D4..D5 : Y' dbut ligne courante
				        ; D2 hw  : Nb SL pour  col 0 source
				        ; D5 hw  : Dim X dest		
				        ; D7 lw  : Masque pour col 0 source
				        ; D7 lw  : No bit dest col 0 source
				        ; A1     : ^byte  dest col 0 source
				        ; A0     : ^variables

;#2#	MOVE.32	#2**31,D1		; Pf X' Y' au milieux pt dbut 
;#2#	MOVE.32	#2**31,D4		; pour viter blanc entre 2 lignes
					; conscutives (Si val diffrente 
					; entre 2 ligne basculement coor
					; Y,X entre ligne pas syncrone !)

	TEST.16		{A0}+OSFIX			; Fact incr X = 1 ?
	JUMP,EQ		LCOLI1RQ			; Oui => LCOLRQI1
	JUMP		LCOLILT1RQ			; < 1 => LCOLRQILT1


ELCOLRQ:
	POPM.32		D1..D2|D4..D5|D7|A0|A1		; Sort :
				    ; D1..D2 : X' dbut ligne courante
				    ; D4..D5 : Y' dbut ligne courante
				    ; D2 hw  : Nb SL pour  col 0 source
				    ; D5 hw  : Dim X dest		
				    ; D7 lw  : Masque pour col 0 source
				    ; D7 lw  : No bit dest col 0 prc source
				    ; A1     : ^byte  dest col 0 prc source
				    ; A0     : ^variables

	MOVE.32		D2,A4				; Init coor X point dest prcdent
	MOVE.32		{A0}+OXFIY+OHDLW,D0		; PF fact incrmental Y  pour X'	-> D0
	ADD.32		{A0}+OXFIY+OLDLW,D1		; Pf X' ligne suivante			-> D1
	ADDX.16		D0,D2				; PF X' ligne suivante			-> D2

	MOVE.32		{A0}+OXFIXY+OHDLW,D0		; PF fact incrmental XY pour X'	-> D0
	EX.32		D3,A3
	ADD.32		{A0}+OXFIXY+OLDLW,D3
	EX.32		D3,A3				; Pf fact incrmental col pour X'	-> A3
	ADDX.32		D0,D3				; PF fact incrmental col pour X'	-> D3

	MOVE.32		D5,A5				; Init coor Y point dest prcdent
	MOVE.32		{A0}+OYFIY+OHDLW,D0		; PF fact incrmental Y  pour Y'	-> D0
	ADD.32		{A0}+OYFIY+OLDLW,D4		; Pf Y' ligne suivante			-> D4
	ADDX.16		D0,D5				; PF Y' ligne suivante			-> D5

	MOVE.32		{A0}+OYFIXY+OHDLW,D0		; PF fact incrmental XY pour Y'	-> D0
	EX.32		D6,A6
	ADD.32		{A0}+OYFIXY+OLDLW,D6
	EX.32		D6,A6				; Pf fact incrmental col pour Y'	-> A6
	ADDX.32		D0,D6				; PF fact incrmental col pour X'	-> D6

	MOVE.16		{A0}+OSFIY,D0			; Facteur incr X * 2**16		-> D0
	JUMP,EQ		L10$				; (Fact = 1) => 10$
	ADD.16		D0,{A0}+OSMODY			; On passe  la ligne suivante ?
	JUMP,CC		L20$				; Non => 20$
L10$:
	MOVE.16		{A0}+OSDX,D0			; Dim X source (byte)			-> D0
	CONV.A16.32	D0				; Etend pour add.32
	ADD.32		D0,{A0}+OSPTLINE		; Init ^dbut nouvelle ligne
L20$:
	DEC.16		{A0}+OCPTY			; Fin transformation rectangle ?
	JUMP,NE		LLINERQ				; Non => LLINERQ
	clr.16		D7
	RET


;--------------\\
;    LCOLI1RQ	>
;............../

; Boucle en X quand l'incrment source X est gale  1 (dim images cts
; horizontaux source <= dim des horizonteaux source).

LCOLI1RQ:
	MOVE.32		{A0}+OSPTLINE,A0		; ^dbut ligne courante source		-> A0
	TEST.16		D7				; Pt col 0 source dans bit 7 ?
	JUMP,NS		R8^L20$				; Oui => 20$
	MOVE.8		{A0+},D7			; Byte source				-> D7
	SWAP.32		D2				; Nb dcalage ncessaire		-> D2L
	SL.8		D2,D7				; Modulo 64 !0 pas de problme
	SWAP.32		D2				; Pt col 0 source dans B6		-> D7

L20$:							; Boucle colonne =>
	GETPTS						; Met point courant source dans B7	-> D7
	TEST.8		D7				; Point source allum ?
	JUMP,NC		R8^L50$				; Non => 50$

	SWAP.32		D7				; No bit dest point prcdent		-> D7L
	GETPTD						; Calcul ^, no bit point dest
	TSET.8		{A1}:D7				; Allume le point
	SWAP.32		D7				; I masque I byte source I		-> D7L
	JUMP		R8^L70$
L50$:
	SWAP.32		D7				; No bit dest point prcdent		-> D7L
	GETPTD						; Calcul ^, no bit point dest
;#1#	TCLR.8		{A1}:D7			    ; Eteint le point
	SWAP.32		D7				; I masque I byte source I		-> D7L
;	JUMP	R8^70$
L70$:

	ADD.32		A3,D1				; Calcul X' suivant
	ADDX.16		D3,D2
	ADD.32		A6,D4				; Calcul Y' suivant
	ADDX.16		D6,D5				; Fin ligne ?
	DJ.16,NMO	D0,L20$				; Non => 20$
	JUMP		ELCOLRQ


;--------------\\
;   LCOLILT1RQ	>
;............../

; Boucle en X quand l'incrment source X est plus petit que 1 (dim image 
; d'un ct horizontal source > dim ct horizontal source).

LCOLILT1RQ:
	MOVE.A16	{A0}+OSFIX,A2			; Facteur incr X source			-> A2
	MOVE.32		{A0}+OSPTLINE,A0		; ^dbut ligne courante source		-> A0
	TEST.16		D7				; Pt col 0 source dans bit 7 ?
	JUMP,NS		R8^L10$				; Oui => 10$
	MOVE.8		{A0+},D7			; Byte source				-> D7
	SWAP.32		D2				; Nb dcalage ncessaire		-> D2L
	SL.8		D2,D7				; Modulo 64 !0 pas de problme
	SWAP.32		D2				; Pt col 0 source dans B6		-> D7
L10$:
	GETPTS						; Pt col 0 source dans B7 de D7

L20$:							; Boucle colonne =>
	TEST.8		D7				; Point source allum ?
	JUMP,NC		R8^L30$				; Non => 30$

	SWAP.32		D7				; No bit dest point prcdent		-> D7L
	GETPTD						; Calcul ^, no bit point dest
	TSET.8		{A1}:D7				; Allume le point
	SWAP.32		D7				; I masque I byte source I		-> D7L
	JUMP		R8^L50$
L30$:
	SWAP.32		D7				; No bit dest point prcdent		-> D7L
	GETPTD						; Calcul ^, no bit point dest
;#1#	TCLR.8		{A1}:D7		    ; Eteint le point
	SWAP.32		D7				; I masque I byte source I		-> D7L
;	JUMP		R8^50$              ;

L50$:
	SWAP.32		D0				; Modulo coor X source 2**16 		-> D0
	ADD.16		A2,D0				; On passe au point suivant ?
	JUMP,CC		R8^L60$				; Non => 60$
	GETPTS						; Met point courant source dans B7	-> D7
L60$:
	SWAP.32		D0				; | Modulo coor X  2**16 | dcpt X |	-> D0

	ADD.32		A3,D1				; Calcul X' suivant
	ADDX.16		D3,D2
	ADD.32		A6,D4				; Calcul Y' suivant
	ADDX.16		D6,D5				; Fin ligne ?
	DJ.16,NMO	D0,L20$				; Non => 20$
	JUMP		ELCOLRQ


.if	VersCouleur
;--------------\\
;   TRECTQUADc	>
;--------------/

; Transforme un rectangle en un quadrilatre quelconque.

; in	A0 : ^zone variable
; out	-
; mod	F

TRECTQUADc:
	CALL		DONBITRQ			; Calcul nb itration en X et Y
	CALL		DOFINC				; Calcul des facteurs incrmentaux

	; Calcul param accs destination

	MOVE.32		{A0}+ODPT,A4			; ^matrice dest  			-> A4
	MOVE.16		{A0}+ODDX,D4			; Dim X matrice dest (bytes)		-> D4
	MOVE.32		{A0}+OD0,D5			; Coor D0				-> D5
	CALL		GETMEMPOSc			; ^byte mmoire				-> A4
	MOVE.32		A4,A1				; ^byte  point D0			-> A1

	move.8		{A1}, D7
	swap.16		D7
	MOVE.8		D5,D7				; No bit point D0			-> D7
	SWAP.32		D7

        ; Calcul param accs source (S0 -1 en X)
	; Pour viter les accs hors matrice, on demande le point source
 	; courant en dbut de boucle (et pas le point suivant en fin de
	; boucle. C'est pourquoi il faut les paramtres du point prcdent
	; le premier point en entre dans la boucle (^byte et masque).

	MOVE.32		{A0}+OSPT,A4			; ^matrice source			-> A4
	MOVE.16		{A0}+OSDX,D4			; Dim X matrice source (bytes)		-> D4
	MOVE.32		{A0}+OS0,D5			; Coor S0				-> D5
	CALL		GETMEMPOSc			; ^byte mmoire				-> A4
							; No bit				-> D5

	MOVE.32		A4,{A0}+OSPTLINE		; Init ^ligne source
	MOVE.16		#2**8*2'1111,D7			; Init masque				-> D7
	SL.16		D5,D7				; Point prc = B0 byte prc. ?
.if	false
	JUMP,NS		L10$				; Oui => 10$ (byte charg dans GETPTS)
	SUB.32		#6,D5				;  0..6 -> -6..0
	NEG.32		D5				; -6..0 ->  6..0
	MOVE.16		D5,D2				; Sauve nb shift left  pour que 
	SWAP.32		D2				; point prcdent = B7 byte		-> D2H
	MOVE.16		#2**8*2'1111,D7			; Init masque				-> D7
	SL.16		D5,D7
L10$:
.endif

	MOVE.32		#2**31,D1			; Pf X' * 2**32				-> D1
	MOVE.16		{A0}+OD0+OX,D2			; PF X' * 2**32 : D0			-> D2
	MOVE.32		{A0}+OXFIX+OLDLW,A3		; Pf Facteur incrmental X pour X'	-> A3
	MOVE.32		{A0}+OXFIX+OHDLW,D3		; PF Facteur incrmental X pour X'	-> D3

	MOVE.32		#2**31,D4			; Pf Y' * 2**32				-> D4
	MOVE.16		{A0}+OD0+OY,D5			; PF Y' * 2**32 : D0 			-> D5
	MOVE.32		{A0}+OYFIX+OLDLW,A6		; Pf Facteur incrmental X pour Y'	-> A6
	MOVE.32		{A0}+OYFIX+OHDLW,D6		; PF Facteur incrmental X pour Y'	-> D6

	MOVE.32		D2,A4				; Init coor X point dest prcdent
	MOVE.32		D5,A5				; Init coor Y point dest prcdent

	SWAP.32		D5
	MOVE.16		{A0}+ODDX,D5			; Dim X dest (bytes)		-> D5.16..31
	SWAP.32		D5

	CLR.16		{A0}+OSMODY			; Init modulo 2**16 coor Y


	MOVE.16		{A0}+ONBITX,{A0}+OCPTX		; Dcompteur Y
	MOVE.16		{A0}+ONBITY,{A0}+OCPTY		; Dcompteur X
	DEC.16		{A0}+OCPTX			; Pour DJ.16,NMO


	; BOUCLE PRINCIPALE DEFORMATION RECTANGLE :
	; -----------------------------------------

LLINERQc:						; Boucle ligne   =>
	SWAP.32		D7				; No bit dest point prcdent	-> D7.16
	GETPTDc		*				; Calcul ^, no bit point dest	-> A1,D7
	SWAP.32		D7				; I masque I byte source I	-> D7.16

	CLR.32		D0				; | modulo 2**16 X | dcpt X |	-> D0
	MOVE.16		{A0}+OCPTX,D0			; Nb itration en X -1		-> D0

	PUSHM.32	D1..D2|D4..D5|D7|A0|A1		; Sauve :
				        ; D1..D2 : X' dbut ligne courante
				        ; D4..D5 : Y' dbut ligne courante
				        ; D2 hw  : Nb SL pour  col 0 source
				        ; D5 hw  : Dim X dest		
				        ; D7 lw  : Masque pour col 0 source
				        ; D7 lw  : No bit dest col 0 source
				        ; A1     : ^byte  dest col 0 source
				        ; A0     : ^variables

;#2#	MOVE.32	#2**31,D1		; Pf X' Y' au milieux pt dbut 
;#2#	MOVE.32	#2**31,D4		; pour viter blanc entre 2 lignes
					; conscutives (Si val diffrente 
					; entre 2 ligne basculement coor
					; Y,X entre ligne pas syncrone !)

	TEST.16		{A0}+OSFIX			; Fact incr X = 1 ?
	JUMP,EQ		LCOLI1RQc			; Oui => LCOLRQI1
	JUMP		LCOLILT1RQc			; < 1 => LCOLRQILT1


ELCOLRQc:
	POPM.32		D1..D2|D4..D5|D7|A0|A1		; Sort :
				    ; D1..D2 : X' dbut ligne courante
				    ; D4..D5 : Y' dbut ligne courante
				    ; D2 hw  : Nb SL pour  col 0 source
				    ; D5 hw  : Dim X dest		
				    ; D7 lw  : Masque pour col 0 source
				    ; D7 lw  : No bit dest col 0 prc source
				    ; A1     : ^byte  dest col 0 prc source
				    ; A0     : ^variables

	MOVE.32		D2,A4				; Init coor X point dest prcdent
	MOVE.32		{A0}+OXFIY+OHDLW,D0		; PF fact incrmental Y  pour X'	-> D0
	ADD.32		{A0}+OXFIY+OLDLW,D1		; Pf X' ligne suivante			-> D1
	ADDX.16		D0,D2				; PF X' ligne suivante			-> D2

	MOVE.32		{A0}+OXFIXY+OHDLW,D0		; PF fact incrmental XY pour X'	-> D0
	EX.32		D3,A3
	ADD.32		{A0}+OXFIXY+OLDLW,D3
	EX.32		D3,A3				; Pf fact incrmental col pour X'	-> A3
	ADDX.32		D0,D3				; PF fact incrmental col pour X'	-> D3

	MOVE.32		D5,A5				; Init coor Y point dest prcdent
	MOVE.32		{A0}+OYFIY+OHDLW,D0		; PF fact incrmental Y  pour Y'	-> D0
	ADD.32		{A0}+OYFIY+OLDLW,D4		; Pf Y' ligne suivante			-> D4
	ADDX.16		D0,D5				; PF Y' ligne suivante			-> D5

	MOVE.32		{A0}+OYFIXY+OHDLW,D0		; PF fact incrmental XY pour Y'	-> D0
	EX.32		D6,A6
	ADD.32		{A0}+OYFIXY+OLDLW,D6
	EX.32		D6,A6				; Pf fact incrmental col pour Y'	-> A6
	ADDX.32		D0,D6				; PF fact incrmental col pour X'	-> D6

	MOVE.16		{A0}+OSFIY,D0			; Facteur incr X * 2**16		-> D0
	JUMP,EQ		L10$				; (Fact = 1) => 10$
	ADD.16		D0,{A0}+OSMODY			; On passe  la ligne suivante ?
	JUMP,CC		L20$				; Non => 20$
L10$:
	MOVE.16		{A0}+OSDX,D0			; Dim X source (byte)			-> D0
	CONV.A16.32	D0				; Etend pour add.32
	ADD.32		D0,{A0}+OSPTLINE		; Init ^dbut nouvelle ligne
L20$:
	DEC.16		{A0}+OCPTY			; Fin transformation rectangle ?
	JUMP,NE		LLINERQc			; Non => LLINERQc
	clr.16		d7
	RET


;--------------\\
;    LCOLI1RQc	>
;............../

; Boucle en X quand l'incrment source X est gale  1 (dim images cts
; horizontaux source <= dim des horizonteaux source).

LCOLI1RQc:
	move.32		{A0}+OTCOUL, A2			; ^table conversion couleurs
	MOVE.32		{A0}+OSPTLINE,A0		; ^dbut ligne courante source		-> A0
	TEST.16		D7				; Pt col 0 source dans bit 7 ?
	JUMP,NS		R8^L20$				; Oui => 20$
	MOVE.8		{A0+},D7			; Byte source				-> D7
.if	false
	SWAP.32		D2				; Nb dcalage ncessaire		-> D2L
	SL.8		D2,D7				; Modulo 64 !0 pas de problme
	SWAP.32		D2				; Pt col 0 source dans B6		-> D7
.endif
L20$:							; Boucle colonne =>
	GETPTSc						; Met point courant source dans B7	-> D7
;-	TEST.8		D7				; Point source allum ?
;-	JUMP,NC		R8^L50$				; Non => 50$

	SWAP.32		D7				; No bit dest point prcdent		-> D7L
	GETPTDc						; Calcul ^, no bit point dest
;	TSET.8		{A1}:D7				; Allume le point
	SETcDEST
	SWAP.32		D7				; I masque I byte source I		-> D7L
;-	JUMP		R8^L70$
;-L50$:
;-	SWAP.32		D7				; No bit dest point prcdent		-> D7L
;-	GETPTD						; Calcul ^, no bit point dest
;#1#	TCLR.8		{A1}:D7			    ; Eteint le point
;-	SWAP.32		D7				; I masque I byte source I		-> D7L
;	JUMP	R8^70$
L70$:

	ADD.32		A3,D1				; Calcul X' suivant
	ADDX.16		D3,D2
	ADD.32		A6,D4				; Calcul Y' suivant
	ADDX.16		D6,D5				; Fin ligne ?
	DJ.16,NMO	D0,L20$				; Non => 20$
	JUMP		ELCOLRQc


;--------------\\
;   LCOLILT1RQ	>
;............../

; Boucle en X quand l'incrment source X est plus petit que 1 (dim image 
; d'un ct horizontal source > dim ct horizontal source).

LCOLILT1RQc:
;	MOVE.A16	{A0}+OSFIX,A2			; Facteur incr X source			-> A2
	move.32		{A0}+OTCOUL, A2			; ^table conversion couleurs
	push.16		{A0}+OSFIX			; Facteur incr X source			-> A2
	MOVE.32		{A0}+OSPTLINE,A0		; ^dbut ligne courante source		-> A0
	TEST.16		D7				; Pt col 0 source dans bit 7 ?
	JUMP,NS		R8^L10$				; Oui => 10$
	MOVE.8		{A0+},D7			; Byte source				-> D7
.if	false
	SWAP.32		D2				; Nb dcalage ncessaire		-> D2L
	SL.8		D2,D7				; Modulo 64 !0 pas de problme
	SWAP.32		D2				; Pt col 0 source dans B6		-> D7
.endif
L10$:
	GETPTSc						; Pt col 0 source dans B7 de D7

L20$:							; Boucle colonne =>
;-	TEST.8		D7				; Point source allum ?
;-	JUMP,NC		R8^L30$				; Non => 30$

	SWAP.32		D7				; No bit dest point prcdent		-> D7L
	GETPTDc						; Calcul ^, no bit point dest
;-	TSET.8		{A1}:D7				; Allume le point
	SETcDEST
	SWAP.32		D7				; I masque I byte source I		-> D7L
;-	JUMP		R8^L50$
;-L30$:
;-	SWAP.32		D7				; No bit dest point prcdent		-> D7L
;-	GETPTD						; Calcul ^, no bit point dest
;#1#	TCLR.8		{A1}:D7		    ; Eteint le point
;-	SWAP.32		D7				; I masque I byte source I		-> D7L
;	JUMP		R8^50$              ;

L50$:
	SWAP.32		D0				; Modulo coor X source 2**16 		-> D0
;	ADD.16		A2,D0				; On passe au point suivant ?
	ADD.16		{SP},D0
	JUMP,CC		R8^L60$				; Non => 60$
	GETPTSc						; Met point courant source dans B7	-> D7
L60$:
	SWAP.32		D0				; | Modulo coor X  2**16 | dcpt X |	-> D0

	ADD.32		A3,D1				; Calcul X' suivant
	ADDX.16		D3,D2
	ADD.32		A6,D4				; Calcul Y' suivant
	ADDX.16		D6,D5				; Fin ligne ?
	DJ.16,NMO	D0,L20$				; Non => 20$

	pop.16		d0				; bidon
	JUMP		ELCOLRQc

.endif



;--------------\\
;   TRECTRECT	>
;--------------/

; Transforme un rectangle en un rectangle quelquonc.

; in	A0 : ^zone variable
; out	-
; mod	F

TRECTRECT:
	CALL		DONBITRR			; Calcul nb itration en X et Y
	CALL		DOFINC				; Calcul des facteurs incrmentaux

	; Calcul param accs destination

	MOVE.32		{A0}+ODPT,A4			; ^matrice dest  			-> A4
	MOVE.16		{A0}+ODDX,D4			; Dim X matrice dest (bytes)		-> D4
	MOVE.32		{A0}+OD0,D5			; Coor D0				-> D5
	CALL		GETMEMPOS			; ^byte mmoire				-> A4
	MOVE.32		A4,A1				; ^byte  point D0			-> A1
	MOVE.16		D5,D6				; No bit point D0			-> D6
	SWAP.32		D7

        ; Calcul param accs source (S0 -1 en X)
	; Pour viter les accs hors matrice, on demande le point source
 	; courant en dbut de boucle (et pas le point suivant en fin de
	; boucle. C'est pourquoi il faut les paramtre du point prcdent
	; le premier point en entre dans la boucle (^byte et masque).

	MOVE.32		{A0}+OSPT,A4			; ^matrice source			-> A4
	MOVE.16		{A0}+OSDX,D4			; Dim X matrice source (bytes)		-> D4
	MOVE.32		{A0}+OS0,D5			; Coor S0				-> D5
	CALL		GETMEMPOS			; ^byte mmoire				-> A4
							; No bit				-> D5

	MOVE.32		A4,{A0}+OSPTLINE		; Init ^ligne source
	MOVE.16		#2**8,D7			; Init masque				-> D7
	SL.16		D5,D7				; Point prc = B0 byte prc. ?
	JUMP,NS		L10$				; Oui => 10$ (byte charg dans GETPTS)
	SUB.32		#6,D5				;  0..6 -> -6..0
	NEG.32		D5				; -6..0 ->  6..0
	MOVE.16		D5,D2				; Sauve nb shift left  pour que 
	SWAP.32		D2				; point prcdent = B7 byte		-> D2h
	MOVE.16		#2**8,D7			; Init masque				-> D7
	SL.16		D5,D7
L10$:

	MOVE.32		#2**31,D1			; Pf X' * 2**32				-> D1
	MOVE.16		{A0}+OD0+OX,D2			; PF X' * 2**32 : D0			-> D2
	MOVE.32		{A0}+OXFIX+OLDLW,A3		; Pf Facteur incrmental X pour X'	-> A3
	MOVE.32		{A0}+OXFIX+OHDLW,D3		; PF Facteur incrmental X pour X'	-> D3

	MOVE.32		#2**31,D4			; Pf Y' * 2**32				-> D4
	MOVE.16		{A0}+OD0+OY,D5			; PF Y' * 2**32 : D0 			-> D5

	MOVE.32		D2,A4				; Init coor X point dest prcdent
	MOVE.32		D5,A5				; Init coor Y point dest prcdent

	SWAP.32		D5
	MOVE.16		{A0}+ODDX,D5			; Dim X matrice dest (bytes)		-> D5
	SWAP.32		D5

	CLR.16		{A0}+OSMODY			; Init modulo 2**16 coor Y

	MOVE.16		{A0}+ONBITX,{A0}+OCPTX		; Dcompteur X
	MOVE.16		{A0}+ONBITY,{A0}+OCPTY		; Dcompteur Y
	DEC.16		{A0}+OCPTX			; Pour DJ.16,NMO


	; BOUCLE PRINCIPALE DEFORMATION RECTANGLE :
	; -----------------------------------------

LLINERR:						; Boucle ligne =>
	GETPTDY						; Calcul ^, no bit point dest	-> A1,D6
	MOVE.16		{A0}+OCPTX,D0			; Nb itration en X -1		-> D0

	PUSHM.32	D1..D2|D5..D7|A0|A1		; Sauve :
				        ; D1..D2 : X' dbut ligne courante
				        ; D4..D5 : Y' dbut ligne courante
				        ; D2 hw  : Nb SL pour  col 0 source
				        ; D5 hw  : Dim X dest		
					; D6 lw  : No bit dest
				        ; D7 lw  : Masque pour col 0 source
				        ; A1     : ^byte  dest col 0 source
				        ; A0     : ^variables
	TEST.16		{A0}+OSFIX			; Fact incr X = 1 ?
	JUMP,EQ		LCOLI1RR			; Oui => LCOLI1RR
	JUMP		LCOLILT1RR			; < 1 => LCOLILT1RR


ELCOLRR:
	POPM.32		D1..D2|D5..D7|A0|A1		; Sort :
				        ; D1..D2 : X' dbut ligne courante
				        ; D4..D5 : Y' dbut ligne courante
				        ; D2 hw  : Nb SL pour  col 0 source
				        ; D5 hw  : Dim X dest		
					; D6 lw  : No bit dest
				        ; D7 lw  : Masque pour col 0 source
				        ; A1     : ^byte  dest col 0 source
				        ; A0     : ^variables

	MOVE.32		D2,A4				; Init coor X point dest prcdent
	MOVE.32		D5,A5				; Init coor Y point dest prcdent	

	MOVE.32		{A0}+OYFIY+OHDLW,D0		; PF fact incrmental Y  pour Y'	-> D0
	ADD.32		{A0}+OYFIY+OLDLW,D4		; Pf Y' ligne suivante			-> D4
	ADDX.16		D0,D5				; PF Y' ligne suivante			-> D5

	MOVE.16		{A0}+OSFIY,D0			; Facteur incr Y * 2**16		-> D0
	JUMP,EQ		L10$				; (Fact = 1) => 10$
	ADD.16		D0,{A0}+OSMODY			; On passe  la ligne suivante ?
	JUMP,CC		L20$				; Non => 20$
L10$:
	MOVE.16		{A0}+OSDX,D0			; Dim X source (byte)			-> D0
	CONV.A16.32	D0				; Etend pour add.32
	ADD.32		D0,{A0}+OSPTLINE		; Init ^dbut nouvelle ligne
L20$:
	DEC.16		{A0}+OCPTY			; Fin transformation rectangle ?
	JUMP,NE		LLINERR				; Non => LLINERR
	clr.16		d7
	RET


;--------------\\
;   LCOLI1RR	>
;............../

; Boucle en X quand l'incrment source X est gale  1 (dim images cts
; horizontaux source <= dim des horizonteaux source).

LCOLI1RR:
	MOVE.32		{A0}+OSPTLINE,A0		; ^dbut ligne courante source		-> A0
	TEST.16		D7				; Pt col 0 source dans bit 7 ?
	JUMP,NS		R8^L20$				; Oui => 20$
	MOVE.8		{A0+},D7			; Byte source				-> D7
	SWAP.32		D2				; Nb dcalage ncessaire		-> D2L
	SL.8		D2,D7				; Modulo 64 !0 pas de problme
	SWAP.32		D2				; Pt col 0 source dans B6		-> D7

L20$:							; Boucle colonne =>
	GETPTS						; Met point courant source dans B7	-> D7
	TEST.8		D7				; Point source allum ?
	JUMP,NC		R8^L50$				; Non => 50$

	GETPTDX						; Calcul ^, no bit point dest
	TSET.8		{A1}:D6				; Allume le point
	JUMP		R8^L70$
L50$:
	GETPTDX						; Calcul ^, no bit point dest
;#1#	TCLR.8		{A1}:D7			    ; Eteint le point
;	JUMP		R8^70$
L70$:
	ADD.32		A3,D1				; Calcul X' suivant
	ADDX.16		D3,D2
	DJ.16,NMO	D0,L20$				; Non => 20$
	JUMP		ELCOLRR


;--------------\\
;  LCOLILT1RR	>
;............../

; Boucle en X quand l'incrment source X est plus petit que 1 (dim image 
; d'un ct horizontal source > dim ct horizontal source).

LCOLILT1RR:
	CLR.16		D5				; Modulo 2**16 X			-> D5
	MOVE.A16	{A0}+OSFIX,A2			; Facteur incr X source			-> A2

	MOVE.32		{A0}+OSPTLINE,A0		; ^dbut ligne courante source		-> A0
	TEST.16		D7				; Pt col 0 source dans bit 7 ?
	JUMP,NS		R8^L10$				; Oui => 10$
	MOVE.8		{A0+},D7			; Byte source				-> D7
	SWAP.32		D2				; Nb dcalage ncessaire		-> D2L
	SL.8		D2,D7				; Modulo 64 !0 pas de problme
	SWAP.32		D2				; Pt col 0 source dans B6		-> D7
L10$:
	GETPTS						; Initilise pt col 0 dans B7 de D7

L20$:							; Boucle colonne =>
	TEST.8		D7				; Point source allum ?
	JUMP,NC		R8^L30$				; Non => 30$
	GETPTDX						; Calcul ^, no bit point dest
	TSET.8		{A1}:D6				; Allume le point
	JUMP		R8^L50$
L30$:
	GETPTDX						; Calcul ^, no bit point dest
;#1#	TCLR.8		{A1}:D7			    ; Eteint le point
;	JUMP		R8^50$			    ;
L50$:
	ADD.16		A2,D5				; On passe au point suivant ?
	JUMP,CC		R8^L70$				; Non => 70$
	GETPTS						; Met point courant source dans B7	-> D7
L70$:
	ADD.32		A3,D1				; Calcul X' suivant
	ADDX.16		D3,D2
	DJ.16,NMO	D0,L20$				; Non => 20$
	JUMP		ELCOLRR


.if	VersCouleur
;--------------\\
;   TRECTRECTc	>
;--------------/

; Transforme un rectangle en un rectangle quelquonc.

; in	A0 : ^zone variable
; out	-
; mod	F

TRECTRECTc:
	CALL		DONBITRR			; Calcul nb itration en X et Y
	CALL		DOFINC				; Calcul des facteurs incrmentaux

	; Calcul param accs destination

	MOVE.32		{A0}+ODPT,A4			; ^matrice dest  			-> A4
	MOVE.16		{A0}+ODDX,D4			; Dim X matrice dest (bytes)		-> D4
	MOVE.32		{A0}+OD0,D5			; Coor D0				-> D5
	CALL		GETMEMPOSc			; ^byte mmoire				-> A4
	MOVE.32		A4,A1				; ^byte  point D0			-> A1

	move.8		{A1}, D6
	swap.16		D6
	MOVE.8		D5,D6				; No bit point D0			-> D6
;	SWAP.32		D7

        ; Calcul param accs source (S0 -1 en X)
	; Pour viter les accs hors matrice, on demande le point source
 	; courant en dbut de boucle (et pas le point suivant en fin de
	; boucle. C'est pourquoi il faut les paramtre du point prcdent
	; le premier point en entre dans la boucle (^byte et masque).

	MOVE.32		{A0}+OSPT,A4			; ^matrice source			-> A4
	MOVE.16		{A0}+OSDX,D4			; Dim X matrice source (bytes)		-> D4
	MOVE.32		{A0}+OS0,D5			; Coor S0				-> D5
	CALL		GETMEMPOSc			; ^byte mmoire				-> A4
							; No bit				-> D5

	MOVE.32		A4,{A0}+OSPTLINE		; Init ^ligne source
	MOVE.16		#2**8*2'1111,D7			; Init masque				-> D7
	SL.16		D5,D7				; Point prc = B0 byte prc. ?
.if	false
	JUMP,NS		L10$				; Oui => 10$ (byte charg dans GETPTS)
	SUB.32		#6,D5				;  0..6 -> -6..0
	NEG.32		D5				; -6..0 ->  6..0
	MOVE.16		D5,D2				; Sauve nb shift left  pour que 
	SWAP.32		D2				; point prcdent = B7 byte		-> D2h
	MOVE.16		#2**8*2'1111,D7			; Init masque				-> D7
	SL.16		D5,D7
L10$:
.endif
	MOVE.32		#2**31,D1			; Pf X' * 2**32				-> D1
	MOVE.16		{A0}+OD0+OX,D2			; PF X' * 2**32 : D0			-> D2
	MOVE.32		{A0}+OXFIX+OLDLW,A3		; Pf Facteur incrmental X pour X'	-> A3
	MOVE.32		{A0}+OXFIX+OHDLW,D3		; PF Facteur incrmental X pour X'	-> D3

	MOVE.32		#2**31,D4			; Pf Y' * 2**32				-> D4
	MOVE.16		{A0}+OD0+OY,D5			; PF Y' * 2**32 : D0 			-> D5

	MOVE.32		D2,A4				; Init coor X point dest prcdent
	MOVE.32		D5,A5				; Init coor Y point dest prcdent

	SWAP.32		D5
	MOVE.16		{A0}+ODDX,D5			; Dim X matrice dest (bytes)		-> D5
	SWAP.32		D5

	CLR.16		{A0}+OSMODY			; Init modulo 2**16 coor Y

	MOVE.16		{A0}+ONBITX,{A0}+OCPTX		; Dcompteur X
	MOVE.16		{A0}+ONBITY,{A0}+OCPTY		; Dcompteur Y
	DEC.16		{A0}+OCPTX			; Pour DJ.16,NMO


	; BOUCLE PRINCIPALE DEFORMATION RECTANGLE :
	; -----------------------------------------

LLINERRc:						; Boucle ligne =>
	GETPTDYc	*				; Calcul ^, no bit point dest	-> A1,D6
	MOVE.16		{A0}+OCPTX,D0			; Nb itration en X -1		-> D0

	PUSHM.32	D1..D2|D5..D7|A0|A1		; Sauve :
				        ; D1..D2 : X' dbut ligne courante
				        ; D4..D5 : Y' dbut ligne courante
				        ; D2 hw  : Nb SL pour  col 0 source
				        ; D5 hw  : Dim X dest		
					; D6 lw  : No bit dest
				        ; D7 lw  : Masque pour col 0 source
				        ; A1     : ^byte  dest col 0 source
				        ; A0     : ^variables
	TEST.16		{A0}+OSFIX			; Fact incr X = 1 ?
	JUMP,EQ		LCOLI1RRc			; Oui => LCOLI1RR
	JUMP		LCOLILT1RRc			; < 1 => LCOLILT1RR


ELCOLRRc:
	POPM.32		D1..D2|D5..D7|A0|A1		; Sort :
				        ; D1..D2 : X' dbut ligne courante
				        ; D4..D5 : Y' dbut ligne courante
				        ; D2 hw  : Nb SL pour  col 0 source
				        ; D5 hw  : Dim X dest		
					; D6 lw  : No bit dest
				        ; D7 lw  : Masque pour col 0 source
				        ; A1     : ^byte  dest col 0 source
				        ; A0     : ^variables

	MOVE.32		D2,A4				; Init coor X point dest prcdent
	MOVE.32		D5,A5				; Init coor Y point dest prcdent	

	MOVE.32		{A0}+OYFIY+OHDLW,D0		; PF fact incrmental Y  pour Y'	-> D0
	ADD.32		{A0}+OYFIY+OLDLW,D4		; Pf Y' ligne suivante			-> D4
	ADDX.16		D0,D5				; PF Y' ligne suivante			-> D5

	MOVE.16		{A0}+OSFIY,D0			; Facteur incr Y * 2**16		-> D0
	JUMP,EQ		L10$				; (Fact = 1) => 10$
	ADD.16		D0,{A0}+OSMODY			; On passe  la ligne suivante ?
	JUMP,CC		L20$				; Non => 20$
L10$:
	MOVE.16		{A0}+OSDX,D0			; Dim X source (byte)			-> D0
	CONV.A16.32	D0				; Etend pour add.32
	ADD.32		D0,{A0}+OSPTLINE		; Init ^dbut nouvelle ligne
L20$:
	DEC.16		{A0}+OCPTY			; Fin transformation rectangle ?
	JUMP,NE		LLINERRc			; Non => LLINERRc
	clr.16		d7
	RET


;--------------\\
;   LCOLI1RRc	>
;............../

; Boucle en X quand l'incrment source X est gale  1 (dim images cts
; horizontaux source <= dim des horizonteaux source).

LCOLI1RRc:
	move.32		{A0}+OTCOUL, A2			; ^table conversion couleurs
	MOVE.32		{A0}+OSPTLINE,A0		; ^dbut ligne courante source		-> A0
	TEST.16		D7				; Pt col 0 source dans bit 7 ?
	JUMP,NS		R8^L20$				; Oui => 20$
	MOVE.8		{A0+},D7			; Byte source				-> D7
.if	false
	SWAP.32		D2				; Nb dcalage ncessaire		-> D2L
	SL.8		D2,D7				; Modulo 64 !0 pas de problme
	SWAP.32		D2				; Pt col 0 source dans B6		-> D7
.endif
L20$:							; Boucle colonne =>
	GETPTSc						; Met point courant source dans B7	-> D7
;-	TEST.8		D7				; Point source allum ?
;-	JUMP,NC		R8^L50$				; Non => 50$

	swap.32		d7
	GETPTDXc					; Calcul ^, no bit point dest

	SETcDEST	D6
	swap.32		d7
;-	TSET.8		{A1}:D6				; Allume le point
;-	JUMP		R8^L70$
;-L50$:
;-	GETPTDX						; Calcul ^, no bit point dest
;#1#	TCLR.8		{A1}:D7			    ; Eteint le point
;	JUMP		R8^70$
L70$:
	ADD.32		A3,D1				; Calcul X' suivant
	ADDX.16		D3,D2
	DJ.16,NMO	D0,L20$				; Non => 20$
	JUMP		ELCOLRRc


;--------------\\
;  LCOLILT1RRc	>
;............../

; Boucle en X quand l'incrment source X est plus petit que 1 (dim image 
; d'un ct horizontal source > dim ct horizontal source).

LCOLILT1RRc:
	CLR.16		D5				; Modulo 2**16 X			-> D5
	move.32		{A0}+OTCOUL, A2			; ^table conversion couleurs
;	MOVE.A16	{A0}+OSFIX,A2			; Facteur incr X source			-> A2
	push.16		{A0}+OSFIX			; Facteur incr X source			->{SP}

	MOVE.32		{A0}+OSPTLINE,A0		; ^dbut ligne courante source		-> A0
	TEST.16		D7				; Pt col 0 source dans bit 7 ?
	JUMP,NS		R8^L10$				; Oui => 10$
	MOVE.8		{A0+},D7			; Byte source				-> D7
.if	false
	SWAP.32		D2				; Nb dcalage ncessaire		-> D2L
	SL.8		D2,D7				; Modulo 64 !0 pas de problme
	SWAP.32		D2				; Pt col 0 source dans B6		-> D7
.endif
L10$:
	GETPTSc						; Initilise pt col 0 dans B7 de D7

L20$:							; Boucle colonne =>
;-	TEST.8		D7				; Point source allum ?
;-	JUMP,NC		R8^L30$				; Non => 30$

	swap.32		d7
	GETPTDXc					; Calcul ^, no bit point dest
;-	TSET.8		{A1}:D6				; Allume le point
	SETcDEST	D6
	swap.32		d7
;-	JUMP		R8^L50$
;-L30$:
	GETPTDXc					; Calcul ^, no bit point dest
;#1#	TCLR.8		{A1}:D7			    ; Eteint le point
;	JUMP		R8^50$			    ;
L50$:
;	ADD.16		A2,D5				; On passe au point suivant ?
	ADD.16		{SP},D5
	JUMP,CC		R8^L70$				; Non => 70$
	GETPTSc						; Met point courant source dans B7	-> D7
L70$:
	ADD.32		A3,D1				; Calcul X' suivant
	ADDX.16		D3,D2
	DJ.16,NMO	D0,L20$				; Non => 20$

	pop.16		d0				; bidon
	JUMP		ELCOLRRc
.endif


;--------------\\
;   DORELPT	>
;--------------/

; Calcul de la position relative de point.

; in	A0.32 : ^var
; out	-
; mod	F

DORELPT:
	PUSH.32		D0
	MOVE.32		{A0}+OS2,D0			; S2 (y,x) 			-> D0
	ADD.32		#16'10001,D0
	SUB.32		{A0}+OS0,D0			; Dim rectangle source		-> D0
	MOVE.32		D0,{A0}+OSDIM

	MOVE.32		{A0}+OD1,{A0}+ORD1
	MOVE.32		{A0}+OD2,{A0}+ORD2
	MOVE.32		{A0}+OD3,{A0}+ORD3

	MOVE.16		{A0}+OD0+OX,D0			; Pos rel pt dest X
	SUB.16		D0,{A0}+ORD1+OX
	SUB.16		D0,{A0}+ORD2+OX
	SUB.16		D0,{A0}+ORD3+OX

	MOVE.16		{A0}+OD0+OY,D0			; Pos rel pt dest X
	SUB.16		D0,{A0}+ORD1+OY
	SUB.16		D0,{A0}+ORD2+OY
	SUB.16		D0,{A0}+ORD3+OY
	POP.32		D0
	RET


;--------------\\
;   DODIFFPT	>
;--------------/

; Calcul la diffrence entre certain point destination.

; in	A0.32 : ^var
; out	-
; mod	F

DODIFFPT:
	PUSH.32		D0
	MOVE.32		{A0}+ORD2,{A0}+OD2MD3
	MOVE.32		{A0}+ORD2,{A0}+OD2MD1

	MOVE.16		{A0}+ORD1+OX,D0			; D2-D1
	SUB.16		D0,{A0}+OD2MD1+OX
	MOVE.16		{A0}+ORD1+OY,D0
	SUB.16		D0,{A0}+OD2MD1+OY

	MOVE.16		{A0}+ORD3+OX,D0			; D2-D3
	SUB.16		D0,{A0}+OD2MD3+OX
	MOVE.16		{A0}+ORD3+OY,D0
	SUB.16		D0,{A0}+OD2MD3+OY

	POP.32		D0
	RET


;--------------\\
;   DONBITRQ	>
;--------------/

; Transf rect -> quadrlilatre
;
; Calcul le nombre d'itrations ncessaires en X et Y. Le nombre
; d'itrations en X est la longueur maximal de l'image des cts
; horizontaux source dans la destination (respectivement verticaux 
; pour Y).

; in	A0.32 : ^var
; out	-
; mod	F

DONBITRQ:
	PUSHM.32	D0..D2
						   ; Nb itration en X =>
	MOVE.16		{A0}+OD2MD3+OX,D0		; D2-D3 X				-> D0
	ABSF.16		D0
	MOVE.16		{A0}+OD2MD3+OY,D1		; D2-D3 Y				-> D1
	ABSF.16		D1
	ADD.16		D1,D0				; D2-D3 X+Y (max prsum)		-> D0

	MOVE.16		{A0}+ORD1+OX,D1			; D1-D0 X 				-> D1
	ABSF.16		D1
	MOVE.16		D1,D2
	MOVE.16		{A0}+ORD1+OY,D1			; D1-D0 Y				-> D1
	ABSF.16		D1
	ADD.16		D2,D1				; D1-D0 X+Y				-> D1
	COMP.16		D0,D1				; Max prsum > D1-D0 X+Y
	JUMP,LS		L30$				; Oui => 30$
	EX.32		D1,D0				; Nouveau max prsum			-> D0
L30$:
	INC.16		D0				; On calcul une dim ! 			-> D0
	MOVE.16		{A0}+OSDIM+OX,D1		; Dim X rectangle source		-> D1
	COMP.16		D0,D1				; Max prsum > Dim X rectangle
	JUMP,LS		L40$				; Oui => 40$
	EX.32		D1,D0				; Max					-> D0
L40$:
	MOVE.16		D0,{A0}+ONBITX			; Init nb itration en X

						   ; Nb itration en Y =>
	MOVE.16		{A0}+OD2MD1+OX,D0		; D2-D1 X 				-> D0
	ABSF.16		D0
	MOVE.16		{A0}+OD2MD1+OY,D1		; D2-D1 Y				-> D1
	ABSF.16		D1
	ADD.16		D1,D0				; D2-D1 X+Y (max prsum)		-> D0

	MOVE.16		{A0}+ORD3+OX,D1			; D3-D0 X				-> D1
	ABSF.16		D1
	MOVE.16		D1,D2
	MOVE.16		{A0}+ORD3+OY,D1			; D3-D0 Y				-> D1
	ABSF.16		D1
	ADD.16		D2,D1				; D3-D0 X+Y				-> D1
	COMP.16		D0,D1				; Max prsum > D3-D0 X+Y
	JUMP,LS		L70$				; Oui => 70$
	EX.32		D1,D0				; Nouveau max prsum			-> D0
L70$:
	INC.16		D0				; On calcul une dim ! 			-> D0
	MOVE.16		{A0}+OSDIM+OY,D1		; Dim Y rectangle source		-> D1
	COMP.16		D0,D1				; Max prsum > Dim Y rectangle
	JUMP,LS		L80$				; Oui => 80$
	EX.32		D1,D0				; Max					-> D0
L80$:
	MOVE.16		D0,{A0}+ONBITY			; Init nb itration en Y
L90$:
	POPM.32		D0..D2
	RET



;--------------\\
;   DONBITRR	>
;--------------/

; Transf  rect -> rect
;
; Calcul le nombre d'itrations ncessaires en X et Y. Le nombre
; d'itrations en X est la longueur maximal de la projection sur
; un des axes de l'image des cts horizontaux source dans la 
; destination (respectivement verticaux pour Y).

; in	A0.32 : ^var
; out	-
; mod	F

DONBITRR:
	PUSHM.32	D0..D1
					   ; Nb itration en X =>
	MOVE.16		{A0}+OD2MD3+OX,D0		; D2-D3 X (max prsum)		-> D0
	ABSF.16		D0
	MOVE.16		{A0}+OD2MD3+OY,D1		; D2-D3 Y			-> D1
	ABSF.16		D1
	COMP.16		D0,D1				; Max prsum > D2-D3 Y
	JUMP,LS		L10$				; Oui => 10$
	EX.32		D1,D0				; Nouveau max prsum		-> D0
L10$:
	MOVE.16		{A0}+ORD1+OX,D1			; D1-D0 X 			-> D1
	ABSF.16		D1
	COMP.16		D0,D1				; Max prsum > D1-D0 X
	JUMP,LS		L20$				; Oui => 20$
	EX.32		D1,D0				; Nouveau max prsum		-> D0
L20$:
	MOVE.16		{A0}+ORD1+OY,D1			; D1-D0 Y			-> D1
	ABSF.16		D1
	COMP.16		D0,D1				; Max prsum > D1-D0 Y
	JUMP,LS		L30$				; Oui => 30$
	EX.32		D1,D0				; Nouveau max prsum		-> D0
L30$:
	INC.16		D0				; On calcul une dim !		-> D0
	MOVE.16		{A0}+OSDIM+OX,D1		; Dim X rectangle source	-> D1
	COMP.16		D0,D1				; Max prsum > Dim X rectangle
	JUMP,LS		L40$				; Oui => 40$
	EX.32		D1,D0				; Max				-> D0
L40$:
	MOVE.16		D0,{A0}+ONBITX			; Init nb itration en X

					   ; Nb itration en Y =>
	MOVE.16		{A0}+OD2MD1+OX,D0		; D2-D1 X (max prsum)		-> D0
	ABSF.16		D0
	MOVE.16		{A0}+OD2MD1+OY,D1		; D2-D1 Y			-> D1
	ABSF.16		D1
	COMP.16		D0,D1				; Max prsum > D2-D1 Y
	JUMP,LS		L50$				; Oui => 50$
	EX.32		D1,D0				; Nouveau max prsum		-> D0
L50$:
	MOVE.16		{A0}+ORD3+OX,D1			; D3-D0 X			-> D1
	ABSF.16		D1
	COMP.16		D0,D1				; Max prsum > D3-D0 X
	JUMP,LS		L60$				; Oui => 60$
	EX.32		D1,D0				; Nouveau max prsum		-> D0
L60$:
	MOVE.16		{A0}+ORD3+OY,D1			; D3-D0 Y			-> D1
	ABSF.16		D1
	COMP.16		D0,D1				; Max prsum > D3-D0 Y
	JUMP,LS		L70$				; Oui => 70$
	EX.32		D1,D0				; Nouveau max prsum		-> D0
L70$:
	INC.16		D0				; On calcul une dim !		-> D0
	MOVE.16		{A0}+OSDIM+OY,D1		; Dim Y rectangle source	-> D1
	COMP.16		D0,D1				; Max prsum > Dim Y rectangle
	JUMP,LS		L80$				; Oui => 80$
	EX.32		D1,D0				; Max				-> D0
L80$:
	MOVE.16		D0,{A0}+ONBITY			; Init nb itration en Y
L90$:
	POPM.32		D0..D1
	RET


;--------------\\
;    DOFINC	>
;--------------/

; Calcul les diffrents facteurs incrmentaux. 

; in	A0.32 : ^var
; out	D7.16 : Erreur
; mod	D7.16 , F

DOFINC:
	PUSHM.32	D0..D4

	CLR.32		D0				; Facteur X source     =>
	MOVE.16		{A0}+OSDIM+OX,D0		; Dim X rectangle source		-> D0
	SWAP.32		D0				; * 2**16				-> D0
	MOVE.16		{A0}+ONBITX,D2			; Nb itration en X			-> D2
	DIVA		D2,D0				; Facteur * 2**16 (0< <= 2**16)	-> D0
	MOVE.16		D0,{A0}+OSFIX			; Init facteur incrmental

					   ; facteur de Y pour X' =>
	MOVE.16		{A0}+ORD3+OX,D1			; D3x-D0x (PF dividente)		-> D1
	CONV.A16.32	D1				; Sign sur 32 bit
	CLR.32		D0				; Init Pf dividente			-> D0
	MOVE.16		{A0}+ONBITY,D2			; Nb itration en Y			-> D2
	DEC.16		D2				; On add incrment NBIT-1 fois !
	CALL		DIVS64
	MOVE.32		D3,{A0}+OXFIY+OLDLW		; Init facteur incrmental
	MOVE.32		D4,{A0}+OXFIY+OHDLW

					   ; facteur de X pour X' =>
	MOVE.16		{A0}+ORD1+OX,D1			; D1x-D0x (PF dividente)		-> D1
	CONV.A16.32	D1				; Sign sur 32 bit
	CLR.32		D0				; Init Pf dividente			-> D0
	MOVE.16		{A0}+ONBITX,D2			; Nb itration en X			-> D2
	DEC.16		D2				; On add incrment NBIT-1 fois !
	CALL		DIVS64
	MOVE.32		D3,{A0}+OXFIX+OLDLW		; Init facteur incrmental
	MOVE.32		D4,{A0}+OXFIX+OHDLW

					   ; facteur de XY pour X' =>
	MOVE.16		{A0}+OD2MD3+OX,D1		; D2x-D3x				-> D1
	SUB.16		{A0}+ORD1+OX,D1			;(D2x-D3x)-(D1x-D0x)			-> D1
	CONV.A16.32	D1				; Sign sur 32 bit
	CLR.32		D0				; Init Pf dividente 			-> D0
	MOVE.16		{A0}+ONBITX,D2			; Nb itration en X			-> D2
	DEC.16		D2				; On add incrment NBIT-1 fois !
	CALL		DIVS64
	MOVE.32		D3,D0				; Rsultat -> nouveau dividente
	MOVE.32		D4,D1
	MOVE.16		{A0}+ONBITY,D2			; Nb itration en Y			-> D2
	DEC.16		D2				; On add incrment NBIT-1 fois !
	CALL		DIVS64
	MOVE.32		D3,{A0}+OXFIXY+OLDLW		; Init facteur incrmental
	MOVE.32		D4,{A0}+OXFIXY+OHDLW



	CLR.32		D0				; Facteur Y source     =>
	MOVE.16		{A0}+OSDIM+OY,D0		; Dim Y rectangle source		-> D0
	SWAP.32		D0				; * 2**16				-> D0
	MOVE.16		{A0}+ONBITY,D2			; Nb itration en Y			-> D2
	DIVA		D2,D0				; Facteur * 2**16 (0< <= 2**16)	-> D0
	MOVE.16		D0,{A0}+OSFIY			; Init facteur incrmental

					   ; facteur de Y pour Y' =>
	MOVE.16		{A0}+ORD3+OY,D1			; D3y-D0y (PF dividente)		-> D1
	CONV.A16.32	D1				; Sign sur 32 bit
	CLR.32		D0				; Init Pf dividente			-> D0
	MOVE.16		{A0}+ONBITY,D2			; Nb itration en Y			-> D2
	DEC.16		D2				; On add incrment NBIT-1 fois !
	CALL		DIVS64
	MOVE.32		D3,{A0}+OYFIY+OLDLW		; Init facteur incrmental
	MOVE.32		D4,{A0}+OYFIY+OHDLW

					   ; facteur de X pour Y' =>
	MOVE.16		{A0}+ORD1+OY,D1			; D1y-D0y (PF dividente)		-> D1
	CONV.A16.32	D1				; Sign sur 32 bit
	CLR.32		D0				; Init Pf dividente			-> D0
	MOVE.16		{A0}+ONBITX,D2			; Nb itration en X			-> D2
	DEC.16		D2				; On add incrment NBIT-1 fois !
	CALL		DIVS64
	MOVE.32		D3,{A0}+OYFIX+OLDLW		; Init facteur incrmental
	MOVE.32		D4,{A0}+OYFIX+OHDLW

					   ; facteur de XY pour Y' =>
	MOVE.16		{A0}+OD2MD1+OY,D1		; D2y-D1y				-> D1
	SUB.16		{A0}+ORD3+OY,D1			;(D2y-D1y)-(D3y-D0y)			-> D1
	CONV.A16.32	D1				; Sign sur 32 bit
	CLR.32		D0				; Init Pf dividente			-> D0
	MOVE.16		{A0}+ONBITX,D2			; Nb itration en X			-> D2
	DEC.16		D2				; On add incrment NBIT-1 fois !
	CALL		DIVS64
	MOVE.32		D3,D0				; Rsultat -> nouveau dividente
	MOVE.32		D4,D1
	MOVE.16		{A0}+ONBITY,D2			; Nb itration en Y			-> D2
	DEC.16		D2				; On add incrment NBIT-1 fois !
	CALL		DIVS64
	MOVE.32		D3,{A0}+OYFIXY+OLDLW		; Init facteur incrmental
	MOVE.32		D4,{A0}+OYFIXY+OHDLW
	POPM.32		D0..D4
	RET



;--------------\\
;  GETMEMPOS	>
;--------------/

; Retourne les paramtres pour accder un point en mmoire.

; in	D4.16 : Dim matrice source en byte
;	D5.32 : Coor point (y,x)
;	A4.32 : ^matrice
; out	A4.32 : ^byte
;	D5.32 : No bit (b7  droite)
; mod	D5.32 , A4.32 , F

GETMEMPOS:
	PUSHM.32	D4|D6
	SWAP.32		D5				; Coor Y				-> D5l
	MUL.16		D5,D4				; Offset dbut ligne coor Y		-> D4
	SWAP.32		D5

	MOVE.16		D5,D6				; Coor X				-> D6
	SR.16		#3,D6				; Offset byte depuis dbut ligne		-> D6
	ADD.32		D4,A4				; ^dbut ligne coor Y			-> A4
	ADD.A16		D6,A4				; ^byte					-> A4
	AND.32		#16'7,D5			; No bit				-> D5
	NEG.32		D5				; 0..7  -> 0..-7
	ADD.32		#7,D5				; 0..-7 -> 7..0
	POPM.32		D4|D6
	RET


.if	VersCouleur

;--------------\\
;  GETMEMPOSc	>
;--------------/

; Retourne les paramtres pour accder un point en mmoire.

; in	D4.16 : Dim matrice source en byte
;	D5.32 : Coor point (y,x)
;	A4.32 : ^matrice
; out	A4.32 : ^byte
;	D5.32 : ... | octet destination | No bit (b7  droite)
; mod	D5.32 , A4.32 , F

GETMEMPOSc:
	PUSHM.32	D4|D6
	SWAP.32		D5				; Coor Y				-> D5l
	MUL.16		D5,D4				; Offset dbut ligne coor Y		-> D4
	SWAP.32		D5

	MOVE.16		D5,D6				; Coor X				-> D6
;	SR.16		#3,D6				; Offset byte depuis dbut ligne		-> D6
	SR.16		#1,D6
	ADD.32		D4,A4				; ^dbut ligne coor Y			-> A4
	ADD.A16		D6,A4				; ^byte					-> A4
;	AND.32		#16'7,D5			; No bit				-> D5
	AND.32		#16'1,D5			; No bit				-> D5
	SL.32		#2, D5				; 0 -> 0 et 1 -> 4
	NEG.32		D5				; 0..4  -> 0..-4
	ADD.32		#4,D5				; 0..-4 -> 4..0
	POPM.32		D4|D6
	RET
.endif


;--------------\\
;    DIVS64	>
;--------------/

; Division signe d'un dividente de 64 bits par un diviseur de 16 bits.
; La division est effectue avec arrondi.

; in	D0.32 : Pf dividente
;	D1.32 : PF dividente
;	D2.16 : Diviseur
; out	D3.32 : Pf rsultat
;	D4.32 : PF rsultat
; mod	D7.16 , F

DIVS64:
	PUSHM.32	D0..D2|D5..D6
	MOVE.16		D2,D6
	CONV.A16.32	D6				; Si le dividente et le diviseur sont
	XOR.32		D1,D6				; diffrent le bit de signe de D6 est  1

						; Test signe dividente =>
	TEST.32		D1				; dividente ngatif ?
	JUMP,PL		L10$				; Non => 10$
	NEG.32		D0				; Pf positif dividente			-> D0
	NEGX.32		D1				; PF positif dividente			-> D1

L10$:
	TEST.16		D2				; Test signe diviseur =>
	JUMP,EQ		L90$				; Nul => 90$
	JUMP,PL		L20$				; Pos => 20$
	NEG.16		D2				; Diviseur positif			-> D2

L20$:							; Ici on divise des nombres positifs =>
	CLR.32		D5				; Effectue la correction pour l'arrondi
	MOVE.16		D2,D5				; Diviseur				-> D5
	SR.16		#1,D5				; 0.5*diviseur				-> D5
	ADD.32		D5,D0
	CLR.32		D5
	ADDX.32		D5,D1

	CLR.32		D3				; Init rsultat et var intermdiaire
	CLR.32		D4
	CLR.32		D5


	COMP.32		#16'FFFF,D1			; Dtermination taille dividente =>
	JUMP,HI		L30$				; 64 bits => 30$
	TEST.16		D1
	JUMP,NE		L40$				; 48 bits => 40$
	COMP.32		#16'FFFF,D0
	JUMP,HI		L50$				; 32 bits => 50$
	TEST.16		D0
	JUMP,NE		L60$				; 16 bits => 60$
	JUMP		L70$				; 0  bits => 70$


L30$:							; Bits 48..63 =>
	SWAP.32		D1
; DD	MOVE.32		D1,D5				; PF dividente				-> D5
	MOVE.16		D1,D5	; DD
	SWAP.32		D1
	DIV.16		D2,D5
	MOVE.16		D5,D4				; Bits 48..63 rsultat			-> D4
	SWAP.32		D4

L40$:							; Bits 32..47 =>
	MOVE.16		D1,D5				; Bits 32..47 dividente 		-> D5
	DIV.16		D2,D5
	MOVE.16		D5,D4				; Bits 32..47 rsultat			-> D4

L50$:							; Bits 16..31 =>
	SWAP.32		D0
	MOVE.16		D0,D5				; Bits 16..31 dividente			-> D5
	SWAP.32		D0
	DIV.16		D2,D5
	MOVE.16		D5,D3				; Bits 16..31 rsultat			-> D3
	SWAP.32		D3

L60$:							; Bits 0..15 => 
	MOVE.16		D0,D5				; Bits 0..15 dividente			-> D5
	DIV.16		D2,D5
	MOVE.16		D5,D3				; Bits 0..15 rsultat			-> D3


L70$:							; Rend rsultat ngatif si ncessaire
	TEST.32		D6				; Diviseur et dividente de mme signe ?
	JUMP,NC		L90$				; Oui => 90$
	NEG.32		D3				; Pf positif rsultat			-> D3
	NEGX.32		D4				; PF positif rsultat			-> D4
	JUMP		L90$

L80$:
	CLR.32		D3				; Si diviseur nul =>
	CLR.32		D4

L90$:
	POPM.32		D0..D2|D5..D6
	TEST.16		D7
	RET

.if	VersCouleur

; table de mixage par dfaut
; ==========================
TableCouleur:		; DDDD		; dddd ssss

; fond blanc est remplac par la couleur source
	.8		2'0000		; 0000 0000
	.8		2'0001		; 0000 0001
	.8		2'0010		; 0000 0010
	.8		2'0011		; 0000 0011
	.8		2'0100		; 0000 0100
	.8		2'0101		; 0000 0101
	.8		2'0110		; 0000 0110
	.8		2'0111		; 0000 0111
	.8		2'1000		; 0000 1000
	.8		2'1001		; 0000 1001
	.8		2'1010		; 0000 1010
	.8		2'1011		; 0000 1011
	.8		2'1100		; 0000 1100
	.8		2'1101		; 0000 1101
	.8		2'1110		; 0000 1110
	.8		2'1111		; 0000 1111

; couleur de fond reste sauf pour le noir
	.8		2'0001		; 0001 0000
	.8		2'0001		; 0001 0001
	.8		2'0001		; 0001 0010
	.8		2'0001		; 0001 0011
	.8		2'0001		; 0001 0100
	.8		2'0001		; 0001 0101
	.8		2'0001		; 0001 0110
	.8		2'0001		; 0001 0111
	.8		2'0001		; 0001 1000
	.8		2'0001		; 0001 1001
	.8		2'0001		; 0001 1010
	.8		2'0001		; 0001 1011
	.8		2'0001		; 0001 1100
	.8		2'0001		; 0001 1101
	.8		2'0001		; 0001 1110
	.8		2'1111		; 0001 1111

	.8		2'0010		; 0010 0000
	.8		2'0010		; 0010 0001
	.8		2'0010		; 0010 0010
	.8		2'0010		; 0010 0011
	.8		2'0010		; 0010 0100
	.8		2'0010		; 0010 0101
	.8		2'0010		; 0010 0110
	.8		2'0010		; 0010 0111
	.8		2'0010		; 0010 1000
	.8		2'0010		; 0010 1001
	.8		2'0010		; 0010 1010
	.8		2'0010		; 0010 1011
	.8		2'0010		; 0010 1100
	.8		2'0010		; 0010 1101
	.8		2'0010		; 0010 1110
	.8		2'1111		; 0010 1111

	.8		2'0011		; 0011 0000
	.8		2'0011		; 0011 0001
	.8		2'0011		; 0011 0010
	.8		2'0011		; 0011 0011
	.8		2'0011		; 0011 0100
	.8		2'0011		; 0011 0101
	.8		2'0011		; 0011 0110
	.8		2'0011		; 0011 0111
	.8		2'0011		; 0011 1000
	.8		2'0011		; 0011 1001
	.8		2'0011		; 0011 1010
	.8		2'0011		; 0011 1011
	.8		2'0011		; 0011 1100
	.8		2'0011		; 0011 1101
	.8		2'0011		; 0011 1110
	.8		2'1111		; 0011 1111

	.8		2'0100		; 0100 0000
	.8		2'0100		; 0100 0001
	.8		2'0100		; 0100 0010
	.8		2'0100		; 0100 0011
	.8		2'0100		; 0100 0100
	.8		2'0100		; 0100 0101
	.8		2'0100		; 0100 0110
	.8		2'0100		; 0100 0111
	.8		2'0100		; 0100 1000
	.8		2'0100		; 0100 1001
	.8		2'0100		; 0100 1010
	.8		2'0100		; 0100 1011
	.8		2'0100		; 0100 1100
	.8		2'0100		; 0100 1101
	.8		2'0100		; 0100 1110
	.8		2'1111		; 0100 1111

	.8		2'0101		; 0101 0000
	.8		2'0101		; 0101 0001
	.8		2'0101		; 0101 0010
	.8		2'0101		; 0101 0011
	.8		2'0101		; 0101 0100
	.8		2'0101		; 0101 0101
	.8		2'0101		; 0101 0110
	.8		2'0101		; 0101 0111
	.8		2'0101		; 0101 1000
	.8		2'0101		; 0101 1001
	.8		2'0101		; 0101 1010
	.8		2'0101		; 0101 1011
	.8		2'0101		; 0101 1100
	.8		2'0101		; 0101 1101
	.8		2'0101		; 0101 1110
	.8		2'1111		; 0101 1111

	.8		2'0110		; 0110 0000
	.8		2'0110		; 0110 0001
	.8		2'0110		; 0110 0010
	.8		2'0110		; 0110 0011
	.8		2'0110		; 0110 0100
	.8		2'0110		; 0110 0101
	.8		2'0110		; 0110 0110
	.8		2'0110		; 0110 0111
	.8		2'0110		; 0110 1000
	.8		2'0110		; 0110 1001
	.8		2'0110		; 0110 1010
	.8		2'0110		; 0110 1011
	.8		2'0110 		; 0110 1100
	.8		2'0110		; 0110 1101
	.8		2'0110		; 0110 1110
	.8		2'1111		; 0110 1111

	.8		2'0111		; 0111 0000
	.8		2'0111		; 0111 0001
	.8		2'0111		; 0111 0010
	.8		2'0111		; 0111 0011
	.8		2'0111		; 0111 0100
	.8		2'0111		; 0111 0101
	.8		2'0111		; 0111 0110
	.8		2'0111		; 0111 0111
	.8		2'0111		; 0111 1000
	.8		2'0111		; 0111 1001
	.8		2'0111 		; 0111 1010
	.8		2'0111 		; 0111 1011
	.8		2'0111		; 0111 1100
	.8		2'0111		; 0111 1101
	.8		2'0111		; 0111 1110
	.8		2'1111		; 0111 1111

	.8		2'1000		; 1000 0000
	.8		2'1000		; 1000 0001
	.8		2'1000		; 1000 0010
	.8		2'1000		; 1000 0011
	.8		2'1000		; 1000 0100
	.8		2'1000		; 1000 0101
	.8		2'1000		; 1000 0110
	.8		2'1000		; 1000 0111
	.8		2'1000		; 1000 1000
	.8		2'1000		; 1000 1001
	.8		2'1000		; 1000 1010
	.8		2'1000		; 1000 1011
	.8		2'1000		; 1000 1100
	.8		2'1000		; 1000 1101
	.8		2'1000		; 1000 1110
	.8		2'1111		; 1000 1111

	.8		2'1001		; 1001 0000
	.8		2'1001		; 1001 0001
	.8		2'1001		; 1001 0010
	.8		2'1001		; 1001 0011
	.8		2'1001		; 1001 0100
	.8		2'1001		; 1001 0101
	.8		2'1001		; 1001 0110
	.8		2'1001		; 1001 0111
	.8		2'1001		; 1001 1000
	.8		2'1001		; 1001 1001
	.8		2'1001		; 1001 1010
	.8		2'1001		; 1001 1011
	.8		2'1001		; 1001 1100
	.8		2'1001		; 1001 1101
	.8		2'1001		; 1001 1110
	.8		2'1111		; 1001 1111

	.8		2'1010		; 1010 0000
	.8		2'1010		; 1010 0001
	.8		2'1010		; 1010 0010
	.8		2'1010		; 1010 0011
	.8		2'1010		; 1010 0100
	.8		2'1010		; 1010 0101
	.8		2'1010		; 1010 0110
	.8		2'1010		; 1010 0111
	.8		2'1010		; 1010 1000
	.8		2'1010		; 1010 1001
	.8		2'1010		; 1010 1010
	.8		2'1010		; 1010 1011
	.8		2'1010		; 1010 1100
	.8		2'1010		; 1010 1101
	.8		2'1010		; 1010 1110
	.8		2'1111		; 1010 1111

	.8		2'1011		; 1011 0000
	.8		2'1011		; 1011 0001
	.8		2'1011		; 1011 0010
	.8		2'1011		; 1011 0011
	.8		2'1011		; 1011 0100
	.8		2'1011		; 1011 0101
	.8		2'1011		; 1011 0110
	.8		2'1011		; 1011 0111
	.8		2'1011		; 1011 1000
	.8		2'1011		; 1011 1001
	.8		2'1011		; 1011 1010
	.8		2'1011		; 1011 1011
	.8		2'1011		; 1011 1100
	.8		2'1011		; 1011 1101
	.8		2'1011		; 1011 1110
	.8		2'1111		; 1011 1111

	.8		2'1100		; 1100 0000
	.8		2'1100		; 1100 0001
	.8		2'1100		; 1100 0010
	.8		2'1100		; 1100 0011
	.8		2'1100		; 1100 0100
	.8		2'1100		; 1100 0101
	.8		2'1100		; 1100 0110
	.8		2'1100		; 1100 0111
	.8		2'1100		; 1100 1000
	.8		2'1100		; 1100 1001
	.8		2'1100		; 1100 1010
	.8		2'1100		; 1100 1011
	.8		2'1100		; 1100 1100
	.8		2'1100		; 1100 1101
	.8		2'1100		; 1100 1110
	.8		2'1111		; 1100 1111

	.8		2'1101		; 1101 0000
	.8		2'1101		; 1101 0001
	.8		2'1101		; 1101 0010
	.8		2'1101		; 1101 0011
	.8		2'1101		; 1101 0100
	.8		2'1101		; 1101 0101
	.8		2'1101		; 1101 0110
	.8		2'1101		; 1101 0111
	.8		2'1101		; 1101 1000
	.8		2'1101		; 1101 1001
	.8		2'1101		; 1101 1010
	.8		2'1101		; 1101 1011
	.8		2'1101		; 1101 1100
	.8		2'1101		; 1101 1101
	.8		2'1101		; 1101 1110
	.8		2'1111		; 1101 1111

	.8		2'1110		; 1110 0000
	.8		2'1110		; 1110 0001
	.8		2'1110		; 1110 0010
	.8		2'1110		; 1110 0011
	.8		2'1110		; 1110 0100
	.8		2'1110		; 1110 0101
	.8		2'1110		; 1110 0110
	.8		2'1110		; 1110 0111
	.8		2'1110		; 1110 1000
	.8		2'1110		; 1110 1001
	.8		2'1110		; 1110 1010
	.8		2'1110		; 1110 1011
	.8		2'1110		; 1110 1100
	.8		2'1110		; 1110 1101
	.8		2'1110		; 1110 1110
	.8		2'1111		; 1110 1111

; noir crase toutes les couleurs
	.8		2'1111		; 1111 0000
	.8		2'1111		; 1111 0001
	.8		2'1111		; 1111 0010
	.8		2'1111		; 1111 0011
	.8		2'1111		; 1111 0100
	.8		2'1111		; 1111 0101
	.8		2'1111		; 1111 0110
	.8		2'1111		; 1111 0111
	.8		2'1111		; 1111 1000
	.8		2'1111		; 1111 1001
	.8		2'1111		; 1111 1010
	.8		2'1111		; 1111 1011
	.8		2'1111		; 1111 1100
	.8		2'1111		; 1111 1101
	.8		2'1111		; 1111 1110
	.8		2'1111		; 1111 1111

.endif


ENDSTRETCH:
	.END


