\define g_Fond:\nef11;
\define g_Evidence:\n(bf)09;

	.TITLE	\g_Evidence;SYSEV\g_Fond;.ASL

;	----------------------------------------
;		(C) 1998 - Pierre ARNAUD
;	----------------------------------------

REVMAJ	= 0
REVMIN	= 1

;	Date      Rv	Commentaire
;	-------------------------------------------------------------------------------
;	03/04/98  0.1	Premire version
;	-------------------------------------------------------------------------------


	.PROC	M68000
	.REF	SMAKY
	.REF	DOLIB
	.REF	SYSEV
	.REF	MON

	.REV	REVMAJ, REVMIN
	.CODE	800,11,2'000111,600,2000,300,2000,2,"N","E","F",11
	.IDENT	"(C) Copyright 1998, Pierre ARNAUD et EPSITEC SA"
	.START	-1

MAXLSN	= 100

;	Description d'un processus intress (listener)
;	------------------------------------

		.LOC	0

OlsnBAR:	.BLK.32	1		; BAR pour synchroniser
OlsnMASK:	.BLK.32	1		; masque des vnements intressants
OlsnPID:	.BLK.16	1		; numro du processus
		.BLK.16	1		; rserve
OlsnNAME:	.BLK.32	1		; nom du listener
LGlsnREC:


;	Variables d'un canal
;	--------------------

		.LOC	0

OVARLOCK:	.BLK.32	1		; smaphore d'accs
OLSNTABLE:	.BLK.8	MAXLSN*LGlsnREC	; table des listeners
LGVAR:



;	En-tte du module de librairie
;	------------------------------

	.LOC	0

BASE:	.16	SYSEV_FIRST
	.16	SYSEV_LAST
	.8	0
	.FILL.8	(OHLREV-APC),0
	.8	REVMAJ,REVMIN
	.32	END_MODULE
	.32	PATHLIB
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"SYSEV"
	.FILL.8	(LGHLIB-APC),0

	.16	_SYSEV_OPEN
	.16	_SYSEV_CLOSE
	.16	_SYSEV_REGISTER
	.16	_SYSEV_UNREGISTER
	.16	_SYSEV_NOTIFY

;-------------\\
;  SYSEV_OPEN  >
;=============/

; Ouvre le gestionnaire des vnements systme.

; in	D2.32	mode (0)
; out	D5.32	canal
;	D7.16	erreur
; mod	D5.32, D7.16

_SYSEV_OPEN:
	PUSHM.32 D4|A4|A5|A6

	MOVE.32	#0,D5
	MOVE.32	#R16^BASE,A4
	MOVE.32	#LGVAR+2**31,D4
	FOS	?GETCOMMEM
	JUMP,NE	ERR$

	MOVE.32	A4,A6
	NTREL	?LOCK
	JUMP,NE	ERR$

	TEST.32	{A6}+OVARLOCK			; dj initialis ?
	JUMP,T	R8^EXIT$			; oui => OK
	MOVE.32	A5,{A6}+OVARLOCK		; non => prend note du smaphore

EXIT$:	NTREL	?UNLOCK
	MOVE.32	A6,D5				; variables = canal

ERR$:	POPM.32	D4|A4|A5|A6
	TEST.16	D7
	RET


;--------------\\
;  SYSEV_CLOSE  >
;==============/

; Ferme un canal ouvert au moyen de SYSEV_OPEN.

; in	D5.32	canal
; out	D7.16	ok/erreur
; mod	D7.16

_SYSEV_CLOSE:
	CLR.16	D7
	RET


;-----------------\\
;  SYSEV_REGISTER  >
;=================/

; Enregistre que le processus appelant est intress  recevoir
; des vnements (masque spcifi en entre).

; in	D2.32	mode (0)
;	D4.32	masque des vnements
;	A3.32	^nom de l'entit (par ex. "le service REMOTE" ou
;		"l'application CARLA", etc.) -- ce nom n'est pas
;		copi; le pointeur est utilis tel quel.
;	D5.32	canal
; out	A5.32	canal BAR  utiliser pour recevoir les vnements
;	D7.16	ok/erreur
; mod	A5.32, D7.16

_SYSEV_REGISTER:
	PUSHM.32 D3|D4|A2..A4|A6

	MOVE.16	#ERSEILMASK,D7
	TEST.32	D4				; masque correct ?
	JUMP,F	ERR$				; non => erreur

	MOVE.16	#ERSEILMODE,D7
	TEST.32	D2				; mode correct ?
	JUMP,T	ERR$				; non => erreur

	MOVE.32	A3,A2
	MOVE.32	D5,A6
	MOVE.32	{A6}+OVARLOCK,A5
	NTREL	?LOCK
	JUMP,NE	ERR$

	MOVE.32	#MAXLSN-1,D3
	MOVE.32	#{A6}+OLSNTABLE,A3		; cherche un "slot" libre

LOOP$:	TEST.32	{A3}+OlsnBAR
	JUMP,T	R8^NEXT$

	MOVE.32	A3,A4				; <-- ^slot
	MOVE.32	D4,D3				; <-- masque

	MOVE.32	#R16^NMNULL,A3
	MOVE.32	#0,D4
	NTREL	?CREBAR
	JUMP,NE	R8^EXIT$

	NTREL	?GTPNUM

	MOVE.32	A2,{A4}+OlsnNAME		; enregistre le nom
	MOVE.32	A5,{A4}+OlsnBAR			; enregistre BAR
	MOVE.32	D3,{A4}+OlsnMASK		; enregistre le masque d'vnements
	MOVE.16	D4,{A4}+OlsnPID			; enregistre le numro de processus associ
	JUMP	R8^EXIT$

NEXT$:	ADD.A16	#LGlsnREC,A3
	DJ.16,NMO D3,LOOP$

	MOVE.16	#ERSEFULL,D7			; "plein"

EXIT$:	PUSHM.32 D7|A5
	MOVE.32	{A6}+OVARLOCK,A5
	NTREL	?UNLOCK
	POPM.32	D7|A5

ERR$:	POPM.32	D3|D4|A2..A4|A6
	TEST.16	D7
	RET



;-------------------\\
;  SYSEV_UNREGISTER  >
;===================/

; Le processus appelant n'est plus intress  recevoir
; des vnements.

; in	D2.32	mode (0)
;	D5.32	canal
; out	D7.16	ok/erreur
; mod	D7.16

_SYSEV_UNREGISTER:
	PUSHM.32 D3|D4|A3|A5|A6

	MOVE.16	#ERSEILMODE,D7
	TEST.32	D2				; mode correct ?
	JUMP,T	ERR$				; non => erreur

	MOVE.32	D5,A6
	MOVE.32	{A6}+OVARLOCK,A5
	NTREL	?LOCK
	JUMP,NE	ERR$

	NTREL	?GTPNUM

	MOVE.32	#MAXLSN-1,D3
	MOVE.32	#{A6}+OLSNTABLE,A3		; cherche le "slot" correspondant
	MOVE.16	#ERSEEDNE,D7			; "entit n'existe pas"

LOOP$:	TEST.32	{A3}+OlsnBAR
	JUMP,F	R8^NEXT$

	COMP.16	{A3}+OlsnPID,D4			; trouv le bon slot ?
	JUMP,NE	R8^NEXT$			; non => suite

	MOVE.32	{A3}+OlsnBAR,A5			; BAR  supprimer
	NTREL	?KILLBAR

	CLR.16	{A3}+OlsnPID
	CLR.32	{A3}+OlsnBAR
	CLR.32	{A3}+OlsnMASK

NEXT$:	ADD.A16	#LGlsnREC,A3
	DJ.16,NMO D3,LOOP$

EXIT$:	MOVE.16	D7,D3
	MOVE.32	{A6}+OVARLOCK,A5
	NTREL	?UNLOCK
	MOVE.16	D3,D7

ERR$:	POPM.32	D3|D4|A3|A5|A6
	TEST.16	D7
	RET


;---------------\\
;  SYSEV_NOTIFY  >
;===============/

; Signale un vnement de type "shutdown". Le time-out actif est
; utilis pour dterminer combien de temps on attend la rponse
; initiale de chaque service.
;
; Un seul processus peut faire un NOTIFY  la fois. Tous les autres
; appels au module seront bloqus tant que le NOTIFY ne s'est pas
; termin.

; in	D2.32	mode (0)
;	D4.32	vnement (un seul bit SVP)
;	D5.32	canal
; out	A3.32	^nom du premier "listener" ayant retourn une erreur
;	D7.16	erreur (dans l'ordre des priorits)
;		#ERSEDENY, au moins un "listener" a refus l'vnement.
;		#ERSEWAIT, au moins un "listener" a demand un sursis.
;		#ERTIMO, time-out, certains "listeners" n'ont pas rpondu
;		dans le dlai imparti (plants/occups). C'est le time-out
;		de l'appelant qui est utilis comme rfrence.
;		...autre...
; mod	D7.16, A3

_SYSEV_NOTIFY:
	PUSHM.32 D0..D4|A2|A4..A6

	MOVE.16	#ERSEILMASK,D7
	MOVE.32	D4,D0				; masque correct ?
	JUMP,F	ERR$				; non => erreur

	MOVE.16	#ERSEILMODE,D7
	TEST.32	D2				; mode correct ?
	JUMP,T	ERR$				; non => erreur

	MOVE.32	D5,A6
	MOVE.32	{A6}+OVARLOCK,A5
	NTREL	?LOCK
	JUMP,NE	ERR$

	MOVE.32	#MAXLSN-1,D3
	MOVE.32	#{A6}+OLSNTABLE,A3		; cherche les "slots" occups
	MOVE.32	#0,D2				; erreurs...
	MOVE.32	D2,A2				; pas de ^nom de listener

LOOP$:	MOVE.32	{A3}+OlsnMASK,D1
	AND.32	D0,D1				; intress  notre vnement ?
	JUMP,F	R8^NEXT$			; non => suite

	MOVE.32	{A3}+OlsnBAR,A5			; BAR  signaler
	NTREL	?OFFERBAR			; y a-t-il quelqu'un ?
	JUMP,EQ	R8^OFFER$			; oui => bon signe
	TSET.32	D2:#0				; non => erreur de time-out
	JUMP	R8^REG$

OFFER$:	MOVE.32	#-1,D4
	NTREL	?MODTIM
	MOVE.32	D1,A4				; vnement  transmettre
	NTREL	?ENDOFFERBAR			; attend indfiniment la rponse
	NTREL	?SETTIM

	MOVE.32	A4,D1				; analyse la rponse
	COMP.16	#SEdoDENY,D1			; refus catgorique ?
	JUMP,EQ	R8^doDENY$			; oui => arrte tout de suite
	COMP.16	#SEdoWAIT,D1			; sursis demand ?
	JUMP,NE	R8^NEXT$			; non => suite
	TSET.32	D2:#1				; oui => prend note

REG$:	MOVE.32	A2,D1				; y a-t-il dj un listener "erronn" ?
	JUMP,T	R8^NEXT$			; oui => laisse l'ancien
	MOVE.32	{A3}+OlsnNAME,A2		; non => prend ce nom

NEXT$:	ADD.A16	#LGlsnREC,A3
	DJ.16,NMO D3,LOOP$

	TEST.32	D2:#1				; y a-t-il eu des "sursis" ?
	JUMP,T	R8^doWAIT$			; oui => signale l'erreur
	TEST.32	D2:#0				; y a-t-il eu une erreur de time-out ?
	JUMP,T	R8^doTIME$			; oui => signale l'erreur
	JUMP	R8^EXIT$

doDENY$:
	MOVE.32	{A3}+OlsnNAME,A2
	MOVE.16	#ERSEDENY,D7			; erreur "refus catgorique"
	JUMP	R8^EXIT$

doWAIT$:
	MOVE.16	#ERSEWAIT,D7			; erreur "sursis demand"
	JUMP	R8^EXIT$

doTIME$:
	MOVE.16	#ERTIMO,D7			; erreur "time-out"

EXIT$:	MOVE.16	D7,D3
	MOVE.32	{A6}+OVARLOCK,A5
	NTREL	?UNLOCK
	MOVE.16	D3,D7
	MOVE.32	A2,A3

ERR$:	POPM.32	D0..D4|A2|A4..A6
	TEST.16	D7
	RET



NMNULL:	.ASCIZ	""
	.EVEN

END_MODULE:

	.END

