
	.TITLE	TCOLOR.ASL

;	-----------------------------------------------
;	    (C) Copyright 1990-1991 - Daniel Roux
;	    (C) Copyright 1992-1997 - Pierre Arnaud
;	-----------------------------------------------

;	Source du module SMA_TCOLOR.LIB

MAJREV	= 2
MINREV	= 1


;	Date		Amliorations
; -------------------------------------------------------------------------------
; 2.1	22.08.97  PA:	Supprim code de debug introduit avec la version 2.0.
; 2.0	12.08.97  PA:	OK avec systme 10.7.
; 1.19	20.06.97  PA:	Imprime correctement (OPEBITMAP en couleur conserve
;			la palette 16/256 couleurs => problme).
; 1.18	23.05.97  PA:	Sauve les registres dans PSS$/TABSRCCA  cause d'un
;			bug de PROF. Grrr.
; 1.17	21.03.97  PA:	Version gnralise de NoCLUTSrcCA (fonctionne aussi
;			avec la carte Alpine). Le champ ODFPIXORG dfinit
;			l'organisation mmoire (big/little endian).
; 1.16	19.11.96  PA:	SAVECLUT retourne les 256 couleurs si demand.
; 1.15	06.11.96  PA:	Utilise vraiment 256 couleurs (palette quilibre).
; 1.14	30.08.96  PA:	SRCCLUT ok si CLUT avec ODFCNP > 8.
; 1.13  14.08.96  PA:	SAVECLUT avec CLUT de plus de 16 couleurs limite  16
;			pour viter de nombreuses incompatibilits.
; 1.12	01.08.96  PA:	SRCCLUT sans CLUT possible (ODFCNP > 8)
; 1.11	09.05.95  PA:	modifi gestion des couleurs relatives pour grer
;			le monochrome (bits 31..24 du "nom").
; 1.10  05.05.95  PA:	plus de TRAP #0
; 1.9	25.01.95  DM:	suppression du concept de CLUT globale, des appels
;			ACTIVE/GETACTIVE, des modes BTCACTIVE/BTCGLOB.
;			version machine indpendante, ne fonctionnera pas
;			sur Smaky 300 avant que le systme 10 n'y soit port.
; 1.8	12.12.94  DM:	suppression mise  jour hard CLUT si profondeur > 8.
; 1.7	17.08.94  PA:	mchant bug dans CLUTMEM (5h de recherche).
; 1.6	12.08.94  PA:	modifi politique de modif. de la CLUT de $HWDIS.
; 1.5	22.07.94  DM:	corrig mon gros bug dans OPEN.
;		  DM:	TCOL_ACTIVE ne fait plus le HARDMAJCLUT sur SM130.
; 1.4	16.07.94  DM:	utilise HWDIS sur Smaky 130.
; 1.3	17.07.93  DM:	HARDSETCLUT ne rendait pas la gestion du TRAP #15 !
;		  DM:	adaptation Smaky 130 avec carte d'extension couleur
; 1.2	03.10.92  PA:	TCOL_LISTCRET n'endommage plus A6
; 1.1	16.08.91  DR:	TCOL_LOADCLUT si GLOBAL => modifie aussi CLUT locale
; 1.0	?	  JFG:	?
; 0.5	20.03.91  JFG:	TCOL_CLOSE modifiait A1 !
; 0.4	18.03.91  JFG:	vrification de la validit du canal du module
; 0.3	12.12.90	compte mmoire priv
; 0.2	23.11.90	mode BTCACTIVE
; 0.1	15.11.90	dbut des travaux ...
; -------------------------------------------------------------------------------

	.PROC	M68020 		; mnmonics CALM 2
	.BASE	10'10		; base 10 par dfaut
	.LAYOUT HEX		; listing en hexadcimal

	.REF	SMAKY
	.REF	DOLIB
	.REF	TCOLOR
	.REF	HWDIS

BTCBUFSIZE =	16		; taille du buffer donne

; Assemblage conditionnel
; -----------------------

Debug		= FALSE;.or.true

	.IF	Debug.OR.TRUE
	.REF	MON
	.ENDIF


	.REV	MAJREV,MINREV
	.IDENT	"(C)  Daniel ROUX, Pierre ARNAUD et EPSITEC SA"


; Constantes
; ----------

MAXGCRET =	100		; nb max de CRET globales
MAXLCRET =	20		; nb max de CRET pour un TCOL_OPEN
RESERVE	 =	20		; rserve avant d'agrandir la mmoire @PA



; Description d'un fichier .CLUT/.CRET
; ------------------------------------

OCTNBM	=	LCTHEAD-2	; nb max (interne)


; Champs privs du descripteur (ne pas exporter)
; ----------------------------------------------

		.LOC	ODFVAR
ODFCHHWD:	.BLK.16	1	; canal FOS pour HWDIS
		.BLK.8	1	; flags internes
ODFPIXORG:	.BLK.8	1	; organisation mmoire (0 => [RGB])
ODFCHDM:	.BLK.32	1	; canal du display manager
ODFPMID:	.BLK.32	1	; ID de pixmap


; Variables locales en (A5)
; -------------------------

		.LOC	0

OLPPSS:		.BLK.8	4			; ^procdure de recherche spciale dans CLUT
OLPGLOB:	.BLK.8	4			; ^variables globales
OLPCLUT:	.BLK.8	4			; ^table CLUT
OLPCRET:	.BLK.8	4*MAXLCRET		; ^tables CRET
OLPLOC:		.BLK.8	4			; ^var. locales pour vrifier la validit du canal
OLPDESC:	.BLK.32	1			; ^desc d'cran associ
OLPPMID:	.BLK.32	1			; ID du pixmap associ  l'cran @PA
OL256CLUT:	.BLK.8	LCTHEAD+256*LCTDATA	; table des 256 couleurs
LGVLOC:




; Variables globales en (A6)
; --------------------------

		.LOC	0
OGPACC:		.BLK.32	1			; ^compte mmoire priv
OGPSEM:		.BLK.32	1			; ^smaphore de bloquage
OGPCRET:	.BLK.32	MAXGCRET		; ^tables CRET
OGBuffCLUT:	.BLK.32 16			; buffer pour tranformer la CLUT
LGVGLOB:



	.MACRO	_Debug		; Texte
	.IF	Debug
	PUSH.16	F
	PUSHM.32 D3|D7
	MON	?AFTIM
	.ASCIZE	"{%1} "
;;;;	MON	?GETCAR
	POPM.32	D3|D7
	POP.16	F
	.ENDIF	Debug
	.ENDMACRO



; En-tte du module LIB
; ---------------------

	.LOC	0
DEBUT:
	TCOL_	FIRST		; code du premier appel	;%error
	TCOL_	LAST		; code du dernier appel	;%error
	.8	0		; nombre d'installations
	.FILL.8	(OHLREV-APC),0
	.8	MAJREV,MINREV	; rvision.version
	.16	0,END_TCOLOR	; longueur
	.32	PATHLIB		; pattern de dbut
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"TCOLOR"	; nom du module
	.FILL.8	(LGHLIB-APC),0

	.16	_TCOL_OPEN
	.16	_TCOL_CLOSE
	.16	_TCOL_ACTIVE
	.16	_TCOL_LOADCLUT
	.16	_TCOL_SAVECLUT
	.16	_TCOL_SRCCLUT
	.16	_TCOL_PUTCLUT
	.16	_TCOL_LOADCRET
	.16	_TCOL_SAVECRET
	.16	_TCOL_KILLCRET
	.16	_TCOL_ADDCRET
	.16	_TCOL_SUBCRET
	.16	_TCOL_SRCCRET
	.16	_TCOL_PUTCRET
	.16	_TCOL_DELCRET
	.16	_TCOL_MAKETRAME
	.16	_TCOL_PPSSCLUT
	.16	_TCOL_GPSSCLUT
	.16	_TCOL_LISTCRET
	.16	_TCOL_GETACTIVE




; Codes des appels
; ----------------



;-----------\\
; _TCOL_OPEN >
;===========/

; Ouvre une instance du module.

; in	D3.32	mode
;		#BTCDESC = 1 : descripteur de fentre dans A2
;	A2.32	descripteur de fentre (si D3:#BTCDESC = 1)
; out	D6.32	canal
;	D7.16	erreur
; mod	D6.32, D7.16

_TCOL_OPEN:
	PUSHM.32 D1|D4|A1|A3..A6

	MOVE.32	#R16^DEBUT,A4
	MOVE.32	#LGVGLOB+2**31,D4
	FOS	?GETCOMMEM	; demande variables globales
	JUMP,NE	EXIT$
	MOVE.32	A4,A6		; A6 <-- ^variables globales

	NTREL	?LOCK		; protge les variables globales
	JUMP,NE	EXIT$

	TEST.32	{A6}+OGPACC	; est-ce la premire fois qu'on passe ici ?
	JUMP,NE	R8^NOACC$	; non => on ne fait rien

	MOVE.32	A5,{A6}+OGPSEM	; OGPSEM <-- ^smaphore
	MOVE.32	A2,A4		; sauve ^desc
	MOVE.32	#R16^NMACC$,A3
	MOVE.32	#MTYPSYS,D1
	SUB.32	A1,A1
	GESMEM	?CREMCPT	; A2 <-- cre un compte mmoire
	JUMP,NS	EXITUNLOCK$
	MOVE.32	A2,{A6}+OGPACC
	MOVE.32	A4,A2		; restore ^desc

NOACC$:	MOVE.32	#LGVLOC,D4
	MOVE.32	#MTYPUSER,D1
	MOVE.32	{A6}+OGPACC,A1
	GESMEM	?GETMEM		; demande variables locales
	JUMP,NE	R8^EXITUNLOCK$

	GESMEM	?CLEARMEM
	MOVE.32	A4,A5		; A5 <-- ^variables locales

	MOVE.32	A6,{A5}+OLPGLOB	; mmorise les variables globales
	MOVE.32	A5,{A5}+OLPLOC	; mmorise la base des variables locales

	MOVE.8	#CLTYPE,{A5}+OL256CLUT+OCTTYP
	MOVE.32	#256*LCTDATA,{A5}+OL256CLUT+OCTLG
	MOVE.16	#256,{A5}+OL256CLUT+OCTNB

	PUSHM.32 D1|D2|A1|A2
	MOVE.32	#{A5}+OL256CLUT+LCTHEAD+16*LCTDATA,A1
	MOVE.32	#R16^PAL256,A2
	MOVE.16	#256-16,D1

INI$:	ADD.A16	#3,A1
	MOVE.8	{A2+},{A1+}
	MOVE.8	{A2+},D2
	MOVE.8	D2,{A1+}
	MOVE.8	D2,{A1+}	; R
	MOVE.8	{A2+},D2
	MOVE.8	D2,{A1+}
	MOVE.8	D2,{A1+}	; G
	MOVE.8	{A2+},D2
	MOVE.8	D2,{A1+}
	MOVE.8	D2,{A1+}	; B
	DEC.16	D1
	JUMP,NE	INI$

	POPM.32	D1|D2|A1|A2

	TEST.32	D3:#BTCDESC
	JUMP,F	R8^NoDesc$

	MOVE.32	A2,{A5}+OLPDESC	; mmorise ^desc fentre
	MOVE.32	{A2}+ODFPMID,{A5}+OLPPMID ; prend note du pixmap ID

NoDesc$:

NoFirst$:
	MOVE.32	A5,D6		; D6 <-- "canal"
	CLR.16	D7		; D7 <-- ok

EXITUNLOCK$:
	PUSH.16	D7
	MOVE.32	{A6}+OGPSEM,A5
	NTREL	?UNLOCK		; fin zone critique
	POP.16	D7
EXIT$:
	POPM.32	D1|D4|A1|A3..A6
	TEST.16	D7		; retour EQ/NE
	RET

NMACC$:	.ASCIZ	"TColMem"
	.EVEN


;------------\\
; _TCOL_CLOSE >
;============/

; Ferme une instance du module.

; in	D6.32	canal
;	D3.32	mode (zro)
; out	-
; mod	D7.16

_TCOL_CLOSE:
	PUSHM.32 D1|A1|A3..A6

	MOVE.32	D6,A5		; A5 <-- ^variables locales
	MOVE.32	{A5}+OLPGLOB,A6	; A6 <-- ^variables globales

	TEST.32	{A5}+OLPCLUT
	JUMP,EQ	 R8^CLUT$
	MOVE.32	{A5}+OLPCLUT,A4
	CALL	TABKILL		; libre la CLUT locale
CLUT$:
	MOVE.32	#{A5}+OLPCRET,A3 ; A3 <-- ^liste des CRETs locales
	MOVE.16	#MAXLCRET-1,D1
LOOP$:
	TEST.32	{A3}		; CRET existe ?
	JUMP,EQ	 R8^NEXT$	; non => NEXT$
	MOVE.32	{A3},A4		; A4 <-- ^CRET
	CALL	TABKILL		; libre une CRET locale
NEXT$:
	ADD.32	#4,A3		; A3 <-- ^^CRET suivante
	DJ.16,NMO  D1,LOOP$

	CLR.32	{A5}+OLPLOC

	MOVE.32	A5,A4
	MOVE.32	#MTYPUSER,D1
	MOVE.32	{A6}+OGPACC,A1
	GESMEM	?GIVMEM		; libre les variables locales

	POPM.32	D1|A1|A3..A6
	RET


;-------------\\
; _TCOL_ACTIVE >
;=============/

; Dfinit si la fentre associe au module est active ou non
; (chargement de la palette des couleurs associe dans le hardware
; du moniteur). 

; in	D6.32	canal
;	D4.8	1 => fentre active
;	D3.32	mode (zro)
;	A5.32	^liste des moniteurs (zro)
; out	-
; mod	D7.16

_TCOL_ACTIVE:
	MON	?AFTIM
	.ASCIZE	"[TCOL_Active]"
;;	TRAP	#0

	MOVE.16	#ERTCQQ,D7
	RET


;----------------\\
; _TCOL_GETACTIVE >
;================/

; Donne le canal actif  un instant donn.

; in	D6.L	canal
; out	D6.L	canal actif
; mod	D7.W

_TCOL_GETACTIVE:
	MON	?AFTIM
	.ASCIZE	"[TCOL_GetActive]"
;;	TRAP	#0

	MOVE.16	#ERTCQQ,D7
	RET


;----------------\\
; _TCOL_MAKETRAME >
;================/

; Cre une trame qui approxime une couleur donne.

; in	D6.L	canal
;	D3.32	mode (BCT*)
;		 BTCT8X8 --> calcule une trame 8x8
;		 BTCGIVE --> rend la couleur relle obtenue
;	A4.32	^couleur  approximer (RGB)
;	A3.32	^buffer pour couleur relle (si D3:#BTCGIVE)
;	A5.32	^buffer (8 bytes) pour la trame (si D3:#BTCT8X8)
; out	D4.L	couleur SET (si D3:#BTCT8X8)
;	D5.32	couleur CLEAR (si D3:#BTCT8X8)
;	{A5}+trame    8x8 (si D3:#BTCT8X8)
;	{A3}+RGB    rel (si D3:#BTCGIVE)
;	D7.16	erreur
; mod	D4.L, D5.L, D7.W

_TCOL_MAKETRAME:
	MOVE.16	#ERTCQQ,D7
	RET





	.INS	TCOLCLUT.ASI
	.INS	TCOLCRET.ASI
	.INS	TCOLTAB.ASI
	.INS	TCOLHARD.ASI

PAL256:
	.INS	256PAL.ASI



ERRCHANNEL:
	MON	?AFTIM
	.ASCIZE	"<CR>Bad TCOLOR ch: "
	PUSHM.32 A0|D4
	MOVE.32	{A7}+2*4,D4	; D4 <-- PC absolu
	MOVE.32	#R16^DEBUT,A0
	SUB.32	A0,D4
	MON	?AFX8
	POPM.32	A0|D4
	RET


END_TCOLOR:


	.END

