	.TITLE	LTREE

;	--------------------------------------
;		(C) 1987 - Francis Klay
;	--------------------------------------
;	Gestion gnralise de B arbres.

; Tree	Psos	Nom	Modifications
; ----------------------------------------------------------------------
; 0.0	4.8	FK	Version initiale			
; 0.1	4.8	FK	Implantation TREE_MOD
;			Implantation sauvetage arbre sur fichier disque
; 0.2	4.8	FK	Implantation provisoire GESMEM TYPAB

	.PROC	M68000		; CALM 3
	.BASE 	10.		; Base 10 par dfaut
	.LISTHEX		; Listing en hexadcima

	.REF	SMAKY		; Df machine
	.REF	MODULES

	 MAJREV	= 0		; Rvision
	 MINREV	= 2		; Version
	.REV	  MAJREV,MINREV	; Init rev entte
	.IDENT	  "F.Klay"	; Init ident entte


; Dclaration PC d'assemblage :
; -----------------------------
	PCCODE	 = 0		; Pour le code
	PCVAR	 = 1		; Pour var globales
	PCOFFSET = 2		; Pour var locales
	
	.PC	PCCODE		; Initialisation PC d'assemblage
	.LOC	0
	.PC	PCVAR
	.LOC	0
	.PC	PCOFFSET
	.LOC	0


; Description B arbre :
; ---------------------
;
; noeud:
;		--------------------------------------
;		| p0 c1 p1 c2 p2 c3 p3 ........ cn pn|
;               --------------------------------------
;
;		                     /      cellules :     \
;                                   / cls ordonnes + info \
; arbre:                           /-------------------------\
;				   ||   ||   ||   ||   ||   ||
;				---------------------------------
;				| |c1| |c2| |c3| |c4| |c5| |c6| |
;                               ---------------------------------
;                   vers cl min |    |    |    |    |    |    |
;                     ------------    v    |    v    v    v    |
;                     |                    v                   v
;                     v         vers cl entre c2 et c3   vers cl max
;     ---------------------------------
;     | |c1| |c2| |c3| |c4| |c5| |c6| |
;     ---------------------------------
;     <   nb cellules = 2d -> d=3     >
;
;   Attention il y a toujours un pt de plus que de cellules (cel): 2d cellules,
;   2d+1 pt. Le pt associ a la cellule (ptas) est le pt qui suit la cellule.
;   Pt0 est associ a aucune cellule cellule
;
;   Structure d'une case : |Cellule|
;                          | ptas  |
;
;   Structure d'une cel  : | cl   |
;                          | info  |


; En-tte du module LIB
; ---------------------
.PC	PCCODE

	TREE_	FIRST		; Code du premier appel	
	TREE_	LAST		; Code du dernier appel	
	.8 	0		; Nombre d'installations
	.FILL.8	(OHLREV-.),0
	.8 	MAJREV,MINREV	; Rvision.version
	.16 	0,END_TREE	; Longueur

	.16 	(PATHLIB&H'FFFF0000)/H'10000 ; pattern de dbut
	.16 	PATHLIB&H'FFFF	             ; Pattern de dbut
	.FILL.8 (OHLNAM-.),0

	.ASCII 	"TREE"		; Nom du module

	.FILL.8	(LGHLIB-.),0
	.16	_TREE_OPEN	; Ouvre un arbre
	.16	_TREE_CLOSE	; Ferme un arbre
	.16	_TREE_WR	; Ecrit un arbre sur disque

	.16	_TREE_INS	; Insre   une cellule
	.16	_TREE_MOD	; Modifie  une cellule
	.16	_TREE_DEL	; Supprime une cellule
	.16	_TREE_SEARCH	; Cherche  une cellule
	.16	_TREE_INFO	; Retourne info l'arbre

	.16	_TREE_SOPEN	; Ouvre   un accs squentiel
	.16	_TREE_SCLOSE	; Ferme   un accs squentiel
	.16	_TREE_SSTART	; Dmarre un accs squentiel

	.16	_TREE_SNEXT	; Retourne la cellule suivante
	.16	_TREE_SPREV	; Retourne la cellule prcdente


; Lg champ cellule :
; ------------------
TLGPT		= 4		; Lg d'un pointeur
TLGKEY		= 4		; Lg cl  cellule
TLGINFO		= 4		; Lg info cellule
TLGCEL		= TLGKEY+TLGINFO; Lg d'une cellule
TLGCASE		= TLGCEL+TLGPT  ; Longueur d'une case


; Dclaration Bit info algorithme de D7 16..31 :
; ----------------------------------------------
				; Pour insertion 
BTINSFA		= 31		; Insertion dans pre

				; Pour suppression
BTDELFA		= 31		; Suppression dans pre
BTPIVOTL	= 30		; Combinaison ou quilibrage avec voisin gauche
BTPIVOTR	= 29		; Combinaison ou quilibrage avec voisin droite
BTMODROOT	= 28		; Modificatioin racine (arbre perd 1 degr)


; Insertion modules :
; -------------------
;	.INS	MMARB		; Macro d'arbitrage accs arbre
	.INS	LTREESEQ.asi	; Gestion accs sqentiels
	.INS	LTREEIO.asi	; Gestion entre/sortie
^ 	MRD_START {A0}+OTVIO,#FLGBURD	; Dbut accs buffris
		  ^ Unknown instruction
^ 	MRD_MANY {A0}+OTVIO
		 ^ Unknown instruction
^ 	MRD_ONE {A0}+OTVIO
		^ Unknown instruction
^ 	MRD_END	  {A0}+OTVIO	; Fin accs buffris
		  ^ Unknown instruction
^ 	MRD_CLOSE {A0}+OTVIO	; Fin accs buffris et fermeture fichier
		  ^ Unknown instruction
^ 	MWR_START {A0}+OTVIO,#FLGBUWR   ; Dbut accs buffris
		  ^ Unknown instruction
^ 	MWR_MANY {A0}+OTVIO
		 ^ Unknown instruction
^ 	MWR_ONE {A0}+OTVIO
		^ Unknown instruction
^ 	MWR_END   {A0}+OTVIO    ; Fin accs buffris	
		  ^ Unknown instruction
^ 	MWR_CLOSE {A0}+OTVIO 	; Fin accs buffris et fermeture fichier
		  ^ Unknown instruction


; Structure descripteur d'arbre :
; -------------------------------
.PC	PCOFFSET
.LOC	0
OTIDENT:	.BLK.32	1	; Identificateur descripteur
OTIDMEM:	.BLK.32	1	; Identificateur cpt mm.
OTDMEM:		.BLK.32	2	; Descripteur    cpt mm.
OTVAL_D:	.BLK.16	1	; Valeur de d
OTVAL_2D:	.BLK.16	1	; Valeur de d*2
OTLGNODE:	.BLK.32	1	; Lg noeud
OTPTROOT:	.BLK.32	1	; ^racine arbre
OTREGNB:	.BLK.32	1	; No de rgnration
OTNBCEL:	.BLK.32	1	; Nb cellules dans arbre
OTNBSDESCR:	.BLK.16	1	; Nb descr accs squentiel
OTVARB:		.BLK.8	ALGVAR	; Var gestion arbitrage accs arbre
			     ^ Undefined symbol
OTVIO:		.BLK.8	LGVARIO	; Var gestion entre/sortie
			      ^ Undefined symbol
TLGDESCR:			; Lg descripteur


; Structure d'un noeud :
; ----------------------
.PC	PCOFFSET
.LOC	0
ONNBCEL:	.BLK.16	1	; Nb cellules dans noeud
ONP0:		.BLK.8	TLGPT	; P0 noueud
ONC1:				; Premire cellule noeud


; Variables globales :
; --------------------
.PC	PCOFFSET
.LOC	0
OTGDMEM:	.BLK.32	2	; Descr mmoire
OTGSTAT:	.BLK.8	1	; Status
 BTGLOCK	= 1		;  Vrouillage
		.BLK.8	1	; Rserve...
TGLGVAR:			; Lg var globales


; Constantes dpendants calcul offset :
; -------------------------------------
TMAX_D		= (H'8FFFF-ONP0-TLGPT)/(2*TLGCASE) ; Val max possible pour d


; Routines :
; ----------
.PC	PCCODE

;--------------\\
;   TREE_OPEN	>
;==============/

; Cre un nouvel arbre et retourne le pt  son descripteur

; in	D0.16 : Nb max cellule dans un noeud (si pas BTMCH ou BTMFILE)
;	D1.16 : Mode d'ouverture
;	D6.16 : Canal        (si BTMCH  )
;	A3.32 : ^Nom fichier (si BTMFILE)
; out	D7.16 : Erreur
;	A0.32 : ^descr arbre
; mod	A0.32 , D7.16 , F

TMOPFILE = 2**BTMFILE+2**BTMCH	     ; Masque open avec fichier

_TREE_OPEN:
	PUSHM.32 D0..D2|D4|A1..A2|A4
	CLR.16	D7		     ; Pas d'erreur			-> D7
	MOVE.32	D1,D2		     ; Sauve le mode			-> D2

	MOVE.32	#R16^TGVAR,A2        ; ^var globales			-> A2
10$:
	TSET.8	{A2}+OTGSTAT:#BTGLOCK; Dj un proc dans open ?
	JUMP,BC	20$		     ; Non => 20$
	MOVE.16	#1,D4		     ; On attend 20 ms.			-> D4
	NTREL	?DELMS
	JUMP	10$
20$:
	MOVE.32	#{A2}+OTGDMEM,A1     ; Descr mm. global		-> A1
	CLR.32	{A1}		     ; Init descr mm.
	CLR.32	{A1}+4		     ; Init descr mm.
	MOVE.32	#TLGDESCR,D4	     ; Lg descrpteur arbre		-> D4
	MOVE.16	#MTYPAB,D1	     ; Type cpt				-> D1
	GESMEM	?GETMEM	
	JUMP,NE	90$
				     ; Init descr arbre
	MOVE.32	A4,A0		     ; ^descr 				-> A0
	MOVE.32	{A1},{A0}+OTDMEM     ; Descr  cpt mm.
	MOVE.32 {A1}+4,{A0}+OTDMEM+4 ; Descr  cpt mm.
	MOVE.32	#{A0}+OTDMEM,A1      ; ^descr cpt mm.			-> A1
	MOVE.32	A1,{A0}+OTIDMEM      ; Ident  cpt mm.
	CLR.32	{A0}+OTPTROOT	     ; Racine arbre
	CLR.32	{A0}+OTNBCEL	     ; Nb cellules dans arbre
	CLR.16	{A0}+OTNBSDESCR	     ; Nb descr accs seq
	CLR.32	{A0}+OTREGNB	     ; No de rgnration arbre

	MA_OPEN	{A0}+OTVARB	     ; Requte des ressources d'arbitrage
		^ Unknown instruction
	JUMP,NE	80$

	MOVE.32	D2,D1		     ; Mode open			-> D1
	AND.16	#TMOPFILE,D2	     ; Ouverture avec fichier ?
	JUMP,EQ	50$		     ; Non => 50$

				     ; Open avec fichier =>
	CALL	TLOAD		     ; Charge l'arbre
	JUMP,NE	80$
	MOVE.32	A0,{A0}+OTIDENT	     ; Init identificateur descr (en 
	JUMP	90$		     ; dernier pour vrouiller accs si
				     ; open pas ok)

50$:				     ; Open avec arbre vide =>
	SR.16	#1,D0		     ; Valeur de d trop petite ?     d	-> D0
	JUMP,EQ	70$		     ; Oui => 70$
	COMP.16	#TMAX_D,D0	     ; Valeur de d trop grande ?
	JUMP,HI	70$		     ; Oui => 70$
	
	MOVE.16	D0,{A0}+OTVAL_D	     ; Init val d
	SL.16	#1,D0		     ;
	MOVE.16	D0,{A0}+OTVAL_2D     ; Init val 2d
	MUL.A16	#TLGCASE,D0	     ; Lg max de la liste - p0		-> D0
	ADD.32	#ONP0+TLGPT,D0       ; Lg noeud				-> D0
	MOVE.32	D0,{A0}+OTLGNODE     ; Init lg noeud

	MOVE.32	A0,{A0}+OTIDENT	     ; Init identificateur descr (en 
	JUMP	90$		     ; dernier pour vrouiller accs si
				     ; open pas ok)

70$:
	MOVE.16	#ERTBDN,D7	     ; Erreur "mauvaise dim noeud"	-> D7
80$:
	PUSH.16	D7
	MOVE.32	{A0}+OTIDMEM,A1	     ; Identificateur cpt mm.		-> A1
	MOVE.32	A0,A4		     ; ^descr arbre			-> A4
	MOVE.16	#MTYPAB,D1	     ; Type de compte			-> D1
	GESMEM	?GIVMEM		     ; Redonne mmoire descr
	POP.16	D7
90$:
	TCLR.8	{A2}+OTGSTAT:#BTGLOCK; Signal sortie open
	POPM.32	D0..D2|D4|A1..A2|A4
	TEST.16	D7
	RET


;--------------\\
; _TREE_CLOSE	>
;==============/

; Dtruit un arbre.

; in	A0.32 : ^descr arbre
; out	D7.A6 : Erreur
; mod	D7.16 , F

_TREE_CLOSE:
	PUSH.32 A4
	CLR.16	D7		; Pas d'erreur
	COMP.32	{A0}+OTIDENT,A0	; Ident descr arbre correcte ?
	JUMP,NE	R8^50$		; Non => 50$


	TEST.16	{A0}+OTNBSDESCR	; Encore descr accs seq ?
	JUMP,NE	R8^60$		; Oui => 60$

	TEST.32	{A0}+OTPTROOT	; Qq dans l'arbre
	JUMP,EQ	R8^10$		; Non => 10$
	MOVE.32	{A0}+OTPTROOT,A4; ^racine				-> A4
	CALL	TKILLTREE	; Dtruit l'arbre
	JUMP,NE	R8^70$
10$:
	MA_CLOSE {A0}+OTVARB	; Redonne les ressources d'arbitrage
		 ^ Unknown instruction
	JUMP,NE	R8^80$
	CALL	TKILLDESCR	; Dtruit le descripteur
	JUMP	R8^90$


50$:	MOVE.16	#ERTBTD,D7	; Erreur "mauvais descr arbre"		-> D7
	JUMP	R8^90$
60$:
	MOVE.16	#ERTSDEX,D7	; Erreur "il existe descr accs seq"	-> D7
	JUMP	R8^90$	
70$:
	PUSH.16	D7
	MA_CLOSE {A0}+OTVARB	; Redonne les ressources d'arbitrage
		 ^ Unknown instruction
	POP.16	D7
80$:
	PUSH.16	D7
	CALL	TKILLDESCR	; Dtruit le descripteur
	POP.16	D7
90$:
	POP.32	A4
	TEST.16	D7
	RET


;--------------\\
;   TKILLTREE	>
;--------------/

; Dtruit un arbre 

; in	A0.32 : ^decripteur arbre
;	A4.32 : ^arbre
; out	D7.16 : Erreur
; mod	A4.32 , D7.16 , F

TKILLTREE:
	PUSHM.32 D1|A1..A2
	TEST.32	{A4}+ONP0	; C'est un noeud terminal ?
	JUMP,EQ	R8^50$		; Oui => 50$

	MOVE.32	A4,A2		; ^noeud courant			-> A2
	MOVE.32	#{A2}+ONP0,A1	; ^p0 noeud				-> A1
	MOVE.16	{A2}+ONNBCEL,D1	; Nb cellule dans noeud			-> D1

10$:				; Dtruit les sous arbres du noeud =>
	MOVE.32	{A1},A4		; ^sous arbre fils			-> A4
	CALL	TKILLTREE	; On va le dtruire
	JUMP,NE	R8^90$
	ADD.A16	#TLGCASE,A1	; ^^sous arbbre fils suivant		-> A1
	DECJ.16,NMO D1,10$	; Attention nb_cel = nb_pt-1

	MOVE.32	A2,A4		; ^noeud courant			-> A4
50$:
	MOVE.32	{A0}+OTIDMEM,A1 ; Ident cpt mm.			-> A1
	MOVE.16	#MTYPAB,D1      ; Type  cpt mm.	 		-> D1
	GESMEM	?GIVMEM		; Redonne la mmoire
;	JUMP	R8^90$
90$:
	POPM.32 D1|A1..A2
	TEST.16	D7
	RET


;--------------\\
;  TKILLDESCR	>
;--------------/

; Dtruit le descripteur d'un arbre.

; in	A0.32 : ^descr arbre
; out	D7.16 : Erreur
; mod	D7.16 , F

TKILLDESCR:
	PUSHM.32 D1|A1|A4	; OTIDENT  0 pour vrouiller les 
	CLR.32	{A0}+OTIDENT	; accs aprs destruction
	MOVE.32	{A0}+OTIDMEM,A1 ; Ident cpt mm.			-> A1
	MOVE.16	#MTYPAB,D1      ; Type  cpt mm.	 		-> D1
	MOVE.32	A0,A4		; ^descr arbre				-> A4
	GESMEM	?GIVMEM
	POPM.32	D1|A1|A4
	RET


;--------------\\
; _TREE_INFO	>
;==============/

; Retourne des informations relative  l'arbre identifi par son
; descripteur

; in	A0.32 : ^descripteur arbre
; out	D0.32 : Nb cellules dans l'arbre
;	D1.32 : Pas dfinit pour l'instant
;	D7.16 : Erreur
; mod	D0.32 , D1.32 , D7.16, F

_TREE_INFO:
	CLR.16	D7	        ; Pas d'erreur
	COMP.32	{A0}+OTIDENT,A0 ; Descr correcte ?
	JUMP,NE	R8^70$	        ; Non => 70$

	MOVE.32	{A0}+OTNBCEL,D0	; Nb cellules damns l'arbre		-> A0
	JUMP	R8^90$
70$:
	MOVE.16	#ERTBTD,D7	; Erreur "mauvais descr arbre"		-> D7
;	JUMP	R8^90$
90$:
	TEST.16	D7
	RET


;--------------\\
; _TREE_SEARCH	>
;==============/

; Cherche les information relative  une cellule identifie par sa
; cl dans l'arbre.

; in	D0.32 : Cl
;	A0.32 : ^descripteur arbre
; out	D1.32 : Information si cel trouve
;	D7.16 : Erreur
; mod	D1.32 , D7.16, F

_TREE_SEARCH:
	PUSHM.32 D3|D5|A4..A5
	CLR.16	D7	        ; Pas d'erreur
	COMP.32	{A0}+OTIDENT,A0 ; Descr correcte ?
	JUMP,NE	R8^70$	        ; Non => 70$

	CALL	TIN_NOEX	; Entre exclusion
	MOVE.32	{A0}+OTPTROOT,A4; ^racine 				-> A4
	COMP.32	#0,A4		; Qq dans l'arbre ?
	JUMP,EQ	R8^80$		; Non => 80$
	CALL	TSEARCHCEL	; Cel trouve ?  ^cel dans arbre si ok	-> A4
	JUMP,NE	R8^90$		; Non => 90$
	MOVE.32	{A4}+TLGKEY,D1	; Info cellule				-> D1
	JUMP	R8^90$
70$:
	MOVE.16	#ERTBTD,D7	; Erreur "mauvais descr arbre"		-> D7
	JUMP	R8^99$
80$:
	MOVE.16	#ERTKNEX,D7	; Erreur "cl n'existe pas"		-> D7
;	JUMP	R8^90$
90$:
	CALL	TOUT_NOEX	; Sortie exclusion
99$:
	POPM.32	D3|D5|A4..A5
	TEST.16	D7
	RET


;--------------\\
;  _TREE_MOD	>
;==============/

; Modifie le champ information d'une cellule identifie par sa cl

; in	D0.32 : Cl identification cellule
;	D1.32 : Nouvelle info cellule
;	A0.32 : ^descripteur arbre
; out	D7.16 : Erreur
; mod	D7.16, F

_TREE_MOD:
	PUSHM.32 D3|D5|A4..A5
	CLR.16	D7	        ; Pas d'erreur
	COMP.32	{A0}+OTIDENT,A0 ; Descr correcte ?
	JUMP,NE	R8^70$	        ; Non => 70$

	CALL	TIN_NOEX	; Entre exclusion
	MOVE.32	{A0}+OTPTROOT,A4; ^racine 				-> A4
	COMP.32	#0,A4		; Qq dans l'arbre ?
	JUMP,EQ	R8^80$		; Non => 80$
	CALL	TSEARCHCEL	; Cel trouve ?  ^cel dans arbre si ok	-> A4
	JUMP,NE	R8^90$		; Non => 90$
	MOVE.32	D1,{A4}+TLGKEY	; Init nouveau champ info
	JUMP	R8^90$
70$:
	MOVE.16	#ERTBTD,D7	; Erreur "mauvais descr arbre"		-> D7
	JUMP	R8^99$
80$:
	MOVE.16	#ERTKNEX,D7	; Erreur "cl n'existe pas"		-> D7
;	JUMP	R8^90$
90$:
	CALL	TOUT_NOEX	; Sortie exclusion
99$:
	POPM.32	D3|D5|A4..A5
	TEST.16	D7
	RET


;--------------\\
;  TSEARCHCEL	>
;--------------/

; Cherche cellule identifie par sa cl dans un arbre

; in	D0.32 : Cl
;	A4.32 : ^arbre
; out	A4.32 : ^cl 
;	D7.16 : Erreur
; mod	D3.32 , D5.32 , A4.32 , D7.16 , F

TSEARCHCEL:
	MOVE.32	#TLGCASE,D5	; Lg cel + son ptas			-> D5

10$:				; On traite un nouveau noeuds
	MOVE.16	{A4}+ONNBCEL,D3	; Nb cellule dans noeuds		-> D3
	DEC.16	D3		; Nb cellule -1				-> D3
	MOVE.32	#{A4}+ONC1,A4	; ^premire cellule			-> A4
20$:
	COMP.32	{A4},D0		; Cl cherche par apport  cl cellule ?
        JUMP,LS	R8^50$		; Plus petite ou gale => 50$
        			; Plus grande          =>
	ADD.32	D5,A4		; (Pas mod flag) ^cellule suivante	-> A4
	DECJ.16,NMO D3,20$	; (Pas mod flag) Encore cel dans noeud ?

				; On est jamais EQ en arrivant sur le
				; test qui suit par l !
50$:
        JUMP,EQ	R8^90$		; Cl trouve => 90$
	MOVE.32	{A4}-TLGPT,D3	; Noeud terminal ?
	JUMP,EQ	R8^80$		; Oui => 80$
	MOVE.32	D3,A4		; Ptas cellule prcdente		-> A4
	JUMP	R8^10$		; Continue a descendre dans l'arbre
				; vers les cls infrieures  celle de
				; la cellule courante est suprieure  
				; celle de la cellule prcdente.
80$:
	MOVE.16	#ERTKNEX,D7
;	JUMP	R8^90$		; Erreur "cl n'existe pas"		-> D7
90$:
	TEST.16	D7
	RET


;--------------\\
;  _TREE_INS	>
;==============/

; Insre une nouvelle cellule identifie par sa cl.

; in	D0.32 : Cl  cellule a insrer
;	D1.32 : Info cellule a insrer
;	A0.32 : ^descr arbre
; out	D7.16 : Erreur
; mod	D7.32 , F
	
_TREE_INS:
	PUSHM.32 D0..D2|D5|A1|A4..A6
	CLR.32	D7		; Pas d'erreur (bit : 0..31 utilis !)
	INC.32	{A0}+OTREGNB	; Incrmente no regnration arbre

	COMP.32	{A0}+OTIDENT,A0	; Descr arbre correcte ?
	JUMP,NE	R8^70$		; Non => 70$

	CALL	TIN_EX		; Entre exclusion
	MOVE.32	{A0}+OTPTROOT,A4; ^racine arbre				-> A4
	MOVE.32	A4,A1		; Event p0 nouvelle racine		-> A1
	COMP.32	#0,A4		; Qq chose dans l'arbre ?
	JUMP,EQ	R8^20$		; Non => 20$

	MOVE.32	#0,A6		; Pas de prrservation			-> A6
	MOVE.16	{A0}+OTVAL_2D,D2; Nb max cellules dans noeud		-> D2   
	COMP.16	{A4}+ONNBCEL,D2	; Peut tre nouveau noeud ?
	JUMP,NE	R8^10$		; Non => 10$
	CALL	TGETMEM         ; ^prrservation			-> A6
	JUMP,NE	R8^90$
10$:
	CALL	TINSCEL		; On va insrer cellule
	JUMP,NE	R8^80$
	INC.32	{A0}+OTNBCEL	; Incrmente nb cellules dans arbre

	TCLR.32	D7:#BTINSFA	; L'arbre augmente de un degr  ?
				; (ins chez un pre inexistant) ?
        JUMP,BS	R8^50$		; Oui => 50$
	COMP.32	#0,A6		; On a fait prrservation inutile ?
	JUMP,EQ	R8^90$		; Non => 90$
	CALL	TGIVMEM
	JUMP	R8^90$

20$:				; Cre racine initiale =>
	CALL	TGETMEM		; ^Racine				-> A6
	JUMP,NE	R8^90$
	INC.32	{A0}+OTNBCEL	; Incrmente nb cellules dans arbre

50$:				; Init nouvelle racine =>
	MOVE.32	A6,{A0}+OTPTROOT; Init ^racine
	MOVE.16	#1,{A6}+ONNBCEL	; Init nb cellule dans racine
	MOVE.32	A1,{A6}+ONP0	           ; Init p0
	MOVE.32	D0,{A6}+ONC1	           ; Init cl
	MOVE.32	D1,{A6}+ONC1+TLGKEY        ; Init info
	MOVE.32	A4,{A6}+ONC1+TLGKEY+TLGINFO; Init p1
	JUMP	R8^90$

70$:
	MOVE.16	#ERTBTD,D7	; Erreur "mauvais descr arbre"		-> D7
	JUMP	R8^99$
80$:
	COMP.32	#0,A6		; On a fait prrservation inutile ?
	JUMP,BC	R8^90$		; Non => 90$
	PUSH.16	D7
	CALL	TGIVMEM
	POP.16	D7
90$:
	CALL	TOUT_EX		; Sortie exclusion
99$:
	POPM.32	D0..D2|D5|A1|A4..A6
	TEST.16	D7
	RET


;--------------\\
;    TINSCEL	>
;--------------/

; Insre rcusivement une nouvelle cellule identifie par sa cl.
; L'algorithme est le suivant : 
;
; 1.	On commence par faire une recherche rcursive dans l'arbre
;	pour dterminer la position d'insertion.
; 2a.	S'il y a assez de place dans le noeud terminal, on y ajoute
;	la nouvelle cellule et c'est fini.
; 2b.	Si le noeud terminal est plein on le casse en 2 (boire du
;	banago le matin de prfrence),
; 3.	On rpartit les cellules entre ces 2 noeuds et on insre
;	la nouvelle cellule (pour plus de dtails voir la routine
;	d'insertion dans un noeud).
; 4.	Lors de l'excution du point 3 on a aussi extrait la cellule
;	mdiane des 2 noeuds avec comme ptas le pt au nouveau noeud.
; 5.	On revient d'un niveau de rcursivit et on insre la cellule
;	extraite dans le noeud pre (point 2)
;
; On remarque que l'arbre est augment d'un degr si tout les noeuds
; sont pleins lors de la remonte rcursive.
;
; Remarque concernant la gestion de la mmoire :
; Comme on peut le voir la mmoire ncessaire au nouveaux noeuds est 
; connue lors de la remonte rcursive. Le problme qui se pose est 
; le suivant : S'il n'y  a plus de mmoire lors d'une insertion chez 
; un pre, la cellule initiale a insrer est dj dans l'arbre et la 
; cellule que l'on ne sait ou mettre est plus ancienne. Il est alors
; trs difficile de remettre l'arbre dans l'tat initial (pensez au
; cas ou le pivot tait la cel no d dans les noeuds dj subdiviss).
; Tester la place restante avant l'algorithme n'est pas possible 
; (commutation de contexte). C'est pourquoi les demandes prsumes
; pour les noeuds sont faites durant la descente rcursive (noeud
; qui on 2 d cellules). Si on a mal prsum on redonne la mmoire 
; lors de la remonte rcursive.

; in	D0.32 : Cl  cellule a insrer
;	D1.32 : Info cellule a insrer
;	A0.32 : ^descr arbre
;	A4.32 : ^arbre
; out	D0.32 : Cl  cellule a insrer  chez pre
;	D1.32 ; Info cellule a insrer  chez pre
;	A4.32 : ptas cellule a insrer  chez pre
;	D7.32 : 16..31 : BTINSFA  1 si insertion chez pre
;	        0..15  : Erreur
; mod	D0.32 , D1.32 , A4.32 , D7.32 , F

TINSCEL:
	PUSHM.32 D2|D3|A3|A6
	MOVE.32	A4,A3		; ^noeud courant			-> A3
	CLR.16	D3		; No cellule noeud courante -1		-> D3
	MOVE.32	#{A4}+ONC1,A4	; ^premire cellule noeud		-> A4


10$:				; Cl de la cellule a insrer par apport
	COMP.32	{A4},D0		;  la cl de la cellule courante ?
        JUMP,EQ	R8^70$		; Egale       => 70$
        JUMP,LO	R8^20$		; Plus petite => 20$
        			; Plus grande =>
	ADD.A16	#TLGCASE,A4	; ^cellule suivante			-> A4
	INC.16	D3		; No cellule suivante -1		-> D3
	COMP.16	{A3}+ONNBCEL,D3	; Encore des cellules dans le noeud ?
	JUMP,LO	R8^10$		; Oui => 10$
				; Non =>				

20$:	
	TEST.32	{A4}-TLGPT	; Noeud terminal (pos ins trouve) ? 
	JUMP,EQ	R8^50$		; Oui => 50$
	MOVE.32	{A4}-TLGPT,A4	; Ptas cellule prcdente		-> A4
 
	MOVE.32	#0,A6		; Pas de prrservation	-> A6
	MOVE.16	{A0}+OTVAL_2D,D2; Nb Max cel dans noeud			-> D2
	COMP.16	{A3}+ONNBCEL,D2	; Peut tre nouveau noeud ?
	JUMP,NE	R8^30$		; Non => 30$
	COMP.16	{A4}+ONNBCEL,D2	; Peut tre nouveau noeud ?
	JUMP,NE	R8^30$		; Non => 30$
	CALL	TGETMEM   	; ^prrservation			-> A6
	JUMP,NE	R8^90$
30$:
	CALL	TINSCEL		; Continue a descendre dans l'arbre
	JUMP,NE	R8^80$		; vers les cls infrieures  celle de
				; la cellule courante est suprieure  
				; celle de la cellule prcdente
	TCLR.32	D7:#BTINSFA	; Insertion dans noeud courant ?
	JUMP,BC	R8^40$		; Non => 40$
	CALL	NINSCEL		; Insre une cellule dans le noeuds 
	JUMP	R8^90$		; courant qui est intermdiaire.
40$:
	COMP.32	#0,A6		; On a fait prrservation inutile ?
	JUMP,EQ	R8^90$		; Non => 90$
	CALL	TGIVMEM
	JUMP	R8^90$

50$:
	MOVE.16	{A0}+OTVAL_2D,D2; Nb Max cel dans noeud			-> D2
	COMP.16	{A3}+ONNBCEL,D2	; Il faut un nouveau noeud ?
	JUMP,NE	R8^60$		; Non => 60$
	CALL	TGETMEM    	; ^nouveau noeud	 		-> A6
	JUMP,NE	R8^90$
60$:
	MOVE.32	#0,A4		; Pas de ptas (noeud terminal)		-> A4
	CALL	NINSCEL		; Insre une cellule dans le noeuds 
	JUMP	R8^90$		; courant qui est terminal

70$:
	MOVE.16	#ERTKAEX,D7	; Erreur cl existe dj		-> D7
	JUMP	R8^90$
80$:
	COMP.32	#0,A6		; On a fait prrservation inutile ?
	JUMP,BC	R8^90$		; Non => 90$
	PUSH.16	D7
	CALL	TGIVMEM
	POP.16	D7
90$:
	POPM.32	D2|D3|A3|A6
	TEST.16	D7
	RET


;--------------\\
;   NINSCEL	>
;--------------/

; Insre une cellule identifie pas sa cl dans un noeud. Si le noeud
; n'est pas plein la cellule est insre dans la liste des cellules
; ordonne selon leurs cls. Si le noeud est plein il est subdivis en
; 2 noeuds, le premier contient les d cls infrieures et le deuxime
; les d cls suprieures. La dernire cellule (celle dont la cl est
; mdiane) est insre dans le noeud pre.
;
; Exemple d = 2 :
;
;  | 66 | 78 | ....          ins 75    | 66 | 71 | 78 |
;  v    |    v      	       ==>     v    |    |    |
;       v  		      		    |	 v
;     | 68 | 69 | 71 | 76 |                 |  | 75 | 76 |    |    |
;     -    -    -    -    -                 |  -    -    -    -    -
;                                           v
;                                         | 68 | 69 |    |    |
;
;	in	D0.32 : 75
;		D3.32 : 3
;		

; in	D0.32 : Cl         cellule a insrer
;	D1.32 : Information cellule a insrer
;	D3.32 : No cellule avant pos insertion (no premire cellule : 1 !)
;	A0.32 : ^descr arbre
;	A3.32 : ^noeud courant
;	A4.32 : Ptas cellule a insrer
;	A6.32 : ^Event nouveau noeud prrserv
; out	D0.32 : Cl  cellule a insrer  chez pre
;	D1.32 ; Info cellule a insrer  chez pre
;	A4.32 : Ptas cellule a insrer  chez pre
;	D7.32 : 16..31 : BTINSFA  1 si insertion chez pre
; mod	D0.32 , D1.32 , A4.32 , D7.32 , F

NINSCEL:
	PUSHM.32 D2..D6|A1..A3|A5
	MOVE.16	{A0}+OTVAL_2D,D2 ; Nb Max cel dans noeud		-> D2
	COMP.16	{A3}+ONNBCEL,D2	 ; Il faut subdiviser le noeud ?
	JUMP,EQ	R8^40$		 ; Oui => 40$
				 ; Non =>
	COMP.16	{A3}+ONNBCEL,D3	 ; Insertion en fin de liste ?
	JUMP,EQ	R8^20$		 ; Oui => 20$

					   ; Non =>
	MUL.16	#TLGCASE,D3		   ; Insertion avec dcallage =>
	MOVE.32	#{A3}+A16^{D3}+ONC1,A1     ; ^pos insertion dans noeud	-> A1
	MOVE.16	{A3}+ONNBCEL,D3		   ; Nb cellule dans noeud	-> D3
	MUL.16	#TLGCASE,D3	
	MOVE.32	#{A3}+A16^{D3}+ONC1,A2	   ; ^pt fin liste		-> A2
	MOVE.32 #{A2}+TLGCASE,A5	   ; ^pt nouvelle fin liste 	-> A5
10$:
	MOVE.32	{-A2},{-A5}	    	   ; Dcale le queue de liste
	COMP.32	A1,A5			   ; Toute la queue dcale ?
	JUMP,HI	R8^10$			   ; Non => 10$
	JUMP	R8^30$

20$:
	MUL.16	#TLGCASE,D3		   ; Insertion sans dcallage =>
	MOVE.32	#{A3}+A16^{D3}+ONC1,A1     ; ^pos insertion dans noeud	-> A1
30$:	MOVE.32	D0,{A1}			   ; Sauve cl
	MOVE.32	D1,{A1}+TLGKEY		   ; Sauve info
	MOVE.32	A4,{A1}+TLGKEY+TLGINFO	   ; Sauve ptas
	INC.16	{A3}+ONNBCEL		   ; Une cl de plus dans noeud
	TCLR.32	D7:#BTINSFA		   ; Pas d'insertion dans pre
	JUMP	90$	

40$:					   ; Subdivision d'un noeud =>
					   ; |p0 c1 p1..pd|cd+1..p2*d|
					   ; <    n1,n3  ><   n2,n4  >
					   ; Ancien  noeud : |entte|n1|n2|
					   ; Nouveau noeud : |entte|n3|n4|
					   ; Si noeuds assez grand on 
	COMP.16	{A0}+OTVAL_D,D3		   ; insrerait la cellule ?
	JUMP,LO	70$			   ; Dans n1        => 70$
	JUMP,HI	60$			   ; Dans n2        => 60$
					   ; Entre n1 et n2 =>

; 	Entre n1 et n2 =>
;	Dans ce cas la cellule  insrer chez le pre est la cellule qu'il
;  	faut insrer  ce niveau et son nouveau ptas est le pointeur du
;	noeud cr. Le ptas de la cellule a insrer devient p0 de n3.
;	cel n1  -> cel n1
;	cel n2  -> cel n3
;	cel ins -> nouvelle cellule ins

	MOVE.16	{A0}+OTVAL_D,D2		   ; d				-> D2
	MUL.16	#TLGCASE,D2		   
	MOVE.32	#{A3}+A16^{D2}+ONC1,A1 	   ; ^premire cellule n2	-> A1
	MOVE.32	#{A6}+ONP0,A2		   ; ^p0 de n3			-> A2
	MOVE.32	A4,{A2+}		   ; Ptas cel ins -> p0 De n3
	DEC.16	D2			   ; Longeur a transfrer	-> D2
55$:					   ;  on ne transfert pas le pt
	MOVE.8	{A1+},{A2+}		   ;  de la premire cellule de
	DECJ.16,NMO D2,55$		   ;  n3 puisque c'est le pt de
				           ;  la cellule a insrer
	MOVE.16	{A0}+OTVAL_D,{A3}+ONNBCEL  ; Init nb cellule dans n1|n2
	MOVE.16	{A0}+OTVAL_D,{A6}+ONNBCEL  ; Init nb cellule dans n2|n3
	TSET.32	D7:#BTINSFA		   ; Signale insertion dans pre
	MOVE.32	A6,A4			   ; Ptas cel insre chez pre	-> A4
	JUMP	90$

; 	Dans n2 =>
;	Dans ce cas la cellule  insrer chez le pre est la premire
;	cellule de n2 son ptas est le pointeur du nouveau noeuds, son
;	ancien ptas devient p0 de n3. La cellule a insrer et son ptas
;	sont ajouts a n3
;	cel n1                       -> cel n1
;	cel n2 - premire + cel ins  -> cel n3
;       ptas premire cel n2         -> p0  n3
;	premire cel n2              -> nouvelle cel ins
60$:
	MOVE.16	{A0}+OTVAL_D,D2		   ; d				-> D2
	MUL.16	#TLGCASE,D2
	MOVE.32	#{A3}+A16^{D2}+ONC1,A1	   ; ^premire cellule n2	-> A1
	MOVE.32	#{A6}+ONP0,A2		   ; ^p0 de n3			-> A2
	MOVE.32	{A1+},D5		   ; Cl  cel insre chez pre	-> D5
        MOVE.32	{A1+},D6		   ; Info cel insre chez pre	-> D6
	MOVE.32	{A1+},{A2+}		   ; Init p0 de n3
	SUB.16	#TLGCASE+1,D2		   ; 1 cel en moin +1 pour DECJ	-> D2
	JUMP,MI	68$			   ; d=1 => 68$
64$:
	MOVE.8	{A1+},{A2+}		   ; Transfert d-1 cellule
	DECJ.16,NMO D2,64$
68$:
	MOVE.16	{A0}+OTVAL_D,D2		   ; d				-> D2
	MOVE.16	D2,{A3}+ONNBCEL		   ; Init nb cel |e|n1|n2|
        DEC.16	D2			   ; d-1			-> D2
	MOVE.16	D2,{A6}+ONNBCEL		   ; Init nb cel |e|n3|n4|

					   ; Insre cel dans |e|n3|n4|
					   ; Pos ins : moin les d cel de
	ADD.32	#2,D2			   ; n1, -1 cel qui va dans pre
	SUB.16	D2,D3			   ; No cel pos ins 		-> D3
	MOVE.32	A6,A3			   ; ^noeud			-> A3
	CALL	NINSCEL			   ; C'est si simple !
	TSET.32	D7:#BTINSFA		   ; Insertion cel chez pre
	MOVE.32	D5,D0			   ; Cl  cel insre chez pre	-> D0
	MOVE.32	D6,D1			   ; Info cel insre chez pre	-> D1
	MOVE.32	A6,A4			   ; Ptas cel insre chez pre	-> A4
	JUMP	R8^90$

; 	Dans n1 =>
;	Dans ce cas la cellule  insrer chez le pre est la dernire
;	cellule de n1 son ptas est le pointeur du nouveau noeuds, son
;	ancien ptas devient p0 de n3. La cellule a insrer et son ptas
;	sont ajouts a n1
;	cel n1 - dernire + cel ins  -> cel n1
;	cel n2			     -> cel n3
;       ptas dernire cel n1         -> p0  n3
;	dernire cel n1              -> nouvelle cel ins
70$:	
	MOVE.16	{A0}+OTVAL_D,D2		   ; d				-> D2
	DEC.16	D2			   ; d-1			-> D2
	MUL.16	#TLGCASE,D2
	MOVE.32	#{A3}+A16^{D2}+ONC1,A1	   ; ^premire dernire cel n1	-> A1
	MOVE.32	#{A6}+ONP0,A2		   ; ^p0 de n3			-> A2
	MOVE.32	{A1+},D5		   ; Cl  cel insre chez pre	-> D5
        MOVE.32	{A1+},D6		   ; Info cel insre chez pre	-> D6
	MOVE.32	{A1+},{A2+}		   ; Init p0 de n3
	ADD.16	#TLGCASE-1,D2		   ; d cel et -1 pour DECJ	-> D2
75$:
	MOVE.8	{A1+},{A2+}		   ; Transfert d cellules
	DECJ.16,NMO D2,75$

	MOVE.16	{A0}+OTVAL_D,D2		   ; d				-> D2
	MOVE.16	D2,{A6}+ONNBCEL		   ; Init nb cel |e|n3|n4|
        DEC.16	D2			   ; d-1			-> D2
	MOVE.16	D2,{A3}+ONNBCEL		   ; Init nb cel |e|n1|n2|

					   ; Insre cel dans |e|n1|n2
	CALL	NINSCEL			   ; C'est si simple !
	TSET.32	D7:#BTINSFA		   ; Insertion cel chez pre
	MOVE.32	D5,D0			   ; Cl  cel insre chez pre	-> D0
	MOVE.32	D6,D1			   ; Info cel insre chez pre	-> D1
	EX.32	A6,A4			   ; Ptas cel insre chez pre	-> A4
;	JUMP	R8^90$

90$:
	POPM.32	D2..D6|A1..A3|A5
	RET


;--------------\\
;  _TREE_DEL	>
;==============/

; Supprime de l'arbre une cellule identifie par sa cl.

; in	D0.32 : Cl  cellule a supprimer
;	A0.32 : ^descr arbre
; out	D7.16 : Erreur
; mod	D7.32 , F

_TREE_DEL:
	PUSHM.32 D5|A4..A5
	CLR.32	D7		; Pas d'erreur (on utilise 32 bits!)	-> D7
	INC.32	{A0}+OTREGNB	; Incrmente no regnration arbre

	COMP.32	{A0}+OTIDENT,A0	; Descr arbre correcte ?
	JUMP,NE	R8^80$		; Non => 80$

	CALL	TIN_EX	 	; Entre exclusion

	TEST.32	{A0}+OTPTROOT	; Qq dans l'arbre ?
	JUMP,EQ	R8^70$		; Non => 70$

	MOVE.32	{A0}+OTPTROOT,A4; ^racine arbre				-> A4
	MOVE.32	#0,A5		; Pas de pre				-> A5
	CLR.16	D5		; No cellule pre (inutile)		-> D5
	CALL	TDELCEL		; Supprime la cellule de l'arbre
	JUMP,NE	R8^90$

	DEC.32	{A0}+OTNBCEL	; Dcrmente nb cellules dans arbre
	TEST.32	D7:#BTMODROOT	; Nouvelle racine (arbre perd 1 degr) ?
	JUMP,BC	R8^90$		; Non => 90$
	MOVE.32	A4,{A0}+OTPTROOT; Sauve ^nouvelle racine
	JUMP	R8^90$

70$:
	MOVE.16	#ERTKNEX,D7	; Erreur "cl n'existe pas"		-> D7
	JUMP	R8^90$
80$:
	MOVE.16	#ERTBTD,D7	; Erreur "mauvais descr arbre"		-> D7
	JUMP	R8^99$
90$:
	CALL	TOUT_EX		; Sortie exclusion
99$:
	AND.32	#H'FFFF,D7	; Efface le word de poid fort (celui
	POPM.32	 D5|A4..A5	; qui contient info algorithme)		-> D7
	TEST.16	D7
	RET


;--------------\\
;   TDELCEL	>
;--------------/

; Supprime de l'arbre une cellule identifie par sa cl. Le principe de 
; l'algorithme est le suivant : 
;
; 1.	On cherche rcursivement dans l'arbre la position de la cellule
;	a supprimer.
; 2.	A ce moment 2 cas sont possible : 
;	 1.	La cellule est dans un noeud terminal de l'arbre
;	 2.	La cellule est dans un noeud intermdaire de l'arbe.
; 3.1	On cheche la cellule adjacente (selon le classement!) et on la
;	copie dans la cellule a supprimer. On rappel alors le point 1
;	en spcifiant : comme arbre le sous arbre pointer par le ptas
;	de la cellule supprime et comme nouvelle cellule a supprimer
;	la cellule qui a t copie.
; 3.2	La cellule est supprime du noeud et la liste des cellules du
;	noeud est compactifie.
; 4.	Si aprs suppression le nb de cellules dans le noeud est encore
;	suprieur  d on a termin.
; 5.	Si aprs suppression le nb de cellules dans le noeud est infrieur
;	a d, on analyse les 2 noeuds voisins de mme niveau. Si un des
;	voisins a d cellules, on combine les 2 noeud pour en faire un seul.
;	Si ce n'est pas le cas on rquilibre le nombre de cellules dans 
;	chaque noeud avec le voisin qui en a le moin.
; 6.	S'il y a eu combinaison de 2 noeuds on devra supprimer une cellule
;	dans le noeud pre au retour d'un niveau de rcursion (point 2).
;	(Pour plus de dtails sur la cellule a supprimer chez le pre voir
;	la routine de suppression d'une cellule dans un noeud).
;	On remarque que l'arbre perd un degr, si durant le retour de 
;	rcursion il y a combinaison  tout les niveaux et que la racine
;	contient une seule cellule.

; in	D0.32 : Cl  cellule a supprimer
;	A0.32 : ^descr arbre
;	D5.16 : No cellule pre descente ...| cel |....
;     		No premire cellule moeud : 1 !   v on est descendu par l
;	A4.32 : ^noeud courant
;	A5.32 : ^noeud pre (si premier appel 0 (pre n'existe pas))
; out	A4.32 : ^event nouvelle racine (l'arbre perd 1 degr) 
;	D7.32 : 16..31 : Info pour suppression noeud pre
;			 Info modif racine (l'arbre perd 1 degr)
;		0..15  : Erreur
; mod	A4.32 , D7.32 , F

TDELCEL:
	PUSHM.32 D0..D1|D3|A3
	MOVE.32	A4,A3		; ^noeud courant			-> A3
	CLR.16	D3		; No cellule noeud courante -1		-> D3
	MOVE.32	#{A4}+ONC1,A4	; ^premire cellule noeud		-> A4

20$:				; Cl de la cellule a supprimer par
	COMP.32	{A4},D0		; apport  la cl de la cellule courante ?
        JUMP,LO	R8^50$		; Plus petite => 50$
        JUMP,NE	R8^40$		; Plus grande => 40$
				; Egale       =>

	TEST.32	{A4}+TLGCASE-TLGPT ; C'est un noeud terminal ?
	JUMP,NE	R8^30$		   ; Non => 30$

	; Cellule a supprimer dans noeud terminal =>
	; Dans ce cas on retire la cellule du noeud terminal. Si il y a 
	; eu combinaison entre 2 noeuds D7 16..32 contient l'information
	; ncessaire  la suppression de la cellule du noeud pre.
	
	CALL	NDELCEL		; Supprime cellule du noeud terminal
	JUMP	R8^90$

	; Cellule a supprimer dans noeud intermdiaire =>
	; Dans ce cas la cellule a supprimer est substitue par sa cel-
	; lule adjacente (on a donc 2 fois la cellule adjacente dans l'
	; arbre. On rappelle alors la routine de suppression avec comme
	; arbre le sous arbre point par le ptas  la cellule supprime,
	; et comme cellule a supprimer la celule adjacente.
	; Remarque : D3 est incrment pour qu'il reprsente la cellule 
	; pre correctement lorqu'on continue la descente (ass sur D5).
        ; Ceci est ncessaire pour que l'ventuel quilibrage ou combi-
	; naison se fasse correctement  ce niveau lors de la remonte
	; rcursive.
30$:
	CALL	GETADJCEL	; Cellule adjacente			-> D0,D1
	MOVE.32	D0,{A4}		; Substitue cl
	MOVE.32	D1,{A4}+TLGKEY	; Substitue info
	ADD.A16	#TLGCASE,A4     ; ^cellule aprs ^sous arbre
	INC.16	D3		; Met  jour no cel descente pre
	JUMP	R8^60$		; contenant la cellule adjacente	-> A4

40$:
	ADD.A16	#TLGCASE,A4	; ^cellule suivante			-> A4
	INC.16	D3		; No cellule suivante -1		-> D3
	COMP.16	{A3}+ONNBCEL,D3	; Encore des cellules dans le noeud ?
	JUMP,LO	R8^20$		; Oui => 20$
				; Non =>
50$:
	TEST.32	{A4}-TLGPT	; ^Noeud terminal (cel pas trouve) ? 
	JUMP,EQ	R8^80$		; Oui => 80$
60$:
	PUSHM.32 D5|A5		; Sauve no cel et ^noeud pre
	  MOVE.16 D3,D5	        ;   Nouveau no cel pre			-> D5
	  MOVE.32 A3,A5		;   ^nouveau noeud pre			-> A5
	  MOVE.32 {A4}-TLGPT,A4	;   Ptas cellule prcdente		-> A4
	  CALL	  TDELCEL       ;   Continue a descendre dans l'arbre
			        ;   vers les cls infrieures  celle de
				;   la cellule courante est suprieure 
				;   celle de la cellule prcdente
	POPM.32	D5|A5	        ; Restitue no cel et ^noeud pre

	TEST.32	D7:#BTDELFA	; Suppression cel dans noeud courant ?
	JUMP,BC	R8^90$		; Non => 90$
	CALL	NDELCEL		; Supprime une cellule dans le noeuds 
	JUMP	R8^90$		; courant qui est intermdiaire.
80$:
	MOVE.16	#ERTKNEX,D7	; Erreur cl n'existe pas		-> D7
90$:
	POPM.32	D0..D1|D3|A3
	TEST.16	D7
	RET


;--------------\\
;   NDELCEL	>
;--------------/

; Supprime une cellule dans un noeud les cas possible sont : 
;
; d= 2 et on supprime la cellule ayant la cl 25
;
; Cas 1
;
; | 10 | 25 | 50 |    |    	====>	| 10 | 50 |    |    |
;
;
; Cas 2
;
; | 10 | 15 | 27 |    |		====>   | 10 | 27 |    |    |
;      |    v                                v
;      |  | 20 | 25 |    |    |	           | 12 | 14 | 15 | 20 |
;      v
;    | 12 | 14 |    |    |
;
;
; Cas 3
;
; | 10 | 15 | 27 |    |		====>   | 10 | 14 | 27 |    |
;      |    v                                |    v
;      |  | 20 | 25 |    |    |	             |  | 15 | 20 |    |    |
;      v			             v
;    | 12 | 13 | 14 |    |                 | 12 | 13 |    |    |
;
;
; Cas 1 On supprime la cellule avec ce mode tant que le nombre de cellules
;	dans le noeud aprs suppression est suprieur ou gal  d (sauf
;	pour la racine, si nb cel=0 dans racine aprs suppression l'arbre
;	perd un degr).
; Cas 2 On utilise ce mode si aprs suppression le nombre de cellule est
;	infrieur a d et qu'un des 2 noeuds voisin contient d cellules.
;	Dans l'exemple si dessus le noeud a supprimer chez le pre est 15.
; Cas 3 On utilise ce mode si aprs suppression le nombre de cellule est
;	infrieur a d et que le mode 2 n'est pas possible. On rquilibre
;	le nombre de cellules dans les noeuds avec celui des 2 voisins 
;	qui en a le moin.

; in	D3.16 : No cellule a supprimer -1 si noeud terminal
;	        No cellule a supprimer -1 si noeud intermdiaire et
;		combinaison avec voisin de droite (pas -1 si gauche)
;		no premre cellule noeud :  1 !
;	D5.16 : No cellule pre descente ...| cel |....
;                                                 v on est descendu par l
;	A0.32 : ^descr arbre
;	A3.32 : ^noeud courant                 
;	A5.32 : ^noeud pre ( 0 si existe pas (noeud courant racine))
;	D7.32 : 16..31 : Info pour suppression : si BTDELFA est  0 il
;		         sagit d'une suppression dans un noeud terminal,
;			 sinon c'est dans un noeud non terminal.
; out	A4.32 : Event nouvelle racine (l'arbre perd 1 degr).
;	D7.32 : 16..31 : Info sur event suppression cel pre 
;			 Info modif racine (l'arbre perd 1 degr)
;		0..15  : Erreur
; mod	A4.32 , D7.32 , F

NDELCEL:
	PUSH.32	D2
	COMP.32	#0,A5		; Le noeud courante Est la racine ?
	JUMP,NE	R8^10$		; Non => 10$
	CALL	RDEL		; Suppression selon cas 1 dans racine
	JUMP	R8^90$
10$:
	CALL	NDEL		; Suppression selon cas 1 dans noeud


	MOVE.16	{A0}+OTVAL_D,D2	; Nb min cel dans noeud			-> D2
	COMP.16	{A3}+ONNBCEL,D2	; Moin de d cel dans noeud ?
	JUMP,LS	R8^90$		; Non => 90$
				; Noeud non standard moin de d cel dans
				; noeud, convertit selon cas 2 ou 3 =>
	CALL	NDO_STAND	; Refait noeud standard (d < nb_cel < 2d)	
90$:
	POP.32	D2
	TEST.16	D7
	RET


;--------------\\
;     NDEL	>
;--------------/

; Effectue la suppression d'une cellule dans un noeud.

; in	D3.16 : No cellule a supprimer -1 si noeud terminal
;	        No cellule a supprimer -1 si noeud intermdiaire et
;		combinaison avec voisin de droite (pas -1 si gauche)
;		no premre cellule noeud :  1 !
;	A3.32 : ^noeud courant
;	A5.32 : ^noeud pre
;	D7.32 : 16..31 : Info pour suppression : si BTDELFA est  0 il
;		         sagit d'une suppression dans un noeud terminal,
;			 sinon c'est dans un noeud non terminal.
; out	D7.32 : 16..32 : Tout les bits d'info sont mis  0      
; mod	D7.32 , F

NDEL:
	PUSHM.32 D1|D3|A1..A2	; Suppression due a une combinaison
	TEST.32	D7:#BTPIVOTL	; avec le voisin de gauche ?
	JUMP,BC	R8^20$		; Non => 20$
	DEC.16	D3		; No cellule a supprimer -1		-> D3
20$:
	MOVE.16	{A3}+ONNBCEL,D1	; Nb cellule dans noeud			-> D1
	SUB.16	D3,D1		; Nb cel aprs cel a supprimer + 1	-> D1
	DEC.16	D1		; Nb cel a dcaler			-> D1
	JUMP,EQ	R8^90$		; Rien a dcaler => 90$	

	MUL.A16	#TLGCASE,D3
	MOVE.32	#{A3}+A16^{D3}+ONC1,A1 ; ^cellule a supprimer		-> A1
	MOVE.32	#{A1}+TLGCASE,A2       ; ^cel suivant cel a supprimer	-> A2
	MUL.A16	#TLGCASE,D1	       ; Lg a dcaler			-> D1
	DEC.16	D1                     
50$:
	MOVE.8	{A2+},{A1+}	; Dcale les cellule aprs la cellule
	DECJ.16,NMO D1,50$	; a supprimer
90$:
	DEC.16	{A3}+ONNBCEL	; Une cellule en moin
	AND.32	#H'FFFF,D7	; Pas suppression chez pre (pour le
	POPM.32	D1|D3|A1..A2	; moment)
	RET


;--------------\\
;     RDEL	>
;--------------/

; Effectue la suppression d'une cellule dans la racine.

; in	D3.16 : No cellule a supprimer -1 si noeud terminal
;	        No cellule a supprimer -1 si noeud intermdiaire et
;		combinaison avec voisin de droite (pas -1 si gauche)
;		no premre cellule noeud :  1 !
;	A3.32 : ^noeud courant
;	D7.32 : 16..31 : Info pour suppression : si BTDELFA est  0 il
;		         sagit d'une suppression dans un noeud terminal,
;			 sinon c'est dans un noeud non terminal.
; out	A4.32 : Event nouvelle racine (l'arbre perd 1 degr)
;	D7.32 : 16..31 : Info modif racine (BTMODROOT set l'arbre perd 1
;		         degr). Tout les autres bits d'info sont mis  0
;		0..15  : Erreur						
; mod	A4.32 , D7.32 , F


RDEL:
	PUSHM.32 D1|D3|A1..A3|A6
	COMP.16	#1,{A3}+ONNBCEL	; C'est la dernire cellule ?
	JUMP,NE	R8^50$		; Non => 50$

				; Dernire cellule =>
	MOVE.32	#0,A4		; Le pauvre arbre est mort		-> A4
	TEST.32	D7:#BTDELFA	; La racine est terminale ?
	JUMP,BC	R8^10$		; Oui => 10$
				; Et non il n'est pas mort
	MOVE.32	{A3}+ONP0,A4	; Nouvelle racine de l'arbre		-> A4
10$:
	MOVE.32	A3,A6		; ^ancienne racine			-> A6
	CALL	TGIVMEM
	JUMP,NE	R8^90$
	TSET.32	D7:#BTMODROOT	; Signale changement racine
	JUMP	R8^90$

				; Ce n'est pas la dernire cellule => 
50$:				; Suppression due a une combinaison
	TEST.32	D7:#BTPIVOTL	; avec le voisin de gauche ?
	JUMP,BC	R8^60$		; Non => 60$
	DEC.16	D3		; No cellule a supprimer -1		-> D3
60$:
	MOVE.16	{A3}+ONNBCEL,D1	; Nb cellule dans racine		-> D1
	SUB.16	D3,D1		; Nb cel aprs cel a supprimer + 1	-> D1
	DEC.16	D1		; Nb cel a dcaler			-> D1
	JUMP,EQ	R8^80$		; Rien a dcaler => 80$	

	MUL.A16	#TLGCASE,D3
	MOVE.32	#{A3}+A16^{D3}+ONC1,A1	; ^cellule a supprimer		-> A1
	MOVE.32	#{A1}+TLGCASE,A2      	; ^cel suivant cel a supprimer	-> A2
	MUL.A16	#TLGCASE,D1	      	; Lg a dcaler			-> D1
	DEC.16	D1
70$:
	MOVE.8	{A2+},{A1+}		; Dcale les cellule aprs la
	DECJ.16,NMO D1,70$		; cellule a supprimer
80$:
	DEC.16	{A3}+ONNBCEL		; Une cellule en moin
90$:	
	AND.32	#2**BTMODROOT+H'FFFF,D7	; Pas suppression chez pre
	POPM.32	D1|D3|A1..A3|A6
	TEST.16	D7
	RET


;--------------\\
;   NDO_STAND	>
;--------------/

; Refait un noaud standard (plus de d-1 cel) a partir d'un noeud contenant
; d-1 cellules.
; Le terme de cellule pivot (celp) correspond  la cellule qui se trouve 
; dans le noeud pre entre les 2 pointeurs au noeud a quilibrer ou a 
; combiner. La cellule pivot avec la dfinition de D5 ci-dessous est soit
; celg soit celd. S'il y a combinaison la cellule pivot devra tre dtruite
; dans le noeud pre.

; in	D5.16 : No celg pre descente ...| celg | celd |...
;		No premire cellule noeud 1 !   v on est descendu par l
;	A3.32 : ^noeud courant                 
;	A0.32 : ^descr arbre
;	A5.32 : ^noeud pre
; out	D7.32 : 16..31 : Info sur event suppression cel pre 
;		0..15  : Erreur
; mod	D7.32 , F

NDO_STAND:
	PUSHM.32 D1|D5|A1..A2

	MOVE.32	D5,D1
	MUL.A16	#TLGCASE,D1
	MOVE.32	{A5}+A16^{D1}+ONC1-TLGCASE-TLGPT,A1 ; ^voisin de gauche	-> A1
	MOVE.32	{A5}+A16^{D1}+ONC1+TLGCASE-TLGPT,A2 ; ^voisin de droite	-> A2	


	MOVE.16	{A0}+OTVAL_D,D1	; D					-> D1
	TEST.16	D5		; Le voisin de gauche existe ?
	JUMP,EQ	R8^20$		; Non => 20$
	COMP.16	{A5}+ONNBCEL,D5	; Le voisin de droite existe ?
	JUMP,HS	R8^25$		; Non => 25$


	COMP.16	{A1}+ONNBCEL,D1 ; D cel dans voisin de gauche ?
	JUMP,EQ	R8^30$		; Oui => 30$
	COMP.16	{A2}+ONNBCEL,D1 ; D cel dans voisin de droite ?
	JUMP,EQ R8^35$		; Oui => 35$ 
	

	; Slection des paramtres de travail
	; On aura dans tout les cas : ^noeud voisin concern  -> A1.32
	;	 	            : no-1 cel pre concerne -> D5.16

	; Pas de combinaison possible et les 2 voisins existent. Il va 
	; donc faloir faire un quilibrage (cas 3)  =>
10$:
	MOVE.16	{A1}+ONNBCEL,D1	; Nb cellule dans voisin de gauche	-> D1
	COMP.16	{A2}+ONNBCEL,D1 ; Quel voisin a le moin de cellule ?
	JUMP,LO	R8^15$		; Celui de gauche => 15$
				; Celui de droite =>
				; nb cel gale    =>
	EX.32	A1,A2		; ^voisin de droite			-> A1
	TSET.32	D7:#BTPIVOTR	; Equilibrage  avec voisin de droite	-> D7
	JUMP	R8^50$
15$:
	DEC.16	D5		; No-1 cellule pivot			-> D5
	TSET.32	D7:#BTPIVOTL	; Equilibrage avec voisin de gauche	-> D7
	JUMP	R8^50$

	; Un des 2 voisins n'existe pas. On regarde alors si il faut faire
	; un quilibrage ou une combinaison (cas 3, cas 2) =>

20$:				; Voisin de gauche existe pas =>
	EX.32	A1,A2		; ^voisin de droite			-> A1   
	TSET.32	D7:#BTPIVOTR  	; Comb/equi avec voisin de droite	-> D7   
	COMP.16	{A1}+ONNBCEL,D1 ; D cel dans le voisin de droite ?
	JUMP,NE	R8^50$		; Non (pas combinaison) => 50$
	TSET.32	D7:#BTDELFA	; Il faudra supprimer une cel dans pre	-> D7
	JUMP	R8^50$	

25$:				; Voisin de droite existe pas =>
	DEC.16	D5		; No-1 cellule pivot			-> D5
	TSET.32	D7:#BTPIVOTL	; Comb/equi avec voisin de gauche	-> D7
	COMP.16	{A1}+ONNBCEL,D1 ; D cel dans le voisin de gauche ?
	JUMP,NE	R8^50$		; Non (pas combinaison) => 50$
	TSET.32	D7:#BTDELFA	; Il faudra supprimer une cel dans pre	-> D7
	JUMP	R8^50$

	; Les 2 voisins existent et au moin une combinaison est possible
	; avec un des voisins (cas 2) =>

30$:				; Avec celui de gauche =>
	DEC.16	D5		; No-1 cellule pivot			-> D5
	TSET.32	D7:#BTPIVOTL	; Combinaison avec voisin de gauche	-> D7
	TSET.32	D7:#BTDELFA	; Il faudra supprimer une cel dans pre	-> D7
	JUMP	R8^50$

35$:				; Avec celui de droite =>
	EX.32	A1,A2		; ^voisin de droite			-> A1
	TSET.32	D7:#BTPIVOTR	; Combinaison avec de voisin droite	-> D7
	TSET.32	D7:#BTDELFA	; Il faudra supprimer une cel dans pre	-> D7
;	JUMP	R8^50$

50$:
	TEST.32	D7:#BTDELFA	; Il y a combinaison de noeud ?
	JUMP,BC	R8^60$		; Non =>

	CALL	NDO_COMB	; Combine les 2 noeuds
	JUMP	R8^90$
60$:
	CALL	NDO_BALANCE	; Effectue l'quilibrage entre 2 noeuds
90$:				
	POPM.32	D1|D5|A1..A2
	TEST.16	D7
	RET


;--------------\\
; NDO_BALANCE	>
;--------------/

; Effectue l'equilibrage entre un noeud contenant d-1 cel et un autre en 
; contenant plus de d (cas 3).

; in	D5.16 : No -1 cellule pivot quilibrage ...| celp |....
;		no premire cellule noeud 1 !      v      v
;	A1.32 : ^nueud contenant d cellules ou plus (n+)
;	A3.32 : ^noeud contenant d-1 cellules       (n-)
;	A5.32 : ^noeud pre
;	D7.32 : 16..31 : Info sur position cellule pivot
; out	-
; mod	F

NDO_BALANCE:
	PUSHM.32 D2|D4|D5|A2|A4..A5

	MUL.16	#TLGCASE,D5
	MOVE.32	#{A5}+A16^{D5}+ONC1,A4 ; ^cellule pivot			-> A4

	MOVE.16	{A1}+ONNBCEL,D4	; Nb cellules plus grand noeud		-> D4
	SUB.16	{A3}+ONNBCEL,D4	; Nb cellules dsquilibrage		-> D4
	COMP.16	#1,D4		; Qu'une cellule de dsquilibre ?
	JUMP,EQ	R8^10$		; Oui => 10$
	SR.16	#1,D4		; Nb cellules a transfrer		-> D4

10$:
	TEST.32	D7:#BTPIVOTL	; Ou vont les cel transfres dans n- ?
	JUMP,BS	R8^50$		; Au dbut => 50$

	; On complte n-  la fin =>
	; Losqu'on complte n-  la fin :  la premre cellule ajoute est 
	; celle qui fait office de pivot. Les suivantes correspondent 
	; la tte de liste de n+. Le nouveau contenu du pivot correspond
	;  la premire cellule de n+ aprs transfert.
	;
	;                          | 12 |
	;                          v    v
	;      | 10 |    |    |    |    | 13 | 16 | 20 | 25 |
	;
        ;			     ||
        ;                            \/
	;
	;                          | 13 |
	;                          v    v
	;      | 10 | 12 |    |    |    | 16 | 20 | 25 |    |

	MOVE.16	{A3}+ONNBCEL,D5		; Nb cellules dans n-		-> D5
	MUL.A16	#TLGCASE,D5
	MOVE.32	#{A3}+A16^{D5}+ONC1,A2	; ^fin liste cellules n-	-> A2
	MOVE.32	#{A1}+ONP0,A5		; ^deb liste cellules n+	-> A5
	MOVE.16	D4,D5			; Nb cellule  dplacer		-> D5

					; Dplace le pivot =>
	MOVE.32	{A4},{A2+}		; Cl  pivot
	MOVE.32	{A4}+TLGKEY,{A2+}	; Info pivot
	MOVE.32	{A5+},{A2+}		; Init son ptas (P0 n+)
	DEC.16	D5			; Encore des cel a dplacer ?
	JUMP,EQ	R8^30$			; Non => 30$

	MUL.16	#TLGCASE,D5		; Transefert le reste =>
	DEC.16	D5			; Lg reste transfert -1		-> D5
20$:
	MOVE.8	{A5+},{A2+}		; Dplace n+ -> n-
	DECJ.16,NMO D5,20$
30$:					; Init nouveau contenu pivot =>
	MOVE.32	{A5+},{A4}		; Cl
	MOVE.32	{A5+},{A4}+TLGKEY	; Info

					; Ramne queue de n+ au dbut =>
	ADD.16	D4,{A3}+ONNBCEL		; Met  jour nb cellules n-
	SUB.16	D4,{A1}+ONNBCEL		; Met  jour nb cellules n+
	MOVE.16	{A1}+ONNBCEL,D5		; Nb cel restant dans n+	-> D5
	MUL.A16	#TLGCASE,D5		; Ne pas oublier de dplacer le
	ADD.16	#TLGPT-1,D5		; future P0 ,-1 DECJ, lg  depl	-> D5
	MOVE.32	#{A1}+ONP0,A2		; ^P0 n+			-> A2
40$:
	MOVE.8	{A5+},{A2+}		; Effectue le dcallage
	DECJ.16,NMO D5,40$
	JUMP	R8^90$

	; On complte n- au dbut =>
	; Losqu'on complte n- au dbut : la premre cellule ajoute est
	; celle qui fait office de pivot. Les suivantes correspondent 
	; la queue de liste de n+. Le nouveau contenu du pivot correspond
	;  la dernire cellule de n+ aprs transfert.
	;
	;                          | 20 |
	;                          v    v
	;      | 10 | 12 | 13 | 16 |    | 25 |    |    |    |
	;
        ;			     ||
        ;                            \/
	;
	;                          | 16 |
	;                          v    v
	;      | 10 | 12 | 13 |    |    | 20 | 25 |    |    |
50$:
	MOVE.16	{A3}+ONNBCEL,D5		; Nb cellules dans n-		-> D5
	MUL.A16	#TLGCASE,D5
	MOVE.32	#{A3}+A16^{D5}+ONC1,A5	; ^fin liste cellules n-	-> A5

	MOVE.16	D4,D5			; Nb cel a dcaller		-> D5
	MUL.A16	#TLGCASE,D5
	MOVE.32	#{A5}+A16^{D5},A2	; La fin de n- est dplc en	-> A2
	MOVE.16	{A3}+ONNBCEL,D5		; Nb cel dans n- ( dplacer)	-> D5
	MUL.A16	#TLGCASE,D5		; Taille qu'il faut
	ADD.16	#TLGPT-1,D5		; dplacer sans oublier p0	-> D5
60$:
	MOVE.8	{-A5},{-A2}		; Fait de la place au
	DECJ.16,NMO D5,60$		;  dbut de n-

					; Dplace la cellule pivot =>
	MOVE.32	{A4}+TLGKEY,{-A2}	; Info pivot
	MOVE.32	{A4},{-A2}		; Cl  pivot

					; Dplace la queue de n+ =>
	MOVE.16	{A1}+ONNBCEL,D5		; Nb cellules dans n+		-> D5
	MUL.A16	#TLGCASE,D5
	MOVE.32	#{A1}+A16^{D5}+ONC1,A5	; ^fin liste cellules n+	-> A5
	MOVE.16	D4,D5			; Nb cellule  dplacer -1
	DEC.16	D5			; (nb que l'on prend dans n+)	-> D5
	JUMP,EQ	R8^80$			; On en prend aucune => 80$
	MUL.A16	#TLGCASE,D5
	DEC.16	D5			; Lg  dplace-1		-> D5
70$:
	MOVE.8	{-A5},{-A2}		; Dplace la queue
	DECJ.16,NMO D5,70$
80$:					; Init p0 n- et nouveau pivot
	MOVE.32	{-A5},{-A2}		; Premier pt queue n+ -> p0 n-
	MOVE.32	{-A5},{A4}+TLGKEY	; Init info nouveaU pivot
	MOVE.32	{-A5},{A4}		; Init cl  nouveau pivot

	ADD.16	D4,{A3}+ONNBCEL		; Met  jour nb cellules n-
	SUB.16	D4,{A1}+ONNBCEL		; Met  jour nb cellules n+
;	JUMP	R8^90$
90$:	
	POPM.32 D2|D4|D5|A2|A4..A5
	RET


;--------------\\
;   NDO_COMB	>
;--------------/

; Effectue la combinaison entre une noeud contenant d-1 cellules et un 
; autre en contenant d. Le contenu du noeud rsultant est de 2d cellules
; puisque le pivot est intgr dans le noeud rsultat (cas 2).

; in	D5.16 : No -1 cellule pivot combinaison ...| celp |....
;		no premire cellule noeud 1 !      v      v
;	A0.32 : ^descr arbre
;	A1.32 : ^nueud contenant d cellules   (n+)
;	A3.32 : ^noeud contenant d-1 cellules (n-)
;	A5.32 : ^noeud pre
;	D7.32 : 16..31 : Info sur position cellule pivot
; out	D7.16 : Erreur
; mod	D7.16 , F

NDO_COMB:
   	PUSHM.32 D5|A1..A6
	MUL.16	#TLGCASE,D5
	MOVE.32	#{A5}+A16^{D5}+ONC1,A4 ; ^cellule pivot			-> A4

	; C'est toujours le noeud fils dont le pointeur est  droite 
	; du pivot qui doit tre complt : d'abord avec le pivot puis
	; avec les cellules de l'autre fils. Si le pivot est la cel
	; pre gauche alors A1 pointe en entre le noeude qui sera le
	;  noeud rsultant (nres), sinon c'est A3.

	TEST.32	D7:#BTPIVOTL	; Pivot est cel pre gauche ?
	JUMP,BC	R8^10$		; Non => 10$
	EX.32	A3,A1		; ^noeud rsultant			-> A3

10$:
	MOVE.32	A3,A5		      ; Sauve ^noeud rsultant		-> A5

	MOVE.16	{A3}+ONNBCEL,D5	      ; Nb cel dja dans nres		-> D5
	MUL.A16	#TLGCASE,D5
	MOVE.32	#{A3}+A16^{D5}+ONC1,A3; ^fin liste cel nres		-> A3

				      ; Dplace le pivot =>
	MOVE.32	{A4},{A3+}	      ; Cl  pivot
	MOVE.32	{A4}+TLGKEY,{A3+}     ; Info pivot
	MOVE.32	A1,A4		      ; Sauve ^noeud non rsultant	-> A4

				      ; Dplace cel n non res =>
	MOVE.16	{A1}+ONNBCEL,D5	      ; nb cellules dans n non res	-> D5
	MUL.A16	#TLGCASE,D5
	ADD.16	#TLGPT-1,D5	      ; Lg  dplacer sans oublier p0 !	-> D5
	MOVE.32	#{A1}+ONP0,A1	      ; ^dbut liste cel n non res	-> A1
50$:
	MOVE.8	{A1+},{A3+}	      ; Dplace les cellules
	DECJ.16,NMO D5,50$	

	MOVE.16	{A0}+OTVAL_2D,{A5}+ONNBCEL ; un beau noeud tout plein	!
	MOVE.32	A4,A6		           ; Redonne la mmoire utilise
	CALL	TGIVMEM		           ; par le noeud non rsultant
	POPM.32 D5|A1..A6
	TEST.16	D7
	RET


;--------------\\
;  GETADJCEL	>
;--------------/

; Retourne la cellule adjacente  une cellule donne en entre (La 
; cellule qui suit celle donne en entre dans l'ordre de classement).
; Cette routine fonctionne seulement si la cellule donne en entre se
; trouve dans un noeud intermdiaire. Dans ce cas la cellule adjacente
; se trouve en tte de liste du noeoud terminal le plus  gauche dans
; le sous arbre point par le ptas de la cellule donne en entre.

; in	A4.32 : ^Cellule donne en entre
; out	D0.32 : Cl  cel adj
;	D1.32 : Info cel adj
; mod	D0.32 , D1.32 ,  F

GETADJCEL:
	PUSH.32 A4
	MOVE.32	{A4}+TLGKEY+TLGINFO,A4 ; Ptas cel in			-> A4	
10$:
	TEST.32	{A4}+ONP0	; Le noeud courant est terminal ?
	JUMP,EQ	R8^50$		; Noeud le plus  gauche trouv => 50$
	MOVE.32	{A4}+ONP0,A4	; P0 noeud courant			-> A4
	JUMP	R8^10$		; On descend un max  gauche
50$:
	MOVE.32	{A4}+ONC1,D0	    ; Cl adj				-> D0
	MOVE.32	{A4}+ONC1+TLGKEY,D1 ; Info adj				-> D1
	POP.32	A4
	RET


;--------------\\
;   TGETMEM	>
;--------------/

; Demande la mmoire ncessaire pour un nouveau noeud.

; in	A0.32 : ^Descr arbre
; out	A6.32 : ^nouveau noeud
;	D7.16 : Erreur
; mod	D7.16 , F

TGETMEM:
	PUSHM.32 D1|D4|A1|A4
	CLR.32	D4		; Requte sur 32 bits                        
	MOVE.32	{A0}+OTLGNODE,D4; Taille d'un noeud			-> D4
	MOVE.32	{A0}+OTIDMEM,A1 ; Ident cpt mm.			-> A1
	MOVE.16	#MTYPAB,D1      ; Type  cpt mm.	 		-> D1
	GESMEM	?GETMEM		; ^nouvelle racine			-> A4
	MOVE.32	A4,A6		; Pas mod flag
	POPM.32	D1|D4|A1|A4	; Pas mod flag
	RET


;--------------\\
;   TGIVMEM	>
;--------------/

; Redonne la mmoire utilise par un noeud

; in	A0.32 : ^descr arbre
;	A6.32 : ^noeud
; out	D7.16 : Erreur
; mod	D7.16 , F

TGIVMEM:
	PUSHM.32 D1|A1|A4
	MOVE.32	A6,A4		; ^mmoire				-> A4
	MOVE.32	{A0}+OTIDMEM,A1 ; Ident cpt mm.			-> A1
	MOVE.16	#MTYPAB,D1      ; Type  cpt mm.	 		-> D1
	GESMEM	?GIVMEM		; Dtruit l'ancienne racine
	POPM.32	D1|A1|A4	; Pas mod flag
	RET


;--------------\\
;   ARBITRAGE	>
;--------------/

; Gnration du code grant l'arbitrage des accs  l'arbre. 
; Attention aux modifications de registres induitent par ces
; appels.

; in	A0.32 : ^descr arbre
; out	D7.32 : Erreur sinon pas mod
; mod	D5.32 , D6.32, A5.32 , F

TIN_NOEX:
	MA_INEXRD  {A0}+OTVARB, ERARB	; Entre accs non exclusif arbre
		   ^ Unknown instruction
	RET
TOUT_NOEX:
	MA_OUTEXRD {A0}+OTVARB, ERARB	; Sortie accs non exclusif arbre
		   ^ Unknown instruction
	RET
TIN_EX:
	MA_INEXWR  {A0}+OTVARB, ERARB	; Entre accs exclusif arbre 
		   ^ Unknown instruction
	RET
TOUT_EX:
	MA_OUTEXWR {A0}+OTVARB, ERARB	; Sortie accs exclusif arbre
		   ^ Unknown instruction
	RET
ERARB:					
	.16	H'A042			; ?AFTIM moniteur
	.ASCIZE	/<CR><CR>Erreur arbitrage librairie arbre<CR><CR>/
	TRAP	#0


; Variables globales dans le code ! :
; -----------------------------------
.PC	PCCODE
TGVAR:		.FILL.8 TGLGVAR,0


END_TREE:
.END    
