;$CALM;

	.TITLE	VM.ASL

;	----------------------------------------
;		(C) 1990 - Pierre Arnaud
;	----------------------------------------

;	Source d'un gestionnaire de mmoire bufferis. Les tranches
;	mmoire ont une taille maximale de 32'000 octets. Les accs
;	au gestionnaire passent toutes par une exclusion unique !


;	Date      Rv	Commentaire
;	-------------------------------------------------------------------------------
;	20/08/92  0.6	Vrifie que le bloc est bien le bon lorsque l'on libre de la
;			mmoire.
;	18/08/92  0.5	Ne boucle plus infiniment dans FINDFREEBLOC (c'tait KILLBLOC
;			qui ne retirait pas l'lment de la liste des libres, on le
;			retrouvait alors  double !)
;	10/07/92  0.4	N'utilise plus aucun appel LIB. Fonctionne donc avant que LIB
;			ne soit compltement initialis.
;	20/08/91  0.3	Optimisations en place. Nouvel appel VM_BUGETMEM permettant de
;			prendre des tranches de plus de 32Ko (en utilisant GESMEM).
;			Economis 2 octets pour chaque tranche "bu", car on ne garde
;			plus l'adresse du bloc, mais l'offset de l'lment dans le bloc.
;	25/07/91  0.2	Lors du KILLMCPT, on dtruit les fichiers qui tranent.
;	21/06/90  0.1a	On utilise le rpertoire spcifi en entre de l'appel CREMCPT
;			pour effectuer les oprations de SWAPPING. Chaque CREMCPT cre
;			un nom de fichier lgrement diffrent (Txxxbbbbbbbb.VM) o xxx
;			est propre au CREMCPT effectu.
;	19/06/90  0.0	Dbut des travaux (ter)
;	-------------------------------------------------------------------------------

;	Chaque lment de mmoire rserv par un VM_GETHANDLE prend en plus
;	de la taille mmoire requise :
;
;	   - 12 octets pour le handle.
;	   - 4 octets pour l'lment de mmoire.
;
;	En moyenne, on compte qu'un VM_GETHANDLE rserve 16.2 octets supplmentaires.
;	Cela signifie que pour 100'000 lments, on requiert 1.62 Mo pour le contrle.
;
;	Remarque :	Faire l'quivalent avec des GESMEM ?GETHANDLE prend 5.6 Mo,
;	----------	soit plus du double de place ( raison de 900 contre 122 us)


	.PROC	M68000
	.REF	SMAKY
	.REF	DOLIB
	.REF	VM
	.REF	MON

REVMAJ	= 0
REVMIN	= 6
REVPRO	= " "

	.REV	REVMAJ, REVMIN
	.CODE	800,11,2'000111,600,2000,300,2000,2,"N","E","F",11
	.IDENT	"(C)  Pierre ARNAUD et EPSITEC-system SA"
	.START	-1



;	Dfinitions pour assemblage
;	---------------------------


PCCODE		== 0
PCLOCAL		== 1
PCVAR		== 2

M68000		== TRUE

		.APC	PCVAR

;	Variables du module
;	-------------------

omodNB:		.BLK.16	1			; numro d'accs 0..n
lmod:

;	Variables globales
;	------------------

		.LOC	0

ovarFIRSTdb:	.BLK.32	1		; ^premier descripteur de bloc
ovarFREEdb:	.BLK.32	1		; ^premier descripteur de bloc libre
ovarLOCKdb:	.BLK.32	1		; smaphore pour verrouiller les accs
ovarNBLOCKdb:	.BLK.16	1		; compteur pour rendre accs au smaphore plus rapide
ovarSIZEbloc:	.BLK.16	1		; taille d'un bloc < 32'000 octets
ovarMARGEbloc:	.BLK.32	1		; marge mmoire  conserver
ovarNBdb:	.BLK.32	1		; nombre de descripteurs

ovarFIRSThb:	.BLK.32	1		; ^premier bloc de handles
ovarFREEhb:	.BLK.32	1		; ^premier bloc de handles libre
ovarLOCKhb:	.BLK.32	1		; smaphore pour verrouiller les accs
ovarNBLOCKhb:	.BLK.16	1		; compteur pour rendre accs au smaphore plus rapide
		.BLK.8	2

ovarMCPT:	.BLK.32	1		; descripteur du compte mmoire
ovarNAME:	.BLK.8	16		; nom du compte virtuel
ovarREP:	.BLK.8	128		; nom du rpertoire
ovarPNAME:	.BLK.32	1		; ^sur la fin du rpertoire indiqu
ovarLNAME:	.BLK.8	4		; nom local "Txxx"
OvarJOKER:	.BLK.8	5		; suite "*.VM<0>"
		.EVEN
lvar:

		.APC	PCLOCAL

;	Constantes diverses
;	-------------------

DEFSIZEBLOC	= 10000			; taille d'un bloc par dfaut
NBHANDLES	= 1000			; allocation par tranches de 1000 handles

bdbOK		= 0			; bloc mmoire ok
bdbDISK		= 1			; bloc mmoire sur disque
bdbEMPTY	= 2			; bloc mmoire vide (pas initialis)


;	Descripteur d'un bloc
;	---------------------

		.LOC	0

odbNEXT:	.BLK.32	1		; suivant
odbPREV:	.BLK.32	1		; prcdent
odbNEXTFREE:	.BLK.32	1		; libre suivant
odbPREVFREE:	.BLK.32	1		; libre prcdent

odbSELF:	.BLK.32	1		; ^sur soi-mme
odbPBLOC:	.BLK.32	1		; ^bloc
odbOFREE:	.BLK.16	1		; offset  l'lment libre dans le bloc
odbMAX:		.BLK.16	1		; taille maximale
odbNBUSED:	.BLK.16	1		; nombre de tranches utilises
odbNBLOCK:	.BLK.32	1		; nombre de verrouillages des lments contenus
odbFLAG:	.BLK.8	2		; fanions
odbSIZE:	.BLK.16	1		; taille

odbNUMFILE:	.BLK.8	8+2		; place pour le "nnnnnnnn"
ldb:


;	Dfinition pour un bloc de handles
;	----------------------------------

		.LOC	0

ovmhbNEXT:	.BLK.32	1		; prochain bloc
ovmhbPREV:	.BLK.32	1		; bloc prcdent
ovmhbNEXTFREE:	.BLK.32	1		; prochain bloc libre
ovmhbFREE:	.BLK.32	1		; premier lment libre du bloc
ovmhbNBUSED:	.BLK.16	1		; nombre de handles utiliss dans le bloc
ovmhbFLAG:	.BLK.16	1
lvmhb:

;	Dfinition d'un handle utilis
;	------------------------------

		.LOC	0

ovmhPBLOC:				; pointeur au bloc contenant la tranche
ovmhNEXTFREE:	.BLK.32	1		; ou pointeur au handle libre suivant
ovmhOTRANCHE:	.BLK.16	1		; offset  la tranche dans le bloc
ovmhNBLOCK:	.BLK.16	1		; nombre de "locks" effectus
ovmhPHBLOC:	.BLK.32	1		; pointeur sur le dbut du bloc de handles de ce handle
lvmh:

		.APC	PCCODE


;	En-tte du module de librairie
;	------------------------------

	.LOC	0

BASE:	.16	VM_FIRST
	.16	VM_LAST
	.8	0
	.FILL.8	(OHLREV-APC),0
	.8	REVMAJ,REVMIN
	.32	END_MODULE
	.32	PATHLIB
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"VM"
	.FILL.8	(LGHLIB-APC),0

	.16	vmCREMCPT		; cre un compte de mmoire virtuelle
	.16	vmKILLMCPT		; tue un compte de mmoire virtuelle
	.16	vmHANDLEget		; demande le handle  une tranche mmoire
	.16	vmHANDLEgiv		; rend le handle d'une tranche mmoire
	.16	vmHANDLElock		; verrouille un handle et cherche l'adresse
	.16	vmHANDLEunlock		; dverrouille un handle

	.16	buOPEN			; ouvre un compte mmoire bufferis
	.16	buCLOSE			; ferme & libre un compte mmoire buf.
	.16	buGET			; cherche une tranche mmoire (D4.16)
	.16	buGIV			; rend une tranche mmoire
	.16	buGETMEM		; cherche une tranche mmoire (D4.32)


;	Routines de gestion de la mmoire
;	---------------------------------

vmNAME:		.ASCIZ	"vmMEMORY"
vmBUNAME:	.ASCIZ	"buMEMORY"
vmJOKER:	.ASCIZ	"*.VM"
		.EVEN


;------------\\
;  vmCREMCPT  >
;============/

; Cre un compte de mmoire virtuelle.

; in	A0.32	^nom du rpertoire (ou ^<0>)
;	A3.32	^nom du compte (max 15 lettres)
;	D1.16	type du compte GESMEM pre
;	A1.32	descripteur du compte GESMEM pre
;	D2.32	marge  garder en mmoire
;	D3.16	taille d'un bloc (0 si taille par dfaut)
; out	A2.32	descripteur du compte de mmoire virtuelle
;	D7.16	erreur
; mod	A2.32, D7.16

vmCREMCPT:
	PUSHM.32 D1|D3|D4|A1|A3|A4

	MOVE.32	A3,A4				; A4 <-- ^nom
	TEST.32	D3				; taille par dfaut ?
	JUMP,NE	R8^NODEF$
	MOVE.32	#DEFSIZEBLOC,D3

NODEF$:	MOVE.32	#R16^vmNAME,A3
	GESMEM	?CREMCPT			; cre le sous-compte
	JUMP,NE	R8^ERR$

	MOVE.32	A4,A3				; A3 <-- ^nom
	MOVE.32	A2,A1				; A1 <-- descripteur du compte  utiliser
	MOVE.32	#MTYPUSER,D1			; D1 <-- compte utilisateur tout neuf

	MOVE.32	#lvar,D4
	GESMEM	?GETMEM				; demande mmoire pour le compte
	JUMP,NE	R8^ERR$

	GESMEM	?CLEARMEM
	MOVE.32	A4,A2				; A2 <-- "compte" de mmoire virtuelle

	MOVE.32	A1,{A2}+ovarMCPT		; conserve le descripteur du compte GESMEM
	MOVE.16	D3,{A2}+ovarSIZEbloc		; conserve taille d'un bloc
	MOVE.32	D2,{A2}+ovarMARGEbloc		; marge  conserver en mmoire

	MOVE.32	#{A2}+ovarNAME,A4
	MOVE.32	#15-1,D4

COPYN$:	MOVE.8	{A3+},{A4+}			; copie le nom (15 car au maximum)
	SKIP,EQ	DJ.16,NMO D4,COPYN$
	CLR.8	{A4}

	CALL	INITBLOCMEM
	JUMP,NE	R8^ERR$
	CALL	vmHANDLEinit
	CALL	INITNAME			; initialise les noms

ERR$:	POPM.32	D1|D3|D4|A1|A3|A4
	TEST.16	D7
	RET

;-----------\\
;  INITNAME  >
;===========/

; Initialise le nom local & le nom du rpertoire

; in	A0.32	^nom du rpertoire
;	A2.32	^variables
; out	D7.16
; mod	D7.16

INITNAME:
	PUSHM.32 D2|D3|D4|A3|A4|A5

	MOVE.32	#R16^BASE,A4
	MOVE.32	#lmod,D4
	TSET.32	D4:#31				; demande un smaphore
	FOS	?GETCOMMEM
	JUMP,NE	R8^ERR$

	NTREL	?LOCK
	CLR.32	D4
	MOVE.16	{A4},D4				; D4 <-- numro spcial propre au module
	INC.16	{A4}
	NTREL	?UNLOCK

	MOVE.32	#{A2}+ovarLNAME,A4		; initialise le nom "Txxx"
	MOVE.8	#"T",{A4+}
	MOVE.32	#3-1,D2

DO$:	MOVE.8	D4,D3
	SR.32	#5,D4				; dcale (divise par 32)
	AND.8	#16'1F,D3			; nombre 0..31
	COMP.8	#10,D3
	JUMP,LT	R8^NUM$
	ADD.8	#"A"-"0"-10,D3
NUM$:	ADD.8	#"0",D3				; D3 <-- "0".."9", "A".."V"
	MOVE.8	D3,{A4+}
	DJ.16,NMO D2,DO$

	MOVE.32	A0,A3
	TEST.8	{A3}				; rpertoire <0> ?
	JUMP,NE	R8^OK$
	FOS	?GDIR				; demande le rpertoire courant

OK$:	MOVE.32	#{A2}+ovarREP,A4		; A4 <-- ^buffer

COPY$:	MOVE.8	{A3+},{A4+}
	JUMP,NE	R8^COPY$
	DEC.32	A4

	MOVE.32	#{A2}+ovarLNAME,A3
	MOVE.8	{A3+},{A4+}
	MOVE.8	{A3+},{A4+}
	MOVE.8	{A3+},{A4+}
	MOVE.8	{A3+},{A4+}			; on a enfin le nom "rp:Txxx" qui est prt
	MOVE.32	A4,{A2}+ovarPNAME		; mmorise le ^fin de nom
	MOVE.8	#".",{A4}+8
	MOVE.8	#"V",{A4}+9
	MOVE.8	#"M",{A4}+10
	CLR.8	{A4}+11				; il n'y a plus qu' placer le numro de bloc !

ERR$:	POPM.32	D2|D3|D4|A3|A4|A5
	TEST.16	D7
	RET




;-------------\\
;  vmKILLMCPT  >
;=============/

; Dtruit le compte de mmoire virtuelle.

; in	A2.32	descripteur du compte de mmoire virtuelle  dtruire
;	D1.16	type du compte GESMEM pre
;	A1.32	descripteur du compte GESMEM pre
; out	D7.16	erreur
; mod	D7.16

vmKILLMCPT:
	PUSHM.32 D0|D1|A0|A1|A2

	PUSHM.32 D3|D4|D6|A3|A4

	MOVE.32	{A2}+ovarPNAME,A3
	CLR.8	{A3}-4				; place <0>  la fin du rp.

	MOVE.32	#{A2}+ovarJOKER,A3
	MOVE.32	#R16^vmJOKER,A4

COPY1$:	MOVE.8	{A4+},{A3+}
	JUMP,NE	COPY1$

	MOVE.32	#{A2}+ovarREP,A3		; A3 <-- ^nom "rp:"
	MOVE.32	#{A2}+ovarLNAME,A4		; A4 <-- ^nom "Txxx*.VM"
	MOVE.32	#0,D3

	FOS	?LISTOPEN
	JUMP,NE	R8^BADLIST$

NEXT$:	FOS	?LISTNXT
	JUMP,NE	R8^FINLIST$

	MOVE.32	{A2}+ovarPNAME,A4
	SUB.32	#4,A4

COPY2$:	MOVE.8	{A3+},{A4+}
	JUMP,NE	COPY2$

	MOVE.32	#{A2}+ovarREP,A3
	FOS	?DELETE
	JUMP	NEXT$

FINLIST$:
	FOS	?LISTCLOSE

BADLIST$:
	POPM.32	D3|D4|D6|A3|A4

	CALL	KILLBLOCMEM
	CALL	vmHANDLEkill

	MOVE.32	A1,A0
	MOVE.32	D1,D0

	MOVE.32	#MTYPUSER,D1
	MOVE.32	{A2}+ovarMCPT,A1
	GESMEM	?GBAMEM				; rend brutalement tout

	MOVE.32	A1,A2				; A2 <-- sous-compte vid  dtruire
	MOVE.32	A0,A1				; A1 <-- descripteur du compte GESMEM pre
	MOVE.32	D0,D1				; D1 <-- compte mmoire GESMEM pre
	GESMEM	?KILLMCPT

ERR$:	POPM.32	D0|D1|A0|A1|A2
	TEST.16	D7
	RET


;

;	----------------------------------------------------------------------------------



;---------\\
;  buOPEN  >
;=========/

; Cre un compte de mmoire bufferis.

; in	A3.32	^nom du compte (max 15 lettres)
;	D1.16	type du compte GESMEM pre
;	A1.32	descripteur du compte GESMEM pre
;	D3.16	taille d'un bloc (0 si taille par dfaut)
; out	A2.32	descripteur du compte de mmoire bufferis
;	D7.16	erreur
; mod	A2.32, D7.16

buOPEN:
	PUSHM.32 D1|D3|D4|A1|A3|A4

	MOVE.32	A3,A4				; A4 <-- ^nom
	TEST.32	D3				; taille par dfaut ?
	JUMP,NE	R8^NODEF$
	MOVE.32	#DEFSIZEBLOC,D3

NODEF$:	MOVE.32	#R16^vmBUNAME,A3
	GESMEM	?CREMCPT			; cre le sous-compte
	JUMP,NE	R8^ERR$

	MOVE.32	A4,A3				; A3 <-- ^nom
	MOVE.32	A2,A1				; A1 <-- descripteur du compte  utiliser
	MOVE.32	#MTYPUSER,D1			; D1 <-- compte utilisateur tout neuf

	MOVE.32	#lvar,D4
	GESMEM	?GETMEM				; demande mmoire pour le compte
	JUMP,NE	R8^ERR$

	GESMEM	?CLEARMEM
	MOVE.32	A4,A2				; A2 <-- "compte" de mmoire virtuelle

	MOVE.32	A1,{A2}+ovarMCPT		; conserve le descripteur du compte GESMEM
	MOVE.16	D3,{A2}+ovarSIZEbloc		; conserve taille d'un bloc

	MOVE.32	#{A2}+ovarNAME,A4
	MOVE.32	#15-1,D4

COPYN$:	MOVE.8	{A3+},{A4+}			; copie le nom (15 car au maximum)
	SKIP,EQ	DJ.16,NMO D4,COPYN$
	CLR.8	{A4}

	CALL	INITBLOCMEM

ERR$:	POPM.32	D1|D3|D4|A1|A3|A4
	TEST.16	D7
	RET


;----------\\
;  buCLOSE  >
;==========/

; Dtruit le compte de mmoire bufferis.

; in	A2.32	descripteur du compte de mmoire bufferis.
;	D1.16	type du compte GESMEM pre
;	A1.32	descripteur du compte GESMEM pre
; out	D7.16	erreur
; mod	D7.16

buCLOSE:
	PUSHM.32 D0|D1|A0|A1|A2

	CALL	KILLBLOCMEM

	MOVE.32	A1,A0
	MOVE.32	D1,D0

	MOVE.32	#MTYPUSER,D1
	MOVE.32	{A2}+ovarMCPT,A1
	GESMEM	?GBAMEM				; rend brutalement tout

	MOVE.32	A1,A2				; A2 <-- sous-compte vid  dtruire
	MOVE.32	A0,A1				; A1 <-- descripteur du compte GESMEM pre
	MOVE.32	D0,D1				; D1 <-- compte mmoire GESMEM pre
	GESMEM	?KILLMCPT

ERR$:	POPM.32	D0|D1|A0|A1|A2
	TEST.16	D7
	RET


;--------\\
;  buGET  >
;========/

; Cherche une tranche mmoire de taille < 32'000.

; in	D4.16	taille de la tranche
;	A2.32	compte
; out	A4.32	^tranche
;	D7.16	erreur
; mod	A4.32, D7.16

buGET:
	PUSH.32 D4
	AND.32	#16'7FFF,D4
	CALL	R8^buGETMEM
	POP.32	D4
	TEST.16	D7
	RET


;-----------\\
;  buGETMEM  >
;===========/

; Cherche une tranche mmoire de taille quelconque. Lorsque la taille
; est suprieure  32000, on passe simplement par GESMEM.

; in	D4.32	taille de la tranche
;	A2.32	compte
; out	A4.32	^tranche
;	D7.16
; mod	A4.32, D7.16

buGETMEM:
	PUSHM.32 D3|D4|A3

	ADD.32	#2,D4				; garde de la place pour l'offset dans le bloc
	CALL	GETELEM				; demande un lment
	JUMP,NE	R8^ERR$

	MOVE.32	A3,A4				; A4 <-- si GESMEM ?GETMEM, alors ^mmoire
	TEST.16	D3				; offset ngatif ?
	JUMP,NS	R8^GETMEM$			; oui => suite d'un appel  GESMEM ?GETMEM

	MOVE.32	{A3}+odbPBLOC,A4		; A4 <-- ^bloc
	MOVE.32	A3,{A4}-4			; prend note du ^bloc (rserve spciale pour a)
	ADD.A16	D3,A4				; A4 <-- ^dans le bloc, sur la tranche de mmoire

GETMEM$:
	MOVE.16	D3,{A4+}			; A4 ^tranche mmoire

ERR$:	POPM.32	D3|D4|A3
	TEST.16	D7
	RET


;--------\\
;  buGIV  >
;========/

; Rend une tranche de mmoire

; in	A2.32	compte
;	A4.32	^dbut de la tranche
; out	D7.16	erreur
; mod	D7.16

buGIV:
	PUSHM.32 D3|A3

	MOVE.32	A4,A3
	MOVE.16	{-A3},D3			; D3 <-- offset
	JUMP,NS	R8^GIVMEM$			; ngatif => faut faire un GESMEM ?GIVMEM

	SUB.A16	D3,A3				; A3 <-- ^dbut du bloc
	MOVE.32	{A3}-4,A3			; A3 <-- ^descripteur du bloc
						; D3 <-- offset dans le bloc

GIVMEM$:
	CALL	GIVELEM				; rend l'lment

ERR$:	POPM.32	D3|A3
	TEST.16	D7
	RET


;	----------------------------------------------------------------------------------


;--------------\\
;  INITBLOCMEM  >
;==============/

; Initialise le gestionnaire de blocs de mmoire.

; in	-
; out	D7.16
; mod	D7.16

INITBLOCMEM:
	PUSHM.32 D4|A5

	MOVE.16	#-1,{A2}+ovarNBLOCKdb
	CLR.16	D4
	NTREL	?CRESEM
	MOVE.32	A5,{A2}+ovarLOCKdb

	CLR.32	{A2}+ovarFIRSTdb
	CLR.32	{A2}+ovarFREEdb
	CLR.32	{A2}+ovarNBdb

ERR$:	POPM.32	D4|A5
	TEST.16	D7
	RET


;--------------\\
;  KILLBLOCMEM  >
;==============/

; Supprime le gestionnaire de blocs mmoire.

; in	-
; out	D7.16
; mod	D7.16

KILLBLOCMEM:
	PUSH.32 A5

	MOVE.32	{A2}+ovarLOCKdb,A5
	NTREL	?KILLSEM

ERR$:	POP.32	A5
;	TEST.16	D7
	RET


;-----------\\
;  LOCKBLOC  >
;===========/

; Verrouille l'accs au bloc.

; in	-
; out	-
; mod	-

LOCKBLOC:
	INC.16	{A2}+ovarNBLOCKdb
	JUMP,NE	R8^LOCK$			; si plusieurs, utilise le smaphore
	RET

LOCK$:	PUSHM.32 D7|A5
	MOVE.32	{A2}+ovarLOCKdb,A5

W$:	NTREL	?WAITEV				; attend sur le smaphore, mme si time-out
	JUMP,NE	R8^W$

	POPM.32	D7|A5
	RET


;-------------\\
;  UNLOCKBLOC  >
;=============/

; Dverrouille l'accs au bloc.

; in	-
; out	-
; mod	-

UNLOCKBLOC:
	DEC.16	{A2}+ovarNBLOCKdb
	JUMP,GE	R8^ULOCK$			; si plusieurs, utilise le smaphore
	RET

ULOCK$:	PUSHM.32 D7|A5
	MOVE.32	{A2}+ovarLOCKdb,A5
	NTREL	?SIGNEV				; libre premier en attente sur le smaphore
	POPM.32	D7|A5
	RET


;----------\\
;  GETELEM  >
;==========/

; Cherche un lment dans un bloc

; in	D4.32	taille de l'lment
; out	A3.32	^descripteur de bloc/^tranche mmoire GESMEM
;	D3.16	offset (si -1 => A3 ^tranche mmoire GESMEM)
;	D7.16	erreur
; mod	A3.32, D3.32 (!), D7.16

GETELEM:
	PUSHM.32 D4

	COMP.32	#32000,D4
	JUMP,LO	R8^BLOC$			; ok, on gre par un lment dans un bloc

;	Appel GESMEM normal si la tranche est trop grande.
;	--------------------------------------------------

	PUSHM.32 D1|A1|A4

	MOVE.32	#MTYPUSER,D1
	MOVE.32	{A2}+ovarMCPT,A1
	GESMEM	?GETMEM				; prend la tranche telle quelle
	MOVE.32	#-1,D3
	MOVE.32	A4,A3				; rend le ^tranche GESMEM

	POPM.32	D1|A1|A4
	JUMP	ERR$

;	Appel GESMEM vit. On prend dans un bloc ayant assez de place
;	--------------------------------------------------------------

BLOC$:	CALL	LOCKBLOC			; **** zone d'exclusion

	INC.16	D4
	TCLR.32	D4:#0				; arrondir au .16
	COMP.16	#4,D4
	JUMP,HS	R8^SIZE$

	MOVE.32	#4,D4

SIZE$:	CALL	FINDFREEBLOC			; cherche le ^descripteur de bloc avec de la place
	JUMP,NE	R8^ER$				; erreur => abandonne

	CALL	GETrealELEM			; prend vraiment l'lment

ER$:	CALL	UNLOCKBLOC			; **** fin zone d'exclusion

ERR$:	POPM.32	D4
	TEST.16	D7
	RET


;----------\\
;  GIVELEM  >
;==========/

; Rend un lment de mmoire.

; in	A3.32	^descripteur de bloc/^tranche mmoire GESMEM
;	D3.16	offset (si -1 => A3 ^tranche mmoire GESMEM)
; out	D7.16	erreur
; mod	D7.16

GIVELEM:
	TEST.16	D3
	JUMP,GE	R8^BLOC$

	PUSHM.32 D1|A1|A4

	MOVE.32	#MTYPUSER,D1
	MOVE.32	{A2}+ovarMCPT,A1
	MOVE.32	A3,A4
	GESMEM	?GIVMEM				; rend la tranche  GESMEM

	POPM.32	D1|A1|A4
	JUMP	R8^ERR$

BLOC$:	COMP.32	{A3}+ODBSELF,A3			; est-ce bien un bloc ?
	JUMP,EQ	R8^RIGHT$			; oui => ok

	MOVE.16	#ERILPT,D7			; retourne "pointeur illgal"
	JUMP	R8^ERR$

RIGHT$:	CALL	LOCKBLOC			; **** zone d'exclusion

	TEST.8	{A3}+odbFLAG:#bdbOK		; bloc ok ?
	JUMP,BS	R8^OK$				; oui => c'est bon
	CALL	SWAPLOAD			; non => charge le bloc
	JUMP,NE	R8^ER$

OK$:	CALL	GIVrealELEM			; rend vraiment l'lment

ER$:	CALL	UNLOCKBLOC			; **** fin zone d'exclusion

ERR$:	TEST.16	D7
	RET



;--------------\\
;  GETrealELEM  >
;==============/

; Prend un lment dans un bloc o il y a de la place.

; in	A3.32	^descripteur de bloc avec de la place
;	D4.16	taille modulo 2
; out	D3.16	offset lment dans le bloc
;	D7.16	erreur (il faut ressayer)
; mod	D3.16, D7.16

GETrealELEM:
	PUSHM.32 D0|D1|D2|D6|A4

	MOVE.16	#1,D7				; D7 <-- erreur, il faut recommencer..

	MOVE.32	{A3}+odbPBLOC,D6		; adresse de base du bloc
	JUMP,EQ	ERR$				; nulle => fin

	MOVE.A16 {A3}+odbOFREE,A4
	ADD.32	D6,A4				; adresse du premier lment libre
	MOVE.32	#-1,D1				; D1 <-- taille maximale
	MOVE.32	#-1,D2				; D2 <-- ^lment favorable

LOOP$:	MOVE.16	{A4}-2,D0			; D0 <-- taille de l'lment actuel
	COMP.16	D0,D4
	JUMP,EQ	R8^FIT$				; taille correcte, ok..
	JUMP,HI	R8^NEXT$			; taille trop petite !

	COMP.16	D0,D1				; ancienne taille meilleure ?
	JUMP,LO	R8^NEXT$			; oui => garde l'ancienne

	MOVE.16	D0,D1
	MOVE.32	A4,D2				; conserve lment adquat

NEXT$:	TEST.16	{A4}				; lment suivant
	JUMP,EQ	R8^FOUND$
	MOVE.A16 {A4},A4
	ADD.32	D6,A4
	JUMP	R8^LOOP$

FIT$:	MOVE.16	D0,D1
	MOVE.32	A4,D2				; conserve lment adquat

FOUND$:	TEST.16	D1
	JUMP,LE	R8^ERR$				; rien trouv => rend une erreur

	MOVE.32	D2,A4
	CALL	UNLINKELEM			; dlie des autres lments (ajuste taille)

	MOVE.16	D1,D0				; D0 <-- taille de l'lment
	SUB.16	D4,D0				; D0 <-- reste si on supprime ce que l'on utilise
	SUB.16	#4,D0				; D0 <-- reste si on dsire tronquer
	COMP.16	#4,D0
	JUMP,LT	R8^USE$				; reste pas assez grand pour tre utilisable

	MOVE.16	D4,{A4}-2			; nouvelle indication de taille au dbut
	MOVE.16	D4,{A4}+A16^{D4}		; nouvelle indication de taille  la fin
	MOVE.16	D0,{A4}+A16^{D4}+2		; nouvelle indication de taille au dbut second
	MOVE.16	D0,{A4}+A16^{D1}		; nouvelle indication de taille  la fin second

	PUSH.32	A4
	MOVE.32	#{A4}+A16^{D4}+4,A4
	CALL	LINKELEM			; ajoute l'lment dans la liste (ajuste taille)
	POP.32	A4

USE$:	CLR.16	D7
	MOVE.16	{A4}-2,D0
	TSET.8	{A4}-2:#7			; signale que le bloc est occup au dbut
	TSET.8	{A4}+A16^{D0}:#7		; signale que le bloc est occup  la fin
	MOVE.32	A4,D3
	SUB.32	D6,D3				; D3 <-- offset  l'lment
	INC.16	{A3}+odbNBUSED			; une utilisation de plus

ERR$:	POPM.32	D0|D1|D2|D6|A4
	TEST.16	D7
	RET


;--------------\\
;  GIVrealELEM  >
;==============/

; Rend rellement l'lment.

; in	A3.32	^descripteur du bloc
;	D3.16	offset de l'lment
; out	-
; mod	D7.16

GIVrealELEM:
	PUSHM.32 D0|D4|D6|A4

	MOVE.32	{A3}+odbPBLOC,D6		; ^dbut du bloc
	MOVE.32	D6,A4
	ADD.A16	D3,A4				; A4 <-- ^lment  rendre

	TCLR.8	{A4}-2:#7			; lment plus utilis
	MOVE.16	{A4}-2,D4			; D4 <-- taille de l'lment
	TCLR.8	{A4}+A16^{D4}:#7		; lment plus utilis (indication de queue)

	TEST.8	{A4}-4:#7			; lment prcdent utilis ?
	JUMP,BS	R8^noUP$			; oui => pas de fusion en amont !

	MOVE.16	{A4}-4,D0
	ADD.16	#4,D0
	SUB.A16	D0,A4				; A4 <-- ^lment prcdent
	CALL	UNLINKELEM			; extrait le prcdent de la liste des libres

	ADD.16	D0,D4
	MOVE.16	D4,{A4}-2
	MOVE.16	D4,{A4}+A16^{D4}		; met  jour la taille au dbut &  la fin

noUP$:	TEST.8	{A4}+A16^{D4}+2:#7		; lment suivant utilis ?
	JUMP,BS	R8^noDOWN$			; oui => pas de fusion plus bas

	PUSH.32	A4

	MOVE.16	{A4}+A16^{D4}+2,D0
	ADD.16	#4,D4
	ADD.A16	D4,A4				; A4 <-- ^lment suivant
	ADD.16	D0,D4				; D4 <-- taille une fois fusionn
	CALL	UNLINKELEM			; extrait le suivant de la liste des libres

	POP.32	A4

	MOVE.16	D4,{A4}-2
	MOVE.16	D4,{A4}+A16^{D4}		; met  jour la taille au dbut &  la fin

noDOWN$:
	CALL	LINKELEM			; rend l'lment au bloc
	DEC.16	{A3}+odbNBUSED			; une utilisation de moins
	JUMP,NE	R8^ERR$

	CALL	KILLBLOC			; dtruit le bloc de mmoire, on n'en a plus besoin

ERR$:	POPM.32	D0|D4|D6|A4
	TEST.16	D7
	RET



;--------------\\
;  ADDBLOCDESC  >
;==============/

; Ajoute un descripteur de bloc dans la liste.

; in	-
; out	A3.32	^descripteur ajout
;	D7.16	erreur
; mod	A3.32, D7.16

ADDBLOCDESC:
	PUSHM.32 D1|D2|D3|D4|A1|A4

	MOVE.32	#MTYPUSER,D1
	MOVE.32	{A2}+ovarMCPT,A1
	MOVE.32	#ldb,D4
	GESMEM	?GETMEM				; cre un descripteur de bloc sur le compte interne
	JUMP,NE	R8^ERR$

	GESMEM	?CLEARMEM			; vide la mmoire
	MOVE.32	A4,{A4}+odbSELF			; <- pointeur sur soi-mme
	TSET.8	{A4}+odbFLAG:#bdbEMPTY		; <- bloc inutilis
	MOVE.32	A4,A3
	ADD.A16	#odbNUMFILE,A4			; A4 <-- buffer pour numro d'ordre
	MOVE.32	{A2}+ovarNBdb,D4		; D4 <-- numro d'ordre de ce descripteur
	INC.32	{A2}+ovarNBdb

	MOVE.32	#8,D3
	CALL	PUTHEX				; place le numro d'ordre (hexa)

	MOVE.32	{A2}+ovarFIRSTdb,A1
	MOVE.32	A1,{A3}+odbNEXT			; suivant de premier (ou ^nil)
	JUMP,EQ	R8^EMPTY$			; aucun => tout simple

	MOVE.32	A3,{A1}+odbPREV			; prcdent de second

EMPTY$:	CLR.32	{A3}+odbPREV			; pas de prcdent
	MOVE.32	A3,{A2}+ovarFIRSTdb		; premier unique

ERR$:	POPM.32	D1|D2|D3|D4|A1|A4
	TEST.16	D7
	RET



;---------\\
;  PUTHEX  >
;=========/

; Place un nombre hexa dans un buffer donn. Place les "n" digits demands
; mais pas de terminateur

; in	A4.32	^buffer
;	D4.32	nombre hexa
;	D3.16	nombre de digits (1..8, pas de vrif)
; out	A4.32	^plus loin (pas de terminateur)
; mod	A4.32

PUTHEX:
	PUSHM.32 D2|D3|D4

	MOVE.16	#8,D2
	SUB.16	D3,D2				; nombre de "rotations" ncessaires
	JUMP,EQ	R8^OK$
	SL.16	#2,D2				; D2 <-- nombre de crans  dcaler
	RL.32	D2,D4

OK$:	DEC.16	D3				; un de moins (pour le NMO)

LOOP$:	RL.32	#4,D4				; [0..3] <-- bits de poids le plus fort
	MOVE.8	D4,D2
	AND.8	#16'0F,D2			; conserve que bits [0..3]
	COMP.8	#10,D2
	JUMP,LT	R8^DEC$
	ADD.8	#"A"-"0"-10,D2

DEC$:	ADD.8	#"0",D2
	MOVE.8	D2,{A4+}
	DJ.16,NMO D3,LOOP$			; suite

ERR$:	POPM.32	D2|D3|D4
	TEST.16	D7
	RET



;----------\\
;  ADDBLOC  >
;==========/

; Ajoute un bloc de mmoire.

; in	D4.16	taille
; out	A3.32	^descripteur du bloc
;	D7.16	erreur
; mod	A3.32, D7.16

ADDBLOC:
	PUSHM.32 D1|D4|D5|A1|A4

	COMP.16	{A2}+ovarSIZEbloc,D4
	JUMP,HS	R8^SIZE$			; taille ok ?

	MOVE.16	{A2}+ovarSIZEbloc,D4		; si trop petite, met  jour

SIZE$:	AND.32	#16'00007FFF,D4			; taille maximale
	ADD.16	#8+4,D4				; 2 au dbut, 2  la fin + rserve + 4 en {A4}-4

	TEST.32	{A2}+ovarMARGEbloc
	JUMP,EQ	R8^OK$

	PUSH.32 D4
	GESMEM	?ARGMEM				; vrifie taille mmoire disponible
	MOVE.32	D4,D1				; D1 <-- nombre de bytes encore libres
	POP.32	D4

	COMP.32	#50000,D5
	JUMP,HI	R8^NSWF$

	CALL	SWAPFREE			; tente de faire de la place

NSWF$:	COMP.32	{A2}+ovarMARGEbloc,D1		; marge pas encore dpasse ?
	JUMP,HI	R8^OK$				; non => fonctionnement normal

	CALL	SWAPGETBLOC			; A3 <-- bloc libr avec de la place
	JUMP,EQ	R8^ERR$				; ok => fin, sinon, mthode conventionnelle

OK$:	CALL	FINDemptyDB			; cherche ^db pas utilis
	JUMP,NE	R8^ERR$

	MOVE.32	#MTYPUSER,D1
	MOVE.32	{A2}+ovarMCPT,A1
	GESMEM	?GETMEM				; cre un descripteur de bloc sur le compte interne
	JUMP,NE	R8^ERR$

	ADD.A16	#4,A4				; A4 <-- ^dbut du bloc, en {A4}-4 il y a une rserve
						; utilise uniquement par VM_BU(GET/GIV)(MEM)
	SUB.16	#8+4,D4
	MOVE.16	D4,{A4}+2			; dbut, indique taille du trou
	MOVE.16	D4,{A4}+A16^{D4}+4		; fin, indique taille du trou
	CLR.32	{A4}+4				; pas de suivant, pas de prcdent

	MOVE.16	D4,{A4}
	TSET.8	{A4}:#7				; indique que premier lment pris (pas de fusion)
	MOVE.16	#16'CACA,{A4}+A16^{D4}+4+2	; indique que dernier lment pris (pas de fusion)

	CLR.16	{A3}+odbNBUSED			; <- aucun lment utilis
	CLR.32	{A3}+odbNBLOCK			; <- aucun lment verrouill
	MOVE.16	D4,{A3}+odbMAX			; <- taille maximale
	MOVE.16	#4,{A3}+odbOFREE		; <- offset premier libre
	MOVE.32	A4,{A3}+odbPBLOC		; <- ^bloc
	MOVE.8	#2**bdbOK,{A3}+odbFLAG		; <- fanion "ok"
	ADD.16	#8,D4
	MOVE.16	D4,{A3}+odbSIZE			; <- taille du bloc

	CALL	LINKFREEDB

ERR$:	POPM.32	D1|D4|D5|A1|A4
	TEST.16	D7
	RET


;--------------\\
;  FINDEMPTYDB  >
;==============/

; Trouve un descripteur de bloc inutilis.

; in	-
; out	A3.32	^descripteur du bloc inutilis
;	D7.16	erreur
; mod	A3.32, D7.16

FINDEMPTYDB:
	CLR.16	D7
	MOVE.32	{A2}+ovarFIRSTdb,A3		; A3 <-- ^premier bloc

LOOP$:	COMP.32	#0,A3				; dernier ?
	JUMP,EQ	R8^ADD$				; oui => pas trouv => ajoute description de bloc

	TEST.8	{A3}+odbFLAG:#bdbEMPTY		; bloc vide ?
	JUMP,BS	R8^FOUND$			; oui => utilise celui-ci
	MOVE.32	{A3}+odbNEXT,A3			; db suivant
	JUMP	R8^LOOP$

ADD$:	CALL	ADDBLOCDESC			; ajoute un descripteur de bloc

FOUND$:	TEST.16	D7
	RET



;-----------\\
;  KILLBLOC  >
;===========/

; Dtruit un bloc de mmoire plus utilis. Cette opration ne
; supprime pas le descripteur du bloc, permettant ainsi d'pargner
; des appels GETMEM superflus.

; in	A3.32	^descripteur du bloc
; out	-
; mod	D7.16

KILLBLOC:
	PUSHM.32 D1|D4|A1|A4

	TEST.8	{A3}+odbFLAG:#bdbOK
	JUMP,BC	R8^ERR$				; ne fait rien si pas initialis
	TEST.16	{A3}+odbNBUSED
	JUMP,NE	R8^ERR$				; ne fait rien si encore des lments utiliss
	TEST.32	{A3}+odbNBLOCK
	JUMP,EQ	R8^DO$				; si ok, supprime la tranche mmoire

	MON	?AFTIM
	.ASCIZE	"<CR>Lock<CR>"
	TRAP	#1
	JUMP	R8^ERR$

FAT$:	MON	?AFTIM
	.ASCIZE	"<CR>Ovf<CR>"
	TRAP	#1
	JUMP	R8^ERR$

DO$:	MOVE.8	#2**bdbEMPTY,{A3}+odbFLAG	; bloc plus utilis
	MOVE.32	#MTYPUSER,D1
	MOVE.32	{A2}+ovarMCPT,A1
	MOVE.32	{A3}+odbPBLOC,A4

	MOVE.16	{A4},D4
	TCLR.32	D4:#15				; vrifie si dbut ok
	JUMP,BC	R8^FAT$				; non => erreur fatale
	COMP.16	#16'CACA,{A4}+A16^{D4}+4+2	; vrifie si fin ok
	JUMP,NE	R8^FAT$				; non => erreur fatale

	SUB.A16	#4,A4				; A4 <-- ^mmoire du bloc
	GESMEM	?GIVMEM				; rend la mmoire du bloc

	CALL	UNLINKFREEDB

ERR$:	POPM.32	D1|D4|A1|A4
;	TEST.16	D7
	RET



;---------------\\
;  FINDFREEBLOC  >
;===============/

; Trouve un bloc avec suffisamment de place pour faire le GETMEM
; dedans.

; in	D4.16	taille de l'lment ncessaire
; out	A3.32	^descripteur du bloc
;	D7.16	erreur (si aucun)
; mod	A3.32, D7.16

FINDFREEBLOC:
	CLR.16	D7
	MOVE.32	{A2}+ovarFREEdb,A3		; A3 <-- ^premier

LOOP$:	COMP.32	#0,A3				; est-ce le dernier ?
	JUMP,EQ	R8^ADD$				; oui => ajoute lment

	TEST.8	{A3}+odbFLAG:#bdbEMPTY		; bloc utilisable ?
	JUMP,BS	R8^NEXT$			; non => suivant
	TEST.8	{A3}+odbFLAG:#bdbDISK		; bloc sur disque ?
	JUMP,BS	R8^NEXT$			; oui => suivant

	COMP.16	{A3}+odbMAX,D4			; taille disponible suffisante ?
	JUMP,LT	R8^DONE$			; oui => termin

NEXT$:	MOVE.32	{A3}+odbNEXTFREE,A3		; passe au suivant
	JUMP	R8^LOOP$

DONE$:	TEST.16	D7
	RET					; rend ok !

ADD$:	CALL	ADDBLOC				; ajoute un bloc de plus
;	TEST.16	D7
	RET


;-----------\\
;  LINKELEM  >
;===========/

; Ajoute un lment dans la liste des libres de ce bloc.

; in	A3.32	^descripteur du bloc
;	A4.32	^lment
;	D6.32	adresse dbut du bloc
; out	-
; mod	D7.16

LINKELEM:
	PUSHM.32 D0|D1|A4

	MOVE.32	A4,D0
	SUB.32	D6,D0				; offset de l'lment

	MOVE.16	{A4}-2,D1			; taille de l'lment
	COMP.16	{A3}+odbMAX,D1
	JUMP,LT	R8^SIZE$

	MOVE.16	D1,{A3}+odbMAX			; nouvelle taille maximale

SIZE$:	MOVE.16	{A3}+odbOFREE,D1		; premier lment
	MOVE.16	D0,{A3}+odbOFREE		; nouveau premier
	CLR.16	{A4}+2				; pas de prcdent
	MOVE.16	D1,{A4}				; suivant = ex-premier
	JUMP,EQ	R8^FIRST$			; pas d'ex-premier => ce bloc a de la place de libre

	MOVE.32	D6,A4
	ADD.A16	D1,A4				; A4 <-- ^second
	MOVE.16	D0,{A4}+2			; nouveau prcdent de second
	JUMP	R8^ERR$

FIRST$:	CALL	LINKFREEDB			; chane le descripteur avec les desc. de blocs libres

ERR$:	POPM.32	D0|D1|A4
	CLR.16	D7
	RET



;-------------\\
;  UNLINKELEM  >
;=============/

; Enlve un lment de la liste des libres de ce bloc.

; in	A3.32	^descripteur du bloc
;	A4.32	^lment
;	D6.32	adresse dbut du bloc
; out	-
; mod	D7.16

UNLINKELEM:
	PUSHM.32 D1|D2|A0|A4

	MOVE.16	{A4},D1				; offset lment suivant
	MOVE.16	{A4}+2,D2			; offset lment prcdent
	JUMP,EQ	R8^FIRST$

	MOVE.32	D6,A0
	MOVE.16	D1,{A0}+A16^{D2}		; mmorise nouveau suivant du prcdent
	JUMP	R8^OK$

FIRST$:	MOVE.16	D1,{A3}+odbOFREE		; nouvel offset de premier lment libre
	JUMP,EQ	R8^FULL$			; plus d'offset => plein !

OK$:	TEST.16	D1				; lment suivant ?
	JUMP,EQ	R8^MAX$				; non => c'est termin

	MOVE.32	D6,A0
	MOVE.16	D2,{A0}+A16^{D1}+2		; mmorise nouveau prcdent du suivant

MAX$:	MOVE.16	{A4}-2,D1			; D1 <-- taille de l'lment
	COMP.16	{A3}+odbMAX,D1			; comme la taille maximale ?
	JUMP,LO	R8^END$				; non => ne fait rien

	CALL	CALCBLOCMAX			; cherche la taille maximale dans le bloc

	JUMP	R8^END$

FULL$:	CLR.16	{A3}+odbMAX			; plus de taille maximale, car plus rien
	CLR.16	{A3}+odbOFREE			; plus d'offset au premier lment libre
	CALL	UNLINKFREEDB			; extrait de la liste des db libres

END$:	POPM.32	D1|D2|A0|A4
	CLR.16	D7
	RET



;-------------\\
;  LINKFREEDB  >
;=============/

; Chane le descripteur dans la liste des libres.

; in	A3.32	^descripteur  chaner
; out	-
; mod	-

LINKFREEDB:
	PUSH.32 A0

	MOVE.32	{A2}+ovarFREEdb,A0
	CLR.32	{A3}+odbPREVFREE		; pas de prcdent libre
	MOVE.32	A3,{A2}+ovarFREEdb		; mmorise nouveau premier
	MOVE.32	A0,{A3}+odbNEXTFREE		; le suivant, c'est le second (ou ^nil)
	JUMP,EQ	R8^EMPTY$

	MOVE.32	A3,{A0}+odbPREVFREE		; le premier est le prcdent du second

EMPTY$:	POP.32	A0
	RET


;---------------\\
;  UNLINKFREEDB  >
;===============/

; Supprime le descripteur de la liste des libres.

; in	A3.32	^descripteur  supprimer
; out	-
; mod	-

UNLINKFREEDB:
	PUSHM.32 D0|A0|A1

	CLR.32	D0
	MOVE.32	{A3}+odbNEXTFREE,A0		; A0 <-- ^suivant
	MOVE.32	{A3}+odbPREVFREE,A1		; A1 <-- ^prcdent

	COMP.32	D0,A1				; pas de prcdent ?
	JUMP,EQ	R8^FIRST$			; oui => premier

	MOVE.32	A0,{A1}+odbNEXTFREE		; chane le suivant avec le prcdent
	JUMP	R8^OK$

FIRST$:	COMP.32	{A2}+OvarFREEdb,A3		; nous devrions tre les premiers
	JUMP,NE	R8^FOOL$			; c'est pas le cas => erreur fatale

	MOVE.32	A0,{A2}+ovarFREEdb		; le suivant devient le premier libre

OK$:	COMP.32	D0,A0				; pas de suivant ?
	JUMP,EQ	R8^LAST$			; oui => dernier

	MOVE.32	A1,{A0}+odbPREVFREE		; chane le prcdent avec le suivant
	JUMP	R8^LAST$

FOOL$:	MON	?AFTIM
	.ASCIZE	"UNLINKFREEDB<CR>"
	TRAP	#1

LAST$:	MOVE.32	D0,{A3}+odbNEXTFREE
	MOVE.32	D0,{A3}+odbPREVFREE

	POPM.32	D0|A0|A1
	RET


;--------------\\
;  CALCBLOCMAX  >
;==============/

; Calcule la taille maximale des lments du bloc

; in	A3.32	^bloc
; out	{A3}	odbMAX, mis  jour
; mod	-

CALCBLOCMAX:
	PUSHM.32 D0|D1|D6|A4

	CLR.16	{A3}+odbMAX			; efface l'indication de taille maximale
	MOVE.32	{A3}+odbPBLOC,D6		; adresse de base du bloc
	JUMP,EQ	R8^ERR$				; nulle => fin
	TEST.16	{A3}+odbOFREE			; offset premier libre ?
	JUMP,EQ	R8^ERR$				; nul => fin

	MOVE.A16 {A3}+odbOFREE,A4
	ADD.32	D6,A4				; adresse du premier lment libre
	CLR.16	D1				; D1 <-- taille maximale nulle

LOOP$:	MOVE.16	{A4}-2,D0			; D0 <-- taille de l'lment actuel
	COMP.16	D1,D0				; maximum meilleur ?
	JUMP,LO	R8^NEXT$			; oui => ne change pas

	MOVE.16	D0,D1

NEXT$:	TEST.16	{A4}				; lment suivant
	JUMP,EQ	R8^FOUND$
	MOVE.A16 {A4},A4
	ADD.32	D6,A4
	JUMP	R8^LOOP$

FOUND$:	MOVE.16	D1,{A3}+odbMAX

ERR$:	POPM.32	D0|D1|D6|A4
	RET



	.INS	vmHANDLE.ASI
	.INS	vmSWAP.ASI

END_MODULE:

	.END
