	.TITLE	XCAR.ASL

	.PROC	M68000
	.BASE	10'10		; base 10 par dfaut
	.LAYOUT HEX		; listing en hexadcimal

REVMAJ	= 2
REVMIN	= 0


; Date		Rev	Amliorations
; -----------------------------------------------------------------------------------
; 02.08.97  PA	2.0	Corrig petite erreur au CLOVAR.
; 26.07.97  PA  1.30	Charge le module GRAMISC si ncessaire. Revu OPEVAR/CLOVAR.
; 13.07.97  PA	1.29	Vrifications supplmentaires de validit (pointeurs nuls).
;			Force l'utilisation de SIP00 si aucune "petit fonte" n'est
;			initialise; n'utilise plus PGCAP quand il est nul.
; 11.05.95  PA	1.28	N'utilise plus GRA, mais GRA2.
;			Exploite la routine d'initialisation automatique de LIB 10.3.
; 03.04.95  PA  1.27	Correction de la souris crase.
; 03.04.95  PA	1.26	Correction pour les chasses fixes.
; 07.02.95  PA	1.25	Correction pour la couleur.
; 19.02.95  PA	1.24	FOS?CLOAD depuis dossier GENC: d'abord !
;			GETCOMMEM: plus de variables dans le code
; 16.08.94	1.23	XCAR_BM*: ok avec SMAKY130 couleur
; 25.03.91	1.22	XCAR_SHOW: correction bug avec version 1.21
; 24.03.92	1.21	ne fait plus de LIB,?GETPDIS (pour DD)
; 10.03.92	1.20	adaptation au nouveau descripteur GRA2 (systme 8)
; 12.09.91	1.19	SMAKY100: plus de RET tout  la fin du code !
; 03.05.91	1.18	XCAR_CREATE/BMMATRIX: lg containte jamais nulle !
; 15.01.91	1.17	XCAR_SHOW/SHOWF: ok si cran couleur (SMAKY300)
; 25.09.90	1.16	XCAR_BMOPEN: gnre un interligne correct (PAGE)
;			XCAR_BMOPEN: sablier pendant chargement
; 04.05.90	1.15	XCAR_CREATE: largeur matrices: chasse ok
; 23.03.90	1.14	XCAR_SHOWF: ok avec trs gros pinceaux
;			XCAR_SHOW/SHOWF: clipping si pinceau dborde
;			gre oxcPMN/PNG (si gencar trs petit)
;			XCAR_SHOW: loupe si gencar trs petit
;			bzier: routine d'exception si outline et <4x4
; 12.03.90	1.13	gre OGCBRI (roman/bold/italic)
;			xcOPPEN dans les *00.GENC (pinceaux)
; 27.02.90	1.12	version distribue par erreur, plante sur SM100 !
; 13.12.89	1.11	XCAR_FRAGMENT: nouvel appel pour PAGE
; 21.11.89	1.10	pour nouveau GRAMISC en A440 !
; 10.11.89	1.9	XCAR_BMMATRIX: rend les largeurs correctes
; 08.11.89	1.8	utilise TGRAMIS --> GRAMISC
; 17.10.89	1.7	XCAR_LIST: nouvel appel de liste
; 19.09.89	1.6	XCAR_BMxxx: nouveaux appels pour PAGE
; 11.08.89	1.5	utilise GRA2_RLINE si contour
; 11.07.89	1.4	XCAR_SHOW: ok si taille > hauteur rectangle
; 05.07.89	1.3	ne charge plus l'en-tte avec FOS,?CLOAD
;			XCAR_SHOWF: nouvel appel pour LIST_VISU
; 15.06.89	1.2	XCAR_SHOW: nouvel appel pour DGENC
; 14.06.89	1.1	XCAR_HEADER: ok
; 13.04.89	1.0	premiers essais avec STRETCH
; -----------------------------------------------------------------------------------


	.REF	SMAKY
	.REF	MODULES
	.REF	DOLIB

	.REV	REVMAJ,REVMIN
	.IDENT	"(C)  Daniel ROUX et EPSITEC SA"



; Constantes
; ----------

CHOUIA05	=	16'8000		; p'tit chouia = 0.5



; Dfinition de l'entte d'un gnrateur de caractres
; ----------------------------------------------------

;OGCRBI		=	H'7C		; 4 caractres pour "normal,gras,ital,gras-ital"

OGCH1		=	16'180		; h1
OGCH2		=	16'200		; h2
OGCMAT		=	16'280		; matrix



; Variables pour courbe de bezier
; -------------------------------

;	C1                      C2
;	 o----------------------o
;	 |                       \
;	 |          .     .       \
;	 |      .              .   \
;	 |   .                     .\
;	 | .                         o
;	 |.                            P2
;	 o  P1

	.LOC	0
OBZP1Y:	.BLK.32	1		; P1[y]
OBZP1X:	.BLK.32	1		; P1[x]
OBZC1Y:	.BLK.32	1		; C1[y]
OBZC1X:	.BLK.32	1		; C1[x]
OBZC2Y:	.BLK.32	1		; C2[y]
OBZC2X:	.BLK.32	1		; C2[x]
OBZP2Y:	.BLK.32	1		; P2[y]
OBZP2X:	.BLK.32	1		; P2[x]
LBZ:



; Variables locales de XCAR_CREATE
; --------------------------------

	.LOC	0

OXCF:	.BLK.8	1		; fonte
	.EVEN
OXCS:	.BLK.8	4		; style
OXCT:	.BLK.8	2		; taille

OXCFILN:.BLK.8	16		; nom du fichier normal
OXCFILJ:.BLK.8	16		; nom du fichier si trs petit

OXCPI:	.BLK.32	1		; ^gencar en entre
OXCPJ:	.BLK.32	1		; ^gencar en entre si trs petit
OXCPO:	.BLK.32	1		; ^gencar en sortie
OXCPM:	.BLK.32	1		; ^descripteur pour transformation mathmatique

OXCGMI:	.BLK.16	1		; canal de SMA_GRAMISC.LIB
OXCLO:	.BLK.32	1		; lg gencar en sortie
OXCDF:	.BLK.8	LGDIS10+4	; descripteur de fentre
OXCPB:	.BLK.32	1		; ^bitmap si cran couleur
OXCPOS:	.BLK.16	2		; position o dessiner (y;x)
OXCIRG:	.BLK.32	1		; rgion: identificateur
OXCBRG:	.BLK.8	LGGBMAP		; rgion: descripteur bitmap
OXCIX1:	.BLK.8	2		; l1 (gauche)	[po]
OXCIX2:	.BLK.8	2		; l2 (droite)	[po]
OXCIXB:	.BLK.8	2		; l1+l2		[bytes]
OXCIY1:	.BLK.8	2		; h1 (haut)	[po]
OXCIY2:	.BLK.8	2		; h2 (bas)	[po]
OXCIYE:	.BLK.8	2		; taille du "E"	[pi]
OXCIYEJ:.BLK.8	2		; taille du "E"	[pi] si trs petit

OXCJMY:	.BLK.8	2		; trs petit: facteur pour *Y
OXCJDY:	.BLK.8	2		; trs petit: facteur pour /Y
OXCJMX:	.BLK.8	2		; trs petit: facteur pour *X
OXCJDX:	.BLK.8	2		; trs petit: facteur pour /X

OXCMOD:	.BLK.8	2		; mode
 XCMODFILL =	1		;  mode remplissage
 XCMODOUTL =	2		;  mode outline
 XCMODFRAG =	3		;  mode fragmente

OPPEN:	.BLK.32	1		; ^matrice pinceau
OLPEN:	.BLK.8	2		; dernier pinceau
OUPEN:	.BLK.8	2		; pinceau en cours d'utilisation

OLPOS:	.BLK.32	1		; dernire position [pg]
OIPOS:	.BLK.32	1		; dernire position [pi]
ORPOS:	.BLK.32	1
OWCAR:	.BLK.8	2

OAGMNR:	.BLK.32	1		; adresse de GMI_NEWRGN
OAGMDR:	.BLK.32	1		; adresse de GMI_DISPOSERGN
OAGMOR:	.BLK.32	1		; adresse de GMI_OPENRGN
OAGMCR:	.BLK.32	1		; adresse de GMI_CLOSERGN
OAGMRB:	.BLK.32	1		; adresse de GMI_RGNTOBITMAP
OAGMPL:	.BLK.32	1		; adresse de GMI_PUTRLINE
NumAGRAMISC	= (APC-OAGMNR).DIV.4

OFRAPV:	.BLK.32	1		; fragment: ^variables de l'utilisateur
OFRAPR:	.BLK.32	1		; fragment: ^routine de l'utilisateur

LGVAR:



; Contenu de la liste des noms
; ----------------------------

	.LOC	0
OLNNAM:	.BLK.8	32		; nom
OLNFON:	.BLK.8	1		; fonte
OLNSTY:	.BLK.8	1		; style/chasse
	.BLK.8	6		; rserve
LLN:

; Variables globales de XCAR_Lxxx
; -------------------------------

	.LOC	0
OVLCTM:	.BLK.32	1		; compte mmoire
OVLPLI:	.BLK.32	1		; ^liste
OVLNLI:	.BLK.8	2		; nb de noms contenus
OVLBUF:	.BLK.8	32		; buffer pour un nom
LVL:



; En-tte du module LIB
; ---------------------

	.LOC	0

BASE:	XCAR_	FIRST		; code du premier appel
	XCAR_	LAST		; code du dernier appel
	.8	0		; nombre d'installations
	.FILL.8	(OHLREV-APC),0
	.8	REVMAJ,REVMIN	; rvision.version
	.32	END_XCAR	; longueur
	.32	PATHLIB		; pattern de dbut
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"XCAR"		; nom du module
	.FILL.8	(OHLINIT-APC),0
	.16	_XCAR_OPEN	; routine d'initialisation
	.16	0		; routine de nettoyage (aucune)
	.FILL.8	(LGHLIB-APC),0

	.16	_XCAR_OPEN
	.16	_XCAR_CREATE
	.16	_XCAR_HEADER
	.16	_XCAR_SHOW
	.16	_XCAR_SHOWF
	.16	_XCAR_BMOPEN
	.16	_XCAR_BMMATRIX
	.16	_XCAR_BMCLOSE
	.16	_XCAR_LIST
	.16	_XCAR_FRAGMENT






;-----------\\
; _XCAR_OPEN >
;===========/

; Charge les modules utilise par XCAR.

; in	-
; out	-
; mod	D7.16

_XCAR_OPEN:
	CLR.16	D7		; retour EQ
	RET


;-------------\\
; _XCAR_CREATE >
;=============/

; Cre un gencar "bitmap" complet (128 caractres)  partir d'un gencar analytique.

; in	D0.B	fonte
;	D1.32	style/chasse
;	D2.8	taille
; out	A4.L	^gencar (GETMEM sur le compte MTYPCP)
;	D7.16	erreur
; mod	D7.W, A4.L

_XCAR_CREATE:
	PUSHM.32 D0..D4|A1|A3|A6

	MOVE.32	D1,D3

	CALL	OPEVAR		; A6 <-- ^variables locales
	JUMP,NE L95$

	SUB.32	#2,SP		; stack <-- rserve place pour erreur
	PUSH.32	#{A6}+OXCIRG	; stack <-- ^VAR identificateur rgion
	MOVE.32	{A6}+OAGMNR,A1
	CALL	{A1}		; GMI_NEWRGN, cre une nouvelle rgion
	POP.16	D7
	JUMP,NE L90$

	MOVE.32	D3,D1
	MOVE.8	D0,{A6}+OXCF
	MOVE.32	D1,{A6}+OXCS
	MOVE.8	D2,{A6}+OXCT+1

	CALL	NAMEGC		; A3 <-- ^nom du fichier
	MOVE.32	#2**BEXNHEAD,D3	; D3 <-- ne charge pas l'en-tte
	CALL	CLOAD
	JUMP,NE L90$
	MOVE.32	A4,{A6}+OXCPI

	MOVE.16	#ERDIGC,D7
	COMP.16	#xcIDENT,{A4}+oxcIDENT
	JUMP,NE L80$

	CALL	NAMEGCJ		; A3 <-- ^nom du fichier trs petit
	JUMP,NE	 R8^DIM$
	MOVE.32	#2**BEXNHEAD,D3	; D3 <-- ne charge pas l'en-tte
	CALL	CLOAD
	JUMP,NE	 R8^DIM$
	MOVE.32	A4,{A6}+OXCPJ
DIM$:
	MOVE.32	{A6}+OXCPI,A4
	CALL	DIMGC		; calcule les dimensions

	MOVE.16	{A6}+OXCIY1,D4
	ADD.16	{A6}+OXCIY2,D4
	MUL.16	{A6}+OXCIXB,D4
	MUL.16	#128,D4
	ADD.32	#OGCMAT,D4
	MOVE.16	#MTYPCP,D1
	GESMEM	?GETMEM		; demande mmoire pour gencar en sortie
	JUMP,NE	 R8^L80$
	MOVE.32	A4,{A6}+OXCPO
	MOVE.32	D4,{A6}+OXCLO

	MOVE.32	A4,A3		; A3 <-- ^gencar en sortie
	MOVE.32	D4,D3		; D3 <-- gnre tout
	MOVE.32	{A6}+OXCPI,A4	; A4 <-- ^gencar en entre
	CALL	CONVHEAD	; gnre l'en-tte
	CALL	CONVGC		; gnre les matrices

	MOVE.32	{A6}+OXCPO,A4	; A4 <-- ^gencar en sortie
	CLR.16	D7		; D7 <-- ok
L80$:
	PUSH.16	D7
	TEST.32	{A6}+OXCPJ
	JUMP,EQ	 R8^L84$
	MOVE.32	#{A6}+OXCFILJ,A3
	FOS	?CUNLOAD
L84$:
	MOVE.32	#{A6}+OXCFILN,A3
	FOS	?CUNLOAD
	POP.16	D7
L90$:
	PUSHM.32 D7|A4
	TEST.32	{A6}+OXCIRG
	JUMP,EQ	 R8^L92$
	SUB.32	#2,SP		; stack <-- rserve place pour erreur
	PUSH.32	{A6}+OXCIRG	; stack <-- ^identificateur rgion
	MOVE.32	{A6}+OAGMDR,A1
	CALL	{A1}		; GMI_DISPOSERGN, rend la rgion
	POP.16	D7
L92$:
	CALL	CLOVAR		; rend les variables
	POPM.32	D7|A4
L95$:
	POPM.32	D0..D4|A1|A3|A6
	TEST.16	D7		; retour EQ/NE
	RET


;-------------\\
; _XCAR_HEADER >
;=============/

; Cre l'en-tte d'un gencar "bitmap"  partir d'un gencar analytique.

; in	D0.B	fonte
;	D1.32	style/chasse
;	D2.8	taille
;	A4.32	^buffer pour recevoir l'en-tte
;	D4.16	lg du buffer
; out	D7.W	erreur
; mod	D7.W

_XCAR_HEADER:
	PUSHM.32 D0..D5|A3|A4|A6

	MOVE.32	A4,A3
	CLR.32	D5
	MOVE.16	D4,D5
	MOVE.32	D1,D3

	CALL	OPEVAR		; A6 <-- ^variables locales
	JUMP,NE L95$

	MOVE.32	D3,D1
	MOVE.8	D0,{A6}+OXCF
	MOVE.32	D1,{A6}+OXCS
	MOVE.8	D2,{A6}+OXCT+1
	MOVE.32	A3,{A6}+OXCPO
	MOVE.32	D5,{A6}+OXCLO

	CALL	NAMEGC		; A3 <-- ^nom du fichier
	MOVE.32	#2**BEXNHEAD,D3	; D3 <-- ne charge pas l'en-tte
	CALL	CLOAD
	JUMP,NE	 R8^L90$
	MOVE.32	A4,{A6}+OXCPI

	MOVE.16	#ERDIGC,D7
	COMP.16	#xcIDENT,{A4}+oxcIDENT
	JUMP,NE	 R8^L80$

	CALL	DIMGC		; calcule les dimensions

	MOVE.32	{A6}+OXCPO,A3	; A3 <-- ^gencar en sortie
	MOVE.32	{A6}+OXCLO,D3	; D3 <-- lg  gnrer
;	MOVE.32	{A6}+OXCPI,A4	; A4 <-- ^gencar en entre
	CALL	CONVHEAD	; gnre l'en-tte

	CLR.16	D7		; D7 <-- ok
L80$:
	PUSH.16	D7
	MOVE.32	#{A6}+OXCFILN,A3
	FOS	?CUNLOAD
	POP.16	D7
L90$:
	CALL	CLOVAR		; rend les variables
L95$:
	POPM.32	D0..D5|A3|A4|A6
	TEST.16	D7		; retour EQ/NE
	RET


;-----------\\
; _XCAR_SHOW >
;===========/

; Affiche les caractres "Abc" d'un gencar analytique rapidement,
; sans construire tous les autres caractres.

; in	D0.8	fonte
;	D1.32	style/chasse
;	D2.8	taille
;	D3.32	coin sup/gauche fentre o afficher (y;x)
;	D4.32	dimensions fentre o afficher (dy;dx)
;	A0.32	^descripteur fentre
; out	D7.16	erreur
; mod	D7.16

_XCAR_SHOW:
	PUSHM.32 D0..D6|A1|A3|A4|A6

	MOVE.32	D3,D5		; D5 <-- pos
	MOVE.32	D4,D6		; D6 <-- dim

	CALL	OPEVAR		; A6 <-- ^variables locales
	JUMP,NE L95$

	SUB.A16	#2,SP		; stack <-- rserve place pour erreur
	PUSH.32	#{A6}+OXCIRG	; stack <-- ^VAR identificateur rgion
	MOVE.32	{A6}+OAGMNR,A1
	CALL	{A1}		; GMI_NEWRGN, cre une nouvelle rgion
	POP.16	D7
	JUMP,NE L90$

	MOVE.8	D0,{A6}+OXCF
	MOVE.32	D1,{A6}+OXCS
	MOVE.8	D2,{A6}+OXCT+1

	CALL	NAMEGC		; A3 <-- ^nom du fichier
	MOVE.32	#2**BEXNHEAD,D3	; D3 <-- ne charge pas l'en-tte
	CALL	CLOAD
	JUMP,NE L90$
	MOVE.32	A4,{A6}+OXCPI

	MOVE.16	#ERDIGC,D7
	COMP.16	#xcIDENT,{A4}+oxcIDENT
	JUMP,NE L80$

	CALL	DIMGC		; calcule les dimensions

	MOVE.32	#OGCH1,D4
	MOVE.32	#MTYPCP,D1
	GESMEM	?GETMEM		; demande mmoire pour en-tte + chasse
	JUMP,NE L80$
	MOVE.32	A4,{A6}+OXCPO
	MOVE.32	D4,{A6}+OXCLO

	MOVE.32	A4,A3		; A3 <-- ^gencar en sortie
	MOVE.32	D4,D3		; D3 <-- gnre tout
	MOVE.32	{A6}+OXCPI,A4	; A4 <-- ^gencar en entre
	CALL	CONVHEAD	; gnre l'en-tte + chasse

	CALL	WDOOPEN		; A3 <-- ^descripteur, prpare la sous-fentre
	JUMP,NE L70$

	MOVE.32	{A6}+OXCPI,A4	; A4 <-- ^gencar en entre
	MOVE.32	#{A4}+oxcLENGTH,A4 ; A4 <-- ^table de chasse

	CLR.16	{A6}+OXCPOS+0
	MOVE.32	{A3}+ODFFDY,D4
	SWAP.32	D4
	SUB.16	{A6}+OXCT,D4
	JUMP,NS	R8^L36$

	SR.16	#1,D4
	ADD.16	{A6}+OXCT,D4
	SUB.16	{A6}+OXCIY1,D4	; D4 <-- position en Y
	MOVE.16	D4,{A6}+OXCPOS+0

L36$:	MOVE.16	{A4}+(2*"A"),D4
	ADD.16	{A4}+(2*"b"),D4
	ADD.16	{A4}+(2*"c"),D4
	CALL	CONVIO		; D4 <-- largeur pour "Abc"
	SUB.16	{A3}+ODFFDX,D4
	NEG.16	D4
	ASR.16	#1,D4
	JUMP,NC	R8^L40$
	CLR.16	D4

L40$:	MOVE.16	D4,{A6}+OXCPOS+2

	MOVE.16	#"A",D3
	CALL	CONVCARSCR	; affiche "A"
	MOVE.16	{A4}+(2*"A"),D4
	CALL	CONVIO
	ADD.16	D4,{A6}+OXCPOS+2

	MOVE.16	#"b",D3
	CALL	CONVCARSCR	; affiche "b"
	MOVE.16	{A4}+(2*"b"),D4
	CALL	CONVIO
	ADD.16	D4,{A6}+OXCPOS+2

	MOVE.16	#"c",D3
	CALL	CONVCARSCR	; affiche "c"

	CALL	SHOWLOUPE	; met v. une loupe

	CALL	WDOCLOSE	; termine la sous-fentre
	CLR.16	D7		; D7 <-- ok
L70$:
	PUSH.16	D7
	MOVE.32	{A6}+OXCPO,A4
	MOVE.16	#MTYPCP,D1
	GESMEM	?GIVMEM		; rend l'en-tte + chasse
	POP.16	D7
L80$:
	PUSH.16	D7
	MOVE.32	#{A6}+OXCFILN,A3
	FOS	?CUNLOAD
	POP.16	D7
L90$:
	PUSH.16	D7
	TEST.32	{A6}+OXCIRG
	JUMP,EQ	 R8^L92$
	SUB.32	#2,SP		; stack <-- rserve place pour erreur
	PUSH.32	{A6}+OXCIRG	; stack <-- ^identificateur rgion
	MOVE.32	{A6}+OAGMDR,A1
	CALL	{A1}		; GMI_DISPOSERGN, rend la rgion
	POP.16	D7
L92$:
	CALL	CLOVAR		; rend les variables
	POP.16	D7
L95$:
	POPM.32	D0..D6|A1|A3|A4|A6
	TEST.16	D7		; retour EQ/NE
	RET

;----------\\
; SHOWLOUPE >
;----------/

; Met une loupe dans le coin inf/droite, si le gencar est trs petit.

; in	A3.32	^descripteur
; out	-
; mod	D7.16

SHOWLOUPE:
	PUSHM.32 D1..D5|A2..A4

	MOVE.32	{A6}+OXCPI,A4	; A4 <-- ^gencar en entre

	MOVE.16	{A6}+OXCT,D4	; D4 <-- taille demande
	COMP.16	{A4}+oxcPMN,D4	; taille trs petite ?
	JUMP,HS	 R8^EXIT$	; non => EXIT$

	TEST.8	{A4}+oxcPNG	; nom existe ?
	JUMP,EQ	R8^EXIT$	; non => EXIT$

	MOVE.32	A3,A2		; A2 <-- ^descripteur fentre

	MOVE.32	#R16^LOUPE$,A3	; A3 <-- ^source
	CLR.32	D3		; D3 <-- position dans source
	MOVE.32	#4,D5		; D5 <-- Iy source

	SUB.32	A4,A4		; A4 <-- destination dans l'cran

	MOVE.16	{A2}+ODFFDY,D4
	SUB.16	#32+2,D4
	SWAP.32	D4
	MOVE.16	{A2}+ODFFDX,D4
	SUB.16	#16+3,D4	; D4 <-- position dans destination

	MOVE.32	#16'10000*32+17,D2 ; D2 <-- dimensions
	MOVE.32	#LOADDOT,D1	   ; D1 <-- mode
	GRA2_	RASTER		   ; met la loupe dans la fentre

EXIT$:	POPM.32	D1..D5|A2..A4
	RET

LOUPE$:
	.16	2'000001111110000,2'0000000000000000
	.16	2'000110000001100,2'0000000000000000
	.16	2'001000111100010,2'0000000000000000
	.16	2'010011010111001,2'0000000000000000
	.16	2'010110101011101,2'0000000000000000
	.16	2'100101010101100,2'1000000000000000
	.16	2'101010001010110,2'1000000000000000
	.16	2'101101010101010,2'1000000000000000
	.16	2'101010101010110,2'1000000000000000
	.16	2'101101010101010,2'1000000000000000
	.16	2'100110101010100,2'1000000000000000
	.16	2'010111010101101,2'0000000000000000
	.16	2'010011101011001,2'0000000000000000
	.16	2'001000111100010,2'0000000000000000
	.16	2'000110000001100,2'0000000000000000
	.16	2'000001111110000,2'0000000000000000
	.16	2'000000011000000,2'0000000000000000
	.16	2'000000011000000,2'0000000000000000
	.16	2'000000111100000,2'0000000000000000
	.16	2'000001000110000,2'0000000000000000
	.16	2'000001000110000,2'0000000000000000
	.16	2'000001000110000,2'0000000000000000
	.16	2'000001000110000,2'0000000000000000
	.16	2'000001000110000,2'0000000000000000
	.16	2'000001000110000,2'0000000000000000
	.16	2'000001000110000,2'0000000000000000
	.16	2'000001000110000,2'0000000000000000
	.16	2'000001000110000,2'0000000000000000
	.16	2'000001000110000,2'0000000000000000
	.16	2'000001000110000,2'0000000000000000
	.16	2'000001000110000,2'0000000000000000
	.16	2'000000111100000,2'0000000000000000


;------------\\
; _XCAR_SHOWF >
;============/

; Affiche les caractres "Abc" d'un gencar analytique rapidement,
; sans construire tous les autres caractres.

; in	D2.W	taille
;	D3.32	coin sup/gauche fentre o afficher (y;x)
;	D4.32	dimensions fentre o afficher (dy;dx)
;	A4.32	^contenu du fichier *00.GENC (sans l'en-tte binaire)
;	A0.32	^descripteur fentre
; out	D7.W	erreur
; mod	D7.W

_XCAR_SHOWF:
	PUSHM.32 D0..D6|A1|A3|A4|A6

	MOVE.32	D4,D6		; D6 <-- dimensions fentre
	MOVE.32	A4,D5

	CALL	OPEVAR		; A6 <-- ^variables locales
	JUMP,NE L95$

	SUB.32	#2,SP		; stack <-- rserve place pour erreur
	PUSH.32	#{A6}+OXCIRG	; stack <-- ^VAR identificateur rgion
	MOVE.32	{A6}+OAGMNR,A1
	CALL	{A1}		; GMI_NEWRGN, cre une nouvelle rgion
	POP.16	D7
	JUMP,NE L90$

	MOVE.32	D5,A4		; A4 <-- ^gencar
	MOVE.32	D3,D5		; D5 <-- position fentre
	MOVE.16	D2,{A6}+OXCT
	MOVE.32	A4,{A6}+OXCPI

	MOVE.16	#ERDIGC,D7
	COMP.16	#xcIDENT,{A4}+oxcIDENT
	JUMP,NE L90$

	CALL	DIMGC		; calcule les dimensions

	MOVE.32	#OGCH1,D4
	MOVE.16	#MTYPCP,D1
	GESMEM	?GETMEM		; demande mmoire pour en-tte + chasse
	JUMP,NE L90$
	MOVE.32	A4,{A6}+OXCPO
	MOVE.32	D4,{A6}+OXCLO

	MOVE.32	A4,A3		; A3 <-- ^gencar en sortie
	MOVE.32	D4,D3		; D3 <-- gnre tout
	MOVE.32	{A6}+OXCPI,A4	; A4 <-- ^gencar en entre
	CALL	CONVHEAD	; gnre l'en-tte + chasse

	CALL	WDOOPEN		; prpare la sous-fentre
	JUMP,NE L80$

	MOVE.32	{A6}+OXCPI,A4	; A4 <-- ^gencar en entre
	MOVE.32	#{A4}+oxcLENGTH,A4 ; A4 <-- ^table de chasse

	MOVE.32	D6,D4
	SWAP.32	D4
	SUB.16	{A6}+OXCT,D4
	SR.16	#1,D4
	ADD.16	{A6}+OXCT,D4
	SUB.16	{A6}+OXCIY1,D4	; D4 <-- position en Y
	MOVE.16	D4,{A6}+OXCPOS+0

	MOVE.16	{A4}+(2*"A"),D4
	ADD.16	{A4}+(2*"b"),D4
	ADD.16	{A4}+(2*"c"),D4
	CALL	CONVIO		; D4 <-- largeur pour "Abc"
	SUB.16	D6,D4
	NEG.16	D4
	ASR.16	#1,D4
	JUMP,NC	 R8^L40$
	CLR.16	D4
L40$:
	MOVE.16	D4,{A6}+OXCPOS+2

	MOVE.16	#"A",D3
	CALL	CONVCARSCR	; affiche "A"
	MOVE.16	{A4}+(2*"A"),D4
	CALL	CONVIO
	ADD.16	D4,{A6}+OXCPOS+2

	MOVE.16	#"b",D3
	CALL	CONVCARSCR	; affiche "b"
	MOVE.16	{A4}+(2*"b"),D4
	CALL	CONVIO
	ADD.16	D4,{A6}+OXCPOS+2

	MOVE.16	#"c",D3
	CALL	CONVCARSCR	; affiche "c"

	CALL	WDOCLOSE	; termine la sous-fentre
	CLR.16	D7		; D7 <-- ok
L80$:
	PUSH.16	D7
	MOVE.32	{A6}+OXCPO,A4
	MOVE.16	#MTYPCP,D1
	GESMEM	?GIVMEM		; rend l'en-tte + chasse
	POP.16	D7
L90$:
	PUSH.16	D7
	TEST.32	{A6}+OXCIRG
	JUMP,EQ	 R8^L92$
	SUB.32	#2,SP		; stack <-- rserve place pour erreur
	PUSH.32	{A6}+OXCIRG	; stack <-- ^identificateur rgion
	MOVE.32	{A6}+OAGMDR,A1
	CALL	{A1}		; GMI_DISPOSERGN, rend la rgion
	POP.16	D7
L92$:
	CALL	CLOVAR		; rend les variables
	POP.16	D7
L95$:
	POPM.32	D0..D6|A1|A3|A4|A6
	TEST.16	D7		; retour EQ/NE
	RET



;--------\\
; WDOOPEN >
;--------/

; Prpare la sous-fentre o afficher.

; in	D5.32	coin sup/gauche fentre o afficher (y;x)
;	D6.32	dimensions fentre o afficher (dy;dx)
; out	A3.32	^descripteur
;	D7.16	erreur
; mod	D7.16, A3.32

WDOOPEN:
	PUSHM.32 D1..D5|A4

	LIB	?GETPDIS		; A4 <-- ^descripteur fentre courante
	ADD.16	{A4}+ODFX,D5
	ADD.16	{A4}+ODFFX,D5
	SWAP.32	D5
	ADD.16	{A4}+ODFY,D5
	ADD.16	{A4}+ODFFY,D5
	SWAP.32	D5

	MOVE.32	#{A6}+OXCDF,A3		; A3 <-- ^copie descripteur fentre
;;	COMP.8	#1,{A4}+ODFCNP		; cran couleur ?
;;	JUMP,EQ	R8^NOCOUL$		; non => NOCOUL$

	SET.8	{A3}+ODFNOW		; on n'est pas dans $DIS_0
	MOVE.32	A3,{A3}+ODFCHECK
	MOVE.16	#-1,{A3}+ODFGRABCNT	; pour le grab...
	MOVE.16	#2,{A3}+ODFCNB		; 2 couleurs
	MOVE.8	#1,{A3}+ODFCNP		; 1 bit/pixel
	CLR.8	{A3}+ODFCMD		; mode monochrome

	MOVE.32	#1,{A3}+ODFCSF		; couleur pour allumer
	CLR.32	{A3}+ODFCCF		; couleur pour teindre

	MOVE.32	D6,D4
	ADD.16	#16-1,D4
	AND.8	#2'11110000,D4
	MOVE.16	D4,D3
	MUL.16	D6,D4
	MOVE.32	#MTYPCP,D1
	GESMEM	?GETMEM			; demande mmoire pour bitmap
	JUMP,NE EXIT$
	GESMEM	?CLEARMEM		; efface le bitmap
	MOVE.32	A4,{A6}+OXCPB		; OXCPB <-- ^bitmap

	MOVE.32	A4,{A3}+ODFABS
	SR.16	#3,D3
	MOVE.16	D3,{A3}+ODFIIY
	CLR.32	D5
	MOVE.32	D5,{A3}+ODFY
	MOVE.32	D5,{A3}+ODFFY

NOCOUL$:
	ADD.16	D5,{A3}+ODFFX
	SWAP.32	D5
	ADD.16	D5,{A3}+ODFFY
	MOVE.32	D6,{A3}+ODFFDY

	MOVE.16	{A3}+ODFX,D4
	ADD.16	{A3}+ODFFX,D4
	MOVE.16	D4,{A3}+ODFWBX		; init min X
	ADD.16	{A3}+ODFFDX,D4
	MOVE.16	D4,{A3}+ODFWEX		; init max X

	MOVE.16	{A3}+ODFY,D4
	ADD.16	{A3}+ODFFY,D4
	MOVE.16	D4,{A3}+ODFWBY		; init min Y
	ADD.16	{A3}+ODFFDY,D4
	MOVE.16	D4,{A3}+ODFWEY		; init max Y

	MOVE.8	#GRACLIP,{A3}+ODFMGR

	MOVE.32	{A3}+ODFABS,A4
	MOVE.32	{A3}+ODFFDY,D2
	MOVE.16	{A3}+ODFWBX,D4
	MOVE.16	D4,D3
	AND.16	#2'1111,D3
	JUMP,EQ	 R8^MODX$
	NEG.16	D3
	ADD.16	#16,D3
	SUB.16	D3,D2
	SUB.16	D3,{A3}+ODFFDX
	SUB.16	D3,{A3}+ODFWEX

MODX$:	ADD.16	#16-1,D4
	AND.8	#2'11110000,D4
	MOVE.16	D4,{A3}+ODFWBX
	SR.16	#3,D4
	ADD.A16	D4,A4
	MOVE.16	{A3}+ODFWBY,D4
	MUL.16	{A3}+ODFIIY,D4
	ADD.32	D4,A4
	MOVE.32	A4,{A6}+OXCBRG+OGBMAPPT
	MOVE.16	{A3}+ODFIIY,{A6}+OXCBRG+OGBMAPWIDTH
	CLR.32	{A6}+OXCBRG+OGBMAPRECT+OGRECTTL
	MOVE.32	D2,{A6}+OXCBRG+OGBMAPRECT+OGRECTBR

	MOVE.8	#AFCCMO,D3
	LIB	?AFCAR		; enlve la souris

	CLR.16	D7		; D7 <-- ok

EXIT$:	POPM.32	D1..D5|A4
	TEST.16	D7		; retour EQ/NE
	RET


;---------\\
; WDOCLOSE >
;---------/

; Termine la sous-fentre.

; in	D5.32	coin sup/gauche fentre o afficher (y;x)
;	D6.32	dimensions fentre o afficher (dy;dx)
; out	-
; mod	D7.16

WDOCLOSE:
	PUSHM.32 D1..D5|A2..A4

;;	COMP.8	#1,{A0}+ODFCNP	; cran couleur ?
;;	JUMP,EQ	R8^EXIT$	; non => EXIT$
	TEST.32	{A6}+OXCPB
	JUMP,EQ	R8^EXIT$

	MOVE.32	#{A6}+OXCDF,A2	; A2 <-- ^copie descripteur fentre

	MOVE.32	D6,D2		; D2 <-- dimensions
	MOVE.32	D5,D4		; D4 <-- origine destination
	CLR.32	D3		; D3 <-- origine source
	MOVE.16	{A2}+ODFIIY,D5
	MOVE.32	{A2}+ODFABS,A3	; A3 <-- ^source
	SUB.32	A4,A4		; A4 <-- ^destination (cran)

	MOVE.32	A0,A2		; A2 <-- ^descripteur
	MOVE.32	#LOADDOT,D1	; D1 <-- mode
	GRA2_	RASTER		; met le bitmap dans la fentre

	MOVE.32	{A6}+OXCPB,A4	; A4 <-- ^bitmap
	MOVE.32	#MTYPCP,D1
	GESMEM	?GIVMEM		; libre mmoire pour bitmap

EXIT$:	MOVE.8	#AFSCMO,D3
	LIB	?AFCAR		; remet la souris

	POPM.32	D1..D5|A2..A4
	RET



;--------\\
; NAMEGC  >
;========/

; Construit le nom du fichier  charger.

; in	D0.8	fonte
;	D1.32	style/chasse
; out	A3.32	^nom du fichier
; mod	D7.16, A3.32

NAMEGC:
	PUSH.32	D1

	MOVE.32	#{A6}+OXCFILN,A3
	MOVE.8	#"S",{A3+}
	MOVE.8	#"M",{A3+}
	MOVE.8	#"A",{A3+}
	MOVE.8	#"_",{A3+}
	MOVE.8	D0,{A3+}
	MOVE.8	D1,{A3+}
	MOVE.8	#"P",{A3+}
	TEST.32	D1:#BGCFIX
	JUMP,BC	 R8^L40$
	MOVE.8	#"F",{A3}-1
	TCLR.8	{A3}-2:#BGCFIX

L40$:	MOVE.8	#"0",{A3+}
	MOVE.8	#"0",{A3+}
	MOVE.8	#".",{A3+}
	MOVE.8	#"G",{A3+}
	MOVE.8	#"E",{A3+}
	MOVE.8	#"N",{A3+}
	MOVE.8	#"C",{A3+}
	CLR.8	{A3}

	MOVE.32	#{A6}+OXCFILN,A3

	POP.32	D1
	RET

;--------\\
; NAMEGCJ >
;========/

; Construit le nom du fichier trs petit  charger.

; in	A4.32	^gencar en entre
; out	A3.32	^nom du fichier
;	D7.16	erreur
; mod	D7.16

NAMEGCJ:
	PUSHM.32 D4|A2

	MOVE.16	#1,D7

	MOVE.32	A4,D4		; gencar valide ?
	JUMP,F	EXIT$		; non => termin

	MOVE.16	{A6}+OXCT,D4	; D4 <-- taille demande
	COMP.16	{A4}+oxcPMN,D4	; taille trs petite ?
	JUMP,HS	 R8^EXIT$	; non => EXIT$

	TEST.8	{A4}+oxcPNG	; nom existe ?
	JUMP,EQ	 R8^EXIT$	; non => EXIT$

	MOVE.32	#{A6}+OXCFILN,A2
	MOVE.32	#{A6}+OXCFILJ,A3

XFER$:	MOVE.8	{A2+},{A3+}	; OXCFILJ <-- OXCFILN
	JUMP,NE XFER$

	MOVE.32	#{A6}+OXCFILJ,A3
	MOVE.16	{A4}+oxcPNG,{A3}+4
	MOVE.8	#"P",{A3}+6

	TCLR.8	{A3}+4+1:#BGCFIX
	JUMP,BC	R8^OK$
	MOVE.8	#"F",{A3}+6

OK$:	CLR.16	D7		; D7 <-- ok

EXIT$:	POPM.32	D4|A2
	TEST.16	D7		; retour EQ/NE
	RET


;--------\\
; DIMGC   >
;========/

; Calcule les dimensions maximales d'un caractres.

; in	A4.32	^gencar en entre
; out	-
; mod	D7.16

DIMGC:
	PUSHM.32 D1..D4|A2|A3

	MOVE.32	A4,D1		; gencar valide ?
	JUMP,F	EXIT$		; non => termin

	CALL	CALCHTE		; D4 <-- hauteur du "E"
	MOVE.16	D4,{A6}+OXCIYE

	TEST.32	{A6}+OXCPJ
	JUMP,EQ	 R8^L10$
	PUSH.32	A4
	MOVE.32	{A6}+OXCPJ,A4
	CALL	CALCHTE		; D4 <-- hauteur du "E" si trs petit
	MOVE.16	D4,{A6}+OXCIYEJ
	POP.32	A4
L10$:
	MOVE.32	#{A4}+oxcXMINS,A3
	MOVE.16	#128-1,D3
	CLR.16	D4
L20$:
	MOVE.16	{A3+},D2
	NEG.16	D2
	COMP.16	D2,D4
	JUMP,GE	 R8^L22$
	MOVE.16	D2,D4
L22$:
	DJ.16,NMO  D3,L20$
	CALL	CONVIO
	TEST.8	{A4}+oxcMODE+2:#bxcMODELIMIT-8
	JUMP,BC	 R8^L24$
	CLR.16	D4
L24$:
	MOVE.16	D4,{A6}+OXCIX1

	MOVE.32	#{A4}+oxcYMINS,A3
	MOVE.16	#128-1,D3
	CLR.16	D4
L30$:
	MOVE.16	{A3+},D2
	NEG.16	D2
	COMP.16	D2,D4
	JUMP,GE	 R8^L32$
	MOVE.16	D2,D4
L32$:
	DJ.16,NMO  D3,L30$
	CALL	CONVIO
	MOVE.16	D4,{A6}+OXCIY1

	MOVE.32	#{A4}+oxcXMAXS,A3
	MOVE.32	#{A4}+oxcLENGTH,A2
	MOVE.16	#128-1,D3
	CLR.16	D4
L40$:
	MOVE.16	{A2+},D2
	TEST.8	{A4}+oxcMODE+2:#bxcMODELINK-8
	JUMP,BS	 R8^L44$
	TEST.8	{A6}+OXCS+3:#BGCFIX-0
	JUMP,BS	 R8^L44$
	MOVE.16	{A3+},D1	; D1 <-- chasse minimale (recouvrement impossible !)
	COMP.16	D1,D2
	JUMP,HS	 R8^L44$
	MOVE.16	D1,D2
L44$:
	COMP.16	D2,D4
	JUMP,GE	 R8^L48$
	MOVE.16	D2,D4
L48$:
	DJ.16,NMO  D3,L40$
	CALL	CONVIO
	MOVE.16	D4,{A6}+OXCIX2

	MOVE.32	#{A4}+oxcYMAXS,A3
	MOVE.16	#128-1,D3
	CLR.16	D4
L50$:
	MOVE.16	{A3+},D2
	COMP.16	D2,D4
	JUMP,GE	 R8^L52$
	MOVE.16	D2,D4
L52$:
	DJ.16,NMO  D3,L50$
	CALL	CONVIO
	INC.16	D4
	MOVE.16	D4,{A6}+OXCIY2

	TEST.8	{A6}+OXCS+3:#BGCFIX-0
	JUMP,BC	 R8^L60$
	MOVE.16	{A4}+oxcLENGTH+(2*"E"),D4
	CALL	CONVIO		; D4 <-- largeur du "E"
	MOVE.16	D4,{A6}+OXCIX2
L60$:
	MOVE.16	{A6}+OXCIX1,D4
	ADD.16	{A6}+OXCIX2,D4
	ADD.16	#16-1,D4
	SR.16	#4,D4
	SL.16	#1,D4
	MOVE.16	D4,{A6}+OXCIXB

EXIT$:	POPM.32	D1..D4|A2|A3
	RET


;---------\\
; CONVHEAD >
;=========/

; Gnre l'en-tte du gnrateur.

; in	A3	^gencar en sortie
;	D3.32	lg  gnrer en sortie
;	  	^gencar en entre
; out	(A3)++	gencar en sortie
; mod	D7.W

CONVHEAD:
	PUSHM.32 D1..D4|A1|A2|A5

	PUSH.32	A4
	MOVE.32	A3,A4
	MOVE.32	D3,D4
	GESMEM	?CLEARMEM	; efface tout en sortie
	POP.32	A4

; Gnre l'en-tte du gencar.

	MOVE.16	{A6}+OXCIY1,D4
	ADD.16	{A6}+OXCIY2,D4
	MOVE.16	D4,{A3}+OGCMHD

	MOVE.16	{A6}+OXCIXB,D4
	MOVE.8	D4,{A3}+OGCMWB
	MUL.16	{A3}+OGCMHD,D4
	MOVE.16	D4,{A3}+OGCMSB

;	MOVE.8	#0,{A3}+OGCFCA
	MOVE.8	#128-1,{A3}+OGCLCA

	MOVE.16	{A6}+OXCIX1,{A3}+OGCLMA
	MOVE.16	{A6}+OXCIY2,{A3}+OGCBLI
	MOVE.16	{A6}+OXCIY1,{A3}+OGCMH1
	MOVE.16	{A6}+OXCIY2,{A3}+OGCMH2

	MOVE.16	{A6}+OXCIX1,D4
	ADD.16	{A6}+OXCIX2,D4
	MOVE.16	D4,{A3}+OGCMWI

	MOVE.16	{A6}+OXCIYE,D4	; D4 <-- hauteur du "E"
	MUL.16	{A4}+oxcITL,D4
	DIV.16	#1000,D4
	CALL	CONVIO		; D4 <-- hauteur du "E"
	MOVE.16	{A6}+OXCIY1,D2
	ADD.16	{A6}+OXCIY2,D2	; D2 <-- minimum autoris
	COMP.16	D2,D4
	JUMP,HS	 R8^L15$
	MOVE.16	D2,D4
L15$:
	MOVE.16	D4,{A3}+OGCISP

	MOVE.8	#1,{A3}+OGCVSP
;	MOVE.16	#16'0000,{A3}+OGCPWI
	MOVE.16	#16'0080,{A3}+OGCPH1
	MOVE.16	#16'0100,{A3}+OGCPH2
	MOVE.16	#16'0180,{A3}+OGCPMX

	MOVE.32	{A4}+oxcRBI,{A3}+OGCRBI

	MOVE.32	#{A3}+OGCIDE,A1
	MOVE.32	#{A4}+oxcIDE,A2
L20$:
	MOVE.8	{A2+},{A1+}
	JUMP,NE L20$

	MOVE.32	#{A3}+OGCTXT,A1
	MOVE.32	#{A4}+oxcTEXT,A2
L22$:
	MOVE.8	{A2+},{A1+}
	JUMP,NE L22$

	MOVE.32	#{A3}+OGCCNM,A1
	MOVE.32	#{A4}+oxcNAME,A2
L24$:
	MOVE.8	{A2+},{A1+}
	JUMP,NE L24$

; Gnre la table de chasse.

	COMP.32	#OGCWID,D3
	JUMP,LS L90$

	MOVE.32	#{A3}+OGCWID,A1
	MOVE.32	#{A4}+oxcLENGTH,A2
	MOVE.32	#{A4}+oxcXMAXS,A5
	MOVE.16	#128-1,D1
L40$:
	MOVE.16	{A2+},D4
	TEST.8	{A4}+oxcMODE+2:#bxcMODELINK-8
	JUMP,BS	 R8^L45$
	TEST.8	{A6}+OXCS+3:#BGCFIX-0
	JUMP,BS	 R8^L45$
	MOVE.16	{A5+},D2	; D2 <-- chasse minimale (recouvrement impossible !)
	COMP.16	D2,D4
	JUMP,HS	 R8^L45$
	MOVE.16	D2,D4
L45$:
	CALL	CONVIO
	ADD.16	{A6}+OXCIX1,D4
	MOVE.8	D4,{A1+}
	DJ.16,NMO  D1,L40$

; Gnre la table h1.

	COMP.32	#OGCH1,D3
	JUMP,LS	 R8^L90$

	MOVE.32	#{A3}+OGCH1,A1
	MOVE.32	#{A4}+oxcYMINS,A2
	MOVE.16	#128-1,D1
L50$:
	MOVE.16	{A2+},D4
	NEG.16	D4
	CALL	CONVIO
	MOVE.8	D4,{A1+}
	DJ.16,NMO  D1,L50$

; Gnre la table h2.

	COMP.32	#OGCH2,D3
	JUMP,LS	 R8^L90$

	MOVE.32	#{A3}+OGCH2,A1
	MOVE.32	#{A4}+oxcYMAXS,A2
	MOVE.16	#128-1,D1
L60$:
	MOVE.16	{A2+},D4
	CALL	CONVIO
	MOVE.8	D4,{A1+}
	DJ.16,NMO  D1,L60$

L90$:
	POPM.32	D1..D4|A1|A2|A5
	RET

;--------\\
; CALCHTE >
;========/

; Cherche la hauteur du "E", sans tenir compte des pinceaux.

; in	A4.L	^gencar en entre
; out	D4.W	hauteur du "E"
; mod	D4.L, D7.W

CALCHTE:
	MOVE.32	A4,D4		; gencar valide ?
	JUMP,F	R8^EXIT$	; non => termin

	MOVE.16	{A4}+oxcHTE,D4
	JUMP,NE	 R8^EXIT$
	MOVE.16	{A4}+oxcYMINS+(2*"E"),D4
	NEG.16	D4
EXIT$:	RET



;--------\\
; CONVGC  >
;========/

; Gnre toutes les matrices des caractres.

; in	A3	^gencar en sortie
;	  	^gencar en entre
; out	(A3)++	gencar en sortie
; mod	D7.W

CONVGC:
	PUSHM.32 D3|A2

; Prpare le descripteur de fentre.

	MOVE.32	#{A6}+OXCDF,A2	; A2 <-- ^descripteur fentre spcial

	CLR.32	{A2}+ODFY
	CLR.32	{A2}+ODFFY
	CLR.32	{A2}+ODFWBY

	CLR.16	D3
	MOVE.8	{A3}+OGCMWB,D3
	MOVE.16	D3,{A2}+ODFIIY
	SL.16	#3,D3
	MOVE.16	D3,{A2}+ODFDX
	MOVE.16	D3,{A2}+ODFFDX
	MOVE.16	D3,{A2}+ODFWEX

	MOVE.16	{A3}+OGCMHD,D3
	MOVE.16	D3,{A2}+ODFDY
	MOVE.16	D3,{A2}+ODFFDY
	MOVE.16	D3,{A2}+ODFWEY

	MOVE.16	#1,{A2}+ODFIIX
	MOVE.8	#GRACLIP,{A2}+ODFMGR
	MOVE.8	#-1,{A2}+ODFNOW

; Gnre tous les caractres.

	CLR.16	D3
L40$:
	CALL	CONVCAR		; gnre un caractre
	INC.16	D3
	COMP.16	#128,D3
	JUMP,LO L40$

	POPM.32	D3|A2
	RET

;--------\\
; CONVCAR >
;--------/

; Gnre la matrice d'un caractre.

; in	D3.16	code d'un caractre
;	A3.32	^gencar en sortie
; out	(A3)++	nouvelle matrice
; mod	D7.16

CONVCAR:
	PUSHM.32 D1..D4|A1..A5

	MOVE.16	D3,D1		; D1 <-- caractre

	MUL.16	{A3}+OGCMSB,D3
	MOVE.32	#{A3}+OGCMAT,A1
	ADD.32	D3,A1		; A1 <-- ^matrice  crer

	MOVE.32	#{A6}+OXCBRG,A2	; A2 <-- ^descripteur bitmap
	MOVE.32	A1,{A2}+OGBMAPPT

	CLR.16	D4
	MOVE.8	{A3}+OGCMWB,D4	; D4 <-- largeur matrice en bytes
	MOVE.16	D4,{A2}+OGBMAPWIDTH

	CLR.32	{A2}+OGBMAPRECT+OGRECTTL
	MOVE.16	{A3}+OGCMHD,D4	; D4 <-- hauteur matrice
	SWAP.32	D4
	CLR.16	D4
	MOVE.8	{A3}+OGCMWB,D4
	SL.16	#3,D4		; D4 <-- largeur matrice
	MOVE.32	D4,{A2}+OGBMAPRECT+OGRECTBR

	MOVE.16	D1,D3		; D3 <-- caractre
	CALL	IFFILL		; remplissage ?
	JUMP,NE L50$		; non => 50$

	SUB.32	#2,SP		; stack <-- rserve place pour erreur
	PUSH.32	{A6}+OXCIRG	; stack <-- ^identificateur rgion
	PUSH.16	#GFILLXOR+GFILLINTERIOR	; stack <-- mode
	PUSH.32	#{A6}+OXCBRG+OGBMAPRECT	; stack <-- ^cliprect
	MOVE.32	{A6}+OAGMOR,A1
	CALL	{A1}		; GMI_OPENRGN, dbut de dfinition de rgion
	POP.16	D7
	JUMP,NE	 R8^L50$

	MOVE.16	D1,D3		; D3 <-- caractre
	MOVE.16	#XCMODFILL,{A6}+OXCMOD
	CALL	DECODE		; dfinition de la rgion

	SUB.32	#2,SP		; stack <-- rserve place pour erreur
	PUSH.32	{A6}+OXCIRG	; stack <-- ^identificateur rgion
	MOVE.32	{A6}+OAGMCR,A1
	CALL	{A1}		; GMI_CLOSERGN, termine la dfinition de rgion
	POP.16	D7

	SUB.32	#2,SP		; stack <-- rserve place pour erreur
	PUSH.32	{A6}+OXCIRG	; stack <-- ^identificateur rgion
	PUSH.32	#{A6}+OXCBRG	; stack <-- ^descripteur bitmap
	PUSH.8	#GMOR		; stack <-- mode de transfert
	MOVE.32	{A6}+OAGMRB,A1
	CALL	{A1}		; GMI_RGNTOBITMAP, bitmap <-- rgion
	POP.16	D7

L50$:
	MOVE.16	D1,D3		; D3 <-- caractre
	CALL	IFOUTL		; outline ?
	JUMP,NE	 R8^L90$	; non => 90$

	MOVE.32	#{A6}+OXCBRG,A2	; A2 <-- ^descripteur bitmap
	MOVE.32	{A2}+OGBMAPPT,{A6}+OXCDF+ODFABS
	MOVE.16	#XCMODOUTL,{A6}+OXCMOD
	CALL	DECODE		; dfinition de la rgion
L90$:
	POPM.32	D1..D4|A1..A5
	RET

;-----------\\
; CONVCARSCR >
;-----------/

; Dessine la matrice d'un caractre directement dans l'cran.

; in	D3.16	code d'un caractre
;	A3.32	^descripteur
; out	-
; mod	D7.16

CONVCARSCR:
	PUSHM.32 D1..D4|A1..A5

	MOVE.16	D3,D1		; D1 <-- caractre
	CALL	IFFILL		; remplissage ?
	JUMP,NE	R8^L50$		; non => 50$

	SUB.A16	#2,SP		; stack <-- rserve place pour erreur
	PUSH.32	{A6}+OXCIRG	; stack <-- ^identificateur rgion
	PUSH.16	#GFILLXOR+GFILLINTERIOR	; stack <-- mode
	PUSH.32	#{A6}+OXCBRG+OGBMAPRECT	; stack <-- ^cliprect
	MOVE.32	{A6}+OAGMOR,A1
	CALL	{A1}		; GMI_OPENRGN, dbut de dfinition de rgion
	POP.16	D7
	JUMP,NE	 R8^L50$

	MOVE.16	D1,D3		; D3 <-- caractre
	MOVE.16	#XCMODFILL,{A6}+OXCMOD
	CALL	DECODE		; dfinition de la rgion

	SUB.32	#2,SP		; stack <-- rserve place pour erreur
	PUSH.32	{A6}+OXCIRG	; stack <-- ^identificateur rgion
	MOVE.32	{A6}+OAGMCR,A1
	CALL	{A1}		; GMI_CLOSERGN, termine la dfinition de rgion
	POP.16	D7

	MOVE.32	#{A6}+OXCBRG,A2	; A2 <-- ^descripteur bitmap
	MOVE.16	#GMOR,D2	; D2 <-- mode de transfert

	SUB.32	#2,SP		; stack <-- rserve place pour erreur
	PUSH.32	{A6}+OXCIRG	; stack <-- ^identificateur rgion
	PUSH.32	#{A6}+OXCBRG	; stack <-- ^descripteur bitmap
	PUSH.8	#GMOR		; stack <-- mode de transfert
	MOVE.32	{A6}+OAGMRB,A1
	CALL	{A1}		; GMI_RGNTOBITMAP, bitmap <-- rgion
	POP.16	D7

L50$:	MOVE.16	D1,D3		; D3 <-- caractre
	CALL	IFOUTL		; outline ?
	JUMP,NE	R8^L90$		; non => 90$

	MOVE.16	#XCMODOUTL,{A6}+OXCMOD
	CALL	DECODE		; dfinition de la rgion

L90$:	POPM.32	D1..D4|A1..A5
	RET


;--------\\
; CONVIO  >
;========/

; 

; in	D4.W	longueur dans le gencar en entre [pi]
; out	D4.W	idem, dans le gencar en sortie [po]
; mod	D4.L, D7.W

CONVIO:
	PUSH.32	D3

	MUL.A16	{A6}+OXCT,D4

	CLR.32	D3
	MOVE.16	{A6}+OXCIYE,D3
	SR.16	#1,D3
	ADD.32	D3,D4
	DIV.A16	{A6}+OXCIYE,D4

	POP.32	D3
	RET

;--------\\
; CONVIOJ >
;========/

; 

; in	D4.W	longueur dans le gencar en entre [pi]
; out	D4.W	idem, dans le gencar en sortie [po]
; mod	D4.L, D7.W

CONVIOJ:
	PUSH.32	D3

	MUL.A16	{A6}+OXCT,D4

	CLR.32	D3
	MOVE.16	{A6}+OXCIYEJ,D3
	SR.16	#1,D3
	ADD.32	D3,D4
	DIV.A16	{A6}+OXCIYEJ,D4

	POP.32	D3
	RET



;--------\\
; OPEVAR  >
;--------/

; Ouvre les variables locales.

; ATTENTION:	Il faut absolument excuter un appel  GMI par un CALL (An)
;		et non par un appel normal GMI_xxx, car le passage des
;		paramtres par le stack n'est pas compatible entre GMI et
;		les modules .LIB en mode superviseur !!!

; in	-
; out	A6.L	^variables locales
;	D7.16	erreur
; mod	D7.W, A6.L

OPEVAR:
	PUSHM.32 D1|D3|D4|A1|A3|A4

	MOVE.32	#R16^NMGMI,A3
	MOVE.16	#GMI_FIRST,D3
	LIB_	OPEN			; ouvre le module GRAMISC si ncessaire
	JUMP,NE	EXIT$

	MOVE.16	D1,D3

	MOVE.32	#LGVAR,D4
	MOVE.32	#MTYPCP,D1
	GESMEM	?GETMEM			; demande mmoire pour les variables
	JUMP,NE EXIT$

	GESMEM	?CLEARMEM
	MOVE.32	A4,A6			; A6 <-- ^variables locales

	MOVE.16	D3,{A6}+OXCGMI
	MOVE.32	#R16^TABLE$,A1

; L'accs  GRAMISC se fait par des CALLs directs afin d'tre rapide
; et fonctionner en mode superviseur (soi-disant).

ALOOP$:	MOVE.16	{A1+},D3
	JUMP,EQ	R8^OK$
	MOVE.16	{A1+},D1

	LIB_	GETAD
	MOVE.32	A3,{A6}+A16^{D1}	; remplit la table des adresses
	JUMP	ALOOP$

OK$:	CALL	GETPDIS			; A4 <-- ^descripteur $DIS_0
	JUMP,NE	R8^EXIT$

	MOVE.32	A4,A3			; A3 <-- ^descripteur $DIS_0 original
	MOVE.32	#{A6}+OXCDF,A4		; A4 <-- ^copie descripteur fentre
	MOVE.32	#LGDIS10+4,D4
	GESMEM	?COPYMEM

	MOVE.32	A4,A3			; A3 <-- ^copie descripteur fentre
	SET.8	{A3}+ODFNOW		; on n'est pas dans $DIS_0
	MOVE.32	A3,{A3}+ODFCHECK
	MOVE.16	#-1,{A3}+ODFGRABCNT	; pour le grab...
	MOVE.16	#2,{A3}+ODFCNB		; 2 couleurs
	MOVE.8	#1,{A3}+ODFCNP		; 1 bit/pixel
	CLR.8	{A3}+ODFCMD		; mode monochrome

	MOVE.32	#1,{A3}+ODFCSF		; couleur pour allumer
	CLR.32	{A3}+ODFCCF		; couleur pour teindre

	CLR.16	D7			; D7 <-- ok

EXIT$:	POPM.32	D1|D3|D4|A1|A3|A4
	TEST.16	D7			; retour EQ/NE
	RET


TABLE$:	.16	GMI_NEWRGN,	OAGMNR
	.16	GMI_DISPOSERGN,	OAGMDR
	.16	GMI_OPENRGN,	OAGMOR
	.16	GMI_CLOSERGN,	OAGMCR
	.16	GMI_RGNTOBITMAP,OAGMRB
	.16	GMI_PUTRLINE,	OAGMPL
	.16	0


;--------\\
; CLOVAR  >
;--------/

; Ferme les variables locales.

; in	A6.L	^variables locales
; out	-
; mod	-

CLOVAR:
	PUSHM.32 D1|D7|A4

	MOVE.16	{A6}+OXCGMI,D1
	LIB_	CLOSE			; libre le module GRAMISC

	MOVE.32	#MTYPCP,D1

	TEST.32	{A6}+OPPEN
	JUMP,EQ	R8^GIVE$
	MOVE.32	{A6}+OPPEN,A4
	GESMEM	?GIVMEM			; libre l'ancien pinceau

GIVE$:	MOVE.32	A6,A4
	GESMEM	?GIVMEM			; rend les variables

	POPM.32	D1|D7|A4
	RET



;--------\\
; GETPDIS >
;========/

; Cherche le descripteur de $DIS_0

; in	-
; out	A4.32	^descripteur de $DIS_0
;	D7.16	erreur
; mod	D7.16, A4.32

GETPDIS:
	PUSHM.32 D3|D4|D6|A3

	MOVE.32	#R16^NAME$,A3
	MOVE.32	#2**BOPEXTEND.OR.2**BOPRSTATUS,D3
	FOS	?ARGSOPEN
	JUMP,NE	 R8^EXIT$

	PUSH.32	D4		; stack <-- ^p'tit buffer de 4 bytes
	MOVE.32	SP,A4		; A4 <-- ^buffer
	MOVE.32	#4,D4		; D4 <-- lg demande
	FOS	?RSTATUS	; lit le ^descripteur
	MOVE.32	{A4},A4		; A4 <-- ^descripteur
	POP.32	D4

	PUSH.16	D7
	FOS	?CLOSE
	POP.16	D7
EXIT$:
	POPM.32	D3|D4|D6|A3
	TEST.16	D7		; retour EQ/NE
	RET

NAME$:	.ASCIZ	"$DIS_0"
	.EVEN


; in	A3.32	^nom du fichier
; 	D3.32	 fanions
; out	...	 comme FOS ?CLOAD
; mod	...

CLOAD:
	PUSHM.32 D0|A0|A1|A3

	SUB.A16	#80,SP
	MOVE.32	#R16^NMPFIX,A0
	MOVE.32	SP,A1

COPY1$:	MOVE.8	{A0+},{A1+}
	JUMP,NE	COPY1$

	MOVE.32	A3,A0
	DEC.32	A1

COPY2$:	MOVE.8	{A0+},{A1+}
	JUMP,NE	COPY2$

	MOVE.32	SP,A3
	FOS	?CLOAD		; charge depuis le bon dossier systme
	ADD.A16	#80,SP

	POPM.32	D0|A0|A1|A3
	RET


	.INS	XCARBITMAP.ASI
	.INS	XCARFRAG.ASI
	.INS	XCARLSTGC.ASI
	.INS	XCARDRAW.ASI

NMGMI:	.ASCIZ	"GRAMISC"
NMPFIX:	.ASCIZ	"#:(GENC:,)"
FLNAME:	.ASCIZ	"#:(GENC:,)SMA_XCAR.INFO"
	.EVEN

END_XCAR:

	.END

