
; $sma; $flg: 00010002
; $bin: F.MERR
; --------------------

	.TITLE		ERROR
	.PROC		M68000

ErrSCSI	=	false

	.REF		SMAKY
	.REF		MODULES
	.REF		RES

	.MACRO		TLANGUE
	.IF		COPY(%P,7,1)=F
LANGUE	= FR
	.ENDIF
	.IF		COPY(%P,7,1)=E
LANGUE	= AN
	.ENDIF
	.IF		COPY(%P,7,1)=D
LANGUE	= AL
	.ENDIF
	.ENDMACRO

FR	= 1		; franais
AN	= 2		; anglais
AL	= 3		; allemand

; rpartition des erreurs
; 04..	Display
; 05..	Printer
; 06..	Keyboard
; 81..	Ntrel
; 82..	Bios
; 83..	Gesmem
; 84..	Scsi
; 85..	Fos
; 86..	Lib
; 87..	Cle
; 88..	Mem Masse
; 89..	Netw
; 90..	Basic
; 92..	Logo
; 94..	Modula
; A0..	Ressources
; B0..	Pilotes


TLANGUE			; assemblage conditionnel selon FR/AN/AL
COMPLET	= FALSE		; tous les messages

; erreurs non comprise dans SMAKY.SYMB
; ------------------------------------
;
ERSYS		=	16'8000				; erreur systme
ERLIB		=	16'8600				; erreur LIB
ERDIMA		=	16'0420				; codage d'image
ERKEY		=	16'0600				; erreur clavier
ERMRDA		=	16'8834				; err. read data
ERMWDA		=	16'8844				; err. write data
ERNBLO		=	16'8935				; manque un bloc

ERCDEF		=	16'8701				; chane de dfinition illgale
ERCLAB2		=	16'8702				; label inexistant
ERCLAB1		=	16'8703				; label dj dfini
ERCLABI		=	16'8704				; label illgal
ERCIF		=	16'8705				; trop de .IF..
ERCMAC		=	16'8706				; commande macro


	.LOC		0

	.16.16		ERSYS,	T_ERSYS


; FOS ->
	.16.16		ERFOS,	T_ERFOS
	.16.16		ERFRES, T_ERFRES
	.16.16		ERFUNI, T_ERFUNI
	.16.16		ERFFIL, T_ERFFIL
	.16.16		ERFILL, T_ERFILL

	.16.16		ERILOP, T_ERILOP
	.16.16		EROUTF, T_EROUTF
	.16.16		ERFDNE, T_ERFDNE
	.16.16		ERFAEX, T_ERFAEX
	.16.16		ERILCH, T_ERILCH
	.16.16		ERFUSE, T_ERFUSE
	.16.16		ERFNOP, T_ERFNOP
	.16.16		ERUNNI, T_ERUNNI
	.16.16		ERUUSE, T_ERUUSE
	.16.16		ERUTYP, T_ERUTYP
	.16.16		ERDDNE, T_ERDDNE
	.16.16		ERITYP, T_ERITYP
;	.16.16		ERNREL, T_ERNREL
	.16.16		ERXCHANGE, T_ERXCHANGE
	.16.16		ERNENT, T_ERNENT
	.16.16		ERCHMM, T_ERCHMM
	.16.16		ERFILG, T_ERFILG
                                        
	.16.16		ERFULL, T_ERFULL
	.16.16		ERDKFU, T_ERDKFU
.if	false
	.16.16		ERFTFU, T_ERFTFU
	.16.16		ERSTFU, T_ERSTFU
	.16.16		ERLIFU, T_ERLIFU
	.16.16		ERTPFU, T_ERTPFU
	.16.16		ERPMFU, T_ERPMFU
	.16.16		ERDTFU, T_ERDTFU
	.16.16		ERVTFU, T_ERVTFU
	.16.16		ERNTFU, T_ERNTFU
	.16.16		ERUTFU, T_ERUTFU
.endif
	.16.16		ERBUFU, T_ERBUFU
	.16.16		ERMSFU, T_ERMSFU
                                        
	.16.16		ERATT,	T_ERATT
	.16.16		ERATTE, T_ERATTE
	.16.16		ERATTM, T_ERATTM
	.16.16		ERATTR, T_ERATTR
	.16.16		ERATTW, T_ERATTW
	.16.16		ERATTY, T_ERATTY
	.16.16		ERATTS, T_ERATTS
	.16.16		ERATTG, T_ERATTG
	.16.16		ERATTD, T_ERATTD
	.16.16		ERATTC, T_ERATTC
	.16.16		ERATTA, T_ERATTA
	.16.16		ERATTZ, T_ERATTZ
	.16.16		ERATTX, T_ERATTX
	.16.16		ERATTN, T_ERATTN
	.16.16		ERFCODE,T_ERFCODE
	.16.16		ERNSUNI,T_ERNSUNI
                                         
	.16.16		ERBINA, T_ERBINA
	.16.16		ERBICHK,T_ERBICHK
	.16.16		ERBNRE, T_ERBNRE
	.16.16		ERSYNT, T_ERSYNT
	.16.16		ERILUN, T_ERILUN
	.16.16		ERTOLO, T_ERTOLO
	.16.16		ERTOCO, T_ERTOCO
	.16.16		ERILCA, T_ERILCA
	.16.16		ERILAT, T_ERILAT

	.16.16		ERUCALL,T_ERUCALL
	.16.16		ERNSERV,T_ERNSERV
	.16.16		ERBLOQ, T_ERBLOQ


.if	COMPLET
	.16.16		ERNSAD, T_ERNSAD
	.16.16		ERILAD, T_ERILAD
	.16.16		ERNOHD, T_ERNOHD
                                        
	.16.16		ERLGFX, T_ERLGFX
	.16.16		ERNOOP, T_ERNOOP
                                        
	.16.16		ERLDIMA,T_ERLDIMA
	.16.16		ERIFNR, T_ERIFNR
.endif                                   

; GESMEM ->
	.16.16		ERGESM, T_ERGESM
	.16.16		ERMHKO, T_ERMHKO

	.16.16		ERIMEP, T_ERIMEP

	.16.16		ERMELG, T_ERMELG

	.16.16		ERMFUL, T_ERMFUL

.if	COMPLET
	.16.16		ERMEMKO,T_ERMEMKO

	.16.16		ERMCTYP,T_ERMCTYP
	.16.16		ERIPRS, T_ERIPRS
	.16.16		ERILIMI,T_ERILIMI
	.16.16		ERIADR, T_ERIADR
	.16.16		ERPTMEM,T_ERPTMEM
	.16.16		ERMPTYP,T_ERMPTYP

	.16.16		ERNLEN, T_ERNLEN

	.16.16		ERNEMEM,T_ERNEMEM
	.16.16		ERMOCC, T_ERMOCC
.endif


; BIOS ->
	.16.16		ERBIOS, T_ERBIOS
	.16.16		ERIDP,	T_ERIDP
	.16.16		ERIRLG, T_ERIRLG
	.16.16		ERIRDL, T_ERIRDL
	.16.16		ERDPR,	T_ERDPR 
	.16.16		ERRDPR, T_ERRDPR
	.16.16		ERWRPR, T_ERWRPR
	.16.16		ERKLPR, T_ERKLPR
	.16.16		ERDNTF,	T_ERDNTF
	.16.16		ERIDEV, T_ERIDEV
	.16.16		ERINAM, T_ERINAM
	.16.16		ERDOP,	T_ERDOP
	.16.16		EROPMX, T_EROPMX
	.16.16		ERALOP, T_ERALOP
	.16.16		ERAOPE, T_ERAOPE
	.16.16		ERNOTO, T_ERNOTO
	.16.16		ERUNCO, T_ERUNCO
	.16.16		ERHEAD,	T_ERHEAD

	.16.16		ERTRSTO,T_ERTRSTO
	.16.16		ERTERM, T_ERTERM
	.16.16		ERTRAV, T_ERTRAV
	.16.16		ERDEOF, T_ERDEOF
	.16.16		ERCOMA,	T_ERCOMA
	.16.16		ERILLO, T_ERILLO
	.16.16		ERTYPC, T_ERTYPC
	.16.16		ERCRED,	T_ERCRED
	.16.16		ERNDEV, T_ERNDEV
	.16.16		ERHREAD,T_ERHREAD
	.16.16		ERHWRITE,T_ERHWRITE

.if	COMPLET
	.16.16		ERDHAI, T_ERDHAI
	.16.16		ERDHIO, T_ERDHIO
	.16.16		ERDHIN, T_ERDHIN
	.16.16		ERDHIT, T_ERDHIT
.endif                                  


; NTREL ->
	.16.16		ERNTREL,T_ERNTREL
	.16.16		ERNTLI,	T_ERNTLI
	.16.16		ERTIMO, T_ERTIMO
	.16.16		ERINTP,	T_ERINTP
	.16.16		ERILPT, T_ERILPT
	.16.16		ERPRIO, T_ERPRIO
	.16.16		ERMINU, T_ERMINU

	.16.16		ERINTO, T_ERINTO

	.16.16		ERNOOB,	T_ERNOOB

	.16.16		ERLIMA,	T_ERLIMA

.if	COMPLET
	.16.16		ERILMO, T_ERILMO
	.16.16		ERNORA, T_ERNORA
	.16.16		ERNCHI, T_ERNCHI
	.16.16		ERNOIS, T_ERNOIS
	.16.16		ERFPOS, T_ERFPOS
	.16.16		ERPNIS, T_ERPNIS
	.16.16		ERPNIA, T_ERPNIA
	.16.16		ERPNIB, T_ERPNIB
	.16.16		ERVEOV, T_ERVEOV
	.16.16		ERLGTS, T_ERLGTS
.endif                                  


; Mmoire de Masse ->
	.16.16		ERMM,	T_ERMM
	.16.16		ERMFUNC,T_ERMFUNC
	.16.16		ERMDISK,T_ERMDISK
	.16.16		ERMOFF, T_ERMOFF
	.16.16		ERMRDY, T_ERMRDY
	.16.16		ERMUSE, T_ERMUSE
	.16.16		ERMOUT, T_ERMOUT
	.16.16		ERMWRK, T_ERMWRK
	.16.16		ERMDSK, T_ERMDSK
	.16.16		ERMNORD,T_ERMNORD
	.16.16		ERMNPA, T_ERMNPA
	.16.16		ERMPNI, T_ERMPNI
	.16.16		ERMREAD,T_ERMREAD

	.16.16		ERMRFI, T_ERMRFI
	.16.16		ERMWRITE,T_ERMWRITE

	.16.16		ERMWFI, T_ERMWFI
	.16.16		ERMWPR, T_ERMWPR
	.16.16		ERMWFO, T_ERMWFO

.if	COMPLET
	.16.16		ERMRDP, T_ERMRDP
	.16.16		ERMRDS, T_ERMRDS
	.16.16		ERMRNF, T_ERMRNF
	.16.16		ERMRDA, T_ERMRDA
	.16.16		ERMRCK, T_ERMRCK

	.16.16		ERMWDP, T_ERMWDP
	.16.16		ERMWDS, T_ERMWDS
	.16.16		ERMWNF, T_ERMWNF
	.16.16		ERMWDA, T_ERMWDA
	.16.16		ERMWCK, T_ERMWCK
.endif


; LIB ->
	.16.16		ERLIB,	T_ERLIB
	.16.16		ERLFUL, T_ERLFUL
	.16.16		ERLNOP, T_ERLNOP
	.16.16		ERLNWD, T_ERLNWD
	.16.16		ERLNKY, T_ERLNKY
	.16.16		ERLSYN,	T_ERLSYN
	.16.16		ERLBFU,	T_ERLBFU
	.16.16		ERLWFU, T_ERLWFU
	.16.16		ERLWUS, T_ERLWUS
	.16.16		ERLWNI, T_ERLWNI
	.16.16		ERLMFU,	T_ERLMFU
	.16.16		ERLMNO,	T_ERLMNO


; DISPLAY ->
	.16.16		ERDIS,	T_ERDIS
	.16.16		ERDIIL, T_ERDIIL
	.16.16		ERDIOUT,T_ERDIOUT
	.16.16		ERDIROL,T_ERDIROL
	.16.16		ERDIGC, T_ERDIGC
	.16.16		ERDINO, T_ERDINO

	.16.16		ERDIMA,	T_ERDIMA
	.16.16		ERDIND,	T_ERDIND

.if	COMPLET
	.16.16		ERDINC, T_ERDINC
	.16.16		ERDIDC,	T_ERDIDC
	.16.16		ERDIDD, T_ERDIDD
	.16.16		ERDIBUF,T_ERDIBUF
.endif


; KEY ->
	.16.16		ERKEY,	T_ERKEY
	.16.16		ERKYIL, T_ERKYIL
	.16.16		ERKYIN, T_ERKYIN
	.16.16		ERKYAA, T_ERKYAA
	.16.16		ERKYNA, T_ERKYNA
	.16.16		ERKYTA, T_ERKYTA
	.16.16		ERKYFU, T_ERKYFU



; PRINTER ->
	.16.16		ERPRIN, T_ERPRIN
	.16.16		ERPCTL, T_ERPCTL
	.16.16		ERPCUK, T_ERPCUK
	.16.16		ERPCIC, T_ERPCIC
	.16.16		ERPSYN, T_ERPSYN
	.16.16		ERPNPR, T_ERPNPR
	.16.16		ERPMPR, T_ERPMPR
;	.16.16		ERPIWD, T_ERPIWD
;	.16.16		ERPIIL, T_ERPIIL
	.16.16		ERPSTO, T_ERPSTO


; NETWORK ->
	.16.16		ERNETW, T_ERNETW
	.16.16		ERNILP, T_ERNILP

	.16.16		ERNISL, T_ERNISL
	.16.16		ERNPNR, T_ERNPNR

	.16.16		ERNSTL, T_ERNSTL
	.16.16		ERNHRD, T_ERNHRD
	.16.16		ERNHAB, T_ERNHAB
	.16.16		ERNHNQ, T_ERNHNQ

	.16.16		ERNABO, T_ERNABO

	.16.16		ERNMPF, T_ERNMPF
	.16.16		ERNMPS, T_ERNMPS
	.16.16		ERNMPC, T_ERNMPC

	.16.16		16'8980,T_8980

.if	COMPLET
	.16.16		ERNIPO, T_ERNIPO
	.16.16		ERNIAD, T_ERNIAD
	.16.16		ERNISN, T_ERNISN
	.16.16		ERNISP, T_ERNISP
	.16.16		ERNIPD, T_ERNIPD
	.16.16		ERNPWN, T_ERNPWN
	.16.16		ERNPIA, T_ERNPIA
	.16.16		ERNPWO, T_ERNPWO
	.16.16		ERNPNS, T_ERNPNS
	.16.16		ERNBLO, T_ERNBLO
	.16.16		ERNHMI, T_ERNHMI
	.16.16		ERNPEM, T_ERNPEM
	.16.16		ERNPFU, T_ERNPFU
	.16.16		ERNPUS, T_ERNPUS

	.16.16		16'8981,T_8981
	.16.16		16'8982,T_8982
	.16.16		16'8983,T_8983
	.16.16		16'8984,T_8984
	.16.16		16'8985,T_8985
	.16.16		16'8986,T_8986
	.16.16		16'8987,T_8987
	.16.16		16'8988,T_8988
.endif


; CLE ->
	.16.16		ERCDEF,	T_ERCDEF		; chane de dfinition illgale
	.16.16		ERCLAB2,T_ERCLAB2		; label inexistant
	.16.16		ERCLAB1,T_ERCLAB1		; label dj dfini
	.16.16		ERCLABI,T_ERCLABI		; label illgal
	.16.16		ERCIF,	T_ERCIF			; trop de .IF..
	.16.16		ERCMAC,	T_ERCMAC		; commande macro

; Ressources ->

	.16.16		ERrsIL, T_ERrsIL		; "illegal..."
.if	COMPLET
	.16.16		ERrsILMOD, T_ERrsILMOD		; "illegal mode" (OPEN/GET/CLOSE/DEF)
	.16.16		ERrsILNUM, T_ERrsILNUM		; "illegal ressource number"
	.16.16		ERrsILTYP, T_ERrsILTYP		; "illegal ressource type"
	.16.16		ERrsILKND, T_ERrsILKND		; "illegal ressource kind"
	.16.16		ERrsILSIZ, T_ERrsILSIZ		; "illegal ressource size"
	.16.16		ERrsILLAB, T_ERrsILLAB		; "illegal ressource label"
	.16.16		ERrsILSUBR, T_ERrsILSUBR	; "illegal subressource"
	.16.16		ERrsILCAN, T_ERrsILCAN		; "illegal channel"
	.16.16		ERrsILCTR, T_ERrsILCTR		; "illegal control command"
	.16.16		ERrsILKEY, T_ERrsILKEY		; "illegal key"
	.16.16		ERrsILOP, T_ERrsILOP		; "illegal operation"
	.16.16		ERrsILFSTO, T_ERrsILFSTO	; "illegal format de stockage"
.endif

	.16.16		ERrsFILE, T_ERrsFILE		; "file ERror..."
	.16.16		ERrsREV, T_ERrsREV		; "revision incompatibility"
	.16.16		ERrsNOSUBR, T_ERrsNOSUBR	; "no subressources implemented"
	.16.16		ERrsNORES, T_ERrsNORES		; "no ressources in RS file"
	.16.16		ERrsNORESCODE, T_ERrsNORESCODE	; "no ressources in CODE file"
	.16.16		ERrsBADFILE, T_ERrsBADFILE	; "bad ressource file"

	.16.16		ERrsMISC, T_ERrsMISC		; "miscellanous error..."
.if	COMPLET
	.16.16		ERrsSYSTO, T_ERrsSYSTO		; "system too old"
	.16.16		ERrsKILLED, T_ERrsKILLED	; "entity killed"
	.16.16		ERrsTYPAE, T_ERrsTYPAE		; "type already exists"
	.16.16		ERrsTOOMGIV, T_ERrsTOOMGIV	; "too many RES_GIVE"
	.16.16		ERrsUSED, T_ERrsUSED		; "ressource already used"
.endif

	.16.16		ERrsEXEC, T_ERrsEXEC		; "execution error..."
.if	COMPLET
	.16.16		ERrsBADHARDW, T_ERrsBADHARDW	; "bad hardware"
	.16.16		ERrsCALLDNE, T_ERrsCALLDNE	; "call does not exist"
	.16.16		ERrsDECACHE, T_ERrsDECACHE	; "decache not possible"
.endif


; Pilotes:
	.16.16		16'B000, T_B000
	.16.16		16'B001, T_B001
	.16.16		16'B002, T_B002

.if	ErrSCSI
; SCSI ->
	.16.16		16'8400, T_8400
	.16.16		16'8410, T_8410
	.16.16		16'8420, T_8420
	.16.16		16'8430, T_8430
	.16.16		16'8440, T_8440
	.16.16		16'8441, T_8441
	.16.16		16'8442, T_8442
	.16.16		16'8450, T_8440
	.16.16		16'8460, T_8460
	.16.16		16'8470, T_8470
	.16.16		16'8480, T_8480
	.16.16		16'8490, T_8490

.if	COMPLET
	.16.16		16'8401, T_8401
	.16.16		16'8402, T_8402
	.16.16		16'8403, T_8403
	.16.16		16'8404, T_8404
	.16.16		16'8405, T_8405
	.16.16		16'8406, T_8406
	.16.16		16'8407, T_8407
	.16.16		16'8408, T_8408
	.16.16		16'8409, T_8409
	.16.16		16'840A, T_840A
	.16.16		16'840B, T_840B
	.16.16		16'840C, T_840C
	.16.16		16'840D, T_840D
	.16.16		16'840E, T_840E

	.16.16		16'8411, T_8411
	.16.16		16'8412, T_8412

	.16.16		16'8421, T_8421
	.16.16		16'8422, T_8422
	.16.16		16'8423, T_8423
	.16.16		16'8424, T_8424
	.16.16		16'8425, T_8425
	.16.16		16'8426, T_8426
	.16.16		16'8427, T_8427
	.16.16		16'8428, T_8428
	.16.16		16'8429, T_8429
	.16.16		16'842A, T_842A

	.16.16		16'8431, T_8431
	.16.16		16'8432, T_8432
	.16.16		16'8433, T_8433
	.16.16		16'8434, T_8434
	.16.16		16'8435, T_8435
	.16.16		16'8436, T_8436
	.16.16		16'8437, T_8437
	.16.16		16'8438, T_8438
	.16.16		16'8439, T_8439
	.16.16		16'843A, T_843A
	.16.16		16'843B, T_843B
	.16.16		16'843C, T_843C
	.16.16		16'843D, T_843D

	.16.16		16'8443, T_8443
	.16.16		16'8444, T_8444
	.16.16		16'8445, T_8445
	.16.16		16'8446, T_8446
	.16.16		16'8447, T_8447
	.16.16		16'8448, T_8448
	.16.16		16'8449, T_8449
	.16.16		16'844A, T_844A
	.16.16		16'844B, T_844B

	.16.16		16'8451, T_8451
	.16.16		16'8452, T_8452
	.16.16		16'8453, T_8453
	.16.16		16'8454, T_8454
	.16.16		16'8455, T_8455
	.16.16		16'8456, T_8456
	.16.16		16'8457, T_8457

	.16.16		16'8461, T_8461
.endif
.endif
	.16		0, 0		; fin de la liste d'indirection

.if	LANGUE.EQ.FR

T_ERSYS:	.ASCIZ		"Problme systme"

T_ERFOS:	.ASCIZ		"Problme avec un fichier"
T_ERFRES:	.ASCIZ		"Extension rserve"
T_ERFUNI:	.ASCIZ		"Nom d'unit: attendu"
T_ERFILL:	.ASCIZ		"Nom de fichier illgal"

T_ERILOP:	.ASCIZ		"Opration illgale"
T_EROUTF:	.ASCIZ		"Hors du fichier"
T_ERFDNE:	.ASCIZ		"{Fichier} n'existe pas"
T_ERFAEX:	.ASCIZ		"{Fichier} existe dj"
T_ERILCH:	.ASCIZ		"Canal incorrect"      
T_ERFUSE:	.ASCIZ		"{Fichier} utilis"
T_ERFNOP:	.ASCIZ		"{Fichier} dj ferm"
T_ERUNNI:	.ASCIZ		"{#Unit} pas initialise"
T_ERUUSE:	.ASCIZ		"Unit {#} utilise"
T_ERUTYP:	.ASCIZ		"Type d'unit incorrect"
T_ERDDNE:	.ASCIZ		"Dossier {?} pas trouv"
T_ERITYP:	.ASCIZ		"Type d'installation incorrect"
T_ERNREL:	.ASCIZ		"RELEASE pas fait"
T_ERNENT:	.ASCIZ		"Rserv par un autre logiciel"
T_ERFILG:	.ASCIZ		"Fichier trop court!"

T_ERXCHANGE:
;		.ASCIZ		"Disquette prcdente pas referme"
;		.ASCIZ		"Nouvelle disquette dans le lecteur"
		.ASCIZ		"La disquette a t change"

T_ERFULL:	.ASCIZ		"Plein"
T_ERDKFU:	.ASCIZ		"Disque plein"
.if	0
T_ERFTFU:	.ASCIZ		"Trop de fichiers disques ouverts"
T_ERSTFU:	.ASCIZ		"Trop de fichiers locaux ouverts"
T_ERLIFU:	.ASCIZ		"Trop d'assignations"
T_ERTPFU:	.ASCIZ		"Trop de pilotes utiliss"
T_ERPMFU:	.ASCIZ		"Trop de fichier en cache"
T_ERUTFU:
T_ERDTFU:	.ASCIZ		"Trop de dossiers initialiss"
T_ERVTFU:	.ASCIZ		"Trop d'installations virtuelles"
T_ERNTFU:	.ASCIZ		"Trop de fichiers rseau ouverts"
.endif
T_ERBUFU:	.ASCIZ		"Tampon d'analyse plein"
T_ERMSFU:	.ASCIZ		"Mmoire du serveur pleine"

T_ERATT:	.ASCIZ		"{Fichier} protg"
T_ERATTE:	.ASCIZ		"Ouverture exclusive impossible"
T_ERATTM:	.ASCIZ		"Ouverture multiple impossible"
T_ERATTR:	.ASCIZ		"Lecture impossible"
T_ERATTW:	.ASCIZ		"Ecriture impossible"
T_ERATTY:	.ASCIZ		"Fermeture impossible"
T_ERATTS:	.ASCIZ		"Spos impossible"
T_ERATTG:	.ASCIZ		"Gpos impossible"
T_ERATTD:	.ASCIZ		"{Fichier} indestructible"
T_ERATTC:	.ASCIZ		"Changement de nom impossible"
T_ERATTA:	.ASCIZ		"Changement des attributs impossible"
T_ERATTZ:	.ASCIZ		"Remise  zro impossible"
T_ERATTX:	.ASCIZ		"{Fichier} pas excutable"
T_ERATTN:	.ASCIZ		"{} accs rseau protg"
T_ERFCODE:	.ASCIZ		"{Fichier} verrouill"
T_ERNSUNI:	.ASCIZ		"?MOVE impossible"

T_ERBINA:	.ASCIZ		"Binaire incorrect"
T_ERBICHK:	.ASCIZ		"Somme de contrle incorrecte"
T_ERBNRE:	.ASCIZ		"Binaire non relogeable"

T_ERPSYN:
T_ERLSYN:
T_ERSYNT:	.ASCIZ		"Syntaxe incorrecte"
T_ERILUN:	.ASCIZ		"Unit incorrecte"
T_ERTOLO:	.ASCIZ		"Nom trop long"
T_ERFFIL:
T_ERTOCO:	.ASCIZ		"Nom inexistant"
T_ERILCA:	.ASCIZ		"Caractre illgal"
T_ERILAT:	.ASCIZ		"Attribut illgal"

T_ERUCALL:	.ASCIZ		"RCVNET serveur trop ancien !"
T_ERNSERV:	.ASCIZ		"Station distante non serveur"
T_ERBLOQ:	.ASCIZ		"Machine arrte"

.if		COMPLET
T_ERNSAD:	.ASCIZ		"Pas d'adresse de dmarrage"
T_ERILAD:	.ASCIZ		"Adresse incorrecte"
T_ERNOHD:	.ASCIZ		"entte binaire pas en mmoire"
T_ERLGFX:	.ASCIZ		"Longueur pas en blocs"
T_ERIFNR:
T_ERNOOP:	.ASCIZ		"Plus d'option"
T_ERLDIMA:	.ASCIZ		"Image gnrique charge"
.endif

T_ERGESM:	.ASCIZ		"Problme mmoire"
T_ERMHKO:	.ASCIZ		"Mmoire dfectueuse"
T_ERIMEP:	.ASCIZ		"Paramtre mmoire illgal"
T_ERMELG:	.ASCIZ		"Longueur mmoire fausse"
T_ERMFUL:	.ASCIZ		"Mmoire pleine"

.if		COMPLET
T_ERMEMKO:	.ASCIZ		"Circuit mmoire dfectueux"
T_ERMCTYP:	.ASCIZ		"Entit mmoire incorrecte"
T_ERIPRS:	.ASCIZ		"Fraction mmoire trop grande"
T_ERILIMI:	.ASCIZ		"Limite mmoire incorrecte"
T_ERIADR:	.ASCIZ		"Adresse mmoire incorrecte"
T_ERPTMEM:	.ASCIZ		"Pointeur mmoire incorrect"
T_ERMPTYP:	.ASCIZ		"Type processus interdit"
T_ERNLEN:	.ASCIZ		"Longueur mmoire nulle"
T_ERNEMEM:	.ASCIZ		"Pas assez de mmoire"
T_ERMOCC:	.ASCIZ		"Mmoire dj occupe"
.endif


T_ERBIOS:	.ASCIZ		"Problme BIOS"
T_ERIDP:	.ASCIZ		"Paramtre illgal"
T_ERIRDL:
T_ERIRLG:	.ASCIZ		"Longueur illgale"

T_ERDPR:	.ASCIZ		"Pilote protg"
T_ERRDPR:	.ASCIZ		"Pilote protg en lecture"
T_ERWRPR:	.ASCIZ		"Pilote protg en criture"
T_ERKLPR:	.ASCIZ		"Pilote indestructible"

T_ERDNTF:	.ASCIZ		"Pilote introuvable"
T_ERIDEV:	.ASCIZ		"Numro de pilote inconnu"
T_ERINAM:	.ASCIZ		"Nom de pilote inconnu"

T_ERDOP:	.ASCIZ		"Problme d'ouverture"
T_EROPMX:	.ASCIZ		"Trop de pilotes ouverts"
T_ERALOP:;	.ASCIZ		"Pilote {#} dj ouvert"
T_ERAOPE:	.ASCIZ		"Pilote {#} utilis"
T_ERNOTO:	.ASCIZ		"Pilote pas ouvert"
T_ERUNCO:	.ASCIZ		"{#Unit} hors service"

T_ERHEAD:	.ASCIZ		"Entte de pilote incorrecte"

T_ERTRSTO:
T_ERTRAV:	.ASCIZ		"Transfert stopp"
T_ERTERM:	.ASCIZ		"Terminateur rencontr"
T_ERDEOF:	.ASCIZ		"Fin de fichier pilote"

T_ERCOMA:
T_ERILLO:	.ASCIZ		"Commande incorrecte"
T_ERTYPC:	.ASCIZ		"Type de pilote incorrect"
T_ERCRED:	.ASCIZ		"Problme de cration"
T_ERNDEV:	.ASCIZ		"Pilote dj install"
T_ERHREAD:	.ASCIZ		"Problme de lecture hard"
T_ERHWRITE:	.ASCIZ		"Problme d'criture hard"

.if		COMPLET
T_ERDHAI:	.ASCIZ		"Adresse de base impaire"
T_ERDHIO:	.ASCIZ		"Offset incorrect"
T_ERDHIN:	.ASCIZ		"Numro incorrect"
T_ERDHIT:	.ASCIZ		"Nom incorrect"
.endif


T_ERNTREL:	.ASCIZ		"Problme temps rel"
T_ERNTLI:
.if		COMPLET
		.ASCIZ		"Limite temps rel atteinte"
.endif
T_ERTIMO:	.ASCIZ		"Temps dpass"
T_ERINTP:	.ASCIZ		"Paramtre incorrect"
T_ERILPT:	.ASCIZ		"Pointeur incorrect"
T_ERPRIO:	.ASCIZ		"Priorit incorrecte"
T_ERMINU:	.ASCIZ		"Smaphore incorrect"

T_ERINTO:	.ASCIZ		"Objet incorrect"

T_ERNOOB:	.asciz		"Objet concern inexistant"

T_ERLIMA:	.asciz		"Limite impose atteinte"

.if		COMPLET
T_ERILMO:	.ASCIZ		"Mode incorrect"
T_ERNORA:	.ASCIZ		"Demande d'accs pas faite"
T_ERNCHI:	.ASCIZ		"Pas une descendance"
T_ERNOIS:	.ASCIZ		"Pas de processus dans smaphore"
T_ERFPOS:	.ASCIZ		"Pas de processus pre"
T_ERPNIS:	.ASCIZ		"Processus pas dans smaphore"
T_ERPNIA:	.ASCIZ		"Processus pas dans l'arbitre"
T_ERPNIB:	.ASCIZ		"Processus pas dans la BAL"
T_ERVEOV:	.ASCIZ		"Limite max de var E atteinte"
T_ERLGTS:	.ASCIZ		"Longueur de tampon donn trop petite"
.endif




T_ERMM:		.ASCIZ		"Problme avec la mmoire de masse {#}"
T_ERMFUNC:	.ASCIZ		"{#} Fonctionnement incorrect"
T_ERMDISK:	.ASCIZ		"Unit {#} absente"
T_ERMOFF:	.ASCIZ		"Unit {#} inactive"
T_ERMRDY:	.ASCIZ		"Unit {#} non prte"

T_ERMUSE:	.ASCIZ		"Problme d'utilisation"
T_ERMOUT:	.ASCIZ		"{#} Accs hors de la mmoire de masse"
T_ERMWRK:	.ASCIZ		"Unit {#} occupe"
T_ERCHMM:
T_ERMDSK:	.ASCIZ		"{#} Changement de disquette"
T_ERMNORD:	.ASCIZ		"{#} Lecture interdite"
T_ERMNPA:	.ASCIZ		"{#} Partition inconnue"
T_ERMPNI:	.ASCIZ		"{#} Paramtres pas initialiss"

T_ERMREAD:	.ASCIZ		"{#} Lecture du disque impossible"

T_ERMWRITE:	.ASCIZ		"{#} Ecriture sur disque impossible"
T_ERMRFI:
T_ERMWFI:	.ASCIZ		"{#} Format incompatible"
T_ERMWPR:	.ASCIZ		"{#Unit} protg en criture"
T_ERMWFO:	.ASCIZ		"{#} Formatage incorrect"

.if		COMPLET
T_ERMRDP:	.ASCIZ		"{#} Piste incorrecte en lecture"
T_ERMRDS:	.asciz		"{#} Secteur incorrect en lecture"
T_ERMRDA:	.ASCIZ		"{#} Problme de data en lecture"
T_ERMRCK:	.ASCIZ		"{#} Problme de check-sum en lecture"
T_ERMWDP:	.ASCIZ		"{#} Piste incorrecte en criture"
T_ERMWDS:	.ASCIZ		"{#} Secteur incorrect en criture"
T_ERMRNF:
T_ERMWNF:	.ASCIZ		"{#} Non format"
T_ERMWDA:	.ASCIZ		"{#} Problme de data en criture"
T_ERMWCK:	.ASCIZ		"{#} Problme de check-sum en criture"
.endif



T_ERLIB:	.ASCIZ		"Problme avec la librairie"
T_ERLFUL:	.ASCIZ		"Librairie trop utilise"
T_ERLNOP:	.ASCIZ		"Librairie pas ouverte"
T_ERLNWD:	.ASCIZ		"Fentre pas utilise"
T_ERLNKY:	.ASCIZ		"Clavier pas utilis"
T_ERLBFU:	.ASCIZ		"Tampon plein"
T_ERLWFU:	.ASCIZ		"Trop de sous-fentres"
T_ERLWUS:	.ASCIZ		"Sous-fentre utilise"
T_ERLWNI:	.ASCIZ		"Sous-fentre inconnue"
T_ERLMFU:	.ASCIZ		"Trop de modules"
T_ERLMNO:	.ASCIZ		"Module pas ouvert"


T_ERDIS:	.ASCIZ		"Problme dans une fentre"
T_ERDIIL:	.ASCIZ		"Caractre ou commande inconnu"
T_ERDIOUT:	.ASCIZ		"Dbordement de la fentre"
T_ERDIROL:	.ASCIZ		"Dcalage de la fentre effectu"
T_ERDIGC:	.ASCIZ		"Gnrateur {de caractres} inexistant"
T_ERDINO:	.ASCIZ		"Plus de fentre approprie"

T_ERDIMA:	.ASCIZ		"Codage d'image incorrect"
T_ERDIND:	.ASCIZ		"Image non dcodable"
.if		COMPLET
T_ERDINC:	.ASCIZ		"Image non codable"
T_ERDIDC:	.ASCIZ		"Image dj code"
T_ERDIDD:	.ASCIZ		"Image non code"
T_ERDIBUF:	.ASCIZ		"Chevauchement de zones"
.endif

T_ERKEY:	.ASCIZ		"Problme avec le clavier"
T_ERKYIL:	.ASCIZ		"Numro de clavier inconnu"
T_ERKYIN:	.ASCIZ		"Clavier inexistant"
T_ERKYAA:	.ASCIZ		"Touche dj assigne"
T_ERKYNA:	.ASCIZ		"Touche pas assigne"
T_ERKYTA:	.ASCIZ		"Trop d'assignations de touches"
T_ERKYFU:	.ASCIZ		"Trop de touches presses"



T_ERPRIN:	.ASCIZ		"Vrifier l'imprimante"
T_ERPCTL:	.ASCIZ		"Commande trop longue"
T_ERPCUK:	.ASCIZ		"Commande inconnue"
T_ERPCIC:	.ASCIZ		"Commande incorrecte"
T_ERPNPR:	.ASCIZ		"Arguments non admis"
T_ERPMPR:	.ASCIZ		"Argument manquant"
T_ERPIWD:	.ASCIZ		"Fentre inexistante"
T_ERPIIL:	.ASCIZ		"Interligne illgal"
T_ERPSTO:	.ASCIZ		"Impression stoppe"


T_ERNETW:	.ASCIZ		"Problme sur le rseau"
T_ERNILP:	.ASCIZ		"Paramtre incorrect"
T_ERNISL:	.ASCIZ		"Longueur segment invalide"
T_ERNPNR:	.ASCIZ		"Port de {destination} pas prt"
T_ERNSTL:	.ASCIZ		"Segment dest. trop petit"
T_ERNHRD:	.ASCIZ		"Problme hardware"
T_ERNHAB:	.ASCIZ		"Hardware absent"
T_ERNHNQ:	.ASCIZ		"Station {?} inexistante"
T_8960:
T_ERNABO:	.ASCIZ		"Transfert avort"
T_ERNMPF:	.ASCIZ		"Plus assez de port"
T_ERNMPS:	.ASCIZ		"Port dj occup"
T_ERNMPC:	.ASCIZ		"Port dj libr"
T_8980:		.ASCIZ		"Reu un mauvais paquet rseau"		; "Receive bad station {}"


.if		COMPLET
T_ERNIPO:	.ASCIZ		"Port inexistant"
T_ERNIAD:	.ASCIZ		"Adresse invalide"
T_ERNISN:	.ASCIZ		"Nombre de segments invalide"
T_ERNISP:	.ASCIZ		"Paramtres exp. incorrects"
T_ERNIPD:	.ASCIZ		"Description paquet incorrect"
T_ERNPWN:	.ASCIZ		"Port dest. n'attend rien"
T_ERNPIA:	.ASCIZ		"Port dest. inactif"
T_ERNPWO:	.ASCIZ		"Port dest. attend autre exp."
T_ERNPNS:	.ASCIZ		"Port dest. pas assez segment"
T_ERNBLO:	.ASCIZ		"Manque un bloc"
T_ERNHMI:	.ASCIZ		"Problme hardware"
T_ERNPEM:	.ASCIZ		"La file du port est vide"
T_ERNPFU:	.ASCIZ		"La file du port est pleine"
T_ERNPUS:	.ASCIZ		"Un port est utilis"
T_8981:		.ASCIZ		"Reu d'un mauvais port"
T_8982:		.ASCIZ		"Reu un numro de bloc inattendu"
T_8983:		.ASCIZ		"Reu un mauvais no de regnration"
T_8984:		.ASCIZ		"Reu un mauvais no de message"
T_8985:		.ASCIZ		"Reu mauvaise entte"
T_8986:		.ASCIZ		"Emission impossible"
T_8987:		.ASCIZ		"Reu mauvais type de paquet"
T_8988:		.ASCIZ		"Interruption manquante"
.endif


T_ERCDEF:	.ASCIZ		"Chane de dfinition illgale"
T_ERCLAB2:	.ASCIZ		"Label inexistant"
T_ERCLAB1:	.ASCIZ		"Label dj dfini"
T_ERCLABI:	.ASCIZ		"Label illgal"
T_ERCIF:	.ASCIZ		"Trop de .IF.."
T_ERCMAC:	.ASCIZ		"Valable uniquement en macro"


.if	ErrSCSI
; SCSI -->

T_8400:		.ASCIZ		"Recouvrement effectu"
T_8410:		.ASCIZ		"Unit SCSI non prte"
T_8420:		.ASCIZ		"Problme avec le mdia"
T_8430:		.ASCIZ		"Problme avec le matriel"
T_8440:		.ASCIZ		"Requte illgale"
T_8441:		.ASCIZ		"Trop de paramtres"
T_8442:		.ASCIZ		"Commande illgale"
T_8450:		.ASCIZ							"Illegal Request"
T_8460:		.ASCIZ		"Signal attention activ"

T_8470:		.ASCIZ		"Donnes protges"

T_8480:		.ASCIZ		"Commande interrompue"

T_8490:		.ASCIZ		"Problme de comparaison"

.IF		COMPLET
T_8401:		.ASCIZ		"Recouvrement effectu par relecture"
T_8402:		.ASCIZ		"Recouvrement effectu par correction"
T_8403:		.ASCIZ		"Erreur rcuprable (0 bit)"
T_8404:		.ASCIZ		"Erreur rcuprable (1 bit)"
T_8405:		.ASCIZ		"Erreur rcuprable (2 bits)"
T_8406:		.ASCIZ		"Erreur rcuprable (3 bits)"
T_8407:		.ASCIZ		"Erreur rcuprable (4 bits)"
T_8408:		.ASCIZ		"Erreur rcuprable (5 bits)"
T_8409:		.ASCIZ		"Erreur rcuprable (6 bits)"
T_840A:		.ASCIZ		"Erreur rcuprable (7 bits)"
T_840B:		.ASCIZ		"Erreur rcuprable (8 bits)"
T_840C:		.ASCIZ		"Erreur rcuprable (9 bits)"
T_840D:		.ASCIZ		"Erreur rcuprable (10 bits)"
T_840E:		.ASCIZ		"Erreur rcuprable (11 bits)"

T_8411:		.ASCIZ		"Cible non prte"
T_8412:		.ASCIZ		"Cible non slectionne"

T_8421:		.ASCIZ		"Recouvrement impossible en lecture"
T_8422:		.ASCIZ		"Pas de marque d'adresse (ID)"
T_8423:		.ASCIZ		"Pas de marque d'adresse (donnes)"
T_8424:		.ASCIZ		"Enregistrement pas trouv"
T_8425:		.ASCIZ		"Positionnement incorrect"
T_8426:		.ASCIZ		"Recouvrement marque d'adresse"
T_8427:		.ASCIZ		"Liste des blocs dfectueux incorrecte"
T_8428:		.ASCIZ		"Liste primaire pas trouve"
T_8429:		.ASCIZ		"Format absent"
T_842A:		.ASCIZ		"Plus de secteur en rserve"

T_8431:		.ASCIZ		"Pas de signal d'index / secteur"
T_8432:		.ASCIZ		"Positionnement pas termin"
T_8433:		.ASCIZ		"Erreur d'criture"
T_8434:		.ASCIZ		"Piste zro pas trouve"
T_8435:		.ASCIZ		"Units multiples slectionnes"
T_8436:		.ASCIZ		"ID CRC ou ECC incorrect"
T_8437:		.ASCIZ		"Positionnement incorrect"
T_8438:		.ASCIZ		"RAM de la cible dfectueuse"
T_8439:		.ASCIZ		"Problme lors du test de L'ECC"
T_843A:		.ASCIZ		"Problme lors de la mise sous tension"
T_843B:		.ASCIZ		"Message rejet"
T_843C:		.ASCIZ		"Problme avec le matriel SCSI"
T_843D:		.ASCIZ		"Problme lors de la slection/reslection"

T_8443:		.ASCIZ		"Adresse logique de bloc illgale"
T_8444:		.ASCIZ		"Fonction illgale pour ce type d'unit"
T_8445:		.ASCIZ		"Paramtre illgal dans le CDB"
T_8446:		.ASCIZ		"Numro d'unit logique incorrect"
T_8447:		.ASCIZ		"Champ illgal dans la liste des paramtres"
T_8448:		.ASCIZ					"Track 0 Misadjust Error"
T_8449:		.ASCIZ					"Crash Stop Check Error"
T_844A:		.ASCIZ					"No Hall Transition Check Error"
T_844B:		.ASCIZ					"Unexpected Interrupt"

T_8451:		.ASCIZ					"Parameter Overrun"
T_8452:		.ASCIZ					"Invalid Command Operation Code"
T_8453:		.ASCIZ					"Invalid Logical Block Adress"
T_8454:		.ASCIZ					"Illgal function for device type"
T_8455:		.ASCIZ					"Illegal field in CDB"
T_8456:		.ASCIZ					"Invalid LUN"
T_8457:		.ASCIZ					"Invalid field Parameter List"

T_8461:		.ASCIZ		"Disque chang depuis la dernire commande"

.endif
.endif

; Ressources ->

T_ERrsIL:	.asciz		"Accs ressource incorrect"
.if	COMPLET
T_ERrsILMOD:	.asciz		"Mode illgal"
T_ERrsILNUM:	.asciz		"Numro de ressource incorrect"
T_ERrsILTYP:	.asciz		"Type de ressource incorrect"
T_ERrsILKND:	.asciz		"Genre de ressource incorrect"
T_ERrsILSIZ:	.asciz		"Taille de ressource incorrect"
T_ERrsILLAB:	.asciz		"Label ressource incorrect"
T_ERrsILSUBR:	.asciz		"Sous-ressource incorrecte"
T_ERrsILCAN:	.asciz		"Canal incorrect"
T_ERrsILCTR:	.asciz		"Commande incorrecte"
T_ERrsILKEY:	.asciz		"Touche incorrecte"
T_ERrsILOP:	.asciz		"Operation illgale"
T_ERrsILFSTO:	.asciz		"Format de stockage illegal"
.endif

T_ERrsFILE:	.asciz		"Erreur de fichier"
T_ERrsREV:	.asciz		"Rvision incompatible"
T_ERrsNOSUBR:	.asciz		"Sous-ressources non implmentes"
T_ERrsNORES:	.asciz		"Pas de ressource dans fichier.RS"
T_ERrsNORESCODE:.asciz		"Pas de ressource dans fichier.CODE"
T_ERrsBADFILE:	.asciz		"Fichier ressource incorrect"

T_ERrsMISC:	.asciz		"Erreur ressources"
.if	COMPLET
T_ERrsSYSTO:	.asciz		"Systme trop vieux"
T_ERrsKILLED:	.asciz		"Entit dtruite"
T_ERrsTYPAE:	.asciz		"Type dj existant"
T_ERrsTOOMGIV:	.asciz		"Trop de RES_GIVE"
T_ERrsUSED:	.asciz		"Ressource en utilisation"
.endif

T_ERrsEXEC:	.asciz		"Erreur d'execution"
.if	COMPLET
T_ERrsBADHARDW:	.asciz		"Mauvais hardware"
T_ERrsCALLDNE:	.asciz		"Appel n'existe pas"
T_ERrsDECACHE:	.asciz		"Dcache impossible"
.endif


T_B000:		.ASCIZ		"Simulateur dfectueux"
T_B001:		.ASCIZ		"Simulateur absent"
T_B002:		.ASCIZ		"Machine non supporte"

.endif		; franais


.if	LANGUE.EQ.AN

T_ERSYS:	.ASCIZ		"System error"			;	"Problme systme"
T_ERFOS:	.ASCIZ		"File error"			;	"Problme avec un fichier"
T_ERFRES:	.ASCIZ		"Reserved extension"		;	"Extension rserve"
T_ERFUNI:	.ASCIZ		"Unit name: expected"		;	"Nom d'unit: attendu"
T_ERFILL:	.ASCIZ		"Illegal file name"		;	"Nom de fichier illgal"
T_ERILOP:	.ASCIZ		"Illegal operation"		;	"Opration illgale"
T_EROUTF:	.ASCIZ		"Out of file"			;	"Hors du fichier"
T_ERFDNE:	.ASCIZ		"{File} does not exist"		;	"{Fichier} n'existe pas"
T_ERFAEX:	.ASCIZ		"{File} already exist"		;	"{Fichier} existe dj"
T_ERILCH:	.ASCIZ		"Illegal channel"		;	"Canal incorrect"      
T_ERFUSE:	.ASCIZ		"{File} in use"			;	"{Fichier} utilis"
T_ERFNOP:	.ASCIZ		"{File} not open"		;	"{Fichier} dj ferm"
T_ERUNNI:	.ASCIZ		"{Unit} not initialised"	;	"Unit pas initialise"
T_ERUUSE:	.ASCIZ		"Unit {} in use"		;	"Unit utilise"
T_ERUTYP:	.ASCIZ		"Illegal unit type"		;	"Type d'unit incorrect"
T_ERDDNE:	.ASCIZ		"{Directory} not found"		;	"Dossier {?} pas trouv"
T_ERITYP:	.ASCIZ		"Illegal install type"		;	"Type d'installation incorrect"
T_ERNREL:	.ASCIZ		"RELEASE forget"		;	"RELEASE pas fait"
T_ERNENT:	.ASCIZ		"ENTER make by an other programm";	"ENTER fait par un autre programme"
T_ERFILG:	.ASCIZ							"{Fichier} trop court!"
T_ERXCHANGE:	.ASCIZ		"Disquette sortie du lecteur"

T_ERFULL:	.ASCIZ		"Full"				;	"Plein"
T_ERDKFU:	.ASCIZ		"Disk full"			;	"Disque plein"
.if	0
T_ERFTFU:	.ASCIZ		"Too many opened disk files"	;	"Trop de fichiers disques ouverts"
T_ERSTFU:	.ASCIZ		"Too many opened local files"	;	"Trop de fichiers locaux ouverts"
T_ERLIFU:	.ASCIZ		"Too many assign"		;	"Trop d'assignations"
T_ERTPFU:	.ASCIZ		"Too many used drivers"		;	"Trop de drivers utiliss"
T_ERPMFU:	.ASCIZ		"Too many executed programm"	;	"Trop de programmes excuts"
T_ERUTFU:
T_ERDTFU:	.ASCIZ		"Too many initialised directory";	"Trop de dossiers initialiss"
T_ERVTFU:	.ASCIZ		"Too many virtual install"	;	"Trop d'installations virtuelles"
T_ERNTFU:	.ASCIZ		"Too many opened network's files";	"Trop de fichiers rseau ouverts"
.endif
T_ERBUFU:	.ASCIZ		"Analyse buffer full"		;	"Buffer d'analyse plein"
T_ERMSFU:	.ASCIZ		"Memory full on server"		;	"Mmoire du serveur pleine"

T_ERATT:	.ASCIZ		"{File} protected"		;	"{Fichier} protg"
T_ERATTE:	.ASCIZ		"Open exclusif protected"	;	"Ouverture exclusive impossible"
T_ERATTM:	.ASCIZ		"Open multiple protected"	;	"Ouverture multiple impossible"
T_ERATTR:	.ASCIZ		"Read protected"		;	"Lecture impossible"
T_ERATTW:	.ASCIZ		"Write protected"		;	"Ecriture impossible"
T_ERATTY:	.ASCIZ		"Reset protected"		;	"Fermeture impossible"
T_ERATTS:	.ASCIZ		"Spos protected"		;	"Spos impossible"
T_ERATTG:	.ASCIZ		"Gpos protected"		;	"Gpos impossible"
T_ERATTD:	.ASCIZ		"{} Delete protected"		;	"{Fichier} indestructible"
T_ERATTC:	.ASCIZ		"Rename protected"		;	"Changment de nom impossible"
T_ERATTA:	.ASCIZ		"Chatr protected"		;	"Changement des attributs impossible"
T_ERATTZ:	.ASCIZ		"Clear protected"		;	"Remise  zro impossible"
T_ERATTX:	.ASCIZ		"{} Execute protected"		;	"{Fichier} pas excutable"
T_ERATTN:	.ASCIZ		"{} Network acces protected"	;	"{} accs rseau protg"
T_ERFCODE:	.ASCIZ		"Looked file {}"		;	"{Fichier} verrouill"
T_ERNSUNI:	.ASCIZ							"?MOVE impossible"

T_ERBINA:	.ASCIZ		"Binary incorrect"		;	"Binaire incorrect"
T_ERBICHK:	.ASCIZ		"Check sum incorrect"		;	"Somme de contrle incorrecte"
T_ERBNRE:	.ASCIZ							"Binaire non relogeable"

T_ERPSYN:
T_ERLSYN:
T_ERSYNT:	.ASCIZ		"Syntaxe error"			;	"Syntaxe incorrecte"
T_ERILUN:	.ASCIZ		"Illegal unit"			;	"Unit incorrecte"
T_ERTOLO:	.ASCIZ		"Name too long"			;	"Nom trop long"
T_ERFFIL:
T_ERTOCO:	.ASCIZ		"Name not found"		;	"Nom inexistant"
T_ERILCA:	.ASCIZ		"Illegal character"		;	"Caractre illgal"
T_ERILAT:	.ASCIZ		"Illegal attribut"		;	"Attribut illgal"
T_ERUCALL:	.ASCIZ							"RCVNET serveur trop ancien !"
T_ERNSERV:	.ASCIZ		"Network master not server"	;	"Station distante non serveur"
T_ERBLOQ:	.ASCIZ							"Machine arrte"

.if		COMPLET
T_ERNSAD:	.ASCIZ		"No starting address"		;	"Pas d'adresse de start"
T_ERILAD:	.ASCIZ		"Illegal address"		;	"Adresse incorrecte"
T_ERNOHD:	.ASCIZ							"entte binaire pas en mmoire"
T_EREXLO:	.ASCIZ							"Extension trop longue"
T_ERIFNR:
T_ERNOOP:	.ASCIZ							"Plus d'option"
T_ERLDIMA:	.ASCIZ							"Image gnrique charge"
.endif


T_ERGESM:	.ASCIZ		"Memory error"			;	"Problme mmoire"
T_ERMHKO:	.ASCIZ		"Hard memory ko"		;	"Mmoire dfectueuse"
T_ERIMEP:	.ASCIZ		"Illegal memory parametre"	;	"Paramtre mmoire illgal"
T_ERMELG:	.ASCIZ		"Illegal memory length"		;	"Longueur mmoire fausse"
T_ERMFUL:	.ASCIZ		"Memory full"			;	"Mmoire pleine"

.if		COMPLET
T_ERMEMKO:	.ASCIZ		"Memory chip ko"		;	"Circuit mmoire dfectueux"
T_ERMCTYP:	.ASCIZ		"Incorrect entity memory"	;	"Entit mmoire incorrecte"
T_ERIPRS:	.ASCIZ		"Request memory too big"	;	"Fraction mmoire trop grande"
T_ERILIMI:	.ASCIZ		"Illegal memory boundary"	;	"Limite mmoire incorrecte"
T_ERIADR:	.ASCIZ		"Illegal memory address"	;	"Adresse mmoire incorrecte"
T_ERPTMEM:	.ASCIZ		"Illegal memory pointer"	;	"Pointeur mmoire incorrect"
T_ERMPTYP:	.ASCIZ		"Illegal processus type"	;	"Type processus interdit"
T_ERNLEN:	.ASCIZ		"Memory length equal to zero"	;	"Longueur mmoire nulle"
T_ERNEMEM:	.ASCIZ		"Not enough memory"		;	"Pas assez de mmoire"
T_ERMOCC:	.ASCIZ		"Memory busy"			;	"Mmoire dj occupe"
.endif


T_ERBIOS:	.ASCIZ		"BIOS error"			;	"Problme BIOS"
T_ERIDP:	.ASCIZ		"Illegal parametre"		;	"Paramtre illgal"
T_ERIRDL:
T_ERIRLG:	.ASCIZ		"Illegal length"		;	"Longueur illgale"

T_ERDPR:	.ASCIZ		"Driver protected"		;	"Driver protg"
T_ERRDPR:	.ASCIZ		"Driver read protected"		;	"Driver protg en lecture"
T_ERWRPR:	.ASCIZ		"Driver write protected"	;	"Driver protg en criture"
T_ERKLPR:	.ASCIZ		"Driver delele protected"	;	"Driver indestructible"

T_ERDNTF:	.ASCIZ		"Driver not found"		;	"Driver introuvable"
T_ERIDEV:	.ASCIZ		"Driver number not found"	;	"Numro de driver inconnu"
T_ERINAM:	.ASCIZ		"Driver name not found"		;	"Nom de driver inconnu"

T_ERDOP:	.ASCIZ		"Open error"			;	"Problme d'ouverture"
T_EROPMX:	.ASCIZ		"Too many driver opened"	;	"Trop de drivers ouverts"
T_ERAOPE:
T_ERALOP:	.ASCIZ		"Driver {} already opened"	;	"Driver dj ouvert"
T_ERNOTO:	.ASCIZ		"Driver not open"		;	"Driver pas ouvert"
T_ERUNCO:	.ASCIZ		"{Unit} not connected"		;	"Unit pas connecte"

T_ERHEAD:	.ASCIZ		"Illegal driver header"		;	"Entte de driver incorrecte"
T_ERTRSTO:
T_ERTRAV:	.ASCIZ		"Transfert aborted"		;	"Transfert stopp"
T_ERTERM:	.ASCIZ		"Ended meeting"			;	"Terminateur rencontr"
T_ERDEOF:	.ASCIZ		"End of driver file"		;	"Fin de fichier driver"

T_ERCOMA:
T_ERILLO:	.ASCIZ		"Illegal command"		;	"Commande incorrecte"
T_ERTYPC:	.ASCIZ		"Illegal type driver"		;	"Type de driver incorrect"
T_ERCRED:	.ASCIZ		"Create error"			;	"Problme de cration"
T_ERNDEV:	.ASCIZ		"Driver already installed"	;	"Driver dj install"
T_ERHREAD:	.ASCIZ		"Hard read error"		;	"Problme de lecture hard"
T_ERHWRITE:	.ASCIZ		"Hard write error"		;	"Problme d'criture hard"

.if		COMPLET
T_ERDHAI:	.ASCIZ		"Base address odd"		;	"Adresse de base impaire"
T_ERDHIO:	.ASCIZ		"Illegal offset"		;	"Offset incorrect"
T_ERDHIN:	.ASCIZ		"Illegal number"		;	"Numro incorrect"
T_ERDHIT:	.ASCIZ		"Illegal name"			;	"Nom incorrect"
.endif




T_ERNTREL:	.ASCIZ		"Real time error"		;	"Problme temps rel"
T_ERNTLI:
.if		COMPLET
		.ASCIZ		"Real time limit reached"	;	"Limite	temps rel atteinte"
.endif
T_ERTIMO:	.ASCIZ		"Time out"			;	"Temps dpass"
T_ERINTP:	.ASCIZ		"Illegal parametre"		;	"Paramtre incorrect"
T_ERILPT:	.ASCIZ		"Illegal pointer"		;	"Pointeur incorrect"
T_ERPRIO:	.ASCIZ		"Illegal priority"		;	"Priorit incorrecte"
T_ERMINU:	.ASCIZ		"Illegal semaphore"		;	"Smaphore incorrect"

T_ERINTO:	.ASCIZ		"Illegal object"		;	"Objet incorrect"

T_ERNOOB:	.ASCIZ		"Objet not found"		;	"Objet concern inexistant"

T_ERLIMA:	.ASCIZ		"Limite reched"			;	"Limite impose atteinte"

.if		COMPLET
T_ERILMO:	.ASCIZ		"Illegal mode"			;	"Mode incorrect"
T_ERNORA:	.ASCIZ		"Acces not required"		;	"Demande d'accs pas faite"
T_ERNCHI:	.ASCIZ		"Not a son"			;	"Pas une descendance"

T_ERNOIS:	.ASCIZ		"No process in semaphore"	;	"Pas de processus dans smaphore"
T_ERFPOS:	.ASCIZ		"No father process"		;	"Pas de processus pre"
T_ERPNIS:	.ASCIZ		"Process not in semaphore"	;	"Processus pas dans smaphore"
T_ERPNIA:	.ASCIZ		"Process not in arbiter"	;	"Processus pas dans l'arbitre"
T_ERPNIB:	.ASCIZ		"Process not in BAL"		;	"Processus pas dans la BAL"

T_ERVEOV:	.ASCIZ		"May of E resched"		;	"Limite max de var E atteinte"
T_ERLGTS:	.ASCIZ		"Lang too smale"		;	"Longueur de buffer donn trop petite"
.endif




T_ERMM:		.ASCIZ		"Mass memory {} error"		;	"Problme avec la mmoire de masse"
T_ERMFUNC:	.ASCIZ		"{} Malfunction error"		;	"Fonctionnement incorrect"
T_ERMDISK:	.ASCIZ		"Unit {} absent"		;	"Unit absente"
T_ERMOFF:	.ASCIZ		"Unit {} inactive"		;	"Unit inactive"
T_ERMRDY:	.ASCIZ		"Unit {} not ready"		;	"Unit non prte"

T_ERMUSE:	.ASCIZ		"{} Incompatible floppy-disk"	;	"Problme d'utilisation"
T_ERMOUT:	.ASCIZ		"{} Out of mass memory"		;	"Accs hors de la mmoire de masse"
T_ERMWRK:	.ASCIZ		"Unit {} busy"			;	"Unit occupe"
T_ERCHMM:
T_ERMDSK:	.ASCIZ		"{} Disk changed"		;	"Changement de disquette"
T_ERMNORD:	.ASCIZ		"{} Read verboted"		;	"Lecture interdite"
T_ERMNPA:	.ASCIZ		"{} Unknown partition"		;	"Partition inconnue"
T_ERMPNI:	.ASCIZ		"{} Parameters not init"	;	"Paramtres pas initialiss"

T_ERMREAD:	.ASCIZ		"{} Read error"			;	"Lecture du disque impossible"

T_ERMWRITE:	.ASCIZ		"{} Write error"		;	"Ecriture sur disque impossible"

T_ERMRFI:
T_ERMWFI:	.ASCIZ		"{} Incompatible format"	;	"Format incompatible"
T_ERMWPR:	.ASCIZ		"Write protected {floppy disk}"	;	"Unit protge en criture"
T_ERMWFO:	.ASCIZ		"{} Format error"		;	"Formatage incorrect"

.if		COMPLET
T_ERMRDP:	.ASCIZ		"{} Illegal read track"		;	"Piste incorrecte en lecture"
T_ERMRDS:	.ASCIZ		"{} Illegal read sector"	;	"Secteur incorrect en lecture"
T_ERMRDA:	.ASCIZ		"{} Data read error"		;	"Problme de data en lecture"
T_ERMRCK:	.ASCIZ		"{} Check-sum read error"	;	"Problme de check-sum en lecture"

T_ERMWDP:	.ASCIZ		"{} Illegal write track"	;	"Piste incorrecte en criture"
T_ERMWDS:	.ASCIZ		"{} Illegal write sector"	;	"Secteur incorrect en criture"
T_ERMRNF:
T_ERMWNF:	.ASCIZ		"{} No format"			;	"Non format"
T_ERMWDA:	.ASCIZ		"{} Data write error"		;	"Problme de data en criture"
T_ERMWCK:	.ASCIZ		"{} Check-sum write error"	;	"Problme de check-sum en criture"
.endif


T_ERLIB:	.ASCIZ		"Library error"			;	"Problme avec la librairie"
T_ERLFUL:	.ASCIZ		"Library too many used"		;	"Librairie trop utilise"
T_ERLNOP:	.ASCIZ		"Library not open"		;	"Librairie pas ouverte"
T_ERLNWD:	.ASCIZ		"Window not used"		;	"Fentre pas utilise"
T_ERLNKY:	.ASCIZ		"Keyboard not used"		;	"Clavier pas utilis"
T_ERLBFU:	.ASCIZ		"Buffer full"			;	"Buffer plein"
T_ERLWFU:	.ASCIZ		"Too many sub-window"		;	"Trop de sous-fentres"
T_ERLWUS:	.ASCIZ		"Sub-window used"		;	"Sous-fentre utilise"
T_ERLWNI:	.ASCIZ		"Unknown sub-window"		;	"Sous-fentre inconnue"
T_ERLMFU:	.ASCIZ		"Too many modules"		;	"Trop de modules"
T_ERLMNO:	.ASCIZ		"Module not opened"		;	"Module pas ouvert"


T_ERDIS:	.ASCIZ		"Window error"			;	"Problme dans une fentre"
T_ERDIIL:	.ASCIZ		"Illegal character or command"	;	"Caractre ou commande inconnu"
T_ERDIOUT:	.ASCIZ		"Out of window"			;	"Dbordement de la fentre"
T_ERDIROL:	.ASCIZ		"Scroll done"			;	"Dcalage de la fentre effectu"
T_ERDIGC:	.ASCIZ		"Unknow font {}"		;	"Gnrateur {de caractres} inexistant"
T_ERDINO:	.ASCIZ							"Plus de fentre approprie"

T_ERDIMA:	.ASCIZ		"Incorrect compress pickture"	;	"Codage d'image incorrect"
T_ERDIND:	.ASCIZ		"Picture not uncompressable"	;	"Image non dcodable"
.if		COMPLET
T_ERDINC:	.ASCIZ							"Image non codable"
T_ERDIDC:	.ASCIZ		"Picture already compressed"	;	"Image dj code"
T_ERDIDD:	.ASCIZ							"Image non code"
T_ERDIBUF:	.ASCIZ							"Chevauchement de zones"
.endif

T_ERKEY:	.ASCIZ		"Keyboard error"		;	"Problme avec le clavier"
T_ERKYIL:	.ASCIZ		"Unknown keyboard number"	;	"Numro de clavier inconnu"
T_ERKYIN:	.ASCIZ		"Non-existant keyboard"		;	"Clavier inexistant"
T_ERKYAA:	.ASCIZ		"Key already assign"		;	"Touche dj assigne"
T_ERKYNA:	.ASCIZ		"Key not assign"		;	"Touche pas assigne"
T_ERKYTA:	.ASCIZ		"Too many key's assign"		;	"Trop d'assignations de touches"
T_ERKYFU:	.ASCIZ		"Too many strike keys"		;	"Trop de touches presses"



T_ERPRIN:	.ASCIZ		"Printer error"			;	"Vrifier l'imprimante"
T_ERPCTL:	.ASCIZ		"Command too long"		;	"Commande trop longue"
T_ERPCUK:	.ASCIZ		"Unknown command"		;	"Commande inconnue"
T_ERPCIC:	.ASCIZ		"Illegal code"			;	"Commande incorrecte"
T_ERPNPR:	.ASCIZ		"Argument not assumed"		;	"Arguments non admis"
T_ERPMPR:	.ASCIZ		"Argument missing"		;	"Argument manquant"
T_ERPIWD:	.ASCIZ		"Unknown window"		;	"Fentre inexistante"
T_ERPIIL:	.ASCIZ		"Illegal interline"		;	"Interligne illgal"
T_ERPSTO:	.ASCIZ							"Impression stoppe"


T_ERNETW:	.ASCIZ		"Network error"			;	"Problme sur le rseau"
T_ERNILP:	.ASCIZ		"Illegal parametre"		;	"Paramtre incorrect"
T_ERNISL:	.ASCIZ		"Invalid segment length"	;	"Longueur segment invalide"
T_ERNPNR:	.ASCIZ		"{Destination} port inactiv"	;	"Port de {destination} pas prt"
T_ERNSTL:	.ASCIZ		"Destination segment too little";	"Segment dest. trop petit"
T_ERNHRD:	.ASCIZ		"Hardware error"		;	"Problme hardware"
T_ERNHAB:	.ASCIZ		"Hardware is missing"		;	"Hardware absent"
T_ERNHNQ:	.ASCIZ		"Station {} does not exist"	;	"Station {?} inexistante"
T_8960:
T_ERNABO:	.ASCIZ		"Avorted trans."		;	"Transfert avort"

T_ERNMPF:	.ASCIZ		"No more port"			;	"Plus assez de port"
T_ERNMPS:	.ASCIZ		"Port already used"		;	"Port dj occup"
T_ERNMPC:	.ASCIZ		"Port already free"		;	"Port dj libr"
T_8980:		.ASCIZ		"Receive bad station {}"

.if		COMPLET
T_ERNIPO:	.ASCIZ		"Unknown port"			;	"Port inexistant"
T_ERNIAD:	.ASCIZ		"Invalid adress"		;	"Adresse invalide"
T_ERNISN:	.ASCIZ		"Invalid segment number"	;	"Nombre de segments invalide"
T_ERNISP:	.ASCIZ		"Invalid parameter exp."	;	"Paramtres exp. incorrects"
T_ERNIPD:	.ASCIZ		"Incorrect packet description"	;	"Description paquet incorrect"

T_ERNPWN:	.ASCIZ		"Dest. port wait nothing"	;	"Port dest. n'attend rien"
T_ERNPIA:	.ASCIZ		"Dest. port not active"		;	"Port dest. inactif"
T_ERNPWO:	.ASCIZ		"Dest. port wait from other exp.";	"Port dest. attend autre exp."
T_ERNPNS:	.ASCIZ		"Dest. port as not enough segments";	"Port dest. pas assez segment"
T_ERNBLO:	.ASCIZ		"A bloc is missing"		;	"Manque un bloc"

T_ERNHMI:	.ASCIZ		"Hardware error"		;	"Problme hardware"

T_ERNPEM:	.ASCIZ		"Empty port list"		;	"La file du port est vide"
T_ERNPFU:	.ASCIZ		"Full port list"		;	"La file du port est pleine"
T_ERNPUS:	.ASCIZ		"Port in use"			;	"Un port est en utilisation"
T_8981:		.ASCIZ		"Receive bad port"
T_8982:		.ASCIZ		"Receive bad bloc"
T_8983:		.ASCIZ		"Receive bad regnration number"
T_8984:		.ASCIZ		"Receive bad Message number"
T_8985:		.ASCIZ		"Receive bad entte"
T_8986:		.ASCIZ		"Send impossible"
.endif


T_ERCDEF:	.ASCIZ		"Illegal definition string"	; "Chane de dfinition illgale"
T_ERCLAB2:	.ASCIZ		"Label does not existe"		; "Label inexistant"
T_ERCLAB1:	.ASCIZ		"Label already existe"		; "Label dj dfini"
T_ERCLABI:	.ASCIZ		"Illegal label"			; "Label illgal"
T_ERCIF:	.ASCIZ		"Too many .IF..."		; "Trop de .IF.."
T_ERCMAC:	.ASCIZ		"Only possible in macro file"	; "Valable uniquement en macro"


T_8400:		.ASCIZ		"Recovered Error"
T_8410:		.ASCIZ		"Not Ready"
T_8420:		.ASCIZ		"Medium Error"
T_8430:		.ASCIZ		"Hardware Error"
T_8440:		.ASCIZ		"Data Buffer Check"
T_8441:		.ASCIZ		"REQ/ACK Check"
T_8442:		.ASCIZ		"Spin Stability Check"
T_8450:		.ASCIZ		"Illegal Request"
T_8460:		.ASCIZ		"Unit Attention"
T_8470:		.ASCIZ		"Data Protect"
T_8480:		.ASCIZ		"Aborted Command"
T_8490:		.ASCIZ		"Miscompare"

; Ressources ->

T_ERrsIL:	.asciz		"illegal..."
.if	COMPLET
T_ERrsILMOD:	.asciz		"illegal mode"
T_ERrsILNUM:	.asciz		"illegal ressource number"
T_ERrsILTYP:	.asciz		"illegal ressource type"
T_ERrsILKND:	.asciz		"illegal ressource kind"
T_ERrsILSIZ:	.asciz		"illegal ressource size"
T_ERrsILLAB:	.asciz		"illegal ressource label"
T_ERrsILSUBR:	.asciz		"illegal subressource"
T_ERrsILCAN:	.asciz		"illegal channel"
T_ERrsILCTR:	.asciz		"illegal control command"
T_ERrsILKEY:	.asciz		"illegal key"
T_ERrsILOP:	.asciz		"illegal operation"
T_ERrsILFSTO:	.asciz		"illegal format de stockage"
.endif

T_ERrsFILE:	.asciz		"file ERror..."
T_ERrsREV:	.asciz		"revision incompatibility"
T_ERrsNOSUBR:	.asciz		"no subressources implemented"
T_ERrsNORES:	.asciz		"no ressources in RS file"
T_ERrsNORESCODE:.asciz		"no ressources in CODE file"
T_ERrsBADFILE:	.asciz		"bad ressource file"

T_ERrsMISC:	.asciz		"miscellanous error..."
.if	COMPLET
T_ERrsSYSTO:	.asciz		"system too old"
T_ERrsKILLED:	.asciz		"entity killed"
T_ERrsTYPAE:	.asciz		"type already exists"
T_ERrsTOOMGIV:	.asciz		"too many RES_GIVE"
T_ERrsUSED:	.asciz		"ressource already used"
.endif

T_ERrsEXEC:	.asciz		"execution error..."
.if	COMPLET
T_ERrsBADHARDW:	.asciz		"bad hardware"
T_ERrsCALLDNE:	.asciz		"call does not exist"
T_ERrsDECACHE:	.asciz		"decache not possible"
.endif

T_B000:		.ASCIZ		"Simulateur dfectueux"
T_B001:		.ASCIZ		"Simulateur absent"
T_B002:		.ASCIZ		"Machine non supporte"


.if		COMPLET
T_8401:		.ASCIZ		"Recovered Read data with drive's Read retries"
T_8402:		.ASCIZ		"Recovered Read data with drive's ECC correction"
T_8403:		.ASCIZ		"Correctable ECC error,  number of bits correctable: 0"
T_8404:		.ASCIZ		"Correctable ECC error,  number of bits correctable: 1"
T_8405:		.ASCIZ		"Correctable ECC error,  number of bits correctable: 2"
T_8406:		.ASCIZ		"Correctable ECC error,  number of bits correctable: 3"
T_8407:		.ASCIZ		"Correctable ECC error,  number of bits correctable: 4"
T_8408:		.ASCIZ		"Correctable ECC error,  number of bits correctable: 5"
T_8409:		.ASCIZ		"Correctable ECC error,  number of bits correctable: 6"
T_840A:		.ASCIZ		"Correctable ECC error,  number of bits correctable: 7"
T_840B:		.ASCIZ		"Correctable ECC error,  number of bits correctable: 8"
T_840C:		.ASCIZ		"Correctable ECC error,  number of bits correctable: 9"
T_840D:		.ASCIZ		"Correctable ECC error,  number of bits correctable: 10"
T_840E:		.ASCIZ		"Correctable ECC error,  number of bits correctable: 11"

T_8411:		.ASCIZ		"Drive Not Ready"
T_8412:		.ASCIZ		"Drive Not Selected"

T_8421:		.ASCIZ		"Unrecovered Read error of data blocks"
T_8422:		.ASCIZ		"No Addres Mark found in ID field"
T_8423:		.ASCIZ		"No Adress Mark Found in Data field"
T_8424:		.ASCIZ		"No record found"
T_8425:		.ASCIZ		"Seek Error"
T_8426:		.ASCIZ		"Recovered Data Adress Mark"
T_8427:		.ASCIZ		"Defect List Error"
T_8428:		.ASCIZ		"Primary Defect List not found"
T_8429:		.ASCIZ		"Format Failed"
T_842A:		.ASCIZ		"No Defect Spare Location Available"

T_8431:		.ASCIZ		"No Index / Sector signal"
T_8432:		.ASCIZ		"No Seek Complete"
T_8433:		.ASCIZ		"Write Fault"
T_8434:		.ASCIZ		"No track zero found"
T_8435:		.ASCIZ		"Multiple Drive Selected"
T_8436:		.ASCIZ		"ID CRC or ECC error"
T_8437:		.ASCIZ		"Seek Error"
T_8438:		.ASCIZ		"RAM failure"
T_8439:		.ASCIZ		"ECC diagnostic failure"
T_843A:		.ASCIZ		"Power On Failure"
T_843B:		.ASCIZ		"Message Reject Error"
T_843C:		.ASCIZ		"SCSI Hardware/Firmware Error"
T_843D:		.ASCIZ		"Select/Reselect failed"
T_843E:		.ASCIZ		"Adaptec AIC 010 Failure"
T_843F:		.ASCIZ		"Checksum Check"

T_8443:		.ASCIZ		"L.T. 3600 RPM"
T_8444:		.ASCIZ		"Spin Check"
T_8445:		.ASCIZ		"0.05% Spin Check"
T_8446:		.ASCIZ		"Unable to Cover Rezero Sensor"
T_8447:		.ASCIZ		"Unable to Uncover Rezero Sensor"
T_8448:		.ASCIZ		"Track 0 Misadjust Error"
T_8449:		.ASCIZ		"Crash Stop Check Error"
T_844A:		.ASCIZ		"No Hall Transition Check Error"
T_844B:		.ASCIZ		"Unexpected Interrupt"

T_8451:		.ASCIZ		"Parameter Overrun"
T_8452:		.ASCIZ		"Invalid Command Operation Code"
T_8453:		.ASCIZ		"Invalid Logical Block Adress"
T_8454:		.ASCIZ		"Illegal function for device type"
T_8455:		.ASCIZ		"Illegal field in CDB"
T_8456:		.ASCIZ		"Invalid LUN"
T_8457:		.ASCIZ		"Invalid field Parameter List"
.endif

.endif		; anglais


.if	LANGUE.EQ.AL

T_ERSYS:	.ASCIZ		"Systemfehler"			;	"Problme systme"
T_ERFOS:	.ASCIZ		"Dateifehler"			;	"Problme avec un fichier"
T_ERFRES:	.ASCIZ							"Extension rserve"
T_ERFUNI:	.ASCIZ							"Nom d'unit: attendu"
T_ERFILL:	.ASCIZ							"Nom de fichier illgal"
T_ERILOP:	.ASCIZ		"Illegale Operation"		;	"Opration illgale"
T_EROUTF:	.ASCIZ		"Dateigrenze berschritten"	;	"Hors du fichier"
T_ERFDNE:	.ASCIZ		"{Datei} exisitiert nicht"	;	"{Fichier} n'existe pas"
T_ERFAEX:	.ASCIZ		"{Datei} existiert bereits"	;	"{Fichier} existe dj"
T_ERILCH:	.ASCIZ		"Illegaler Kanal"		;	"Canal incorrect"      
T_ERFUSE:	.ASCIZ		"{Datei} im Gebrauch"		;	"{Fichier} utilis"
T_ERFNOP:	.ASCIZ		"Nicht geffnete {Datei}"	;	"{Fichier} dj ferm"
T_ERUNNI:	.ASCIZ		"{Einheit} nicht initialisiert"	;	"Unit pas initialise"
T_ERUUSE:	.ASCIZ		"Einheit {} im Gebrauch"	;	"Unit utilise"
T_ERUTYP:	.ASCIZ		"Illegaler Einheitstype"	;	"Type d'unit incorrect"
T_ERDDNE:	.ASCIZ		"{Directory} exisitiert nicht"	;	"Dossier {?} n'existe pas"
T_ERITYP:	.ASCIZ							"Type d'installation incorrect"
T_ERNREL:	.ASCIZ							"RELEASE pas fait"
T_ERNENT:	.ASCIZ							"ENTER fait par un autre programme"
T_ERFILG:	.ASCIZ							"{Fichier} trop court!"
T_ERXCHANGE:	.ASCIZ		"Disquette sortie du lecteur"

T_ERFULL:	.ASCIZ		"Voll"				;	"Plein"
T_ERDKFU:	.ASCIZ		"Disk voll"			;	"Disque plein"
.if	0
T_ERFTFU:	.ASCIZ		"Zu viele offene Dateien"	;	"Trop de fichiers disques ouverts"
T_ERSTFU:	.ASCIZ		"Zu viele lokale Dateien offen"	;	"Trop de fichiers locaux ouverts"
T_ERLIFU:	.ASCIZ		"Zu viele Zuweisungen"		;	"Trop d'assignations"
T_ERTPFU:	.ASCIZ		"Zu viele bentzte Driver"	;	"Trop de drivers utiliss"
T_ERPMFU:	.ASCIZ		"Zu viele ausgefhrte Programme";	"Trop de programmes excuts"
T_ERUTFU:
T_ERDTFU:	.ASCIZ							"Trop de dossiers initialiss"
T_ERVTFU:	.ASCIZ							"Trop d'installations virtuelles"
T_ERNTFU:	.ASCIZ							"Trop de fichiers rseau ouverts"
.endif
T_ERBUFU:	.ASCIZ							"Buffer d'analyse plein"
T_ERMSFU:	.ASCIZ							"Mmoire du serveur pleine"

T_ERATT:	.ASCIZ		"Geschtzte {Datei}"		;	"{Fichier} protg"
T_ERATTE:	.ASCIZ		"Exklusives Oeffnen geschtzt"	;	"Ouverture exclusive impossible"
T_ERATTM:	.ASCIZ		"Mehrfach Oeffnen geschtzt"	;	"Ouverture multiple impossible"
T_ERATTR:	.ASCIZ		"Lesen geschtzt"		;	"Lecture impossible"
T_ERATTW:	.ASCIZ		"Schreiben geschtzt"		;	"Ecriture impossible"
T_ERATTY:	.ASCIZ		"Zurcksetzen geschtzt"	;	"Fermeture impossible"
T_ERATTS:	.ASCIZ		"Spos geschtzt"		;	"Spos impossible"
T_ERATTG:	.ASCIZ		"Gpos geschtzt"		;	"Gpos impossible"
T_ERATTD:	.ASCIZ		"Delete geschtzt {}"		;	"{Fichier} indestructible"
T_ERATTC:	.ASCIZ		"Rename geschtzt"		;	"Changement de nom impossible"
T_ERATTA:	.ASCIZ		"Chatr geschtzt"		;	"Changement des attributs impossible"
T_ERATTZ:	.ASCIZ		"Clear geschtzt"		;	"Remise  zro impossible"
T_ERATTX:	.ASCIZ		"{} Lgo geschtzt"		;	"{Fichier} pas excutable"
T_ERATTN:	.ASCIZ							"{} accs rseau protg"
T_ERFCODE:	.ASCIZ							"{Fichier} verrouill"
T_ERNSUNI:	.ASCIZ							"?MOVE impossible"

T_ERBINA:	.ASCIZ		"Inkorrekter Binrkode"		;	"Binaire incorrect"
T_ERBICHK:	.ASCIZ							"Somme de contrle incorrecte"
T_ERBNRE:	.ASCIZ							"Binaire non relogeable"

T_ERPSYN:
T_ERLSYN:
T_ERSYNT:	.ASCIZ		"Syntaxfehler"			;	"Syntaxe incorrecte"
T_ERILUN:	.ASCIZ		"Illegale Einheit"		;	"Unit incorrecte"
T_ERTOLO:	.ASCIZ		"Name zu lang"			;	"Nom trop long"
T_ERFFIL:
T_ERTOCO:	.ASCIZ		"Name nicht gefunden"		;	"Nom inexistant"
T_ERILCA:	.ASCIZ		"Illegales Zeichen"		;	"Caractre illgal"
T_ERILAT:	.ASCIZ		"Illegales Attribut"		;	"Attribut illgal"
T_ERUCALL:	.ASCIZ							"RCVNET serveur trop ancien !"
T_ERNSERV:	.ASCIZ							"Station distante non serveur"
T_ERBLOQ:	.ASCIZ							"Machine arrte"
.if		COMPLET
T_ERNSAD:	.ASCIZ		"Keine Startaddresse"		;	"Pas d'adresse de start"
T_ERILAD:	.ASCIZ		"Illegale Adresse"		;	"Adresse incorrecte"
T_ERNOHD:	.ASCIZ							"entte binaire pas en mmoire"
T_EREXLO:	.ASCIZ							"Extension trop longue"
T_ERIFNR:
T_ERNOOP:	.ASCIZ							"Plus d'option"
T_ERLDIMA:	.ASCIZ							"Image gnrique charge"
.endif


T_ERGESM:	.ASCIZ		"Speicherfehler"		;	"Problme mmoire"
T_ERMHKO:	.ASCIZ		"Speicher fehlerhaft"		;	"Mmoire dfectueuse"

T_ERIMEP:	.ASCIZ		"Illegale Speicherparameter"	;	"Paramtre mmoire illgal"

T_ERMELG:	.ASCIZ		"Illegale Speicherlnge"	;	"Longueur mmoire fausse"

T_ERMFUL:	.ASCIZ		"Speicher voll"			;	"Mmoire pleine"

.if		COMPLET
T_ERMEMKO:	.ASCIZ		"Speicherchip defekt"		;	"Circuit mmoire dfectueux"

T_ERMCTYP:	.ASCIZ		"Inkorrekte Speicherzuweisung"	;	"Entit mmoire incorrecte"
T_ERIPRS:	.ASCIZ		"Speicherforderung zu hoch"	;	"Fraction mmoire trop grande"
T_ERILIMI:	.ASCIZ		"Illegale Speichergrenze"	;	"Limite mmoire incorrecte"
T_ERIADR:	.ASCIZ		"Illegale Speicheradresse"	;	"Adresse mmoire incorrecte"
T_ERPTMEM:	.ASCIZ		"Illegaler Speicherzeiger"	;	"Pointeur mmoire incorrect"
T_ERMPTYP:	.ASCIZ							"Type processus interdit"

T_ERNLEN:	.ASCIZ		"Speicherlnge null"		;	"Longueur mmoire nulle"

T_ERNEMEM:	.ASCIZ		"Speicher nicht ausreichend"	;	"Pas assez de mmoire"
T_ERMOCC:	.ASCIZ		"Besetzter Speicher"		;	"Mmoire dj occupe"
.endif


T_ERBIOS:	.ASCIZ		"BIOS-Fehler"			;	"Problme BIOS"
T_ERIDP:	.ASCIZ		"Illegale Parameter"		;	"Paramtre illgal"
T_ERIRDL:
T_ERIRLG:	.ASCIZ		"Illegale Lnge"		;	"Longueur illgale"

T_ERDPR:	.ASCIZ		"Geschtzter Driver"		;	"Driver protg"
T_ERRDPR:	.ASCIZ		"Driver read geschtzt"		;	"Driver protg en lecture"
T_ERWRPR:	.ASCIZ		"Driver write geschtzt"	;	"Driver protg en criture"
T_ERKLPR:	.ASCIZ							"Driver indestructible"

T_ERDNTF:	.ASCIZ		"Unbekannter Driver"		;	"Driver introuvable"
T_ERIDEV:	.ASCIZ		"Unbekannte Drivernummer"	;		"Numro de driver inconnu"
T_ERINAM:	.ASCIZ		"Unbekannter Drivername"	;		"Nom de driver inconnu"

T_ERDOP:	.ASCIZ		"Open Fehler"			;	"Problme d'ouverture"
T_EROPMX:	.ASCIZ		"Zu viele geffnete Driver"	;	"Trop de drivers ouverts"
T_ERAOPE:
T_ERALOP:	.ASCIZ		"Driver {} bereits geffnet"	;	"Driver dj ouvert"
T_ERNOTO:	.ASCIZ		"Driver nicht offen"		;	"Driver pas ouvert"
T_ERUNCO:	.ASCIZ							"{Unit} pas connecte"

T_ERHEAD:	.ASCIZ		"Illegaler Driver-Header"	;	"Entte de driver incorrecte"
T_ERTRSTO:
T_ERTRAV:	.ASCIZ							"Transfert stopp"
T_ERTERM:	.ASCIZ		"Schlusszeichen gefunden"	;	"Terminateur rencontr"
T_ERDEOF:	.ASCIZ							"Fin de fichier driver"

T_ERCOMA:
T_ERILLO:	.ASCIZ		"Illegaler Befehl"		;	"Commande incorrecte"
T_ERTYPC:	.ASCIZ							"Type de driver incorrect"
T_ERCRED:	.ASCIZ		"Create Fehler"			;	"Problme de cration"
T_ERNDEV:	.ASCIZ		"Driver bereits installiert"	;	"Driver dj install"
T_ERHREAD:	.ASCIZ							"Problme de lecture hard"
T_ERHWRITE:	.ASCIZ							"Problme d'criture hard"

.if		COMPLET
T_ERDHAI:	.ASCIZ		"Ungerade Basisadresse"		;	"Adresse de base impaire"
T_ERDHIO:	.ASCIZ		"Illegaler Offset"		;	"Offset incorrect"
T_ERDHIN:	.ASCIZ		"Illegale Nummer"		;	"Numro incorrect"
T_ERDHIT:	.ASCIZ		"Illegaler Name"		;	"Nom incorrect"
.endif



T_ERNTREL:	.ASCIZ		"Real-Time Fehler"		;	"Problme temps rel"
T_ERNTLI:
.if		COMPLET
		.ASCIZ		"Real-Time Grenze erreicht"	;	"Limite temps rel atteinte"
.endif
T_ERTIMO:	.ASCIZ		"Zeit abgelaufen"		;	"Temps dpass"
T_ERINTP:	.ASCIZ		"Illegale Parameter"		;	"Paramtre incorrect"
T_ERILPT:	.ASCIZ		"Illegaler Zeiger"		;	"Pointeur incorrect"
T_ERPRIO:	.ASCIZ		"Illegale Prioritt"		;	"Priorit incorrecte"
T_ERMINU:	.ASCIZ		"Illegaler Semaphore"		;	"Smaphore incorrect"

T_ERINTO:	.ASCIZ		"Illegales Objekt"		;	"Objet incorrect"

T_ERNOOB:	.ASCIZ							"Objet concern inexistant"

T_ERLIMA:	.ASCIZ							"Limite impose atteinte"

.if		COMPLET
T_ERILMO:	.ASCIZ							"Mode incorrect"

T_ERNORA:	.ASCIZ							"Demande d'accs pas faite"
T_ERNCHI:	.ASCIZ							"Pas une descendance"

T_ERNOIS:	.ASCIZ							"Pas de processus dans smaphore"
T_ERFPOS:	.ASCIZ							"Pas de processus pre"
T_ERPNIS:	.ASCIZ							"Processus pas dans smaphore"
T_ERPNIA:	.ASCIZ							"Processus pas dans l'arbitre"
T_ERPNIB:	.ASCIZ							"Processus pas dans la BAL"

T_ERVEOV:	.ASCIZ							"Limite max de var E atteinte"
T_ERLGTS:	.ASCIZ							"Longueur de buffer donn trop petite"
.endif




T_ERMM:		.ASCIZ		"{} Massenspeicherfehler"	;	"Problme avec la mmoire de masse"
T_ERMFUNC:	.ASCIZ		"{} Strungs Fehler"		;	"Fonctionnement incorrect"
T_ERMDISK:	.ASCIZ		"Verwendungs Fehler {}"		;	"Unit absente"
T_ERMOFF:	.ASCIZ		"Ausserhalb Massenspeicher {}"	;	"Unit inactive"
T_ERMRDY:	.ASCIZ		"Lesefehler {}"			;	"Unit non prte"

T_ERMUSE:	.ASCIZ							"{} Problme d'utilisation"
T_ERMOUT:	.ASCIZ							"{} Accs hors de la mmoire de masse"
T_ERMWRK:	.ASCIZ							"Unit {} occupe"
T_ERCHMM:
T_ERMDSK:	.ASCIZ							"{} Changement de disquette"
T_ERMNORD:	.ASCIZ							"{} Lecture interdite"
T_ERMNPA:	.ASCIZ							"{} Partition inconnue"
T_ERMPNI:	.ASCIZ							"{} Paramtres pas initialiss"

T_ERMREAD:	.ASCIZ		"{} Lesefehler"			;	"{} Lecture du disque impossible"

T_ERMWRITE:	.ASCIZ		"{} Schreibfehler"		;	"Ecriture sur disque impossible"

T_ERMRFI:
T_ERMWFI:	.ASCIZ							"{} Format incompatible"
T_ERMWPR:	.ASCIZ		"{} Schreibgeschtzt"		;	"Unit protge en criture"
T_ERMWFO:	.ASCIZ							"Formatage incorrect"

.if		COMPLET
T_ERMRDP:	.ASCIZ		"{} Illegale Spur"		;	"Piste incorrecte en lecture"
T_ERMRDS:	.ASCIZ		"{} Illegaler Sektor"		;	"Secteur incorrect en lecture"
T_ERMRDA:	.ASCIZ		"{} Datenfehler"		;	"Problme de data en lecture"
T_ERMRCK:	.ASCIZ		"{} Checksum-Fehler"		;	"Problme de check-sum en lecture"
T_ERMWDP:	.ASCIZ		"{} Illegale Spur"		;	"Piste incorrecte en criture"
T_ERMWDS:	.ASCIZ		"{} Illegaler Sektor"		;	"Secteur incorrect en criture"
T_ERMRNF:
T_ERMWNF:	.ASCIZ							"{} Non format"
T_ERMWDA:	.ASCIZ		"{} Datenfehler"		;	"Problme de data en criture"
T_ERMWCK:	.ASCIZ		"{} Checksum-Fehler"		;	"Problme de check-sum en criture"
.endif



T_ERLIB:	.ASCIZ							"Problme avec la librairie"
T_ERLFUL:	.ASCIZ							"Librairie trop utilise"
T_ERLNOP:	.ASCIZ							"Librairie pas ouverte"
T_ERLNWD:	.ASCIZ							"Fentre pas utilise"
T_ERLNKY:	.ASCIZ							"Clavier pas utilis"
T_ERLBFU:	.ASCIZ							"Buffer plein"
T_ERLWFU:	.ASCIZ							"Trop de sous-fentres"
T_ERLWUS:	.ASCIZ							"Sous-fentre utilise"
T_ERLWNI:	.ASCIZ							"Sous-fentre inconnue"
T_ERLMFU:	.ASCIZ							"Trop de modules"
T_ERLMNO:	.ASCIZ							"Module pas ouvert"


T_ERDIS:	.ASCIZ							"Problme dans une fentre"
T_ERDIIL:	.ASCIZ							"Caractre ou commande inconnu"
T_ERDIOUT:	.ASCIZ							"Dbordement de la fentre"
T_ERDIROL:	.ASCIZ							"Dcalage de la fentre effectu"
T_ERDIGC:	.ASCIZ							"Gnrateur {de caractres} inexistant"
T_ERDINO:	.ASCIZ							"Plus de fentre approprie"

T_ERDIMA:	.ASCIZ							"Codage d'image incorrect"
T_ERDIND:	.ASCIZ							"Image non dcodable"

.if		COMPLET
T_ERDINC:	.ASCIZ							"Image non codable"
T_ERDIDC:	.ASCIZ							"Image dj code"
T_ERDIDD:	.ASCIZ							"Image non code"
T_ERDIBUF:	.ASCIZ							"Chevauchement de zones"
.endif

T_ERKEY:	.ASCIZ							"Problme avec le clavier"
T_ERKYIL:	.ASCIZ							"Numro de clavier inconnu"
T_ERKYIN:	.ASCIZ							"Clavier inexistant"
T_ERKYAA:	.ASCIZ							"Touche dj assigne"
T_ERKYNA:	.ASCIZ							"Touche pas assigne"
T_ERKYTA:	.ASCIZ							"Trop d'assignations de touches"
T_ERKYFU:	.ASCIZ							"Trop de touches presses"



T_ERPRIN:	.ASCIZ							"Vrifier l'imprimante"
T_ERPCTL:	.ASCIZ							"Commande trop longue"
T_ERPCUK:	.ASCIZ							"Commande inconnue"
T_ERPCIC:	.ASCIZ							"Commande incorrecte"
T_ERPNPR:	.ASCIZ							"Arguments non admis"
T_ERPMPR:	.ASCIZ							"Argument manquant"
T_ERPIWD:	.ASCIZ							"Fentre inexistante"
T_ERPIIL:	.ASCIZ							"Interligne illgal"
T_ERPSTO:	.ASCIZ							"Impression stoppe"


T_ERNETW:	.ASCIZ							"Problme sur le rseau"
T_ERNILP:	.ASCIZ							"Paramtre incorrect"
T_ERNISL:	.ASCIZ							"Longueur segment invalide"
T_ERNPNR:	.ASCIZ							"Port de {destination} pas prt"

T_ERNSTL:	.ASCIZ							"Segment dest. trop petit"
T_ERNHRD:	.ASCIZ							"Problme hardware"
T_ERNHAB:	.ASCIZ							"Hardware absent"
T_ERNHNQ:	.ASCIZ							"Station {?} inexistante"
T_8960:
T_ERNABO:	.ASCIZ							"Transfert avort"

T_ERNMPF:	.ASCIZ							"Plus assez de port"
T_ERNMPS:	.ASCIZ							"Port dj occup"
T_ERNMPC:	.ASCIZ							"Port dj libr"
T_8980:		.ASCIZ							"Receive bad station {}"

.if		COMPLET
T_ERNIPO:	.ASCIZ							"Port inexistant"
T_ERNIAD:	.ASCIZ							"Adresse invalide"
T_ERNISN:	.ASCIZ							"Nombre de segments invalide"
T_ERNISP:	.ASCIZ							"Paramtres exp. incorrects"
T_ERNIPD:	.ASCIZ							"Description paquet incorrect"
T_ERNPWN:	.ASCIZ							"Port dest. n'attend rien"
T_ERNPIA:	.ASCIZ							"Port dest. inactif"
T_ERNPWO:	.ASCIZ							"Port dest. attend autre exp."
T_ERNPNS:	.ASCIZ							"Port dest. pas assez segment"
T_ERNBLO:	.ASCIZ							"Manque un bloc"

T_ERNHMI:	.ASCIZ							"Problme hardware"

T_ERNPEM:	.ASCIZ							"La file du port est vide"
T_ERNPFU:	.ASCIZ							"La file du port est pleine"
T_ERNPUS:	.ASCIZ							"Un port est en utilisation"
T_8981:		.ASCIZ							"Receive bad port"
T_8982:		.ASCIZ							"Receive bad bloc"
T_8983:		.ASCIZ							"Receive bad regnration number"
T_8984:		.ASCIZ							"Receive bad Message number"
T_8985:		.ASCIZ							"Receive bad entte"
T_8986:		.ASCIZ							"Send impossible"
.endif


T_ERCDEF:	.ASCIZ							"Chane de dfinition illgale"
T_ERCLAB2:	.ASCIZ							"Label inexistant"
T_ERCLAB1:	.ASCIZ							"Label dj dfini"
T_ERCLABI:	.ASCIZ							"Label illgal"
T_ERCIF:	.ASCIZ							"Trop de .IF.."
T_ERCMAC:	.ASCIZ							"Valable uniquement en macro"


; SCSI ->

T_8400:		.ASCIZ					"Recovered Error"
T_8410:		.ASCIZ					"Not Ready"
T_8420:		.ASCIZ					"Medium Error"
T_8430:		.ASCIZ					"Hardware Error"
T_8440:		.ASCIZ					"Data Buffer Check"
T_8441:		.ASCIZ					"REQ/ACK Check"
T_8442:		.ASCIZ					"Spin Stability Check"
T_8450:		.ASCIZ					"Illegal Request"
T_8460:		.ASCIZ					"Unit Attention"
T_8470:		.ASCIZ					"Data Protect"
T_8480:		.ASCIZ					"Aborted Command"
T_8490:		.ASCIZ					"Miscompare"

.if		COMPLET
T_8401:		.ASCIZ					"Recovered Read data with drive's Read retries"
T_8402:		.ASCIZ					"Recovered Read data with drive's ECC correction"
T_8403:		.ASCIZ					"Correctable ECC error,  number of bits correctable: 0"
T_8404:		.ASCIZ					"Correctable ECC error,  number of bits correctable: 1"
T_8405:		.ASCIZ					"Correctable ECC error,  number of bits correctable: 2"
T_8406:		.ASCIZ					"Correctable ECC error,  number of bits correctable: 3"
T_8407:		.ASCIZ					"Correctable ECC error,  number of bits correctable: 4"
T_8408:		.ASCIZ					"Correctable ECC error,  number of bits correctable: 5"
T_8409:		.ASCIZ					"Correctable ECC error,  number of bits correctable: 6"
T_840A:		.ASCIZ					"Correctable ECC error,  number of bits correctable: 7"
T_840B:		.ASCIZ					"Correctable ECC error,  number of bits correctable: 8"
T_840C:		.ASCIZ					"Correctable ECC error,  number of bits correctable: 9"
T_840D:		.ASCIZ					"Correctable ECC error,  number of bits correctable: 10"
T_840E:		.ASCIZ					"Correctable ECC error,  number of bits correctable: 11"

T_8411:		.ASCIZ					"Drive Not Ready"
T_8412:		.ASCIZ					"Drive Not Selected"

T_8421:		.ASCIZ					"Unrecovered Read error of data blocks"
T_8422:		.ASCIZ					"No Addres Mark found in ID field"
T_8423:		.ASCIZ					"No Adress Mark Found in Data field"
T_8424:		.ASCIZ					"No record found"
T_8425:		.ASCIZ					"Seek Error"
T_8426:		.ASCIZ					"Recovered Data Adress Mark"
T_8427:		.ASCIZ					"Defect List Error"
T_8428:		.ASCIZ					"Primary Defect List not found"
T_8429:		.ASCIZ					"Format Failed"
T_842A:		.ASCIZ					"No Defect Spare Location Available"

T_8431:		.ASCIZ					"No Index / Sector signal"
T_8432:		.ASCIZ					"No Seek Complete"
T_8433:		.ASCIZ					"Write Fault"
T_8434:		.ASCIZ					"No track zero found"
T_8435:		.ASCIZ					"Multiple Drive Selected"
T_8436:		.ASCIZ					"ID CRC or ECC error"
T_8437:		.ASCIZ					"Seek Error"
T_8438:		.ASCIZ					"RAM failure"
T_8439:		.ASCIZ					"ECC diagnostic failure"
T_843A:		.ASCIZ					"Power On Failure"
T_843B:		.ASCIZ					"Message Reject Error"
T_843C:		.ASCIZ					"SCSI Hardware/Firmware Error"
T_843D:		.ASCIZ					"Select/Reselect failed"
T_843E:		.ASCIZ					"Adaptec AIC 010 Failure"
T_843F:		.ASCIZ					"Checksum Check"

T_8443:		.ASCIZ					"L.T. 3600 RPM"
T_8444:		.ASCIZ					"Spin Check"
T_8445:		.ASCIZ					"0.05% Spin Check"
T_8446:		.ASCIZ					"Unable to Cover Rezero Sensor"
T_8447:		.ASCIZ					"Unable to Uncover Rezero Sensor"
T_8448:		.ASCIZ					"Track 0 Misadjust Error"
T_8449:		.ASCIZ					"Crash Stop Check Error"
T_844A:		.ASCIZ					"No Hall Transition Check Error"
T_844B:		.ASCIZ					"Unexpected Interrupt"

T_8451:		.ASCIZ					"Parameter Overrun"
T_8452:		.ASCIZ					"Invalid Command Operation Code"
T_8453:		.ASCIZ					"Invalid Logical Block Adress"
T_8454:		.ASCIZ					"Illgal function for device type"
T_8455:		.ASCIZ					"Illegal field in CDB"
T_8456:		.ASCIZ					"Invalid LUN"
T_8457:		.ASCIZ					"Invalid field Parameter List"
.endif

; Ressources ->

T_ERrsIL:	.asciz		"illegal..."
.if	COMPLET
T_ERrsILMOD:	.asciz		"illegal mode"
T_ERrsILNUM:	.asciz		"illegal ressource number"
T_ERrsILTYP:	.asciz		"illegal ressource type"
T_ERrsILKND:	.asciz		"illegal ressource kind"
T_ERrsILSIZ:	.asciz		"illegal ressource size"
T_ERrsILLAB:	.asciz		"illegal ressource label"
T_ERrsILSUBR:	.asciz		"illegal subressource"
T_ERrsILCAN:	.asciz		"illegal channel"
T_ERrsILCTR:	.asciz		"illegal control command"
T_ERrsILKEY:	.asciz		"illegal key"
T_ERrsILOP:	.asciz		"illegal operation"
T_ERrsILFSTO:	.asciz		"illegal format de stockage"
.endif

T_ERrsFILE:	.asciz		"file ERror..."
T_ERrsREV:	.asciz		"revision incompatibility"
T_ERrsNOSUBR:	.asciz		"no subressources implemented"
T_ERrsNORES:	.asciz		"no ressources in RS file"
T_ERrsNORESCODE:.asciz		"no ressources in CODE file"
T_ERrsBADFILE:	.asciz		"bad ressource file"

T_ERrsMISC:	.asciz		"miscellanous error..."
.if	COMPLET
T_ERrsSYSTO:	.asciz		"system too old"
T_ERrsKILLED:	.asciz		"entity killed"
T_ERrsTYPAE:	.asciz		"type already exists"
T_ERrsTOOMGIV:	.asciz		"too many RES_GIVE"
T_ERrsUSED:	.asciz		"ressource already used"
.endif

T_ERrsEXEC:	.asciz		"execution error..."
.if	COMPLET
T_ERrsBADHARDW:	.asciz		"bad hardware"
T_ERrsCALLDNE:	.asciz		"call does not exist"
T_ERrsDECACHE:	.asciz		"decache not possible"
.endif

T_B000:		.ASCIZ		"Simulateur dfectueux"
T_B001:		.ASCIZ		"Simulateur absent"
T_B002:		.ASCIZ		"Machine non supporte"



.endif		; allemand

 	.END
